

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddResultSet.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddResultSet.sp,v $ $Id: sp_dm2_AddResultSet.sp,v 1.8.12.7 2019/03/15 16:57:32 anguyen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_AddResultSet')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_AddResultSet <<<'
	drop procedure sp_dm2_AddResultSet
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddResultSet')
	delete from GxQscripts where name = 'sp_dm2_AddResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddResultSet'
GO
print '... Creating Procedure: sp_dm2_AddResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddResultSet
  @i_inputXML VARCHAR(MAX),
  @i_ContainerID VARCHAR(36) = '',
  @i_userGuid VARCHAR(36) =  '',
  @i_attribute INTEGER = 0,
  @i_restoreCCN INTEGER = 0,
  @i_restoreTime VARCHAR(50) = ''
AS
SET NOCOUNT ON
   /**
      *
                  Usage:
                                    This will be called when the download request comes for an item from outlook
                                    If entry not found
                                          Insert a new row in DMResultSet,DMResultSetInfo and DMContainerItem.
                                    Else
                                          Update the DMResultSet/DMContainerInfo table accordingly
                  Input -->
                        @i_inputXML = XMl structure of GResultItem
                        @i_ContainerID = ContainerGuid to which it needs to be inserted
                                                (if not provided DMContainerItem table entry will not be inserted)
                        @i_userGuid = which user invokes this sp
                        @i_attribute = attribute to be set in DMContainerItem
                        @i_restoreCCN = CommCell number to which it will be restored (by default it is 0)
                        @i_restoreTime = if this field is not empty update DMResultSEt with the input restore details
                                                            (restoreJobId, destPath,restoreStatus,restoreTime)
                  OutPut -->
                        @o_ResultSetId = returns the ResultSetId of the inserted items.
                                                On Any failure returns empty value
      *
      **/
BEGIN
      DECLARE @o_ResultSetId VARCHAR(36) = ''
	  DECLARE @Mark_Email_Restore_To_Xml  INTEGER = 1024 -- this is use to filter out all emails which are restored in .xml format. Those restored emails can have same Commcell Number, aFileID, and aFileOffset but the restored file is in .xml format. That .xml format is specifically used for Outlook client to generate email preview with attachments in native format
      IF(LEN(ISNULL(@i_inputXML,'')) = 0)
            GOTO CX_EXIT
      --Local Variable
      DECLARE @commcellNo     INTEGER = 0,
                  @aFileId    INTEGER = 0,
                  @aFileOffset      BIGINT = 0,
                  @inputXML   XML = @i_inputXML,
                  @attibute   INTEGER = 0,
				  @turboGuid VARCHAR(128) = '',
				  @documentId VARCHAR(256) = ''
      SELECT            @commcellNo = ISNULL(T.item.value('@commcellNo', 'INTEGER'),0),
                        @aFileId = ISNULL(T.item.value('@aFileId', 'INTEGER'),0),
                        @aFileOffset = ISNULL(T.item.value('@aFileOffset', 'BIGINT'),0),
						@turboGuid = ISNULL(T.item.value('@turboGuid', 'VARCHAR(128)'), ''),
						@documentId = ISNULL(T.item.value('@documentId', 'VARCHAR(256)'), '')
      FROM  @inputXML.nodes('DM2ContentIndexing_GResultItem') T(item)
	  create table #tmpDMResultSet
		(
			[aFileLength] [bigint],
			[AppType] [int],
			[FileSizeKB] [float],
			[ModifiedTime] [datetime],
			[JobId] [int],
			[OriginalFullPath] [nvarchar](max),
			[ClientID] [int],
			[RestoreStatus] [int],
			[DestinationPath] [nvarchar](max),
			[AppId]	[int]
		)
		INSERT INTO #tmpDMResultSet
			SELECT
					ISNULL(T.item.value('@aFileLength', 'BIGINT'),0),
					ISNULL(T.item.value('@appType', 'INTEGER'),0),
					ISNULL(T.item.value('@sizeKB', 'FLOAT'),0),
					dbo.GetDateTime(ISNULL(T.item.value('@modifiedTime', 'BIGINT'),0)),
					ISNULL(T.item.value('@jobId', 'INTEGER'),0),
					CASE WHEN ISNULL(T.item.value('@filePath', 'NVARCHAR(max)'),'') <> '' THEN dbo.DecodeInvalidXMLCharsManaged(T.item.value('@filePath', 'NVARCHAR(max)')) ELSE '' END,
                    ISNULL(T.item.value('@clientId', 'INTEGER'),0),
					ISNULL(T.item.value('@restoreStatus', 'INTEGER'),0),
					ISNULL(T.item.value('./metaData[1]/@destinationPath', 'NVARCHAR(MAX)'),''),
					ISNULL(T.item.value('@appId', 'INTEGER'),0)
			FROM  @inputXML.nodes('DM2ContentIndexing_GResultItem') T(item)
		------------+++++++++Begin Transaction+++++++++------------
		DECLARE @result INT
		DECLARE @outResult INT
		DECLARE @errMsg NVARCHAR(MAX)
		BEGIN TRY
		BEGIN TRAN
		--Add lock so that we dont insert duplicate entries in DMResultSet table (when parallel execution happens)
			EXEC @result = sp_getapplock @Resource = 'sp_dm2_AddResultSet', @LockMode = 'Exclusive', @LockTimeout = 60000
			IF @result < 0
			BEGIN
                SET @errMsg = CASE @result
										when -1 then 'Explicit Raise Error: Applock request timed out.'
										when -2 then 'Applock request canceled.'
										when -3 then 'Explicit Raise Error: Applock involved in deadlock'
										else 'Parameter validation or other call error.'
									end
                RAISERROR (@errMsg,16,1)
				GOTO CX_EXIT
			END
		--first check if we can match item by turboguid if value is given in input
		IF ISNULL(@turboGuid,'') <> ''
		BEGIN
			SELECT TOP 1 @o_ResultSetId  = ResultSetID, @attibute = Attribute
			FROM  DMResultSet
			WHERE IndexGUID = @turboGuid
		END
		--can't find by turboguid, now try by ccn,afid,afof if afileid information is available
		IF ISNULL(@o_ResultSetId,'') = '' and @aFileId > 0
		BEGIN
	        SELECT TOP 1 @o_ResultSetId  = ResultSetID, @attibute = Attribute
			FROM  DMResultSet
			WHERE CommCellNumber = @commcellNo AND  aFileID = @aFileId AND aFileOffset = @aFileOffset AND Attribute <> @Mark_Email_Restore_To_Xml -- -- D.Attribute <> @Mark_Email_Restore_To_Xml is used to filter out all emails which are restored in .xml format. Those restored emails can have same Commcell Number, aFileID, and aFileOffset but the restored file is in .xml format. That .xml format is specifically used for Outlook client to generate email preview with attachments in native format. Recall is not required for that specific type of preview so this change won't affect it.
		END
        IF(LEN(ISNULL(@o_ResultSetId,'')) = 0)
			BEGIN
            ----Assign new ResultSetId
            SET @o_ResultSetId = LOWER(NEWID()) -- Because c# generates lower case GUIDs and just to keep it consistent with respect to that.
            --Insert entry to DMResultSet
            INSERT INTO DMResultSet
				(   ResultSetID,CommCellNumber,
                    aFileID,aFileOffset,
                    aFileLength,AppType,
                    FileSizeKB,ModifiedTime,
                    JobId,OriginalFullPath,
                    DestinationPath,CreateTime,
                    RestoreUserGUID,RestoreCommCellNumber,
                    RestoreJobID,RestoreStatus,
                    RestoreTime,Attribute,
                    documentID,ClientID,ERMStatus,
				    IndexGUID,AppId)
                SELECT  @o_ResultSetId, @commcellNo,
                        @aFileId,@aFileOffset,
						TMP.aFileLength,
						TMP.AppType,
						TMP.FileSizeKB,
						TMP.ModifiedTime,
						TMP.JobId,TMP.OriginalFullPath,
						'',getDate(),
						@i_userGuid,@i_restoreCCN,
						0,TMP.RestoreStatus,
						getDate(),0,
                        @documentId,TMP.ClientID,
 						0,@turboGuid, TMP.AppId
                FROM  #tmpDMResultSet TMP
                IF (@@ERROR <> 0)
                    GOTO CX_EXIT
            END
            ELSE
            BEGIN
                --if the input restoreTime field is not empty
                --update dmresultset table
                IF(LEN(ISNULL(@i_restoreTime,''))>0)
                BEGIN
                    UPDATE DMResultSet
                    SET RestoreTime = CONVERT(DATETIME,@i_restoreTime),
                    RestoreStatus = (CASE TMP.RestoreStatus
                                        WHEN 0      THEN DMResultSet.RestoreStatus
                                        ELSE TMP.RestoreStatus
                                        END
                                    ),
                    FileSizeKB  =   (CASE TMP.FileSizeKB
										WHEN 0      THEN DMResultSet.FileSizeKB
                                        ELSE TMP.FileSizeKB
                                        END
                                    ),
                    DestinationPath = (CASE LEN(TMP.DestinationPath)
                                        WHEN 0      THEN DMResultSet.DestinationPath
                                        ELSE dbo.DecodeInvalidXMLCharsManaged(TMP.DestinationPath)
                                        END
                                    )
					FROM  #tmpDMResultSet TMP
                    WHERE ResultSetID = @o_ResultSetId
                IF (@@ERROR <> 0)
                    GOTO CX_EXIT
				END
				------CASE where the ResultSetItem is marked for deletion
				IF ((@attibute & 4) = 4)
				BEGIN
					UPDATE DMResultSet
					SET Attribute = (Attribute & ~4)
					WHERE ResultSetID = @o_ResultSetId
				IF (@@ERROR <> 0)
					GOTO CX_EXIT
                END
			END
        --insert into DMcontainerItem, if input has valid ContainerGuid
        IF(LEN(ISNULL(@i_ContainerID,''))>0 AND
            NOT EXISTS (SELECT ResultSetID
                        FROM  DMContainerItem         WITH (READUNCOMMITTED)
                        WHERE ContainerID = @i_ContainerID
                        AND   ResultSetID = @o_ResultSetId ))
        BEGIN
            INSERT INTO DMContainerItem (ContainerID,QueryID,ResultSetID,CreateTime,Attribute,UserGUID)
            VALUES (@i_ContainerID, '', @o_ResultSetId, getUTCDate(), @i_attribute, @i_UserGUID)
            IF (@@ERROR <> 0)
                GOTO CX_EXIT
        END
      ------------+++++++++Commit Transaction+++++++++------------
	  --this will release the applock
      COMMIT TRAN
	  END TRY
	  BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		if @@TRANCOUNT > 0
			ROLLBACK TRANSACTION
		SELECT @errMsg = ERROR_MESSAGE()
		RAISERROR(@errMsg, 15, 50)
	  END CATCH
CX_EXIT:
      IF(XACT_STATE() <> 0)
      BEGIN
            SET @o_ResultSetId = ''
            ------------+++++++++Rollback Transaction+++++++++------------
            ROLLBACK TRAN;
            PRINT 'Transcation Rollbacked due to Error'
      END
	IF OBJECT_ID('tempdb.dbo.#tmpDMResultSet') IS NOT NULL
	DROP TABLE #tmpDMResultSet
    SELECT @o_ResultSetId
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddResultSet')
	delete from GxQscripts where name = 'sp_dm2_AddResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddResultSet',  '00010008001200070000', 'sp_dm2_AddResultSet', '00010008001200070000')
GO

