

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddItemsToSyncWithIndexing.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_AddItemsToSyncWithIndexing()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddItemsToSyncWithIndexing.sp,v $ $Id: sp_dm2_AddItemsToSyncWithIndexing.sp,v 1.5.178.1 2016/11/01 21:09:14 rkulkarni Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddItemsToSyncWithIndexing <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddItemsToSyncWithIndexing')
	drop procedure sp_dm2_AddItemsToSyncWithIndexing
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_AddItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddItemsToSyncWithIndexing'
GO
print '... Creating Procedure: sp_dm2_AddItemsToSyncWithIndexing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddItemsToSyncWithIndexing
  @ItemsToSync AS DMItemsToSyncWithIndexingTypeV2 READONLY 
AS
BEGIN
CREATE TABLE #DMItemsToSyncWithIndexingType
(
	ItemID					int identity(1,1),
	aFileID					bigint,
	aFileOffset				bigint,
	CommCellNumber   		int,
	OriginalFullPath 		nvarchar(4000),
	IndexGUID				varchar(128),
	SyncStatus				int,
	idxAFileId				bigint,
	idxAFileOffset			bigint,
	idxCommCellNumber		int null,
	ResultSetID				char(36) null
)
--
/*
 Merge in T-SQL fails if there are duplicates based on which condition we are matching with main table and hence we use Partition and Rank technique
 In this stored procedure we only care about following SyncStatus records
 SyncStatus = 0 --> inserted state before lookup started.
 SyncStatus = 1 --> lookup succeeded
 SyncStatus = 2 --> lookup failed
 --
 Following type of records never inserted or updated from here. They are always saved from sp_dm2_AddResultSetBulk stored procedure alone:
 SyncStatus = 4 --> item is duplicate at source (search or review set engine) and is dropped when saving to dmresultset. These rows are
					used for sake of mapping an item while restore status of an item is updated
*/
--
INSERT INTO #DMItemsToSyncWithIndexingType (aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber, ResultSetID)
SELECT aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber, ResultSetID
FROM @ItemsToSync
MERGE DMItemsToSyncWithIndexing AS A
USING (SELECT *, RANK() OVER(PARTITION BY aFileID, aFileOffset, CommCellNumber ORDER BY ItemID) ItemRank FROM #DMItemsToSyncWithIndexingType) AS T
ON (A.aFileID = T.aFileID AND A.aFileOffset = T.aFileOffset AND A.CommCellNumber = T.CommCellNumber AND a.SyncStatus IN (0, 1, 2) AND T.ItemRank = 1)
WHEN NOT MATCHED THEN
	INSERT (aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber, ResultSetID, IndexSyncTime)
	VALUES (T.aFileID, T.aFileOffset, T.CommCellNumber, T.OriginalFullPath, T.IndexGUID, T.SyncStatus, T.idxAFileId, T.idxAFileOffset, T.idxCommCellNumber, T.ResultSetID, GetDate())
WHEN MATCHED THEN
UPDATE SET idxaFileId = T.idxaFileId,
idxaFileOffset = T.idxaFileOffset,
idxCommCellNumber = T.idxCommCellNumber,
IndexSyncTime = GetDate(),
SyncStatus = T.SyncStatus,
OriginalFullPath = T.OriginalFullPath
;
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_AddItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddItemsToSyncWithIndexing'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddItemsToSyncWithIndexing',  '00010005017800010000', 'sp_dm2_AddItemsToSyncWithIndexing', '00010005017800010000')
GO

