

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddCommand.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddCommand.sp,v $ $Id: sp_dm2_AddCommand.sp,v 1.1.2.7 2017/02/10 19:16:39 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddCommand <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddCommand')
	drop procedure sp_dm2_AddCommand
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddCommand')
	delete from GxQscripts where name = 'sp_dm2_AddCommand'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddCommand')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddCommand'
GO
print '... Creating Procedure: sp_dm2_AddCommand'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddCommand
  @i_xml xml,
  @i_user char(36), -- user guid of current logged in user
  @o_errCode INT OUTPUT,
  @o_errMsg NVARCHAR(MAX) OUTPUT,
  @o_commandId INT OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @cmdName nvarchar(max) = ''
	SELECT  @cmdName = T.c.value('@name', 'nvarchar(max)'),
			@o_commandId = ISNULL(T.c.value('@cmdid', 'INT'),0)
		FROM @i_xml.nodes('/DM2ContentIndexing_DM2CmdInsertReq/basicInfo') T(c)
	DECLARE @defaultGuid char(36) = (select cast(cast(0 as binary) as uniqueidentifier) )
	------------------------------  validation of parameters --------------------------------------
	IF ( ISNULL(@cmdName,'') = '' )
	BEGIN
		SELECT @o_errCode = 11710,
				@o_errMsg = 'Invalid command Name'
		GOTO _EXIT;
	END
	IF ( LEN(@cmdName) > 255 )
	BEGIN
		SELECT @o_errCode = 11713,
				@o_errMsg = 'Command Name exceed allowable limit of 256 characters'
		GOTO _EXIT;
	END
	IF ( EXISTS ( Select TOP 1 Name from DMCmd WITH (NOLOCK) where Name=@cmdName AND CommandId<>@o_commandId) )
	BEGIN
		SELECT @o_errCode = 11711,
				@o_errMsg = 'Command with name already exists'
		GOTO _EXIT;
	END
	IF ( @o_commandId <> 0 AND NOT EXISTS ( SELECT CommandId from DMCmd WITH (NOLOCK) where CommandId=@o_commandId  ) )
	BEGIN
		SELECT @o_errCode=11703,
				@o_errMsg='CommandId doesnt exists'
		GOTO _EXIT;
	END
	-- first insert only new actions into table based on XML index, then insert actions which are already present
	-- this will then be updated with new action IDs generated after inserting into CommandAction table
	CREATE TABLE #tmpActionDefn ( Idx INT  , CmdId INT, CommandActionId INT, ActionId INT NOT NULL, PId INT, pguid char(36) NULL, pvalue nvarchar(max) )
	INSERT INTO #tmpActionDefn
				SELECT
					DENSE_RANK() OVER (ORDER BY c) AS idx,
					@o_commandId,
					ISNULL(T.c.value('@aid', 'INT' ),0) ,
					T.c.value('@actionId', 'INT' ) ,
					ISNULL(P.x.value('@paramid', 'INT'),0) ,
					P.x.value('@paramGuid', 'char(36)') ,
					ISNULL(P.x.value('(valueMap[1]/@value)', 'nvarchar(max)'),'')
				from @i_xml.nodes('/DM2ContentIndexing_DM2CmdInsertReq/actions') AS T(c)
				OUTER APPLY c.nodes('paramValues') AS P(x)
				where ISNULL(T.c.value('@aid', 'INT' ),0)   = 0
	DECLARE @c INT = 0
	SET @c = (SELECT COUNT(*) from #tmpActionDefn)
	INSERT INTO #tmpActionDefn
				SELECT
					@c+1,
					@o_commandId,
					ISNULL(T.c.value('@aid', 'INT' ),0),
					T.c.value('@actionId', 'INT' ) ,
					ISNULL(P.x.value('@paramid', 'INT'),0) ,
					P.x.value('@paramGuid', 'char(36)'),
					ISNULL(P.x.value('(valueMap[1]/@value)', 'nvarchar(max)'),'')
				from @i_xml.nodes('/DM2ContentIndexing_DM2CmdInsertReq/actions') AS T(c)
				OUTER APPLY c.nodes('paramValues') AS P(x)
				where ISNULL(T.c.value('@aid', 'INT' ),0)   != 0
	-- validate actions and parameters
	-- validate action Id
	IF( EXISTS (SELECT ActionId from #tmpActionDefn  WITH (NOLOCK)
					EXCEPT
					SELECT Id FROM DMSearchCriteriaGroup WITH (NOLOCK) WHERE
							BitVisibility = ( Select BinaryWeightage from DMSearchView  WITH (NOLOCK) where ViewName = 'OutlookContentStoreCommands')
				)
	  )
	BEGIN
		SELECT @o_errCode = 11700,
				@o_errMsg = 'Input Action is not valid. ActionID '
		GOTO _EXIT;
	END
	-- valdidate parameters
	IF( EXISTS (Select pguid, ActionId from #tmpActionDefn  WITH (NOLOCK) where ISNULL(pguid,'') <> ''
					EXCEPT
					SELECT DISTINCT Id, GroupId FROM DMSearchCriteriaField   as DF WITH (NOLOCK)
				)
	  )
	BEGIN
		SELECT @o_errCode = 11701,
				@o_errMsg = 'Invalid Parameter  '
		GOTO _EXIT;
	END
	IF( EXISTS (Select pguid, ActionId from #tmpActionDefn T  WITH (NOLOCK)
					INNER JOIN DMSearchCriteriaField as DF  WITH (NOLOCK)
					on T.ActionId = DF.GroupId where ISNULL(pguid,'') = ''
					EXCEPT
					SELECT DISTINCT Id, GroupId FROM DMSearchCriteriaField as DF WITH (NOLOCK) INNER JOIN #tmpActionDefn T on T.ActionId = DF.GroupId
				)
   	  )
	BEGIN
		SELECT @o_errCode = 11702,
				@o_errMsg = 'Mandatory parameters missing '
		GOTO _EXIT;
	END
	---------------------- validation done -----------------------------
	BEGIN TRY
	BEGIN TRAN
	-- -update table
	--update DMCmd table
		MERGE INTO DMCmd As Trg
			Using ( select  @cmdName as Name,
					@o_commandId as Id,
					ISNULL(T.c.value('@desc', 'nvarchar(max)'),'') as descr,
					T.c.value('@clientType', 'INT') as type,
					ISNULL(T.c.value('@attribute', 'INT'),0) as attr,
					ISNULL(T.c.value('@status', 'INT'),0) as stat,
					ISNULL(T.c.value('@retentionPeriod', 'INT'),7) as reten,
					ISNULL(T.c.value('@taskId', 'INT'), 0) as taskId
					from @i_xml.nodes('/DM2ContentIndexing_DM2CmdInsertReq/basicInfo') T(c)
				) as Src
			ON Trg.CommandId = Src.Id
			When MATCHED
			THEN
				UPDATE SET
					@o_commandId = Trg.CommandId,
					Trg.Name = Src.Name,
					Trg.Description = Src.descr,
					Trg.ClientType = Src.type,
					Trg.Attribute=Src.attr,
					Trg.Status = Src.stat,
					Trg.Retention = Src.reten,
					Trg.taskId = Src.taskId,
					ModifiedTime = GETUTCDATE(),
					ModifiedBy = @i_user
			WHEN NOT MATCHED
			THEN
				INSERT
					(Name,
					Description,
					ClientType,
					Attribute,
					Status,
					Retention,
					CreateTime,
					ModifiedTime,
					CreatedBy,
					ModifiedBy)
				VALUES (
					Src.Name,
					Src.descr,
					Src.type,
					Src.attr,
					Src.stat,
					Src.reten,
					GETUTCDATE(),
					GETUTCDATE(),
					@i_user,
					@i_user);
		SET @o_commandId = CASE WHEN ISNULL(@o_commandId, 0) = 0 THEN SCOPE_IDENTITY() ELSE @o_commandId END
		-- update DMCmdTarget
		MERGE INTO DMCmdTarget As Trg
			Using ( select
				ISNULL(T.c.value('@entityId', 'nvarchar(256)'), @defaultGuid) as ownerguid,
				T.c.value('@entityType', 'INT') as type,
				ISNULL(T.c.value('@attribute', 'INT'),0) as attr,
				@o_commandId as cmdId,
				ISNULL(T.c.value('@targetid', 'INT'),0) as targetId
				from @i_xml.nodes('/DM2ContentIndexing_DM2CmdInsertReq/users') T(c)
			) as Src
			ON Trg.TargetId = Src.targetId
			When MATCHED AND Trg.CommandId = @o_commandId
			THEN
				UPDATE SET
					Trg.EntityId = Src.ownerguid,
					Trg.EntityType = Src.type,
					Trg.Attribute = Src.attr
			WHEN NOT MATCHED AND Src.targetId = 0
			THEN
				INSERT
					(CommandId,
					 EntityId,
					 EntityType,
					 Attribute)
				VALUES
					( @o_commandId,
					Src.ownerguid,
					Src.type,
					Src.attr)
			WHEN NOT MATCHED BY SOURCE  AND Trg.CommandId = @o_commandId
			THEN
				DELETE;
		-- update DMCmdAction
		-- we perform merge as 2 seaprate actions as we want newly insrted action Ids in temp table
		CREATE TABLE #tmpAction ( Id INT IDENTITY(1,1) , CommandActionId INT)
		MERGE INTO DMCmdAction As Trg
			Using (
					SELECT @o_commandId as cmdId,
						ISNULL(T.c.value('@aid', 'INT'),0) as aid,
						T.c.value('@actionId', 'INT') as actionId,
						ISNULL(T.c.value('@attribute', 'INT'),0) as attr
					from @i_xml.nodes('/DM2ContentIndexing_DM2CmdInsertReq/actions') T(c)
				) as Src
			ON Trg.CommandActionId = Src.aid
			When MATCHED AND Trg.CommandId = @o_commandId
			THEN
				UPDATE SET
					Trg.ActionId = Src.actionId,
					Trg.Attribute = Src.attr
			WHEN NOT MATCHED BY SOURCE  AND Trg.CommandId = @o_commandId
			THEN
				DELETE;
		MERGE INTO DMCmdAction As Trg
			Using (
					SELECT @o_commandId as cmdId,
						ISNULL(T.c.value('@aid', 'INT'),0) as aid,
						T.c.value('@actionId', 'INT') as actionId,
						ISNULL(T.c.value('@attribute', 'INT'),0) as attr
						from @i_xml.nodes('/DM2ContentIndexing_DM2CmdInsertReq/actions') T(c)
				) as Src
			ON  Trg.CommandActionId = Src.aid
			WHEN NOT MATCHED AND Src.aid = 0
			THEN
				INSERT
					(CommandId,
					ActionId,
					Attribute
					)
				VALUES
					( @o_commandId,
					Src.actionId,
					Src.attr
					)
			OUTPUT INSERTED.CommandActionId into #tmpAction ;
		UPDATE #tmpActionDefn SET CommandActionId = TMP.CommandActionId FROM #tmpAction TMP where TMP.Id = idx
		-------------------- update Parameters ------------------------------
		MERGE INTO DMCmdParams As Trg
			Using (
					SELECT
						TMP.CmdId as cmdId,
						TMP.CommandActionId as aId,
						TMP.PId as pid,
						TMP.pguid as pguid,
						TMP.pvalue as value
						from #tmpActionDefn TMP  WITH (NOLOCK)
				)  as Src
			ON Trg.ParamId = Src.pid
			When MATCHED
			THEN
				UPDATE SET
					Trg.CommandActionId = Src.aid,
					Trg.ParamGuid = Src.pguid,
					Trg.ParamValue = Src.value,
					Trg.SavedTime = GETUTCDATE()
			WHEN NOT MATCHED AND Src.pid = 0 AND ISNULL(Src.pguid,'') <> ''
			THEN
				INSERT
					(CommandActionId,
					ParamGuid,
					ParamValue,
					SavedTime)
				VALUES
					( Src.aId,
					Src.pguid,
					Src.value,
					GETUTCDATE())
			WHEN NOT MATCHED BY SOURCE AND Trg.CommandActionId in ( select CommandActionId from #tmpActionDefn  WITH (NOLOCK) )
			THEN
				DELETE;
	COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF @@TRANCOUNT > 0 AND XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
		SELECT @o_errMsg = ERROR_MESSAGE(), @o_errCode = ERROR_NUMBER()
	END CATCH
 _EXIT:
	IF object_id('tempdb.dbo.#tmpAction') IS NOT NULL
		DROP TABLE #tmpAction
	IF object_id('tempdb.dbo.#tmpActionDefn') IS NOT NULL
		DROP TABLE #tmpActionDefn
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddCommand')
	delete from GxQscripts where name = 'sp_dm2_AddCommand'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddCommand')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddCommand'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddCommand',  '00010001000200070000', 'sp_dm2_AddCommand', '00010001000200070000')
GO

