SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/CV_GetSpParams.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/CV_GetSpParams.sp,v $ $Id: CV_GetSpParams.sp,v 1.2 2010/03/17 15:29:53 ylu Exp $";
--  +========================================================================+
--  | Stored Precedure: CV_GetSpParams()
--  | Description:  Return list of parameters and their data type for sp
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_GetSpParams <<<'

IF EXISTS (select * from sysobjects where name='CV_GetSpParams')
	drop procedure CV_GetSpParams
IF EXISTS (select * from GxQscripts where name='CV_GetSpParams')
	delete from GxQscripts where name = 'CV_GetSpParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSpParams')
	delete from GXDBVersions where aliasname = 'CV_GetSpParams'
GO
print '... Creating Procedure: CV_GetSpParams'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure CV_GetSpParams
  @i_sp_name VARCHAR(1024)
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ParamTbl TABLE (Parameter VARCHAR(64), Type VARCHAR(128))
	INSERT INTO @ParamTbl
    SELECT
        [Param] = COALESCE(PARAMETER_NAME, '<no params>'),
        [DataType] = COALESCE(UPPER(DATA_TYPE) + CASE
            WHEN DATA_TYPE IN ('NUMERIC', 'DECIMAL') THEN
                '(' + CAST(NUMERIC_PRECISION AS VARCHAR)
                + ', ' + CAST(NUMERIC_SCALE AS VARCHAR) + ')'
            WHEN RIGHT(DATA_TYPE, 4) = 'CHAR' THEN (CASE WHEN CHARACTER_MAXIMUM_LENGTH = -1 THEN '(MAX)' ELSE
                '(' + CAST(CHARACTER_MAXIMUM_LENGTH AS VARCHAR) + ')' END)
            ELSE '' END + CASE PARAMETER_MODE
            WHEN 'INOUT' THEN ' OUTPUT' ELSE ' ' END, '-')
    FROM INFORMATION_SCHEMA.PARAMETERS
    WHERE SPECIFIC_NAME = @i_sp_name
    ORDER BY ORDINAL_POSITION
    SELECT * FROM @ParamTbl
GO

IF EXISTS (select * from GxQscripts where name = 'CV_GetSpParams')
	delete from GxQscripts where name = 'CV_GetSpParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_GetSpParams')
	delete from GXDBVersions where aliasname = 'CV_GetSpParams'
GO

insert into GXDBVersions values(2, 'CV_GetSpParams',  '00010002000000000000', 'CV_GetSpParams', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_GetQscriptInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_GetQscriptInfo.sp,v $ $Id: QS_GetQscriptInfo.sp,v 1.6 2010/05/04 20:48:16 ylu Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetQscriptInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_GetQscriptInfo')
	drop procedure QS_GetQscriptInfo
IF EXISTS (select * from GxQscripts where name='QS_GetQscriptInfo')
	delete from GxQscripts where name = 'QS_GetQscriptInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptInfo')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptInfo'
GO
print '... Creating Procedure: QS_GetQscriptInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetQscriptInfo
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_name varchar(1024)=''
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @tblQscriptList TABLE
	(
		QscriptName varchar(64),
		AuditLevel	int,
		TimeCreated	datetime,
		TimeExpires	datetime
	)
	INSERT INTO @tblQscriptList
	SELECT name, auditLevel, timeCreated, timeExpires
	FROM GxQscripts
	WHERE  name not like '%_CVupdate_%'
	AND   ( @i_name = '' OR
			name like @i_name OR
			name like 'QS_' + @i_name )
	IF @@ROWCOUNT = 0
	BEGIN
		SET @localErrorMsg = 'Error: Qscript not found!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	SELECT * FROM @tblQscriptList
	ORDER BY QscriptName, TimeCreated desc
ARGS_ERROR:
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetQscriptInfo')
	delete from GxQscripts where name = 'QS_GetQscriptInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptInfo')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptInfo'
GO

insert into GXDBVersions values(2, 'QS_GetQscriptInfo',  '00010006000000000000', 'QS_GetQscriptInfo', '00010006000000000000')
GO

insert into GxQscripts values(2,'QS_GetQscriptInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn getQscriptInfo -si @i_name=''script_name''
'
 + CHAR(10) + '	qoperation execscript -sn getQscriptInfo -si ''script_name''
'
 + CHAR(10) + '-- 	script_name: Full script name or name with wild card ''%''. If no name is inputed, then all scripts will be returned.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_GetQscriptExec.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_GetQscriptExec.sp,v $ $Id: QS_GetQscriptExec.sp,v 1.6 2010/05/04 20:46:24 ylu Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetQscriptExec <<<'

IF EXISTS (select * from sysobjects where name='QS_GetQscriptExec')
	drop procedure QS_GetQscriptExec
IF EXISTS (select * from GxQscripts where name='QS_GetQscriptExec')
	delete from GxQscripts where name = 'QS_GetQscriptExec'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptExec')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptExec'
GO
print '... Creating Procedure: QS_GetQscriptExec'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetQscriptExec
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_name varchar(1024)='',
  @i_from varchar(1024)='',
  @i_to varchar(1024)='',
  @i_status int = 0
AS
Set NOCOUNT ON
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	IF @i_status not in (0, 1, 2)
	BEGIN
		SET @localErrorMsg = 'Error: Invalid status!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	DECLARE @tblQscriptList TABLE
	(
		QscriptName varchar(64),
		TimeStart	datetime,
		TimeEnd		datetime,
		Status		int,
		InputParams	varchar(max)
	)
	INSERT INTO @tblQscriptList
	SELECT 	name, timeStart, timeEnd, status, inputParams
	FROM GxQscriptExec
	WHERE (name = @i_name OR name = 'QS_' + @i_name)
	AND (@i_status = 0 OR status = @i_status)
	AND (@i_from = '' OR timeStart > @i_from) AND (@i_to = '' OR timeEnd < @i_to)
	IF @@ROWCOUNT = 0
	BEGIN
		SET @localErrorMsg = 'Error: No execution record found!'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
	SELECT * FROM @tblQscriptList
	ORDER BY QscriptName, TimeStart desc
ARGS_ERROR:
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetQscriptExec')
	delete from GxQscripts where name = 'QS_GetQscriptExec'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetQscriptExec')
	delete from GXDBVersions where aliasname = 'QS_GetQscriptExec'
GO

insert into GXDBVersions values(2, 'QS_GetQscriptExec',  '00010006000000000000', 'QS_GetQscriptExec', '00010006000000000000')
GO

insert into GxQscripts values(2,'QS_GetQscriptExec',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn getQscriptExec -si @i_name=''script_name'' -si @i_from=''from_time'' -si @i_to=''to_time'' -si @i_status=''exec_status''
'
 + CHAR(10) + '	qoperation execscript -sn getQscriptExec -si ''script_name'' -si ''from_time'' -si ''to_time'' -si ''exec_status''
'
 + CHAR(10) + '-- 	script_name: full script name.'
 + CHAR(10) + '-- 	from_time: SQL datetime. For example ''01/01/2010''. Ignored if not given.'
 + CHAR(10) + '-- 	to_time: SQL datetime. For example ''06/01/2010''. Ignored if not given.'
 + CHAR(10) + '-- 	exec_status: 1 for successful execution, 2 for failed execution. 0 for all status.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/cvsp_drop_pk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/cvsp_drop_pk.sp,v $ $Id: cvsp_drop_pk.sp,v 1.1 2008/09/29 17:03:08 hkapadia Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_drop_pk()
--  |
--  | Description:  First drop all foreign keys referenced to the primary key
--  |				of the given table then drop the primary key
--  |
--  |       Input:  tblName
--	|
--  |      Output:  error code
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_drop_pk <<<'

IF EXISTS (select * from sysobjects where name='cvsp_drop_pk')
	drop procedure cvsp_drop_pk
IF EXISTS (select * from GxQscripts where name='cvsp_drop_pk')
	delete from GxQscripts where name = 'cvsp_drop_pk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_pk')
	delete from GXDBVersions where aliasname = 'cvsp_drop_pk'
GO
print '... Creating Procedure: cvsp_drop_pk'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_drop_pk
  @tblName varchar(40)
AS
DECLARE	@fkTable	varchar (40)
DECLARE @keyName	varchar (255)
DECLARE @execString	nvarchar(255)
DECLARE @errCode    int
SET	@errCode = 0
DECLARE fkCursor CURSOR FOR
	SELECT	DISTINCT object_name(constid), object_name(fkeyid)
	FROM	sysforeignkeys
	WHERE	rkeyid = object_id(@tblName)
OPEN	fkCursor
FETCH	NEXT FROM fkCursor INTO @keyName, @fkTable
WHILE	@@FETCH_STATUS = 0
BEGIN
		SET	@execString = 'ALTER TABLE ' + @fkTable +' DROP CONSTRAINT ' + @keyName
		EXEC sp_executesql @execString
		SET	@errCode = @@error
		IF	@errCode <> 0
			BREAK
		FETCH NEXT FROM fkCursor INTO @keyName, @fkTable
END
CLOSE		fkCursor
DEALLOCATE	fkCursor
IF	@errCode <> 0
	return @errCode
SELECT @keyName = name FROM sysobjects WHERE parent_obj = object_id(@tblName) AND xtype = 'PK'
IF (@keyName IS NOT null)
BEGIN
	SET @execString = 'ALTER TABLE ' + @tblName +' DROP CONSTRAINT ' + @keyName
	EXEC sp_executesql @execString
END
RETURN @errCode
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_drop_pk')
	delete from GxQscripts where name = 'cvsp_drop_pk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_pk')
	delete from GXDBVersions where aliasname = 'cvsp_drop_pk'
GO

insert into GXDBVersions values(2, 'cvsp_drop_pk',  '00010001000000000000', 'cvsp_drop_pk', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/cvsp_drop_fkeys.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/cvsp_drop_fkeys.sp,v $ $Id: cvsp_drop_fkeys.sp,v 1.1 2008/09/29 17:03:08 hkapadia Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_drop_fkeys()
--  |
--  | Description:  Stored procedure to drop table foreign key
--  |
--  |       Input:  fromTable, fromColumn, ToTable
--	|
--  |      Output:  error code
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_drop_fkeys <<<'

IF EXISTS (select * from sysobjects where name='cvsp_drop_fkeys')
	drop procedure cvsp_drop_fkeys
IF EXISTS (select * from GxQscripts where name='cvsp_drop_fkeys')
	delete from GxQscripts where name = 'cvsp_drop_fkeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_fkeys')
	delete from GXDBVersions where aliasname = 'cvsp_drop_fkeys'
GO
print '... Creating Procedure: cvsp_drop_fkeys'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_drop_fkeys
  @fromTable varchar(40),
  @fromColumn varChar(40),
  @ToTable varchar(40)
AS
declare @fkName     varchar (255)
declare @execString nvarchar (255)
declare @errCode    int
set	@errCode = 0
IF object_id('tempdb.dbo.#ffk') is not null DROP TABLE #ffk
CREATE TABLE #ffk
(
	PKTABLE_QUALIFIER		varchar(255),
	PKTABLE_OWNER	varchar(255),
	PKTABLE_NAME	varchar(255),
	PKCOLUMN_NAME	varchar(255),
	FKTABLE_QUALIFIER	varchar(255),
	FKTABLE_OWNER	varchar(255),
	FKTABLE_NAME	varchar(255),
	FKCOLUMN_NAME	varchar(255),
	KEY_SEQ		int,
	UPDATE_RULE	int,
	DELETE_RULE	int,
	FK_NAME	varchar(255),
	PK_NAME	varchar(255),
	DEFERRABILITY	varchar(255)
)
INSERT INTO  #ffk
EXEC  sp_fkeys @fktable_name=@fromTable
DECLARE fkCursor CURSOR FOR
	select distinct  FK_NAME from #ffk
	where PKTABLE_NAME = @ToTable
	AND FKCOLUMN_NAME = @fromColumn
OPEN fkCursor
FETCH	NEXT FROM fkCursor INTO @fkName
WHILE	@@FETCH_STATUS = 0
BEGIN
		--print 'Dropping constraint [' + @fkName + '] from table [' + @fromTable + '] to table [' + @ToTable + '].'
		set @execString = 'alter table ' + @fromTable +' drop ' + @fkName
		exec sp_executesql @execString
		set @errCode = @@error
		IF @errCode <> 0
			break;
		FETCH	NEXT FROM fkCursor INTO @fkName
END
CLOSE fkCursor
DEALLOCATE fkCursor
drop table #ffk
IF @errCode <> 0
	return @errCode
ELSE
	return 0
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_drop_fkeys')
	delete from GxQscripts where name = 'cvsp_drop_fkeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_fkeys')
	delete from GXDBVersions where aliasname = 'cvsp_drop_fkeys'
GO

insert into GXDBVersions values(2, 'cvsp_drop_fkeys',  '00010001000000000000', 'cvsp_drop_fkeys', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/cvsp_enable_trigger.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/cvsp_enable_trigger.sp,v $ $Id: cvsp_enable_trigger.sp,v 1.2 2010/01/25 17:56:32 chandru Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_enable_trigger <<<'

IF EXISTS (select * from sysobjects where name='cvsp_enable_trigger')
	drop procedure cvsp_enable_trigger
IF EXISTS (select * from GxQscripts where name='cvsp_enable_trigger')
	delete from GxQscripts where name = 'cvsp_enable_trigger'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_enable_trigger')
	delete from GXDBVersions where aliasname = 'cvsp_enable_trigger'
GO
print '... Creating Procedure: cvsp_enable_trigger'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_enable_trigger
  @trgName varchar(256)
AS
DECLARE @tblName	varchar(256)
DECLARE @sqlQuery	nvarchar(max)
SELECT	@tblName = name FROM sys.objects WHERE object_id in (SELECT parent_id FROM sys.triggers WHERE name = @trgName)
IF (@tblName IS NOT null)
BEGIN
	SET	@sqlQuery = 'ENABLE TRIGGER [' + @trgName + '] ON ' + @tblName
	EXEC sp_executesql @sqlQuery
END
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_enable_trigger')
	delete from GxQscripts where name = 'cvsp_enable_trigger'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_enable_trigger')
	delete from GXDBVersions where aliasname = 'cvsp_enable_trigger'
GO

insert into GXDBVersions values(2, 'cvsp_enable_trigger',  '00010002000000000000', 'cvsp_enable_trigger', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/cvsp_disable_trigger.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/cvsp_disable_trigger.sp,v $ $Id: cvsp_disable_trigger.sp,v 1.2 2010/01/25 17:56:32 chandru Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_disable_trigger <<<'

IF EXISTS (select * from sysobjects where name='cvsp_disable_trigger')
	drop procedure cvsp_disable_trigger
IF EXISTS (select * from GxQscripts where name='cvsp_disable_trigger')
	delete from GxQscripts where name = 'cvsp_disable_trigger'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_disable_trigger')
	delete from GXDBVersions where aliasname = 'cvsp_disable_trigger'
GO
print '... Creating Procedure: cvsp_disable_trigger'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_disable_trigger
  @trgName varchar(256)
AS
DECLARE @tblName	varchar(256)
DECLARE @sqlQuery	nvarchar(max)
SELECT	@tblName = name FROM sys.objects WHERE object_id in (SELECT parent_id FROM sys.triggers WHERE name = @trgName)
IF (@tblName IS NOT null)
BEGIN
	SET	@sqlQuery = 'DISABLE TRIGGER [' + @trgName + '] ON ' + @tblName
	EXEC sp_executesql @sqlQuery
END
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_disable_trigger')
	delete from GxQscripts where name = 'cvsp_disable_trigger'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_disable_trigger')
	delete from GXDBVersions where aliasname = 'cvsp_disable_trigger'
GO

insert into GXDBVersions values(2, 'cvsp_disable_trigger',  '00010002000000000000', 'cvsp_disable_trigger', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddDownload.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddDownload.sp,v $ $Id: sp_dm2_AddDownload.sp,v 1.8 2012/07/14 22:30:14 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddDownload <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddDownload')
	drop procedure sp_dm2_AddDownload
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddDownload')
	delete from GxQscripts where name = 'sp_dm2_AddDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDownload')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDownload'
GO
print '... Creating Procedure: sp_dm2_AddDownload'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddDownload
  @i_DownLoadID varchar(36) = '' output,
  @i_DestinationPath nvarchar(max) = '',
  @i_Description nvarchar(max) = '',
  @i_FileType int,
  @i_FileSizeKB bigint = 0,
  @i_UserGUID varchar(36),
  @i_ContainerID varchar(36) = '',
  @i_Status int = 0,
  @i_Attribute int = 0,
  @i_RestoreJobID int = 0,
  @i_DownLoadSetID varchar(36)
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode integer
	if not exists (	select * from DMDownload  WITH (READUNCOMMITTED)
					where UserGUID = @i_UserGUID
					and DestinationPath = @i_DestinationPath
					and FileType = @i_FileType
					and (len(@i_ContainerID) = 0 or ContainerID = @i_ContainerID)
					and DownLoadID = @i_DownLoadID)
	begin
		if len(@i_DownLoadID) = 0
		begin
			select @i_DownLoadID = NewID()
		end
		insert into DMDownload (DownLoadID,DestinationPath,Description,FileType,FileSizeKB,UserGUID,ContainerID,Status,Attribute,CreateTime,DownloadTime,RestoreJobID,DownLoadSetID,BatesNumber)
		values (@i_DownloadID, @i_DestinationPath, @i_Description, @i_FileType, @i_FileSizeKB, @i_UserGUID, @i_ContainerID, @i_Status, @i_Attribute, getutcdate(), null, @i_RestoreJobID, @i_DownLoadSetID,'0')
	end
    else
	begin
		set @i_DownLoadID = (	select top 1 DownloadID
							from DMDownload  WITH (READUNCOMMITTED)
							where UserGUID = @i_UserGUID
							and DestinationPath = @i_DestinationPath
							and FileType = @i_FileType
							and (len(@i_ContainerID) = 0 or ContainerID = @i_ContainerID))
		update DMDownload
		set FileSizeKB = @i_FileSizeKB,
			ContainerID = @i_ContainerID,
			Attribute = @i_Attribute
		where DownloadID = @i_DownLoadID
	end
SELECT @errorCode = @@Error
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddDownload')
	delete from GxQscripts where name = 'sp_dm2_AddDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDownload')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDownload'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddDownload',  '00010008000000000000', 'sp_dm2_AddDownload', '00010008000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddDMJob.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddDMJob.sp,v $ $Id: sp_dm2_AddDMJob.sp,v 1.4 2015/07/14 19:34:12 psaoji Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddDMJob <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddDMJob')
	drop procedure sp_dm2_AddDMJob
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddDMJob')
	delete from GxQscripts where name = 'sp_dm2_AddDMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDMJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDMJob'
GO
print '... Creating Procedure: sp_dm2_AddDMJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddDMJob
  @i_JobID varchar(36),
  @i_JobType int,
  @i_JobState int = 0,
  @i_SessionID varchar(24) = '',
  @i_UserGUID varchar(36),
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = '',
  @i_Arguments nvarchar(max) = '',
  @i_Progress int = 0,
  @i_PendingReason nvarchar(max) = '',
  @i_Results nvarchar(max) = '',
  @i_Attribute int = 0
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode integer
if not exists (select * from DMJob WITH (READUNCOMMITTED) where JobID = @i_JobID)
    insert into DMJob
	values (@i_JobID, @i_JobType, @i_JobState, @i_SessionID, @i_UserGUID, @i_ContainerID, @i_ResultSetID, @i_Arguments, @i_Progress, @i_PendingReason, @i_Results, GetUTCDate(), null, @i_Attribute)
SELECT @errorCode = @@Error
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddDMJob')
	delete from GxQscripts where name = 'sp_dm2_AddDMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDMJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDMJob'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddDMJob',  '00010004000000000000', 'sp_dm2_AddDMJob', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddDownloadResultSetBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddDownloadResultSetBulk.sp,v $ $Id: sp_dm2_AddDownloadResultSetBulk.sp,v 1.11 2015/04/16 18:52:49 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddDownloadResultSetBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddDownloadResultSetBulk')
	drop procedure sp_dm2_AddDownloadResultSetBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddDownloadResultSetBulk')
	delete from GxQscripts where name = 'sp_dm2_AddDownloadResultSetBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDownloadResultSetBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDownloadResultSetBulk'
GO
print '... Creating Procedure: sp_dm2_AddDownloadResultSetBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddDownloadResultSetBulk
  @i_DownloadID varchar(36),
  @i_ResultSet xml
-- must be valid xml format, for example:
--    '<ResultSet CommCellNumber="-1" aFileID="123" aFileOffset="123" AppType="1" Status="1" turboGUID="5bcd32a5554da86d32a99da2cac57461"/>
--    <ResultSet CommCellNumber="-1" aFileID="123" aFileOffset="123" AppType="1" Status="1" />
--    <ResultSet CommCellNumber="-1" aFileID="123" aFileOffset="123" AppType="1" Status="1" />'
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode integer
	DECLARE @tblDownloadResultSet TABLE (CommCellNumber int, aFileID bigint, aFileOffset bigint, AppType int, Status int, ResultSetId varchar(36), turboGUID varchar(128))
	DECLARE @DownloadType INT
	SELECT @DownloadType = D.FileType FROM DMDownload D WHERE DownLoadID = @i_DownloadID
	INSERT INTO @tblDownloadResultSet
	SELECT distinct T.c.value('@CommCellNumber','int'),
		   T.c.value('@aFileID', 'bigint'),
	   T.c.value('@aFileOffset', 'bigint'),
		   T.c.value('@AppType', 'int'),
		   T.c.value('@Status', 'int'),
				'',
			T.c.value('@turboGUID', 'VARCHAR(128)')
	FROM   @i_ResultSet.nodes('/ResultSet') T(c)
	UPDATE t SET ResultSetId = RS.ResultSetId
		FROM @tblDownloadResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.turboGUID,'') <> '' AND t.turboGUID = RS.IndexGUID
		--now update only items where resultsetid is not populated
	UPDATE t SET ResultSetId = RS.ResultSetId
		FROM @tblDownloadResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.ResultSetId,'') = '' AND
			t.CommCellNumber = RS.CommCellNumber
			and t.aFileID = RS.aFileID
			and t.aFileOffset = RS.aFileOffset
	DECLARE @tblDMResultSet TABLE (ResultSetId varchar(36), AppType int, [status] int, DestPath nvarchar(max))
	insert into @tblDMResultSet
	select distinct b.resultsetid, a.AppType, a.[Status], ISNULL(b.DestinationPath, '') AS DestPath
	from @tblDownloadResultSet a,  DMResultSet b with (nolock)
	where  a.ResultSetId = b.ResultSetId AND ISNULL(a.ResultSetId,'') <> ''
	 DECLARE @tblDMDownloadResultSet TABLE (ResultSetId varchar(36), DownloadID varchar(36))
	insert into @tblDMDownloadResultSet
	select a.ResultSetId,  DownloadID
	from DMDownloadResultSet a with (nolock), @tblDMResultSet b
	where DownloadID = @i_DownloadID and a.ResultSetId = b.ResultSetId
	--remove duplicate rows
	 DELETE a
	 FROM @tblDMResultSet a, @tblDMDownloadResultSet b
	 WHERE a.ResultSetId = b.ResultSetId
	 insert into DMDownloadResultSet
     select @i_DownloadID, b.ResultSetId, b.AppType,
     (CASE WHEN @DownloadType <> 1 AND DestPath <> '' THEN 100 ELSE  b.[Status] END) AS [Status], getdate(),
     (CASE WHEN @DownloadType <> 1 THEN DestPath ELSE '' END) as [FileName]
     FROM  @tblDMResultSet b
SELECT @errorCode = @@Error
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddDownloadResultSetBulk')
	delete from GxQscripts where name = 'sp_dm2_AddDownloadResultSetBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDownloadResultSetBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDownloadResultSetBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddDownloadResultSetBulk',  '00010011000000000000', 'sp_dm2_AddDownloadResultSetBulk', '00010011000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddDMLegalHoldItemsToBackup.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddDMLegalHoldItemsToBackup.sp,v $ $Id: sp_dm2_AddDMLegalHoldItemsToBackup.sp,v 1.6 2014/07/31 03:55:51 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddDMLegalHoldItemsToBackup <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddDMLegalHoldItemsToBackup')
	drop procedure sp_dm2_AddDMLegalHoldItemsToBackup
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddDMLegalHoldItemsToBackup')
	delete from GxQscripts where name = 'sp_dm2_AddDMLegalHoldItemsToBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDMLegalHoldItemsToBackup')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDMLegalHoldItemsToBackup'
GO
print '... Creating Procedure: sp_dm2_AddDMLegalHoldItemsToBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddDMLegalHoldItemsToBackup
  @i_itemList xml
AS
  DECLARE @o_error integer;
SET NOCOUNT ON
DECLARE @errorCode integer
-- There is problem passing MetaDataXML as part of inputXML and retaining the XML format after inserting into MetaDataXML column.
-- This column will be updated from another stored procedure
	IF object_id('tempdb.dbo.#tmpItemsToBackup') IS NOT NULL
		DROP TABLE #tmpItemsToBackup
	CREATE TABLE #tmpItemsToBackup
	(
		[JobID]	[int] ,
		[CommCellID]	[int] ,
		[CompPolicyID] 	[char](36) ,
		[ContainerID] 	[char](36) ,
		[ResultSetID] 	[char](36) ,
		[OriginalPath] 	[nvarchar](max) ,
		[BackupPath] 	[nvarchar](max) ,
		[MetaDataXML] 	[nvarchar](max) ,
		[BackupStatus]	int,
		[Attribute]	int,
		[AppType] 	[int] ,
		[FileSizeKB]	[bigint]	,
		[ModifiedTime]	datetime ,
		[OriginalFullPath]	[nvarchar](max) ,
		[ClientID]	[int]
	)
	INSERT INTO #tmpItemsToBackup
	SELECT T.item.value('@LegalHoldJobId','int') AS [tJobID],
		   T.item.value('@CommCellId', 'int') AS [tCommCellID],
		   T.item.value('@CompPolicyID', 'char(36)') AS [tCompPolicyID],
		   T.item.value('@ContainerID', 'char(36)'),
		   T.item.value('@ResultSetID', 'char(36)'),
		   T.item.value('@OriginalPath', 'nvarchar(max)') AS [tOriginalPath],
		   T.item.value('@BackupPath', 'nvarchar(max)') AS [tBackupPath],
		   T.item.value('@MetaDataXML', 'nvarchar(max)'),
		   0,
		   0,
		   T.item.value('@AppType', 'int'),
		   T.item.value('@FileSizeKB', 'bigint'),
		   T.item.value('@ModifiedTime', 'datetime'),
		   T.item.value('@OriginalFullPath', 'nvarchar(max)'),
		   T.item.value('@ClientID', 'int')
	FROM   @i_itemList.nodes('/LegalHoldItem') T(item)
	DELETE   #tmpItemsToBackup
	FROM #tmpItemsToBackup AS T
			INNER JOIN
		DMLegalHoldItemsToBackup AS LH WITH (NOLOCK)
	ON LH.JobId = T.JobId AND
		LH.CompPolicyId = T.CompPolicyId AND
		ISNULL(T.ResultSetID,'') = LH.ResultSetID AND
		LH.OriginalPath= T.OriginalPath AND
		LH.BackupPath = T.BackupPath
	INSERT INTO DMLegalHoldItemsToBackup (
			JobId, CommCellId, CompPolicyID, ContainerID, ResultSetID,
			OriginalPath, BackupPath, MetaDataXML, BackupStatus, Attribute,
			AppType, FileSizeKB, ModifiedTime, OriginalFullPath, ClientID)
	SELECT
			T.JobID,T.CommCellID,T.CompPolicyID,T.ContainerID,T.ResultSetID,
			T.OriginalPath,T.BackupPath,T.MetaDataXML,T.BackupStatus,T.Attribute,
			T.AppType,T.FileSizeKB,T.ModifiedTime,T.OriginalFullPath,T.ClientID
	FROM #tmpItemsToBackup AS T
	DROP TABLE #tmpItemsToBackup
SELECT @errorCode = @@Error
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddDMLegalHoldItemsToBackup')
	delete from GxQscripts where name = 'sp_dm2_AddDMLegalHoldItemsToBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDMLegalHoldItemsToBackup')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDMLegalHoldItemsToBackup'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddDMLegalHoldItemsToBackup',  '00010006000000000000', 'sp_dm2_AddDMLegalHoldItemsToBackup', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddQuery.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddQuery.sp,v $ $Id: sp_dm2_AddQuery.sp,v 1.8 2012/04/02 07:26:44 pbuilder Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddQuery <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddQuery')
	drop procedure sp_dm2_AddQuery
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddQuery')
	delete from GxQscripts where name = 'sp_dm2_AddQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddQuery'
GO
print '... Creating Procedure: sp_dm2_AddQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddQuery
  @i_QueryID char(36),
  @i_UserGUID char(36),
  @i_SessionID char(24) = '',
  @i_QueryName nvarchar(1024),
  @i_SearchTerms nvarchar(1024),
  @i_Query nvarchar(max),
  @i_CreateTime datetime,
  @i_Attribute int = 0,
  @i_Comments nvarchar(max),
  @i_CommentsTime datetime,
  @i_QuerySummary nvarchar(max),
  @i_CommServContainerGuid char(36),
  @i_TotalHits int = null
AS
  DECLARE @o_errorCode integer;
IF @i_QueryName IS NULL
	SET @i_QueryName = ''
IF @i_SearchTerms IS NULL
	SET @i_SearchTerms = ''
IF @i_Comments IS NULL
	SET @i_Comments = ''
IF @i_QuerySummary IS NULL
	SET @i_QuerySummary = ''
SET NOCOUNT ON
DECLARE @errorCode integer
insert into DMQuery (QueryID, UserGUID, SessionID, QueryName, SearchTerms, Query, CreateTime, Attribute, Comments, CommentsTime, QuerySummary, CommServContainerGuid, TotalHits)
values (@i_QueryID, @i_UserGUID, @i_SessionID, @i_QueryName, @i_SearchTerms, @i_Query, GetUTCDate(), @i_Attribute, @i_Comments, GetUTCDate(), @i_QuerySummary, @i_CommServContainerGuid, @i_TotalHits)
SELECT @errorCode = @@Error
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddQuery')
	delete from GxQscripts where name = 'sp_dm2_AddQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddQuery'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddQuery',  '00010008000000000000', 'sp_dm2_AddQuery', '00010008000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddLegalHoldItemsToBackupBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddLegalHoldItemsToBackupBulk.sp,v $ $Id: sp_dm2_AddLegalHoldItemsToBackupBulk.sp,v 1.7 2014/06/24 06:26:37 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddLegalHoldItemsToBackupBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddLegalHoldItemsToBackupBulk')
	drop procedure sp_dm2_AddLegalHoldItemsToBackupBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddLegalHoldItemsToBackupBulk')
	delete from GxQscripts where name = 'sp_dm2_AddLegalHoldItemsToBackupBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddLegalHoldItemsToBackupBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddLegalHoldItemsToBackupBulk'
GO
print '... Creating Procedure: sp_dm2_AddLegalHoldItemsToBackupBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddLegalHoldItemsToBackupBulk
  @i_DataFilePath nvarchar(1024)
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode	 integer;
BEGIN TRY
	DECLARE @l_delimiter	VARCHAR(256)
	DECLARE @l_rowdelimiter VARCHAR(256)
	DECLARE @SQL		VARCHAR(2048)
	SET @l_delimiter = ISNULL((SELECT SettingValue
							FROM DMSetting WITH (READUNCOMMITTED) WHERE settingName = 'DMBulkInsert_Delim'), '')
	IF(LEN(@l_delimiter ) = 0)
	BEGIN
		SET @l_delimiter = 'CV0X12'
		SET @l_rowdelimiter = 'CV0X12RT\n'
	END
	ELSE
	BEGIN
		SET @l_rowdelimiter = @l_delimiter + 'RT\n'
	END
	IF object_id('tempdb.dbo.#tmpItemsToBackup') IS NOT NULL
		DROP TABLE #tmpItemsToBackup
	CREATE TABLE #tmpItemsToBackup
	(
		[JobID] 						[int] 					NOT null,
		[CommCellID] 				[int] 					NOT null,
		[CompPolicyID] 			[char](36) 			NOT null,
		[ContainerID] 			[char](36) 			NOT null,
		[ResultSetID] 			[char](36) 			NOT null,
		[OriginalPath] 			[nvarchar](max) NOT null,
		[BackupPath] 				[nvarchar](max) NOT null,
		[MetaDataXML] 			[nvarchar](max) null,
		[AppType] 					[int] 					null,
		[FileSizeKB]				[bigint] 				null,
		[ModifiedTime]			[int] 					null,
		[OriginalFullPath]	[nvarchar](max) null,
		[ClientID]					[int] 					null,
		[OwnerField]			 	[nvarchar](max) null,
		[FromField]		 	[nvarchar](max) null,
		[FolderPath]	 	[nvarchar](max) null
	)
	SET @SQL = 'BULK INSERT #tmpItemsToBackup FROM '''+@i_DataFilePath+''' WITH (ROWTERMINATOR = '''+@l_rowdelimiter+''', FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
	exec (@SQL)
	CREATE INDEX idx_tmpItemsToBackup
	ON #tmpItemsToBackup (ResultSetID, JobId, CompPolicyId )
	--------+++++++++++ Begin Transaction++++++++++-------------
	BEGIN TRAN
	MERGE DMLegalHoldItemsToBackup AS A
	USING (SELECT * FROM #tmpItemsToBackup)AS T
	ON (A.JobId = T.JobId AND
		A.CompPolicyId = T.CompPolicyId AND
		A.ResultSetID = T.ResultSetID)
	WHEN NOT MATCHED THEN
		INSERT		(JobId,CommCellId,CompPolicyId,
					ContainerID,ResultSetID,OriginalPath,
					BackupPath,MetaDataXML,BackupStatus,
					Attribute,AppType,FileSizeKB,
					ModifiedTime,OriginalFullPath,ClientID,
					OwnerField,FromField,FolderPath
					)
		VALUES    (T.JobID, T.CommCellID, t.CompPolicyID,
					T.ContainerID, T.ResultSetID, T.OriginalPath,
					T.BackupPath, T.MetaDataXML, 0,
					0, T.AppType, T.FileSizeKB,
					dbo.getDateTime(T.ModifiedTime), T.OriginalFullPath, T.ClientID,
					T.OwnerField,T.FromField,T.FolderPath
					)
	WHEN MATCHED AND A.BackupStatus <> 1
	THEN
		UPDATE SET  modifiedTime = dbo.getDateTime(T.ModifiedTime),
					BackupStatus = 0
	;
	--------+++++++++++ Commit Transaction++++++++++-------------
	IF(@@TRANCOUNT > 0)
	BEGIN
		COMMIT TRAN;
	END
CX_EXIT:
	IF object_id('tempdb.dbo.#tmpItemsToBackup') IS NOT NULL
		DROP TABLE #tmpItemsToBackup
	IF (@errorCode != 0)
	BEGIN
		PRINT 'Completed With Error [ '+ 	CONVERT(NVARCHAR(MAX),@errorCode) + ' ]';
		IF(XACT_STATE() <> 0)
		BEGIN
			ROLLBACK TRAN;
			PRINT 'Transcation Rollbacked due to Error'
		END
	END
	ELSE
	BEGIN
		PRINT 'Completed Successfully';
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SELECT @errorCode = ERROR_NUMBER()
	PRINT 'Error Code   : '+ CONVERT(NVARCHAR(MAX),@errorCode  )
    PRINT 'Error Message: '+ ERROR_MESSAGE()
	-- Rollback any active or uncommittable transactions
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRAN;
		PRINT 'Transcation Rollbacked due to Exception'
	END
	IF object_id('tempdb.dbo.#tmpItemsToBackup') IS NOT NULL
		DROP TABLE #tmpItemsToBackup
END CATCH;
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddLegalHoldItemsToBackupBulk')
	delete from GxQscripts where name = 'sp_dm2_AddLegalHoldItemsToBackupBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddLegalHoldItemsToBackupBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddLegalHoldItemsToBackupBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddLegalHoldItemsToBackupBulk',  '00010007000000000000', 'sp_dm2_AddLegalHoldItemsToBackupBulk', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddResultSet.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddResultSet.sp,v $ $Id: sp_dm2_AddResultSet.sp,v 1.8 2015/04/16 18:52:22 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddResultSet <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddResultSet')
	drop procedure sp_dm2_AddResultSet
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddResultSet')
	delete from GxQscripts where name = 'sp_dm2_AddResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddResultSet'
GO
print '... Creating Procedure: sp_dm2_AddResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddResultSet
  @i_inputXML VARCHAR(MAX),
  @i_ContainerID VARCHAR(36) = '',
  @i_userGuid VARCHAR(36) =  '',
  @i_attribute INTEGER = 0,
  @i_restoreCCN INTEGER = 0,
  @i_restoreTime VARCHAR(50) = ''
AS
SET NOCOUNT ON
   /**
      *
                  Usage:
                                    This will be called when the download request comes for an item from outlook
                                    If entry not found
                                          Insert a new row in DMResultSet,DMResultSetInfo and DMContainerItem.
                                    Else
                                          Update the DMResultSet/DMContainerInfo table accordingly
                  Input -->
                        @i_inputXML = XMl structure of GResultItem
                        @i_ContainerID = ContainerGuid to which it needs to be inserted
                                                (if not provided DMContainerItem table entry will not be inserted)
                        @i_userGuid = which user invokes this sp
                        @i_attribute = attribute to be set in DMContainerItem
                        @i_restoreCCN = CommCell number to which it will be restored (by default it is 0)
                        @i_restoreTime = if this field is not empty update DMResultSEt with the input restore details
                                                            (restoreJobId, destPath,restoreStatus,restoreTime)
                  OutPut -->
                        @o_ResultSetId = returns the ResultSetId of the inserted items.
                                                On Any failure returns empty value
      *
      **/
BEGIN
      DECLARE @filePathStr NVARCHAR(MAX)
      DECLARE @emailFromStr NVARCHAR(MAX)
      DECLARE @folderPathStr NVARCHAR(MAX)
      DECLARE @o_ResultSetId VARCHAR(36) = ''
      IF(LEN(ISNULL(@i_inputXML,'')) = 0)
            GOTO CX_EXIT
      --Local Variable
      DECLARE @commcellNo     INTEGER = 0,
                  @aFileId    INTEGER = 0,
                  @aFileOffset      BIGINT = 0,
                  @inputXML   XML = @i_inputXML,
                  @attibute   INTEGER = 0,
				  @turboGuid VARCHAR(128) = ''
      SELECT            @commcellNo = ISNULL(T.item.value('@commcellNo', 'INTEGER'),0),
                        @aFileId = ISNULL(T.item.value('@aFileId', 'INTEGER'),0),
                        @aFileOffset = ISNULL(T.item.value('@aFileOffset', 'BIGINT'),0),
						@turboGuid = ISNULL(T.item.value('@turboGuid', 'VARCHAR(128)'), '')
      FROM  @inputXML.nodes('DM2ContentIndexing_GResultItem') T(item)
	  --first check if we can match item by turboguid if value is given in input
	  IF ISNULL(@turboGuid,'') <> ''
	  BEGIN
		SELECT TOP 1 @o_ResultSetId  = ResultSetID, @attibute = Attribute
		FROM  DMResultSet   WITH (READUNCOMMITTED)
		WHERE IndexGUID = @turboGuid
	  END
	  --can't find by turboguid, now try by ccn,afid,afof if afileid information is available
	  IF ISNULL(@o_ResultSetId,'') = '' and @aFileId > 0
	  BEGIN
	        SELECT TOP 1 @o_ResultSetId  = ResultSetID, @attibute = Attribute
			FROM  DMResultSet   WITH (READUNCOMMITTED)
			WHERE CommCellNumber = @commcellNo AND  aFileID = @aFileId AND aFileOffset = @aFileOffset
	  END
      ------------+++++++++Begin Transaction+++++++++------------
      BEGIN TRAN
            IF(LEN(ISNULL(@o_ResultSetId,'')) = 0)
            BEGIN
                  ----Assign new ResultSetId
                  SET @o_ResultSetId = LOWER(NEWID()) -- Because c# generates lower case GUIDs and just to keep it consistent with respect to that.
                  SELECT @filePathStr = ISNULL(T.item.value('@filePath', 'NVARCHAR(max)'),''),
						@emailFromStr = T.item.value('./appSpecific[1]/eMail[1]/@from','NVARCHAR(max)'),
						@folderPathStr = T.item.value('@folderPath', 'NVARCHAR(max)')
                  FROM  @inputXML.nodes('DM2ContentIndexing_GResultItem') T(item)
                  IF @filePathStr <> ''
					SET @filePathStr = dbo.DecodeInvalidXMLCharsManaged(@filePathStr)
				  IF ISNULL(@emailFromStr, '') <> ''
					SET @emailFromStr = dbo.DecodeInvalidXMLCharsManaged(@emailFromStr)
				  IF ISNULL(@folderPathStr, '') <> ''
					SET @folderPathStr = dbo.DecodeInvalidXMLCharsManaged(@folderPathStr)
                  --Insert entry to DMResultSet
                  INSERT INTO DMResultSet
                        (     ResultSetID,CommCellNumber,
                              aFileID,aFileOffset,
                              aFileLength,AppType,
                              FileSizeKB,ModifiedTime,
                              JobId,OriginalFullPath,
                              DestinationPath,CreateTime,
                              RestoreUserGUID,RestoreCommCellNumber,
                              RestoreJobID,RestoreStatus,
                              RestoreTime,Attribute,
                              documentID,ClientID,ERMStatus,
 							  IndexGUID)
                  SELECT      @o_ResultSetId, @commcellNo,
                              @aFileId,@aFileOffset,
                              ISNULL(T.item.value('@aFileLength', 'BIGINT'),0), ISNULL(T.item.value('@appType', 'INTEGER'),0),
                              ISNULL(T.item.value('@sizeKB', 'FLOAT'),0), dbo.GetDateTime(ISNULL(T.item.value('@modifiedTime', 'BIGINT'),0)),
                              ISNULL(T.item.value('@jobId', 'INTEGER'),0), @filePathStr,
                              '',getDate(),
                              @i_userGuid,@i_restoreCCN,
                              0,3,
                              getDate(),0,
                              '',ISNULL(T.item.value('@clientId', 'INTEGER'),0),
 							  0,@turboGuid
                  FROM  @inputXML.nodes('DM2ContentIndexing_GResultItem') T(item)
                  IF (@@ERROR <> 0)
                        GOTO CX_EXIT
                  INSERT INTO DMResultSetInfo (ResultSetID,ResultSet)
                  VALUES (@o_ResultSetId,@i_inputXML)
                  IF (@@ERROR <> 0)
                        GOTO CX_EXIT
            END
            ELSE
            BEGIN
                        --if the input restoreTime field is not empty
                        --update dmresultset table
                        IF(LEN(ISNULL(@i_restoreTime,''))>0)
                        BEGIN
                              UPDATE DMResultSet
                              SET RestoreTime = CONVERT(DATETIME,@i_restoreTime),
                                    RestoreStatus = (CASE ISNULL(T.item.value('@restoreStatus', 'INTEGER'),0)
                                                                  WHEN 0      THEN RestoreStatus
                                                                  ELSE T.item.value('@restoreStatus', 'INTEGER')
                                                                  END
                                                                  ),
                                    FileSizeKB  = (CASE ISNULL(T.item.value('@sizeKB', 'FLOAT'),0)
                                                                  WHEN 0      THEN FileSizeKB
                                                                  ELSE T.item.value('@sizeKB', 'FLOAT')
                                                                  END
                                                                  ),
                                    DestinationPath = (CASE LEN(ISNULL(T.item.value('./metaData[1]/@destinationPath', 'NVARCHAR(MAX)'),''))
                                                                        WHEN 0      THEN DestinationPath
                                                                        ELSE dbo.DecodeInvalidXMLCharsManaged(T.item.value('./metaData[1]/@destinationPath', 'NVARCHAR(MAX)'))
                                                                        END
                                                                        )
							  FROM  @inputXML.nodes('DM2ContentIndexing_GResultItem') T(item)
                              WHERE ResultSetID = @o_ResultSetId
                              IF (@@ERROR <> 0)
                                    GOTO CX_EXIT
                        END
                        ------CASE where the ResultSetItem is marked for deletion
                        IF ((@attibute & 4) = 4)
                        BEGIN
                              UPDATE DMResultSet
                              SET Attribute = (Attribute & ~4)
                              WHERE ResultSetID = @o_ResultSetId
                              IF (@@ERROR <> 0)
                                    GOTO CX_EXIT
                        END
            END
            --insert into DMcontainerItem, if input has valid ContainerGuid
            IF(LEN(ISNULL(@i_ContainerID,''))>0 AND
                  NOT EXISTS (SELECT ResultSetID
                                                FROM  DMContainerItem         WITH (READUNCOMMITTED)
                                                WHERE ContainerID = @i_ContainerID
                                                      AND   ResultSetID = @o_ResultSetId ))
            BEGIN
                  INSERT INTO DMContainerItem (ContainerID,QueryID,ResultSetID,CreateTime,Attribute,UserGUID)
                  VALUES (@i_ContainerID, '', @o_ResultSetId, getUTCDate(), @i_attribute, @i_UserGUID)
                  IF (@@ERROR <> 0)
                        GOTO CX_EXIT
            END
      ------------+++++++++Commit Transaction+++++++++------------
      COMMIT TRAN
CX_EXIT:
      IF(XACT_STATE() <> 0)
      BEGIN
            SET @o_ResultSetId = ''
            ------------+++++++++Rollback Transaction+++++++++------------
            ROLLBACK TRAN;
            PRINT 'Transcation Rollbacked due to Error'
      END
      SELECT @o_ResultSetId
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddResultSet')
	delete from GxQscripts where name = 'sp_dm2_AddResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddResultSet',  '00010008000000000000', 'sp_dm2_AddResultSet', '00010008000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddResultSetBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddResultSetBulk.sp,v $ $Id: sp_dm2_AddResultSetBulk.sp,v 1.48 2015/05/08 16:11:26 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddResultSetBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddResultSetBulk')
	drop procedure sp_dm2_AddResultSetBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddResultSetBulk')
	delete from GxQscripts where name = 'sp_dm2_AddResultSetBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddResultSetBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddResultSetBulk'
GO
print '... Creating Procedure: sp_dm2_AddResultSetBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddResultSetBulk
  @i_DataFilePath varchar(1024),
  @i_ContainerID varchar(36),
  @i_QueryID varchar(36),
  @i_isCompliancePolicy integer,
  @i_UserGUID varchar(36),
  @o_RowsInserted integer = 0 OUTPUT,
  @o_OutputMessage nvarchar(max) = '' OUTPUT,
  @o_MessageLogLevel INT = 4 OUTPUT
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
		DECLARE @LOG_ERROR INT =  1
		DECLARE @LOG_INFO INT =  2
		DECLARE @LOG_TRACING INT =  3
		DECLARE @LOG_DETAILS INT = 4
		DECLARE @AtLeastOneError BIT = 0
		DECLARE @AtLeastOneInfo BIT = 0
		DECLARE @AtLeastOneTracing BIT = 0
		DECLARE @inputRowCount INTEGER
		DECLARE @uniqueInputRowCount INTEGER
		DECLARE @rowCount INTEGER
		DECLARE @errorCode	INTEGER
		SET		@errorCode	= 0
		declare @l_delimiter	varchar(256)
		declare @SQL	varchar(2048)
		SELECT	@o_OutputMessage = '', @o_MessageLogLevel = 4 --LogLevel.LOG_DETAILS
		set @l_delimiter = ISNULL((select SettingValue from DMSetting WITH (READUNCOMMITTED) where settingName = 'DMBulkInsert_Delim'), '')
		IF(len(@l_delimiter ) = 0)
			SET @l_delimiter = 'CV0X12'
		create table #tmpBulkResultSet
		(
			[ResultSetID] [char](36) NOT null,
			[CommCellNumber] [int] NOT null,
			[aFileID] [bigint] NOT null,
			[aFileOffset] [bigint] NOT null,
			[aFileLength] [bigint] NOT null,
			[AppType] [int] NOT null,
			[FileSizeKB] [float] NOT null,
			[ModifiedTime] [datetime] NOT null,
			[JobId] [int] NOT null,
			[ResultSet] [nvarchar](max) NOT null,
			[OriginalFullPath] [nvarchar](max) NOT null,
			[documentId] [varchar](256) NOT null,
			[ClientID] [int] NOT null,
			[tagGUIDList][varchar](max) null,
			[OwnerField]		[nvarchar](max) null,
			[FromField]		 	[nvarchar](max) null,
			[FolderPath]	 	[nvarchar](max) null,
			[IndexGUID]			[VARCHAR](128) null,
			EmailSubject	NVARCHAR(MAX) null,
			EmailTO			NVARCHAR(MAX) null,
			EmailFROM		NVARCHAR(MAX) null,
			EmailBCC		NVARCHAR(MAX) null,
			EmailCC			NVARCHAR(MAX) null,
			[Title]				[nvarchar](1024) null
		)
		create table #tmpDMResultSet
		(
			[ResultSetID] [char](36) NOT null,
			[CommCellNumber] [int] NOT null,
			[aFileID] [bigint] NOT null,
			[aFileOffset] [bigint] NOT null,
			[aFileLength] [bigint],
			[AppType] [int],
			[FileSizeKB] [float],
			[ModifiedTime] [datetime],
			[JobId] [int],
			[ResultSet] [nvarchar](max),
			[OriginalFullPath] [nvarchar](max),
			[documentId] [varchar](256),
			[ClientID] [int],
			[tagGUIDList][varchar](max),
			[OwnerField]		[nvarchar](max) null,
			[FromField]		 	[nvarchar](max) null,
			[FolderPath]	 	[nvarchar](max) null,
			[IndexGUID]			[VARCHAR](128) null,
			[Title]				[nvarchar](1024) null,
			EmailSubject	NVARCHAR(MAX) null,
			EmailTO			NVARCHAR(MAX) null,
			EmailFROM		NVARCHAR(MAX) null,
			EmailBCC		NVARCHAR(MAX) null,
			EmailCC			NVARCHAR(MAX) null,
			isExistsInDMResultSet	bit default 0,
			idInDMResultSetInfo	INT default 0,
			needaFileIdOrOfffsetUpdate		bit default 0,
			-- Fix for MR 130907 that cause voilation of this primary key constraint when we are updating temporary table.
			-- PRIMARY KEY (CommCellNumber, aFileId, aFileOffset)
		)
		CREATE INDEX tmpDMResultSet_idx_1 ON #tmpDMResultSet(ResultSetId);
		CREATE INDEX tmpDMResultSet_idx_2 ON #tmpDMResultSet(IndexGUID);
		CREATE INDEX tmpDMResultSet_idx_3 ON #tmpDMResultSet(isExistsInDMResultSet);
		-- Primary key is no more enforced on table #tmpDMResultSet and rather for speed lookup, we are having index on CommCellNumber, aFileId, aFileOffset
		CREATE INDEX tmpDMResultSet_idx_4 ON #tmpDMResultSet(CommCellNumber, aFileId, aFileOffset);
		create table #tmpDMUserItemTags
		(
			[ResultSetID] [char](36) NOT null,
			[UserGUID]		[char](36) NOT null,
			[TagGUID]			[char](36) null
		)
		create table #tmpDistinctRS(ResultSetId	[char](36) NOT null, isDMContainerItemExists BIT default 0)
		SET @SQL = 'BULK INSERT #tmpBulkResultSet FROM '''+@i_DataFilePath+''' WITH (FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
		exec (@SQL)
		SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
		SELECT @inputRowCount = @rowCount
		IF @rowCount > 0
		BEGIN
			SELECT @o_OutputMessage = 'Number of input items: [' + convert(varchar, @rowCount) + ']. '
			SELECT @AtLeastOneTracing = 1
		END
		ELSE
		BEGIN
			SELECT @o_OutputMessage = 'No items found in input.'
			SELECT @AtLeastOneError = 1
		END
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO #tmpDMResultSet (ResultSetID, CommCellNumber, aFileID, aFileOffset)
		SELECT DISTINCT '', CommCellNumber, aFileId, aFileOffset
		FROM #tmpBulkResultSet
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tmpDMResultSet
		SET ResultSetId  = B.ResultSetId,
			aFileLength = B.aFileLength,
			AppType = B.AppType,
			FileSizeKB = B.FileSizeKB,
			ModifiedTime = B.ModifiedTime,
			JobId = B.JobId,
			ResultSet = B.ResultSet,
			OriginalFullPath = B.OriginalFullPath,
			documentId = B.documentId,
			ClientID = B.ClientID,
			tagGUIDList = B.tagGUIDList,
			OwnerField = B.OwnerField,
			FromField = B.FromField,
			FolderPath = B.FolderPath,
			IndexGUID = B.IndexGUID,
			Title = B.Title,
			EmailSubject = B.EmailSubject,
			EmailFROM = B.EmailFROM,
			EmailTO = B.EmailTO,
			EmailCC = B.EmailCC,
			EmailBCC = B.EmailBCC
		FROM #tmpDMResultSet A, #tmpBulkResultSet B
		WHERE A.CommCellNumber = B.CommCellNumber
		AND A.aFileId = B.aFileId
		AND A.aFileOffset = B.aFileOffSet
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Also we want suppress duplicates w.r.t IndexGUID (turboguid) from 11.0
		;WITH CTE AS (
			SELECT ROW_NUMBER() OVER (PARTITION BY IndexGUID ORDER BY aFileID DESC) PT
			FROM #tmpDMResultSet
			WHERE ISNULL(IndexGUID, '')  <> ''
		)
		DELETE FROM CTE
		WHERE PT > 1
		SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
		IF @rowCount > 0
		BEGIN
			SELECT @o_OutputMessage += 'Ignored [' + convert(varchar, @rowCount) + '] item(s) (duplicate with respect to turboguid) from the input. '
			SET @AtLeastOneError = 1
		END
		IF @errorCode != 0 GOTO CX_EXIT
		--Get the resultSetId based on indexguid/turboguid first
		UPDATE tt
		SET ResultSetId = RS.ResultSetId,
			--CommCellNumber = (CASE WHEN RS.aFileID < tt.aFileID THEN tt.CommCellNumber ELSE RS.CommCellNumber END), -- This never change so we don't update as of now.
			aFileID = (CASE WHEN RS.aFileID < tt.aFileID THEN tt.aFileID ELSE RS.aFileID END),
			aFileOffset = (CASE WHEN RS.aFileID < tt.aFileID THEN tt.aFileOffset ELSE RS.aFileOffset END),
			needaFileIdOrOfffsetUpdate = (CASE WHEN RS.aFileID < tt.aFileID THEN 1 ELSE 0 END),
			isExistsInDMResultSet = 1
		FROM #tmpDMResultSet as tt, DMResultSet as RS WITH (READUNCOMMITTED)
		where ISNULL(tt.IndexGUID, '') <> '' and tt.IndexGUID = RS.IndexGUID
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the resultSetId based on ccn,afid,afof (backward compatibility for data from older agents or any other agents who don't generate turboguid)
		UPDATE tt
		SET ResultSetId = RS.ResultSetId,
			isExistsInDMResultSet = 1
		FROM #tmpDMResultSet as tt, DMResultSet as RS WITH (READUNCOMMITTED)
		where tt.isExistsInDMResultSet = 0 AND tt.aFileID > 0 AND tt.CommCellNumber = RS.CommCellNumber
							AND tt.aFileId = RS.aFileId
							AND tt.aFileOffset = RS.aFileOffSet
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Fix for MR 130907
		-- we can allow duplicates to enter table during updation and afterwards delete / clean duplicate combination of CommCellNumber, aFileId, aFileOffset
		;WITH CTE AS (
				SELECT ROW_NUMBER() OVER (PARTITION BY CommCellNumber, aFileId, aFileOffset ORDER BY aFileID DESC) PT
				FROM #tmpDMResultSet
				WHERE aFileID > 0
			)
		DELETE FROM CTE
		WHERE PT > 1
		SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
		IF @rowCount > 0
		BEGIN
			SELECT @o_OutputMessage += 'Ignored [' + convert(varchar, @rowCount) + '] item(s) (duplicate with respect to commcellnumber,afileid,afileoffset) from the input. '
			SET @AtLeastOneError = 1
		END
		IF @errorCode != 0 GOTO CX_EXIT
		SELECT @uniqueInputRowCount = COUNT(*) FROM #tmpDMResultSet
		--This condition should not happen according to latest changes done in polling stored procedure (sp_dm2_GetResultItemDetail) and if it happen we want to fail and detect the bug
		--we can comment out if it does not happen in lab after stabilizing these changes.
		IF EXISTS (SELECT * FROM #tmpDMResultSet WHERE isExistsInDMResultSet = 0 AND ResultSetID in (SELECT ResultSetID FROM DMResultSet EX WITH (READUNCOMMITTED)))
		BEGIN
			--Also we want tester to keep moving by disabling this error that will trigger DEV analysis to find out on why this happened.
			IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DISABLE_RESULTSETID_MISMATCH_ERROR' AND SettingValue = 'True')
			BEGIN
				RAISERROR ('Item supplied has ResultSetId that already exist in database but neither CCN,AFileId,AFileOffset or TurboGuid does not match', 16, 1)
				GOTO CX_EXIT
			END
		END
		INSERT INTO DMResultSet
			(ResultSetID,CommCellNumber,aFileID,aFileOffset,aFileLength,
			AppType,FileSizeKB,ModifiedTime,JobId,OriginalFullPath,
			DestinationPath,CreateTime,RestoreUserGUID,RestoreCommCellNumber,RestoreJobID,
			RestoreStatus,RestoreTime,Attribute,
			documentID,ClientID,ERMStatus,
			IndexGUID,Title)
		select
			tt.ResultSetID, tt.CommCellNumber, tt.aFileID, tt.aFileOffset, tt.aFileLength,
			tt.AppType, tt.FileSizeKB, tt.ModifiedTime, tt.JobId, tt.OriginalFullPath,
			'', getDate(), '', 0, 0,
			0, getDate(), 0,
			tt.documentId, tt.ClientID, 0,
			tt.IndexGUID,tt.Title
		from #tmpDMResultSet as tt
		where tt.isExistsInDMResultSet <> 1
		SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
		SELECT @o_OutputMessage += 'Inserted [' + convert(varchar, @rowCount) + '] item(s) into DMResultSet. '
		IF @rowCount > 0
		BEGIN
			if @rowCount = @inputRowCount
				SET @AtLeastOneTracing = 1
			else
				SET @AtLeastOneInfo = 1
		END
		ELSE IF EXISTS (SELECT TOP 1 * FROM #tmpDMResultSet WHERE isExistsInDMResultSet <> 1)
		BEGIN
			SELECT @AtLeastOneError = 1	--Something in input to be inserted but we could not insert them
		END
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE RS
		SET
		--RS.CommCellNumber = tt.CommCellNumber, -- This never change so we don't update as of now but we may decide to update it in future if needed.
		aFileID = tt.aFileID,
		aFileOffset = tt.aFileOffset
		FROM DMResultSet RS, #tmpDMResultSet tt
		WHERE RS.ResultSetID = tt.ResultSetID AND tt.needaFileIdOrOfffsetUpdate = 1
		--check for error
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE RS
		SET
		--Update soft deleted attribute
			Attribute = CASE WHEN (RS.Attribute & 4 = 4) THEN
							RS.Attribute & ~4
							ELSE Attribute END,
		--Update the documentId
			documentId = CASE WHEN (RS.documentId = '') THEN
							tt.documentId
							ELSE RS.documentId END,
		--Update the ClientID
			ClientID = CASE WHEN (RS.ClientID = 0) THEN
							tt.ClientID
							ELSE RS.ClientID END,
		--Update the Size
			FileSizeKB =  tt.FileSizeKB,
		--Update TURBO/INDEX GUID if earlier it is null or empty in DB
			IndexGUID = CASE WHEN ISNULL(RS.IndexGUID, '') = '' THEN
						tt.IndexGUID
						ELSE RS.IndexGUID END,
		--Update modifiedtime if earlier it is null or empty in DB
			ModifiedTime = CASE WHEN (ISNULL(RS.ModifiedTime, '') = '' OR  RS.ModifiedTime = '1970-01-01 00:00:00.000') THEN
						tt.ModifiedTime
						ELSE RS.ModifiedTime END,
		--If we are updating XML blob, it is better we update flat table (Title) also, other-wise it will cause data disintegrated.
			Title = tt.Title
		FROM DMResultSet RS, #tmpDMResultSet tt
		WHERE RS.ResultSetID = tt.ResultSetID AND tt.isExistsInDMResultSet = 1
		--check for error
		SELECT @errorCode =	@@ERROR, @rowCount = @@ROWCOUNT
		if @rowCount > 0
		BEGIN
			SELECT @o_OutputMessage += 'Updated [' + convert(varchar, @rowCount) + '] item(s) in DMResultSet. '
			SET @AtLeastOneInfo = 1
		END
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the deleted flag if the entry already exists
		UPDATE DMContainerItemStates
		SET Attribute = Attribute & ~4
		FROM #tmpDMResultSet as tt, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
		WHERE CIS.ContainerId = @i_ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = @i_UserGUID
		AND		CIS.Attribute & 4 = 4
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		IF @i_isCompliancePolicy = 1
		BEGIN
			-- Update the Compliance Policy attribute if the entry already exists
			UPDATE DMContainerItem WITH (PAGLOCK)
			SET Attribute = Attribute | 32
			FROM #tmpDMResultSet as tt, DMContainerItem as CI
			WHERE CI.ContainerId = @i_ContainerId
			AND 	CI.ResultSetId = tt.ResultSetId
			AND		CI.Attribute & 32 = 0
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			-- Update the Compliance Policy attribute if the entry already exists
			UPDATE DMContainerItemStates
			SET Attribute = Attribute | 32
			FROM #tmpDMResultSet as tt, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
			WHERE CIS.ContainerId = @i_ContainerId
			AND 	CIS.ResultSetId = tt.ResultSetId
			AND		CIS.AssignedUserGUID = @i_UserGUID
			AND		CIS.Attribute & 32 = 0
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
		DECLARE @MergeOutput1 table
		(
			ActionType nvarchar(10)
		);
		--
		;MERGE DMContainerItem AS TARGET
		USING (SELECT distinct tt.ResultSetId FROM #tmpDMResultSet  AS tt) AS SOURCE (ResultSetId)
		ON (target.ResultSetId = source.ResultSetId AND TARGET.ContainerId = @i_ContainerId)
		WHEN NOT MATCHED BY TARGET THEN
			INSERT (ContainerID,QueryID,ResultSetID,CreateTime,Attribute,UserGUID)
			VALUES (@i_ContainerId, @i_QueryID, source.ResultsetId, getUtcDate(), CASE WHEN @i_isCompliancePolicy = 1 THEN 32 ELSE 0 END, @i_UserGUID)
		WHEN MATCHED THEN
			UPDATE SET
					TARGET.Attribute = TARGET.Attribute & ~4,
					TARGET.CreateTime = getutcDate()
		OUTPUT   $action   INTO @MergeOutput1;
		SELECT	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		SELECT @o_RowsInserted = COUNT(*) FROM @MergeOutput1 WHERE ActionType = 'INSERT'
		SELECT @rowCount = @o_RowsInserted + COUNT(*) FROM @MergeOutput1 WHERE ActionType = 'UPDATE'
		SELECT @o_OutputMessage += 'Saved [' + convert(varchar, @rowCount) + '] item(s) in DMContainerItem. '
		--Counts not matching, raise log level to error
		IF (@rowCount <> @uniqueInputRowCount) OR (@rowCount <> @inputRowCount)
		BEGIN
			SET @AtLeastOneError = 1
		END
		ELSE
		BEGIN
			SET @AtLeastOneInfo = 1
		END
		--
		INSERT INTO #tmpDMUserItemTags
		SELECT DISTINCT TT.ResultSetId, @i_UserGUID, TAG.ID
		FROM #tmpDMResultSet TT CROSS APPLY dbo.splitStringToTable(TT.tagGUIDList) TAG
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
 		CREATE INDEX IDX_tmpDMUserItemTags_CIT ON #tmpDMUserItemTags(TagGUID, ResultSetID, UserGUID)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the deleted flag if the entry already exists
		UPDATE DMUserItemTags
		SET 	Attribute = UIT.Attribute & ~4
		FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMUserItemTags as tt
		WHERE UIT.ResultSetId = tt.ResultSetId
		AND		UIT.UserGUID = tt.UserGUID
		AND		UIT.TagID = tt.TagGUID
		AND		UIT.Attribute & 4 = 4
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the SYNC TO FAST flag if the entry already exists
		UPDATE DMUserItemTags
		SET 	Attribute = UIT.Attribute | 2
		FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMUserItemTags as tt
		WHERE UIT.ResultSetId = tt.ResultSetId
		AND		UIT.UserGUID = tt.UserGUID
		AND		UIT.TagID = tt.TagGUID
		AND		UIT.Attribute & 2 = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Create the new entries
		INSERT INTO DMUserItemTags
		SELECT  tt.UserGUID, tt.ResultSetId, tt.TagGUID, getDate(), 2 -- Synced with FAST
		FROM 	#tmpDMUserItemTags as tt
		WHERE NOT EXISTS (SELECT TOP 1 * FROM DMUserItemTags AS UIT WITH (READUNCOMMITTED)
											WHERE UIT.ResultSetId = tt.ResultSetId
											AND		UIT.UserGUID = tt.UserGUID
											AND		UIT.TagID = tt.TagGUID)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Remove all Container specific rows once it is SYNCed in FAST
		DELETE DMContainerItemTags
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMUserItemTags as tt
		WHERE CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	CX_EXIT:
		IF @errorCode != 0
		BEGIN
			  SET @o_RowsInserted = 0
			  SELECT null
			  SET @o_MessageLogLevel = @LOG_ERROR
		END
		ELSE
		BEGIN
				SELECT R.ResultSetID, R.ResultSet FROM #tmpDMResultSet R
				IF @AtLeastOneError = 1
				BEGIN
					SET @o_MessageLogLevel = @LOG_ERROR
				END
				ELSE IF @AtLeastOneInfo = 1
				BEGIN
					SET @o_MessageLogLevel = @LOG_INFO
				END
				ELSE IF @AtLeastOneTracing = 1
				BEGIN
					SET @o_MessageLogLevel = @LOG_TRACING
				END
				ELSE
				BEGIN
					SET @o_MessageLogLevel = @LOG_DETAILS
				END
		END
		--
		IF OBJECT_ID('tempdb.dbo.#tmpBulkResultSet') IS NOT NULL
		DROP TABLE #tmpBulkResultSet
		IF OBJECT_ID('tempdb.dbo.#tmpDMResultSet') IS NOT NULL
		DROP TABLE #tmpDMResultSet
		IF OBJECT_ID('tempdb.dbo.#tmpDistinctRS') IS NOT NULL
		DROP TABLE #tmpDistinctRS
		IF OBJECT_ID('tempdb.dbo.#tmpDMUserItemTags') IS NOT NULL
		DROP TABLE #tmpDMUserItemTags
		IF OBJECT_ID('tempdb.dbo.#tmpDMEmailFields') IS NOT NULL
		DROP TABLE #tmpDMEmailFields
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddResultSetBulk')
	delete from GxQscripts where name = 'sp_dm2_AddResultSetBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddResultSetBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddResultSetBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddResultSetBulk',  '00010048000000000000', 'sp_dm2_AddResultSetBulk', '00010048000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_BulkGetDestPathForItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_BulkGetDestPathForItems.sp,v $ $Id: sp_dm2_BulkGetDestPathForItems.sp,v 1.3 2008/06/12 23:33:12 ylu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_BulkGetDestPathForItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_BulkGetDestPathForItems')
	drop procedure sp_dm2_BulkGetDestPathForItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_BulkGetDestPathForItems')
	delete from GxQscripts where name = 'sp_dm2_BulkGetDestPathForItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_BulkGetDestPathForItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_BulkGetDestPathForItems'
GO
print '... Creating Procedure: sp_dm2_BulkGetDestPathForItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_BulkGetDestPathForItems
  @i_DataFilePath nvarchar(1024)
AS
  DECLARE @o_ResultSetID varchar(36);
  DECLARE @o_DestinationPath nvarchar(max);
	SET NOCOUNT ON
	DECLARE @l_delimiter	VARCHAR(256)
	DECLARE @SQL		VARCHAR(2048)
	SET @l_delimiter = ISNULL((SELECT SettingValue FROM DMSetting WITH (READUNCOMMITTED) WHERE settingName = 'DMBulkInsert_Delim'), '')
	IF(LEN(@l_delimiter ) = 0)
	BEGIN
		SET @l_delimiter = 'CV0X12'
	END
	create table #tmpDMResultSet
	(
		[ResultSetID] [char](36) NOT null
	)
	create table #tmpDMDestinationPath
	(
		[ResultSetID] [char](36) NOT null,
		[DestinationPath] [nvarchar](max) NOT null
	)
	SET @SQL = 'BULK INSERT #tmpDMResultSet FROM '''+@i_DataFilePath+''' WITH (FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
	exec (@SQL)
	INSERT INTO #tmpDMDestinationPath
	SELECT DISTINCT b.ResultSetId, b.DestinationPath
	FROM #tmpDMResultSet a, dmResultSet b
	WHERE a.ResultSetId = b.ResultSetId
	AND b.RestoreStatus = 4
	SELECT * FROM #tmpDMDestinationPath
	ORDER BY ResultSetId, DestinationPath
	DROP TABLE #tmpDMResultSet
	DROP TABLE #tmpDMDestinationPath
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_BulkGetDestPathForItems')
	delete from GxQscripts where name = 'sp_dm2_BulkGetDestPathForItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_BulkGetDestPathForItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_BulkGetDestPathForItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_BulkGetDestPathForItems',  '00010003000000000000', 'sp_dm2_BulkGetDestPathForItems', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_ContainerItemTagsBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_ContainerItemTagsBulk.sp,v $ $Id: sp_dm2_ContainerItemTagsBulk.sp,v 1.5 2008/08/21 17:31:24 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_ContainerItemTagsBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_ContainerItemTagsBulk')
	drop procedure sp_dm2_ContainerItemTagsBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_ContainerItemTagsBulk')
	delete from GxQscripts where name = 'sp_dm2_ContainerItemTagsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ContainerItemTagsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_ContainerItemTagsBulk'
GO
print '... Creating Procedure: sp_dm2_ContainerItemTagsBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_ContainerItemTagsBulk
  @i_ContainerID varchar(36),
  @i_UserID varchar(36),
  @i_SelALLFlag INTEGER,
  @i_DataFilePath varchar(1024),
  @i_Operation INTEGER,
  @i_TagGUIDList XML
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
	/*
	-- @i_Operation = 1 --> ADD Tags
	-- @i_Operation = 2 --> DELETE Tags
	*/
	DECLARE @errorCode integer
	declare @l_delimiter	varchar(256)
	declare @SQL	varchar(2048)
	set @l_delimiter = ISNULL((select SettingValue from DMSetting WITH (READUNCOMMITTED) where settingName = 'DMBulkInsert_Delim'), '')
	IF(len(@l_delimiter ) = 0)
		SET @l_delimiter = 'CV0X12'
	IF object_id('tempdb.dbo.#tmpDMResultSet') is not null
	DROP TABLE #tmpDMResultSet
	IF object_id('tempdb.dbo.#tmpDMTags') is not null
	DROP TABLE #tmpDMTags
	IF object_id('tempdb.dbo.#tmpDMResultSetTags') is not null
	DROP TABLE #tmpDMResultSetTags
	create table #tmpDMResultSet
	(
		[ResultSetID] [char](36) NOT null
	)
	create table #tmpDMTags
	(
		[TagID] [varchar](36) NOT null
	)
	create table #tmpDMResultSetTags
	(
		[ContainerID] [char](36) NOT null,
		[ResultSetID] [char](36) NOT null,
		[UserGUID]		[char](36) NOT null,
		[TagGUID]			[char](36) null
	)
	IF (@i_SelALLFlag = 0)
	BEGIN
		SET @SQL = 'BULK INSERT #tmpDMResultSet FROM '''+@i_DataFilePath+''' WITH (FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
		exec (@SQL)
	END
	ELSE
	BEGIN
		INSERT INTO #tmpDMResultSet
		SELECT DISTINCT ResultSetID
		FROM DMContainerItem CI
		WHERE CI.ContainerID = @i_ContainerID
		AND		CI.Attribute & 4 = 0
	END
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO #tmpDMTags
	SELECT	DISTINCT T.item.value('@TagGUID', 'VARCHAR(36)')
	FROM		@i_TagGUIDList.nodes('/TagList/TagInfo') T(item)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	IF (@i_Operation = 1) -- ADD Tags
	BEGIN
		-- Update the deleted flag if the entry already exists
		UPDATE DMContainerItemStates
		SET Attribute = Attribute & ~4
		FROM #tmpDMResultSet as tt, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
		WHERE CIS.ContainerId = @i_ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = @i_UserID
		AND		CIS.Attribute & 4 = 4
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Create the new entries
		INSERT INTO DMContainerItemStates
		SELECT @i_ContainerId, tt.ResultSetId, @i_UserID, '', getDate(), @i_UserID, '', 0
		FROM #tmpDMResultSet as tt
		WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemStates AS CIS WITH (READUNCOMMITTED)
											WHERE CIS.ContainerId = @i_ContainerId
											AND 	CIS.ResultSetId = tt.ResultSetId
											AND		CIS.AssignedUserGUID = @i_UserID)
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	END
	INSERT INTO #tmpDMResultSetTags
	SELECT DISTINCT @i_ContainerId, TT.ResultSetId, @i_UserID, TAG.TagID
	FROM #tmpDMResultSet TT, #tmpDMTags TAG
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	CREATE INDEX IDX_tmpDMResultSetTags_CIT ON #tmpDMResultSetTags(ContainerID, ResultSetID, UserGUID, TagGUID)
	IF (@i_Operation = 1) -- ADD Tags
	BEGIN
		-- Update the deleted flag if the entry already exists
		UPDATE DMContainerItemTags
		SET 	Attribute = CIT.Attribute & ~4
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		AND		CIT.Attribute & 4 = 4
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Create the new entries
		INSERT INTO DMContainerItemTags
		SELECT CIS.AssignID, tt.TagGUID, getDate(), @i_UserID, '', 0 -- NOT Synced with FAST
		FROM 	DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND 	NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemTags AS CIT WITH (READUNCOMMITTED)
											WHERE CIS.AssignID = CIT.AssignID
											AND 	CIT.TagID = tt.TagGUID)
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Remove those Tags that are already SYNCed in FAST
		DELETE DMContainerItemTags
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), DMUserItemTags UIT WITH (READUNCOMMITTED)
		WHERE CIS.ResultSetId = UIT.ResultSetId
		AND		CIS.AssignedUserGUID = UIT.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = UIT.TagID
		AND		UIT.Attribute & 2 = 2
		AND		UIT.Attribute & 4 = 0
	END
	ELSE IF (@i_Operation = 2) -- DELETE Tags
	BEGIN
		-- DELETE the tag entries for this Container
		DELETE DMContainerItemTags
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		-- Mark Deleted
		UPDATE DMUserItemTags
		SET 	Attribute = UIT.Attribute | 4
		FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE UIT.ResultSetId = tt.ResultSetId
		AND		UIT.UserGUID = tt.UserGUID
		AND		UIT.TagID = tt.TagGUID
		AND		UIT.Attribute & 4 = 0
		-- Update the SYNC TO FAST flag
		UPDATE DMUserItemTags
		SET 	Attribute = UIT.Attribute & ~2
		FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE UIT.ResultSetId = tt.ResultSetId
		AND		UIT.UserGUID = tt.UserGUID
		AND		UIT.TagID = tt.TagGUID
		AND		UIT.Attribute & 2 = 2
/*
		-- This table will only contain the DB ONLY tags. Delete them with Remove Tag Request
		-- Update the deleted flag
		UPDATE DMContainerItemTags
		SET 	Attribute = CIT.Attribute | 4
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		AND		CIT.Attribute & 4 = 0
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
		-- Update the FAST Sync flag
		UPDATE DMContainerItemTags
		SET 	Attribute = CIT.Attribute & ~2
		FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
		WHERE CIS.ContainerId = tt.ContainerId
		AND 	CIS.ResultSetId = tt.ResultSetId
		AND		CIS.AssignedUserGUID = tt.UserGUID
		AND		CIS.AssignID = CIT.AssignID
		AND		CIT.TagID = tt.TagGUID
		AND		CIT.Attribute & 2 = 2
*/
		IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	END
CX_EXIT:
	DROP TABLE #tmpDMResultSet
	DROP TABLE #tmpDMTags
	DROP TABLE #tmpDMResultSetTags
	SELECT	0
	RETURN
CX_ERROR_EXIT:
	DROP TABLE #tmpDMResultSet
	DROP TABLE #tmpDMTags
	DROP TABLE #tmpDMResultSetTags
	SELECT	-1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_ContainerItemTagsBulk')
	delete from GxQscripts where name = 'sp_dm2_ContainerItemTagsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ContainerItemTagsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_ContainerItemTagsBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_ContainerItemTagsBulk',  '00010005000000000000', 'sp_dm2_ContainerItemTagsBulk', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddItemReport.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddItemReport.sp,v $ $Id: sp_dm2_AddItemReport.sp,v 1.2 2008/08/28 16:03:39 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddItemReport <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddItemReport')
	drop procedure sp_dm2_AddItemReport
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddItemReport')
	delete from GxQscripts where name = 'sp_dm2_AddItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddItemReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddItemReport'
GO
print '... Creating Procedure: sp_dm2_AddItemReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddItemReport
  @i_jobId int,
  @i_status int,
  @i_operationType int,
  @i_timeOfAction datetime,
  @i_operationInfo nvarchar(max),
  @i_aFileID bigint,																			
  @i_aFileOffset bigint,																				
  @i_itemInfo nvarchar(max),
  @i_Id INT OUTPUT,
  @i_CommCellNumber INT,
  @i_UserName nvarchar(256),
  @i_errCode int = 0,
  @i_reason nvarchar(max) = ''
AS
SET @i_Id = 0
INSERT INTO DMItemReport
(
	jobId, [status], operationType, reason, timeOfAction,
	operationInfo, aFileID, aFileOffset, itemInfo, errCode, CommCellNumber, UserName
)
VALUES
(
	@i_jobId, @i_status, @i_operationType, @i_reason, @i_timeOfAction,
	@i_operationInfo, @i_aFileID, @i_aFileOffset, @i_itemInfo, @i_errCode, @i_CommCellNumber, @i_UserName
)
IF @@ERROR = 0
	SET @i_Id = @@IDENTITY
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddItemReport')
	delete from GxQscripts where name = 'sp_dm2_AddItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddItemReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddItemReport'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddItemReport',  '00010002000000000000', 'sp_dm2_AddItemReport', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddUserComment.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddUserComment.sp,v $ $Id: sp_dm2_AddUserComment.sp,v 1.6 2010/07/12 23:42:12 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddUserComment <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddUserComment')
	drop procedure sp_dm2_AddUserComment
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddUserComment')
	delete from GxQscripts where name = 'sp_dm2_AddUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddUserComment'
GO
print '... Creating Procedure: sp_dm2_AddUserComment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddUserComment
  @i_CommentID char(36),
  @i_UserGUID char(36),
  @i_SessionID varchar(24) = '',
  @i_ContainerID char(36) = NULL,
  @i_ResultSetID char(36) = NULL,
  @i_ParentCommentID char(36) = NULL,
  @i_Comment nvarchar(max),
  @i_CreateTime datetime,
  @i_Attribute int = 0
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode integer
	if (len(isnull(@i_Comment, '')) > 0)
	begin
	  insert into DMUserComment (CommentID, UserGUID, SessionID, ContainerID, ResultSetID, ParentCommentID, Comment, CreateTime, Attribute, ModifiedTime)
	  values (@i_CommentID, @i_UserGUID, @i_SessionID, @i_ContainerID, @i_ResultSetID, @i_ParentCommentID, @i_Comment, @i_CreateTime, 0, @i_CreateTime)
	end
SELECT @errorCode = @@Error
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddUserComment')
	delete from GxQscripts where name = 'sp_dm2_AddUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddUserComment'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddUserComment',  '00010006000000000000', 'sp_dm2_AddUserComment', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddSetting.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddSetting.sp,v $ $Id: sp_dm2_AddSetting.sp,v 1.3 2013/10/18 16:44:17 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddSetting <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddSetting')
	drop procedure sp_dm2_AddSetting
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddSetting')
	delete from GxQscripts where name = 'sp_dm2_AddSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddSetting')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddSetting'
GO
print '... Creating Procedure: sp_dm2_AddSetting'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddSetting
  @i_SettingName varchar(200),
  @i_SettingValue nvarchar(max),
  @i_CreateTime datetime
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode integer
  if not exists (select * from DMSetting WITH (READUNCOMMITTED) where SettingName = @i_SettingName)
	insert into DMSetting
	values (@i_SettingName, @i_SettingValue, @i_CreateTime)
  else
    update DMSetting
    set SettingValue = @i_SettingValue, CreateTime = @i_CreateTime
	where SettingName = @i_SettingName
SELECT @errorCode = @@Error
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddSetting')
	delete from GxQscripts where name = 'sp_dm2_AddSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddSetting')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddSetting'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddSetting',  '00010003000000000000', 'sp_dm2_AddSetting', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddUserPref.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddUserPref.sp,v $ $Id: sp_dm2_AddUserPref.sp,v 1.3 2009/10/15 13:45:40 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddUserPref <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddUserPref')
	drop procedure sp_dm2_AddUserPref
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddUserPref')
	delete from GxQscripts where name = 'sp_dm2_AddUserPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddUserPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddUserPref'
GO
print '... Creating Procedure: sp_dm2_AddUserPref'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddUserPref
  @i_UserPrefName varchar(50),
  @i_UserGUID char(36),
  @i_UserPrefValue nvarchar(50),
  @i_CreateTime datetime
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode integer
  if not exists (select * from DMUserPref WITH (READUNCOMMITTED) where UserPrefName = @i_UserPrefName AND UserGUID = @i_UserGUID)
	insert into DMUserPref (UserPrefName,UserGUID,UserPrefValue,CreateTime)
	values (@i_UserPrefName, @i_UserGUID, @i_UserPrefValue, @i_CreateTime)
  else
    update DMUserPref
    set UserPrefValue = @i_UserPrefValue, CreateTime = @i_CreateTime
	where UserPrefName = @i_UserPrefName
	and UserGUID = @i_UserGUID
SELECT @errorCode = @@Error
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddUserPref')
	delete from GxQscripts where name = 'sp_dm2_AddUserPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddUserPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddUserPref'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddUserPref',  '00010003000000000000', 'sp_dm2_AddUserPref', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddUserSession.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddUserSession.sp,v $ $Id: sp_dm2_AddUserSession.sp,v 1.11 2015/07/13 18:52:27 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddUserSession <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddUserSession')
	drop procedure sp_dm2_AddUserSession
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddUserSession')
	delete from GxQscripts where name = 'sp_dm2_AddUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddUserSession'
GO
print '... Creating Procedure: sp_dm2_AddUserSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddUserSession
  @i_IP varchar(255),
  @i_SessionID char(36),
  @i_UserGUID char(36) output,
  @i_CommCellNumber int,
  @i_UserName nvarchar(256),
  @i_CreateTime datetime,
  @i_Attribute int,
  @i_TimeOutInMin int = 30,
  @i_ConsoleType int = 0,
  @i_siteMode int = 0,
  @i_DeviceId nvarchar(max) = NULL,
  @i_SpecialProperties XML = NULL
AS
BEGIN
SET ANSI_NULLS ON
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @i_errorCode integer
	SELECT @i_DeviceId = (CASE WHEN LEN(ISNULL( @i_DeviceId , '')) = 0 THEN NULL ELSE @i_DeviceId END)
	SELECT @i_SpecialProperties = (CASE WHEN LEN(ISNULL( CONVERT(NVARCHAR(MAX), @i_SpecialProperties) , '')) = 0 THEN NULL ELSE @i_SpecialProperties END)
  if exists (
		select top 1 SessionId from DMUserSession WITH (READUNCOMMITTED)
		where CommCellNumber = @i_CommCellNumber and UserName = @i_UserName and ISNULL(UserGUID, '') <> '' and ISNULL(@i_UserGUID, '') = ''
	)
	BEGIN
		set @i_UserGUID = (select top 1 UserGUID from DMUserSession
			WITH (READUNCOMMITTED) where CommCellNumber = @i_CommCellNumber and UserName = @i_UserName and ISNULL(UserGUID, '') <> ''
		)
	END
  insert into DMUserSession (IP,SessionID,UserGUID,CommCellNumber,UserName,CreateTime,Attribute,LastAccessTime,TimeOutInMin,ConsoleType)
  values (@i_IP, @i_SessionID, @i_UserGUID, @i_CommCellNumber, @i_UserName, @i_CreateTime,@i_Attribute,@i_CreateTime,@i_TimeOutInMin,@i_ConsoleType)
SELECT @i_errorCode = @@Error
if @i_errorCode = 0
BEGIN
	INSERT INTO DMUserSessionDetail(SessionID, SiteMode, DeviceID, SpecialProperties)
	VALUES( @i_SessionID, @i_siteMode, @i_DeviceId, @i_SpecialProperties )
END
SELECT @i_errorCode = @@Error
SELECT @i_errorCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddUserSession')
	delete from GxQscripts where name = 'sp_dm2_AddUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddUserSession'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddUserSession',  '00010011000000000000', 'sp_dm2_AddUserSession', '00010011000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_RenewUserSession.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_RenewUserSession.sp,v $ $Id: sp_dm2_RenewUserSession.sp,v 1.2 2014/02/24 21:58:20 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_RenewUserSession <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_RenewUserSession')
	drop procedure sp_dm2_RenewUserSession
IF EXISTS (select * from GxQscripts where name='sp_dm2_RenewUserSession')
	delete from GxQscripts where name = 'sp_dm2_RenewUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RenewUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_RenewUserSession'
GO
print '... Creating Procedure: sp_dm2_RenewUserSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_RenewUserSession
  @i_CurSessionId varchar(36),
  @i_DeviceId nvarchar(max),
  @i_Attribute int,
  @i_NewSessionId varchar(36) OUTPUT,
  @i_errorCode int output
AS
BEGIN
	DECLARE @deviceId nvarchar(max)
	DECLARE @ExSessionId nvarchar(36)
	SET @i_errorCode = 0
	SELECT @ExSessionId = U.SessionID, @deviceId = DeviceID FROM DMUserSession U
	JOIN DMUserSessionDetail D ON U.SessionID = D.SessionID
	WHERE U.SessionID = @i_CurSessionId
	IF ISNULL(@ExSessionId, '') = ''
		 SET @i_errorCode = 1143 -- SESSION_NOT_FOUND_FOR_SESSION_RENEWAL
	ELSE IF ISNULL(@deviceId, '') = '' OR @deviceId <> @i_DeviceId
		SET @i_errorCode =  1138 -- DEVICE_ID_MISMATCH_FOR_SESSION_RENEWAL
	IF @i_errorCode = 0
	BEGIN
		BEGIN TRAN
		IF ISNULL(@i_NewSessionId, '') = ''
			SET @i_NewSessionId = LOWER(NEWID())
		insert into DMUserSession (IP,SessionID,UserGUID,CommCellNumber,UserName,CreateTime,Attribute,LastAccessTime,TimeOutInMin,ConsoleType)
		SELECT IP,@i_NewSessionId,UserGUID,CommCellNumber,UserName,GETUTCDATE(),@i_Attribute,GETUTCDATE(),TimeOutInMin,ConsoleType FROM DMUserSession
		WHERE SessionID = @i_CurSessionId
		SELECT @i_errorCode = @@Error
		IF @i_errorCode = 0
		BEGIN
			INSERT INTO DMUserSessionDetail(SessionID, SiteMode, DeviceID, SpecialProperties,LinkSessionID)
			SELECT @i_NewSessionId, SiteMode, DeviceId, SpecialProperties, @i_CurSessionId FROM DMUserSessionDetail
			WHERE SessionID = @i_CurSessionId
			SELECT @i_errorCode = @@Error
		END
		IF @i_errorCode = 0
			COMMIT TRAN
		ELSE
			ROLLBACK TRAN
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_RenewUserSession')
	delete from GxQscripts where name = 'sp_dm2_RenewUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RenewUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_RenewUserSession'
GO

insert into GXDBVersions values(2, 'sp_dm2_RenewUserSession',  '00010002000000000000', 'sp_dm2_RenewUserSession', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddSearchParamPreference.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddSearchParamPreference.sp,v $ $Id: sp_dm2_AddSearchParamPreference.sp,v 1.4 2009/06/18 08:10:26 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddSearchParamPreference <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddSearchParamPreference')
	drop procedure sp_dm2_AddSearchParamPreference
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddSearchParamPreference')
	delete from GxQscripts where name = 'sp_dm2_AddSearchParamPreference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddSearchParamPreference')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddSearchParamPreference'
GO
print '... Creating Procedure: sp_dm2_AddSearchParamPreference'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddSearchParamPreference
  @i_UserGuid varchar(36) = '',
  @i_PreferredValue nvarchar(max) = '',
  @i_Name varchar(50) = ''
AS
SET NOCOUNT ON
DECLARE @i_ParamId INT
SET @i_ParamId = (SELECT Id FROM [DMSearchParameter] WITH (READUNCOMMITTED) WHERE Name = @i_Name)
IF NOT EXISTS (SELECT * FROM [DMSearchParamPreference] WITH (READUNCOMMITTED) WHERE ParamId = @i_ParamId AND UserGuid = @i_UserGuid)
BEGIN
	INSERT INTO [DMSearchParamPreference]
	VALUES (@i_ParamId, @i_UserGuid, @i_PreferredValue)
END
ELSE
BEGIN
    UPDATE [DMSearchParamPreference]
    SET PreferredValue = @i_PreferredValue
	WHERE ParamId = @i_ParamId AND UserGuid = @i_UserGuid
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddSearchParamPreference')
	delete from GxQscripts where name = 'sp_dm2_AddSearchParamPreference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddSearchParamPreference')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddSearchParamPreference'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddSearchParamPreference',  '00010004000000000000', 'sp_dm2_AddSearchParamPreference', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetContainerRptItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetContainerRptItems.sp,v $ $Id: sp_dm2_GetContainerRptItems.sp,v 1.12 2015/03/10 13:26:06 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetContainerRptItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetContainerRptItems')
	drop procedure sp_dm2_GetContainerRptItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetContainerRptItems')
	delete from GxQscripts where name = 'sp_dm2_GetContainerRptItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetContainerRptItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetContainerRptItems'
GO
print '... Creating Procedure: sp_dm2_GetContainerRptItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetContainerRptItems
  @inputXML xml
AS
BEGIN
  DECLARE @fromDate DateTime
  DECLARE @ToDate DateTime
  DECLARE @fromDateString varchar(20)
  DECLARE @ToDateString varchar(20)
  DECLARE @offset INT
  DECLARE @limit INT
  DECLARE @debug BIT
	SET NOCOUNT ON
	--should be 1 only for debugging purposes
	SET @debug = 0
	IF @debug = 1
	BEGIN
		SET @limit = 10
		SET @offset = 20
	END
	ELSE
	BEGIN
		SET @limit = @inputXML.value('(DM2ContentIndexing_GetContainersRptReq/pagingConfig/@limit)[1]', 'INT')
		SET @offset = @inputXML.value('(DM2ContentIndexing_GetContainersRptReq/pagingConfig/@offset)[1]', 'INT')
	END
	IF @limit <= 0
	BEGIN
		SET @limit = 1000
	END
	--Capture Inputs
	SET @fromDateString = @inputXML.value('(/DM2ContentIndexing_GetContainersRptReq/@fromTime)[1]', 'varchar(20)')
	SET @ToDateString = @inputXML.value('(/DM2ContentIndexing_GetContainersRptReq/@toTime)[1]', 'varchar(20)')
	SET @fromDate = dbo.GetDateTime(@fromDateString)
	SET @ToDate = dbo.GetDateTime(@ToDateString)
	--Input is UTC. We have been storing local time in DMContainerItem. So convert before compare..
    SELECT @fromDate = dbo.GetLocalTime(@fromDate), @ToDate = dbo.GetLocalTime(@ToDate)
	--DROP and create necessary temp tables..
	IF object_id('tempdb.dbo.#tblContainers') is not null
	DROP TABLE #tblContainers
	--IF object_id('tempdb.dbo.#tblGetContainerRptItem') is not null
	--DROP TABLE #tblGetContainerRptItem
	create table #tblContainers (ContainerID varchar(36), ContainerName nvarchar(MAX))
	--create table #tblGetContainerRptItem (
	--	rowId INT IDENTITY(1,1),
	--	ContainerID VARCHAR(36), ClientID INT, JobId INT, RestoreStatus INT, ERMStatus INT, BackupStatus INT,
	--	CreateTime VARCHAR(20), UserName VARCHAR(128), EmailOrFile VARCHAR(5), Conv VARCHAR(MAX)
	--)
	INSERT INTO #tblContainers
	SELECT T.item.value('@containerGuid', 'VARCHAR(36)') as ContainerID,
			T.item.value('@containerName', 'NVARCHAR(MAX)') as ContainerName
	FROM @inputxml.nodes('/DM2ContentIndexing_GetContainersRptReq/containers') T(item)
	DECLARE @CC INT
	SET @CC = (SELECT COUNT(*) FROM #tblContainers)
	SELECT ContainerID, ClientID, JobId, RestoreStatus, ERMStatus, BackupStatus, CreateTime, UserName, EmailOrFile, Conv FROM
	(
		SELECT *, /*ROW_NUMBER() OVER (ORDER BY DER.ContainerID, DER.CONV) AS ROWNUM,*/
				ROW_NUMBER() OVER (ORDER BY MUserName) AS URowNum
		FROM
		(
			SELECT DISTINCT I.ContainerID, U.ClientID, U.JobId, U.RestoreStatus, U.ERMStatus, LB.BackupStatus,
			CONVERT(CHAR(19), I.CreateTime, 20) AS CreateTime, S.UserName , (CASE WHEN P.IsEmailAppType = 1 THEN 'Email' ELSE 'File' END) AS EmailOrFile,
			(CASE WHEN P.IsEmailAppType = 1 THEN  U.Title  ELSE U.OriginalFullPath END)  AS Conv,
			U.ResultSetID AS ResultSetID,
			(SELECT ISNULL(ContainerName, '') FROM #tblContainers C WHERE I.ContainerID = C.ContainerId) AS ContainerName,
			(CASE CHARINDEX('\', S.UserName) WHEN 0 THEN S.UserName ELSE SUBSTRING(S.UserName, CHARINDEX('\', S.UserName) + 1, LEN(S.UserName) - CHARINDEX('\',S.UserName)) END) AS MUserName
			FROM DMContainerItem I  WITH (READUNCOMMITTED)
			INNER JOIN DMResultSet U WITH (READUNCOMMITTED) ON I.ResultSetID = U.ResultSetID  AND (I.Attribute & 4) != 4
			LEFT  JOIN DMUserSession S WITH (READUNCOMMITTED) ON I.UserGUID = S.UserGUID
			LEFT JOIN DMUIAppTypeMap P WITH (READUNCOMMITTED) ON U.AppType = P.AppTypeId
			LEFT JOIN DMLegalHoldItemsToBackup LB WITH (READUNCOMMITTED) ON LB.ResultSetID = U.ResultSetID -- and LB.JobId = U.JobId
			WHERE  dateadd(minute, datepart(TZoffset, sysdatetimeoffset()), I.CreateTime) < @ToDate and dateadd(minute, datepart(TZoffset, sysdatetimeoffset()), I.CreateTime) >= @fromDate
			and (@CC = 0 OR I.ContainerID in (select ContainerID from #tblContainers))
		) DER
	) TEMP
	WHERE TEMP.URowNum > @offset AND TEMP.URowNum <= @offset + @limit
	ORDER BY TEMP.MUserName, TEMP.ContainerName
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetContainerRptItems')
	delete from GxQscripts where name = 'sp_dm2_GetContainerRptItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetContainerRptItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetContainerRptItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetContainerRptItems',  '00010012000000000000', 'sp_dm2_GetContainerRptItems', '00010012000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetSearchActivityReport.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetSearchActivityReport.sp,v $ $Id: sp_dm2_GetSearchActivityReport.sp,v 1.2 2010/06/09 15:22:51 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetSearchActivityReport <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetSearchActivityReport')
	drop procedure sp_dm2_GetSearchActivityReport
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetSearchActivityReport')
	delete from GxQscripts where name = 'sp_dm2_GetSearchActivityReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetSearchActivityReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetSearchActivityReport'
GO
print '... Creating Procedure: sp_dm2_GetSearchActivityReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetSearchActivityReport
  @inputXML xml
AS
BEGIN
  DECLARE @fromDate DateTime
  DECLARE @ToDate DateTime
  DECLARE @fromDateString varchar(20)
  DECLARE @ToDateString varchar(20)
  DECLARE @offset INT
  DECLARE @limit INT
  DECLARE @debug BIT
	SET NOCOUNT ON
	--should be 1 only for debugging purposes
	SET @debug = 0
	IF @debug = 1
	BEGIN
		SET @limit = 10
		SET @offset = 20
	END
	ELSE
	BEGIN
		SET @limit = @inputXML.value('(DM2ContentIndexing_GetContainersRptReq/pagingConfig/@limit)[1]', 'INT')
		SET @offset = @inputXML.value('(DM2ContentIndexing_GetContainersRptReq/pagingConfig/@offset)[1]', 'INT')
	END
	IF @limit <= 0
	BEGIN
		SET @limit = 1000
	END
	--Capture Inputs
	SET @fromDateString = @inputXML.value('(/DM2ContentIndexing_GetContainersRptReq/@fromTime)[1]', 'varchar(20)')
	SET @ToDateString = @inputXML.value('(/DM2ContentIndexing_GetContainersRptReq/@toTime)[1]', 'varchar(20)')
	SET @fromDate = dbo.GetDateTime(@fromDateString)
	SET @ToDate = dbo.GetDateTime(@ToDateString)
	SELECT QueryID, CreateTime, TotalHits, Query FROM
	(
	SELECT Q.QueryID, createTime = dbo.getUnixTime(Q.CreateTime), Q.TotalHits, Q.Query, ROW_NUMBER() OVER (ORDER BY CreateTime) AS ROWNUM
	FROM DMQuery Q
	WITH (READUNCOMMITTED)
	WHERE Q.CreateTime < @ToDate and Q.CreateTime >= @fromDate
	) TEMP
	WHERE TEMP.ROWNUM > @offset AND TEMP.ROWNUM <= @offset + @limit
	ORDER BY ROWNUM
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetSearchActivityReport')
	delete from GxQscripts where name = 'sp_dm2_GetSearchActivityReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetSearchActivityReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetSearchActivityReport'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetSearchActivityReport',  '00010002000000000000', 'sp_dm2_GetSearchActivityReport', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDMEmailItemTagGUIDs.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDMEmailItemTagGUIDs.sp,v $ $Id: sp_dm2_GetDMEmailItemTagGUIDs.sp,v 1.4 2012/04/02 07:25:44 pbuilder Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDMEmailItemTagGUIDs <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDMEmailItemTagGUIDs')
	drop procedure sp_dm2_GetDMEmailItemTagGUIDs
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDMEmailItemTagGUIDs')
	delete from GxQscripts where name = 'sp_dm2_GetDMEmailItemTagGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMEmailItemTagGUIDs')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMEmailItemTagGUIDs'
GO
print '... Creating Procedure: sp_dm2_GetDMEmailItemTagGUIDs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDMEmailItemTagGUIDs
  @i_xml_Files XML
AS
BEGIN
  DECLARE @@t_Items TABLE (CCId int, AFId bigint, FileOffset bigint) 
	INSERT INTO @@t_Items( CCId, AFId, FileOffset )
	SELECT	T.c.value('@CCId', 'int'),
			T.c.value('@AFId', 'bigint'),
			T.c.value('@aFileOffset', 'bigint')
	FROM @i_xml_Files.nodes('/restlist/file') T(c)
	SELECT T.TagID FROM DMResultSet R
	JOIN @@t_Items I ON R.CommCellNumber = I.CCId AND R.aFileId = I.AFId AND R.aFileOffset = I.FileOffset
	JOIN DMUserItemTags T ON R.ResultSetId = T.ResultSetId  AND (T.Attribute & 4)= 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDMEmailItemTagGUIDs')
	delete from GxQscripts where name = 'sp_dm2_GetDMEmailItemTagGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMEmailItemTagGUIDs')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMEmailItemTagGUIDs'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDMEmailItemTagGUIDs',  '00010004000000000000', 'sp_dm2_GetDMEmailItemTagGUIDs', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDMFileItemTagGUIDs.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDMFileItemTagGUIDs.sp,v $ $Id: sp_dm2_GetDMFileItemTagGUIDs.sp,v 1.3 2010/04/30 17:58:21 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDMFileItemTagGUIDs <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDMFileItemTagGUIDs')
	drop procedure sp_dm2_GetDMFileItemTagGUIDs
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDMFileItemTagGUIDs')
	delete from GxQscripts where name = 'sp_dm2_GetDMFileItemTagGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMFileItemTagGUIDs')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMFileItemTagGUIDs'
GO
print '... Creating Procedure: sp_dm2_GetDMFileItemTagGUIDs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDMFileItemTagGUIDs
  @i_xml_Files XML
AS
BEGIN
	SELECT T.TagId FROM
	(
		SELECT	T.c.value('@CCId', 'int') AS CCId,
			T.c.value('@AFId', 'bigint') AS AFId,
			T.c.value('@OrigPath', 'nvarchar(max)') AS OrigPath
		FROM @i_xml_Files.nodes('/restlist/file') T(c)
	) Tmp
	JOIN DMResultSet R ON R.CommCellNumber = Tmp.CCId AND R.aFileId = Tmp.AFId AND R.OriginalFullPath = Tmp.OrigPath
	JOIN DMUserItemTags T ON R.ResultSetId = T.ResultSetId AND (T.Attribute & 4)= 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDMFileItemTagGUIDs')
	delete from GxQscripts where name = 'sp_dm2_GetDMFileItemTagGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMFileItemTagGUIDs')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMFileItemTagGUIDs'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDMFileItemTagGUIDs',  '00010003000000000000', 'sp_dm2_GetDMFileItemTagGUIDs', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDMJob.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDMJob.sp,v $ $Id: sp_dm2_GetDMJob.sp,v 1.3 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDMJob <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDMJob')
	drop procedure sp_dm2_GetDMJob
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDMJob')
	delete from GxQscripts where name = 'sp_dm2_GetDMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMJob'
GO
print '... Creating Procedure: sp_dm2_GetDMJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDMJob
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_JobID varchar(36) = '',
  @i_SessionID varchar(24) = '',
  @i_UserGUID varchar(36) = '',
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = '',
  @i_Progress int = 0,
  @i_StartTime varchar(50) = '',
  @i_EndTime varchar(50) = '',
  @i_Attribute int = 0
AS
  DECLARE @o_JobID char(36);
  DECLARE @o_JobType int;
  DECLARE @o_JobState int;
  DECLARE @o_SessionID varchar(50);
  DECLARE @o_UserGUID varchar(36);
  DECLARE @o_ContainerID varchar(36);
  DECLARE @o_ResultSetID varchar(36);
  DECLARE @o_Arguments nvarchar(max);
  DECLARE @o_Progress int;
  DECLARE @o_PendingReason nvarchar(max);
  DECLARE @o_Results nvarchar(max);
  DECLARE @o_StartTime datetime;
  DECLARE @o_EndTime datetime;
  DECLARE @o_Attribute int;
SET NOCOUNT ON
  if len(@i_ResultSetID) > 0
  begin
    select top 1 * from DMJob WITH (READUNCOMMITTED)
	where ResultSetID = @i_ResultSetID
	and JobState in (2, 3)
	order by JobState, StartTime desc
	goto done
  end
  if len(@i_ContainerID) > 0
  begin
    select top 1 * from DMJob WITH (READUNCOMMITTED)
	where ContainerID = @i_ContainerID
	and JobState in (2, 3)
	order by JobState, StartTime desc
	goto done
  end
  if len(@i_JobID) > 0
  begin
    select top 1 * from DMJob WITH (READUNCOMMITTED)
	where JobID = @i_JobID
	and JobState in (2, 3)
	order by JobState, StartTime desc
	goto done
  end
  declare @i_StartRN int
  declare @i_EndRN int
  if (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
  begin
	set @i_StartRN = 1
	set @i_EndRN = (select count(JobID)
				  from DMJob WITH (READUNCOMMITTED)
				  where (len(@i_SessionID) = 0 or SessionID = @i_SessionID)
				  and (len(@i_UserGUID) = 0 or UserGUID = @i_UserGUID)
				  and (@i_Progress = 0 or Progress = @i_Progress)
				  and (@i_Attribute = 0 or (Attribute & @i_Attribute) = @i_Attribute)
				  and (@i_StartTime = null or StartTime >= @i_StartTime)
				  and (@i_EndTime = null or EndTime <= @i_EndTime))
  end
  else
  begin
	set @i_StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
	set @i_EndRN = @i_NumPages * @i_ItemsOnPage + @i_StartRN - 1
  end
	exec ('WITH [dm2_GetDMJob] AS
	(SELECT J.*, ROW_NUMBER() OVER (order by StartTime) as RowNumber
	FROM DMJob AS J WITH (READUNCOMMITTED)
	  where (len(''' + @i_SessionID + ''') = 0 or SessionID = ''' + @i_SessionID + ''')
	  and (len(''' + @i_UserGUID + ''') = 0 or UserGUID = ''' + @i_UserGUID + ''')
	  and (len(''' + @i_StartTime + ''') = 0 or datediff(d, StartTime, cast(''' + @i_StartTime + ''' as datetime)) >= 0)
	  and (len(''' + @i_EndTime + ''') = 0 or datediff(d, cast(''' + @i_EndTime + ''' as datetime), EndTime) >= 0)
	  and (' + @i_Progress + ' = 0 or Progress = ' + @i_Progress + ')
	  and (' + @i_Attribute + ' = 0 or (Attribute & ' + @i_Attribute + ') = ' + @i_Attribute + '))
	SELECT *
	FROM [dm2_GetDMJob]
	WHERE RowNumber between ' + @i_StartRN + ' and ' + @i_EndRN)
done:
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDMJob')
	delete from GxQscripts where name = 'sp_dm2_GetDMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMJob'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDMJob',  '00010003000000000000', 'sp_dm2_GetDMJob', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDMLegalHoldItemsMetaData.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDMLegalHoldItemsMetaData.sp,v $ $Id: sp_dm2_GetDMLegalHoldItemsMetaData.sp,v 1.3 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDMLegalHoldItemsMetaData <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDMLegalHoldItemsMetaData')
	drop procedure sp_dm2_GetDMLegalHoldItemsMetaData
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDMLegalHoldItemsMetaData')
	delete from GxQscripts where name = 'sp_dm2_GetDMLegalHoldItemsMetaData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMLegalHoldItemsMetaData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMLegalHoldItemsMetaData'
GO
print '... Creating Procedure: sp_dm2_GetDMLegalHoldItemsMetaData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDMLegalHoldItemsMetaData
  @i_JobId integer	= 0,
  @i_CommCellId integer	= 0,
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = ''
AS
  DECLARE @o_MetaDataXML nvarchar(max);
SET NOCOUNT ON
SELECT 	MetaDataXML
FROM 		DMLegalHoldItemsToBackup WITH (READUNCOMMITTED)
WHERE 	JobId = @i_JobId
AND 		CommCellId = @i_CommCellId
AND			ContainerID = @i_ContainerID
AND			ResultSetID = @i_ResultSetID
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDMLegalHoldItemsMetaData')
	delete from GxQscripts where name = 'sp_dm2_GetDMLegalHoldItemsMetaData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMLegalHoldItemsMetaData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMLegalHoldItemsMetaData'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDMLegalHoldItemsMetaData',  '00010003000000000000', 'sp_dm2_GetDMLegalHoldItemsMetaData', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDMLegalHoldItemsToBackup.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDMLegalHoldItemsToBackup.sp,v $ $Id: sp_dm2_GetDMLegalHoldItemsToBackup.sp,v 1.2 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDMLegalHoldItemsToBackup <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDMLegalHoldItemsToBackup')
	drop procedure sp_dm2_GetDMLegalHoldItemsToBackup
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDMLegalHoldItemsToBackup')
	delete from GxQscripts where name = 'sp_dm2_GetDMLegalHoldItemsToBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMLegalHoldItemsToBackup')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMLegalHoldItemsToBackup'
GO
print '... Creating Procedure: sp_dm2_GetDMLegalHoldItemsToBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDMLegalHoldItemsToBackup
  @i_JobId integer	= 0,
  @i_CommCellId integer	= 0,
  @i_StartIndex integer	= 0,
  @i_Count integer	= 100
AS
  DECLARE @o_MetaDataXML xml;
SET NOCOUNT ON
declare 	@EndRN 	integer
set 		@EndRN = @i_Count + @i_StartIndex - 1
--Update the OriginalPath from DMResultSet table
--as power restore job may have updated the restore path
IF @i_StartIndex = 1
BEGIN
	UPDATE	DMLegalHoldItemsToBackup
	SET 		OriginalPath = RS.destinationPath
	FROM 		DMLegalHoldItemsToBackup LH, DMResultSet RS
	WHERE 	LH.ResultSetID = RS.ResultSetID
	AND			LH.JobId = @i_JobId
	AND			LH.CommCellId = @i_CommCellId
	AND 		LEN(LH.ResultSetID) > 0
	--AND (LH.OriginalPath IS NULL OR LEN(LH.OriginalPath) = 0)
END
-- The MegaXML file will be fetched from different SP
exec ('WITH [dm2_GetDMLegalHoldItemsToBackup] AS
(SELECT ContainerID, ResultSetID, OriginalPath, BackupPath, ROW_NUMBER() OVER (order by BackupPath asc) as RowNumber
FROM [DMLegalHoldItemsToBackup]	WITH (READUNCOMMITTED)
WHERE (JobId = ' +  @i_JobId + ' AND CommCellId = ' + @i_CommCellId + ' AND len(OriginalPath) > 0 AND len(ContainerID) > 0))
SELECT DISTINCT ContainerID, ResultSetID, OriginalPath, BackupPath
FROM [dm2_GetDMLegalHoldItemsToBackup] WITH (READUNCOMMITTED)
WHERE RowNumber BETWEEN ' + @i_StartIndex + ' AND ' + @EndRN)
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDMLegalHoldItemsToBackup')
	delete from GxQscripts where name = 'sp_dm2_GetDMLegalHoldItemsToBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMLegalHoldItemsToBackup')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMLegalHoldItemsToBackup'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDMLegalHoldItemsToBackup',  '00010002000000000000', 'sp_dm2_GetDMLegalHoldItemsToBackup', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDMLegalHoldXMLFileToBackup.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDMLegalHoldXMLFileToBackup.sp,v $ $Id: sp_dm2_GetDMLegalHoldXMLFileToBackup.sp,v 1.4 2010/05/12 21:27:43 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDMLegalHoldXMLFileToBackup <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDMLegalHoldXMLFileToBackup')
	drop procedure sp_dm2_GetDMLegalHoldXMLFileToBackup
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDMLegalHoldXMLFileToBackup')
	delete from GxQscripts where name = 'sp_dm2_GetDMLegalHoldXMLFileToBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMLegalHoldXMLFileToBackup')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMLegalHoldXMLFileToBackup'
GO
print '... Creating Procedure: sp_dm2_GetDMLegalHoldXMLFileToBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDMLegalHoldXMLFileToBackup
  @i_JobId integer	= 0,
  @i_CommCellId integer	= 0
AS
  DECLARE @o_ContainerID integer;
  DECLARE @o_ResultSetID integer;
  DECLARE @o_OriginalPath integer;
  DECLARE @o_BackupPath integer;
SET NOCOUNT ON
SET ANSI_NULLS ON
SELECT ContainerID, ResultSetID, OriginalPath, BackupPath
FROM DMLegalHoldItemsToBackup WITH (READUNCOMMITTED)
WHERE JobId = @i_JobId
AND CommCellId = @i_CommCellId
AND len(OriginalPath) > 0
AND len(ContainerID) = 0
AND BackupPath LIKE '%LegalHoldItems_%.xml%'
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDMLegalHoldXMLFileToBackup')
	delete from GxQscripts where name = 'sp_dm2_GetDMLegalHoldXMLFileToBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMLegalHoldXMLFileToBackup')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMLegalHoldXMLFileToBackup'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDMLegalHoldXMLFileToBackup',  '00010004000000000000', 'sp_dm2_GetDMLegalHoldXMLFileToBackup', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadResultSet.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadResultSet.sp,v $ $Id: sp_dm2_GetDownloadResultSet.sp,v 1.6 2014/05/20 12:45:56 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDownloadResultSet <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadResultSet')
	drop procedure sp_dm2_GetDownloadResultSet
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadResultSet'
GO
print '... Creating Procedure: sp_dm2_GetDownloadResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownloadResultSet
  @i_UserGUID varchar(36) = '',
  @i_DownLoadID varchar(36) = '',
  @i_ContainerID varchar(36) = '',
  @i_RestoreJobID int = 0,
  @i_Attribute int = -1,
  @i_offset int = 0,
  @i_limit int = 10000
AS
  DECLARE @o_DownLoadID char(36);
  DECLARE @o_ResultSetID char(36);
  DECLARE @o_AppType integer;
  DECLARE @o_Status integer;
  DECLARE @o_CreateTime datetime;
  DECLARE @o_DestinationPath nvarchar(max);
SET NOCOUNT ON
if len(@i_DownLoadID) = 0
begin
	select a.DownloadID,a.ResultSetID,a.AppType,a.Status,a.CreateTime,a.FileName, a.[FileName] as DestinationPath
	from DMDownloadResultSet a WITH (READUNCOMMITTED), DMResultSet b WITH (READUNCOMMITTED)
	where a.DownloadID in (
		select DownloadID from DMDownload WITH (READUNCOMMITTED)
		where (len(@i_UserGUID) = 0 or UserGUID = @i_UserGUID)
		and (len(@i_ContainerID) = 0 or ContainerID = @i_ContainerID)
		and (len(@i_Attribute) < 0 or (Attribute & @i_Attribute) = @i_Attribute)
		and (@i_RestoreJobID = 0 or RestoreJobID = @i_RestoreJobID)
	)
end
else
begin
	--TODO:we need to impelment paging here
	IF @i_limit <= 0
    BEGIN
        SET @i_limit = 10000
    END
	select DownloadID,ResultSetID,AppType,Status,CreateTime,FileName, DestinationPath FROM
	(
		select a.DownloadID,a.ResultSetID,a.AppType,a.Status,a.CreateTime,a.FileName, a.[FileName] as DestinationPath, ROW_NUMBER() OVER (ORDER BY CreateTime) AS ROWNUM
		from DMDownloadResultSet a WITH (READUNCOMMITTED)
		where a.DownloadID = @i_DownloadID
	)TEMP
    WHERE TEMP.ROWNUM > @i_offset AND TEMP.ROWNUM <= @i_offset + @i_limit
    ORDER BY ROWNUM
end
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadResultSet',  '00010006000000000000', 'sp_dm2_GetDownloadResultSet', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownload.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownload.sp,v $ $Id: sp_dm2_GetDownload.sp,v 1.6 2012/07/02 14:42:57 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDownload <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownload')
	drop procedure sp_dm2_GetDownload
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownload')
	delete from GxQscripts where name = 'sp_dm2_GetDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownload')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownload'
GO
print '... Creating Procedure: sp_dm2_GetDownload'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownload
  @i_UserGUID varchar(36) = '',
  @i_DownLoadID varchar(36) = '',
  @i_ContainerID varchar(36) = '',
  @i_RestoreJobID int = 0,
  @i_Attribute int = -1,
  @i_Description nvarchar(max) = '',
  @i_DownLoadSetID varchar(36) = ''
AS
SET NOCOUNT ON
select * from DMDownload WITH (READUNCOMMITTED)
where (len(@i_UserGUID) = 0 or UserGUID = @i_UserGUID)
and (len(@i_DownloadID) = 0 or DownloadID = @i_DownloadID)
and (len(@i_ContainerID) = 0 or ContainerID = @i_ContainerID)
and (@i_Attribute < 0 or (Attribute & @i_Attribute) = @i_Attribute)
and (@i_RestoreJobID = 0 or RestoreJobID = @i_RestoreJobID)
and (len(@i_Description) = 0 or Description = @i_Description)
and (LEN(@i_DownLoadSetID) = 0 or DownLoadSetID = @i_DownLoadSetID)
order by Description
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownload')
	delete from GxQscripts where name = 'sp_dm2_GetDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownload')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownload'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownload',  '00010006000000000000', 'sp_dm2_GetDownload', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetItemReport.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetItemReport.sp,v $ $Id: sp_dm2_GetItemReport.sp,v 1.2 2008/08/28 15:38:06 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetItemReport <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetItemReport')
	drop procedure sp_dm2_GetItemReport
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetItemReport')
	delete from GxQscripts where name = 'sp_dm2_GetItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetItemReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetItemReport'
GO
print '... Creating Procedure: sp_dm2_GetItemReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetItemReport
  @operationType INT,
  @jobId INT,
  @status INT
AS
SELECT ISNULL(itemInfo.value('(/DM2ContentIndexing_DMItemInfo/@fileNameConv)[1]', 'varchar(2048)'), '') AS FileNameConv,
ISNULL(itemInfo.value('(DM2ContentIndexing_DMItemInfo/@clientId)[1]', 'bigint'), 0) AS ClientId,
ISNULL(itemInfo.value('(DM2ContentIndexing_DMItemInfo/@appType)[1]', 'int'), 0) AS AppType,
ISNULL(itemInfo.value('(DM2ContentIndexing_DMItemInfo/@sizeKB)[1]', 'bigint'),0) AS SizeKB,
[status], errCode, ISNULL(UserName, '') AS UserName, ISNULL(CommCellNumber, 0) AS CommCellNumber
FROM DMItemReport
WHERE (@operationType = -1 OR OperationType = @operationType) AND
(@jobId = -1 OR JobId = @jobId) AND
(@status = -1 OR @status = [status])
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetItemReport')
	delete from GxQscripts where name = 'sp_dm2_GetItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetItemReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetItemReport'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetItemReport',  '00010002000000000000', 'sp_dm2_GetItemReport', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldResultSet.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldResultSet.sp,v $ $Id: sp_dm2_GetLegalHoldResultSet.sp,v 1.8 2010/11/18 14:45:03 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetLegalHoldResultSet <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetLegalHoldResultSet')
	drop procedure sp_dm2_GetLegalHoldResultSet
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetLegalHoldResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldResultSet'
GO
print '... Creating Procedure: sp_dm2_GetLegalHoldResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetLegalHoldResultSet
  @i_CompPolicyID varchar(36),
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_OrderByClause nvarchar(max) = 'modifiedTime',
  @i_BackupStatus varchar(30) = 'SUCCESS',
  @i_GetEmailsFlag bit = 1,
  @i_GetFilesFlag bit = 1,
  @i_offset int = 0
AS
SET NOCOUNT ON
DECLARE @StartRN INT
DECLARE @EndRN INT
--Changes to support both the pagination retrieval
-- through the pagenumber and offset
IF(@i_offset <= 0)
BEGIN
	IF (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
	BEGIN
		SET @StartRN = 1
		SET @EndRN = -1
	END
	ELSE
	BEGIN
		SET @StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
		SET @EndRN = @i_NumPages * @i_ItemsOnPage + @StartRN - 1
	END
END
ELSE
BEGIN
	IF(@i_ItemsOnPage) <= 0
	BEGIN
		SET @StartRN = @i_offset
		SET @EndRN = -1
	END
	ELSE
	BEGIN
		SET @StartRN = @i_Offset
		SET @EndRN = @i_offset + @i_ItemsOnPage - 1
	END
END
IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = '#tblGetLegalHoldItems')
	DROP TABLE #tblGetLegalHoldItems
CREATE TABLE #tblGetLegalHoldItems
(
	ContainerID 	VARCHAR(36),
	ResultSetID 	VARCHAR(36),
	LHJobID 			INT,
	LHCommCellID 	INT,
	BackupStatus 	INT
)
IF (@i_BackupStatus = 'FAILED')
BEGIN
	INSERT INTO #tblGetLegalHoldItems
	SELECT DISTINCT LH.ContainerID, LH.ResultSetID, LH.JobId, LH.CommCellId, LH.BackupStatus
	FROM dmLegalHoldItemsToBackup LH WITH (NOLOCK), DMUIAppTypeMap AT WITH (NOLOCK)
	WHERE LH.CompPolicyId = @i_CompPolicyID
	AND		LH.BackupStatus <> 1
	AND		LH.AppType = AT.AppTypeId
	AND		(AT.IsEmailAppType = CONVERT(VARCHAR, @i_GetEmailsFlag) OR
			 AT.IsFileAppType = CONVERT(VARCHAR, @i_GetFilesFlag))
END
ELSE IF (@i_BackupStatus = 'SUCCESS')
BEGIN
	INSERT INTO #tblGetLegalHoldItems
	SELECT DISTINCT LH.ContainerID, LH.ResultSetID, LH.JobId, LH.CommCellId, LH.BackupStatus
	FROM dmLegalHoldItemsToBackup LH WITH (NOLOCK), DMUIAppTypeMap AT WITH (NOLOCK)
	WHERE LH.CompPolicyId = @i_CompPolicyID
	AND		LH.BackupStatus = 1
	AND		LH.AppType = AT.AppTypeId
	AND		(AT.IsEmailAppType = CONVERT(VARCHAR, @i_GetEmailsFlag) OR
			 AT.IsFileAppType = CONVERT(VARCHAR, @i_GetFilesFlag))
END
ELSE
BEGIN
	INSERT INTO #tblGetLegalHoldItems
	SELECT DISTINCT LH.ContainerID, LH.ResultSetID, LH.JobId, LH.CommCellId, LH.BackupStatus
	FROM dmLegalHoldItemsToBackup LH WITH (NOLOCK), DMUIAppTypeMap AT WITH (NOLOCK)
	WHERE LH.CompPolicyId = @i_CompPolicyID
	AND		LH.AppType = AT.AppTypeId
	AND		(AT.IsEmailAppType = CONVERT(VARCHAR, @i_GetEmailsFlag) OR
			 AT.IsFileAppType = CONVERT(VARCHAR, @i_GetFilesFlag))
END
if @EndRN < 0 	select @EndRN = count(*) from #tblGetLegalHoldItems
EXEC ('WITH [dm2_GetLegalHoldItems] AS
(SELECT DISTINCT LH.*, ROW_NUMBER() OVER (order by LH.' + @i_OrderByClause + ') as RowNumber
FROM #tblGetLegalHoldItems AS T, dmLegalHoldItemsToBackup LH WITH (NOLOCK)
WHERE T.ContainerID = LH.ContainerID
AND		T.ResultSetID = LH.ResultSetID
AND		T.LHJobID = LH.JobId
AND		T.LHCommCellID = CommCellId
)
SELECT *
FROM [dm2_GetLegalHoldItems]
WHERE RowNumber between ' + @StartRN + ' and ' + @EndRN + ' ORDER BY RowNumber ')
drop table #tblGetLegalHoldItems
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetLegalHoldResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetLegalHoldResultSet',  '00010008000000000000', 'sp_dm2_GetLegalHoldResultSet', '00010008000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldItemsSize.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldItemsSize.sp,v $ $Id: sp_dm2_GetLegalHoldItemsSize.sp,v 1.4 2014/09/23 12:56:54 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetLegalHoldItemsSize <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetLegalHoldItemsSize')
	drop procedure sp_dm2_GetLegalHoldItemsSize
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetLegalHoldItemsSize')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldItemsSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldItemsSize')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldItemsSize'
GO
print '... Creating Procedure: sp_dm2_GetLegalHoldItemsSize'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetLegalHoldItemsSize
  @i_CompPolicyID varchar(36),
  @i_BackupStatus varchar(30) = 'SUCCESS'
AS
SET NOCOUNT ON
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE NAME = '#tblGetLegalHoldItemsSize')
	DROP TABLE #tblGetLegalHoldItemsSize
CREATE TABLE #tblGetLegalHoldItemsSize (ContainerID VARCHAR(36), ResultSetID VARCHAR(36), LHJobID INT, LHCommCellID INT, BackupStatus INT, FileSizeKB FLOAT)
IF (@i_BackupStatus = 'FAILED')
BEGIN
	INSERT 	INTO #tblGetLegalHoldItemsSize
	SELECT 	DISTINCT LH.ContainerID, LH.ResultSetID, LH.JobId, LH.CommCellId, LH.BackupStatus, 0
	FROM 		 dmLegalHoldItemsToBackup LH	 WITH (READUNCOMMITTED)
  WHERE 	LH.CompPolicyId = @i_CompPolicyID
  AND			LH.BackupStatus <> 1
  AND         LEN(LH.ResultSetID) > 0
END
ELSE IF (@i_BackupStatus = 'SUCCESS')
BEGIN
	INSERT 	INTO #tblGetLegalHoldItemsSize
	SELECT 	DISTINCT LH.ContainerID, LH.ResultSetID, LH.JobId, LH.CommCellId, LH.BackupStatus, 0
	FROM 		 dmLegalHoldItemsToBackup LH	WITH (READUNCOMMITTED)
  WHERE 	LH.CompPolicyId = @i_CompPolicyID
  AND			LH.BackupStatus = 1
  AND         LEN(LH.ResultSetID) > 0
END
ELSE
BEGIN
	INSERT 	INTO #tblGetLegalHoldItemsSize
	SELECT 	DISTINCT LH.ContainerID, LH.ResultSetID, LH.JobId, LH.CommCellId, LH.BackupStatus, 0
	FROM 		dmLegalHoldItemsToBackup LH WITH (READUNCOMMITTED)
  WHERE 	LH.CompPolicyId = @i_CompPolicyID
  AND         LEN(LH.ResultSetID) > 0
END
UPDATE #tblGetLegalHoldItemsSize
SET FileSizeKB = RS.FileSizeKB
FROM #tblGetLegalHoldItemsSize T, DMResultSet RS
WHERE T.ResultSetId = RS.ResultSetId
SELECT ISNULL(SUM(FileSizeKB), 0) AS TotalSizeKB
FROM #tblGetLegalHoldItemsSize
drop table #tblGetLegalHoldItemsSize
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetLegalHoldItemsSize')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldItemsSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldItemsSize')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldItemsSize'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetLegalHoldItemsSize',  '00010004000000000000', 'sp_dm2_GetLegalHoldItemsSize', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldResultSetCount.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldResultSetCount.sp,v $ $Id: sp_dm2_GetLegalHoldResultSetCount.sp,v 1.5 2014/09/23 12:57:00 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetLegalHoldResultSetCount <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetLegalHoldResultSetCount')
	drop procedure sp_dm2_GetLegalHoldResultSetCount
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetLegalHoldResultSetCount')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldResultSetCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldResultSetCount')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldResultSetCount'
GO
print '... Creating Procedure: sp_dm2_GetLegalHoldResultSetCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetLegalHoldResultSetCount
  @i_CompPolicyID varchar(36),
  @i_BackupStatus varchar(30) = 'SUCCESS',
  @i_GetEmailsFlag bit = 1,
  @i_GetFilesFlag bit = 1
AS
  DECLARE @o_TotalCount integer;
SET NOCOUNT ON
DECLARE @TotalCount INTEGER
SET			@TotalCount = 0
IF (@i_BackupStatus = 'FAILED')
BEGIN
	SELECT 	@TotalCount = COUNT (DISTINCT CONVERT(varchar(36), LH.ContainerID) + CONVERT(varchar(36), LH.ResultSetID) + CONVERT(varchar(12), LH.JobId) + CONVERT(varchar(12), LH.CommCellId) + CONVERT(varchar(10), LH.BackupStatus))
	FROM 	dmLegalHoldItemsToBackup LH   WITH (READUNCOMMITTED), DMUIAppTypeMap AT WITH (READUNCOMMITTED)
	WHERE 	LH.CompPolicyId = @i_CompPolicyID
	AND		LH.BackupStatus <> 1
	AND		LH.AppType = AT.AppTypeId
	AND     LEN(LH.ResultSetID) > 0
	AND		(AT.IsEmailAppType = CONVERT(VARCHAR, @i_GetEmailsFlag) OR
			 AT.IsFileAppType = CONVERT(VARCHAR, @i_GetFilesFlag))
END
ELSE IF (@i_BackupStatus = 'SUCCESS')
BEGIN
	SELECT 	@TotalCount = COUNT (DISTINCT CONVERT(varchar(36), LH.ContainerID) + CONVERT(varchar(36), LH.ResultSetID) + CONVERT(varchar(12), LH.JobId) + CONVERT(varchar(12), LH.CommCellId) + CONVERT(varchar(10), LH.BackupStatus))
	FROM 	dmLegalHoldItemsToBackup LH	WITH (READUNCOMMITTED),	DMUIAppTypeMap AT WITH (READUNCOMMITTED)
	WHERE 	LH.CompPolicyId = @i_CompPolicyID
	AND		LH.BackupStatus = 1
	AND		LH.AppType = AT.AppTypeId
	AND     LEN(LH.ResultSetID) > 0
	AND		(AT.IsEmailAppType = CONVERT(VARCHAR, @i_GetEmailsFlag) OR
			 AT.IsFileAppType = CONVERT(VARCHAR, @i_GetFilesFlag))
END
ELSE
BEGIN
	SELECT 	@TotalCount = COUNT (DISTINCT CONVERT(varchar(36), LH.ContainerID) + CONVERT(varchar(36), LH.ResultSetID) + CONVERT(varchar(12), LH.JobId) + CONVERT(varchar(12), LH.CommCellId) + CONVERT(varchar(10), LH.BackupStatus))
	FROM 	dmLegalHoldItemsToBackup LH	 WITH (READUNCOMMITTED), DMUIAppTypeMap AT WITH (READUNCOMMITTED)
	WHERE 	LH.CompPolicyId = @i_CompPolicyID
	AND		LH.AppType = AT.AppTypeId
	AND     LEN(LH.ResultSetID) > 0
	AND		(AT.IsEmailAppType = CONVERT(VARCHAR, @i_GetEmailsFlag) OR
			 AT.IsFileAppType = CONVERT(VARCHAR, @i_GetFilesFlag))
END
SELECT @TotalCount AS TotalCount
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetLegalHoldResultSetCount')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldResultSetCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldResultSetCount')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldResultSetCount'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetLegalHoldResultSetCount',  '00010005000000000000', 'sp_dm2_GetLegalHoldResultSetCount', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetNonRestoredItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetNonRestoredItems.sp,v $ $Id: sp_dm2_GetNonRestoredItems.sp,v 1.5 2008/09/17 14:42:31 tchatterjee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetNonRestoredItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetNonRestoredItems')
	drop procedure sp_dm2_GetNonRestoredItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetNonRestoredItems')
	delete from GxQscripts where name = 'sp_dm2_GetNonRestoredItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetNonRestoredItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetNonRestoredItems'
GO
print '... Creating Procedure: sp_dm2_GetNonRestoredItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetNonRestoredItems
  @i_ResultSetIDList varchar(max) = '',
  @i_ContainerId varchar(128),
  @i_isCompliancePolicy integer
AS
SET NOCOUNT ON
declare @queryStr varchar(max)
IF(len(@i_ResultSetIDList) = 0)
BEGIN
	IF @i_isCompliancePolicy = 1
	set @queryStr = 'SELECT RS.*, RSI.ResultSet, ISNULL(UC.Comment, '''') as UserComments FROM DMResultSet AS RS WITH (READUNCOMMITTED), DMResultSetInfo AS RSI WITH (READUNCOMMITTED), DMContainerItem AS CI WITH (READUNCOMMITTED) LEFT OUTER JOIN DMUserComment AS UC WITH (READUNCOMMITTED) ON UC.ContainerId = CI.ContainerId AND UC.ResultSetId = CI.ResultSetId WHERE CI.ContainerId = ' + @i_ContainerId + ' AND CI.ResultSetId = RS.ResultSetId AND RS.ResultSetId = RSI.ResultSetId AND (CI.Attribute & 32) = 32 AND (CI.Attribute & 4) = 0'
	ELSE
	set @queryStr = 'SELECT RS.*, RSI.ResultSet, ISNULL(UC.Comment, '''') as UserComments FROM DMResultSet AS RS WITH (READUNCOMMITTED), DMResultSetInfo AS RSI WITH (READUNCOMMITTED), DMContainerItem AS CI WITH (READUNCOMMITTED) LEFT OUTER JOIN DMUserComment AS UC WITH (READUNCOMMITTED) ON UC.ContainerId = CI.ContainerId AND UC.ResultSetId = CI.ResultSetId WHERE CI.ContainerId = ' + @i_ContainerId + ' AND CI.ResultSetId = RS.ResultSetId AND RS.ResultSetId = RSI.ResultSetId AND (CI.Attribute & 4) = 0'
	EXEC(@queryStr)
END
ELSE
BEGIN
	IF @i_isCompliancePolicy = 1
	set @queryStr = 'SELECT RS.*, RSI.ResultSet, ISNULL(UC.Comment, '''') as UserComments FROM DMResultSet AS RS WITH (READUNCOMMITTED), DMResultSetInfo AS RSI WITH (READUNCOMMITTED), DMContainerItem AS CI WITH (READUNCOMMITTED) LEFT OUTER JOIN DMUserComment AS UC WITH (READUNCOMMITTED) ON UC.ContainerId = CI.ContainerId AND UC.ResultSetId = CI.ResultSetId WHERE CI.ContainerId = ' + @i_ContainerId + ' AND CI.ResultSetId IN ' +  @i_ResultSetIDList + ' AND CI.ResultSetId = RS.ResultSetId AND RS.ResultSetId = RSI.ResultSetId AND (CI.Attribute & 32) = 32 AND (CI.Attribute & 4) = 0'
	ELSE
	set @queryStr = 'SELECT RS.*, RSI.ResultSet, ISNULL(UC.Comment, '''') as UserComments FROM DMResultSet AS RS WITH (READUNCOMMITTED), DMResultSetInfo AS RSI WITH (READUNCOMMITTED), DMContainerItem AS CI WITH (READUNCOMMITTED) LEFT OUTER JOIN DMUserComment AS UC WITH (READUNCOMMITTED) ON UC.ContainerId = CI.ContainerId AND UC.ResultSetId = CI.ResultSetId WHERE CI.ContainerId = ' + @i_ContainerId + ' AND CI.ResultSetId IN ' +  @i_ResultSetIDList + ' AND CI.ResultSetId = RS.ResultSetId AND RS.ResultSetId = RSI.ResultSetId AND (CI.Attribute & 4) = 0'
	EXEC(@queryStr)
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetNonRestoredItems')
	delete from GxQscripts where name = 'sp_dm2_GetNonRestoredItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetNonRestoredItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetNonRestoredItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetNonRestoredItems',  '00010005000000000000', 'sp_dm2_GetNonRestoredItems', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetQuery.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetQuery.sp,v $ $Id: sp_dm2_GetQuery.sp,v 1.3 2009/11/23 22:06:21 sabdulrahman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetQuery <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetQuery')
	drop procedure sp_dm2_GetQuery
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetQuery')
	delete from GxQscripts where name = 'sp_dm2_GetQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetQuery'
GO
print '... Creating Procedure: sp_dm2_GetQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetQuery
  @i_UserGUID varchar(36) = '',
  @i_SessionID varchar(24) = '',
  @i_QueryID varchar(36) = '',
  @i_QueryName nvarchar(1024) = '',
  @i_Attribute int = 0,
  @i_CommServContainerGuid varchar(36) = ''
AS
  DECLARE @o_QueryID char(36);
  DECLARE @o_UserGUID char(36);
  DECLARE @o_SessionID char(24);
  DECLARE @o_QueryName nvarchar(1024);
  DECLARE @o_SearchTerms nvarchar(1024);
  DECLARE @o_Query nvarchar(max);
  DECLARE @o_CreateTime datetime;
  DECLARE @o_Attribute integer;
  DECLARE @o_Comments nvarchar(max);
  DECLARE @o_CommentsTime datetime;
  DECLARE @o_QuerySummary nvarchar(max);
SET NOCOUNT ON
  select * from [DMQuery]	 WITH (READUNCOMMITTED)
  where (len(@i_QueryID) = 0 or [QueryID] = @i_QueryID)
  and (len(@i_SessionID) = 0 or [SessionID] = @i_SessionID)
  and (len(@i_UserGUID) = 0 or UserGUID = @i_UserGUID)
  and (len(@i_QueryName) = 0 or [QueryName] = @i_QueryName)
  and (len(@i_CommServContainerGuid) = 0 or [CommServContainerGuid] =  @i_CommServContainerGuid)
  and (Attribute & 2) = 0
  and (@i_Attribute = 0 or (Attribute & @i_Attribute) = @i_Attribute)
	ORDER BY QueryName
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetQuery')
	delete from GxQscripts where name = 'sp_dm2_GetQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetQuery'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetQuery',  '00010003000000000000', 'sp_dm2_GetQuery', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetQueries.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetQueries.sp,v $ $Id: sp_dm2_GetQueries.sp,v 1.3 2010/04/14 11:55:34 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetQueries <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetQueries')
	drop procedure sp_dm2_GetQueries
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetQueries')
	delete from GxQscripts where name = 'sp_dm2_GetQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetQueries')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetQueries'
GO
print '... Creating Procedure: sp_dm2_GetQueries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetQueries
  @i_UserGUID char(36),
  @i_Attribute int,                        -- Supply @i_Attribute = 0 if you do not want to filter by attribute
  @i_CommServContainerGuid char(36) = '',	-- Supply @i_CommServContainerGuid = '' if you do not want to filter by CommServContainerGuid
  @i_Offset integer = 0,					-- Supply @i_Offset = -1 if you do not want paging
  @i_Limit integer = 10,					-- Supply @i_Limit = -1 if you do not want paging
  @i_IsLegacyQuery integer = -1,		-- Supply @i_IsLegacyQuery = 0 if you do not want to filter by LegacyQueryStatus. If legacy query status = 1, then it means it is of older release: i.e., 8.0 or 7.0 and If legacy query status = 0, it means it is of latest release (9.0). For 10.0, again this status has to change or go away.
  @i_OrderByClause nvarchar(max) = '',
  @o_Count bigint OUTPUT                   -- NOTE to DEVELOPERS: when adding more params, keep all optional parameters at the end.
AS
      DECLARE @stNo INTEGER
      DECLARE @endNo INTEGER
      DECLARE @s_Attribute NVARCHAR(MAX)
      DECLARE @sqlStmt NVARCHAR(MAX)
      SET @stNo = -1
      SET @endNo = -1
      SET @s_Attribute = CONVERT(NVARCHAR(MAX),@i_Attribute)
      IF(@i_Offset+@i_Limit <= 0)
      BEGIN
            set @stNo = 1
            set @endNo = -1
      END
      ELSE
      BEGIN
            set @stNo = @i_Offset + 1
            set @endNo = (@i_Offset + @i_Limit)
      END
      IF(@i_OrderByClause is null or LEN(@i_OrderByClause) = 0)
            SET @i_OrderByClause = 'QueryName'
            --print 'check this stmt loc'
      select @o_Count = COUNT(*) from [DMQuery] WITH (READUNCOMMITTED)
            where (@s_Attribute = 0 or (Attribute & @s_Attribute ) = @s_Attribute)
            AND (@i_IsLegacyQuery = -1 OR CONVERT(xml, Query).exist('/DM2ContentIndexing_SearchRequest') = @i_IsLegacyQuery)
            AND (CommServContainerGuid = @i_CommServContainerGuid OR @i_CommServContainerGuid = '');
      SET @sqlStmt = 'Select * from
      (
            select * , ROW_NUMBER() over (order by '+ @i_OrderByClause+') as rownum
            from [DMQuery]    WITH (READUNCOMMITTED)
            where ( '+@s_Attribute +'= 0 or (Attribute & '+ @s_Attribute+' ) = '+@s_Attribute+')
            AND ( '+ CONVERT(VARCHAR, @i_IsLegacyQuery)+'= -1 OR CONVERT(xml, Query).exist(''/DM2ContentIndexing_SearchRequest'') = '+CONVERT(VARCHAR,@i_IsLegacyQuery)+')
            AND (CommServContainerGuid = '''+@i_CommServContainerGuid +'''OR '''+@i_CommServContainerGuid +'''= '''')
            --AND UserGuid = @i_UserGUID
      )A '
      IF @stNo > 0 AND @endNo > 0
      BEGIN
		SET @sqlStmt = @sqlStmt + ' WHERE A.rownum >= '+ CONVERT(NVARCHAR(MAX),@stNo) + ' AND A.rownum <= ' + CONVERT(NVARCHAR(MAX),@endNo )
	  END
	  SET @sqlStmt = @sqlStmt + ' ORDER BY '+ @i_OrderByClause
      --print @sqlStmt
      exec sp_executesql @sqlStmt
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetQueries')
	delete from GxQscripts where name = 'sp_dm2_GetQueries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetQueries')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetQueries'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetQueries',  '00010003000000000000', 'sp_dm2_GetQueries', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetRestoreJob.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetRestoreJob()
--  | Description:  Get the Job Status Info
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetRestoreJob.sp,v $ $Id: sp_dm2_GetRestoreJob.sp,v 1.5 2011/07/06 15:21:08 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetRestoreJob <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetRestoreJob')
	drop procedure sp_dm2_GetRestoreJob
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetRestoreJob')
	delete from GxQscripts where name = 'sp_dm2_GetRestoreJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetRestoreJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetRestoreJob'
GO
print '... Creating Procedure: sp_dm2_GetRestoreJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetRestoreJob
  @i_RestoreJobID int = 0,
  @i_UserGUID nvarchar(256) = '',
  @i_RestoreStatus int = -1,
  @i_withInHours int = 168,
  @i_containerIdList nvarchar(max) = '',
  @i_resultSetIDs varchar(max) = ''	
AS
/*
@karthiks
	Modifed the Sp not to honor the ContainerId as it was unnecessary join performed..
	Also the ResultSetId need not be retrieved bcoz, we are focused only in distinct RestoreJobId and
		no where concerned about the ResultSetId
*******/
--DECLARE @tblResultSet TABLE (ResultSetId varchar(36), RestoreJobId int PRIMARY KEY (ResultSetId))
--INSERT INTO @tblResultSet
SELECT DISTINCT RS.RestoreJobId  as RestoreJobID,
			'Retrieve' as JobType,
			'' as DestinationComputer,
			0 as Status,
			0 as Progress,
			0 as Errors,
			'' as StartTime,
			'' as EndTime
FROM DMResultSet as RS		 WITH (READUNCOMMITTED)
  WHERE (@i_RestoreJobID = 0 or RS.RestoreJobID = @i_RestoreJobID)
  AND (len(@i_UserGUID) = 0 or (RS.RestoreUserGUID = @i_UserGUID))
  AND RS.RestoreJobID > 0
  AND (
		-- completed/failed jobs within @withInHours hour and all other jobs
		(@i_RestoreStatus = -1
			AND ((RS.RestoreStatus in (4,5,7) AND (@i_withInHours <= 0 OR (@i_withInHours > 0 AND datediff(hh, RS.RestoreTime, getdate()) <= @i_withInHours)))
				OR  RS.RestoreStatus NOT IN (4,5,7))
		)
		OR
		RS.RestoreStatus = @i_RestoreStatus
	   )
	   AND (LEN(@i_resultSetIDs) = 0 OR RS.ResultSetID IN
			(SELECT ID FROM dbo.splitStringToTable(@i_resultSetIDs)))
		--SELECT	DISTINCT RS.RestoreJobID as RestoreJobID,
		--	'Retrieve' as JobType,
		--	'' as DestinationComputer,
		--	0 as Status,
		--	0 as Progress,
		--	0 as Errors,
		--	'' as StartTime,
		--	'' as EndTime
		--	  FROM @tblResultSet as RS,DMContainerItem as CI	WITH (READUNCOMMITTED)
		--				WHERE RS.ResultSetID = CI.ResultSetID
		--		AND (LEN(@i_containerIdList)=0 or
		--					CI.ContainerID in (select * from dbo.splitStringToTable(@i_containerIdList)))
		--		AND (CI.Attribute & 4) = 0
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetRestoreJob')
	delete from GxQscripts where name = 'sp_dm2_GetRestoreJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetRestoreJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetRestoreJob'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetRestoreJob',  '00010005000000000000', 'sp_dm2_GetRestoreJob', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetResultSet()
--  | Description:  Get the ResultSet Info
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSet.sp,v $ $Id: sp_dm2_GetResultSet.sp,v 1.15 2015/04/16 18:51:46 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultSet <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultSet')
	drop procedure sp_dm2_GetResultSet
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSet'
GO
print '... Creating Procedure: sp_dm2_GetResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultSet
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = '',
  @i_CommCellNumber int = 0,
  @i_aFileID bigint = 0,
  @i_aFileOffset bigint = 0,
  @i_AppType int = 0,
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_UserGUID varchar(36) = '',
  @i_RestoreStatus int = -1,
  @i_OrderByClause nvarchar(max) = 'DMContainerItem.CreateTime DESC',
  @i_GetEmailsFlag bit = 1,
  @i_GetFilesFlag bit = 1,
  @i_offset int = 0
AS
SET NOCOUNT ON
  DECLARE @StartRN					INTEGER
  DECLARE @EndRN 						INTEGER
	DECLARE @sqlCmd 					NVARCHAR(max)
	DECLARE @curResultSetId		VARCHAR(36)
	DECLARE @tmpTagStr				NVARCHAR(MAX)
	DECLARE @ParmDefinition		NVARCHAR(MAX);
  IF @i_GetEmailsFlag IS null
	SET @i_GetEmailsFlag = 1
  IF @i_GetFilesFlag IS NULL
	SET @i_GetFilesFlag = 1
	--Changes to support both the pagination retrieval
	-- through the pagenumber and offset
  IF(@i_offset <= 0)
	BEGIN
	  IF (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
	  BEGIN
			SET @StartRN = 1
			SET @EndRN = -1
	  END
	  ELSE
	  BEGIN
			SET @StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
			SET @EndRN = @i_NumPages * @i_ItemsOnPage + @StartRN - 1
	  END
	END
	ELSE
	BEGIN
		IF(@i_ItemsOnPage) <= 0
		BEGIN
			SET @StartRN = @i_Offset
			SET @EndRN = -1
		END
		ELSE
		BEGIN
			SET @StartRN = @i_Offset
			SET @EndRN = @i_offset + @i_ItemsOnPage - 1
		END
	END
	--check if the orderbyclause is empty
	IF(LEN(ISNULL(@i_OrderByClause,'')) = 0 )
		SET @i_OrderByClause = 'DMContainerItem.CreateTime DESC'
	IF object_id('tempdb.dbo.#tblGetContainerItem') is not null
	DROP TABLE #tblGetContainerItem
	IF object_id('tempdb.dbo.#tblAppType') is not null
		DROP TABLE #tblAppType
	CREATE TABLE #tblGetContainerItem (rowId INT, ResultSetID VARCHAR(36))--,UserComments NVARCHAR(MAX))
	CREATE UNIQUE CLUSTERED INDEX IDX_tempTblGetContainerItem_1 ON #tblGetContainerItem(rowId);
	CREATE NONCLUSTERED INDEX IDX_tempTblGetContainerItem_2 ON #tblGetContainerItem(ResultSetID);
	IF NOT(@i_GetEmailsFlag = 1 AND @i_GetFilesFlag = 1)
	BEGIN
	CREATE TABLE #tblAppType (AppType INT );
	CREATE UNIQUE CLUSTERED INDEX IDX_tempTblAppType ON #tblAppType (AppType)
					 INSERT INTO #tblAppType
					 SELECT distinct AppTypeId
						 FROM DMUIAppTypeMap AS AT
						 WHERE AT.IsEmailAppType = @i_GetEmailsFlag OR AT.IsFileAppType = @i_GetFilesFlag
	END
	SET @sqlCmd = '
					;WITH AllResults AS
					(	SELECT '
	IF(@EndRN > 0)
		SET @sqlCmd  = @sqlCmd  + ' TOP (@EndRN) '
	SET @sqlCmd = @sqlCmd + ' ROW_NUMBER() OVER (ORDER BY ' + @i_OrderByClause +') AS row ,
								DMContainerItem.ResultSetID
						 FROM DMResultSet AS DMResultSet WITH (READUNCOMMITTED) INNER JOIN
							DMContainerItem AS DMContainerItem WITH (READUNCOMMITTED)
						ON	DMResultSet.ResultSetID = DMContainerItem.ResultSetID   AND	(DMContainerItem.Attribute & 4) = 0 '
	IF NOT(@i_GetEmailsFlag = 1 AND @i_GetFilesFlag = 1)
		SET @sqlCmd = @sqlCmd + ' AND DMResultSet.AppType IN (SELECT AT.AppType
													FROM #tblAppType AS AT) '
	SET @sqlCmd = @sqlCmd + 'where (len('''+ (@i_ContainerID)+''') = 0 or (DMContainerItem.ContainerID = '''+(@i_ContainerID)+''')))
							 INSERT INTO #tblGetContainerItem
							SELECT  V.row,V.ResultSetID
								FROM AllResults AS V
								where V.row >= @StartRN '
	SET @ParmDefinition = N'@EndRN INTEGER,@StartRN INTEGER,@i_GetEmailsFlag BIT, @i_GetFilesFlag BIT'
	EXEC sp_executesql @sqlCmd,@ParmDefinition,@EndRN,@StartRN,@i_GetEmailsFlag,@i_GetFilesFlag
	--IF len(@i_ContainerID) > 0
	--BEGIN
	--	UPDATE #tblGetContainerItem
	--	SET UserComments = ISNULL(UC.Comment, '')
	--	FROM  #tblGetContainerItem T
	--			INNER JOIN
	--		DMUserComment UC
	--		ON UC.ResultSetID = T.ResultSetID
	--			AND UC.ContainerID = @i_ContainerID
	--END
	SELECT t.ResultSetID,RS.RestoreStatus, RSI.ResultSet, '' AS UserComments,
			RS.CommCellNumber,RS.aFileID,RS.aFileOffset,RS.aFileLength,
			RS.AppType,RS.FileSizeKB,RS.ModifiedTime,RS.JobId,RS.OriginalFullPath,
			RS.DestinationPath,RS.CreateTime,RS.RestoreUserGUID,RS.RestoreJobID,
			RS.RestoreStatus,RS.RestoreTime,RS.Attribute,
			RS.documentID,RS.ClientID
	FROM #tblGetContainerItem as t
			INNER JOIN
		DMResultSet AS RS WITH (READUNCOMMITTED)
		ON t.ResultSetID = RS.ResultSetID
			INNER JOIN
		DMResultSetInfo AS RSI WITH (READUNCOMMITTED)
		ON t.ResultSetID = RSI.ResultSetID
	ORDER BY t.rowId
  DROP TABLE #tblGetContainerItem
IF object_id('tempdb.dbo.#tblAppType') is not null
	DROP TABLE #tblAppType
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultSet',  '00010015000000000000', 'sp_dm2_GetResultSet', '00010015000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemDetail.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemDetail.sp,v $ $Id: sp_dm2_GetResultItemDetail.sp,v 1.18 2015/04/16 18:51:12 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultItemDetail <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultItemDetail')
	drop procedure sp_dm2_GetResultItemDetail
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultItemDetail')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemDetail')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemDetail'
GO
print '... Creating Procedure: sp_dm2_GetResultItemDetail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultItemDetail
  @i_ItemsXML XML,
  @i_DUMMY NVARCHAR(MAX) = ''
AS
BEGIN
	DECLARE @curResultSetId			VARCHAR(36)
	DECLARE @curCommentId				VARCHAR(36)
	DECLARE @curComment					NVARCHAR(MAX)
	DECLARE @curTagsXML					XML
	DECLARE @curCommCellNumber 	INTEGER
	DECLARE @curAFileId 		BIGINT
	DECLARE @curAFileOffSet 		BIGINT
	DECLARE @tmpContainerStr		VARCHAR(MAX)
	DECLARE @tmpDBTagStr				VARCHAR(MAX)
	DECLARE @tmpTagStr					VARCHAR(MAX)
	DECLARE @tmpLHGUIDStr				VARCHAR(MAX)
	DECLARE @debug							BIT
	DECLARE @i_UserGUID					VARCHAR(36)
	DECLARE @i_ContainerGUID		VARCHAR(36)
	DECLARE @i_xmlText				XML
	--below 3 bits will be useful to avoid any unnecessay query on tables.
	DECLARE @isContainerListEmpty	BIT = 1
	DECLARE @isTagListEmpty			BIT = 1
	DECLARE @isLHListEmpty			BIT = 1
	--change @debug to 1 helps trace outputs of stored proc, but should be 0 in test / production env..
	SET @debug = 0
	--drop temptable iff any exists
	IF object_id('tempdb.dbo.#tmpContainerGUIDList') IS NOT NULL
		DROP TABLE #tmpContainerGUIDList
	IF object_id('tempdb.dbo.#tmpTagGUIDList') IS NOT NULL
		DROP TABLE #tmpTagGUIDList
	IF object_id('tempdb.dbo.#tmpLHGUIDList') IS NOT NULL
		DROP TABLE #tmpLHGUIDList
	IF object_id('tempdb.dbo.#tmpViewTagList') IS NOT NULL
		DROP TABLE #tmpViewTagList
	IF object_id('tempdb.dbo.#tmpResultSet') IS NOT NULL
		DROP TABLE #tmpResultSet
	--created non-clustered index on temp table for fast access..
	CREATE TABLE #tmpContainerGUIDList ( ContainerId VARCHAR(36) )
	CREATE NONCLUSTERED INDEX tmpContainerGUIDList_idx1 ON #tmpContainerGUIDList(containerId)
	CREATE TABLE #tmpTagGUIDList ( TagID VARCHAR(36) )
	CREATE NONCLUSTERED INDEX tmpTagGUIDList_idx1 ON #tmpTagGUIDList(TagID)
	CREATE TABLE #tmpLHGUIDList ( CompPolicyID VARCHAR(36) )
	CREATE NONCLUSTERED INDEX tmpLHGUIDList_idx1 ON #tmpLHGUIDList(CompPolicyID)
	CREATE TABLE #tmpViewTagList ( TagID VARCHAR(36) )
	--LegalHoldStatus = 1 (Success), 3 (Unknown), 2 (Failed), 0 (Submitted)
	CREATE Table #tmpResultSet
	(
		DocumentId 			char(256),
		ResultSetId 		VARCHAR(36),
		CommCellNumber 	INTEGER,
		aFileId 				BIGINT,
		aFileOffSet 		BIGINT,
		restoreStatus 	INTEGER,
		ContainerList 	VARCHAR(MAX),
		DBTagGUIDList 	VARCHAR(MAX),
		TagGUIDList 		VARCHAR(MAX),
		LegalHoldStatus INTEGER,
		DestinationPath NVARCHAR(MAX),
		Comment 				NVARCHAR(MAX),
		CommentID 			CHAR(36),
		LHGUIDList 			VARCHAR(MAX),
		TagsXML					XML,
		isExistsInDMResultSet		bit default 0,
		IndexGUID			varchar(128),
		NewCCN				INT,
		NewAFID				BIGINT,
		NewAFOF				BIGINT,
		UseNewRestoreIndex  BIT default 0
	)
	CREATE NONCLUSTERED INDEX tmpResultSet_idx1 ON #tmpResultSet(ResultSetId)
	CREATE NONCLUSTERED INDEX tmpResultSet_idx2 ON #tmpResultSet(aFileId,aFileOffSet)
			INCLUDE (CommCellNumber)
	CREATE NONCLUSTERED INDEX tmpResultSet_idx3 ON #tmpResultSet(IndexGUID)
	SELECT @i_UserGUID = T.c.value('@userGuid', 'VARCHAR(36)')
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq') T(c)
	IF @i_UserGUID IS null
		SET @i_UserGUID = ''
	SELECT @i_ContainerGUID = T.c.value('@containerGuid', 'VARCHAR(36)')
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/currentContainer') T(c)
	IF @i_ContainerGUID IS null
		SET @i_ContainerGUID = ''
	--Check if the sharedEntities node exists
	IF( (SELECT @i_ItemsXML.exist('DM2ContentIndexing_GetResultItemsMetaDataReq/sharedEntities')) = 1)
	BEGIN
	-- Populate containerGUID that current user can view
	INSERT INTO #tmpContainerGUIDList
	SELECT * FROM dbo.splitStringToTable((SELECT T.c.value('@containerIdList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/sharedEntities') T(c)))
		--Reset the bit, if count(temp table) > 0
		IF((SELECT COUNT(ContainerId) FROM #tmpContainerGUIDList) > 0)
			SET @isContainerListEmpty = 0
	-- Populate TagGUIDs that current user can view
	INSERT INTO #tmpTagGUIDList
	SELECT * FROM dbo.splitStringToTable((SELECT T.c.value('@tagIdList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/sharedEntities') T(c)))
		--Reset the bit, if count(temp table) > 0
		IF((SELECT COUNT(TagID) FROM #tmpTagGUIDList) > 0)
			SET @isTagListEmpty = 0
	-- Populate LegalHoldGUIDs that current user can view
	INSERT INTO #tmpLHGUIDList
	SELECT * FROM dbo.splitStringToTable((SELECT T.c.value('@legalHoldList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/sharedEntities') T(c)))
		--Reset the bit, if count(temp table) > 0
		IF((SELECT COUNT(CompPolicyID) FROM #tmpLHGUIDList) > 0)
			SET @isLHListEmpty = 0
	END
	IF @debug = 1
	BEGIN
		SELECT '#tmpContainerGUIDList' AS TableName, * FROM #tmpContainerGUIDList
		SELECT '#tmpTagGUIDList' AS TableName, * FROM #tmpTagGUIDList
		SELECT '#tmpLHGUIDList' AS TableName, * FROM #tmpLHGUIDList
	END
	INSERT INTO #tmpResultSet(DocumentId, CommCellNumber, aFileId, aFileOffSet,
														restoreStatus, ContainerList, TagGUIDList, LegalHoldStatus,
														TagsXML, IndexGUID)
	SELECT T.c.value('@documentId', 'varchar(256)'), T.c.value('@commcellNo', 'integer'),
					T.c.value('@aFileId', 'bigint'), 	T.c.value('@aFileOffset', 'bigint'),
					0 AS RestoreStatus, '' AS ContainerList, '' AS TagGUIDList,	3 AS LegalHoldStatus,
					CAST(T.c.query('./tags') AS XML) AS TagsXML,
					T.c.value('@turboGuid', 'varchar(128)')
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetResultItemsMetaDataReq/input/resultItem') T(c);
	UPDATE tt
	SET ResultSetId = RS.ResultSetId,
	restoreStatus = RS.RestoreStatus,
	DestinationPath = RS.DestinationPath,
	LegalHoldStatus = 3,
	isExistsInDMResultSet = 1,
	tt.UseNewRestoreIndex = CASE WHEN tt.aFileId < RS.aFileID THEN 1 ELSE 0 END,
	tt.NewAFID = RS.aFileID,
	tt.NewAFOF = RS.aFileOffset,
	tt.NewCCN = RS.CommCellNumber
	FROM #tmpResultSet tt, DMResultSet RS WITH (READUNCOMMITTED)
	WHERE tt.aFileId <> 0 AND ISNULL(TT.IndexGUID, '') <> '' AND  RS.IndexGUID = TT.IndexGUID
	--Update the resultitem specific information
	UPDATE #tmpResultSet
	SET ResultSetId = RS.ResultSetId,
	restoreStatus = RS.RestoreStatus,
	DestinationPath = RS.DestinationPath,
	LegalHoldStatus = 3,
	isExistsInDMResultSet = 1
	FROM #tmpResultSet tt, DMResultSet RS WITH (READUNCOMMITTED)
	WHERE tt.aFileId <> 0 AND isExistsInDMResultSet = 0 AND RS.CommCellNumber = tt.CommCellNumber AND RS.aFileId = tt.aFileId AND RS.aFileOffSet = tt.aFileOffSet
	--Below case is used for edge drive where in request doesnt have afileid/offset , turboguid. So we compare wrt documentId..
    --
    IF EXISTS( SELECT TOP 1 * FROM #tmpResultSet tt WHERE tt.aFileId = 0)
    BEGIN
            UPDATE #tmpResultSet
            SET ResultSetId = RS.ResultSetId,
                    restoreStatus = RS.RestoreStatus,
                    DestinationPath = RS.DestinationPath
            FROM #tmpResultSet tt INNER JOIN
                    DMResultSet RS WITH (READUNCOMMITTED)
            ON tt.aFileId = 0 AND
               ISNULL(tt.DocumentId,'') <> '' AND tt.DocumentId = RS.DocumentId
    END
	IF @debug = 1
	BEGIN
		SELECT '#tmpResultSet' AS TableName, * FROM #tmpResultSet
	END
	DECLARE ResultSetCur CURSOR STATIC FOR
	SELECT ResultSetId, TagsXML,CommCellNumber, aFileId, aFileOffSet FROM #tmpResultSet
	OPEN ResultSetCur
	FETCH NEXT FROM ResultSetCur INTO @curResultSetId, @curTagsXML, @curCommCellNumber,@curAFileId, @curAFileOffSet
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE #tmpViewTagList
		SET @tmpContainerStr = null
		SET @tmpDBTagStr = null
		SET @tmpTagStr = null
		SET @tmpLHGUIDStr = null
		SET @curCommentId = ''
		SET @curComment = ''
		--Get the last Modified Comment on items (if any)
		SELECT TOP 1 @curCommentId = UC.CommentId, @curComment = UC.Comment
		FROM DMUserComment UC WITH (NOLOCK), DMContainerItem CI WITH (NOLOCK)
		WHERE UC.ResultSetId = CI.ResultSetId
		AND		UC.ContainerId = CI.ContainerId
		AND		UC.ResultSetId = @curResultSetId
		AND 	UC.ContainerId = @i_ContainerGUID
		AND		(UC.attribute & 4) = 0
		AND	  (CI.Attribute & 4) = 0
		AND 	UC.Comment IS NOT null
		AND		LEN(UC.Comment) > 0
		ORDER BY modifiedTime DESC
		--check if containerlist exists
		IF( @isContainerListEmpty = 0)
		BEGIN
			----Capture ContainerId List of those in which current ResultItemId exists and current user can view it
			SELECT @tmpContainerStr = ISNULL(STUFF(
					(SELECT  ', ' "text()", tt.ContainerId "text()"
		FROM 	#tmpContainerGUIDList tt, DMContainerItem CI  WITH (READUNCOMMITTED)
		WHERE	tt.ContainerId = CI.ContainerId
		AND		CI.ResultSetId = @curResultSetId
		AND		(len(@i_ContainerGUID) = 0 OR tt.ContainerId <> @i_ContainerGUID) -- If called from reviewset view then list other reviewsets except the current one
		AND	  (CI.Attribute & 4) = 0
						FOR XML PATH('')),1,1,''),'')
		END
		--check if taglist exists
		IF( @isTagListEmpty = 0)
		BEGIN
		--Get the Container specific (DB ONLY) tags
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		INSERT INTO  #tmpViewTagList
		SELECT DISTINCT CIT.TagId
		FROM 	#tmpTagGUIDList tt, DMContainerItemStates CIS WITH (READUNCOMMITTED), DMContainerItemTags CIT WITH (READUNCOMMITTED)
		WHERE	(len(@i_ContainerGUID) = 0 OR CIS.ContainerId = @i_ContainerGUID)
		AND		CIS.ResultSetId = @curResultSetId
		--AND		CIS.AssignedUserGUID = @i_UserGUID -- Get all users tags since current user can view shared Tags
		AND		CIS.AssignId = CIT.AssignId
		AND		CIT.TagID = tt.TagID
		AND		(CIS.Attribute & 4) = 0
		AND		(CIT.Attribute & 4) = 0
		--Get complete list of DB TagIds that current user can view
			SELECT @tmpDBTagStr =
					ISNULL(STUFF((SELECT ',' "text()", tt.TagID "text()"
		FROM #tmpViewTagList tt
								FOR XML PATH('')),1,1,''),'')
		--Clean DB tags and get Fast Synced Tags
		DELETE FROM #tmpViewTagList
		--Get the Item specific (FAST SYNCed) tags
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		INSERT INTO  #tmpViewTagList
		SELECT DISTINCT UIT.TagID
		FROM 	#tmpTagGUIDList tt, DMUserItemTags UIT WITH (READUNCOMMITTED)
		WHERE	UIT.ResultSetId = @curResultSetId
		--AND		UIT.UserGUID = @i_UserGUID -- Get all users tags since current user can view shared Tags
		AND		UIT.TagID = tt.TagID
		AND		(UIT.Attribute & 4) = 0
		UNION
		--Get the tags retrieved from FAST search results
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		--For now get tags from ResultSetXML when @i_ContainerGUID is empty for tags coming from FAST
		SELECT DISTINCT TAG.TagID
		FROM 	#tmpTagGUIDList tt, ( SELECT T.c.value('@id', 'char(36)') AS TagID
																FROM @curTagsXML.nodes('/tags/tag') T(c)) TAG
		WHERE	TAG.TagID = tt.TagID
		AND		len(@i_ContainerGUID) = 0
		--Get complete list of TagIds that current user can view
			SELECT @tmpTagStr =
				ISNULL(STUFF((SELECT ',' "text()", tt.TagID "text()"
		FROM #tmpViewTagList tt
								FOR XML PATH('')),1,1,''),'')
		END
		--check for Legalhold list is empty
		IF(@isLHListEmpty = 0)
		BEGIN
		--Get the LegalHold GUIDs to which this item is backed up and shared by current user
			SELECT @tmpLHGUIDStr =ISNULL(STUFF((
				SELECT ',' "text()", LH.CompPolicyID "text()"
					FROM 	#tmpLHGUIDList tt,
					(SELECT DISTINCT CompPolicyID
															FROM DMLegalHoldItemsToBackup WITH (READUNCOMMITTED)
															WHERE ResultSetId = @curResultSetId
															AND		(len(@i_ContainerGUID) = 0 OR ContainerId = @i_ContainerGUID)
															AND		BackupStatus = 1) LH
		WHERE	LH.CompPolicyID = tt.CompPolicyID
					FOR XML PATH('')),1,1,''),'')
		END
		IF(LEN(ISNULL(@curResultSetId,'')) > 0)
		BEGIN
		--Update List of ReviewSets, List of Tags and List of LegalHolds
			UPDATE #tmpResultSet
			SET commentId = ISNULL(@curCommentId, ''),
					comment = ISNULL(@curComment, ''),
					ContainerList = ISNULL(@tmpContainerStr, ''),
					DBTagGUIDList = ISNULL(@tmpDBTagStr, ''),
					TagGUIDList = ISNULL(@tmpTagStr, ''),
					LHGUIDList = ISNULL(@tmpLHGUIDStr, '')
			WHERE ResultSetId = @curResultSetId
		END
		--below case
		-- when request is from search page and tags are synced with CI
		-- but for some reason items doesnt exits in DM2 table, its ResultSetid wil be empty
		--[for better readability update has been moved as seperate stmt]
		ELSE
		BEGIN
			UPDATE #tmpResultSet
			SET commentId = ISNULL(@curCommentId, ''),
					comment = ISNULL(@curComment, ''),
					ContainerList = ISNULL(@tmpContainerStr, ''),
					DBTagGUIDList = ISNULL(@tmpDBTagStr, ''),
					TagGUIDList = ISNULL(@tmpTagStr, ''),
					LHGUIDList = ISNULL(@tmpLHGUIDStr, '')
			WHERE @curCommCellNumber = CommCellNumber  AND
				  @curAFileId = aFileId AND
				  @curAFileOffSet = aFileOffSet
		END
			FETCH NEXT FROM ResultSetCur INTO @curResultSetId, @curTagsXML, @curCommCellNumber,@curAFileId, @curAFileOffSet
		END
		SELECT * FROM #tmpResultSet
		DROP TABLE #tmpResultSet
		DROP TABLE #tmpContainerGUIDList
		DROP TABLE #tmpTagGUIDList
		DROP TABLE #tmpLHGUIDList
		DROP TABLE  #tmpViewTagList
		CLOSE ResultSetCur
		DEALLOCATE ResultSetCur
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultItemDetail')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemDetail')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemDetail'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultItemDetail',  '00010018000000000000', 'sp_dm2_GetResultItemDetail', '00010018000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetItemStatus.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetResultSetItemStatus()
--  | Description:  Get the ResultSet Item Status
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetItemStatus.sp,v $ $Id: sp_dm2_GetResultSetItemStatus.sp,v 1.3 2015/04/16 18:53:01 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultSetItemStatus <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultSetItemStatus')
	drop procedure sp_dm2_GetResultSetItemStatus
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultSetItemStatus')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetItemStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetItemStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetItemStatus'
GO
print '... Creating Procedure: sp_dm2_GetResultSetItemStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultSetItemStatus
  @i_ResultSetIDList varchar(max) = ''
AS
IF(len(@i_ResultSetIDList) > 0)
BEGIN
	declare @queryStr varchar(max)
	set @queryStr = 'SELECT ResultSetId, RestoreStatus FROM DMResultSet  WITH (READUNCOMMITTED) WHERE ResultSetId IN ' +  @i_ResultSetIDList
	EXEC(@queryStr)
END
ELSE
BEGIN
	SELECT '', 0, 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultSetItemStatus')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetItemStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetItemStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetItemStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultSetItemStatus',  '00010003000000000000', 'sp_dm2_GetResultSetItemStatus', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetItemTagGUIDs.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetItemTagGUIDs.sp,v $ $Id: sp_dm2_GetResultSetItemTagGUIDs.sp,v 1.1 2008/11/04 18:44:13 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultSetItemTagGUIDs <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultSetItemTagGUIDs')
	drop procedure sp_dm2_GetResultSetItemTagGUIDs
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultSetItemTagGUIDs')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetItemTagGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetItemTagGUIDs')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetItemTagGUIDs'
GO
print '... Creating Procedure: sp_dm2_GetResultSetItemTagGUIDs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultSetItemTagGUIDs
  @i_ResultSetId CHAR(36)
AS
  DECLARE @tmpTagStr NVARCHAR(MAX)
	--Just a double check to ensure if temp table exists, drop it.
	IF object_id('tempdb.dbo.#tblTagGUIDList') is not null
	DROP TABLE #tblTagGUIDList
	create table #tblTagGUIDList (TagGUIDS VARCHAR(50))
	--Get the DB ONLY tags
	INSERT INTO #tblTagGUIDList
	SELECT	DISTINCT CIT.TagID
	FROM 	DMContainerItemStates CIS, DMContainerItemTags CIT
	WHERE	CIS.ResultSetId = @i_ResultSetId
	AND		CIS.AssignId = CIT.AssignId
	AND		(CIS.Attribute & 4) = 0
	AND		(CIT.Attribute & 4) = 0
	--Get the Item specific FAST SYNCed ONLY tags
	INSERT INTO #tblTagGUIDList
	SELECT	DISTINCT UIT.TagID FROM DMUserItemTags UIT
	WHERE	UIT.ResultSetId = @i_ResultSetId
	AND		(UIT.Attribute & 4) = 0
	--Create consolidated list of comma seperated list so that we can return it
	SELECT @tmpTagStr = COALESCE(@tmpTagStr + ',', '') + TT.TagGUIDS
	FROM 	#tblTagGUIDList TT
	IF object_id('tempdb.dbo.#tblTagGUIDList') is not null		-- cleanup.
	DROP TABLE #tblTagGUIDList
	SELECT @tmpTagStr AS TagGuids		--Done. Return Comma seperated list of all tags from here.
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultSetItemTagGUIDs')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetItemTagGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetItemTagGUIDs')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetItemTagGUIDs'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultSetItemTagGUIDs',  '00010001000000000000', 'sp_dm2_GetResultSetItemTagGUIDs', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneUserSession.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneUserSession()
--  | Description:  Prune User Session
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneUserSession.sp,v $ $Id: sp_dm2_PruneUserSession.sp,v 1.4 2013/12/29 04:18:12 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneUserSession <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneUserSession')
	drop procedure sp_dm2_PruneUserSession
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneUserSession')
	delete from GxQscripts where name = 'sp_dm2_PruneUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneUserSession'
GO
print '... Creating Procedure: sp_dm2_PruneUserSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneUserSession
  @i_UserGUID varchar(36) = '',
  @i_SessionID varchar(36) = ''
AS
  --Pruning Process will not send session Id input. But Logout functionality will.
  --Marking attribute as 4 helps to identify loggout session entries in dmusersession. We don't delete right away unlike QSDK session entries.
  --We let regular pruning that runs to delete entries from dmusersession.
  if ISNULL(@i_SessionID,'') = ''
  begin
	  --Bug Found: No entry point found in code that calls pruning of queries in 10.0. Fixing it by calling it from here.
	  exec sp_dm2_PruneQuery @i_UserGUID, ''
	  if @i_UserGUID != ''
	  begin
		  delete from DMUserSession
		  where UserGUID = @i_UserGUID
	  end
	  else
	  begin
		DECLARE @l_retainEntries INT = 10  -- default 10 entries
		SELECT @l_retainEntries = ISNULL(SettingValue, 10) FROM DMSetting
		WHERE SettingName = 'RETAIN_USERSESSION_ENTRY'
		--Pruning changes (retain last 10(default) entries grouped by userguid,ipaddress)
		DELETE dt
		FROM (SELECT
				ROW_NUMBER() OVER ( PARTITION BY userguid, ip ORDER BY lastAccesstime DESC ) AS 'RowNumber'
			  FROM DMUserSession
		  ) dt
		WHERE RowNumber > @l_retainEntries
	end
  end
  else
  begin
	 UPDATE DMUserSession
	 SET Attribute = Attribute | 4
	 WHERE SessionId = @i_SessionID
  end
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneUserSession')
	delete from GxQscripts where name = 'sp_dm2_PruneUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneUserSession'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneUserSession',  '00010004000000000000', 'sp_dm2_PruneUserSession', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetResultSetToPrune()
--  | Description:  Get the ResultSet To Prune
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetToPrune.sp,v $ $Id: sp_dm2_GetResultSetToPrune.sp,v 1.7 2014/03/19 16:46:49 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultSetToPrune <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultSetToPrune')
	drop procedure sp_dm2_GetResultSetToPrune
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultSetToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetToPrune'
GO
print '... Creating Procedure: sp_dm2_GetResultSetToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultSetToPrune
  @i_StartIndex int = 0,
  @i_Count int = 100
AS
	-- NO PROCESSING SHOULD BE DONE VIA CVD CONTEXT
	--exec sp_dm2_PruneUserSession
	--by default, we dont want to run this pruning operation  from CVD context.
	-- so just return empty value and the other code will not get executed
	IF NOT EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'RETURN_PRUNE_LIST_CVD' AND SettingValue = 'true')
	BEGIN
		SELECT DestinationPath, ResultSetID from DMResultSet where 1=2
	END
	ELSE
	BEGIN
		--download pruning will be done on deletion of downloadSet
		--exec sp_dm2_PruneDownload
		--
		-- Get all the result items that are marked deleted
		DECLARE @EndRN INT
		SET @EndRN = @i_Count + @i_StartIndex - 1
		EXEC ('WITH [dm2_GetResultSet] AS
		(SELECT DestinationPath, ResultSetID, ROW_NUMBER() OVER (order by PruneRequestTime asc) AS RowNumber
		FROM [DMResultSet] WITH (READUNCOMMITTED)
		WHERE (Attribute & 4) = 4
		AND (DestinationPath IS NOT NULL AND LEN(DestinationPath) > 0))
		SELECT DISTINCT DestinationPath, ResultSetID
		FROM [dm2_GetResultSet]
		WHERE RowNumber between ' + @i_StartIndex + ' AND ' + @EndRN)
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultSetToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetToPrune'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultSetToPrune',  '00010007000000000000', 'sp_dm2_GetResultSetToPrune', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetSetting.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetSetting()
--  | Description:  Get the Settings
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetSetting.sp,v $ $Id: sp_dm2_GetSetting.sp,v 1.2 2010/11/29 14:27:38 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetSetting <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetSetting')
	drop procedure sp_dm2_GetSetting
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetSetting')
	delete from GxQscripts where name = 'sp_dm2_GetSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetSetting')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetSetting'
GO
print '... Creating Procedure: sp_dm2_GetSetting'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetSetting
  @i_SettingName varchar(MAX) = ''
AS
IF len(@i_SettingName) = 0
BEGIN
	SELECT * FROM [DMSetting] WITH (READUNCOMMITTED)
END
ELSE
BEGIN
	SELECT S.* FROM [DMSetting] S WITH (READUNCOMMITTED)
	JOIN dbo.split(@i_SettingName, ',') T ON T.Data = S.SettingName
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetSetting')
	delete from GxQscripts where name = 'sp_dm2_GetSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetSetting')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetSetting'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetSetting',  '00010002000000000000', 'sp_dm2_GetSetting', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetUserComment.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetUserComment()
--  | Description:  Get the User Comments
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetUserComment.sp,v $ $Id: sp_dm2_GetUserComment.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetUserComment <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetUserComment')
	drop procedure sp_dm2_GetUserComment
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetUserComment')
	delete from GxQscripts where name = 'sp_dm2_GetUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserComment'
GO
print '... Creating Procedure: sp_dm2_GetUserComment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetUserComment
  @i_CommentID varchar(36) = '',
  @i_UserGUID nvarchar(256) = '',
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = '',
  @i_ParentCommentID varchar(36) = ''
AS
  select * from [DMUserComment] WITH (READUNCOMMITTED)
  where (len(@i_CommentID) = 0 or CommentID = @i_CommentID)
  and (len(@i_UserGUID) = 0 or UserGUID = @i_UserGUID)
  and (len(@i_ContainerID) = 0 or ContainerID = @i_ContainerID)
  and (len(@i_ResultSetID) = 0 or ResultSetID = @i_ResultSetID)
  and (len(@i_ParentCommentID) = 0 or ParentCommentID = @i_ParentCommentID)
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetUserComment')
	delete from GxQscripts where name = 'sp_dm2_GetUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserComment'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetUserComment',  '00010001000000000000', 'sp_dm2_GetUserComment', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetUserPref.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetUserPref()
--  | Description:  Get User preferences using the pagenation
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetUserPref.sp,v $ $Id: sp_dm2_GetUserPref.sp,v 1.12 2010/10/18 11:31:33 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetUserPref <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetUserPref')
	drop procedure sp_dm2_GetUserPref
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetUserPref')
	delete from GxQscripts where name = 'sp_dm2_GetUserPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserPref'
GO
print '... Creating Procedure: sp_dm2_GetUserPref'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetUserPref
  @i_UserGUID VARCHAR(MAX) = '',
  @i_ViewNames VARCHAR(MAX) = '',
  @i_PrefNames VARCHAR(MAX) = '',
  @i_SiteMode VARCHAR(50)	= '',
  @i_Offset INTEGER = 0,
  @i_Limit INTEGER = 10,  
  @i_OrderByClause NVARCHAR(MAX) = 'ViewName',
  @o_Count bigint OUTPUT
AS
DECLARE @SettingVal BIT = 0
	DECLARE @stNo INTEGER = 1
	DECLARE @endNo INTEGER = -1
	DECLARE @sqlStmt NVARCHAR(MAX) = ''
	DECLARE @bitVisibility INTEGER = 4
	--SEt the bit visibility default is 4
	IF ISNULL(@i_SiteMode, '') = ''
	BEGIN
		SET @bitVisibility = 0
	END
	ELSE
	BEGIN
	        SET @bitVisibility = ISNULL((	SELECT BinaryWeightage
									FROM DMSearchView
									WHERE ViewName = @i_SiteMode)
									,-1)
	END
	IF(@i_Offset+@i_Limit <= 0)
	BEGIN
		set @stNo = 1
		set @endNo = -1
	END
	ELSE
	BEGIN
		set @stNo = @i_Offset + 1
		set @endNo = (@i_Offset + @i_Limit)
	END
	IF object_id('tempdb.dbo.#tblAllResults') is not null
		DROP TABLE #tblAllResults
	CREATE table #tblAllResults (cnt int identity(1,1),UserGUID varchar(MAX),UserName varchar(max),ViewName varchar(max),
		UserPrefName varchar(max),UserPrefValue varchar(max),LastModifiedTime DateTime,Setting varchar(max));
	SELECT @SettingVal = ISNULL(SettingValue, 'False') FROM DMSetting WHERE SettingName = 'DEFAULT_Disable_End_User_Setting'
	/*
	*@karthiks: MR: 56792
	*User has not logged into the webUI but perform ACC policy on CS.
	*So DMUserSession will not hold the userGuid. but some valid userGuid is sent.
	*To handle this scenario, if entry doesnt exists in DMUserSession
	*we put the userGuid and userNAme as "Unknown" in #tblUserGuidViews and return default value
	* */
	--Create temp table that will hold the user details and view names
	CREATE TABLE #tblUserGuidViews(UserGUID VARCHAR(MAX),UserName VARCHAR(MAX),ViewId VARCHAR(MAX), ViewName VARCHAR(MAX));
	INSERT INTO #tblUserGuidViews
	SELECT DISTINCT A.UserGUID,A.UserName, B.Id as ViewId, B.ViewName
	FROM DMUserSession AS A,
		 DMSearchView AS B
	WHERE B.BinaryWeightage <> 4
		AND  (LEN(@i_ViewNames) = 0 OR B.Id IN (SELECT ID FROM dbo.splitStringToTable(@i_ViewNames) ))
		AND  (LEN (@i_UserGUID) = 0 or (A.UserGUID IN (SELECT ID FROM dbo.splitStringToTable(@i_UserGUID))))
	--This is in the case if we get userGuid but its entry is not in DMUserSession
	-- For eg: user performing ACC policy without logging into WebUI once too.
	-- dont conside if the #tblUserGuidViews is > 0
	IF(LEN(@i_UserGUID) > 0 AND (SELECT COUNT(*) FROM #tblUserGuidViews) = 0)
	BEGIN
		INSERT INTO #tblUserGuidViews
		SELECT DISTINCT A.UserGUID,'Unknown',B.Id as ViewId, B.ViewName
		FROM (SELECT ID FROM dbo.splitStringToTable(@i_UserGUID)) AS A (UserGUID),
			DMSearchView AS B
		WHERE B.BinaryWeightage <> 4
			AND  (LEN(@i_ViewNames) = 0 OR B.Id IN (SELECT ID FROM dbo.splitStringToTable(@i_ViewNames) ))
	END
	--Declare variables for the cursor
	DECLARE @cUserGuid			VARCHAR(MAX),
			@cUserName			VARCHAR(MAX),
			@cViewId			VARCHAR(36),
			@cViewName			VARCHAR(MAX),
			@cPrefName			VARCHAR(MAX),
			@cDefaultValue		VARCHAR(MAX)
	-- Declare cursor for Preferences
	DECLARE preferenceCursor CURSOR FAST_FORWARD FOR
	SELECT	 U.UserGUID AS UserGUID,U.UserName AS UserName,U.ViewId AS ViewId,
			 U.ViewName AS ViewName,S.FieldLabel AS FieldLabel,S.InitialDefaultValue AS DefaultValue
	FROM
	(
		(
			SELECT * FROM #tblUserGuidViews
		) AS U
		CROSS APPLY
		(
			-- if @bitVisibility = -1 means invalid site mode, so we won't return any list
		    -- if @bitVisibility = 0 means client program not interested in site mode filtering, so we return all preferences and its values
			SELECT FieldLabel,InitialDefaultValue
			FROM DMSearchCriteriaField
			WHERE GroupId = 9 AND @bitVisibility <> -1
				AND (LEN(ISNULL(@i_PrefNames,'')) = 0 OR (FieldLabel IN (SELECT ID FROM dbo.splitStringToTable(@i_PrefNames))))
			AND ( (@bitVisibility = 0) OR (@bitVisibility > 0 AND (BitVisibility & @bitVisibility)>0) )
		) AS S
	)
	OPEN preferenceCursor
	FETCH NEXT FROM preferenceCursor INTO	@cUserGuid,@cUserName,@cViewId,
											@cViewName,@cPrefName,@cDefaultValue
		-----------------------Begin Cursor -----------------------
	WHILE @@FETCH_STATUS = 0
	BEGIN
		/*
		*	The hierarchy is as follows
			1. DMUserPref table where AdminFlag = 0 AND !Disable enduser setting
			2. DMUserPref table where AdminFlag = 1
			3. DMAdminPref table
			4. Default value
		*/
		------Variables to be inserted into the temp table
		DECLARE @tUserPrefValue		VARCHAR(MAX) = '',
				@tModifiedTime		DATETIME,
				@tModifiedUserGuid	VARCHAR(MAX) = ''
		-----+++++++++++++++++++++ DMUserPref Table where AdminFlag = 0 AND !Disable enduser setting+++++++++++++++++++--------------
		IF(@SettingVal = 0 AND EXISTS(	SELECT TOP 1 P_Id FROM DMUserPref
									WHERE   UserGUID		= @cUserGuid
										AND UserPrefName	= @cPrefName
										AND ViewId			= @cViewId
										AND	AdminFlag		= 0))
		BEGIN
			SELECT	@tUserPrefValue		= UserPrefValue,
					@tModifiedTime		= CreateTime,
					@tModifiedUserGuid	= ModifiedBy
			FROM DMUserPref
			WHERE   UserGUID			= @cUserGuid
					AND UserPrefName	= @cPrefName
					AND ViewId			= @cViewId
					AND	AdminFlag		= 0
		END
		-----+++++++++++++++++++++ DMUserPref Table where AdminFlag = 1 +++++++++++++++++++--------------
		ELSE IF( EXISTS(SELECT TOP 1 P_Id FROM DMUserPref
						WHERE   UserGUID		= @cUserGuid
							AND UserPrefName	= @cPrefName
							AND ViewId			= @cViewId
							AND	AdminFlag		= 1))
		BEGIN
			SELECT	@tUserPrefValue		= UserPrefValue,
					@tModifiedTime		= CreateTime,
					@tModifiedUserGuid	= ModifiedBy
			FROM DMUserPref
			WHERE   UserGUID			= @cUserGuid
					AND UserPrefName	= @cPrefName
					AND ViewId			= @cViewId
					AND	AdminFlag		= 1
		END
		-----+++++++++++++++++++++ DMAdminPref Table	+++++++++++++++++++--------------
		ELSE IF( EXISTS(SELECT TOP 1 Id FROM DMAdminPref
						WHERE   PrefName	= @cPrefName
							AND ViewName	= @cViewId))
		BEGIN
			SELECT	@tUserPrefValue		= PrefValue,
					@tModifiedTime		= ModifiedTime,
					@tModifiedUserGuid	= ModifiedBy
			FROM DMAdminPref
			WHERE   PrefName	= @cPrefName
				AND ViewName	= @cViewId
		END
		-----+++++++++++++++++++++ DEFAULT VALUE	+++++++++++++++++++--------------
		ELSE
		BEGIN
			SELECT	@tUserPrefValue		= @cDefaultValue,
					@tModifiedUserGuid	= 'N/A',
			--GET DATE FROM DMSetting TABLE. IF NOT EXISTS ASSIGN TODAY'S DATE
					@tModifiedTime = ISNULL((SELECT TOP 1 CreateTime
										 FROM DMSetting
										 WHERE SettingName = 'DEFAULT_'+@cPrefName),
										 GETUTCDATE());
		END
		-----+++++++++++++++++++++ INSERT INTO TEMP TABLE +++++++++++++++++++--------------
		INSERT #tblAllResults
			(UserGUID,UserName,ViewName,
			UserPrefName,UserPrefValue,LastModifiedTime,
			Setting)
		VALUES
			(@cUserGuid,@cUserName,@cViewName,
			@cPrefName,@tUserPrefValue,@tModifiedTime,
			ISNULL((SELECT TOP 1 UserName
					FROM DMUserSession
					WHERE UserGUID= @tModifiedUserGuid),
					'System'))
	 FETCH NEXT FROM preferenceCursor INTO	@cUserGuid,@cUserName,@cViewId,
											@cViewName,@cPrefName,@cDefaultValue
	END
		----------------------- END	Cursor -----------------------
	CLOSE preferenceCursor
	DEALLOCATE preferenceCursor
	IF @endNo <=0
		SELECT @endNo = COUNT(*) FROM #tblAllResults
	select @o_Count = COUNT(*) from #tblAllResults
	IF(LEN(ISNULL(@i_OrderByClause,'')) = 0)
		SET @i_OrderByClause = 'ViewName'
	SET @sqlStmt = 	'SELECT UserGUID,UserName,ViewName,UserPrefName,UserPrefValue,LastModifiedTime,Setting '+
		' FROM #tblAllResults '+
		' WHERE cnt BETWEEN ' + CONVERT(VARCHAR(MAX),@stNo) + ' AND '+ CONVERT(VARCHAR(MAX),@endNo) +
		' ORDER BY ' + @i_OrderByClause
	EXEC sp_executesql @sqlStmt
	DROP TABLE #tblAllResults
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetUserPref')
	delete from GxQscripts where name = 'sp_dm2_GetUserPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserPref'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetUserPref',  '00010012000000000000', 'sp_dm2_GetUserPref', '00010012000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetUserSession.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetUserSession()
--  | Description:  Get User Session Info
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetUserSession.sp,v $ $Id: sp_dm2_GetUserSession.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetUserSession <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetUserSession')
	drop procedure sp_dm2_GetUserSession
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetUserSession')
	delete from GxQscripts where name = 'sp_dm2_GetUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserSession'
GO
print '... Creating Procedure: sp_dm2_GetUserSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetUserSession
  @i_UserGUID varchar(36) = ''
AS
  if @i_UserGUID != ''
	select * from [DMUserSession] WITH (READUNCOMMITTED)
	where UserGUID = @i_UserGUID
	order by CreateTime desc
  else
	select distinct UserGUID, UserName from [DMUserSession]	   WITH (READUNCOMMITTED)
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetUserSession')
	delete from GxQscripts where name = 'sp_dm2_GetUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserSession'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetUserSession',  '00010001000000000000', 'sp_dm2_GetUserSession', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetAdvSearchGroupData.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetAdvSearchGroupData.sp,v $ $Id: sp_dm2_GetAdvSearchGroupData.sp,v 1.7 2012/02/24 21:49:15 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetAdvSearchGroupData <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetAdvSearchGroupData')
	drop procedure sp_dm2_GetAdvSearchGroupData
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetAdvSearchGroupData')
	delete from GxQscripts where name = 'sp_dm2_GetAdvSearchGroupData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAdvSearchGroupData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAdvSearchGroupData'
GO
print '... Creating Procedure: sp_dm2_GetAdvSearchGroupData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetAdvSearchGroupData
  @i_SiteMode varchar(50) = '',
  @i_GroupId integer = 10
AS
SET NOCOUNT ON
	IF @i_GroupId > 0
	BEGIN
		SELECT G.*, ISNULL(C.AllowedCount, 1) as AllowedCount FROM [DMSearchCriteriaGroup] G WITH (READUNCOMMITTED)
		LEFT JOIN [DMSearchGroupAssociation] C ON G.Id = C.GroupId
		WHERE G.Id = @i_GroupId
		ORDER BY G.DisplayOrder
	END
	ELSE
	BEGIN
		DECLARE @BinaryWeight INT
		SELECT @BinaryWeight = BinaryWeightage FROM [DMSearchView] WHERE ViewName = @i_SiteMode
		SELECT G.*, ISNULL(C.AllowedCount, 1) as AllowedCount FROM [DMSearchCriteriaGroup] G WITH (READUNCOMMITTED)
		LEFT JOIN [DMSearchGroupAssociation] AS C ON G.Id = C.GroupId AND C.ViewName = @i_SiteMode
		WHERE @BinaryWeight & G.BitVisibility > 0
		ORDER BY G.DisplayOrder
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetAdvSearchGroupData')
	delete from GxQscripts where name = 'sp_dm2_GetAdvSearchGroupData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAdvSearchGroupData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAdvSearchGroupData'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetAdvSearchGroupData',  '00010007000000000000', 'sp_dm2_GetAdvSearchGroupData', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetAdvSearchFieldData.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetAdvSearchFieldData.sp,v $ $Id: sp_dm2_GetAdvSearchFieldData.sp,v 1.10 2012/08/17 18:24:57 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetAdvSearchFieldData <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetAdvSearchFieldData')
	drop procedure sp_dm2_GetAdvSearchFieldData
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetAdvSearchFieldData')
	delete from GxQscripts where name = 'sp_dm2_GetAdvSearchFieldData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAdvSearchFieldData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAdvSearchFieldData'
GO
print '... Creating Procedure: sp_dm2_GetAdvSearchFieldData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetAdvSearchFieldData
  @i_SiteMode varchar(50) = '',
  @i_GroupID int = 0
AS
SET NOCOUNT ON
DECLARE @hideTagsFeature BIT
SET @hideTagsFeature = 1
--Check if feature is OFF by default
IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'SEARCH_BY_TAGS' and SettingValue = 'True')
BEGIN
	SET @hideTagsFeature = 0
END
SELECT A.*, ISNULL(B.FriendlyName, '') as FieldName
FROM [DMSearchCriteriaField] A
WITH (READUNCOMMITTED)
LEFT JOIN [DMIndexProfile] B ON A.IdxFieldId = B.FieldId
WHERE A.GroupId = @i_GroupID AND ((SELECT BinaryWeightage FROM [DMSearchView] WHERE ViewName = @i_SiteMode) & A.BitVisibility > 0)
AND (@hideTagsFeature = 0 OR (@hideTagsFeature = 1 AND A.Id <> '0E419A91-0BCC-47CA-A2DE-57770C9AAAF1')) -- Tags in Common group
ORDER BY FieldDisplayOrder ASC
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetAdvSearchFieldData')
	delete from GxQscripts where name = 'sp_dm2_GetAdvSearchFieldData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAdvSearchFieldData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAdvSearchFieldData'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetAdvSearchFieldData',  '00010010000000000000', 'sp_dm2_GetAdvSearchFieldData', '00010010000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetSearchParameter.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetSearchParameter.sp,v $ $Id: sp_dm2_GetSearchParameter.sp,v 1.1 2009/05/18 13:02:26 sgupta Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetSearchParameter <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetSearchParameter')
	drop procedure sp_dm2_GetSearchParameter
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetSearchParameter')
	delete from GxQscripts where name = 'sp_dm2_GetSearchParameter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetSearchParameter')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetSearchParameter'
GO
print '... Creating Procedure: sp_dm2_GetSearchParameter'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetSearchParameter
AS
SET NOCOUNT ON
	SELECT * FROM [DMSearchParameter] WITH (READUNCOMMITTED)
	ORDER BY Id
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetSearchParameter')
	delete from GxQscripts where name = 'sp_dm2_GetSearchParameter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetSearchParameter')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetSearchParameter'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetSearchParameter',  '00010001000000000000', 'sp_dm2_GetSearchParameter', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetSearchParamPreference.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetSearchParamPreference.sp,v $ $Id: sp_dm2_GetSearchParamPreference.sp,v 1.1 2009/05/18 13:02:18 sgupta Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetSearchParamPreference <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetSearchParamPreference')
	drop procedure sp_dm2_GetSearchParamPreference
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetSearchParamPreference')
	delete from GxQscripts where name = 'sp_dm2_GetSearchParamPreference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetSearchParamPreference')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetSearchParamPreference'
GO
print '... Creating Procedure: sp_dm2_GetSearchParamPreference'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetSearchParamPreference
  @i_ParamID int = 0,
  @i_UserGuid varchar(36) = ''
AS
SET NOCOUNT ON
	SELECT PP.PreferredValue FROM [DMSearchParamPreference] AS PP,
	[DMSearchParameter] AS P WITH (READUNCOMMITTED)
	WHERE (PP.UserGuid = @i_UserGuid)
	AND (PP.ParamId = P.Id)
	AND (PP.ParamId = @i_ParamID)
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetSearchParamPreference')
	delete from GxQscripts where name = 'sp_dm2_GetSearchParamPreference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetSearchParamPreference')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetSearchParamPreference'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetSearchParamPreference',  '00010001000000000000', 'sp_dm2_GetSearchParamPreference', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_MarkRestoreFailedBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_MarkRestoreFailedBulk()
--  | Description:  Mark the failed restored jobs
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_MarkRestoreFailedBulk.sp,v $ $Id: sp_dm2_MarkRestoreFailedBulk.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_MarkRestoreFailedBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_MarkRestoreFailedBulk')
	drop procedure sp_dm2_MarkRestoreFailedBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_MarkRestoreFailedBulk')
	delete from GxQscripts where name = 'sp_dm2_MarkRestoreFailedBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MarkRestoreFailedBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_MarkRestoreFailedBulk'
GO
print '... Creating Procedure: sp_dm2_MarkRestoreFailedBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_MarkRestoreFailedBulk
  @i_jobId Integer,
  @i_xml_AFOffsets XML
AS
BEGIN
-- expects a list like
-- <failedlist>
--    <file CCId="2" AFId="2" AFOff="27" />
--    <file CCId="2" AFId="4" AFOff="37" />
--    <file CCId="2" AFId="6" AFOff="909" />
-- </failedlist>
	DECLARE @lt_AFOffsets TABLE (CCId int, AFId bigint, AFOff bigInt)
	INSERT INTO @lt_AFOffsets
	SELECT T.c.value('@CCId','int'),
		   T.c.value('@AFId', 'bigint'),
		   T.c.value('@AFOff', 'bigint')
	FROM   @i_xml_AFOffsets.nodes('/failedlist/file') T(c)
	UPDATE DMResultSet
	SET   RestoreStatus = 5
	FROM  @lt_AFOffsets tt
    WHERE CommcellNumber= tt.CCId AND aFileID = tt.AFId  and aFileoffset = tt.AFOff
	-- and jobid equals whatever
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_MarkRestoreFailedBulk')
	delete from GxQscripts where name = 'sp_dm2_MarkRestoreFailedBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MarkRestoreFailedBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_MarkRestoreFailedBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_MarkRestoreFailedBulk',  '00010001000000000000', 'sp_dm2_MarkRestoreFailedBulk', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_MarkRestoreFailedForObject.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_MarkRestoreFailedForObject()
--  | Description:  Mark the failed restored jobs
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_MarkRestoreFailedForObject.sp,v $ $Id: sp_dm2_MarkRestoreFailedForObject.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_MarkRestoreFailedForObject <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_MarkRestoreFailedForObject')
	drop procedure sp_dm2_MarkRestoreFailedForObject
IF EXISTS (select * from GxQscripts where name='sp_dm2_MarkRestoreFailedForObject')
	delete from GxQscripts where name = 'sp_dm2_MarkRestoreFailedForObject'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MarkRestoreFailedForObject')
	delete from GXDBVersions where aliasname = 'sp_dm2_MarkRestoreFailedForObject'
GO
print '... Creating Procedure: sp_dm2_MarkRestoreFailedForObject'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_MarkRestoreFailedForObject
  @i_RestoreJobID int,
  @i_aFileID bigint,
  @i_aFileoffset bigint
AS
BEGIN
	  update DMResultSet
	  set   RestoreStatus = 5
		-- 5 = failed
	  where aFileID = @i_aFileID
	  and aFileoffset = @i_aFileoffset
	  -- and RestoreJobID = @i_RestoreJobID
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_MarkRestoreFailedForObject')
	delete from GxQscripts where name = 'sp_dm2_MarkRestoreFailedForObject'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MarkRestoreFailedForObject')
	delete from GXDBVersions where aliasname = 'sp_dm2_MarkRestoreFailedForObject'
GO

insert into GXDBVersions values(2, 'sp_dm2_MarkRestoreFailedForObject',  '00010001000000000000', 'sp_dm2_MarkRestoreFailedForObject', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_MoveFailedLegalHoldItems.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_MoveFailedLegalHoldItems()
--  | Description:  Moved failed LegalHold Items
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_MoveFailedLegalHoldItems.sp,v $ $Id: sp_dm2_MoveFailedLegalHoldItems.sp,v 1.4 2015/04/16 18:51:18 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_MoveFailedLegalHoldItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_MoveFailedLegalHoldItems')
	drop procedure sp_dm2_MoveFailedLegalHoldItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_MoveFailedLegalHoldItems')
	delete from GxQscripts where name = 'sp_dm2_MoveFailedLegalHoldItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MoveFailedLegalHoldItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_MoveFailedLegalHoldItems'
GO
print '... Creating Procedure: sp_dm2_MoveFailedLegalHoldItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_MoveFailedLegalHoldItems
  @i_CompPolicyId varchar(36),
  @i_ContainerID varchar(36),
  @i_UserGUID varchar(36)
AS
DECLARE @o_alreadyExistsInContainer INT = 0,
				@o_alreadyExistsWithNewId INT = 0,
				@o_duplicateEntries	INT = 0,
				@o_existsInDMresultSet	INT = 0,
				@o_newlyInserted		INT = 0,
				@o_newlyAddedInDMResultSet INT = 0,
				@o_errorCode		INT = 0,
				@o_errorMessage		NVARCHAR(MAX) = ''
	BEGIN TRY
		DECLARE @l_CURRENTDATE DATETIME = GETUTCDATE();
		DECLARE @l_status INT = 0
		-- dmsetting to over ride default faile status
		--  0 or null - fetch failed items
		--  1			- fetch success items
		-- -1			- move all items
		SELECT @l_status = CONVERT(INT,ISNULL(SettingValue,'0')) FROM DMSetting WHERE SettingName = 'MOVE_LEGALHOLD_ITEMS_FETCH_STATUS'
		IF OBJECT_ID('tempdb.dbo.#tblMoveLegalHoldItems') IS NOT NULL
			DROP TABLE #tblMoveLegalHoldItems
		CREATE TABLE #tblMoveLegalHoldItems (
				ID INT IDENTITY(1,1),
				jobId INT,
				ResultSetID VARCHAR(36),
				isDMResultSetExists BIT DEFAULT 0
		)
		CREATE INDEX IDX_tblMoveLegalHoldItems_ResultSetId ON #tblMoveLegalHoldItems(ResultSetID)
		CREATE INDEX IDX_tblMoveLegalHoldItems_isDMResultSetExists ON #tblMoveLegalHoldItems(isDMResultSetExists)
	  -- Get all Failed items
		INSERT 	INTO #tblMoveLegalHoldItems (jobId, ResultSetID)
		SELECT 	LH.JobId, LH.ResultSetID
		FROM 	dmLegalHoldItemsToBackup LH	  WITH (READUNCOMMITTED)
		WHERE 	LH.CompPolicyId = @i_CompPolicyID
		AND		(@l_status = -1 OR LH.BackupStatus = @l_status)
		AND 	ISNULL(LH.ResultSetID,'') <> ''
		IF  NOT EXISTS(SELECT TOP 1 * FROM #tblMoveLegalHoldItems)
		BEGIN
			SELECT @o_errorCode = 9524,
					@o_errorMessage = 'No items found for copying from legalhold for criteria CompPolicyId :[' + @i_CompPolicyId + '] ,status: [' + CONVERT(VARCHAR(20),@l_status) + ']'
			GOTO CX_EXIT
		END
		--delete duplicates
		DELETE 	FROM #tblMoveLegalHoldItems
		WHERE ID NOT IN
		(
			SELECT MAX(ID)
			FROM #tblMoveLegalHoldItems
			GROUP BY ResultSetID
		)
		SELECT @o_duplicateEntries = @@ROWCOUNT
		-- if already exists
		DELETE t
		FROM #tblMoveLegalHoldItems t
				INNER JOIN
			DMContainerItem AS C WITH (NOLOCK)
		ON t.ResultSetID = C.ResultSetID AND C.ContainerID = @i_ContainerID
		SELECT @o_alreadyExistsInContainer = @@ROWCOUNT
		--update flag that exists in DMResultset table
		UPDATE #tblMoveLegalHoldItems
		SET isDMResultSetExists = 1
		FROM #tblMoveLegalHoldItems as T
				INNER JOIN
			DMResultSet AS R WITH(NOLOCK)
		ON R.ResultSetID = T.ResultSetID
		INSERT INTO DMContainerItem (ContainerID, ResultSetID, UserGUID,QueryID,Attribute,CreateTime)
		SELECT DISTINCT @i_ContainerID,T.ResultSetID, @i_UserGUID, '',0 , @l_CURRENTDATE --ignore duplicates
		FROM #tblMoveLegalHoldItems AS T WHERE T.isDMResultSetExists = 1
		SELECT @o_newlyInserted = @@ROWCOUNT
		-- DELETE which are inserted.
		DELETE #tblMoveLegalHoldItems
		WHERE isDMResultSetExists = 1
		--now create ResultSet
		WHILE EXISTS (SELECT TOP 1 * from #tblMoveLegalHoldItems)
		BEGIN
			--declare all local variable for processing..
			DECLARE @l_lhId INT = 0,
					@l_jobId	INT = 0,
					@l_resultsetId	VARCHAR(36) = ''
			SELECT Top  1 @l_lhId = ID , @l_jobId = T.jobId, @l_resultsetId = T.ResultSetID	FROM #tblMoveLegalHoldItems as T
			--
			DECLARE @l_metaDataXML NVARCHAR(max) = '',
					@inputXML XML,
					@count INTEGER,
					@ResultSetID VARCHAR(36) = '',
					@ResultSetXMLStr NVARCHAR(MAX) = '',
					@ResultSetXML XML,
					@OrigResultSetID	NVARCHAR(36) = @l_resultsetId,
					@ownerField NVARCHAR(MAX) = N''
			SELECT @l_metaDataXML = L.MetaDataXML  FROM DMLegalHoldItemsToBackup AS L WITH (NOLOCK)
			WHERE L.CompPolicyId = @i_CompPolicyId AND L.JobId = @l_jobId AND L.ResultSetID = @l_resultsetId
			SET	@inputXML = CONVERT(XML, @l_metaDataXML, 1)
			SELECT @count = COUNT(*) FROM @inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
			--Translate old LegalHold MetaDataXML to 9.0 format
			IF @count = 0
			BEGIN
				SET @inputxml = CAST(dbo.ConvertLegalHoldMetaDataXMLTo900XMLManaged(@l_metaDataXML) AS XML)
			END
			-------------------++++++++++++++++ temp tables for storing parsed XML and updating +++++++++++++++++++++++++++++++++---------------------
			DECLARE @tblResultSet TABLE
			(
				filePath				NVARCHAR(max),
				fileName				NVARCHAR(1024),
				folderPath				NVARCHAR(max),
				appType					INTEGER,
				appId					INTEGER,
				commcellNo				INTEGER,
				clientId				INTEGER,
				pushError				NVARCHAR(max),
				sizeKB					FLOAT,
				MIMEType				NVARCHAR(256),
				modifiedTime			BIGINT,
				jobId					INTEGER,
				contentIndexingJobId	INTEGER,
				backupTime				BIGINT,
				aFileId					INTEGER,
				aFileOffset				BIGINT,
				aFileLength				BIGINT,
				dynTeaser				NVARCHAR(max),
				rank					FLOAT,
				documentId				VARCHAR(256),
				ownerField				NVARCHAR(MAX),
				lnks					NVARCHAR(MAX)
			)
			DECLARE @tblUserComments TABLE
			(
				UserGUID			VARCHAR(36),
				CreationDateTime	VARCHAR(25),
				ModifiedDateTime	VARCHAR(25),
				Comments			NVARCHAR(max)
			)
			DECLARE @tblAssignedUser TABLE
			(
				AssignId		INTEGER,
				StateID			VARCHAR(36),
				UserNotes		NVARCHAR(max),
				UserGUID		VARCHAR(36),
				ReviewSetTags	XML,
				CITags			XML
			)
			DECLARE @tblUserTags TABLE
			(
				AssignId	INTEGER,
				UserGUID	VARCHAR(36),
				TagId		VARCHAR(36)
			)
			--clean table
			delete @tblResultSet
			delete @tblUserComments
			delete @tblUserTags
			delete @tblAssignedUser
			INSERT	INTO @tblResultSet
			SELECT	T.item.value('@filePath', 'NVARCHAR(max)'),
					T.item.value('@fileName', 'NVARCHAR(1024)'),
					T.item.value('@folderPath', 'NVARCHAR(max)'),
					T.item.value('@appType', 'INTEGER'),
					T.item.value('@appId', 'INTEGER'),
					T.item.value('@commcellNo', 'INTEGER'),
					T.item.value('@clientId', 'INTEGER'),
					T.item.value('@pushError', 'NVARCHAR(max)'),
					T.item.value('@sizeKB', 'FLOAT'),
					T.item.value('@MIMEType', 'NVARCHAR(256)'),
					T.item.value('@modifiedTime', 'BIGINT'),
					T.item.value('@jobId', 'INTEGER'),
					T.item.value('@contentIndexingJobId', 'INTEGER'),
					T.item.value('@backupTime', 'BIGINT'),
					T.item.value('@aFileId', 'INTEGER'),
					T.item.value('@aFileOffset', 'BIGINT'),
					T.item.value('@aFileLength', 'BIGINT'),
					T.item.value('@dynTeaser', 'NVARCHAR(max)'),
					T.item.value('@rank', 'FLOAT'),
					T.item.value('@documentId', 'VARCHAR(256)'),
					T.item.value('./appSpecific[1]/eMail[1]/@from','NVARCHAR(max)'),
					T.item.value('./appSpecific[1]/eMail[1]/@links','NVARCHAR(max)')
			FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
			UPDATE @tblResultSet
			SET filePath = CASE WHEN filePath IS null THEN
									N''
								ELSE filePath END
			--------------------+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++-----------------------
			SET @ResultSetID = (SELECT TOP 1 R.ResultSetID FROM DMResultSet AS R WITH (NOLOCK)
									INNER JOIN
									@tblResultSet AS T
									ON T.aFileId = R.aFileID AND T.commcellNo = R.CommCellNumber AND T.aFileOffset = R.aFileOffset)
			IF ISNULL(@ResultSetID , '' ) = ''
			BEGIN
				--PopulateOwnerField only if required
				IF EXISTS (SELECT * FROM DMUIAppTypeMap
							WHERE AppTypeId = (SELECT TOP 1 appType FROM @tblResultSet)
								AND IsEmailAppType = 1)
				BEGIN
					DECLARE @getOwnerAsMailBoxOwner NVARCHAR(10) = 'False',
							@lnks NVARCHAR(MAX) = '',
							@fromField NVARCHAR(MAX) = '',
							@filePath NVARCHAR(MAX) = ''
					SELECT @getOwnerAsMailBoxOwner = SettingValue
					FROM DMSetting WHERE SettingName = 'POPULATE_OWNERFIELD_AS_MAILBOXOWNER'
					SELECT @lnks = T.lnks,@fromField = T.ownerField, @filePath = T.filePath
					FROM @tblResultSet AS T
					--Now populate the ownerField by calling the CLR function
					--Syntax:
					--[dbo].[GetOwnerFieldManaged](@fromField [nvarchar](max), @lnks [nvarchar](max), @filePath [nvarchar](max), @getMailOwnerStr [nvarchar](10))
					SELECT @ownerField = dbo.GetOwnerFieldManaged(@fromField,@lnks,@filePath,@getOwnerAsMailBoxOwner)
				END
				--Convert to lower case
				SELECT @ownerField = LOWER(ISNULL(@ownerField,N''))
				SET @ResultSetID = NEWID()	-- new ResultSetId
				INSERT INTO DMResultSet
					(ResultSetID,CommCellNumber,aFileID,aFileOffset,aFileLength,
					AppType,FileSizeKB,ModifiedTime,JobId,OriginalFullPath,
					DestinationPath,CreateTime,RestoreUserGUID,RestoreCommCellNumber,RestoreJobID,
					RestoreStatus,RestoreTime,Attribute,
					documentID,ClientID,ERMStatus,
					Title)
				SELECT
					@ResultSetID, T.commcellNo, T.aFileId, T.aFileOffset, T.aFileLength,
					appType, sizeKB, dbo.GetDateTime(modifiedTime), jobId, filePath,
					'', GETDATE(), @i_UserGUID, 0,0,
					0, null, 0,
					T.documentId, clientId,0,
					fileName
				FROM	@tblResultSet as T
				SET @o_newlyAddedInDMResultSet = @o_newlyAddedInDMResultSet + 1
				INSERT INTO DMResultSetInfo
				SELECT	@ResultSetID, ''
				FROM	@tblResultSet
				--Translate to DM2ContentIndexing_GResultItem Root tag
				SELECT @ResultSetXML = CAST(dbo.fn_dm2_GetLatestResultSetXML(@ResultSetID, CAST(@inputxml.query('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') AS NVARCHAR(max))) AS XML)
				IF @ResultSetXML.exist('//DM2ContentIndexing_GResultItem[@ResultItemID]') = 0
					SET @ResultSetXML.modify('insert attribute ResultItemID {sql:variable("@ResultSetID")} into (/DM2ContentIndexing_GResultItem)[1]')
				ELSE
					SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@ResultItemID)[1] with sql:variable("@ResultSetID")')
				--check whether the ownerField is populated in the GResultItem
				--if not insert new attribute
				IF(@ResultSetXML.exist('//DM2ContentIndexing_GResultItem/appSpecific/eMail/@owner')  = 0)
					SET @ResultSetXML.modify('insert attribute owner {sql:variable("@ownerField")}
					into (/DM2ContentIndexing_GResultItem/appSpecific/eMail)[1]')
				ELSE
					SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/appSpecific/eMail/@owner)[1]
					with sql:variable("@ownerField") ')
				SELECT @ResultSetXMLStr = CAST(@ResultSetXML AS NVARCHAR(MAX))
				UPDATE DMResultSetInfo
				SET ResultSet = @ResultSetXMLStr
				WHERE ResultSetID = @ResultSetID
			END
			ELSE
			BEGIN
				SET @o_alreadyExistsWithNewId += 1
			END
			-------------------------+++++++++++++++++++++++ Populate DMEail table+++++++++++++++++++---------------------
			IF EXISTS (SELECT * FROM DMUIAppTypeMap
						WHERE AppTypeId = (SELECT TOP 1 appType FROM @tblResultSet)
							AND IsEmailAppType = 1)
			BEGIN
				DECLARE @ResultSetTable AS ResultSetType
				INSERT INTO @ResultSetTable	-- ONly one item will get inserted.
				SELECT ResultSetID, CAST(ResultSet AS XML) FROM DMResultSetInfo WITH (NOLOCK)
				WHERE ResultSetID = @ResultSetID
				IF EXISTS (SELECT TOP 1 * FROM @ResultSetTable)
				BEGIN
					IF OBJECT_ID('tempdb.dbo.#tmpDMEmailFields') IS NOT NULL
						DROP TABLE #tmpDMEmailFields
					CREATE TABLE #tmpDMEmailFields
					(
						resultSetID VARCHAR(36),
						subjectField NVARCHAR(MAX),
						toField NVARCHAR(MAX),
						fromField NVARCHAR(MAX),
						bccField NVARCHAR(MAX),
						ccField NVARCHAR(MAX)
					);
					INSERT INTO #tmpDMEmailFields
					SELECT T.ResultSetId,T.subjectField,T.toField,T.fromField,T.bccField,T.ccField
					FROM dbo.fn_dm2_GetValuesForEmailFields(@ResultSetTable) AS T
					IF EXISTS (SELECT E.ResultSetID FROM DMEmailResult E WITH(NOLOCK) inner join @ResultSetTable as TR ON E.ResultSetID = TR.ResultSetID)
					BEGIN
						UPDATE DMEmailResult
						SET EmailSubject = TR.subjectField, EmailFROM = TR.fromField, EmailTO = TR.toField, EmailCC = TR.ccField, EmailBCC = TR.bccField,
						SavedTime = GETUTCDATE()
						FROM #tmpDMEmailFields TR
						WHERE DMEmailResult.ResultSetID = TR.ResultSetID
					END
					ELSE
						INSERT INTO DMEmailResult (ResultSetID,EmailSubject,EmailFROM,EmailTO,EmailCC,EmailBCC,SavedTime)
						SELECT TR.ResultSetID, TR.subjectField, TR.fromField, TR.toField, TR.ccField, TR.bccField, GETUTCDATE() FROM #tmpDMEmailFields TR
				END
			END
			--------------------+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++-----------------------
			--------------------++++++++++++++++++++++++++Inserts in all required tables++++++++++++++++++++++++++-----------------------
																																											IF NOT EXISTS (	SELECT *
						FROM	DMContainerItem		WITH (READUNCOMMITTED)
						WHERE	ContainerID = @i_ContainerID
						AND		ResultSetID = @ResultSetID)
			BEGIN
				INSERT INTO DMContainerItem
				values(@i_ContainerID, '', @ResultSetID, @l_CURRENTDATE, 0, @i_UserGUID)
				INSERT INTO @tblUserComments
				SELECT	ISNULL(T.item.value('userInfo[1]/@userGuid', 'VARCHAR(36)'), ''),
								ISNULL(T.item.value('userComment[1]/@creationDateTime', 'VARCHAR(25)'), ''),
								ISNULL(T.item.value('userComment[1]/@modifiedDateTime', 'VARCHAR(25)'), ''),
								ISNULL(T.item.value('userComment[1]/@comments', 'NVARCHAR(MAX)'), '')
				FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/userCommentInformation/userCommentInfo') T(item)
				SET @o_newlyInserted += 1
				IF EXISTS (SELECT UserGUID FROM @tblUserComments WHERE Comments IS NOT NULL)
					INSERT	INTO DMUserComment
					SELECT NEWID(), UserGUID, '', @i_ContainerID, @ResultSetID, NULL, Comments, CONVERT(DATETIME, CreationDateTime), 0, CONVERT(DATETIME, ModifiedDateTime)
					FROM @tblUserComments
					WHERE Comments IS NOT NULL
			END
			ELSE
			BEGIN
				UPDATE DMContainerItem
				SET Attribute = Attribute & ~4
				WHERE ContainerID = @i_ContainerID
				AND ResultSetID = @ResultSetID
				AND	Attribute & 4 = 4
				UPDATE DMUserComment
				SET Attribute = Attribute & ~4
				WHERE ContainerID = @i_ContainerID
				AND ResultSetID = @ResultSetID
				AND	Attribute & 4 = 4
			END
				--Get Assigned User Info
											INSERT INTO @tblAssignedUser
			SELECT	ISNULL(T.item.value('@assignID', 'INTEGER'), ''),
					ISNULL(T.item.value('docState[1]/@stateID', 'VARCHAR(36)'), ''),
					T.item.value('docState[1]/@stateDescription', 'NVARCHAR(max)'),
					ISNULL(T.item.value('userInformation[1]/@userGuid', 'VARCHAR(36)'), ''),
					T.item.query('./ReviewSetTags'),
					T.item.query('./CITags')
			FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/assignedUserInfo/assignedUser') T(item)
									INSERT INTO @tblUserTags
			SELECT	0, UserGUID, T.c.value('@id', 'VARCHAR(36)')
			FROM	@tblAssignedUser CROSS APPLY CITags.nodes('/CITags') T(c)
			UNION
			SELECT	0, UserGUID, T.c.value('@id', 'VARCHAR(36)')
			FROM	@tblAssignedUser CROSS APPLY ReviewSetTags.nodes('/ReviewSetTags') T(c)
				-- Update the deleted flag if the entry already exists
										UPDATE DMContainerItemStates
			SET Attribute = Attribute & ~4
			FROM @tblAssignedUser AS TT, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
			WHERE CIS.ContainerId = @i_ContainerId
			AND 	CIS.ResultSetId = @ResultSetID
			AND		CIS.AssignedUserGUID = TT.UserGUID
			AND		CIS.Attribute & 4 = 4
				--Insert entries if not exists
										INSERT INTO DMContainerItemStates
			SELECT @i_ContainerID, @ResultSetID, TT.UserGUID, TT.StateID, getUTCDate(), @i_UserGUID, TT.UserNotes, 0
			FROM @tblAssignedUser AS TT
			WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemStates AS CIS WITH (READUNCOMMITTED)
									WHERE CIS.ContainerId = @i_ContainerId
									AND 	CIS.ResultSetId = @ResultSetID
									AND		CIS.AssignedUserGUID = TT.UserGUID)
				UPDATE @tblUserTags
				SET assignID = CIS.assignID
				FROM @tblUserTags TT, DMContainerItemStates CIS WITH (NOLOCK)
				WHERE CIS.ContainerId = @i_ContainerId
				AND 	CIS.ResultSetId = @ResultSetID
				AND		CIS.AssignedUserGUID = TT.UserGUID
				-- Update the deleted flag if the entry already exists
									UPDATE DMContainerItemTags
			SET 	Attribute = Attribute & ~4
			FROM 	DMContainerItemTags CIT, @tblUserTags AS TT
			WHERE CIT.assignID = TT.assignID
			AND		CIT.TagID = TT.TagID
			AND		CIT.Attribute & 4 = 4
				-- Update the deleted flag if the entry already exists
										UPDATE DMUserItemTags
			SET 	Attribute = Attribute & ~4
			FROM 	DMUserItemTags UIT, @tblUserTags AS TT
			WHERE UIT.UserGUID = TT.UserGUID
			AND		UIT.ResultSetID = @ResultSetID
			AND		UIT.TagID = TT.TagID
			AND		UIT.Attribute & 4 = 4
				--Create entries if not exists
									INSERT INTO DMContainerItemTags
			SELECT TT.AssignID, TT.TagID, getUTCDate(), @i_UserGUID, '', 0
			FROM	@tblUserTags AS TT
			WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemTags AS CIT WITH (NOLOCK)
									WHERE CIT.AssignID = TT.AssignID
									AND		CIT.TagID = TT.TagID)
				-- Remove all DB Tags if User Tags already exists
													DELETE DMContainerItemTags
			FROM 	DMContainerItemTags AS CIT, DMContainerItemStates AS CIS WITH (NOLOCK), DMUserItemTags UIT WITH (NOLOCK), @tblUserTags AS TT
			WHERE CIS.ResultSetId = UIT.ResultSetId
				AND		CIS.AssignedUserGUID = UIT.UserGUID
				AND		CIS.AssignID = CIT.AssignID
				AND		CIT.TagID = UIT.TagID
				AND		UIT.ResultSetId = @ResultSetID
				AND		UIT.UserGUID = TT.UserGUID
				AND		UIT.TagID = TT.TagID
				AND		UIT.Attribute & 4 = 0
				--------------------+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++-----------------------
				--delete entry from temp table
				DELETE #tblMoveLegalHoldItems WHERE ID = @l_lhId
		END
	END TRY
	BEGIN CATCH
		
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT @o_errorMessage = ERROR_MESSAGE(), @o_errorCode = ERROR_NUMBER()
	END CATCH
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tblMoveLegalHoldItems') IS NOT NULL
			DROP TABLE #tblMoveLegalHoldItems
	select @o_alreadyExistsInContainer 'AlreadyExistsInContainer',
			@o_newlyInserted 'NewlyInserted',
			@o_duplicateEntries 'DuplicateEntries',
			@o_alreadyExistsWithNewId 'AlreadyExistsWithNewId',
			@o_newlyAddedInDMResultSet 'NewlyAddedInDMResultSet',
			@o_errorCode 'ErrorCode',
			@o_errorMessage 'ErrorMessage'
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_MoveFailedLegalHoldItems')
	delete from GxQscripts where name = 'sp_dm2_MoveFailedLegalHoldItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MoveFailedLegalHoldItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_MoveFailedLegalHoldItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_MoveFailedLegalHoldItems',  '00010004000000000000', 'sp_dm2_MoveFailedLegalHoldItems', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PopulateDMSetting.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PopulateDMSetting.sp,v $ $Id: sp_dm2_PopulateDMSetting.sp,v 1.1 2008/11/06 19:47:28 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PopulateDMSetting <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PopulateDMSetting')
	drop procedure sp_dm2_PopulateDMSetting
IF EXISTS (select * from GxQscripts where name='sp_dm2_PopulateDMSetting')
	delete from GxQscripts where name = 'sp_dm2_PopulateDMSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PopulateDMSetting')
	delete from GXDBVersions where aliasname = 'sp_dm2_PopulateDMSetting'
GO
print '... Creating Procedure: sp_dm2_PopulateDMSetting'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PopulateDMSetting
  @i_xml_Data XML
AS
DECLARE @Success BIT
SET @Success = 0
SET NOCOUNT ON
	SELECT
	T.c.value('@SettingName', 'varchar(200)') as SettingName,
	T.c.value('@SettingValue', 'nvarchar(200)') as SettingValue INTO #DMTempSetting
	FROM @i_xml_Data.nodes('/DMSettings/DMSetting') T(c)
	BEGIN TRANSACTION
	UPDATE DMSetting
	SET DMSetting.SettingValue = T.SettingValue
	FROM #DMTempSetting T
	JOIN DMSetting D ON D.SettingName = T.SettingName AND D.SettingValue <> T.SettingValue
	IF @@ERROR = 0
	BEGIN
		INSERT INTO DMSetting (SettingName, SettingValue, CreateTime)
		SELECT SettingName, SettingValue, GetDate() as CreateTime
		FROM #DMTempSetting
		WHERE SettingName NOT IN (SELECT SettingName FROM DMSetting)
		IF @@ERROR = 0
			SET @Success = 1
	END
	IF @Success = 1
	BEGIN
		COMMIT TRANSACTION
		SELECT 0 AS ErrorCode, '' AS ErrorMessage
	END
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
		SELECT 1 AS ErrorCode, 'Populate operation failed' AS ErrorMessage
	END
	IF OBJECT_ID('tempdb..#DMTempSetting') IS NOT NULL
	BEGIN
		DROP TABLE #DMTempSetting
	END
SET NOCOUNT OFF
-- below is the way on how you can execute this stored proc.
--DECLARE @xmlValue XML
--
--SELECT @xmlValue = '<DMSettings>
--<DMSetting SettingName="DEFAULT_Results_retention_in_days_per_user" SettingValue="120" />
--<DMSetting SettingName="POLL_INTVL" SettingValue="60" /></DMSettings>'
--
--EXECUTE sp_dm2_PopulateDMSetting @xmlValue
--
--
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PopulateDMSetting')
	delete from GxQscripts where name = 'sp_dm2_PopulateDMSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PopulateDMSetting')
	delete from GXDBVersions where aliasname = 'sp_dm2_PopulateDMSetting'
GO

insert into GXDBVersions values(2, 'sp_dm2_PopulateDMSetting',  '00010001000000000000', 'sp_dm2_PopulateDMSetting', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneLegalHoldItemsToBackup.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneLegalHoldItemsToBackup()
--  | Description:  Prune LegalHold Items backed up
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneLegalHoldItemsToBackup.sp,v $ $Id: sp_dm2_PruneLegalHoldItemsToBackup.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneLegalHoldItemsToBackup <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneLegalHoldItemsToBackup')
	drop procedure sp_dm2_PruneLegalHoldItemsToBackup
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneLegalHoldItemsToBackup')
	delete from GxQscripts where name = 'sp_dm2_PruneLegalHoldItemsToBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneLegalHoldItemsToBackup')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneLegalHoldItemsToBackup'
GO
print '... Creating Procedure: sp_dm2_PruneLegalHoldItemsToBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneLegalHoldItemsToBackup
  @i_CompPolicyID varchar(36)
AS
	SET NOCOUNT ON
  DELETE 	DMLegalHoldItemsToBackup
  WHERE 	CompPolicyID = @i_CompPolicyID
	-- Unset legally held flag in DMContainerItem if no row exists in DMLegalHoldItemsToBackup
	-- with BackupStatus = SUCCESS
	UPDATE 	DMContainerItem
	SET 		Attribute = CI.Attribute & ~8
	FROM 		DMContainerItem CI LEFT OUTER JOIN DMLegalHoldItemsToBackup LH	 WITH (READUNCOMMITTED)
	ON 			CI.ContainerId = LH.ContainerId
	AND			CI.ResultSetId = LH.ResultSetId
	AND			LH.BackupStatus = 1
	WHERE 	LH.ContainerId IS null
	AND			LH.ResultSetId IS null
	AND 		CI.Attribute & 8 = 8
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneLegalHoldItemsToBackup')
	delete from GxQscripts where name = 'sp_dm2_PruneLegalHoldItemsToBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneLegalHoldItemsToBackup')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneLegalHoldItemsToBackup'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneLegalHoldItemsToBackup',  '00010001000000000000', 'sp_dm2_PruneLegalHoldItemsToBackup', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneQuery.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneQuery()
--  | Description:  Prune Query
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneQuery.sp,v $ $Id: sp_dm2_PruneQuery.sp,v 1.3 2014/03/19 16:46:33 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneQuery <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneQuery')
	drop procedure sp_dm2_PruneQuery
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneQuery')
	delete from GxQscripts where name = 'sp_dm2_PruneQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneQuery'
GO
print '... Creating Procedure: sp_dm2_PruneQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneQuery
  @i_UserGUID varchar(36) = '',
  @i_QueryID varchar(36) = ''
AS
	IF LEN(@i_QueryID) > 0
	BEGIN
		DELETE FROM DMQuery
		WHERE QueryID = @i_QueryID
	END
	ELSE
	BEGIN
		DECLARE @currentDate DATETIME = GETUTCDATE();
		DECLARE @pruneInterval INT = 90  -- default 90 days
		SELECT @pruneInterval = ISNULL(SettingValue, 90) FROM DMSetting
		WHERE SettingName = 'PRUNE_INTERVAL_FOR_QUERY_Days'
		IF(LEN(ISNULL(@i_UserGUID,'')) > 0)
		BEGIN
			DELETE FROM DMQuery WHERE
				UserGUID = @i_UserGUID
				AND Attribute & 1 <> 1  -- If Bit 1 is set on attribute, then that means it is user saved,
				AND datediff(d, CreateTime, @currentDate) > @pruneInterval	-- and dont prune records less tahn default 90 days.
		END
		ELSE
		BEGIN
			--case when we need to prune all records which matches the criteria.
			--
			DECLARE @batchCount INT = 10000  -- default
			SELECT @batchCount = ISNULL(SettingValue, 90) FROM DMSetting
			WHERE SettingName = 'DELETE_BATCH_COUNT_DMQUERY'
			--Create temp tbl for holding queryIds
			IF OBJECT_ID('tempdb.dbo.#tmpQueryIdsPrune') IS NOT NULL
				DROP TABLE #tmpQueryIdsPrune
			CREATE TABLE #tmpQueryIdsPrune( 	QueryId VARCHAR(36)		) ;
			INSERT INTO #tmpQueryIdsPrune
			SELECT TOP (@batchCount) Q.QueryID from DMQuery Q WITH (READUNCOMMITTED)
			WHERE Attribute & 1 <> 1 AND datediff(d, Q.CreateTime, @currentDate) > @pruneInterval
			WHILE EXISTS(SELECT TOP 1* FROM #tmpQueryIdsPrune)
			BEGIN
				DELETE DMQuery
				WHERE QueryID IN (SELECT T.QueryId FROM #tmpQueryIdsPrune AS T)
				--clean temp table
				DELETE #tmpQueryIdsPrune
				INSERT INTO #tmpQueryIdsPrune
				SELECT TOP (@batchCount) Q.QueryID from DMQuery Q WITH (READUNCOMMITTED)
				WHERE Attribute & 1 <> 1 AND datediff(d, Q.CreateTime, @currentDate) > @pruneInterval
			END
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneQuery')
	delete from GxQscripts where name = 'sp_dm2_PruneQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneQuery'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneQuery',  '00010003000000000000', 'sp_dm2_PruneQuery', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneResultSetItemsBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneResultSetItemsBulk()
--  | Description:  Prune ResultSet in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneResultSetItemsBulk.sp,v $ $Id: sp_dm2_PruneResultSetItemsBulk.sp,v 1.6 2012/11/15 16:04:32 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneResultSetItemsBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneResultSetItemsBulk')
	drop procedure sp_dm2_PruneResultSetItemsBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneResultSetItemsBulk')
	delete from GxQscripts where name = 'sp_dm2_PruneResultSetItemsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneResultSetItemsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneResultSetItemsBulk'
GO
print '... Creating Procedure: sp_dm2_PruneResultSetItemsBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneResultSetItemsBulk
  @i_ResultSetIds nvarchar(max) = '',
  @i_containerID nvarchar(max) = '',
  @i_Attribute int = 0,
  @i_InputAsItemID BIT = 0
AS
-- i_ResultSetIds --> This can be comma seperated list of ID from DMContainerItem if i_InputAsItemID = 1
-- i_ResultSetIds --> This will be comma seperated list of ResultSetID from DMResultSet if i_InputAsItemID = 0
  --Create temp tbl for holding ResultSetId
	CREATE TABLE #tmpResultSetId
	(
		ResultSetId VARCHAR(36)
	) ;
	--When we delete particular resultSetId list
	IF LEN(@i_ResultSetIds) > 0 AND LEN(@i_containerID) > 0
	BEGIN
		IF @i_InputAsItemID = 0
		BEGIN
			INSERT INTO #tmpResultSetId
			SELECT  LTRIM(RTRIM(ID))
			FROM dbo.splitStringToTable(@i_ResultSetIds)
			WHERE ID IS NOT NULL
			AND LEN(ID) > 0
		END
		ELSE
		BEGIN
			INSERT INTO #tmpResultSetId
			SELECT ResultSetID FROM DMContainerItem C WITH(NOLOCK), dbo.splitStringToTable(@i_ResultSetIds) A
			WHERE C.ID = CONVERT(INT, LTRIM(RTRIM(A.ID)))
		END
		DELETE DMContainerItemTags
		FROM DMContainerItemTags CIT, DMContainerItemStates CIS, #tmpResultSetId T
		WHERE CIS.ContainerID = @i_containerID
		AND 	CIS.ResultSetID = T.ResultSetId
		AND		CIS.AssignID = CIT.AssignID
		DELETE DMContainerItemStateHistory
		FROM DMContainerItemStateHistory CIH, DMContainerItemStates CIS, #tmpResultSetId T
		WHERE CIS.ContainerID = @i_containerID
		AND 	CIS.ResultSetID = T.ResultSetId
		AND		CIS.AssignID = CIH.AssignID
		DELETE DMContainerItemStates
		FROM DMContainerItemStates CIS, #tmpResultSetId T
		WHERE CIS.ContainerID = @i_containerID
		AND 	CIS.ResultSetID = T.ResultSetId
		DELETE DMUserComment
		FROM DMUserComment UC, #tmpResultSetId T
		WHERE UC.ContainerID = @i_containerID
		AND 	UC.ResultSetID = T.ResultSetId
		DELETE DMContainerItem
		FROM DMContainerItem CI, #tmpResultSetId T
		WHERE CI.ContainerID = @i_containerID
		AND 	CI.ResultSetID = T.ResultSetId
	END
  ELSE IF LEN(@i_containerID) > 0 AND LEN(@i_ResultSetIds) = 0
  --when we delete a  particular ReviewSet
	BEGIN
		INSERT INTO #tmpResultSetId
		SELECT ResultSetID
		FROM DMContainerItem
		WHERE ContainerID = @i_containerID
		AND ResultSetID IS NOT NULL
		AND LEN(ResultSetID) > 0
		DELETE DMContainerItemTags
		WHERE AssignID IN (
												SELECT AssignID
												FROM DMContainerItemStates
												WHERE ContainerID = @i_containerID
											)
		DELETE DMContainerItemStateHistory
		WHERE AssignID IN (
												SELECT AssignID
												FROM DMContainerItemStates
												WHERE ContainerID = @i_containerID
											)
		DELETE DMContainerItemStates
		WHERE ContainerID = @i_containerID
		DELETE DMUserComment
		WHERE ContainerID = @i_containerID
		DELETE DMContainerExport
		WHERE ContainerID = @i_containerID
		DELETE DMContainerItem
		WHERE ContainerID = @i_containerID
	END
	IF ( (SELECT COUNT(*) FROM #tmpResultSetId) > 0 )
	BEGIN
		--Find reference count
		DELETE #tmpResultSetId
		FROM #tmpResultSetId T, DMContainerItem CI WITH (NOLOCK)
		WHERE T.ResultSetId = CI.ResultSetId
		--Find reference count in DMDownloadResultSet
		DELETE #tmpResultSetId
		FROM #tmpResultSetId T, DMDownloadResultSet CI WITH (NOLOCK)
		WHERE T.ResultSetId = CI.ResultSetId
		--Mark items deleted and later submit for space cleanup
		UPDATE DMResultSet
		SET Attribute = Attribute | 4, --Mark DELETED
			PruneRequestTime = GETUTCDATE()
		FROM DMResultSet RS, #tmpResultSetId T
		WHERE RS.ResultSetID = T.ResultSetId
	END
	DROP TABLE #tmpResultSetId
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneResultSetItemsBulk')
	delete from GxQscripts where name = 'sp_dm2_PruneResultSetItemsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneResultSetItemsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneResultSetItemsBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneResultSetItemsBulk',  '00010006000000000000', 'sp_dm2_PruneResultSetItemsBulk', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneSetting.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneSetting()
--  | Description:  Prune Settings
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneSetting.sp,v $ $Id: sp_dm2_PruneSetting.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneSetting <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneSetting')
	drop procedure sp_dm2_PruneSetting
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneSetting')
	delete from GxQscripts where name = 'sp_dm2_PruneSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneSetting')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneSetting'
GO
print '... Creating Procedure: sp_dm2_PruneSetting'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneSetting
  @i_SettingName varchar(50)
AS
  delete from DMSetting
  where SettingName = @i_SettingName
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneSetting')
	delete from GxQscripts where name = 'sp_dm2_PruneSetting'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneSetting')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneSetting'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneSetting',  '00010001000000000000', 'sp_dm2_PruneSetting', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneUserComment.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneUserComment()
--  | Description:  Prune User Comments
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneUserComment.sp,v $ $Id: sp_dm2_PruneUserComment.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneUserComment <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneUserComment')
	drop procedure sp_dm2_PruneUserComment
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneUserComment')
	delete from GxQscripts where name = 'sp_dm2_PruneUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneUserComment'
GO
print '... Creating Procedure: sp_dm2_PruneUserComment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneUserComment
  @i_CommentID varchar(36) = '',
  @i_UserGUID varchar(36) = '',
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = '',
  @i_ParentCommentID varchar(36) = ''
AS
  delete from DMUserComment
  where (len(@i_CommentID) = 0 or CommentID = @i_CommentID)
  and (len(@i_UserGUID) = 0 or UserGUID = @i_UserGUID)
  and (len(@i_ContainerID) = 0 or ContainerID = @i_ContainerID)
  and (len(@i_ResultSetID) = 0 or ResultSetID = @i_ResultSetID)
  and (len(@i_ParentCommentID) = 0 or ParentCommentID = @i_ParentCommentID)
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneUserComment')
	delete from GxQscripts where name = 'sp_dm2_PruneUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneUserComment'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneUserComment',  '00010001000000000000', 'sp_dm2_PruneUserComment', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneUserPref.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneUserPref()
--  | Description:  Prune User Preferences
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneUserPref.sp,v $ $Id: sp_dm2_PruneUserPref.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneUserPref <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneUserPref')
	drop procedure sp_dm2_PruneUserPref
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneUserPref')
	delete from GxQscripts where name = 'sp_dm2_PruneUserPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneUserPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneUserPref'
GO
print '... Creating Procedure: sp_dm2_PruneUserPref'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneUserPref
  @i_UserPrefName varchar(50) = '',
  @i_UserGUID varchar(36)
AS
  delete DMUserPref
	where (len(@i_UserPrefName) = 0 or (UserPrefName = @i_UserPrefName))
	and UserGUID = @i_UserGUID
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneUserPref')
	delete from GxQscripts where name = 'sp_dm2_PruneUserPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneUserPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneUserPref'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneUserPref',  '00010001000000000000', 'sp_dm2_PruneUserPref', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_RestoreLHRSItemsWithAFIdAndOffset.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_RestoreLHRSItemsWithAFIdAndOffset()
--  | Description:  Restore LegalHold Items
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_RestoreLHRSItemsWithAFIdAndOffset.sp,v $ $Id: sp_dm2_RestoreLHRSItemsWithAFIdAndOffset.sp,v 1.25 2015/04/16 18:53:14 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_RestoreLHRSItemsWithAFIdAndOffset <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
	drop procedure sp_dm2_RestoreLHRSItemsWithAFIdAndOffset
IF EXISTS (select * from GxQscripts where name='sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
	delete from GxQscripts where name = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
	delete from GXDBVersions where aliasname = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO
print '... Creating Procedure: sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_RestoreLHRSItemsWithAFIdAndOffset
  @i_ContainerID VARCHAR(36),
  @i_restoreJobId INTEGER,
  @i_restoreCCNumber INTEGER,
  @i_backupCCNumber INTEGER,
  @i_archFileId BIGINT,
  @i_archFileOffset BIGINT,
  @i_destPath NVARCHAR(max),
  @i_metaDataXML NVARCHAR(max),
  @i_DownloadID CHAR(36) = '',
  @i_UserGUID VARCHAR(36) = ''
AS
	SET NOCOUNT ON
	BEGIN TRANSACTION LHRESTOREITEM
	DECLARE @inputXML XML
	SET			@inputXML = CONVERT(XML, @i_metaDataXML, 1)
	DECLARE @errorCode	INTEGER
	SET			@errorCode	= 0
	DECLARE @restoreStatus	INTEGER
	SET	  	@restoreStatus	= 0
        DECLARE @auditInputXML NVARCHAR(MAX)
	SET @auditInputXML = ''
	IF @i_ContainerID IS NULL OR LEN(@i_ContainerID) = 0
	BEGIN
		SET	@errorCode	=	-1
		GOTO CX_EXIT
	END
	DECLARE @count INTEGER
	SELECT @count = COUNT(*) FROM @inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
	--Translate old LegalHold MetaDataXML to 9.0 format
	IF @count = 0
	BEGIN
		SET @inputxml = CAST(dbo.ConvertLegalHoldMetaDataXMLTo900XMLManaged(@i_metaDataXML) AS XML)
	END
	IF @i_UserGUID IS NULL OR LEN(@i_UserGUID) = 0
	BEGIN
		SET	@errorCode	=	-1
		GOTO CX_EXIT
	END
	IF (@i_destPath IS null)
		SET @i_destPath = ''
	IF (LEN(@i_destPath) = 0)
		SET	  @restoreStatus	= 5 -- Failed
	ELSE
		SET	  @restoreStatus	= 4 -- For Success
	DECLARE @tblResultSet TABLE
	(
		filePath							NVARCHAR(max),
		fileName							NVARCHAR(1024),
		folderPath						NVARCHAR(max),
		appType								INTEGER,
		appId									INTEGER,
		commcellNo						INTEGER,
		clientId							INTEGER,
		pushError							NVARCHAR(max),
		sizeKB								FLOAT,
		MIMEType							NVARCHAR(256),
		modifiedTime					BIGINT,
		jobId									INTEGER,
		contentIndexingJobId	INTEGER,
		backupTime						BIGINT,
		aFileId								INTEGER,
		aFileOffset						BIGINT,
		aFileLength						BIGINT,
		dynTeaser							NVARCHAR(max),
		rank									FLOAT,
		ownerField						NVARCHAR(MAX),
		lnks							NVARCHAR(MAX)
	)
	DECLARE @tblUserComments TABLE
	(
		UserGUID					VARCHAR(36),
		CreationDateTime	VARCHAR(25),
		ModifiedDateTime	VARCHAR(25),
		Comments					NVARCHAR(max)
	)
	DECLARE @tblAssignedUser TABLE
	(
		AssignId					INTEGER,
		StateID						VARCHAR(36),
		UserNotes					NVARCHAR(max),
		UserGUID					VARCHAR(36),
		ReviewSetTags			XML,
		CITags						XML
	)
	DECLARE @tblUserTags TABLE
	(
		AssignId					INTEGER,
		UserGUID					VARCHAR(36),
		TagId							VARCHAR(36)
	)
	DECLARE @ResultSetID VARCHAR(36)
	SET			@ResultSetID = ''
	DECLARE @ResultSetXMLStr NVARCHAR(MAX)
	SET			@ResultSetXMLStr = ''
	DECLARE @ResultSetXML XML
	DECLARE @NewDocumentID 	VARCHAR(256)
	SET 		@NewDocumentID 	= ''
	DECLARE	@OrigResultSetID			NVARCHAR(36)
	DECLARE @ownerField NVARCHAR(MAX) = N''
	INSERT	INTO @tblResultSet
	SELECT	T.item.value('@filePath', 'NVARCHAR(max)'),
			T.item.value('@fileName', 'NVARCHAR(1024)'),
			T.item.value('@folderPath', 'NVARCHAR(max)'),
			T.item.value('@appType', 'INTEGER'),
			T.item.value('@appId', 'INTEGER'),
			T.item.value('@commcellNo', 'INTEGER'),
			T.item.value('@clientId', 'INTEGER'),
			T.item.value('@pushError', 'NVARCHAR(max)'),
			T.item.value('@sizeKB', 'FLOAT'),
			T.item.value('@MIMEType', 'NVARCHAR(256)'),
			T.item.value('@modifiedTime', 'BIGINT'),
			T.item.value('@jobId', 'INTEGER'),
			T.item.value('@contentIndexingJobId', 'INTEGER'),
			T.item.value('@backupTime', 'BIGINT'),
			T.item.value('@aFileId', 'INTEGER'),
			T.item.value('@aFileOffset', 'BIGINT'),
			T.item.value('@aFileLength', 'BIGINT'),
			T.item.value('@dynTeaser', 'NVARCHAR(max)'),
			T.item.value('@rank', 'FLOAT'),
			T.item.value('./appSpecific[1]/eMail[1]/@from','NVARCHAR(max)'),
			T.item.value('./appSpecific[1]/eMail[1]/@links','NVARCHAR(max)')
	FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @tblResultSet
	SET filePath = CASE WHEN filePath IS null THEN
							N''
						ELSE filePath END
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT	@OrigResultSetID = T.item.value('@ResultItemID', 'NVARCHAR(36)')
	FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF NOT EXISTS (	SELECT ResultSetID FROM DMResultSet   WITH (READUNCOMMITTED)
					 WHERE CommCellNumber = @i_backupCCNumber
					 AND aFileID = @i_archFileId
					 AND aFileOffset = @i_archFileOffset
					)
	BEGIN
		--PopulateOwnerField only if required
		IF EXISTS (SELECT * FROM DMUIAppTypeMap
					WHERE AppTypeId = (SELECT TOP 1 appType FROM @tblResultSet)
						AND IsEmailAppType = 1)
		BEGIN
			DECLARE @getOwnerAsMailBoxOwner NVARCHAR(10) = 'False',
					@lnks NVARCHAR(MAX) = '',
					@fromField NVARCHAR(MAX) = '',
					@filePath NVARCHAR(MAX) = ''
			SELECT @getOwnerAsMailBoxOwner = SettingValue
			FROM DMSetting WHERE SettingName = 'POPULATE_OWNERFIELD_AS_MAILBOXOWNER'
			SELECT @lnks = T.lnks,@fromField = T.ownerField, @filePath = T.filePath
			FROM @tblResultSet AS T
			--Now populate the ownerField by calling the CLR function
			--Syntax:
			--[dbo].[GetOwnerFieldManaged](@fromField [nvarchar](max), @lnks [nvarchar](max), @filePath [nvarchar](max), @getMailOwnerStr [nvarchar](10))
			SELECT @ownerField = dbo.GetOwnerFieldManaged(@fromField,@lnks,@filePath,@getOwnerAsMailBoxOwner)
		END
		--Convert to lower case
		SELECT @ownerField = LOWER(ISNULL(@ownerField,N''))
		SET @ResultSetID = NEWID()
		INSERT INTO DMResultSet
			(ResultSetID,CommCellNumber,aFileID,aFileOffset,aFileLength,
			AppType,FileSizeKB,ModifiedTime,JobId,OriginalFullPath,
			DestinationPath,CreateTime,RestoreUserGUID,RestoreCommCellNumber,RestoreJobID,
			RestoreStatus,RestoreTime,Attribute,
			documentID,ClientID,ERMStatus,
			Title)
		SELECT
			@ResultSetID, @i_backupCCNumber, @i_archFileId, @i_archFileOffset, aFileLength,
			appType, sizeKB, dbo.GetDateTime(modifiedTime), jobId, filePath,
			@i_destPath, getDate(), @i_UserGUID, 0,@i_restoreJobId,
			@restoreStatus, getDate(), 0,
			'', clientId,0,
			fileName
		FROM	@tblResultSet
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO DMResultSetInfo
		SELECT	@ResultSetID, ''
		FROM	@tblResultSet
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Translate to DM2ContentIndexing_GResultItem Root tag
		SELECT @ResultSetXML = CAST(dbo.fn_dm2_GetLatestResultSetXML(@ResultSetID, CAST(@inputxml.query('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') AS NVARCHAR(max))) AS XML)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		IF @ResultSetXML.exist('//DM2ContentIndexing_GResultItem[@ResultItemID]') = 0
			SET @ResultSetXML.modify('insert attribute ResultItemID {sql:variable("@ResultSetID")} into (/DM2ContentIndexing_GResultItem)[1]')
		ELSE
			SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@ResultItemID)[1] with sql:variable("@ResultSetID")')
		SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@commcellNo)[1] with sql:variable("@i_backupCCNumber")')
		SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@aFileId)[1] with sql:variable("@i_archFileId")')
		SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@aFileOffset)[1] with sql:variable("@i_archFileOffset")')
		IF @ResultSetXML.exist('//DM2ContentIndexing_GResultItem[@documentId]') = 0
			SET @ResultSetXML.modify('insert attribute documentId {sql:variable("@NewDocumentID")} into (/DM2ContentIndexing_GResultItem)[1]')
		ELSE
			SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@documentId)[1] with sql:variable("@NewDocumentID")')
		--check whether the ownerField is populated in the GResultItem
		--if not insert new attribute
		IF(@ResultSetXML.exist('//DM2ContentIndexing_GResultItem/appSpecific/eMail/@owner')  = 0)
			SET @ResultSetXML.modify('insert attribute owner {sql:variable("@ownerField")}
			into (/DM2ContentIndexing_GResultItem/appSpecific/eMail)[1]')
		ELSE
			SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/appSpecific/eMail/@owner)[1]
			with sql:variable("@ownerField") ')
		SELECT @ResultSetXMLStr = CAST(@ResultSetXML AS NVARCHAR(MAX))
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE DMResultSet
		SET Attribute = 16
		WHERE ResultSetID = @ResultSetID
		UPDATE DMResultSetInfo
		SET ResultSet = @ResultSetXMLStr
		WHERE ResultSetID = @ResultSetID
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	ELSE
	BEGIN
	  SET @ResultSetID = (	SELECT	TOP 1 ResultSetID
							FROM	DMResultSet	  WITH (READUNCOMMITTED)
							WHERE	CommCellNumber = @i_backupCCNumber
							AND		aFileID = @i_archFileId
							AND		aFileOffset = @i_archFileOffset
							)
	  --Update the existing row with the new restorePath and restore Status
		UPDATE DMResultSet
		SET DestinationPath = @i_destPath,
			RestoreUserGUID = @i_UserGUID,
			RestoreJobId = @i_restoreJobId,
			RestoreStatus = @restoreStatus,
			RestoreTime = getDate(),
			Attribute = 16
			-- Unset all other attributes as well
		WHERE ResultSetID = @ResultSetID
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	IF EXISTS (SELECT * FROM DMUIAppTypeMap
					WHERE AppTypeId = (SELECT TOP 1 appType FROM @tblResultSet)
						AND IsEmailAppType = 1)
	BEGIN
		DECLARE @ResultSetTable AS ResultSetType
		INSERT INTO @ResultSetTable
		SELECT ResultSetID, CAST(ResultSet AS XML)
		FROM DMResultSetInfo
		WHERE ResultSetID = @ResultSetID
		IF EXISTS (SELECT TOP 1 * FROM @ResultSetTable)
		BEGIN
			CREATE TABLE #tmpDMEmailFields
			(
				resultSetID VARCHAR(36),
				subjectField NVARCHAR(MAX),
				toField NVARCHAR(MAX),
				fromField NVARCHAR(MAX),
				bccField NVARCHAR(MAX),
				ccField NVARCHAR(MAX)
			);
			INSERT INTO #tmpDMEmailFields
			SELECT T.ResultSetId,T.subjectField,T.toField,T.fromField,T.bccField,T.ccField
			FROM dbo.fn_dm2_GetValuesForEmailFields(@ResultSetTable) AS T
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			UPDATE DMEmailResult
			SET EmailSubject = TR.subjectField, EmailFROM = TR.fromField, EmailTO = TR.toField, EmailCC = TR.ccField, EmailBCC = TR.bccField,
			SavedTime = GETUTCDATE()
			FROM #tmpDMEmailFields TR
			WHERE DMEmailResult.ResultSetID = TR.ResultSetID
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			INSERT INTO DMEmailResult (ResultSetID,EmailSubject,EmailFROM,EmailTO,EmailCC,EmailBCC,SavedTime)
			SELECT TR.ResultSetID, TR.subjectField, TR.fromField, TR.toField, TR.ccField, TR.bccField, GETUTCDATE() FROM #tmpDMEmailFields TR
			WHERE NOT EXISTS (SELECT ResultSetID FROM DMEmailResult E WHERE E.ResultSetID = TR.ResultSetID)
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
	END
	IF NOT (@i_DownloadID IS null OR LTRIM(RTRIM(@i_DownloadID)) = '')
	BEGIN
		INSERT INTO DMDownloadResultSet (DownloadID, ResultSetID, AppType, Status, CreateTime,FileName)
		SELECT @i_DownloadID as DownloadID, @ResultSetID as ResultSetID,
		AppType, (CASE WHEN ISNULL(@i_destPath,'') = '' THEN 0 ELSE 100 END) as Status, GetDate() as CreateTime,@i_destPath as FileName
		FROM DMResultSet
		WHERE ResultSetID = @ResultSetID
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	IF NOT EXISTS (	SELECT *
					FROM	DMContainerItem		WITH (READUNCOMMITTED)
					WHERE	ContainerID = @i_ContainerID
					AND		ResultSetID = @ResultSetID)
	BEGIN
		INSERT INTO DMContainerItem
		values(@i_ContainerID, '', @ResultSetID, getUTCDate(), 0, @i_UserGUID)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO @tblUserComments
		SELECT	ISNULL(T.item.value('userInfo[1]/@userGuid', 'VARCHAR(36)'), ''),
						ISNULL(T.item.value('userComment[1]/@creationDateTime', 'VARCHAR(25)'), ''),
						ISNULL(T.item.value('userComment[1]/@modifiedDateTime', 'VARCHAR(25)'), ''),
						ISNULL(T.item.value('userComment[1]/@comments', 'NVARCHAR(MAX)'), '')
		FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/userCommentInformation/userCommentInfo') T(item)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		IF EXISTS (SELECT UserGUID FROM @tblUserComments WHERE Comments IS NOT NULL)
		INSERT	INTO DMUserComment
		SELECT NEWID(), UserGUID, '', @i_ContainerID, @ResultSetID, NULL, Comments, CONVERT(DATETIME, CreationDateTime), 0, CONVERT(DATETIME, ModifiedDateTime)
		FROM @tblUserComments
		WHERE Comments IS NOT NULL
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-------------------Audit add items to reviewSet.-------------------
		--
		--construct the reuseRequestId,So that for a particular job only once the EventId will be created...
		--
		DECLARE  @reuseRequestId VARCHAR(100)
		SELECT @reuseRequestId = 'ReuseId_JobId_'+ CONVERT(VARCHAR(16),@i_restoreJobId) + '_LegalHoldRestore'
		--ParamList can contain only mandatory fields
		--ItemSource and the Destination containerGuid
		SET @auditInputXML =
			(
				SELECT @i_ContainerID '@containerGuid', 1 '@type', @i_UserGUID '@userGuid',@reuseRequestId '@reuseRequestId',
					(SELECT 'LegalHold_Restore' '@paramValue',11 '@paramName' FOR XML PATH('paramList'), TYPE),
					(SELECT @i_ContainerID '@paramValue',3 '@paramName' FOR XML PATH('paramList'), TYPE),
					@ResultSetID 'resultSetIds/@val'
				FOR XML PATH('DM2ContentIndexing_EventOperation')
			)
	END
	ELSE
	BEGIN
		UPDATE DMContainerItem
		SET Attribute = Attribute & ~4
		WHERE ContainerID = @i_ContainerID
		AND ResultSetID = @ResultSetID
		AND	Attribute & 4 = 4
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE DMUserComment
		SET Attribute = Attribute & ~4
		WHERE ContainerID = @i_ContainerID
		AND ResultSetID = @ResultSetID
		AND	Attribute & 4 = 4
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	--Get Assigned User Info
	INSERT INTO @tblAssignedUser
	SELECT	ISNULL(T.item.value('@assignID', 'INTEGER'), ''),
			ISNULL(T.item.value('docState[1]/@stateID', 'VARCHAR(36)'), ''),
			T.item.value('docState[1]/@stateDescription', 'NVARCHAR(max)'),
			ISNULL(T.item.value('userInformation[1]/@userGuid', 'VARCHAR(36)'), ''),
			T.item.query('./ReviewSetTags'),
			T.item.query('./CITags')
	FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/assignedUserInfo/assignedUser') T(item)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO @tblUserTags
	SELECT	0, UserGUID, T.c.value('@id', 'VARCHAR(36)')
	FROM	@tblAssignedUser CROSS APPLY CITags.nodes('/CITags') T(c)
	UNION
	SELECT	0, UserGUID, T.c.value('@id', 'VARCHAR(36)')
	FROM	@tblAssignedUser CROSS APPLY ReviewSetTags.nodes('/ReviewSetTags') T(c)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the deleted flag if the entry already exists
	UPDATE DMContainerItemStates
	SET Attribute = Attribute & ~4
	FROM @tblAssignedUser AS TT, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
	WHERE CIS.ContainerId = @i_ContainerId
	AND 	CIS.ResultSetId = @ResultSetID
	AND		CIS.AssignedUserGUID = TT.UserGUID
	AND		CIS.Attribute & 4 = 4
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Insert entries if not exists
	INSERT INTO DMContainerItemStates
	SELECT @i_ContainerID, @ResultSetID, TT.UserGUID, TT.StateID, getUTCDate(), @i_UserGUID, TT.UserNotes, 0
	FROM @tblAssignedUser AS TT
	WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemStates AS CIS WITH (READUNCOMMITTED)
							WHERE CIS.ContainerId = @i_ContainerId
							AND 	CIS.ResultSetId = @ResultSetID
							AND		CIS.AssignedUserGUID = TT.UserGUID)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @tblUserTags
	SET assignID = CIS.assignID
	FROM @tblUserTags TT, DMContainerItemStates CIS WITH (NOLOCK)
	WHERE CIS.ContainerId = @i_ContainerId
	AND 	CIS.ResultSetId = @ResultSetID
	AND		CIS.AssignedUserGUID = TT.UserGUID
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the deleted flag if the entry already exists
	UPDATE DMContainerItemTags
	SET 	Attribute = Attribute & ~4
	FROM 	DMContainerItemTags CIT, @tblUserTags AS TT
	WHERE CIT.assignID = TT.assignID
	AND		CIT.TagID = TT.TagID
	AND		CIT.Attribute & 4 = 4
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the deleted flag if the entry already exists
	UPDATE DMUserItemTags
	SET 	Attribute = Attribute & ~4
	FROM 	DMUserItemTags UIT, @tblUserTags AS TT
	WHERE UIT.UserGUID = TT.UserGUID
	AND		UIT.ResultSetID = @ResultSetID
	AND		UIT.TagID = TT.TagID
	AND		UIT.Attribute & 4 = 4
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Create entries if not exists
	INSERT INTO DMContainerItemTags
	SELECT TT.AssignID, TT.TagID, getUTCDate(), @i_UserGUID, '', 0
	FROM	@tblUserTags AS TT
	WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemTags AS CIT WITH (NOLOCK)
							WHERE CIT.AssignID = TT.AssignID
							AND		CIT.TagID = TT.TagID)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Remove all DB Tags if User Tags already exists
	DELETE DMContainerItemTags
	FROM 	DMContainerItemTags AS CIT, DMContainerItemStates AS CIS WITH (NOLOCK), DMUserItemTags UIT WITH (NOLOCK), @tblUserTags AS TT
	WHERE CIS.ResultSetId = UIT.ResultSetId
	AND		CIS.AssignedUserGUID = UIT.UserGUID
	AND		CIS.AssignID = CIT.AssignID
	AND		CIT.TagID = UIT.TagID
	AND		UIT.ResultSetId = @ResultSetID
	AND		UIT.UserGUID = TT.UserGUID
	AND		UIT.TagID = TT.TagID
	AND		UIT.Attribute & 4 = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF @errorCode = 0
		COMMIT TRANSACTION LHRESTOREITEM
	ELSE
		ROLLBACK TRANSACTION LHRESTOREITEM
	--if the errorCode = 0 and @auditInputXML is not empty
	--call audit stored procedure...
	--this is called after the transaction because, Nested transaction was involved.
	--which ended up is Mismatch transaction count
	IF(@errorCode = 0 AND @auditInputXML IS NOT NULL AND LEN(@auditInputXML) > 0)
	BEGIN
		EXECUTE sp_dm2_AuditOperation @auditInputXML,1
	END
	IF OBJECT_ID('#tmpDMEmailFields') IS NOT null
	DROP TABLE #tmpDMEmailFields
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
	delete from GxQscripts where name = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
	delete from GXDBVersions where aliasname = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO

insert into GXDBVersions values(2, 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset',  '00010025000000000000', 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset', '00010025000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateCompliancePolicyItemsStatus.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateCompliancePolicyItemsStatus.sp,v $ $Id: sp_dm2_UpdateCompliancePolicyItemsStatus.sp,v 1.4 2012/04/02 07:23:36 pbuilder Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateCompliancePolicyItemsStatus <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateCompliancePolicyItemsStatus')
	drop procedure sp_dm2_UpdateCompliancePolicyItemsStatus
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateCompliancePolicyItemsStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateCompliancePolicyItemsStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateCompliancePolicyItemsStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateCompliancePolicyItemsStatus'
GO
print '... Creating Procedure: sp_dm2_UpdateCompliancePolicyItemsStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateCompliancePolicyItemsStatus
  @i_RetainOption INT,
  @i_UserGUID CHAR(36),
  @i_ContainerID CHAR(36),
  @i_OperationTypeFlags INT,
  @i_JobID INT
AS
	DECLARE	@ErrorCode				INT,
				@ErrorDesc				VARCHAR(2000),
				@CheckLegalHoldStatus	BIT,
				@CheckERMStatus			BIT,
				@AttributeToOR			INT
	-- Indicator constants for retain option
	DECLARE @RetainFailedItems INT
	SET @RetainFailedItems = 1
	DECLARE @RetainReviewSet INT
	SET @RetainReviewSet = 2
	-- Binary weight constants for operation type
	DECLARE @LHFlagConstant INT
	SET @LHFlagConstant = 2
	DECLARE @ERMFlagConstant INT
	SET @ERMFlagConstant = 4
        DECLARE @PreviousJobId INT
	BEGIN TRANSACTION
	SET NOCOUNT ON
	-- while checking backup status, we are interested only in immediate previous jobid..
	SELECT TOP 1 @PreviousJobId = JobID
	FROM DMLegalHoldItemsToBackup WHERE ContainerId = @i_ContainerID AND JobId < @i_JobID
	ORDER BY JOBID DESC
	-- Init..
	SELECT @ErrorCode = 0, @ErrorDesc = '', @CheckLegalHoldStatus = 0, @CheckERMStatus = 0
	-- Figure out what operation types are passed in..
	IF @i_OperationTypeFlags & @LHFlagConstant = @LHFlagConstant
	BEGIN
		SET @CheckLegalHoldStatus = 1   -- SET LH Flag.
	END
	IF @i_OperationTypeFlags & @ERMFlagConstant = @ERMFlagConstant
	BEGIN
		SET @CheckERMStatus = 1	-- SET ERM Flag.
	END
	IF NOT (@i_RetainOption = 1 OR @i_RetainOption = 2)
	BEGIN
		SELECT @ErrorCode = 1, @ErrorDesc = 'Invalid Option Specified as input.'
		GoTo ExitLine
	END
	SET NOCOUNT OFF
	CREATE TABLE #DMContainerItem ( ContainerID char(36), ResultSetID char(36), QueryID char(36) )
	IF @i_RetainOption = @RetainFailedItems
	BEGIN
		INSERT INTO	#DMContainerItem
		SELECT CI.ContainerID, CI.ResultSetID, CI.QueryID FROM DMContainerItem CI
		INNER JOIN DMResultSet RS ON CI.ResultSetId = RS.ResultSetId
		LEFT JOIN DMLegalHoldItemsToBackup LH ON CI.ResultSetId = LH.ResultSetId AND CI.ContainerId = LH.ContainerId AND LH.JobID = @PreviousJobId
		WHERE CI.ContainerID = @i_ContainerID
		AND (CI.Attribute & 64 = 64 OR CI.Attribute & 32 = 32)
		AND RS.RestoreStatus = 4
		AND ( (@CheckLegalHoldStatus = 1 AND LH.BackupStatus = 1) OR @CheckLegalHoldStatus = 0 )
		AND ( (@CheckERMStatus = 1 AND RS.ERMStatus = 8) OR @CheckERMStatus = 0 )
		UPDATE DMContainerItem
		SET Attribute = (Attribute | 4)
		FROM #DMContainerItem DM
		WHERE DMContainerItem.ContainerID = DM.ContainerID
		AND DMContainerItem.ResultSetID = DM.ResultSetID
		AND DMContainerItem.QueryID = DM.QueryID
	END
	ELSE IF @i_RetainOption = @RetainReviewSet
	BEGIN
		INSERT INTO	#DMContainerItem
		SELECT CI.ContainerID, CI.ResultSetID, CI.QueryID FROM DMContainerItem CI
		INNER JOIN DMResultSet RS ON CI.ResultSetId = RS.ResultSetId
		LEFT JOIN DMLegalHoldItemsToBackup LH ON CI.ResultSetId = LH.ResultSetId AND CI.ContainerId = LH.ContainerId AND LH.JobID = @PreviousJobId
		WHERE CI.ContainerID = @i_ContainerID
		AND CI.Attribute & 32 = 32
		AND RS.RestoreStatus = 4
		AND ( (@CheckLegalHoldStatus = 1 AND LH.BackupStatus = 1) OR @CheckLegalHoldStatus = 0 )
		AND ( (@CheckERMStatus = 1 AND RS.ERMStatus = 8) OR @CheckERMStatus = 0 )
		UPDATE DMContainerItem
		SET Attribute = (((Attribute | 64)) ^ 32)
		FROM #DMContainerItem DM
		WHERE DMContainerItem.ContainerID = DM.ContainerID
		AND DMContainerItem.ResultSetID = DM.ResultSetID
		AND DMContainerItem.QueryID = DM.QueryID
	END
	SET @ErrorCode = @@ERROR
ExitLine:
	IF @ErrorCode > 0 OR @ErrorDesc <> ''
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
	SELECT @ErrorCode AS ErrorCode, @ErrorDesc as ErrorString
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateCompliancePolicyItemsStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateCompliancePolicyItemsStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateCompliancePolicyItemsStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateCompliancePolicyItemsStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateCompliancePolicyItemsStatus',  '00010004000000000000', 'sp_dm2_UpdateCompliancePolicyItemsStatus', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDMJob.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateDMJob()
--  | Description:  Update DMJob
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDMJob.sp,v $ $Id: sp_dm2_UpdateDMJob.sp,v 1.3 2015/07/14 19:34:12 psaoji Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateDMJob <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateDMJob')
	drop procedure sp_dm2_UpdateDMJob
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateDMJob')
	delete from GxQscripts where name = 'sp_dm2_UpdateDMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDMJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDMJob'
GO
print '... Creating Procedure: sp_dm2_UpdateDMJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateDMJob
  @i_JobID varchar(36),
  @i_JobState int = 0,
  @i_Progress int = 0,
  @i_Results nvarchar(max) = '',
  @i_setPendingReason nvarchar(max) = '',
  @i_clearPendingReason nvarchar(max) = '',
  @i_setAttribute int = 0,
  @i_clearAttribute int = 0
AS
  UPDATE DMJob
  SET
	JobState = (case @i_JobState when 0 then JobState else @i_JobState end),
	Progress = (case @i_Progress when 0 then Progress else @i_Progress end),
	Results = (case len(@i_Results) when 0 then Results else @i_Results end),
	PendingReason = (case len(@i_setPendingReason) when 0 then @i_clearPendingReason else @i_setPendingReason end),
	Attribute = (Attribute | @i_setAttribute) & ~@i_clearAttribute,
	EndTime = case WHEN @i_Progress >= 100 THEN GetUtcDate() ELSE NULL END
  WHERE JobID = @i_JobID
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateDMJob')
	delete from GxQscripts where name = 'sp_dm2_UpdateDMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDMJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDMJob'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateDMJob',  '00010003000000000000', 'sp_dm2_UpdateDMJob', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDownload.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateDownload()
--  | Description:  Update Download
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDownload.sp,v $ $Id: sp_dm2_UpdateDownload.sp,v 1.7 2013/10/18 16:56:57 rarora Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateDownload <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateDownload')
	drop procedure sp_dm2_UpdateDownload
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateDownload')
	delete from GxQscripts where name = 'sp_dm2_UpdateDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDownload')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDownload'
GO
print '... Creating Procedure: sp_dm2_UpdateDownload'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateDownload
  @i_DownloadID varchar(36),
  @i_DestinationPath nvarchar(max) = '', 
  @i_FileSizeKB bigint = 0,
  @i_RestoreJobID int = 0, 
  @i_Status int = 0,
  @i_Attribute int = 0,
  @i_Description nvarchar(max) = '',
  @i_CabItemCount int = -1,
  @i_singleShare int = 0
AS
DECLARE @RestoredCount INT
  if @i_Description != ''
  begin
	-- need to update description, figure out if the same description has been used by the same user
	declare @DownLoadSetID varchar(36)
	select @DownLoadSetID = DownLoadSetID from DMDownload WITH (READUNCOMMITTED) where DownLoadID = @i_DownloadID
    if exists (select top 1 * from DMDownload WITH (READUNCOMMITTED)
				where DownloadID != @i_DownloadID
				and Description = @i_Description
				and DownLoadSetID = @DownLoadSetID)
		return 1
  end
  --Even if one item is not succcesful, then we have to report it as partial..
  IF EXISTS(SELECT DownloadID FROM DMDownload WHERE @i_Status = 100 AND FileType = 2 AND DownloadID = @i_DownloadID)
  BEGIN
	BEGIN
		IF EXISTS(SELECT TOP 1 ResultSetID FROM DMDownloadResultSet WHERE [Status] <> 100 AND DownloadID = @i_DownloadID)
		BEGIN
			SET @i_Status = 101
		END
		--Some times everything gets restored, but everything may be not zipped, in that case also we have to mark it as partial
		IF @i_Status = 100 AND @i_CabItemCount > -1
		BEGIN
			SELECT @RestoredCount = COUNT(ResultSetID) FROM DMDownloadResultSet WHERE [Status] = 100 AND DownloadID = @i_DownloadID
			IF @RestoredCount <> @i_CabItemCount
				SET @i_Status = 101
		END
	END
  END
  IF @i_singleShare = 1
  BEGIN
		select @i_DestinationPath = DestinationPath From DMResultSet A, DMDownloadResultSet B Where A.ResultSetID = B.ResultSetID and B.DownloadID = @i_DownloadID
  END
  update DMDownload
  set
	DestinationPath = (case len(@i_DestinationPath) when 0 then DestinationPath else @i_DestinationPath end),
	FileSizeKB = (case @i_FileSizeKB when 0 then FileSizeKB else @i_FileSizeKB end),
	RestoreJobID = (case @i_RestoreJobID when 0 then RestoreJobID else @i_RestoreJobID end),
	Status = (case @i_Status when 0 then Status else @i_Status end),
	Attribute = (Attribute | @i_Attribute),
	DownloadTime = (case (@i_Attribute & 1) when 1 then getdate() else DownloadTime end),
	Description = (case len(@i_Description) when 0 then Description else @i_Description end)
  where DownloadID = @i_DownloadID
  return 0
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateDownload')
	delete from GxQscripts where name = 'sp_dm2_UpdateDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDownload')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDownload'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateDownload',  '00010007000000000000', 'sp_dm2_UpdateDownload', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDownloadBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateDownloadBulk()
--  | Description:  Update Download in Bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDownloadBulk.sp,v $ $Id: sp_dm2_UpdateDownloadBulk.sp,v 1.2 2012/08/06 15:32:09 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateDownloadBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateDownloadBulk')
	drop procedure sp_dm2_UpdateDownloadBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateDownloadBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateDownloadBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDownloadBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDownloadBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateDownloadBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateDownloadBulk
  @i_DownloadID varchar(36),
  @i_ResultSet xml	
AS
-- 	must be valid xml format, for example:
--	<ResultSet CommCellNumber="-1" aFileID="123" aFileOffset="123" AppType="1" Status="1" />
--	<ResultSet CommCellNumber="-1" aFileID="123" aFileOffset="123" AppType="1" Status="1" />
--	<ResultSet CommCellNumber="-1" aFileID="123" aFileOffset="123" AppType="1" Status="1" />
	DECLARE @tblDownloadResultSet TABLE (CommCellNumber int, aFileID bigint, aFileOffset bigint, AppType int, Status int, ResultSetID varchar(36))
	INSERT INTO @tblDownloadResultSet
	SELECT 	T.c.value('@CommCellNumber','int'),
		   		T.c.value('@aFileID', 'bigint'),
		   		T.c.value('@aFileOffset', 'bigint'),
		   		T.c.value('@AppType', 'int'),
		   		T.c.value('@Status', 'int'),
					''
	FROM   @i_ResultSet.nodes('/ResultSet') T(c)
	update 	DMDownloadResultSet
	set Status = a.Status
	from @tblDownloadResultSet a, DMResultSet b WITH (NOLOCK), DMDownloadResultSet c
	where a.CommCellNumber = b.CommCellNumber
	and a.aFileID = b.aFileID
	and a.aFileOffset = b.aFileOffset
	and a.AppType = b.AppType
	and b.ResultSetID = c.ResultSetID
	and c.DownloadID = @i_DownloadID
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateDownloadBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateDownloadBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDownloadBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDownloadBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateDownloadBulk',  '00010002000000000000', 'sp_dm2_UpdateDownloadBulk', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_DM2_UpdateDMEmailItemReport.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDMEmailItemReport.sp,v $ $Id: sp_dm2_UpdateDMEmailItemReport.sp,v 1.4 2008/09/17 02:32:13 aprasad Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateDMEmailItemReport <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateDMEmailItemReport')
	drop procedure sp_dm2_UpdateDMEmailItemReport
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateDMEmailItemReport')
	delete from GxQscripts where name = 'sp_dm2_UpdateDMEmailItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDMEmailItemReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDMEmailItemReport'
GO
print '... Creating Procedure: sp_dm2_UpdateDMEmailItemReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateDMEmailItemReport
  @i_jobId Integer,
  @i_xml_Files XML
AS
BEGIN
  DECLARE @t_Files TABLE (CCId int, AFId bigint, FileOffset bigint, errCode INT, statusCode INT, reason nVARCHAR(max)) 
	SET NOCOUNT OFF
	INSERT INTO @t_Files( CCId, AFId, FileOffset, errCode, statusCode, reason  )
	SELECT	T.c.value('@CCId', 'int'),
			T.c.value('@AFId', 'bigint'),
			T.c.value('@aFileOffset', 'bigint'),
			T.c.value('@errCode', 'int'),
			T.c.value('@statusCode', 'int'),
			T.c.value('@reason', 'nvarchar(max)')
	FROM @i_xml_Files.nodes('/restlist/file') T(c)
	SET NOCOUNT ON
	UPDATE DMItemReport
	SET ErrCode = tf.errCode, reason = tf.reason, status = tf.statusCode
	FROM @t_Files tf
	WHERE DMItemReport.CommCellNumber = tf.CCId AND DMItemReport.AFileId = tf.AFId AND DMItemReport.aFileOffset = tf.FileOffset AND DMItemReport.JobId = @i_jobId
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_DM2_UpdateDMEmailItemReport')
	delete from GxQscripts where name = 'sp_DM2_UpdateDMEmailItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_DM2_UpdateDMEmailItemReport')
	delete from GXDBVersions where aliasname = 'sp_DM2_UpdateDMEmailItemReport'
GO

insert into GXDBVersions values(2, 'sp_DM2_UpdateDMEmailItemReport',  '00010004000000000000', 'sp_DM2_UpdateDMEmailItemReport', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_DM2_UpdateDMFileItemReport.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDMFileItemReport.sp,v $ $Id: sp_dm2_UpdateDMFileItemReport.sp,v 1.5 2012/04/02 07:21:28 pbuilder Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateDMFileItemReport <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateDMFileItemReport')
	drop procedure sp_dm2_UpdateDMFileItemReport
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateDMFileItemReport')
	delete from GxQscripts where name = 'sp_dm2_UpdateDMFileItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDMFileItemReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDMFileItemReport'
GO
print '... Creating Procedure: sp_dm2_UpdateDMFileItemReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateDMFileItemReport
  @i_jobId Integer,
  @i_xml_Files XML
AS
BEGIN
  DECLARE @@t_Files TABLE (CCId int, AFId bigint, errCode INT, statusCode INT, OrigPath nvarchar(max), reason nVARCHAR(max), FileOffset bigint)
	SET NOCOUNT OFF
	INSERT INTO @@t_Files( CCId, AFId, errCode, statusCode, OrigPath, reason )
	SELECT	T.c.value('@CCId', 'int'),
			T.c.value('@AFId', 'bigint'),
			T.c.value('@errCode', 'int'),
			T.c.value('@statusCode', 'int'),
			T.c.value('@OrigPath', 'nvarchar(max)'),
			T.c.value('@reason', 'nvarchar(max)')
	FROM @i_xml_Files.nodes('/restlist/file') T(c)
	UPDATE @@t_Files
	SET FileOffset = R.aFileOffset
	FROM DMResultSet R
	WHERE AFId = R.aFileId AND CCId = R.CommCellNumber AND OrigPath = R.OriginalFullPath AND R.RestoreJobID = @i_jobId
	SET NOCOUNT ON
	UPDATE DMItemReport
	SET ErrCode = tf.errCode, reason = tf.reason, status = tf.statusCode
	FROM @@t_Files tf
	WHERE DMItemReport.CommCellNumber = tf.CCId AND DMItemReport.AFileId = tf.AFId AND DMItemReport.aFileOffset = tf.FileOffset AND DMItemReport.JobId = @i_jobId
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_DM2_UpdateDMFileItemReport')
	delete from GxQscripts where name = 'sp_DM2_UpdateDMFileItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_DM2_UpdateDMFileItemReport')
	delete from GXDBVersions where aliasname = 'sp_DM2_UpdateDMFileItemReport'
GO

insert into GXDBVersions values(2, 'sp_DM2_UpdateDMFileItemReport',  '00010005000000000000', 'sp_DM2_UpdateDMFileItemReport', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateItemReport.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateItemReport.sp,v $ $Id: sp_dm2_UpdateItemReport.sp,v 1.1 2008/08/27 10:23:38 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateItemReport <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateItemReport')
	drop procedure sp_dm2_UpdateItemReport
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateItemReport')
	delete from GxQscripts where name = 'sp_dm2_UpdateItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateItemReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateItemReport'
GO
print '... Creating Procedure: sp_dm2_UpdateItemReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateItemReport
  @i_jobId int,
  @i_status int,
  @i_errCode int,
  @i_reason nvarchar(max)
AS
UPDATE DMItemReport
SET  [status] = @i_status, errCode = @i_errCode, reason = @i_reason
WHERE JobId = @i_jobId
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateItemReport')
	delete from GxQscripts where name = 'sp_dm2_UpdateItemReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateItemReport')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateItemReport'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateItemReport',  '00010001000000000000', 'sp_dm2_UpdateItemReport', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateLegalHoldBackupStatus.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateLegalHoldBackupStatus()
--  | Description:  Update the LegalHold Backup Job Status
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateLegalHoldBackupStatus.sp,v $ $Id: sp_dm2_UpdateLegalHoldBackupStatus.sp,v 1.2 2008/04/09 16:28:08 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateLegalHoldBackupStatus <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateLegalHoldBackupStatus')
	drop procedure sp_dm2_UpdateLegalHoldBackupStatus
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateLegalHoldBackupStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateLegalHoldBackupStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateLegalHoldBackupStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateLegalHoldBackupStatus'
GO
print '... Creating Procedure: sp_dm2_UpdateLegalHoldBackupStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateLegalHoldBackupStatus
  @i_JobId integer			= 0,
  @i_CommCellId integer			= 0,
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = '',
  @i_BackupStatus integer			= 0
AS
	UPDATE 	DMLegalHoldItemsToBackup
	SET 		BackupStatus = @i_BackupStatus
	WHERE 	JobId = @i_JobId
	AND 		CommCellId = @i_CommCellId
	AND			ContainerID = @i_ContainerID
	AND			ResultSetID = @i_ResultSetID
	IF (@i_BackupStatus = 1) -- If Success
	BEGIN
		UPDATE 	DMContainerItem
		SET 		Attribute = Attribute | 8
		WHERE 	ContainerID = @i_ContainerID
		AND			ResultSetID = @i_ResultSetID
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateLegalHoldBackupStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateLegalHoldBackupStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateLegalHoldBackupStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateLegalHoldBackupStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateLegalHoldBackupStatus',  '00010002000000000000', 'sp_dm2_UpdateLegalHoldBackupStatus', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateQuery.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateQuery()
--  | Description:  Update the Query
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateQuery.sp,v $ $Id: sp_dm2_UpdateQuery.sp,v 1.3 2010/03/03 21:53:48 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateQuery <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateQuery')
	drop procedure sp_dm2_UpdateQuery
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateQuery')
	delete from GxQscripts where name = 'sp_dm2_UpdateQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateQuery'
GO
print '... Creating Procedure: sp_dm2_UpdateQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateQuery
  @i_QueryID varchar(36),
  @i_QueryName nvarchar(1024) = '',
  @i_Comments nvarchar(max) = '',
  @i_QuerySummary nvarchar(max) = '',  
  @i_Attribute int = 0,
  @i_SetOrClear int = 0  
AS
  update DMQuery
  set
	QueryName = (case @i_QueryName when '' then QueryName else @i_QueryName end),
	Comments =  (case @i_Comments when '' then Comments else @i_Comments end),
	QuerySummary =  (case @i_QuerySummary when '' then QuerySummary else @i_QuerySummary end),
	CommentsTime = (case @i_Comments when '' then CommentsTime else GetUTCDate() end),
	Attribute = (case @i_SetOrClear when 0 then (Attribute & ~@i_Attribute) else @i_Attribute end)
    where QueryID = @i_QueryID
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateQuery')
	delete from GxQscripts where name = 'sp_dm2_UpdateQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateQuery')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateQuery'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateQuery',  '00010003000000000000', 'sp_dm2_UpdateQuery', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreFile.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreFile()
--  | Description:  Update the Restore Files
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreFile.sp,v $ $Id: sp_dm2_UpdateRestoreFile.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreFile <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreFile')
	drop procedure sp_dm2_UpdateRestoreFile
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreFile')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreFile')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreFile'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreFile'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreFile
  @i_RestoreJobID int,
  @i_aFileID bigint,
  @i_OriginalFullPath nvarchar(max),
  @i_DestinationPath nvarchar(max)
AS
  update DMResultSet
  set	RestoreJobID = @i_RestoreJobID,
		DestinationPath = @i_DestinationPath,
	  RestoreStatus = 4
  where
	aFileID = @i_aFileID and OriginalFullPath = @i_OriginalFullPath
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreFile')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreFile')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreFile'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreFile',  '00010001000000000000', 'sp_dm2_UpdateRestoreFile', '00010001000000000000')
GO


SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreFilesBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreFilesBulk')
	drop procedure sp_dm2_UpdateRestoreFilesBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreFilesBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreFilesBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreFilesBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreFilesBulk'
GO

print '... Creating Procedure: sp_dm2_UpdateRestoreFilesBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreFilesBulk
  @i_jobId Integer,
  @DMrestoreTbl DM2RestoreFileUpdateV2 READONLY,
  @i_isUnixUpdate INTEGER = 0
AS
BEGIN
		DECLARE @error int
		DECLARE @DownloadID char(36)
		DECLARE @SettingVal VARCHAR(MAX) = ''
		DECLARE @CcnCheckEnabled BIT = 0
		DECLARE @TurboGuicCheckEnabled BIT = 0
		DECLARE @MtimeCheckEnabled BIT = 0

		SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_CCN_CHECK_IN_RESTORE'

		IF ISNULL(@SettingVal, '') = 'True'
			SET @CcnCheckEnabled = 1
		
		SET @SettingVal = ''
		SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_TURBO_GUID_CHECK_IN_RESTORE'

		IF ISNULL(@SettingVal, '') = 'True'
			SET @TurboGuicCheckEnabled = 1
		
		SET @SettingVal = ''
		SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_MODIFIED_TIME_CHECK_IN_RESTORE'

		IF ISNULL(@SettingVal, '') = 'True'
			SET @MtimeCheckEnabled = 1

	BEGIN TRANSACTION
		DECLARE @lt_AFFiles TABLE (ID int IDENTITY(1,1) ,CCId int, AFId bigint, OrigPath nvarchar(max), DestPath nvarchar(max), status int, mtime int, turboGUID varchar(128))
		INSERT INTO @lt_AFFiles (CCId,AFId,OrigPath,DestPath,status, mtime, turboGUID)
		SELECT T.CCId,T.AFId,T.OPath,T.DPath,T.status, T.mtime, T.turboGUID FROM @DMrestoreTbl as T
		
		DECLARE @lt_AFFilesToResultSetId TABLE (t_id int , t_resultSetID char(36))
		
		--matching result set id WITH turbo guid
		IF @TurboGuicCheckEnabled = 1
		BEGIN
			INSERT INTO  @lt_AFFilesToResultSetId
			SELECT T.ID,  R.ResultSetID
			FROM @lt_AFFiles T, DMResultSet R WITH (NOLOCK)
			WHERE  ISNULL((turboGUID),'') != '' AND turboGUID = IndexGUID
		END

		--matching result set id WITH mtime		
		IF( @i_isUnixUpdate = 1)
		BEGIN			
			INSERT INTO  @lt_AFFilesToResultSetId
			SELECT T.ID,  R.ResultSetID
			FROM @lt_AFFiles T, DMResultSet R WITH (NOLOCK)
			WHERE aFileID = AFId AND OriginalFullPath COLLATE Latin1_General_CS_AS = OrigPath 
			AND (@MtimeCheckEnabled = 0 OR (@MtimeCheckEnabled = 1 AND mtime = dbo.GetUnixTime(ModifiedTime)))
					AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
			AND T.ID NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId )
		END
		ELSE
		BEGIN
			INSERT INTO  @lt_AFFilesToResultSetId
			SELECT T.ID,  R.ResultSetID
			FROM @lt_AFFiles T, DMResultSet R WITH (NOLOCK)
			WHERE aFileID = AFId AND OriginalFullPath = OrigPath 
			AND (@MtimeCheckEnabled = 0 OR (@MtimeCheckEnabled = 1 AND mtime = dbo.GetUnixTime(ModifiedTime)))
					AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
			AND T.ID NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId )
		END
		
		--Case when we couldn find any matching resultSet,  then we check this flag for Lotus nous
		IF EXISTS(SELECT * FROM @lt_AFFiles as tt WHERE id NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId ))		
		BEGIN
			/*
				Issue:
						if an email has multiple attachments during backup and few of them are filtered during CI, 
					then the attachment number present in the path for each attachment within its documentID, mismatches and does not follow their sequence of number. 
			
				Fix:
						During restore update, we try to convert the db path to match with original email which doesnt have attachment number, 
					there by path would match the input index path.				
			*/
			DECLARE @enableLNPartialCheck BIT = 
					CASE WHEN ISNULL((SELECT SettingValue FROM DMSetting 
								WHERE SettingName = 'ENABLE_LN_PATH_PARTIAL_MATCH'),'false') = 'true'	--default disabled
						THEN 1 ELSE 0 END
						
			IF(@enableLNPartialCheck = 1)
			BEGIN
				UPDATE tt 
				SET tt.OrigPath = (CASE WHEN PATINDEX('%S:_:%',tt.OrigPath) = 0  THEN tt.OrigPath 
									ELSE SUBSTRING(tt.OrigPath,1,(PATINDEX('%S:_:%',tt.OrigPath)))END)
				FROM @lt_AFFiles as tt
				WHERE tt.id NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId )
				
				--Since all mails and attachement have same path, delete duplicate
				DELETE FROM @lt_AFFiles
				WHERE ID NOT IN(
					SELECT MAX(ID)
					FROM @lt_AFFiles AS tt
					GROUP BY tt.AFId,tt.OrigPath
				)
				
				--For LN, compare origPath by stripping attachment.	 	
				INSERT INTO @lt_AFFilesToResultSetId
				SELECT DISTINCT tt.ID,  R.ResultSetID
				FROM @lt_AFFiles tt, DMResultSet R WITH (NOLOCK)
				WHERE  tt.id NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId )
					AND tt.AFId = R.aFileID  AND 									
						tt.OrigPath =				
						(CASE WHEN PATINDEX('%S:_:%',R.OriginalFullPath) = 0  THEN R.OriginalFullPath 
							ELSE SUBSTRING(R.OriginalFullPath,1,(PATINDEX('%S:_:%',R.OriginalFullPath)))END)
					AND R.AppType IN (52, 90)			
				
								
			END
		END
			UPDATE DMResultSet
			SET DestinationPath = tt.DestPath, RestoreStatus = 4
			FROM @lt_AFFiles tt, @lt_AFFilesToResultSetId tr
			WHERE ResultSetID = tr.t_resultSetID AND tt.id = tr.t_id
			SET @error = @@ERROR
			IF @error = 0
			BEGIN
				SELECT TOP 1 @DownloadID = DownloadID FROM DMDownload WITH(NOLOCK) WHERE RestoreJobID = @i_jobId
				IF ISNULL(@DownloadID, '') <> ''
				BEGIN
					UPDATE DMDownloadResultSet
					SET [FileName] = tt.DestPath,
					[Status] = (CASE WHEN tt.Status = 4 AND ISNULL(tt.DestPath, '') <> '' THEN 100 ELSE 500 END)
					FROM @lt_AFFiles tt, @lt_AFFilesToResultSetId tr
					WHERE DownloadID = @DownloadID AND tt.id = tr.t_id AND ResultSetID = tr.t_resultSetID
					SET @error = @@ERROR
				END
			END
		IF @error = 0
			COMMIT TRANSACTION
		ELSE
			ROLLBACK TRANSACTION
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreFilesBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreFilesBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreFilesBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreFilesBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreFilesBulk',  '00010004000000000000', 'sp_dm2_UpdateRestoreFilesBulk', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreJobID.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreJobID()
--  | Description:  Update the Restore JobId
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreJobID.sp,v $ $Id: sp_dm2_UpdateRestoreJobID.sp,v 1.2 2008/04/09 16:19:15 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreJobID <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreJobID')
	drop procedure sp_dm2_UpdateRestoreJobID
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreJobID')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreJobID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreJobID')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreJobID'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreJobID'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreJobID
  @i_UserGUID varchar(36) = '',
  @i_ContainerName nvarchar(max) = '',
  @i_CommCellNumber int = 0,
  @i_aFileID bigint = 0,
  @i_aFileOffset bigint = 0,
  @i_RestoreJobID int = 0
AS
	  update DMResultSet
	  set RestoreUserGUID = @i_UserGUID,
--	  RestoreStatus = CASE WHEN RestoreStatus > 0 THEN RestoreStatus ELSE 1 END, RestoreJobID = @i_RestoreJobID
	  RestoreStatus = 1, RestoreJobID = @i_RestoreJobID, RestoreTime = GetDate(), DestinationPath = ''
	  where
			  CommCellNumber = @i_CommCellNumber
			  and aFileID = @i_aFileID
			  and aFileOffset = @i_aFileOffset
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreJobID')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreJobID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreJobID')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreJobID'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreJobID',  '00010002000000000000', 'sp_dm2_UpdateRestoreJobID', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreJobIDBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreJobIDBulk()
--  | Description:  Update the Restore JobId in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreJobIDBulk.sp,v $ $Id: sp_dm2_UpdateRestoreJobIDBulk.sp,v 1.2 2015/04/16 18:51:55 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreJobIDBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreJobIDBulk')
	drop procedure sp_dm2_UpdateRestoreJobIDBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreJobIDBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreJobIDBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreJobIDBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreJobIDBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreJobIDBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreJobIDBulk
  @i_UserGUID varchar(36) = '',
  @i_RestoreJobID int = 0,
  @i_DataFilePath varchar(1024) = ''
AS
		declare @l_delimiter	varchar(256)
		declare @SQL	varchar(2048)
		set @l_delimiter = ISNULL((select SettingValue from DMSetting WITH (READUNCOMMITTED) where settingName = 'DMBulkInsert_Delim'), '')
		IF(len(@l_delimiter ) = 0)
			SET @l_delimiter = 'CV0X12'
		create table #tmpDMResultSet
		(
			[CommCellNumber] [int] ,
			[aFileID] [bigint]  ,
			[aFileOffset] [bigint] ,
			turboguid varchar(128)
		)
		SET @SQL = 'BULK INSERT #tmpDMResultSet FROM '''+@i_DataFilePath+''' WITH (FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
		exec (@SQL)
		DECLARE @tblResultSet TABLE (ResultSetId varchar(36),CommCellNumber int, aFileID bigint, aFileOffset bigint, turboGUID varchar(128))
		INSERT INTO @tblResultSet
		SELECT distinct ' ', CommCellNumber, aFileID, aFileOffset, turboguid FROM #tmpDMResultSet
		UPDATE @tblResultSet SET ResultSetId = RS.ResultSetId
		FROM @tblResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.turboGUID,'') <> '' AND t.turboGUID = RS.IndexGUID
		--now update only items where resultsetid is not populated
		UPDATE t SET ResultSetId = RS.ResultSetId
		FROM @tblResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.ResultSetId,'') = '' AND
			t.CommCellNumber = RS.CommCellNumber
			and t.aFileID = RS.aFileID
			and t.aFileOffset = RS.aFileOffset
	  update RS
	  set RestoreUserGUID = @i_UserGUID,
	  RestoreStatus = 1, RestoreJobID = @i_RestoreJobID, RestoreTime = GetDate(), DestinationPath = ''
	  FROM @tblResultSet t inner join DMResultSet RS WITH (NOLOCK) ON
	  t.ResultSetId = RS.ResultSetId
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreJobIDBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreJobIDBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreJobIDBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreJobIDBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreJobIDBulk',  '00010002000000000000', 'sp_dm2_UpdateRestoreJobIDBulk', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreMail.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreMail()
--  | Description:  Update the Restore Mails
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreMail.sp,v $ $Id: sp_dm2_UpdateRestoreMail.sp,v 1.1 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreMail <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreMail')
	drop procedure sp_dm2_UpdateRestoreMail
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreMail')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreMail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreMail')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreMail'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreMail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreMail
  @i_RestoreJobID int,
  @i_aFileID bigint,
  @i_aFileoffset bigint,
  @i_DestinationPath nvarchar(max)
AS
	  update DMResultSet
	  set DestinationPath = @i_DestinationPath,
		  RestoreStatus = 4
	  where aFileID = @i_aFileID
	  and aFileoffset = @i_aFileoffset
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreMail')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreMail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreMail')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreMail'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreMail',  '00010001000000000000', 'sp_dm2_UpdateRestoreMail', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreMailsBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreMailsBulk()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreMailsBulk.sp,v $ $Id: sp_dm2_UpdateRestoreMailsBulk.sp,v 1.8 2015/04/16 18:53:07 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreMailsBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreMailsBulk')
	drop procedure sp_dm2_UpdateRestoreMailsBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreMailsBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreMailsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreMailsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreMailsBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreMailsBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreMailsBulk
  @i_jobId Integer,
  @DMrestoreTbl DM2RestoreStatusUpdate READONLY
AS
BEGIN
DECLARE @error int
DECLARE @DownloadID char(36)
DECLARE @SettingVal VARCHAR(MAX) = ''
DECLARE @CcnCheckEnabled BIT = 0
SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_CCN_CHECK_IN_RESTORE'
	IF ISNULL(@SettingVal, '') = 'True'
		SET @CcnCheckEnabled = 1
-- expects a list like
-- <restlist>
--    <file CCId="2" AFId="2" AFOff="27" DPath="/blabla" />
--    <file CCId="2" AFId="4" AFOff="37" />
--    <file CCId="2" AFId="6" AFOff="909" />
-- </restlist>
	DECLARE @lt_AFOffsets TABLE (CCId int, AFId bigint, AFOff bigInt, DestPath nvarchar(max), status int, ResultItemID char(36))
--	INSERT INTO @lt_AFOffsets
--	SELECT T.c.value('@CCId','int'),
--		   T.c.value('@AFId', 'bigint'),
--		   T.c.value('@AFOff', 'bigint'),
--		   T.c.value('@DPath', 'nvarchar(max)'),
--		   ISNULL(T.c.value('@status', 'int'), 0), -- ERMStatus for success
--		   NULL AS ResultItemID
--	FROM   @i_xml_AFOffsets.nodes('/restlist/file') T(c)
	INSERT INTO @lt_AFOffsets (CCId,AFId,AFOff,DestPath,status,ResultItemID)
	SELECT T.CCId,T.AFId,T.AFOffset,T.DPath,ISNULL(T.status, 0), null FROM @DMrestoreTbl as T
	UPDATE tt
	SET ResultItemID = ResultSetID
	FROM @lt_AFOffsets tt,
	DMResultSet R WITH(NOLOCK)
	WHERE R.aFileID = tt.AFId AND R.aFileoffset = tt.AFOff AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
	BEGIN TRANSACTION
		UPDATE DMResultSet
		SET DestinationPath = tt.DestPath, RestoreStatus = 4
		FROM @lt_AFOffsets tt
		WHERE ResultSetID = tt.ResultItemID
		SET @error = @@ERROR
		IF @error = 0
		BEGIN
			SELECT TOP 1 @DownloadID = DownloadID FROM DMDownload WITH(NOLOCK) WHERE RestoreJobID = @i_jobId
			IF ISNULL(@DownloadID, '') <> ''
			BEGIN
				UPDATE DMDownloadResultSet
				SET [FileName] = tt.DestPath,
				[Status] = (CASE WHEN tt.Status = 4 AND ISNULL(tt.DestPath, '') <> '' THEN 100 ELSE 500 END)
				FROM @lt_AFOffsets tt
				WHERE DownloadID = @DownloadID AND ResultSetID = tt.ResultItemID
				SET @error = @@ERROR
			END
		END
	IF @error = 0
		COMMIT TRANSACTION
	ELSE
		ROLLBACK TRANSACTION
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreMailsBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreMailsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreMailsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreMailsBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreMailsBulk',  '00010008000000000000', 'sp_dm2_UpdateRestoreMailsBulk', '00010008000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreStatus.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreStatus()
--  | Description:  Update the Restore Status
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreStatus.sp,v $ $Id: sp_dm2_UpdateRestoreStatus.sp,v 1.9 2015/06/23 16:35:15 aausarkar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreStatus <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreStatus')
	drop procedure sp_dm2_UpdateRestoreStatus
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreStatus'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreStatus
  @i_RestoreJobID int = 0,
  @i_OldRestoreStatus int = -1,
  @i_RestoreStatus int = 0,
  @i_IsJM int = 0,
  @i_ResultSetID varchar(max) = '',
  @i_ID BIGINT = 0
AS
  -- this sp is NOT called by clRestore, only called by GUI
  -- get dm2 restore job status
  declare @dm2RestoreStatus int
  set @dm2RestoreStatus = @i_RestoreStatus
  if @i_IsJM > 0
  begin
	select @dm2RestoreStatus = (	case @i_RestoreStatus -- this is JM status
									when 1 then 1 -- RUNNING
									when 2 then 1 -- PENDING
									when 3 then 1 -- WAITING
									when 4 then 4 -- COMPLETED
									when 5 then 6 -- STOPPED
									when 6 then 7 -- KILLPENDING
									when 7 then 6 -- STOPPENDING
									when 8 then 6 -- INTERRUPTPENDING
									when 9 then 4 -- COMPLETEDSUCCESS
									when 10 then 5 -- COMPLETEDFAIL
									when 11 then 7 -- STATEKILLED
									when 12 then 4 -- COMPLETEDPARTIAL
									when 13 then 7 -- SYSTEMKILLPENDING
									when 14 then 1 -- DORMANT
									when 15 then 1 -- QUEUED
									when 16 then 1 -- DORMANTSCHEDWAIT
									when 17 then 1 -- RUNNING_UNVERIFIABLE
									when 18 then 1 -- DANGLINGJOBCLEANUP
									when 99 then 1 -- jobs unpicked by schedular
									else  0
								end)
-- DM2 RestoreStatus
--ANY = -1,
--Not_submitted = 0,
--Submitted_for_viewing = 1,
--Ready_to_be_viewed = 2,
--Submitted_for_Restore = 3,
--Restore_completed = 4,
--Failed = 5,
--Suspended = 6,
--Killed = 7
-- JM job status:
--	RUNNING = 1,
--	PENDING,
--	WAITING,
--	COMPLETED,
--	STOPPED,
--	KILLPENDING,
--	STOPPENDING,
--	INTERRUPTPENDING,
--	COMPLETEDSUCCESS,
--	COMPLETEDFAIL,
--	STATEKILLED,
--	COMPLETEDPARTIAL,
--	SYSTEMKILLPENDING, -- this is used when the job is to be automatically killed
--	DORMANT,
--	QUEUED,
--	DORMANTSCHEDWAIT,
--	RUNNING_UNVERIFIABLE,
--	DANGLINGJOBCLEANUP -- this is used when the j
  end
  if @i_ID > 0
  begin
	UPDATE DMResultSet
	SET RestoreStatus = 0, DestinationPath = ''
	WHERE ID = @i_ID
  end
  else if len(@i_ResultSetID) <= 0 and @i_RestoreJobID > 0
  begin
	  if @i_IsJM = 0
        BEGIN
                  ;WITH CTE AS
                  (
                        SELECT DISTINCT ResultSetID FROM DMResultSet WITH (NOLOCK)
                        WHERE RestoreJobID = @i_RestoreJobID
                              and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
                  )
			  update DMResultSet
			  set RestoreStatus = @dm2RestoreStatus
                    WHERE ResultSetID IN ( SELECT C.ResultSetID FROM CTE AS C )
                    --update DMResultSet
                    --set RestoreStatus = @dm2RestoreStatus
                    --where RestoreJobID = @i_RestoreJobID
                    --and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
        END
	  else
		  if @dm2RestoreStatus <> 4 and @dm2RestoreStatus >= 0
              BEGIN
                  ;WITH CTE AS
                  (
                        SELECT DISTINCT ResultSetID FROM DMResultSet WITH (NOLOCK)
                        WHERE RestoreJobID = @i_RestoreJobID
                              AND RestoreStatus NOT IN (4, @dm2RestoreStatus)
                              AND (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
                  )
			  update DMResultSet
			  set RestoreStatus = @dm2RestoreStatus
                  WHERE ResultSetID IN ( SELECT C.ResultSetID FROM CTE AS C )
                    --update DMResultSet
                    --set RestoreStatus = @dm2RestoreStatus
                    --where RestoreJobID = @i_RestoreJobID
                    --and RestoreStatus NOT IN (4, @dm2RestoreStatus)
                    --and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
              END
              ELSE
              BEGIN
                        ;WITH CTE AS
                        (
                              SELECT DISTINCT ResultSetID FROM DMResultSet WITH (NOLOCK)
                              WHERE RestoreJobID = @i_RestoreJobID
                                      and RestoreStatus NOT IN (4,5)
			  and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
                        )
			  update DMResultSet
			  set RestoreStatus = 5
                        WHERE ResultSetID IN ( SELECT C.ResultSetID FROM CTE AS C )
                    --update DMResultSet
                    --set RestoreStatus = 5
                    --where RestoreJobID = @i_RestoreJobID
                    --and RestoreStatus NOT IN (4,5)
                    --and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
              END
  end
  else
  begin
	exec ('update DMResultSet set RestoreStatus = 0, DestinationPath = '''', RestoreJobID = 0 where ResultSetID in (''' + @i_ResultSetID + ''')')
  end
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreStatus',  '00010009000000000000', 'sp_dm2_UpdateRestoreStatus', '00010009000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreStatusBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreStatusBulk()
--  | Description:  Update the Restore Status in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreStatusBulk.sp,v $ $Id: sp_dm2_UpdateRestoreStatusBulk.sp,v 1.6 2015/04/16 18:51:08 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreStatusBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreStatusBulk')
	drop procedure sp_dm2_UpdateRestoreStatusBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreStatusBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreStatusBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreStatusBulk
  @i_jobId Integer,
  @DMrestoreTbl DM2RestoreStatusUpdate READONLY
AS
BEGIN
-- expects a list like
-- <restlist>
--    <file CCId="2" AFId="2" AFOffset="27" DPath="/blabla" />
--    <file CCId="2" AFId="4" AFOffset="37" />
--    <file CCId="2" AFId="6" AFOffset="909" />
-- </restlist>
	DECLARE @lt_AFFiles TABLE (CCId int, AFId bigint, AFOffset bigint, OrigPath nvarchar(max), DestPath nvarchar(max), status int, ResultItemID char(36))
	DECLARE @error int
	DECLARE @DownloadID char(36)
--	INSERT INTO @lt_AFFiles (CCId,AFId,AFOffset,OrigPath,DestPath,status)
--	SELECT T.c.value('@CCId','int'),
--		   T.c.value('@AFId', 'bigint'),
--		   T.c.value('@AFOffset', 'bigint'),
--		   T.c.value('@OPath', 'nvarchar(max)'),
--		   T.c.value('@DPath', 'nvarchar(max)'),
--		   ISNULL(T.c.value('@status', 'int'), 0) -- ERMStatus for success
--	FROM   @i_xml_AFFiles.nodes('/restlist/file') T(c)
	INSERT INTO @lt_AFFiles (CCId,AFId,AFOffset,OrigPath,DestPath,status)
	SELECT T.CCId,T.AFId,T.AFOffset,T.OPath,T.DPath,ISNULL(T.status, 0) FROM @DMrestoreTbl as T
	UPDATE tt
	SET ResultItemID = ResultSetID
	FROM @lt_AFFiles tt,
	DMResultSet R WITH(NOLOCK)
	WHERE
				-- CommcellNumber= tt.CCId AND
			aFileID = tt.AFId
			AND ( aFileOffset = tt.AFOffset OR OriginalFullPath = tt.OrigPath)
		-- and jobid equals whatever
	BEGIN TRANSACTION
		UPDATE DMResultSet
		SET DestinationPath = tt.DestPath, RestoreStatus = 4
		FROM @lt_AFFiles tt
		WHERE ResultSetID = tt.ResultItemID
		SET @error = @@ERROR
		IF @error = 0
		BEGIN
			SELECT TOP 1 @DownloadID = DownloadID FROM DMDownload WITH(NOLOCK) WHERE RestoreJobID = @i_jobId
			IF ISNULL(@DownloadID, '') <> ''
			BEGIN
				UPDATE DMDownloadResultSet
				SET [FileName] = tt.DestPath,
				[Status] = (CASE WHEN ISNULL(tt.DestPath, '') <> '' THEN 100 ELSE 500 END)
				FROM @lt_AFFiles tt
				WHERE DownloadID = @DownloadID AND ResultSetID = tt.ResultItemID
				SET @error = @@ERROR
			END
		END
	IF @error = 0
		COMMIT TRANSACTION
	ELSE
		ROLLBACK TRANSACTION
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreStatusBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreStatusBulk',  '00010006000000000000', 'sp_dm2_UpdateRestoreStatusBulk', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateUserComment.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateUserComment()
--  | Description:  Update the User Comments
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateUserComment.sp,v $ $Id: sp_dm2_UpdateUserComment.sp,v 1.4 2010/07/12 23:42:12 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateUserComment <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateUserComment')
	drop procedure sp_dm2_UpdateUserComment
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateUserComment')
	delete from GxQscripts where name = 'sp_dm2_UpdateUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateUserComment'
GO
print '... Creating Procedure: sp_dm2_UpdateUserComment'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateUserComment
  @i_CommentID char(36),
  @i_Comment nvarchar(max)
AS
	SET NOCOUNT ON
  if exists (select * from DMUserComment WITH (READUNCOMMITTED) where CommentID = @i_CommentID)
  begin
  	if (len(isnull(@i_Comment, '')) > 0)
  	begin
		  update DMUserComment
		  set Comment = @i_Comment, ModifiedTime = getUtcDate()
		  where CommentID = @i_CommentID
		end
		else
		begin
			-- remove the comment row if comment is empty
		  delete DMUserComment
		  where CommentID = @i_CommentID
		end
	end
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateUserComment')
	delete from GxQscripts where name = 'sp_dm2_UpdateUserComment'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateUserComment')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateUserComment'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateUserComment',  '00010004000000000000', 'sp_dm2_UpdateUserComment', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneActionInfo.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneActionInfo.sp,v $ $Id: sp_dm2_PruneActionInfo.sp,v 1.2 2013/07/16 12:44:48 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneActionInfo <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneActionInfo')
	drop procedure sp_dm2_PruneActionInfo
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneActionInfo')
	delete from GxQscripts where name = 'sp_dm2_PruneActionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneActionInfo')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneActionInfo'
GO
print '... Creating Procedure: sp_dm2_PruneActionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneActionInfo
  @i_resultSetIds VARCHAR(MAX) = '', --semi colon seperated list
  @i_eventId BIGINT = 0,
  @i_eventType INT = 0,	
  @i_userGuid VARCHAR(36) = ''
AS
SET NOCOUNT ON
BEGIN
	SELECT @i_resultSetIds = ISNULL(@i_resultSetIds,''),
			@i_userGuid = ISNULL(@i_userGuid,''),
			@i_eventId = ISNULL(@i_eventId ,0),
			@i_eventType = ISNULL(@i_eventType ,0)
	--If no valid inputs are provided, return
	IF (@i_eventId = 0 AND
		@i_eventType = 0 AND
		LEN(@i_resultSetIds) = 0 AND
		LEN(@i_userGuid) = 0 )
	BEGIN
		RETURN
	END
	IF object_id('tempdb.dbo.#zeroRefEventId') IS NOT NULL
		DROP TABLE #zeroRefEventId
	--temp table to prune all entries belonging to eventId
	CREATE TABLE #zeroRefEventId (refEventId BIGINT);
	IF(LEN(@i_resultSetIds) > 0)
	BEGIN
		IF object_id('tempdb.dbo.#deletedRows_PruneAction') IS NOT NULL
			DROP TABLE #deletedRows_PruneAction
		IF object_id('tempdb.dbo.#distinctDeletedRows_PruneAction') IS NOT NULL
			DROP TABLE #distinctDeletedRows_PruneAction
		CREATE TABLE #deletedRows_PruneAction (refEventId BIGINT);
		CREATE TABLE #distinctDeletedRows_PruneAction (refEventId BIGINT);
		IF object_id('tempdb.dbo.#inputResultSetId') IS NOT NULL
			DROP TABLE #inputResultSetId
		CREATE TABLE #inputResultSetId (resultSetId char(36) PRIMARY KEY);
		INSERT INTO #inputResultSetId
		SELECT DISTINCT  S.ID FROM dbo.splitStringToTable(@i_resultSetIds) AS S
		--Insert the deleted rows into the #tempTable, so if that eventId doesnt have any resultSetIds then entire event details can be pruned
		DELETE FROM DMActionItemMap
		OUTPUT	DELETED.refEventId
			INTO #deletedRows_PruneAction
		WHERE ResultSetId IN (SELECT IR.resultSetId FROM #inputResultSetId AS IR)
		INSERT INTO #distinctDeletedRows_PruneAction
		SELECT DISTINCT refEventId FROM #deletedRows_PruneAction
		INSERT INTO #zeroRefEventId
		SELECT distinct refEventId FROM #distinctDeletedRows_PruneAction AS T
		WHERE NOT EXISTS( SELECT refEventId FROM DMActionItemMap AS AIM WHERE AIM.refEventId = T.refEventId )
	END
	IF(@i_eventId > 0)
	BEGIN
		INSERT INTO #zeroRefEventId VALUES (@i_eventId)
	END
	IF( @i_eventType > 0 )
	BEGIN
		INSERT INTO #zeroRefEventId
		SELECT EventId FROM DMAction
		WHERE EventType = @i_eventType
	END
	IF( LEN(@i_userGuid) > 0)
	BEGIN
		INSERT INTO #zeroRefEventId
		SELECT EventId FROM DMAction
		WHERE UserGuid = @i_userGuid
	END
	IF EXISTS (SELECT refEventId FROM #zeroRefEventId)
	BEGIN
		-- Prune from DMActionItemMap
		DELETE FROM DMActionItemMap
		WHERE refEventId IN (SELECT DISTINCT T.refEventId FROM #zeroRefEventId AS T )
		--Prune FROM DMActionParam
		DELETE FROM DMActionParam
		WHERE refEventId IN (SELECT DISTINCT T.refEventId FROM #zeroRefEventId AS T )
		--prune from DMAction
		DELETE FROM DMAction
		WHERE EventId IN (SELECT DISTINCT T.refEventId FROM #zeroRefEventId AS T )
	END
	IF object_id('tempdb.dbo.#zeroRefEventId') IS NOT NULL
		DROP TABLE #zeroRefEventId
	IF object_id('tempdb.dbo.#deletedRows_PruneAction') IS NOT NULL
			DROP TABLE #deletedRows_PruneAction
	IF object_id('tempdb.dbo.#distinctDeletedRows_PruneAction') IS NOT NULL
			DROP TABLE #distinctDeletedRows_PruneAction
	IF object_id('tempdb.dbo.#inputResultSetId') IS NOT NULL
			DROP TABLE #inputResultSetId
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneActionInfo')
	delete from GxQscripts where name = 'sp_dm2_PruneActionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneActionInfo')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneActionInfo'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneActionInfo',  '00010002000000000000', 'sp_dm2_PruneActionInfo', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateResultSetToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateResultSetToPrune()
--  | Description:  Update the resultsets to prune
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateResultSetToPrune.sp,v $ $Id: sp_dm2_UpdateResultSetToPrune.sp,v 1.3 2011/06/21 10:01:21 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateResultSetToPrune <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateResultSetToPrune')
	drop procedure sp_dm2_UpdateResultSetToPrune
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateResultSetToPrune')
	delete from GxQscripts where name = 'sp_dm2_UpdateResultSetToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateResultSetToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateResultSetToPrune'
GO
print '... Creating Procedure: sp_dm2_UpdateResultSetToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateResultSetToPrune
  @i_PruneResults XML
AS
	SET NOCOUNT ON
-- expects a list like
-- <PruneResults>
--    <ResultSet ResultSetID="abcd-abcd0a0d-ad-gadg-ag-d" PruneStatus="1"/>
--    <ResultSet ResultSetID="asdfas-abcdasdf0a0d-ad-asd" PruneStatus="2"/>
--    <ResultSet ResultSetID="abasdfasd-adsf-a-dsf-a-dfd" PruneStatus="3"/>
-- </PruneResults>
	DECLARE @tblResultSetPruneResults TABLE (RSID varchar(36), Status int)
	DECLARE @tblResultSetDeleted TABLE (RSID varchar(36))
	INSERT INTO @tblResultSetPruneResults
	SELECT T.c.value('@ResultSetID','varchar(36)'),
		   T.c.value('@PruneStatus', 'int')
	FROM @i_PruneResults.nodes('/PruneResults/ResultSet') T(c)
	INSERT INTO @tblResultSetDeleted
	SELECT DISTINCT RS.ResultSetID
	FROM DMResultSet RS WITH (READUNCOMMITTED) LEFT OUTER JOIN DMDownloadResultSet D WITH (READUNCOMMITTED)
	ON RS.ResultSetId = D.ResultSetId
	WHERE D.ResultSetId IS NULL
	AND RS.ResultSetID IN (SELECT RSID FROM @tblResultSetPruneResults WHERE Status = 0)
	AND	(RS.Attribute & 4) = 4
	-- Update prune status for items that are successfully removed from cache
	UPDATE DMResultSet
	SET PruneStatus = 0,
	PruneUpdateTime = getUTCDate(),
	DestinationPath = '',
	RestoreUserGUID = '',
	RestoreCommCellNumber = 0,
	RestoreJobID = 0,
	RestoreStatus = 0,
	RestoreTime = NULL
	WHERE ResultSetID IN (SELECT RSID FROM @tblResultSetPruneResults WHERE Status = 0)
	-- Update the PruneStatus of all items that failed to remove from cache
	UPDATE DMResultSet
	SET PruneStatus = tt.Status, PruneUpdateTime = getUTCDate()
	FROM @tblResultSetPruneResults tt
  WHERE ResultSetID = tt.RSID
  AND		tt.Status != 0
	AND	(Attribute & 4) = 4
	UPDATE DMResultSet
	SET PruneStatus = 0, PruneUpdateTime = getUTCDate()
	FROM @tblResultSetPruneResults tt
  WHERE ResultSetID = tt.RSID
  AND tt.Status != 0
	AND	(Attribute & 4) = 0
/*
	-- This can be moved to sp_dm2_prunedownload
	delete from DMDownloadResultSet
	where ResultSetID in (select RSID from @tblResultSetDeleted)
	-- This will be moved to new SP which needs to handle physical pruning of zip files and cab files
	-- In response of above SP we will delete entries from DMDownload table
	delete from DMDownload
	where DownloadID not in (select DownloadID from DMDownloadResultSet WITH (READUNCOMMITTED))
*/
/*
	-- No need to keep entries for Legalhold since we are now going to get legalhold page info from LegalHold MetaData XML
	-- Do Not delete the resultset for LegalHold Backups
	DELETE 	@tblResultSetDeleted
	FROM 		@tblResultSetDeleted T, DMLegalHoldItemsToBackup LHI WITH (NOLOCK)
	WHERE 	T.RSID = LHI.ResultSetID
*/
	-- Now we are not going to soft delete items in DMContainerItem table.
	--It will be deleted when delete operation is performed on Reviewsets or items on reviewset
	--However, need this deletion for upgrading customers
	DELETE FROM DMContainerItem
	WHERE ResultSetID IN (SELECT RSID FROM @tblResultSetDeleted)
	DELETE 	DMContainerItemStates
	FROM 		DMContainerItemStates S LEFT OUTER JOIN DMContainerItem CI
	ON 			S.containerID = CI.containerID
	AND			S.resultsetID = CI.resultsetID
	WHERE 	CI.containerID IS NULL
	AND 		CI.resultsetID IS NULL
	--Items that are not restored can be deleted if not referenced in any reviewsets
	INSERT INTO @tblResultSetDeleted
	SELECT RS.ResultSetID
	FROM DMResultSet RS LEFT OUTER JOIN DMDownloadResultSet D
	ON RS.ResultSetId = D.ResultSetId
	WHERE D.ResultSetId IS null
	AND (DestinationPath IS null OR LEN(DestinationPath) = 0)
	AND	(Attribute & 4) = 4
	--prune DMACtion tables.
	DECLARE @ResultSetIds VARCHAR(MAX)
	SELECT @ResultSetIds = ISNULL(STUFF(
					(SELECT  ';' "text()", RSID "text()"
						FROM 	@tblResultSetDeleted
						FOR XML PATH('')),1,1,''),'')
	EXEC sp_dm2_PruneActionInfo @i_resultSetIds = @ResultSetIds
	DELETE FROM DMResultSet
	WHERE ResultSetID IN (SELECT RSID FROM @tblResultSetDeleted)
	--DELETE DMResultSet
	--FROM DMResultSet RS LEFT OUTER JOIN DMDownloadResultSet D
	--ON RS.ResultSetId = D.ResultSetId
	--WHERE D.ResultSetId IS null
	--AND (DestinationPath IS null OR LEN(DestinationPath) = 0)
	--AND	(Attribute & 4) = 4
/*
	-- We don't need to set / unset this flag now
	UPDATE DMContainerItem
	SET Attribute = (Attribute & ~1)
	where ResultSetID in (select RSID from @tblResultSetPruneResults where Status = 0)
	and (Attribute & 1) = 1
	-- DMContainer table is moved to CS now
	-- There is no user preference based pruning
	delete from DMContainer
	where ContainerID not in (select ContainerID from DMContainerItem WITH (READUNCOMMITTED))
	and (Attribute & 1) = 1
*/
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateResultSetToPrune')
	delete from GxQscripts where name = 'sp_dm2_UpdateResultSetToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateResultSetToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateResultSetToPrune'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateResultSetToPrune',  '00010003000000000000', 'sp_dm2_UpdateResultSetToPrune', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_SyncItemTagsWithCIServerBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_SyncItemTagsWithCIServerBulk.sp,v $ $Id: sp_dm2_SyncItemTagsWithCIServerBulk.sp,v 1.5 2010/05/13 17:21:42 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_SyncItemTagsWithCIServerBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_SyncItemTagsWithCIServerBulk')
	drop procedure sp_dm2_SyncItemTagsWithCIServerBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_SyncItemTagsWithCIServerBulk')
	delete from GxQscripts where name = 'sp_dm2_SyncItemTagsWithCIServerBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncItemTagsWithCIServerBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncItemTagsWithCIServerBulk'
GO
print '... Creating Procedure: sp_dm2_SyncItemTagsWithCIServerBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_SyncItemTagsWithCIServerBulk
  @i_ContainerID varchar(36),
  @i_UserID varchar(36),
  @i_SelALLFlag INTEGER,
  @i_DataFilePath varchar(1024),
  @i_ForceSync INTEGER
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
	DECLARE @errorCode integer
	declare @l_delimiter	varchar(256)
	declare @SQL					varchar(2048)
	declare	@uniqueId 		varchar(36)
	set @l_delimiter = ISNULL((select SettingValue from DMSetting WITH (READUNCOMMITTED) where settingName = 'DMBulkInsert_Delim'), '')
	IF(len(@l_delimiter ) = 0)
		SET @l_delimiter = 'CV0X12'
	IF object_id('tempdb.dbo.#tmpDMResultSet') is not null
	DROP TABLE #tmpDMResultSet
	IF object_id('tempdb.dbo.#tmpDMResultSetTags') is not null
	DROP TABLE #tmpDMResultSetTags
	create table #tmpDMResultSet
	(
		[ResultSetID] [char](36) NOT null
	)
	create table #tmpDMResultSetTags
	(
		[ResultSetID] [char](36) NOT null,
		[UserGUID]		[char](36) NOT null,
		[TagGUID]			[char](36) null,
		[Attribute]		int
	)
	IF (@i_SelALLFlag = 0)
	BEGIN
		SET @SQL = 'BULK INSERT #tmpDMResultSet FROM '''+@i_DataFilePath+''' WITH (FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
		exec (@SQL)
	END
	ELSE
	BEGIN
		INSERT INTO #tmpDMResultSet
		SELECT DISTINCT ResultSetID
		FROM DMContainerItem CI
		WHERE CI.ContainerID = @i_ContainerID
		AND		CI.Attribute & 4 = 0
	END
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tmpDMResultSetTags
	SELECT DISTINCT TT.ResultSetId, @i_UserID, CIT.TagID, CIT.Attribute
	FROM #tmpDMResultSet TT, DMContainerItemStates as CIS WITH (READUNCOMMITTED), DMContainerItemTags CIT WITH (READUNCOMMITTED)
	WHERE CIS.ContainerId = @i_ContainerId
	AND 	CIS.ResultSetId = TT.ResultSetId
	AND		CIS.AssignedUserGUID = @i_UserID
	AND		CIS.AssignID = CIT.AssignID
	AND		((@i_ForceSync = 1) OR (CIT.Attribute & (2 + 8)) = 0)		-- NOT SYNCed, Not Submitted For Sync
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- DO NOT send the items without documentID for Tagging since those items will never get tags in CIServer
	DELETE #tmpDMResultSetTags
	FROM 	#tmpDMResultSetTags AS tt, DMResultSet AS RS WITH (NOLOCK)
	WHERE tt.ResultSetID = RS.ResultSetID
	AND		(RS.documentID IS NULL OR LEN(RS.documentID) = 0)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update the DELETE flag if there is new request to ADD tag again
	UPDATE DMUserItemTags
	SET 	Attribute = tt.Attribute
	FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
	WHERE UIT.ResultSetId = tt.ResultSetId
	AND		UIT.UserGUID = tt.UserGUID
	AND		UIT.TagID = tt.TagGUID
	AND		UIT.Attribute & 4 = 4
	AND		tt.Attribute & 4 = 0
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tmpDMResultSetTags
	SELECT DISTINCT UIT.ResultSetId, @i_UserID, UIT.TagID, UIT.Attribute
	FROM #tmpDMResultSet TT, DMUserItemTags UIT
	WHERE UIT.ResultSetId = TT.ResultSetId
	AND		UIT.UserGUID = @i_UserID
	AND		((@i_ForceSync = 1) OR (UIT.Attribute & (2 + 8)) = 0)	-- NOT SYNCed, Not Submitted For Sync
	AND		NOT EXISTS (SELECT TOP 1 * FROM #tmpDMResultSetTags AS TAG
										WHERE UIT.ResultSetId = TAG.ResultSetId
										AND		UIT.UserGUID = TAG.UserGUID
										AND		UIT.TagID = TAG.TagGUID)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- DO NOT send the items without documentID for Tagging since those items will never get tags in CIServer
	DELETE #tmpDMResultSetTags
	FROM 	#tmpDMResultSetTags AS tt, DMResultSet AS RS WITH (NOLOCK)
	WHERE tt.ResultSetID = RS.ResultSetID
	AND		(RS.documentID IS NULL OR LEN(RS.documentID) = 0)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	CREATE INDEX IDX_tmpDMResultSetTags_CIT ON #tmpDMResultSetTags(TagGUID, ResultSetID, UserGUID)
	SELECT @uniqueId = NEWID()
	INSERT INTO DMItemsToSyncWithCIServer
	SELECT DISTINCT @uniqueId, ResultSetID, UserGUID, TagGUID, Attribute, 0, 0
	FROM 	#tmpDMResultSetTags
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	DROP TABLE #tmpDMResultSet
	DROP TABLE #tmpDMResultSetTags
	SELECT	0 AS ErrorCode, @uniqueId AS UniqueID
	RETURN
CX_ERROR_EXIT:
	DROP TABLE #tmpDMResultSet
	DROP TABLE #tmpDMResultSetTags
	SELECT	-1 AS ErrorCode, '' AS UniqueID
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_SyncItemTagsWithCIServerBulk')
	delete from GxQscripts where name = 'sp_dm2_SyncItemTagsWithCIServerBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncItemTagsWithCIServerBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncItemTagsWithCIServerBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_SyncItemTagsWithCIServerBulk',  '00010005000000000000', 'sp_dm2_SyncItemTagsWithCIServerBulk', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetItemsToSyncWithCIServer.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetItemsToSyncWithCIServer.sp,v $ $Id: sp_dm2_GetItemsToSyncWithCIServer.sp,v 1.2 2008/04/23 21:19:21 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetItemsToSyncWithCIServer <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetItemsToSyncWithCIServer')
	drop procedure sp_dm2_GetItemsToSyncWithCIServer
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetItemsToSyncWithCIServer')
	delete from GxQscripts where name = 'sp_dm2_GetItemsToSyncWithCIServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetItemsToSyncWithCIServer')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetItemsToSyncWithCIServer'
GO
print '... Creating Procedure: sp_dm2_GetItemsToSyncWithCIServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetItemsToSyncWithCIServer
  @i_UniqueID varchar(36),
  @i_itemsInBatch int = 500
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
	DECLARE @errorCode 	integer
	DECLARE @numRow 		integer
	IF object_id('tempdb.dbo.#tmpDMResultSet') is not null
	DROP TABLE #tmpDMResultSet
	create table #tmpDMResultSet
	(
		ResultSetID 		char(36) 			NOT null,
		aFileId					bigint 				NOT null,
		aFileOffset			bigint 				NOT null,
		CommcellNumber	int 					NOT null,
		documentID			varchar(256)	NOT null,
		UserID					char(36)			NOT null,
		TagID						char(36)			NOT null,
		TagOperation		int						NOT null
	)
	/*
	-- TagOperation = 1 --> ADD Tags
	-- TagOperation = 2 --> DELETE Tags
	*/
	INSERT INTO #tmpDMResultSet
	SELECT TOP (@i_itemsInBatch) ResultSetID, 0, 0, 0, '', UserGUID, TagGUID, CASE (Attribute & 4) WHEN 4 THEN 2 ELSE 1 END
	FROM DMItemsToSyncWithCIServer
	WHERE UniqueID = @i_UniqueID
	AND		IsProcessed = 0
	SELECT 	@errorCode = @@ERROR, @numRow = @@ROWCOUNT
	IF	@errorCode > 0 GOTO CX_ERROR_EXIT
	UPDATE 	#tmpDMResultSet
	SET aFileId = RS.afileId, aFileOffSet = RS.aFileOffset, CommcellNumber = RS.CommcellNumber, documentID = RS.documentID
	FROM #tmpDMResultSet TT, DMResultSet RS
	WHERE TT.ResultSetID = RS.ResultSetID
	IF @numRow > 0
	BEGIN
		-- Update the items as processed
		UPDATE 	DMItemsToSyncWithCIServer
		SET			IsProcessed = 1
		FROM 		#tmpDMResultSet TT, DMItemsToSyncWithCIServer ITS
		WHERE 	UniqueID = @i_UniqueID
		AND			TT.ResultSetID = ITS.ResultSetID
	END
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	SELECT 0 AS ErrorCode, ResultSetID, aFileId, aFileOffset, CommcellNumber, documentID, UserID, TagID, TagOperation
	FROM #tmpDMResultSet
	ORDER BY ResultSetID
	DROP TABLE #tmpDMResultSet
	RETURN
CX_ERROR_EXIT:
	SELECT	-1 AS ErrorCode, '', 0, 0, 0, '', '', '', 0
	DROP TABLE #tmpDMResultSet
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetItemsToSyncWithCIServer')
	delete from GxQscripts where name = 'sp_dm2_GetItemsToSyncWithCIServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetItemsToSyncWithCIServer')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetItemsToSyncWithCIServer'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetItemsToSyncWithCIServer',  '00010002000000000000', 'sp_dm2_GetItemsToSyncWithCIServer', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateSubmittedForSyncFlag.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateSubmittedForSyncFlag.sp,v $ $Id: sp_dm2_UpdateSubmittedForSyncFlag.sp,v 1.1 2008/04/24 18:37:01 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateSubmittedForSyncFlag <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateSubmittedForSyncFlag')
	drop procedure sp_dm2_UpdateSubmittedForSyncFlag
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateSubmittedForSyncFlag')
	delete from GxQscripts where name = 'sp_dm2_UpdateSubmittedForSyncFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateSubmittedForSyncFlag')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateSubmittedForSyncFlag'
GO
print '... Creating Procedure: sp_dm2_UpdateSubmittedForSyncFlag'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateSubmittedForSyncFlag
  @i_UniqueID varchar(36),
  @i_JobID int
AS
  DECLARE @o_errorCode integer;
	SET NOCOUNT ON
	UPDATE DMItemsToSyncWithCIServer
	SET JobId = @i_JobID
	WHERE UniqueID = @i_UniqueID
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update the Submitted TO FAST flag for Item specific rows
	UPDATE DMUserItemTags
	SET 	Attribute = UIT.Attribute | 8
	FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), DMItemsToSyncWithCIServer ITS WITH (READUNCOMMITTED)
	WHERE UIT.ResultSetId = ITS.ResultSetId
	AND		UIT.UserGUID = ITS.UserGUID
	AND		UIT.TagID = ITS.TagGUID
	AND		UIT.Attribute & 8 = 0
	AND		ITS.UniqueID = @i_UniqueID
	AND		ITS.IsProcessed = 1
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update the Submitted TO FAST flag for Container specific rows
	UPDATE DMContainerItemTags
	SET 	Attribute = CIT.Attribute | 8
	FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), DMItemsToSyncWithCIServer as ITS WITH (READUNCOMMITTED)
	WHERE ITS.UniqueID = @i_UniqueID
	AND		ITS.IsProcessed = 1
	AND		CIS.ResultSetId = ITS.ResultSetId
	AND		CIS.AssignedUserGUID = ITS.UserGUID
	AND		CIS.AssignID = CIT.AssignID
	AND		CIT.TagID = ITS.TagGUID
	AND		CIT.Attribute & 8 = 0
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	SELECT 0 as ErrorCode
	RETURN
CX_ERROR_EXIT:
	SELECT	-1 as ErrorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateSubmittedForSyncFlag')
	delete from GxQscripts where name = 'sp_dm2_UpdateSubmittedForSyncFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateSubmittedForSyncFlag')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateSubmittedForSyncFlag'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateSubmittedForSyncFlag',  '00010001000000000000', 'sp_dm2_UpdateSubmittedForSyncFlag', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateSyncWithCIServerFlag.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateSyncWithCIServerFlag.sp,v $ $Id: sp_dm2_UpdateSyncWithCIServerFlag.sp,v 1.2 2008/04/24 18:37:01 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateSyncWithCIServerFlag <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateSyncWithCIServerFlag')
	drop procedure sp_dm2_UpdateSyncWithCIServerFlag
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateSyncWithCIServerFlag')
	delete from GxQscripts where name = 'sp_dm2_UpdateSyncWithCIServerFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateSyncWithCIServerFlag')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateSyncWithCIServerFlag'
GO
print '... Creating Procedure: sp_dm2_UpdateSyncWithCIServerFlag'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateSyncWithCIServerFlag
  @i_JobID int
AS
  DECLARE @o_errorCode integer;
	SET NOCOUNT ON
	-- Unset Submit To FAST flag
	UPDATE DMUserItemTags
	SET 	Attribute = UIT.Attribute & ~8
	FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), DMItemsToSyncWithCIServer ITS WITH (READUNCOMMITTED)
	WHERE UIT.ResultSetId = ITS.ResultSetId
	AND		UIT.UserGUID = ITS.UserGUID
	AND		UIT.TagID = ITS.TagGUID
	AND		UIT.Attribute & 8 = 8
	AND		ITS.JobID = @i_JobID
	AND		ITS.IsProcessed = 1
	-- Update the SYNC TO FAST flag
	UPDATE DMUserItemTags
	SET 	Attribute = UIT.Attribute | 2
	FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), DMItemsToSyncWithCIServer ITS WITH (READUNCOMMITTED)
	WHERE UIT.ResultSetId = ITS.ResultSetId
	AND		UIT.UserGUID = ITS.UserGUID
	AND		UIT.TagID = ITS.TagGUID
	AND		UIT.Attribute & 2 = 0
	AND		ITS.JobID = @i_JobID
	AND		ITS.IsProcessed = 1
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Create the new entries
	INSERT INTO DMUserItemTags
	SELECT  ITS.UserGUID, ITS.ResultSetId, ITS.TagGUID, getDate(), 2 -- Synced with FAST
	FROM 	DMItemsToSyncWithCIServer as ITS WITH (READUNCOMMITTED)
	WHERE ITS.JobID = @i_JobID
	AND		ITS.IsProcessed = 1
	AND	NOT EXISTS (SELECT TOP 1 * FROM DMUserItemTags AS UIT WITH (READUNCOMMITTED)
										WHERE UIT.ResultSetId = ITS.ResultSetId
										AND		UIT.UserGUID = ITS.UserGUID
										AND		UIT.TagID = ITS.TagGUID)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Remove all Container specific rows once it is SYNCed in FAST
	DELETE DMContainerItemTags
	FROM 	DMContainerItemTags as CIT WITH (READUNCOMMITTED), DMContainerItemStates as CIS WITH (READUNCOMMITTED), DMItemsToSyncWithCIServer as ITS WITH (READUNCOMMITTED)
	WHERE ITS.JobID = @i_JobID
	AND		ITS.IsProcessed = 1
	AND		CIS.ResultSetId = ITS.ResultSetId
	AND		CIS.AssignedUserGUID = ITS.UserGUID
	AND		CIS.AssignID = CIT.AssignID
	AND		CIT.TagID = ITS.TagGUID
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	--DELETE the rows after being processed
	DELETE 	DMItemsToSyncWithCIServer
	WHERE 	JobID = @i_JobID
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	SELECT 0 as ErrorCode
	RETURN
CX_ERROR_EXIT:
	SELECT	-1 as ErrorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateSyncWithCIServerFlag')
	delete from GxQscripts where name = 'sp_dm2_UpdateSyncWithCIServerFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateSyncWithCIServerFlag')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateSyncWithCIServerFlag'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateSyncWithCIServerFlag',  '00010002000000000000', 'sp_dm2_UpdateSyncWithCIServerFlag', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateUserGUID.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateQuery()
--  | Description:  Update the Query
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateUserGUID.sp,v $ $Id: sp_dm2_UpdateUserGUID.sp,v 1.2 2010/04/28 05:28:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateUserGUID <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateUserGUID')
	drop procedure sp_dm2_UpdateUserGUID
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateUserGUID')
	delete from GxQscripts where name = 'sp_dm2_UpdateUserGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateUserGUID')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateUserGUID'
GO
print '... Creating Procedure: sp_dm2_UpdateUserGUID'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateUserGUID
  @i_origUserGUID varchar(36),
  @i_UserGUID varchar(36)
AS
	-- Update actual UserGUID with Galaxy UserGUID
	IF (@i_UserGUID <> @i_origUserGUID)
	BEGIN
		IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DMContainerHistory]') and OBJECTPROPERTY(id, N'IsTable') = 1)
		BEGIN
			UPDATE DMContainerHistory
			SET UserGUID = @i_UserGUID
			WHERE UserGUID = @i_origUserGUID
		END
		UPDATE DMContainerItem
		SET UserGUID = @i_UserGUID
		WHERE UserGUID = @i_origUserGUID
		UPDATE DMContainerItemStateHistory
		SET LastAssignedUserGUID = @i_UserGUID
		WHERE LastAssignedUserGUID = @i_origUserGUID
		UPDATE DMContainerItemStateHistory
		SET LastModifiedUserGUID = @i_UserGUID
		WHERE LastModifiedUserGUID = @i_origUserGUID
		UPDATE DMContainerItemStates
		SET AssignedUserGUID = @i_UserGUID
		WHERE AssignedUserGUID = @i_origUserGUID
		UPDATE DMContainerItemStates
		SET ModifiedUserGUID = @i_UserGUID
		WHERE ModifiedUserGUID = @i_origUserGUID
		UPDATE DMContainerItemTags
		SET ModifiedUserGUID = @i_UserGUID
		WHERE ModifiedUserGUID = @i_origUserGUID
		UPDATE DMDownload
		SET UserGUID = @i_UserGUID
		WHERE UserGUID = @i_origUserGUID
		UPDATE DMItemsToSyncWithCIServer
		SET UserGUID = @i_UserGUID
		WHERE UserGUID = @i_origUserGUID
		UPDATE DMJob
		SET UserGUID = @i_UserGUID
		WHERE UserGUID = @i_origUserGUID
		UPDATE DMQuery
		SET UserGUID = @i_UserGUID
		WHERE UserGUID = @i_origUserGUID
		UPDATE DMResultSet
		SET RestoreUserGUID = @i_UserGUID
		WHERE RestoreUserGUID = @i_origUserGUID
		UPDATE DMUserComment
		SET UserGUID = @i_UserGUID
		WHERE UserGUID = @i_origUserGUID
		UPDATE DMUserItemTags
		SET UserGUID = @i_UserGUID
		WHERE UserGUID = @i_origUserGUID
		UPDATE DMUserPref
		SET UserGUID = @i_UserGUID
		WHERE UserGUID = @i_origUserGUID
		UPDATE DMUserSession
		SET UserGUID = @i_UserGUID
		WHERE UserGUID = @i_origUserGUID
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateUserGUID')
	delete from GxQscripts where name = 'sp_dm2_UpdateUserGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateUserGUID')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateUserGUID'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateUserGUID',  '00010002000000000000', 'sp_dm2_UpdateUserGUID', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateHostName.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateDMJob()
--  | Description:  Update DMJob
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateHostName.sp,v $ $Id: sp_dm2_UpdateHostName.sp,v 1.1 2008/07/01 21:03:28 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateHostName <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateHostName')
	drop procedure sp_dm2_UpdateHostName
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateHostName')
	delete from GxQscripts where name = 'sp_dm2_UpdateHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateHostName')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateHostName'
GO
print '... Creating Procedure: sp_dm2_UpdateHostName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateHostName
  @i_clientHostName nvarchar(510) = '',
  @i_CSNetHostName nvarchar(510) = ''
AS
	IF @i_clientHostName IS NOT NULL AND LEN(@i_clientHostName) > 0
	BEGIN
	  UPDATE DMSetting
	  SET SettingValue = @i_clientHostName
	  WHERE SettingName = 'CommClientName'
	  AND		SettingValue <> @i_clientHostName
  END
	IF @i_CSNetHostName IS NOT NULL AND LEN(@i_CSNetHostName) > 0
	BEGIN
	  UPDATE DMSetting
	  SET SettingValue = @i_CSNetHostName
	  WHERE SettingName = 'CommserveHostName'
	  AND		SettingValue <> @i_CSNetHostName
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateHostName')
	delete from GxQscripts where name = 'sp_dm2_UpdateHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateHostName')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateHostName'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateHostName',  '00010001000000000000', 'sp_dm2_UpdateHostName', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_CleanDB.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_cleanDB.sp,v $ $Id: sp_dm2_cleanDB.sp,v 1.3 2011/12/27 12:23:49 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_CleanDB <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_CleanDB')
	drop procedure sp_dm2_CleanDB
IF EXISTS (select * from GxQscripts where name='sp_dm2_CleanDB')
	delete from GxQscripts where name = 'sp_dm2_CleanDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_CleanDB')
	delete from GXDBVersions where aliasname = 'sp_dm2_CleanDB'
GO
print '... Creating Procedure: sp_dm2_CleanDB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_CleanDB
AS
SET NOCOUNT ON
DELETE FROM DMItemsToSyncWithCIServer
DELETE FROM DMUserItemTags
DELETE FROM DMContainerItemStateHistory
DELETE FROM DMContainerItemTags
DELETE FROM DMContainerItemStates
DELETE FROM DMUserSession
DELETE FROM DMUserPref
DELETE FROM DMUserComment
DELETE FROM DMQuery
DELETE FROM DMLegalHoldItemsToBackup
DELETE FROM DMJob
DELETE FROM DMDownloadResultSet
DELETE FROM DMDownload
DELETE FROM DMContainerItem
DELETE FROM DMResultSetInfo
DELETE FROM DMEmailResult
DELETE FROM DMActionItemMap
DELETE FROM DMActionParam
DELETE FROM DMResultSet
DELETE FROM DMAction
IF EXISTS (SELECT * FROM SYSOBJECTS WHERE xtype='U' and name='DMContainerHistory')
BEGIN
	EXEC('DELETE FROM DMContainerHistory')
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_CleanDB')
	delete from GxQscripts where name = 'sp_dm2_CleanDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_CleanDB')
	delete from GXDBVersions where aliasname = 'sp_dm2_CleanDB'
GO

insert into GXDBVersions values(2, 'sp_dm2_CleanDB',  '00010003000000000000', 'sp_dm2_CleanDB', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetConnectionConfig.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetConnectionConfig.sp,v $ $Id: sp_dm2_GetConnectionConfig.sp,v 1.1 2009/06/16 05:42:35 sgupta Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetConnectionConfig <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetConnectionConfig')
	drop procedure sp_dm2_GetConnectionConfig
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetConnectionConfig')
	delete from GxQscripts where name = 'sp_dm2_GetConnectionConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetConnectionConfig')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetConnectionConfig'
GO
print '... Creating Procedure: sp_dm2_GetConnectionConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetConnectionConfig
AS
SET NOCOUNT ON
	SELECT * FROM [DMConnectionConfig] WITH (READUNCOMMITTED)
	ORDER BY Id
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetConnectionConfig')
	delete from GxQscripts where name = 'sp_dm2_GetConnectionConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetConnectionConfig')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetConnectionConfig'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetConnectionConfig',  '00010001000000000000', 'sp_dm2_GetConnectionConfig', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetPaneltoColumnConfig.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetPaneltoColumnConfig.sp,v $ $Id: sp_dm2_GetPaneltoColumnConfig.sp,v 1.5 2011/02/15 13:49:40 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetPaneltoColumnConfig <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetPaneltoColumnConfig')
	drop procedure sp_dm2_GetPaneltoColumnConfig
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetPaneltoColumnConfig')
	delete from GxQscripts where name = 'sp_dm2_GetPaneltoColumnConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetPaneltoColumnConfig')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetPaneltoColumnConfig'
GO
print '... Creating Procedure: sp_dm2_GetPaneltoColumnConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetPaneltoColumnConfig
  @i_SiteMode varchar(50) = '',
  @i_Name varchar(50) = ''
AS
SET NOCOUNT ON
	BEGIN
		SELECT ISNULL(C.ColumnName, '') AS ColumnName, ISNULL(C.ResourceKey, '') AS ResourceKey,
		ISNULL(C.PropertyName, '') AS PropertyName, Width, Alignment, ISNULL(A.DisplayOrder, -1) AS DisplayOrder,
		(A.PanelTypeId) AS PanelTypeId	-- Both ENUMS and DB PanelTypeId starts from 1
		FROM [DMUIPanelColumns] AS A
		WITH (READUNCOMMITTED)
		INNER JOIN [DMUIPanelType] AS B ON B.Id = A.PanelTypeId
		INNER JOIN [DMUIColumns] AS C ON C.Id = A.ColumnId
		WHERE ((LEN(ISNULL(@i_Name,'')) = 0) OR B.Name = @i_Name)
			AND ((SELECT BinaryWeightage FROM [DMSearchView] WHERE ViewName = @i_SiteMode) & A.BitVisibility > 0)
		ORDER BY B.id,A.DisplayOrder
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetPaneltoColumnConfig')
	delete from GxQscripts where name = 'sp_dm2_GetPaneltoColumnConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetPaneltoColumnConfig')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetPaneltoColumnConfig'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetPaneltoColumnConfig',  '00010005000000000000', 'sp_dm2_GetPaneltoColumnConfig', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetAdminPref.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetAdminPref.sp,v $ $Id: sp_dm2_GetAdminPref.sp,v 1.4 2009/11/18 13:33:21 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetAdminPref <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetAdminPref')
	drop procedure sp_dm2_GetAdminPref
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetAdminPref')
	delete from GxQscripts where name = 'sp_dm2_GetAdminPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAdminPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAdminPref'
GO
print '... Creating Procedure: sp_dm2_GetAdminPref'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetAdminPref
  @i_ViewNames VARCHAR(max)= '',
  @i_IsCustom bit = 0,
  @i_PrefNames varchar(max) = ''
AS
SET NOCOUNT ON
IF (@i_IsCustom = 1)
BEGIN
		select PrefName,PrefValue,(select top 1 ViewName from DMSearchView sv where a.ViewName = sv.Id) as ViewName
		from DMAdminPref a where (a.PrefName in (select distinct FieldLabel from DMSearchCriteriaField where GroupId = 11))
		and ( LEN(@i_PrefNames) = 0 or PrefName in (select * from dbo.splitStringToTable(@i_PrefNames)))
		and ( LEN(@i_ViewNames) = 0 or (Select Top 1 V.ViewName from DMSearchView as V where  Id = a.ViewName)
			in (select * from dbo.splitStringToTable(@i_ViewNames)))
END
ELSE
BEGIN
		select PrefName,PrefValue,CreatedBy =
			Case
				When (select top 1 UserName from DMUserSession where UserGUID=CreatedBy) is not null then
					(select top 1 UserName from DMUserSession where UserGUID=CreatedBy)
				else 'N/A'
			end,
			CreatedTime, ModifiedBy =
			Case
				When (select top 1 UserName from DMUserSession where UserGUID=ModifiedBy) is not null then
					(select top 1 UserName from DMUserSession where UserGUID=ModifiedBy)
				else 'N/A'
			end		,
		ModifiedTime,
		(select top 1 ViewName from DMSearchView sv where a.ViewName = sv.Id) as ViewName
		from DMAdminPref a
		WHERE (len(@i_ViewNames) = 0 or ViewName in (select * from dbo.splitStringToTable(@i_ViewNames)) ) AND ( LEN(@i_PrefNames) = 0 or
				PrefName in (select * from dbo.splitStringToTable(@i_PrefNames)))
		 and
		PrefName in (select distinct FieldLabel from DMSearchCriteriaField where GroupId = 9)
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetAdminPref')
	delete from GxQscripts where name = 'sp_dm2_GetAdminPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAdminPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAdminPref'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetAdminPref',  '00010004000000000000', 'sp_dm2_GetAdminPref', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDefaultAdminPreference.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDefaultAdminPreference.sp,v $ $Id: sp_dm2_GetDefaultAdminPreference.sp,v 1.4 2010/06/08 07:17:33 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDefaultAdminPreference <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDefaultAdminPreference')
	drop procedure sp_dm2_GetDefaultAdminPreference
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDefaultAdminPreference')
	delete from GxQscripts where name = 'sp_dm2_GetDefaultAdminPreference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDefaultAdminPreference')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDefaultAdminPreference'
GO
print '... Creating Procedure: sp_dm2_GetDefaultAdminPreference'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDefaultAdminPreference
  @i_PrefNames VARCHAR(MAX)= '',
  @i_siteMode VARCHAR(50) = 'Admin',
  @i_IsCustom BIT = 0
AS
SET NOCOUNT ON
DECLARE @bitVisibility	int = 4
SET @bitVisibility = ISNULL((SELECT BinaryWeightage FROM DMSearchView WHERE ViewName = @i_siteMode),4);
SELECT FieldLabel, DataType, UIControlType,DefaultValues,InitialDefaultValue
		FROM DMSearchCriteriaField WHERE ((BitVisibility&@bitVisibility)>0) AND ( LEN(@i_PrefNames) = 0 or
		FieldLabel in (select * from dbo.splitStringToTable(@i_PrefNames))) AND
		GroupId = Case when @i_IsCustom = 1 then (select 11)
					else (select 9)
					End
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDefaultAdminPreference')
	delete from GxQscripts where name = 'sp_dm2_GetDefaultAdminPreference'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDefaultAdminPreference')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDefaultAdminPreference'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDefaultAdminPreference',  '00010004000000000000', 'sp_dm2_GetDefaultAdminPreference', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AdminPreferenceOperation.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AdminPreferenceOperation.sp,v $ $Id: sp_dm2_AdminPreferenceOperation.sp,v 1.8 2010/07/21 06:29:57 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AdminPreferenceOperation <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AdminPreferenceOperation')
	drop procedure sp_dm2_AdminPreferenceOperation
IF EXISTS (select * from GxQscripts where name='sp_dm2_AdminPreferenceOperation')
	delete from GxQscripts where name = 'sp_dm2_AdminPreferenceOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AdminPreferenceOperation')
	delete from GXDBVersions where aliasname = 'sp_dm2_AdminPreferenceOperation'
GO
print '... Creating Procedure: sp_dm2_AdminPreferenceOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AdminPreferenceOperation
  @i_input as nvarchar(max) = ''
AS
SET NOCOUNT ON
IF ( LEN(@i_input) > 0)
BEGIN
	DECLARE 	@viewId			VARCHAR(MAX)
	DECLARE		@userPrefName	VARCHAR(MAX)
	DECLARE		@userPrefValue	VARCHAR(MAX)
	DECLARE		@modifiedBy		VARCHAR(MAX)
	DECLARE		@userGUID		VARCHAR(MAX)
	DECLARE		@x XML
	DECLARE		@isAdminPref	BIT
	SET @x = @i_input
		------------------- Check whether operation is performed by Admin or User --------------
	SET @isAdminPref = ISNULL((SELECT T.a.value('@isAdminPref','BIT')
			FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq') AS T(a) ),1)
		-- ----------- Operation for insert and update --------------
	if ( (SELECT T.a.value('@operationType','INT')
		FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq') AS T(a) ) = 1)
	BEGIN
		--------------------Perform Insert on DMAdminPref table --------------------
		DECLARE adminCursor CURSOR FAST_FORWARD FOR
		SELECT
			T.list.value('@viewId','VARCHAR(MAX)'),
			T.list.value('@userPrefName','VARCHAR(MAX)') ,
			T.list.value('@userPrefValue','VARCHAR(MAX)') ,
			T.list.value('@modifiedBy','VARCHAR(MAX)')
		FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq/adminPrefList') AS T(list)
		WHERE T.list.exist('./userGUIDs') <> 1
		OPEN adminCursor
		FETCH NEXT FROM adminCursor INTO @viewId ,@userPrefName,@userPrefValue,@modifiedBy
		WHILE @@FETCH_STATUS = 0
		BEGIN
		IF NOT EXISTS(SELECT Id FROM DMAdminPref WHERE ViewName = @viewId and
														PrefName = @userPrefName )
		BEGIN
			INSERT DMAdminPref (ViewName, PrefName,PrefValue,
				CreatedTime,CreatedBy,ModifiedTime,ModifiedBy)
			VALUES	(@viewId,@userPrefName,@userPrefValue,
				GETUTCDATE(),@modifiedBy,GETUTCDATE(),@modifiedBy)
		END
		ELSE
		BEGIN
			UPDATE DMAdminPref	SET
				PrefValue = @userPrefValue,
				ModifiedBy = @modifiedBy,
				ModifiedTime = GETUTCDATE()
			WHERE ViewName = @viewId and
				PrefName = @userPrefName
		END
		FETCH NEXT FROM adminCursor INTO @viewId ,@userPrefName,@userPrefValue,@modifiedBy
		END
		CLOSE adminCursor
		DEALLOCATE adminCursor
		---------------------Perform Insert on DMUserPref table (Special Preferences)------------------
		DECLARE userCursor CURSOR FAST_FORWARD FOR
		SELECT
			T.list.value('@viewId','VARCHAR(MAX)') AS viewId,
			T.list.value('@userPrefName','VARCHAR(MAX)') AS userPrefName,
			T.list.value('@userPrefValue','VARCHAR(MAX)') AS userPrefValue,
			T.list.value('@modifiedBy','VARCHAR(MAX)') AS modifiedBy,
			T1.userGuid.value('@val','VARCHAR(MAX)') AS userGUID
		FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq/adminPrefList') AS T(list)
			CROSS APPLY
			T.list.nodes('./userGUIDs') AS T1(userGuid)
		OPEN userCursor
		FETCH NEXT FROM userCursor INTO @viewId ,@userPrefName,@userPrefValue,@modifiedBy,@userGUID
		WHILE @@FETCH_STATUS = 0
		BEGIN
		IF NOT EXISTS(SELECT P_Id FROM DMUserPref U WHERE
				U.UserPrefName = @userPrefName AND	U.ViewId = @viewId AND
				U.UserGUID = @userGUID AND U.AdminFlag = @isAdminPref)
		BEGIN
			INSERT DMUserPref (UserPrefName,UserGUID,UserPrefValue,
				CreateTime,ViewId,AdminFlag,ModifiedBy)
			VALUES (@userPrefName,@userGUID,@userPrefValue,
				GETUTCDATE(),@viewId,@isAdminPref,@modifiedBy)
		END
		ELSE
		BEGIN
			UPDATE DMUserPref SET
				UserPrefValue = @userPrefValue,
				CreateTime = GETUTCDATE(),
				ModifiedBy = @modifiedBy,
				AdminFlag  = @isAdminPref
			WHERE UserPrefName = @userPrefName AND
				ViewId = @viewId AND
				UserGUID = @userGUID
		END
		FETCH NEXT FROM userCursor INTO @viewId ,@userPrefName,@userPrefValue,@modifiedBy,@userGUID
		END
		CLOSE userCursor
		DEALLOCATE userCursor
	END
		-- ----------- Perform Deletion Operation --------------
	ELSE
	BEGIN
		---------------- DELETE FROM DMAdminPref table ------------------------
		MERGE DMAdminPref AS A
		USING (
			SELECT T.list.value('@viewId','VARCHAR(MAX)'),
				T.list.value('@userPrefName','VARCHAR(MAX)')
			FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq/adminPrefList') AS T(list)
			WHERE T.list.exist('./userGUIDs') <> 1) AS TMP (ViewID,UserPrefName)
		ON ( A.ViewName = TMP.ViewID AND A.PrefName = TMP.UserPrefName )
		WHEN MATCHED THEN
			DELETE ;
		---------------- DELETE FROM DMUserPref table ------------------------
		MERGE DMUserPref AS U
		USING (
			SELECT	T.list.value('@viewId','VARCHAR(MAX)') AS viewId,
				T.list.value('@userPrefName','VARCHAR(MAX)') AS userPrefName,
				T1.userGuid.value('@val','VARCHAR(MAX)') AS userGUID
			FROM @x.nodes('/DM2ContentIndexing_GetAdminPrefOperReq/adminPrefList') AS T(list)
			CROSS APPLY
			T.list.nodes('./userGUIDs') AS T1(userGuid)) AS TMP (viewID,userPrefName,userGUID)
		ON ( U.UserPrefName = TMP.userPrefName AND U.ViewId = TMP.viewId AND U.UserGUID = TMP.userGUID AND U.AdminFlag = @isAdminPref)
		WHEN MATCHED THEN
			DELETE;
	END
END
IF(@isAdminPref = 1)
BEGIN
	SELECT PrefName,PrefValue,CreatedBy =
			CASE
				WHEN (SELECT TOP 1 UserName FROM DMUserSession WHERE UserGUID=CreatedBy) IS NOT NULL THEN
					(SELECT TOP 1 UserName FROM DMUserSession WHERE UserGUID=CreatedBy)
				ELSE 'N/A'
			END,
		CreatedTime, ModifiedBy =
			CASE
				WHEN (SELECT TOP 1 UserName from DMUserSession WHERE UserGUID=ModifiedBy) IS NOT NULL THEN
					(SELECT TOP 1 UserName from DMUserSession WHERE UserGUID=ModifiedBy)
				ELSE 'N/A'
			END,
		ModifiedTime,
		(SELECT TOP 1 ViewName FROM DMSearchView sv WHERE a.ViewName = sv.Id) AS ViewName
	FROM DMAdminPref a
	WHERE PrefName IN (SELECT DISTINCT FieldLabel FROM DMSearchCriteriaField WHERE GroupId = 9)
END
ELSE
BEGIN
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AdminPreferenceOperation')
	delete from GxQscripts where name = 'sp_dm2_AdminPreferenceOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AdminPreferenceOperation')
	delete from GXDBVersions where aliasname = 'sp_dm2_AdminPreferenceOperation'
GO

insert into GXDBVersions values(2, 'sp_dm2_AdminPreferenceOperation',  '00010008000000000000', 'sp_dm2_AdminPreferenceOperation', '00010008000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadItems.sp,v $ $Id: sp_dm2_GetDownloadItems.sp,v 1.4 2012/06/22 18:49:24 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDownloadItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadItems')
	drop procedure sp_dm2_GetDownloadItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadItems')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadItems'
GO
print '... Creating Procedure: sp_dm2_GetDownloadItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownloadItems
  @i_DownLoadSetID varchar(36) = '',
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_RestoreStatus int = -1,
  @i_OrderByClause nvarchar(max) = 'Description'
AS
  DECLARE @StartRN integer
  DECLARE @EndRN integer
  DECLARE @sqlCmd nvarchar(max)
SET NOCOUNT ON
  IF (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
  BEGIN
		SET @StartRN = 1
		SET @EndRN = -1
  END
  ELSE
  BEGIN
		SET @StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
		SET @EndRN = @i_NumPages * @i_ItemsOnPage + @StartRN - 1
  END
	IF object_id('tempdb.dbo.#tblGetAllDownLoadsItem') is not null
	DROP TABLE #tblGetAllDownLoadsItem
	IF object_id('tempdb.dbo.#tblGetDownLoadsItem') is not null
	DROP TABLE #tblGetDownLoadsItem
  create table #tblGetAllDownLoadsItem (rowId INT IDENTITY(1,1), DownLoadID VARCHAR(36))
  create table #tblGetDownLoadsItem (rowId INT, DownLoadID VARCHAR(36), TotalItemCount int, RestoredItemCount int)
	SET @sqlCmd = 'insert into #tblGetAllDownLoadsItem '
	SET @sqlCmd = @sqlCmd + 'select DownLoadID from DMDownload WITH (READUNCOMMITTED) '
	SET @sqlCmd = @sqlCmd + 'where (LEN(''' + @i_DownLoadSetID + ''') = 0 or DownLoadSetID = ''' + @i_DownLoadSetID + ''')'
	SET @sqlCmd = @sqlCmd + ' AND FileType IN (1,2) '
	SET @sqlCmd = @sqlCmd + 'order by ' + @i_OrderByClause
	exec sp_executesql @sqlCmd
	if @EndRN < 0 	select @EndRN = count(*) from #tblGetAllDownLoadsItem
	--select * from #tblGetAllDownLoadsItem
	INSERT INTO #tblGetDownLoadsItem(rowId, DownLoadID)
	SELECT rowId, DownLoadID
	FROM #tblGetAllDownLoadsItem
	WHERE rowId BETWEEN @StartRN AND @EndRN
	--select * from #tblGetDownLoadsItem
	UPDATE #tblGetDownLoadsItem
	SET TotalItemCount = ISNULL((SELECT COUNT(ResultSetId) FROM DMDownloadResultSet RS WITH (READUNCOMMITTED) WHERE RS.DownloadId = #tblGetDownLoadsItem.DownloadID), 0),
	RestoredItemCount = ISNULL((SELECT COUNT(ResultSetId) FROM DMDownloadResultSet RS WITH (READUNCOMMITTED) WHERE RS.DownloadId = #tblGetDownLoadsItem.DownloadID AND RS.Status = 100), 0)
	SELECT DL.*, t.TotalItemCount, t.RestoredItemCount
	FROM #tblGetDownLoadsItem as t
	JOIN DMDownload AS DL WITH (READUNCOMMITTED) on t.DownLoadID = DL.DownLoadID
	ORDER BY t.rowId
	DROP TABLE #tblGetAllDownLoadsItem
    DROP TABLE #tblGetDownLoadsItem
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadItems')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadItems',  '00010004000000000000', 'sp_dm2_GetDownloadItems', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadSetItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadSetItems.sp,v $ $Id: sp_dm2_GetDownloadSetItems.sp,v 1.4 2015/04/16 18:52:30 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDownloadSetItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadSetItems')
	drop procedure sp_dm2_GetDownloadSetItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadSetItems')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadSetItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadSetItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadSetItems'
GO
print '... Creating Procedure: sp_dm2_GetDownloadSetItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownloadSetItems
  @i_DownLoadID varchar(36) = '',
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_RestoreStatus int = -1,
  @i_OrderByClause nvarchar(max) = 'modifiedTime'
AS
  DECLARE @StartRN integer
  DECLARE @EndRN integer
  DECLARE @sqlCmd nvarchar(max)
SET NOCOUNT ON
  IF (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
  BEGIN
		SET @StartRN = 1
		SET @EndRN = -1
  END
  ELSE
  BEGIN
		SET @StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
		SET @EndRN = @i_NumPages * @i_ItemsOnPage + @StartRN - 1
  END
	IF object_id('tempdb.dbo.#tblGetAllDownLoadItem') is not null
	DROP TABLE #tblGetAllDownLoadItem
	IF object_id('tempdb.dbo.#tblGetDownLoadItem') is not null
	DROP TABLE #tblGetDownLoadItem
  create table #tblGetAllDownLoadItem (rowId INT IDENTITY(1,1), ResultSetID VARCHAR(36))
  create table #tblGetDownLoadItem (rowId INT, ResultSetID VARCHAR(36))
	IF(@i_RestoreStatus <> -1)
	BEGIN
		SET @sqlCmd = 'insert into #tblGetAllDownLoadItem '
		SET @sqlCmd = @sqlCmd + 'select a.ResultSetID '
		SET @sqlCmd = @sqlCmd + 'FROM DMDownloadResultSet a WITH (READUNCOMMITTED), '
		SET @sqlCmd = @sqlCmd + 'DMResultSet c WITH (READUNCOMMITTED) '
		SET @sqlCmd = @sqlCmd + 'where a.DownloadID = ''' + @i_DownLoadID + ''' '
		SET @sqlCmd = @sqlCmd + 'and a.ResultSetID = c.ResultSetID '
		SET @sqlCmd = @sqlCmd + 'and c.RestoreStatus = ' + @i_RestoreStatus
		SET @sqlCmd = @sqlCmd + 'order by c.' + @i_OrderByClause
	END
	ELSE
	BEGIN
		SET @sqlCmd = 'insert into #tblGetAllDownLoadItem '
		SET @sqlCmd = @sqlCmd + 'select a.ResultSetID '
		SET @sqlCmd = @sqlCmd + 'FROM DMDownloadResultSet a WITH (READUNCOMMITTED), '
		SET @sqlCmd = @sqlCmd + 'DMResultSet c WITH (READUNCOMMITTED) '
		SET @sqlCmd = @sqlCmd + 'where a.DownloadID = ''' + @i_DownLoadID + ''' '
		SET @sqlCmd = @sqlCmd + 'and a.ResultSetID = c.ResultSetID '
		SET @sqlCmd = @sqlCmd + 'order by c.' + @i_OrderByClause
	END
	--
	exec sp_executesql @sqlCmd
	--
	if @EndRN < 0 	select @EndRN = count(*) from #tblGetAllDownLoadItem
	--
	INSERT INTO #tblGetDownLoadItem
	SELECT rowId, ResultSetID
	FROM #tblGetAllDownLoadItem
	WHERE rowId BETWEEN @StartRN AND @EndRN
	--
	SELECT RS.documentID as documentID, RS.aFileID, RS.AppType, RS.aFileOffset, RS.CommCellNumber, RS.IndexGUID, DRS.FileName --, CI.ContainerID as ContainerID
	FROM #tblGetDownLoadItem as t, DMResultSet AS RS WITH (READUNCOMMITTED),
		DMDownloadResultSet AS DRS WITH (READUNCOMMITTED)
	WHERE
		t.ResultSetID = RS.ResultSetID
		AND t.ResultSetID = DRS.ResultSetID
		AND DRS.DownloadID = @i_DownLoadID
	ORDER BY t.rowId
	--
	DROP TABLE #tblGetAllDownLoadItem
    DROP TABLE #tblGetDownLoadItem
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadSetItems')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadSetItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadSetItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadSetItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadSetItems',  '00010004000000000000', 'sp_dm2_GetDownloadSetItems', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadItemsByStatus.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadItemsByStatus.sp,v $ $Id: sp_dm2_GetDownloadItemsByStatus.sp,v 1.6 2014/12/05 20:12:42 sbarman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDownloadItemsByStatus <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadItemsByStatus')
	drop procedure sp_dm2_GetDownloadItemsByStatus
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadItemsByStatus')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadItemsByStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadItemsByStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadItemsByStatus'
GO
print '... Creating Procedure: sp_dm2_GetDownloadItemsByStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownloadItemsByStatus
  @i_DownLoadID varchar(36) = '',
  @i_StartIndex int = 0,
  @i_ItemsOnPage int = 0,
  @i_DownloadStatus int = -1,
  @i_OrderByClause nvarchar(max) = 'modifiedTime DESC',
  @i_UserGUID varchar(36) = '',
  @o_TotalCount int output
AS
  DECLARE @StartRN integer
  DECLARE @EndRN integer
  DECLARE @sqlCmd nvarchar(max)
  DECLARE @sqlCmdCount nvarchar(max)
  DECLARE @sqlCmdCommon nvarchar(max)
  DECLARE @ContainerId varchar(36)
  DECLARE @ParmDefinition nvarchar(1000)
	SET NOCOUNT ON
	SELECT @ContainerId = ContainerID FROM DMDownload WHERE DownLoadID = @i_DownLoadID
	SELECT @sqlCmdCommon = '', @sqlCmd = '', @sqlCmdCount = ''
	IF @i_StartIndex <= 0 OR @i_ItemsOnPage <= 0
	BEGIN
		SET @StartRN = 1
		SET @i_ItemsOnPage = 50
	END
	ELSE
	BEGIN
		SET @StartRN = @i_StartIndex
	END
	SET @EndRN = @StartRN + @i_ItemsOnPage - 1
	PRINT '@i_ItemsOnPage = ' + CONVERT(VARCHAR,@i_ItemsOnPage) + ' , @StartRN = ' + CONVERT(VARCHAR, @StartRN)
	IF object_id('tempdb.dbo.#tblGetAllDownLoadItem') is not null
	DROP TABLE #tblGetAllDownLoadItem
	IF object_id('tempdb.dbo.#tblGetDownLoadItem') is not null
	DROP TABLE #tblGetDownLoadItem
  create table #tblGetAllDownLoadItem (rowId INT IDENTITY(1,1), ResultSetID VARCHAR(36))
  create table #tblGetDownLoadItem (rowId INT, ResultSetID VARCHAR(36))
	BEGIN
		SET @sqlCmd = 'insert into #tblGetAllDownLoadItem '
		SET @sqlCmd = @sqlCmd + 'select a.ResultSetID '
		SET @sqlCmdCommon = @sqlCmdCommon + 'FROM DMDownloadResultSet a WITH (READUNCOMMITTED)'
		SET @sqlCmdCommon = @sqlCmdCommon + 'INNER JOIN DMResultSet  WITH (READUNCOMMITTED) ON DMResultSet.ResultSetID = a.ResultSetID '
		SET @sqlCmdCommon = @sqlCmdCommon + 'where a.DownloadID = ''' + @i_DownLoadID + ''' '
		--
		-- IF @i_RestoreStatus = 100, meaning client is looking to find all items that are successfully written into archive(pst/nsf/cab)
		IF @i_DownloadStatus <> -1
		BEGIN
			IF @i_DownloadStatus = 101
			BEGIN
				SET @sqlCmdCommon = @sqlCmdCommon + 'and a.Status <> 100 '
			END
			ELSE
			BEGIN
				SET @sqlCmdCommon = @sqlCmdCommon + 'and a.Status = ' + CONVERT(varchar(10), @i_DownloadStatus) + ' ' --extra space at end is  must so that subsequent concatenation will be fine.
			END
		END
	END
	SET @sqlCmd = @sqlCmd + @sqlCmdCommon
	--Earlier there was no check and this can cause error if client program explicitely sends empty order by clause..
	IF ISNULL(@i_OrderByClause, '') <> ''
	BEGIN
		SET @sqlCmd = @sqlCmd + ' order by ' + @i_OrderByClause
	END
	ELSE
	BEGIN
		SET @sqlCmd = @sqlCmd + ' order by modifiedTime DESC '
	END
	--
	SET @ParmDefinition = N'@TotalCount INT OUTPUT '
	SET @sqlCmdCount = 'SELECT @TotalCount = COUNT(*) ' + @sqlCmdCommon
	--
	exec sp_executesql @sqlCmdCount, @ParmDefinition, @TotalCount = @o_TotalCount OUTPUT
	--
	PRINT @sqlCmd
	--
	exec sp_executesql @sqlCmd
	--
	if @EndRN < 0 	select @EndRN = count(*) from #tblGetAllDownLoadItem
	--
	INSERT INTO #tblGetDownLoadItem
	SELECT rowId, ResultSetID
	FROM #tblGetAllDownLoadItem
	WHERE rowId BETWEEN @StartRN AND @EndRN
	--select * from #tblGetDownLoadItem
	SELECT
		RS.ResultSetID as ResultSetID, DRS.FileName,
		dbo.fn_dm2_GetLastComment(@i_UserGUID, @ContainerId, RS.ResultSetID) AS Comment,
		RS.RestoreStatus, D.ContainerID, RS.ClientID, D.CreateTime,
		RS.aFileID, RS.aFileOffset, RS.CommCellNumber, RS.IndexGUID, RS.documentID, RS.Title,
		RS.FolderPath, RS.OriginalFullPath, dbo.GetUnixTime(RS.ModifiedTime) as ModifiedTime,
		dbo.GetUnixTime(RS.CreateTime) as ItemAddedTime
	FROM #tblGetDownLoadItem as t
	INNER JOIN
		DMResultSet AS RS WITH (READUNCOMMITTED)
	ON
		t.ResultSetID = RS.ResultSetID
	INNER JOIN
		DMDownloadResultSet AS DRS WITH (READUNCOMMITTED)
	ON
		t.ResultSetID = DRS.ResultSetID
	INNER JOIN
		DMDownload D
	ON
		D.DownLoadID = DRS.DownloadID
	WHERE
		DRS.DownloadID = @i_DownLoadID
	ORDER BY
		t.rowId
	DROP TABLE #tblGetAllDownLoadItem
    DROP TABLE #tblGetDownLoadItem
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadItemsByStatus')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadItemsByStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadItemsByStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadItemsByStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadItemsByStatus',  '00010006000000000000', 'sp_dm2_GetDownloadItemsByStatus', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadSetItemsCount.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadSetItemsCount.sp,v $ $Id: sp_dm2_GetDownloadSetItemsCount.sp,v 1.1 2009/08/19 22:10:48 sabdulrahman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDownloadSetItemsCount <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadSetItemsCount')
	drop procedure sp_dm2_GetDownloadSetItemsCount
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadSetItemsCount')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadSetItemsCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadSetItemsCount')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadSetItemsCount'
GO
print '... Creating Procedure: sp_dm2_GetDownloadSetItemsCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownloadSetItemsCount
  @i_DownLoadID varchar(36) = '',
  @i_Status int = -1
AS
SET NOCOUNT ON
	if (@i_Status <> -1)
		select count(a.ResultSetID)
		from DMDownloadResultSet a WITH (READUNCOMMITTED), DMResultSet c WITH (READUNCOMMITTED)
		where a.DownloadID = @i_DownloadID
		and a.ResultSetID = c.ResultSetID
		and a.Status = @i_Status
	else
		select count(a.ResultSetID)
		from DMDownloadResultSet a WITH (READUNCOMMITTED), DMResultSet c WITH (READUNCOMMITTED)
		where a.DownloadID = @i_DownloadID
		and a.ResultSetID = c.ResultSetID
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadSetItemsCount')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadSetItemsCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadSetItemsCount')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadSetItemsCount'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadSetItemsCount',  '00010001000000000000', 'sp_dm2_GetDownloadSetItemsCount', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetAllUserSession.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetAllUserSession.sp,v $ $Id: sp_dm2_GetAllUserSession.sp,v 1.2 2009/10/09 07:21:32 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetAllUserSession <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetAllUserSession')
	drop procedure sp_dm2_GetAllUserSession
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetAllUserSession')
	delete from GxQscripts where name = 'sp_dm2_GetAllUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAllUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAllUserSession'
GO
print '... Creating Procedure: sp_dm2_GetAllUserSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetAllUserSession
  @i_Offset integer = 0,
  @i_Limit integer = 10,  
  @i_OrderByClause nvarchar(max) = 'UserName',
  @o_Count bigint OUTPUT
AS
	SET NOCOUNT ON
	DECLARE @stNo INTEGER = 1
	DECLARE @endNo INTEGER = -1
	DECLARE @sqlStmt NVARCHAR(MAX)
	IF(@i_Offset+@i_Limit <= 0)
	BEGIN
		set @stNo = 1
		set @endNo = -1
	END
	ELSE
	BEGIN
		set @stNo = @i_Offset + 1
		set @endNo = (@i_Offset + @i_Limit)
	END
	IF object_id('tempdb.dbo.#tblAllResults') is not null
		DROP TABLE #tblAllResults
	CREATE table #tblAllResults (cnt int identity(1,1),UserGUID varchar(36),UserName varchar(max),
								LastModifiedTime DateTime,IpAddress varchar(max));
	set @sqlStmt = 'insert into #tblAllResults(UserGUID,UserName,LastModifiedTime,IpAddress)
		select 	UserGUID,
				UserName,
				CreateTime as LastModifiedTime,
				IP as IpAddress
		from DMUserSession
		where  CreateTime in (select MAX(CreateTime) from DMUserSession group by UserGUID)
		Order By ' + @i_OrderByClause;
	exec sp_executesql @sqlStmt
	If @endNo <=0
		select @endNo = COUNT(*) from #tblAllResults
	select @o_Count = COUNT(*) from #tblAllResults
	set @o_Count =	@o_Count
	select UserGUID,
		UserName,
		LastModifiedTime,
		IpAddress from #tblAllResults where Cnt between @stNo and @endNo
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetAllUserSession')
	delete from GxQscripts where name = 'sp_dm2_GetAllUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAllUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAllUserSession'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetAllUserSession',  '00010002000000000000', 'sp_dm2_GetAllUserSession', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateEntryIdBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateEntryIdBulk()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateEntryIdBulk.sp,v $ $Id: sp_dm2_UpdateEntryIdBulk.sp,v 1.4 2012/08/06 15:32:09 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateEntryIdBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateEntryIdBulk')
	drop procedure sp_dm2_UpdateEntryIdBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateEntryIdBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateEntryIdBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateEntryIdBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateEntryIdBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateEntryIdBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateEntryIdBulk
  @s_downLoadid varchar(36),
  @i_xml_AFOffsets XML
AS
BEGIN
-- expects a list like
-- <restlist>
--    <file CCId="2" AFId="2" AFOff="27" DPath="/blabla" />
--    <file CCId="2" AFId="4" AFOff="37" />
--    <file CCId="2" AFId="6" AFOff="909" />
-- </restlist>
	DECLARE @lt_AFOffsets TABLE (CCId int, AFId bigint, AFOff bigInt, DestPath nvarchar(max), status int)
	INSERT INTO @lt_AFOffsets
	SELECT T.c.value('@CCId','int'),
		   T.c.value('@AFId', 'bigint'),
		   T.c.value('@AFOff', 'bigint'),
		   T.c.value('@DPath', 'nvarchar(max)'),
		   ISNULL(T.c.value('@status', 'int'), 0) -- ERMStatus for success
	FROM   @i_xml_AFOffsets.nodes('/restlist/file') T(c)
		UPDATE DMDownloadResultSet
		SET FileName = tt.DestPath, Status = (CASE ISNULL(tt.DestPath,'') WHEN '' THEN 500 ELSE 100 END)
	FROM @lt_AFOffsets tt, DMDownloadResultSet dr, DMResultSet rr WITH (NOLOCK)
		WHERE
		dr.DownloadID = @s_downLoadId and dr.ResultSetID = rr.ResultSetID and
		rr.aFileID = tt.AFId  and rr.aFileoffset = tt.AFOff
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateEntryIdBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateEntryIdBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateEntryIdBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateEntryIdBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateEntryIdBulk',  '00010004000000000000', 'sp_dm2_UpdateEntryIdBulk', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddContainerView.sp] ---------- 

-- ALLOW COMMENTS BELOW HERE
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddContainerView.sp,v $ $Id: sp_dm2_AddContainerView.sp,v 1.3 2012/04/02 07:28:51 pbuilder Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddContainerView <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddContainerView')
	drop procedure sp_dm2_AddContainerView
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddContainerView')
	delete from GxQscripts where name = 'sp_dm2_AddContainerView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddContainerView')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddContainerView'
GO
print '... Creating Procedure: sp_dm2_AddContainerView'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddContainerView
  @i_ViewName varchar(128),
  @i_ContainerType integer,
  @i_UserGUID char(36),
  @o_RequestId char(36) output
AS
  DECLARE @exCount INT
	SELECT @exCount = COUNT(RequestId) FROM DMContainerView WHERE Name = @i_ViewName AND UserGUID = @i_UserGUID
	IF ISNULL(@exCount, 0) > 0
	BEGIN
		SET @o_RequestId = '4600' -- Error code for view already exists.
	END
	ELSE
	BEGIN
	SET @o_RequestId = NEWID()
	INSERT INTO DMContainerView (RequestId, Name, UserGUID, ContainerType, CreateTime, Attribute)
	SELECT @o_RequestId as RequestId, @i_ViewName as Name, @i_UserGUID as UserGUID, @i_ContainerType as ContainerType,
	GETDATE() as CreateTime, 0 as Attribute
		IF @@ERROR > 0
			SET @o_RequestId = '4601' -- Error code for general error while adding/inserting view.
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddContainerView')
	delete from GxQscripts where name = 'sp_dm2_AddContainerView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddContainerView')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddContainerView'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddContainerView',  '00010003000000000000', 'sp_dm2_AddContainerView', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetContainerViews.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetContainerViews.sp,v $ $Id: sp_dm2_GetContainerViews.sp,v 1.1 2009/11/09 08:38:46 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetContainerViews <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetContainerViews')
	drop procedure sp_dm2_GetContainerViews
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetContainerViews')
	delete from GxQscripts where name = 'sp_dm2_GetContainerViews'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetContainerViews')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetContainerViews'
GO
print '... Creating Procedure: sp_dm2_GetContainerViews'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetContainerViews
  @i_UserGUID char(36), 
  @i_TableOutput INT = 0
AS
	DECLARE @i_xmlText XML
	IF @i_TableOutput = 0
	BEGIN
		SELECT @i_xmlText = (SELECT
		(SELECT ROW_NUMBER() OVER (ORDER BY CreateTime ASC) '@containerId', RequestId '@containerGuid', [Name] '@containerName',
		ContainerType '@containerType', Attribute '@attribute', '' '@comment', 1 as '@containerOwnerType'
		FROM DMContainerView
		WHERE UserGUID = @i_UserGUID
		FOR XML PATH('containers'), TYPE)
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GetContainersResp'))
		SELECT @i_xmlText AS ContainerViews
	END
	ELSE
	BEGIN
		SELECT ROW_NUMBER() OVER (ORDER BY CreateTime ASC) as containerId, RequestId as containerGuid, [Name] AS containerName,
		ContainerType as containerType, Attribute as attribute, '' as comment, 1 as containerOwnerType
		FROM DMContainerView
		WHERE UserGUID = @i_UserGUID
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetContainerViews')
	delete from GxQscripts where name = 'sp_dm2_GetContainerViews'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetContainerViews')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetContainerViews'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetContainerViews',  '00010001000000000000', 'sp_dm2_GetContainerViews', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_ExecuteSql.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_ExecuteSql.sp,v $ $Id: sp_dm2_ExecuteSql.sp,v 1.3 2009/11/21 04:55:47 cvsuser Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_ExecuteSql <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_ExecuteSql')
	drop procedure sp_dm2_ExecuteSql
IF EXISTS (select * from GxQscripts where name='sp_dm2_ExecuteSql')
	delete from GxQscripts where name = 'sp_dm2_ExecuteSql'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ExecuteSql')
	delete from GXDBVersions where aliasname = 'sp_dm2_ExecuteSql'
GO
print '... Creating Procedure: sp_dm2_ExecuteSql'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_ExecuteSql
  @i_Sql varchar(max), 
  @i_ExpectedRowCount int, 
  @i_RollBackOnError bit,
  @i_PreSql varchar(max)
AS
	BEGIN TRANSACTION
	IF LTRIM(RTRIM(@i_PreSql)) <> ''
		EXECUTE (@i_PreSql)
	IF @@ERROR > 0 AND @i_RollBackOnError = 1
	BEGIN
		ROLLBACK TRANSACTION
	END
	ELSE
	BEGIN
		declare @UpdatedRowCount int
		EXECUTE (@i_Sql)
		SET @UpdatedRowCount = @@ROWCOUNT
		IF @i_RollBackOnError = 1
		BEGIN
			if @UpdatedRowCount <> @i_ExpectedRowCount
				ROLLBACK TRANSACTION
			ELSE
				COMMIT TRANSACTION
		END
		ELSE
			COMMIT TRANSACTION
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_ExecuteSql')
	delete from GxQscripts where name = 'sp_dm2_ExecuteSql'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ExecuteSql')
	delete from GXDBVersions where aliasname = 'sp_dm2_ExecuteSql'
GO

insert into GXDBVersions values(2, 'sp_dm2_ExecuteSql',  '00010003000000000000', 'sp_dm2_ExecuteSql', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateERMStatusBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateERMStatusBulk.sp,v $ $Id: sp_dm2_UpdateERMStatusBulk.sp,v 1.1 2009/12/22 16:51:11 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateERMStatusBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateERMStatusBulk')
	drop procedure sp_dm2_UpdateERMStatusBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateERMStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateERMStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateERMStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateERMStatusBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateERMStatusBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateERMStatusBulk
  @i_DataFilePath varchar(1024) = ''
AS
SET NOCOUNT ON
		declare @l_delimiter	varchar(256)
		declare @SQL	varchar(2048)
		set @l_delimiter = ISNULL((select SettingValue from DMSetting WITH (READUNCOMMITTED) where settingName = 'DMBulkInsert_Delim'), '')
		IF(len(@l_delimiter ) = 0)
			SET @l_delimiter = 'CV0X12'
		if object_id('tempdb.dbo.#tmpDMResultSet') is not null
			DROP TABLE #tmpDMResultSet
		create table #tmpDMResultSet
		(
			tResultSet char(36) NOT NULL,
			tERMStatus	int NOT NULL,
		)
		IF(len(@i_DataFilePath ) > 0)
		BEGIN
			SET @SQL = 'BULK INSERT #tmpDMResultSet FROM '''+@i_DataFilePath+''' WITH (FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
			exec (@SQL)
			UPDATE DMResultSet
			SET ERMStatus = T.tERMStatus
			FROM #tmpDMResultSet AS T, DMResultSet AS DMR
				WHERE T.tResultSet = DMR.ResultSetID
		END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateERMStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateERMStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateERMStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateERMStatusBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateERMStatusBulk',  '00010001000000000000', 'sp_dm2_UpdateERMStatusBulk', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateFilesEntryIdBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateFilesEntryIdBulk()
--  | Description:  Update the File Entryid Mails in bulk
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateFilesEntryIdBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateFilesEntryIdBulk')
	drop procedure sp_dm2_UpdateFilesEntryIdBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateFilesEntryIdBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateFilesEntryIdBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateFilesEntryIdBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateFilesEntryIdBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateFilesEntryIdBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateFilesEntryIdBulk
  @restorejobid varchar(36),
  @i_xml_AFOffsets XML,
  @i_isUnixUpdate INTEGER = 0
AS
BEGIN
-- expects a list like
-- <restlist>
--    <file CCId="2" AFId="2" AFOff="27" DPath="/blabla" />
--    <file CCId="2" AFId="4" AFOff="37" />
--    <file CCId="2" AFId="6" AFOff="909" />
-- </restlist>
	declare @s_downLoadid varchar(36)
	DECLARE @lt_AFFiles TABLE (ID int IDENTITY(1,1) ,CCId int, AFId bigint, OrigPath nvarchar(max), DestPath nvarchar(max), status int,ResultItemID char(36))
	DECLARE @SettingVal VARCHAR(MAX) = ''
	DECLARE @CcnCheckEnabled BIT = 0
	select @s_downLoadId = DownLoadID from DMDownload where RestoreJobID = @restorejobid
	SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_CCN_CHECK_IN_RESTORE'
	IF ISNULL(@SettingVal, '') = 'True'
		SET @CcnCheckEnabled = 1
	INSERT INTO @lt_AFFiles (CCId,AFId,OrigPath,DestPath,status)
	SELECT T.c.value('@CCId','int'),
		   T.c.value('@AFId', 'bigint'),
		   T.c.value('@OPath', 'nvarchar(max)'),
		   T.c.value('@DPath', 'nvarchar(max)'),
		   ISNULL(T.c.value('@status', 'int'), 0) -- ERMStatus for success
	FROM   @i_xml_AFOffsets.nodes('/restlist/file') T(c)
	--update resultsetid in temptable
	IF( @i_isUnixUpdate = 1)
	BEGIN
		UPDATE @lt_AFFiles
		SET ResultItemID = ResultSetID
		FROM DMResultSet WITH(NOLOCK)
		WHERE aFileID = AFId AND OriginalFullPath COLLATE Latin1_General_CS_AS = OrigPath AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
	END
	ELSE
	BEGIN
		UPDATE @lt_AFFiles
		SET ResultItemID = ResultSetID
		FROM DMResultSet WITH(NOLOCK)
		WHERE aFileID = AFId AND OriginalFullPath = OrigPath AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
	END
	--Case when we couldn find any matching resultSet,  then we check this flag for Lotus nous
	IF EXISTS(SELECT * FROM @lt_AFFiles as tt WHERE LEN(ISNULL(tt.ResultItemID,'')) = 0)
	BEGIN
		/*
			Issue:
					if an email has multiple attachments during backup and few of them are filtered during CI,
				then the attachment number present in the path for each attachment within its documentID, mismatches and does not follow their sequence of number.
			Fix:
					During restore update, we try to convert the db path to match with original email which doesnt have attachment number,
				there by path would match the input index path.
		*/
		DECLARE @enableLNPartialCheck BIT =
				CASE WHEN ISNULL((SELECT SettingValue FROM DMSetting
							WHERE SettingName = 'ENABLE_LN_PATH_PARTIAL_MATCH'),'false') = 'true'	--default disabled
					THEN 1 ELSE 0 END
		IF(@enableLNPartialCheck = 1)
		BEGIN
			UPDATE tt
			SET tt.OrigPath = (CASE WHEN PATINDEX('%S:_:%',tt.OrigPath) = 0  THEN tt.OrigPath
								ELSE SUBSTRING(tt.OrigPath,1,(PATINDEX('%S:_:%',tt.OrigPath)))END)
			FROM @lt_AFFiles as tt
			WHERE LEN(ISNULL(tt.ResultItemID,'')) = 0
			--Since all mails and attachement have same path, delete duplicate
			DELETE FROM @lt_AFFiles
			WHERE ID NOT IN(
				SELECT MAX(ID)
				FROM @lt_AFFiles AS tt
				GROUP BY tt.AFId,tt.OrigPath
			)
			--For LN, compare origPath by stripping attachment.
			UPDATE tt
				SET ResultItemID = RS.ResultSetID
				FROM @lt_AFFiles as tt inner join  DMResultSet AS RS WITH(NOLOCK)
				ON tt.AFId = RS.aFileID  AND
					tt.OrigPath =
					(CASE WHEN PATINDEX('%S:_:%',RS.OriginalFullPath) = 0  THEN RS.OriginalFullPath
						ELSE SUBSTRING(RS.OriginalFullPath,1,(PATINDEX('%S:_:%',RS.OriginalFullPath)))END)
				WHERE LEN(ISNULL(tt.ResultItemID,'')) = 0 AND RS.AppType IN (52, 90)	--only FOR LN
		END
	END
	UPDATE DMDownloadResultSet
	SET FileName = tt.DestPath, Status = (CASE ISNULL(tt.DestPath,'') WHEN '' THEN dr.Status ELSE 100 END)
	FROM @lt_AFFiles tt INNER JOIN DMDownloadResultSet dr WITH (NOLOCK)
	ON	dr.DownloadID = @s_downLoadId and dr.ResultSetID = tt.ResultItemID
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateFilesEntryIdBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateFilesEntryIdBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateFilesEntryIdBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateFilesEntryIdBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateFilesEntryIdBulk',  '00000000000000000000', 'sp_dm2_UpdateFilesEntryIdBulk', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_ReviewSetSummary.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_ReviewSetSummary.sp,v $ $Id: sp_dm2_ReviewSetSummary.sp,v 1.6 2014/08/25 21:24:11 sbarman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_ReviewSetSummary <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_ReviewSetSummary')
	drop procedure sp_dm2_ReviewSetSummary
IF EXISTS (select * from GxQscripts where name='sp_dm2_ReviewSetSummary')
	delete from GxQscripts where name = 'sp_dm2_ReviewSetSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ReviewSetSummary')
	delete from GXDBVersions where aliasname = 'sp_dm2_ReviewSetSummary'
GO
print '... Creating Procedure: sp_dm2_ReviewSetSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_ReviewSetSummary
  @i_ContainerID char(36),
  @i_computeRestoreOnly int = 0
AS
SET NOCOUNT ON
	DECLARE @totalSize BIGINT = 0
	DECLARE @totalFileSize BIGINT = 0
	DECLARE @totalEmailSize BIGINT = 0
	DECLARE @totalFiles INT = 0
	DECLARE @totalEmails INT = 0
	DECLARE @totalItems INT = 0
	--
	if @i_computeRestoreOnly = 0
	begin
		--Get the file details
		SELECT @totalEmailSize = ISNULL(SUM(FileSizeKB),0),@totalEmails =ISNULL(COUNT(*),0) FROM DMResultSet WITH (NOLOCK) WHERE ResultSetID IN
			(SELECT DISTINCT ResultSetID FROM DMContainerItem WITH (NOLOCK) WHERE ContainerID = @i_ContainerID AND
				(Attribute & 4)= 0 AND
			AppType IN (SELECT AppTypeId FROM DMUIAppTypeMap WITH (NOLOCK) WHERE IsFileAppType = 0))
	end
	if @i_computeRestoreOnly = 0
	begin
		SELECT @totalFileSize = ISNULL(SUM(FileSizeKB),0),@totalFiles = ISNULL(COUNT(*),0) FROM DMResultSet WITH (NOLOCK) WHERE ResultSetID IN
			(SELECT DISTINCT ResultSetID FROM DMContainerItem WITH (NOLOCK) WHERE ContainerID = @i_ContainerID AND
			(Attribute & 4)= 0 AND
			AppType IN (SELECT AppTypeId FROM DMUIAppTypeMap WITH (NOLOCK) WHERE IsFileAppType = 1))
	end
	SET @totalItems = @totalEmails + @totalFiles
	SET @totalSize = @totalEmailSize + @totalFileSize
	SELECT
		@totalItems AS 'TotalItems',
		@totalSize AS 'TotalSize',
		@totalEmails AS 'TotalEmails',
		@totalEmailSize AS 'TotalEmailSize',
		@totalFiles AS 'TotalFiles',
		@totalFileSize AS 'TotalFileSize',
	[0] as [Not_Submitted],
	[1] as [Submitted_for_viewing],
	[4] as [Restore_completed],
	[5]+[7] as [Restore_Failed]
	FROM
	(
	SELECT RestoreStatus from DMResultSet  WITH (NOLOCK)
	WHERE ResultSetID IN (SELECT DISTINCT ResultSetID From DMContainerItem WITH (NOLOCK) WHERE ContainerID = @i_ContainerID)
	) AS RC
	PIVOT
	(
	COUNT(RestoreStatus)
	FOR
	RestoreStatus
	IN ( [0], [1], [4], [5], [7])
	) AS PVT
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_ReviewSetSummary')
	delete from GxQscripts where name = 'sp_dm2_ReviewSetSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ReviewSetSummary')
	delete from GXDBVersions where aliasname = 'sp_dm2_ReviewSetSummary'
GO

insert into GXDBVersions values(2, 'sp_dm2_ReviewSetSummary',  '00010006000000000000', 'sp_dm2_ReviewSetSummary', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDMContainerExport.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateDMContainerExport.sp,v $ $Id: sp_dm2_UpdateDMContainerExport.sp,v 1.1 2010/02/05 12:56:35 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateDMContainerExport <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateDMContainerExport')
	drop procedure sp_dm2_UpdateDMContainerExport
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateDMContainerExport')
	delete from GxQscripts where name = 'sp_dm2_UpdateDMContainerExport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDMContainerExport')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDMContainerExport'
GO
print '... Creating Procedure: sp_dm2_UpdateDMContainerExport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateDMContainerExport
  @i_ExportId CHAR(36),
  @i_ContainerID char(36) = '',
  @i_DestPath VARCHAR(MAX) = '',
  @i_CreateTime DATETIME = '',
  @i_ExportStatus VARCHAR(1024)
AS
SET NOCOUNT ON
	IF(@i_ExportId is not null AND LEN(@i_ExportId) > 0)
	BEGIN
		IF( EXISTS(SELECT * FROM DMContainerExport WHERE ExportId = @i_ExportId))
		BEGIN
			UPDATE DMContainerExport
			SET
				ExportStatus = @i_ExportStatus
			WHERE ExportId = @i_ExportId
			UPDATE DMContainerExport
			SET
				DestPath = @i_DestPath
			WHERE ExportId = @i_ExportId and
				(LEN(@i_DestPath)>0 AND @i_DestPath <> DestPath)
		END
		ELSE
		BEGIN
			IF(@i_ContainerID is not null AND LEN(@i_ContainerID) > 0)
			BEGIN
				IF(@i_CreateTime is null or @i_CreateTime = '')
					SET @i_CreateTime = GETDATE()
				INSERT INTO
				DMContainerExport (ExportId,ContainerID,DestPath,CreateTime,ExportStatus)
				VALUES		  (@i_ExportId,@i_ContainerID,@i_DestPath,@i_CreateTime,@i_ExportStatus)
			END
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateDMContainerExport')
	delete from GxQscripts where name = 'sp_dm2_UpdateDMContainerExport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateDMContainerExport')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateDMContainerExport'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateDMContainerExport',  '00010001000000000000', 'sp_dm2_UpdateDMContainerExport', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemNotInAnyContainer.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemNotInAnyContainer.sp,v $ $Id: sp_dm2_GetResultItemNotInAnyContainer.sp,v 1.1 2010/04/08 13:06:27 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultItemNotInAnyContainer <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultItemNotInAnyContainer')
	drop procedure sp_dm2_GetResultItemNotInAnyContainer
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultItemNotInAnyContainer')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemNotInAnyContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemNotInAnyContainer')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemNotInAnyContainer'
GO
print '... Creating Procedure: sp_dm2_GetResultItemNotInAnyContainer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultItemNotInAnyContainer
  @i_Xml XML = '',
  @i_ReviewSetList VARCHAR(MAX) = ''
AS
SET NOCOUNT ON
	-- i_Xml structute
	 --	<GItems>
	 --      <GItem>
	 --          <GUID> XXXXXXX </GUID>
	 --          <aFileId> XXXXXXX <aFileId>
	 --          <aFileOffset> XXXXXXX <aFileOffset>
	 --          <commCellNumber> XXXXXXX <commCellNumber>
	 --      </GItem>
	 --  </GItems>
	--Create a temp table
	CREATE TABLE #tmpResultItem
	(
		newGUID NVARCHAR(MAX),
		aFileId BIGINT,
		aFileOffset BIGINT,
		commCellNumber INT
	)
	INSERT #tmpResultItem
	SELECT
		T.item.value('GUID[1]','NVARCHAR(MAX)') AS newGUID,
		T.item.value('aFileId[1]','BIGINT') AS aFileId,
		T.item.value('aFileOffset[1]','BIGINT') AS aFileOffset,
		T.item.value('commCellNumber[1]','INT')	AS commCellNumber
	from @i_Xml.nodes('/GItems/GItem') T(item)
	DECLARE @isDebug int = 0
	IF(@isDebug = 1)
	BEGIN
		SELECT * FROM #tmpResultItem
		SELECT ID FROM dbo.splitStringToTable(@i_ReviewSetList)
	END
	--Delete from #tmpResultItem table which matches the fileId,Fileoffset and commcellNumber in DMResultSet
	-- And ContainerId in DMCOntainerItem Exists in @i_ReviewSetList
	DELETE #tmpResultItem
	FROM #tmpResultItem A, DMContainerItem B, DMResultSet C
	WHERE
		A.aFileId	= C.aFileID AND
		A.aFileOffset = C.aFileOffset AND
		A.commCellNumber = C.CommCellNumber AND
		C.ResultSetID = B.ResultSetID AND
		B.ContainerID in (SELECT ID FROM dbo.splitStringToTable(@i_ReviewSetList))
	--Return only the GUID
	SELECT newGUID FROM #tmpResultItem
	DROP TABLE #tmpResultItem
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultItemNotInAnyContainer')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemNotInAnyContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemNotInAnyContainer')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemNotInAnyContainer'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultItemNotInAnyContainer',  '00010001000000000000', 'sp_dm2_GetResultItemNotInAnyContainer', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_MigrateResultXmlsTo90.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_MigrateResultXmlsTo90()
--  | Description:  Update the XMLs in DMResultSetInfo table and DMLegalHoldItemsToBackup to 9.0 desired format.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_MigrateResultXmlsTo90.sp,v $ $Id: sp_dm2_MigrateResultXmlsTo90.sp,v 1.7 2010/08/13 13:23:54 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_MigrateResultXmlsTo90 <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_MigrateResultXmlsTo90')
	drop procedure sp_dm2_MigrateResultXmlsTo90
IF EXISTS (select * from GxQscripts where name='sp_dm2_MigrateResultXmlsTo90')
	delete from GxQscripts where name = 'sp_dm2_MigrateResultXmlsTo90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MigrateResultXmlsTo90')
	delete from GXDBVersions where aliasname = 'sp_dm2_MigrateResultXmlsTo90'
GO
print '... Creating Procedure: sp_dm2_MigrateResultXmlsTo90'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_MigrateResultXmlsTo90
AS
BEGIN
DECLARE @error 			int
DECLARE @startRN 		int
DECLARE @endRN 			int
DECLARE @totalRows	int
SET @error = 0
--BEGIN TRAN
IF OBJECT_ID('tempdb.dbo.#tblGetResultSetID') IS NOT NULL DROP TABLE #tblGetResultSetID
CREATE TABLE #tblGetResultSetID (rowId INT IDENTITY(1,1), ResultSetID VARCHAR(36))
IF EXISTS(
	SELECT * FROM DMLegalHoldItemsToBackup
	WHERE ISNULL(METADATAXML, '') <> '' AND CONVERT(XML, METADATAXML).exist('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') = 0
)
BEGIN
	UPDATE DMLegalHoldItemsToBackup
	SET MetaDataXML = dbo.ConvertLegalHoldMetaDataXMLTo900XMLManaged(MetaDataXML)
	WHERE MetaDataXML IS NOT NULL
	AND	  LEN(MetaDataXML) > 0
	SET @error = @@ERROR
	PRINT 'DMLegalHoldItemsToBackup Updated Successfully'
END
IF @error > 0
BEGIN
	PRINT 'Error occurred updating DMLegalHoldItemsToBackup'
	GOTO ErrorL
END
INSERT INTO #tblGetResultSetID
SELECT resultSetID
FROM DMResultSetInfo WITH (NOLOCK)
SET @error = @@ERROR
IF @error > 0	GOTO ErrorL
SET @startRN = 1
SET @endRN = 2000
SELECT @totalRows = COUNT(*) FROM #tblGetResultSetID
WHILE (1 = 1)
BEGIN
	UPDATE DMResultSetInfo
	SET ResultSet = dbo.fn_dm2_GetLatestResultSetXML(RSI.ResultSetID, RSI.ResultSet)
	FROM DMResultSetInfo RSI, #tblGetResultSetID TMP
	WHERE RSI.resultSetID = TMP.resultSetID
	AND TMP.rowId >= @startRN
	AND TMP.rowId <= @endRN
	SET @error = @@ERROR
	IF @error > 0
	BEGIN
		PRINT 'Error occurred updating DMResultSetInfo'
		GOTO ErrorL
	END
	IF @endRN >= @totalRows
		BREAK
	SET @startRN = @endRN + 1
	SET @endRN = @endRN + 2000
END
IF @error = 0
BEGIN
	PRINT 'Successfully processed Result XML Blobs'
END
ELSE
BEGIN
	PRINT 'Errors in processing Result XML Blobs'
	GOTO ErrorL
END
ErrorL:
	if @error > 0
	BEGIN
		--ROLLBACK TRAN
		print 'Exited with errors'
	END
	else
	BEGIN
		--COMMIT TRAN
		print 'Exited Successfully'
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_MigrateResultXmlsTo90')
	delete from GxQscripts where name = 'sp_dm2_MigrateResultXmlsTo90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MigrateResultXmlsTo90')
	delete from GXDBVersions where aliasname = 'sp_dm2_MigrateResultXmlsTo90'
GO

insert into GXDBVersions values(2, 'sp_dm2_MigrateResultXmlsTo90',  '00010007000000000000', 'sp_dm2_MigrateResultXmlsTo90', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_CreateCLRFunctions.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_CreateCLRFunctions.sp,v $ $Id: sp_dm2_CreateCLRFunctions.sp,v 1.14 2015/04/22 19:15:00 mdilshad Exp $";
--  +===============================================================================+
--  | Stored Proc:  sp_dm2_CreateCLRFunctions()
--  |
--  | Description:  Create CLR functions and stored procedures
--  +===============================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_CreateCLRFunctions <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_CreateCLRFunctions')
	drop procedure sp_dm2_CreateCLRFunctions
IF EXISTS (select * from GxQscripts where name='sp_dm2_CreateCLRFunctions')
	delete from GxQscripts where name = 'sp_dm2_CreateCLRFunctions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_CreateCLRFunctions')
	delete from GXDBVersions where aliasname = 'sp_dm2_CreateCLRFunctions'
GO
print '... Creating Procedure: sp_dm2_CreateCLRFunctions'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sp_dm2_CreateCLRFunctions
  @i_DLLPath NVARCHAR(MAX)
AS
  DECLARE @o_retVal INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @sqlQuery 			NVARCHAR(MAX)
	DECLARE @DLLPathUtils		NVARCHAR(MAX)
	DECLARE @DLLPathLogger 	NVARCHAR(MAX)
	DECLARE @DLLPathXMLMsg	NVARCHAR(MAX)
	SET @sqlQuery = 'USE MASTER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'IF EXISTS (SELECT name FROM syslogins WHERE name = ''CVDM2DBCLRLogin'') ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '  DROP LOGIN CVDM2DBCLRLogin ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'IF EXISTS (SELECT name FROM sys.asymmetric_keys WHERE name = ''CVDM2DBCLRKey'') ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'DROP ASYMMETRIC KEY CVDM2DBCLRKey ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'IF EXISTS (SELECT name FROM syslogins WHERE name = ''CVManagedLoggerLogin'') ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '  DROP LOGIN CVManagedLoggerLogin ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'IF EXISTS (SELECT name FROM sys.asymmetric_keys WHERE name = ''CVManagedLoggerKey'') ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'DROP ASYMMETRIC KEY CVManagedLoggerKey ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'IF EXISTS (SELECT name FROM syslogins WHERE name = ''CVDM2XMLMsgLogin'') ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '  DROP LOGIN CVDM2XMLMsgLogin ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'IF EXISTS (SELECT name FROM sys.asymmetric_keys WHERE name = ''CVDM2XMLManagedMsgKey'') ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'DROP ASYMMETRIC KEY CVDM2XMLManagedMsgKey ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'USE MASTER ' + CHAR(10)
	SET @DLLPathUtils = @i_DLLPath + '\CommonUtils.dll'
	SET @DLLPathLogger = @i_DLLPath + '\CVManagedLogger.dll'
	SET @DLLPathXMLMsg = @i_DLLPath + '\XmlManagedMsg.dll'
	SET @sqlQuery = @sqlQuery + 'CREATE ASYMMETRIC KEY CVDM2XMLManagedMsgKey FROM EXECUTABLE FILE = ''' + @DLLPathXMLMsg + '''' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'CREATE LOGIN CVDM2XMLMsgLogin FROM ASYMMETRIC KEY CVDM2XMLManagedMsgKey ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'GRANT UNSAFE ASSEMBLY TO CVDM2XMLMsgLogin ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'CREATE ASYMMETRIC KEY CVManagedLoggerKey FROM EXECUTABLE FILE = ''' + @DLLPathLogger + '''' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'CREATE LOGIN CVManagedLoggerLogin FROM ASYMMETRIC KEY CVManagedLoggerKey ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'GRANT UNSAFE ASSEMBLY TO CVManagedLoggerLogin ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'CREATE ASYMMETRIC KEY CVDM2DBCLRKey FROM EXECUTABLE FILE = ''' + @DLLPathUtils + '''' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'CREATE LOGIN CVDM2DBCLRLogin FROM ASYMMETRIC KEY CVDM2DBCLRKey ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'GRANT UNSAFE ASSEMBLY TO CVDM2DBCLRLogin ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'USE MASTER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'EXEC sp_configure ''show advanced options'', 1 ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'RECONFIGURE ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'USE MASTER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'EXEC sp_configure ''clr enabled'' , 1 ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'RECONFIGURE ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'USE MASTER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'EXEC sp_configure ''xp_cmdshell'' , 1 ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'RECONFIGURE ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'USE MASTER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'EXEC sp_configure ''Ole Automation Procedures'', 1 ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'RECONFIGURE ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[ConvertLegalHoldMetaDataXMLTo900XMLManaged]'') AND OBJECTPROPERTY(object_id, N''IsInlineFunction'') = 0) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '	DROP FUNCTION [dbo].[ConvertLegalHoldMetaDataXMLTo900XMLManaged] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[ConvertResultItemXMLTo900XMLManaged]'') AND OBJECTPROPERTY(object_id, N''IsInlineFunction'') = 0) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '	DROP FUNCTION [dbo].[ConvertResultItemXMLTo900XMLManaged] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[GetOwnerFieldManaged]'') AND OBJECTPROPERTY(object_id, N''IsInlineFunction'') = 0) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '	DROP FUNCTION [dbo].[GetOwnerFieldManaged] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[DecodeInvalidXMLCharsManaged]'') AND OBJECTPROPERTY(object_id, N''IsInlineFunction'') = 0) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '	DROP FUNCTION [dbo].[DecodeInvalidXMLCharsManaged] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[EncodeInvalidXMLCharsManaged]'') AND OBJECTPROPERTY(object_id, N''IsInlineFunction'') = 0) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '	DROP FUNCTION [dbo].[EncodeInvalidXMLCharsManaged] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''CommonUtils'') ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '	DROP ASSEMBLY [CommonUtils] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''XmlManagedMsg'') ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '	DROP ASSEMBLY [XmlManagedMsg] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''CVManagedLogger'') ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + '	DROP ASSEMBLY [CVManagedLogger] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''SystemWeb'') ' + CHAR(10)
    SET @sqlQuery = @sqlQuery + '  DROP ASSEMBLY [SystemWeb]' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
    SET @sqlQuery = 'IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''SystemRunTimeSerialization'') ' + CHAR(10)
    SET @sqlQuery = @sqlQuery + '  DROP ASSEMBLY [SystemRunTimeSerialization]' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
    SET @sqlQuery =  'IF EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''SMdiagnostics'') ' + CHAR(10)
    SET @sqlQuery = @sqlQuery + ' DROP ASSEMBLY [SMdiagnostics] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	select @sqlQuery = 'Alter database ' + db_name() + ' set trustworthy on' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	DECLARE @windir nvarchar(255)
	declare @WindirTmp table
	(
		EnvVar nvarchar(255)
	)
	INSERT INTO @WindirTmp exec xp_cmdshell 'echo %windir%'
	SET @windir = (SELECT TOP 1 EnvVar from @WindirTmp)
	if (patindex('%\',@windir)=0)
	begin
		SET @windir = @windir + '\'
	end
	if exists(select 1 from sys.dm_clr_properties
		where name='version'
		and value like '%v4%')
	begin
		SET @sqlQuery = 'create assembly [SMdiagnostics] from  N''' + @windir+ 'Microsoft.NET\Framework\v4.0.30319\SMdiagnostics.dll'' WITH PERMISSION_SET = UNSAFE ' + CHAR(10)
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
		SET @sqlQuery = 'CREATE ASSEMBLY [SystemRunTimeSerialization] FROM N''' + @windir+ N'Microsoft.NET\Framework\v4.0.30319\System.Runtime.Serialization.dll'' WITH PERMISSION_SET = UNSAFE ' + CHAR(10)
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
		SET @sqlQuery = 'CREATE ASSEMBLY [SystemWeb] FROM N''' + @windir+ N'Microsoft.NET\Framework64\v4.0.30319\System.Web.dll'' WITH PERMISSION_SET = UNSAFE ' + CHAR(10)
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
	end
	else
	begin
		SET @sqlQuery = 'create assembly [SMdiagnostics] from  N''' + @windir+ 'Microsoft.NET\Framework\v3.0\Windows Communication Foundation\SMdiagnostics.dll'' WITH PERMISSION_SET = UNSAFE ' + CHAR(10)
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
		SET @sqlQuery = 'CREATE ASSEMBLY [SystemRunTimeSerialization] FROM N''' + @windir+ N'Microsoft.NET\Framework\v3.0\Windows Communication Foundation\System.Runtime.Serialization.dll'' WITH PERMISSION_SET = UNSAFE ' + CHAR(10)
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
		SET @sqlQuery = 'CREATE ASSEMBLY [SystemWeb] FROM N''' + @windir+ N'Microsoft.NET\Framework64\v2.0.50727\System.Web.dll'' WITH PERMISSION_SET = UNSAFE ' + CHAR(10)
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
	end
	SET @sqlQuery = 'CREATE ASSEMBLY CVManagedLogger FROM N''' + @DLLPathLogger + ''' WITH PERMISSION_SET = UNSAFE ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'CREATE ASSEMBLY XmlManagedMsg FROM N''' + @DLLPathXMLMsg + ''' WITH PERMISSION_SET = UNSAFE ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'CREATE ASSEMBLY CommonUtils FROM N''' + @DLLPathUtils + ''' WITH PERMISSION_SET = UNSAFE ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'CREATE FUNCTION [dbo].[ConvertLegalHoldMetaDataXMLTo900XMLManaged] ( @oldLHMetaDataXML NVARCHAR(MAX) ) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'RETURNS NVARCHAR(MAX) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'WITH EXECUTE AS CALLER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'AS ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'EXTERNAL NAME [CommonUtils].[Commvault.Utils.UserDefinedFunctions].[ConvertLegalHoldMetaDataXMLTo900XML] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'CREATE FUNCTION [dbo].[ConvertResultItemXMLTo900XMLManaged] ( @ResultItemID NVARCHAR(36), @oldResultItemXML NVARCHAR(MAX) ) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'RETURNS NVARCHAR(MAX) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'WITH EXECUTE AS CALLER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'AS ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'EXTERNAL NAME [CommonUtils].[Commvault.Utils.UserDefinedFunctions].[ConvertResultItemXMLTo900XML] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'CREATE FUNCTION [dbo].[GetOwnerFieldManaged] (@fromField NVARCHAR(MAX), @lnks NVARCHAR(MAX), @filePath NVARCHAR(MAX), @getMailOwnerStr NVARCHAR(10) ) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'RETURNS NVARCHAR(MAX) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'WITH EXECUTE AS CALLER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'AS ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'EXTERNAL NAME [CommonUtils].[Commvault.Utils.UserDefinedFunctions].[GetOwnerField] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'CREATE FUNCTION [dbo].[DecodeInvalidXMLCharsManaged] (@inputString NVARCHAR(MAX)) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'RETURNS NVARCHAR(MAX) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'WITH EXECUTE AS CALLER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'AS ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'EXTERNAL NAME [CommonUtils].[Commvault.Utils.UserDefinedFunctions].[DecodeInvalidXMLCharsHelper] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'CREATE FUNCTION [dbo].[EncodeInvalidXMLCharsManaged] (@inputString NVARCHAR(MAX) ) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'RETURNS NVARCHAR(MAX) ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'WITH EXECUTE AS CALLER ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'AS ' + CHAR(10)
	SET @sqlQuery = @sqlQuery + 'EXTERNAL NAME [CommonUtils].[Commvault.Utils.UserDefinedFunctions].[EncodeInvalidXMLCharsHelper] ' + CHAR(10)
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
CX_EXIT:
	SELECT @o_retVal
	RETURN @o_retVal
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_CreateCLRFunctions')
	delete from GxQscripts where name = 'sp_dm2_CreateCLRFunctions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_CreateCLRFunctions')
	delete from GXDBVersions where aliasname = 'sp_dm2_CreateCLRFunctions'
GO

insert into GXDBVersions values(2, 'sp_dm2_CreateCLRFunctions',  '00010014000000000000', 'sp_dm2_CreateCLRFunctions', '00010014000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneDownloadBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneDownload()
--  | Description:  Prune Downloads
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneDownloadBulk.sp,v $ $Id: sp_dm2_PruneDownloadBulk.sp,v 1.1 2010/05/04 04:54:29 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneDownloadBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneDownloadBulk')
	drop procedure sp_dm2_PruneDownloadBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneDownloadBulk')
	delete from GxQscripts where name = 'sp_dm2_PruneDownloadBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneDownloadBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneDownloadBulk'
GO
print '... Creating Procedure: sp_dm2_PruneDownloadBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneDownloadBulk
  @i_downloadXML XML,
  @i_dummy INT = 0
AS
	IF OBJECT_ID('tempdb.dbo.#tblDownload') IS NOT NULL DROP TABLE #tblDownload
  CREATE TABLE #tblDownload
  (
  	downloadId 			CHAR(36),
  	destinationPath	NVARCHAR(MAX),
  	cabFilePath			NVARCHAR(MAX)
  )
  INSERT INTO #tblDownload
	SELECT CAST(T.c.query('data(downloadId)') AS CHAR(36)),
	   CAST(T.c.query('data(destinationPath)') AS NVARCHAR(MAX)),
	   CAST(T.c.query('data(cabFilePath)') AS NVARCHAR(MAX))
	FROM @i_downloadXML.nodes('/DownloadItems/DownloadItem') T(c)
	--Delete the entries that are successfully deleted from cache
	DELETE DMDownloadResultSet
	FROM DMDownloadResultSet D, #tblDownload T
	WHERE D.downloadId = T.downloadId
	AND		(T.destinationPath IS NULL OR LEN(T.destinationPath) = 0)
	AND		(T.cabFilePath IS NULL OR LEN(T.cabFilePath) = 0)
	--Delete the entries that are successfully deleted from cache
	DELETE DMDownload
	FROM DMDownload D, #tblDownload T
	WHERE D.downloadId = T.downloadId
	AND		(T.destinationPath IS NULL OR LEN(T.destinationPath) = 0)
	AND		(T.cabFilePath IS NULL OR LEN(T.cabFilePath) = 0)
	--Update PruneStatus if it failed to delete from cache
	UPDATE DMDownload
	SET PruneUpdateTime = GETUTCDATE(), PruneStatus = 1
	FROM DMDownload D, #tblDownload T
	WHERE D.downloadId = T.downloadId
	AND		(
					(T.destinationPath IS NOT NULL AND LEN(T.destinationPath) > 0)
					OR
					(T.cabFilePath IS NOT NULL AND LEN(T.cabFilePath) > 0)
				)
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneDownloadBulk')
	delete from GxQscripts where name = 'sp_dm2_PruneDownloadBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneDownloadBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneDownloadBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneDownloadBulk',  '00010001000000000000', 'sp_dm2_PruneDownloadBulk', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldXMLData.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetLegalHoldXMLData()
--  | Description:  Get the Data required to construct LegalHold MetaData XML
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldXMLData.sp,v $ $Id: sp_dm2_GetLegalHoldXMLData.sp,v 1.3 2010/05/12 21:27:43 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetLegalHoldXMLData <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetLegalHoldXMLData')
	drop procedure sp_dm2_GetLegalHoldXMLData
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetLegalHoldXMLData')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldXMLData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldXMLData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldXMLData'
GO
print '... Creating Procedure: sp_dm2_GetLegalHoldXMLData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetLegalHoldXMLData
  @i_ContainerID varchar(36),
  @i_ResultSetID varchar(36),
  @i_StateXML xml,
  @i_TagsXML xml
AS
	SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#tblStateInfo') IS NOT NULL
		DROP TABLE #tblStateInfo
	IF OBJECT_ID('tempdb.dbo.#tblTagInfo') IS NOT NULL
		DROP TABLE #tblTagInfo
	IF OBJECT_ID('tempdb.dbo.#tblLHDataInfo') IS NOT NULL
		DROP TABLE #tblLHDataInfo
  CREATE TABLE #tblStateInfo
  (
  	StateID 		VARCHAR(36),
  	StateValue 	NVARCHAR(256)
  )
  CREATE TABLE #tblTagInfo
  (
  	TagID 		VARCHAR(36),
  	TagValue 	NVARCHAR(256)
  )
	CREATE TABLE #tblLHDataInfo
	(
		DataType					INTEGER,
		AssignId					INTEGER,
		UserGUID					VARCHAR(36),
		UserName					NVARCHAR(256),
		StateId						VARCHAR(36),
		StateValue				NVARCHAR(256),
		StateNotes				NVARCHAR(MAX),
		TagType						INTEGER,
		TagId							VARCHAR(36),
		TagValue    			NVARCHAR(256),
		TagNotes    			NVARCHAR(MAX),
		TagAttr						INTEGER,
		UserComment				NVARCHAR(MAX),
		CreationTime			VARCHAR(25),
		LastModifiedTime	VARCHAR(25)
	)
	INSERT INTO #tblStateInfo
	SELECT  ref.value('@StateID', 'VARCHAR(36)'),
					ref.value('@StateValue', 'NVARCHAR(256)')
	FROM  @i_StateXML.nodes ('StateInfo') S(ref)
	INSERT INTO #tblTagInfo
	SELECT  ref.value('@TagID', 'VARCHAR(36)'),
					ref.value('@TagValue', 'NVARCHAR(256)')
	FROM  @i_TagsXML.nodes ('TagInfo') T(ref)
  -- TagType = 1 - DBOnly Tags
  -- TagType = 2 - CI Tags
  -- DataType = 1 - Tags
  -- DataType = 2 - User Comments
  INSERT INTO #tblLHDataInfo
  -- Get all DB ONLY tags
  SELECT DISTINCT 1, CIS.AssignID, CIS.AssignedUserGUID, US.UserName,
  								CIS.StateID, S.StateValue, CIS.Notes,
   								1, CIT.TagID, T.TagValue, CIT.Notes, CIT.attribute,
   								'', NULL, NULL
	FROM	DMContainerItemStates CIS WITH (NOLOCK)
				LEFT OUTER JOIN #tblStateInfo S
				ON CIS.StateID = S.StateID
				LEFT OUTER JOIN DMUserSession US WITH (NOLOCK)
				ON CIS.AssignedUserGUID = US.UserGUID
				LEFT OUTER JOIN DMContainerItemTags CIT WITH (NOLOCK)
				ON CIS.assignId = CIT.assignId
				LEFT OUTER JOIN #tblTagInfo T
				ON CIT.TagId = T.TagId
	WHERE	CIS.ContainerID = @i_ContainerID
	AND		CIS.ResultSetID = @i_ResultSetID
	AND		CIS.attribute & 4 = 0
	AND		CIT.attribute & 4 = 0
	UNION
  -- Get all CI tags
  SELECT DISTINCT 1, 0, UIT.UserGUID, US.UserName,
  								'', '', '',
   								2, UIT.TagID, T.TagValue, '', UIT.attribute,
   								'', NULL, NULL
	FROM	DMUserItemTags UIT WITH (NOLOCK)
				LEFT OUTER JOIN DMUserSession US WITH (NOLOCK)
				ON UIT.UserGUID = US.UserGUID
				LEFT OUTER JOIN #tblTagInfo T
				ON UIT.TagId = T.TagId
	WHERE	UIT.ResultSetID = @i_ResultSetID
	AND		UIT.attribute & 4 = 0
	UNION
  -- Get all User Comments
  SELECT DISTINCT 2, 0, UC.UserGUID, US.UserName,
  								'', '', '',
  								0, '', '', '', '',
  								UC.Comment,
  								CONVERT(VARCHAR(25), UC.CreateTime, 121),
  								CONVERT(VARCHAR(25), UC.ModifiedTime, 121)
	FROM	DMUserComment UC WITH (NOLOCK)
				LEFT OUTER JOIN DMUserSession US WITH (NOLOCK)
				ON UC.UserGUID = US.UserGUID
	WHERE	UC.ContainerID = @i_ContainerID
	AND		UC.ResultSetID = @i_ResultSetID
	AND		UC.attribute & 4 = 0
	SELECT *
	FROM #tblLHDataInfo
	ORDER BY DataType, UserGUID, TagType
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetLegalHoldXMLData')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldXMLData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldXMLData')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldXMLData'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetLegalHoldXMLData',  '00010003000000000000', 'sp_dm2_GetLegalHoldXMLData', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetFilteredResultItemDetail.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetFilteredResultItemDetail.sp,v $ $Id: sp_dm2_GetFilteredResultItemDetail.sp,v 1.3 2015/04/16 18:53:20 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetFilteredResultItemDetail <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetFilteredResultItemDetail')
	drop procedure sp_dm2_GetFilteredResultItemDetail
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetFilteredResultItemDetail')
	delete from GxQscripts where name = 'sp_dm2_GetFilteredResultItemDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetFilteredResultItemDetail')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetFilteredResultItemDetail'
GO
print '... Creating Procedure: sp_dm2_GetFilteredResultItemDetail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetFilteredResultItemDetail
  @i_ItemsXML XML,
  @i_DUMMY NVARCHAR(MAX) = ''
AS
BEGIN
	DECLARE @curResultSetId			VARCHAR(36)
	DECLARE @curContainerId			VARCHAR(36)
	DECLARE @curCommentId				VARCHAR(36)
	DECLARE @curComment					NVARCHAR(MAX)
	DECLARE @curTagsXML					XML
	DECLARE @tmpContainerStr		VARCHAR(MAX)
	DECLARE @tmpDBTagStr				VARCHAR(MAX)
	DECLARE @tmpTagStr					VARCHAR(MAX)
	DECLARE @tmpLHGUIDStr				VARCHAR(MAX)
	DECLARE @debug							BIT
	DECLARE @i_UserGUID					VARCHAR(36)
	DECLARE @i_xmlText				XML
	--change @debug to 1 helps trace outputs of stored proc, but should be 0 in test / production env..
	SET @debug = 0
	CREATE TABLE #tmpContainerGUIDList ( ContainerId VARCHAR(36) )
	CREATE TABLE #tmpTagGUIDList ( TagID VARCHAR(36) )
	CREATE TABLE #tmpLHGUIDList ( CompPolicyID VARCHAR(36) )
	CREATE TABLE #tmpViewTagList ( TagID VARCHAR(36) )
	--LegalHoldStatus = 1 (Success), 3 (Unknown), 2 (Failed), 0 (Submitted)
	CREATE Table #tmpResultSet
	(
		ContainerId			VARCHAR(36),
		DocumentId 			char(256),
		ResultSetId 		VARCHAR(36),
		CommCellNumber 	INTEGER,
		aFileId 				BIGINT,
		aFileOffSet 		BIGINT,
		restoreStatus 	INTEGER,
		ContainerList 	VARCHAR(MAX),
		DBTagGUIDList 	VARCHAR(MAX),
		TagGUIDList 		VARCHAR(MAX),
		LegalHoldStatus INTEGER,
		DestinationPath NVARCHAR(MAX),
		Comment 				NVARCHAR(MAX),
		CommentID 			CHAR(36),
		LHGUIDList 			VARCHAR(MAX),
		TagsXML					XML
	)
	SELECT @i_UserGUID = T.c.value('@userGuid', 'VARCHAR(36)')
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/userInfo') T(c)
	IF @i_UserGUID IS null
		SET @i_UserGUID = ''
	-- Populate containerGUID that current user can view
	INSERT INTO #tmpContainerGUIDList
	SELECT * FROM dbo.splitStringToTable((SELECT T.c.value('@containerIdList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/sharedEntities') T(c)))
	-- Populate TagGUIDs that current user can view
	INSERT INTO #tmpTagGUIDList
	SELECT * FROM dbo.splitStringToTable((SELECT T.c.value('@tagIdList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/sharedEntities') T(c)))
	-- Populate LegalHoldGUIDs that current user can view
	INSERT INTO #tmpLHGUIDList
	SELECT * FROM dbo.splitStringToTable((SELECT T.c.value('@legalHoldList', 'VARCHAR(MAX)')
																				FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/sharedEntities') T(c)))
	IF @debug = 1
	BEGIN
		SELECT '#tmpContainerGUIDList' AS TableName, * FROM #tmpContainerGUIDList
		SELECT '#tmpTagGUIDList' AS TableName, * FROM #tmpTagGUIDList
		SELECT '#tmpLHGUIDList' AS TableName, * FROM #tmpLHGUIDList
	END
	INSERT INTO #tmpResultSet(ContainerId, DocumentId, CommCellNumber, aFileId, aFileOffSet,
														restoreStatus, ContainerList, TagGUIDList, LegalHoldStatus,
														TagsXML)
	SELECT 	ISNULL(T.c.value('containerInfo[1]/@containerGuid', 'varchar(36)'), ''),
					T.c.value('result[1]/@documentId', 'char(256)'),
					T.c.value('result[1]/@commcellNo', 'integer'),
					T.c.value('result[1]/@aFileId', 'bigint'),
					T.c.value('result[1]/@aFileOffset', 'bigint'),
					0 AS RestoreStatus,
					'' AS ContainerList,
					'' AS TagGUIDList,
					3 AS LegalHoldStatus,
					CAST(T.c.query('result[1]/tags') AS XML) AS TagsXML
	FROM @i_ItemsXML.nodes('/DM2ContentIndexing_GetFilteredResultItemsMetaDataReq/input/containerItems') T(c);
	--Update the resultitem specific information
	UPDATE #tmpResultSet
	SET ResultSetId = RS.ResultSetId,
	restoreStatus = RS.RestoreStatus,
	DestinationPath = RS.DestinationPath,
	LegalHoldStatus = 3
	FROM #tmpResultSet tt, DMResultSet RS WITH (READUNCOMMITTED)
	WHERE RS.CommCellNumber = tt.CommCellNumber
	AND 	RS.aFileId = tt.aFileId
	AND 	RS.aFileOffSet = tt.aFileOffSet
	IF @debug = 1
	BEGIN
		SELECT '#tmpResultSet' AS TableName, * FROM #tmpResultSet
	END
	DECLARE ResultSetCur CURSOR STATIC FOR
	SELECT ContainerId, ResultSetId, TagsXML FROM #tmpResultSet
	OPEN ResultSetCur
	FETCH NEXT FROM ResultSetCur INTO @curContainerId, @curResultSetId, @curTagsXML
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE #tmpViewTagList
		SET @tmpContainerStr = null
		SET @tmpDBTagStr = null
		SET @tmpTagStr = null
		SET @tmpLHGUIDStr = null
		SET @curCommentId = ''
		SET @curComment = ''
		--Get the last Modified Comment on items (if any)
		SELECT TOP 1 @curCommentId = UC.CommentId, @curComment = UC.Comment
		FROM DMUserComment UC WITH (NOLOCK), DMContainerItem CI WITH (NOLOCK)
		WHERE UC.ResultSetId = CI.ResultSetId
		AND		UC.ContainerId = CI.ContainerId
		AND		UC.ResultSetId = @curResultSetId
		AND 	UC.ContainerId = @curContainerId
		AND		(UC.attribute & 4) = 0
		AND	  (CI.Attribute & 4) = 0
		AND 	UC.Comment IS NOT NULL
		AND		LEN(UC.Comment) > 0
		ORDER BY modifiedTime DESC
		--Capture ContainerId List of those in which current ResultItemId exists and current user can view it
		SELECT @tmpContainerStr = COALESCE(@tmpContainerStr + ', ', '') + tt.ContainerId
		FROM 	#tmpContainerGUIDList tt, DMContainerItem CI  WITH (READUNCOMMITTED)
		WHERE	tt.ContainerId = CI.ContainerId
		AND		CI.ResultSetId = @curResultSetId
		AND		(len(@curContainerId) = 0 OR tt.ContainerId <> @curContainerId) -- If called from reviewset view then list other reviewsets except the current one
		AND	  (CI.Attribute & 4) = 0
		--Get the Container specific (DB ONLY) tags
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		INSERT INTO  #tmpViewTagList
		SELECT DISTINCT CIT.TagId
		FROM 	#tmpTagGUIDList tt, DMContainerItemStates CIS WITH (READUNCOMMITTED), DMContainerItemTags CIT WITH (READUNCOMMITTED)
		WHERE	(len(@curContainerId) = 0 OR CIS.ContainerId = @curContainerId)
		AND		CIS.ResultSetId = @curResultSetId
		--AND		CIS.AssignedUserGUID = @i_UserGUID -- Get all users tags since current user can view shared Tags
		AND		CIS.AssignId = CIT.AssignId
		AND		CIT.TagID = tt.TagID
		AND		(CIS.Attribute & 4) = 0
		AND		(CIT.Attribute & 4) = 0
		--Get complete list of DB TagIds that current user can view
		SELECT @tmpDBTagStr = COALESCE(@tmpDBTagStr + ',', '') + tt.TagID
		FROM #tmpViewTagList tt
		--Clean DB tags and get Fast Synced Tags
		DELETE FROM #tmpViewTagList
		--Get the Item specific (FAST SYNCed) tags
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		INSERT INTO  #tmpViewTagList
		SELECT DISTINCT UIT.TagID
		FROM 	#tmpTagGUIDList tt, DMUserItemTags UIT WITH (READUNCOMMITTED)
		WHERE	UIT.ResultSetId = @curResultSetId
		--AND		UIT.UserGUID = @i_UserGUID -- Get all users tags since current user can view shared Tags
		AND		UIT.TagID = tt.TagID
		AND		(UIT.Attribute & 4) = 0
		UNION
		--Get the tags retrieved from FAST search results
		--Since user can view the shared tags, get the tags even if they are tagged by different user but are shared to current user
		--For now get tags from ResultSetXML when @curContainerId is empty for tags coming from FAST
		SELECT DISTINCT TAG.TagID
		FROM 	#tmpTagGUIDList tt, ( SELECT T.c.value('@id', 'char(36)') AS TagID
																FROM @curTagsXML.nodes('/tags/tag') T(c)) TAG
		WHERE	TAG.TagID = tt.TagID
		AND		len(@curContainerId) = 0
		--Get complete list of TagIds that current user can view
		SELECT @tmpTagStr = COALESCE(@tmpTagStr + ',', '') + tt.TagID
		FROM #tmpViewTagList tt
		--Get the LegalHold GUIDs to which this item is backed up and shared by current user
		SELECT @tmpLHGUIDStr = COALESCE(@tmpLHGUIDStr + ',', '') + LH.CompPolicyID
		FROM 	#tmpLHGUIDList tt, (SELECT DISTINCT CompPolicyID
															FROM DMLegalHoldItemsToBackup WITH (READUNCOMMITTED)
															WHERE ResultSetId = @curResultSetId
															AND		(len(@curContainerId) = 0 OR ContainerId = @curContainerId)
															AND		BackupStatus = 1) LH
		WHERE	LH.CompPolicyID = tt.CompPolicyID
		--Update List of ReviewSets, List of Tags and List of LegalHolds
			UPDATE #tmpResultSet
			SET commentId = ISNULL(@curCommentId, ''),
					comment = ISNULL(@curComment, ''),
					ContainerList = ISNULL(@tmpContainerStr, ''),
					DBTagGUIDList = ISNULL(@tmpDBTagStr, ''),
					TagGUIDList = ISNULL(@tmpTagStr, ''),
					LHGUIDList = ISNULL(@tmpLHGUIDStr, '')
			WHERE ResultSetId = @curResultSetId
			AND		ContainerId = @curContainerId
			FETCH NEXT FROM ResultSetCur INTO @curContainerId, @curResultSetId, @curTagsXML
		END
		SELECT * FROM #tmpResultSet
		DROP TABLE #tmpResultSet
		DROP TABLE #tmpContainerGUIDList
		DROP TABLE #tmpTagGUIDList
		DROP TABLE #tmpLHGUIDList
		DROP TABLE  #tmpViewTagList
		CLOSE ResultSetCur
		DEALLOCATE ResultSetCur
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetFilteredResultItemDetail')
	delete from GxQscripts where name = 'sp_dm2_GetFilteredResultItemDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetFilteredResultItemDetail')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetFilteredResultItemDetail'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetFilteredResultItemDetail',  '00010003000000000000', 'sp_dm2_GetFilteredResultItemDetail', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateJMRestoreStatusBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateJMRestoreStatusBulk()
--  | Description:  Update the Restore Status of jobIds in Bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateJMRestoreStatusBulk.sp,v $ $Id: sp_dm2_UpdateJMRestoreStatusBulk.sp,v 1.2 2011/04/14 12:15:32 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateJMRestoreStatusBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateJMRestoreStatusBulk')
	drop procedure sp_dm2_UpdateJMRestoreStatusBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateJMRestoreStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateJMRestoreStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateJMRestoreStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateJMRestoreStatusBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateJMRestoreStatusBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateJMRestoreStatusBulk
  @i_xml XML
AS
BEGIN
	/***
	eg:
		<JobStatusList>
		  <JobStatus i_RestoreJobID="61" i_OldRestoreStatus="-1" i_RestoreStatus="4" i_IsJM="1" />
		  <JobStatus i_RestoreJobID="81" i_OldRestoreStatus="-1" i_RestoreStatus="4" i_IsJM="1" />
		</JobStatusList>
	*/
		--declare cursor variables
	DECLARE @i_RestoreJobID 	INT = 0,
			@i_OldRestoreStatus INT = -1,
			@i_RestoreStatus	INT = 0,
			@i_IsJM				INT = 0,
			@i_ResultSetID 		VARCHAR(MAX) = ''
			--------------Open cursor--------------
	DECLARE JobStatusCursor CURSOR FAST_FORWARD FOR
	SELECT
		ISNULL(T.list.value('@i_RestoreJobID','INT'),0),
		ISNULL(T.list.value('@i_OldRestoreStatus','INT'),-1),
		ISNULL(T.list.value('@i_RestoreStatus','INT'),0),
		ISNULL(T.list.value('@i_IsJM','INT'),0),
		ISNULL(T.list.value('@i_ResultSetID','VARCHAR(MAX)'),'')
	FROM @i_xml.nodes('JobStatusList/JobStatus') AS T(list)
	OPEN JobStatusCursor
	FETCH NEXT FROM JobStatusCursor INTO @i_RestoreJobID,@i_OldRestoreStatus,@i_RestoreStatus,@i_IsJM,@i_ResultSetID
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--Call the existing store proc which updates the jobStatus
		EXEC sp_dm2_UpdateRestoreStatus @i_RestoreJobID,@i_OldRestoreStatus,@i_RestoreStatus,@i_IsJM,@i_ResultSetID
		FETCH NEXT FROM JobStatusCursor INTO @i_RestoreJobID,@i_OldRestoreStatus,@i_RestoreStatus,@i_IsJM,@i_ResultSetID
	END
	CLOSE JobStatusCursor
	DEALLOCATE JobStatusCursor
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateJMRestoreStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateJMRestoreStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateJMRestoreStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateJMRestoreStatusBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateJMRestoreStatusBulk',  '00010002000000000000', 'sp_dm2_UpdateJMRestoreStatusBulk', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemStatus.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemStatus.sp,v $ $Id: sp_dm2_GetResultItemStatus.sp,v 1.2 2015/02/03 20:30:59 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultItemStatus <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultItemStatus')
	drop procedure sp_dm2_GetResultItemStatus
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultItemStatus')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemStatus'
GO
print '... Creating Procedure: sp_dm2_GetResultItemStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultItemStatus
  @i_aFileId BIGINT ,
  @i_aFileOffset BIGINT ,
  @i_CommCellNumber INT ,
  @i_ContainerID VARCHAR(36) = '',
  @i_IndexGUID VARCHAR(128) = ''
AS
SET NOCOUNT ON
	/*
	            Input: CommcellId, AFileId, AFileOffset,ContainerId
	            Output: DestinationPath, RestoreStatus, ResultSetId, Attribute, restoreJobID
	                        (Attribute field will be read from DMContainerItem, rest of the fields will be read from DMResultSet table)
	                        (If item doesnt exists in DMcontainerItem table, -1 is returned)
	      *
	      **/
		DECLARE @ItemID BIGINT
		IF ISNULL(@i_IndexGUID, '') <> ''
		BEGIN
			SELECT @ItemID = ID FROM DMResultSet AS D WITH(NOLOCK)
			WHERE D.IndexGUID = @i_IndexGUID
		END
		IF ISNULL(@ItemID, 0) = 0 AND @i_aFileId > 0
		BEGIN
			SELECT @ItemID = ID FROM DMResultSet AS D WITH(NOLOCK)
			WHERE D.aFileID = @i_aFileId AND D.aFileOffset = @i_aFileOffset AND D.CommCellNumber = @i_CommCellNumber
		END
		SELECT D.ResultSetID, D.DestinationPath, D.RestoreStatus,D.RestoreJobID,
		ISNULL((SELECT C.Attribute FROM DMContainerItem AS C WHERE C.ContainerID = @i_ContainerID AND C.ResultSetID = D.ResultSetID), -1) AS "Attribute"
		FROM DMResultSet D WITH(NOLOCK)
		WHERE ID = @ItemID
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultItemStatus')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultItemStatus',  '00010002000000000000', 'sp_dm2_GetResultItemStatus', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldItemsWithGrouping.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldItemsWithGrouping.sp,v $ $Id: sp_dm2_GetLegalHoldItemsWithGrouping.sp,v 1.6 2012/10/11 17:50:16 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetLegalHoldItemsWithGrouping <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetLegalHoldItemsWithGrouping')
	drop procedure sp_dm2_GetLegalHoldItemsWithGrouping
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetLegalHoldItemsWithGrouping')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldItemsWithGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldItemsWithGrouping')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldItemsWithGrouping'
GO
print '... Creating Procedure: sp_dm2_GetLegalHoldItemsWithGrouping'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetLegalHoldItemsWithGrouping
  @i_xml XML ,
  @o_resultItemsCount BIGINT OUTPUT,
  @o_groupingCount BIGINT OUTPUT,
  @o_localGroupingXml NVARCHAR(MAX) OUTPUT,
  @o_groupingXml NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	--reset Output variables
	SELECT @o_groupingCount = 0, @o_resultItemsCount = 0,
			@o_localGroupingXml = '',@o_groupingXml = ''
	--local variables
	DECLARE @i_backupStatus VARCHAR(30),
			@i_ignoreResultItems BIT = 0,
			@i_ignoreGrouping BIT = 0,
			@i_containerId VARCHAR(36),
			@i_whereClause	NVARCHAR(MAX),
			@i_groupByclause VARCHAR(50),
			@i_orderByClause VARCHAR(50),
			@sqlCmd NVARCHAR(MAX) = '',
			@fetchEmail CHAR(1) = '1',
			@fetchFiles	CHAR(1)	= '1',
			@StartRN	INTEGER = 0,
			@pageCount	INTEGER = 0,
			@EndRN	INTEGER = -1,
			@i_debug	BIT = 0,
			@returnEmptyResultItemTable BIT = 1
	--parse the input XML to get required field only
	SELECT	@i_containerId = ISNULL(T.col.value('@containerId','VARCHAR(36)'),''),
			@i_ignoreResultItems = ISNULL(T.col.value('@ignoreResultItems','BIT'),0),
			@i_ignoreGrouping = ISNULL(T.col.value('@ignoreGrouping','BIT'),0),
			@i_whereClause = ISNULL(T.col.value('@whereCondition','NVARCHAR(MAX)'),''),
			@i_backupStatus = ISNULL(T.col.value('@backupStatus','VARCHAR(30)'),''),
			@i_groupByclause = ISNULL(T.col.value('Grouping[1]/@groupByClause','VARCHAR(50)'),''),
			@i_debug = ISNULL(T.col.value('@debug','BIT'),0)
	FROM @i_xml.nodes('/GetItems')  T(col)
	--SET the backupstatus accordingly
                                                        SELECT @i_backupStatus = CASE WHEN @i_backupStatus = 'SUCCESS' THEN
									' LH.BackupStatus = 1 '
								WHEN @i_backupStatus in( 'FAILURE','FAILED') THEN
									' LH.BackupStatus <> 1 '
								ELSE
									''
							END
	-------++++++++++Case when GResultItems will be returned++++++++-------
	IF(@i_ignoreResultItems = 0)
	BEGIN
		--get the apptype filter and other info
		SELECT	@fetchEmail= ISNULL(T.col.value('ResultItems[1]/@fetchEmails','VARCHAR(1)'),'1'),
				@fetchFiles= ISNULL(T.col.value('ResultItems[1]/@fetchFiles','VARCHAR(1)'),'1'),
				@StartRN = 	ISNULL(T.col.value('ResultItems[1]/@startIndex','INTEGER'),0),
				@pageCount = ISNULL(T.col.value('ResultItems[1]/@pageSize','INTEGER'),0),
				@i_orderByClause = CASE LEN(ISNULL(T.col.value('ResultItems[1]/@orderByClause','VARCHAR(50)'),''))
										WHEN 0 THEN 'ModifiedTime DESC'
										ELSE T.col.value('ResultItems[1]/@orderByClause','VARCHAR(50)')
									END
		FROM @i_xml.nodes('/GetItems')  T(col)
		IF object_id('tempdb.dbo.#tblGetAllContainerItem') is not null
			DROP TABLE #tblGetAllContainerItem
		CREATE TABLE #tblGetAllContainerItem
		(
			[JobID] 		[int],
			[CompPolicyID] 	[char](36) 	,
			[ContainerID] 	[char](36) 	,
			[ResultSetID] 	[char](36) 	,
			[CommCellID] 	[int] 	,
			[BackupStatus]	[int],
			[AppType] 		[int] 		,
			[OwnerField]	[nvarchar](max) ,
			[FromField]		[nvarchar](max) ,
			[FolderPath]	[nvarchar](max) ,
			[RowNumber]		[BIGINT]
		)
		SET @sqlCmd = '	INSERT INTO #tblGetAllContainerItem
						SELECT DISTINCT LH.JobId,LH.CompPolicyId,
									LH.ContainerID,LH.ResultSetID,LH.CommCellId,LH.BackupStatus,LH.AppType,
									ISNULL(LH.OwnerField,'''') AS "OwnerField",
									ISNULL(LH.FromField,'''') AS "FromField",ISNULL(LH.FolderPath,'''')AS "FolderPath",
									ROW_NUMBER() OVER (order by LH.' + @i_OrderByClause + ') as RowNumber
						FROM DMLegalHoldItemsToBackup AS LH
						WHERE ISNULL(LH.ResultSetID, '''') <> '''' AND LH.CompPolicyId = '''+@i_containerId +''''
		IF @fetchEmail = 0 OR @fetchFiles = 0
			SET @sqlCmd = @sqlCmd + ' AND LH.AppType IN (SELECT AT.AppTypeId
							FROM DMUIAppTypeMap AS AT
							WHERE AT.IsEmailAppType = '+ @fetchEmail +
							' OR AT.IsFileAppType = '+  @fetchFiles +')'
		IF(LEN(ISNULL(@i_backupStatus,''))>0)
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_backupStatus
		IF(LEN(ISNULL(@i_whereClause,''))>0)
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_whereClause
		--SET @sqlCmd = @sqlCmd + ' ORDER BY ' + @i_orderByClause
		IF(@i_debug = 1)
			SELECT @sqlCmd 'ResultItemSQLCMD'
		EXECUTE(@sqlCmd);
		SELECT @o_resultItemsCount = COUNT(CompPolicyId) FROM #tblGetAllContainerItem
		IF(@o_resultItemsCount > 0)
		BEGIN
			--Paging config
			SELECT @StartRN = CASE WHEN @StartRN <= 0 THEN 1
									ELSE @StartRN
								END,
					@pageCount = CASE WHEN @pageCount < 0 THEN 0
									ELSE @pageCount
								END,
					@EndRN = CASE WHEN @pageCount <= 0 THEN @o_resultItemsCount
									ELSE (@pageCount+ @StartRN -1)
								END
			IF object_id('tempdb.dbo.#tempGetPageItems') is not null
				DROP TABLE #tempGetPageItems
		CREATE TABLE #tempGetPageItems
		(
			[JobID] 		[int],
			[CompPolicyID] 	[char](36) 	,
			[ContainerID] 	[char](36) 	,
			[ResultSetID] 	[char](36) 	,
			[CommCellID] 	[int] 	,
			[BackupStatus]	[int],
			[AppType] 		[int],
			[OwnerField]	[nvarchar](max) ,
			[FromField]		[nvarchar](max) ,
			[FolderPath]	[nvarchar](max) ,
			[RowNumber]		[BIGINT]
		)
			--Insert into temp table so that grouping can  be done
			insert INTO #tempGetPageItems
			select * FROM #tblGetAllContainerItem AS T
			WHERE T.RowNumber  BETWEEN @StartRN AND @EndRN
			ORDER BY T.RowNumber
			SELECT R.JobID, R.CommCellID, R.CompPolicyID, R.ContainerID, R.ResultSetID,
			L.OriginalPath, L.BackupPath, L.MetaDataXML, L.BackupStatus, L.Attribute, L.AppType,
			L.FileSizeKB,  L.ModifiedTime, L.OriginalFullPath, L.ClientID, R.OwnerField,
			L.FromField, R.FolderPath, R.RowNumber
			FROM #tempGetPageItems R
			JOIN DMLegalHoldItemsToBackup L ON R.JobID = L.JobId AND
			R.CommCellID = L.CommCellId AND R.CompPolicyID = L.CompPolicyId AND R.ContainerID = L.ContainerID AND R.ResultSetID = L.ResultSetID
			AND R.BackupStatus = L.BackupStatus AND R.AppType = L.AppType
			ORDER BY R.RowNumber
			--reset empty table as false
			SET @returnEmptyResultItemTable = 0
			IF(LEN(@i_groupByclause) > 0)
			BEGIN
				IF object_id('tempdb.dbo.#localTmpTbl') is not null
					DROP TABLE #localTmpTbl
				CREATE TABLE #localTmpTbl
					( value NVARCHAR(MAX),
						 countVal BIGINT )
				SET @sqlCmd = 'INSERT INTO #localTmpTbl
					SELECT  CASE LEN(ISNULL(' + @i_groupByclause +',''''))
							WHEN 0 THEN ''N/A''
							ELSE '+ @i_groupByclause +'
							END AS "value",
							COUNT_BIG(*) AS "countVal"
						 FROM #tblGetAllContainerItem AS T'
				SET @sqlCmd  = @sqlCmd + ' WHERE ISNULL(' + @i_groupByclause +','''')
						  IN
					(SELECT DISTINCT ISNULL(' + @i_groupByclause +','''')
						 FROM #tempGetPageItems )'
				SET @sqlCmd = @sqlCmd + ' GROUP BY CASE LEN(ISNULL(' + @i_groupByclause +',''''))
						WHEN 0 THEN ''N/A''
						ELSE '+ @i_groupByclause +'
						END '
				IF(@i_debug = 1)
					SELECT @sqlCmd "LocalGroupingSQLCMD"
				EXECUTE(@sqlCmd)
				SET @o_localGroupingXml =
						(SELECT *
							FROM #localTmpTbl
							For XML RAW('Items'),ROOT('GetItems_Grouping'))
				DROP TABLE #localTmpTbl
			END
			DROP TABLE #tempGetPageItems
		END
		DROP TABLE #tblGetAllContainerItem
	END
	---------+++++++++++++If empty table has to be returned for ResultItems+++++++++++++-------------
	IF(@returnEmptyResultItemTable = 1)
	BEGIN
		SELECT LH.*
		FROM DMLegalHoldItemsToBackup AS LH WITH (READUNCOMMITTED)
		 WHERE 1= 2
	END
	---------++++++++++++Case when GroupingItems to be returned+++++++++++++++------------------
	IF(@i_ignoreGrouping = 0 AND LEN(@i_groupByclause) > 0)
	BEGIN
		--get the apptype filter and other info
		SELECT	@fetchEmail= ISNULL(T.col.value('Grouping[1]/@fetchEmails','VARCHAR(1)'),'1'),
				@fetchFiles= ISNULL(T.col.value('Grouping[1]/@fetchFiles','VARCHAR(1)'),'1'),
				@StartRN = 	ISNULL(T.col.value('Grouping[1]/@startIndex','INTEGER'),0),
				@pageCount = ISNULL(T.col.value('Grouping[1]/@pageSize','INTEGER'),0),
				@i_orderByClause = CASE LEN(ISNULL(T.col.value('Grouping[1]/@orderByClause','VARCHAR(50)'),''))
										WHEN 0 THEN 'countVal DESC'
										ELSE T.col.value('Grouping[1]/@orderByClause','VARCHAR(50)')
									END
		FROM @i_xml.nodes('/GetItems')  T(col)
		IF object_id('tempdb.dbo.#tblGetGroupingItem') is not null
			DROP TABLE #tblGetGroupingItem
		CREATE TABLE #tblGetGroupingItem (rowId INT IDENTITY(1,1), value NVARCHAR(MAX), countVal BIGINT)
		SET @sqlCmd = 'INSERT INTO #tblGetGroupingItem
					SELECT  CASE LEN(ISNULL(' + @i_groupByclause +',''''))
						WHEN 0 THEN ''N/A''
						ELSE '+ @i_groupByclause +'
						END AS "value",
						COUNT_BIG(*) AS "countVal"
					 FROM  DMLegalHoldItemsToBackup AS LH
						WHERE ISNULL(LH.ResultSetID, '''') <> '''' AND LH.CompPolicyId = '''+@i_containerId +''''
	IF @fetchEmail = 0 OR @fetchFiles = 0
			SET @sqlCmd = @sqlCmd + ' AND LH.AppType IN (SELECT AT.AppTypeId
							FROM DMUIAppTypeMap AS AT
							WHERE AT.IsEmailAppType = '+ @fetchEmail +
							' OR AT.IsFileAppType = '+  @fetchFiles +') '
		IF(LEN(ISNULL(@i_backupStatus,''))>0)
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_backupStatus
		IF(LEN(ISNULL(@i_whereClause,''))>0)
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_whereClause
		--	set grouping Clause
		SET @sqlCmd = @sqlCmd + ' GROUP BY CASE LEN(ISNULL(' + @i_groupByclause +',''''))
						WHEN 0 THEN ''N/A''
						ELSE '+ @i_groupByclause +'
						END
						ORDER BY '+@i_orderByClause
		IF(@i_debug = 1)
			SELECT @sqlCmd
		EXECUTE (@sqlCmd)
		SELECT @o_groupingCount = MAX(T.rowId)
		FROM #tblGetGroupingItem AS T
		IF(@o_groupingCount > 0)
		BEGIN
			--Paging config
			SELECT @StartRN = CASE WHEN @StartRN <= 0 THEN 1
									ELSE @StartRN
								END,
					@pageCount = CASE WHEN @pageCount < 0 THEN 0
									ELSE @pageCount
								END,
					@EndRN = CASE WHEN @pageCount <= 0 THEN @o_groupingCount
									ELSE (@pageCount+ @StartRN -1)
								END
			SET @o_groupingXml =
					(SELECT T.value,T.countVal
			FROM #tblGetGroupingItem AS T
			WHERE T.rowId BETWEEN @StartRN AND @EndRN
			ORDER BY T.rowId
					FOR XML RAW('Items'),ROOT('GetItems_Grouping'))
		END
		DROP TABLE #tblGetGroupingItem
	END
	--If empty XML to be returned
	IF(LEN(ISNULL(@o_groupingXml,'')) = 0)
	BEGIN
		SET @o_groupingXml =
				(SELECT '<GetItems_Grouping />')
	END
	IF(LEN(ISNULL(@o_localGroupingXml,'')) = 0)
	BEGIN
		SET @o_localGroupingXml =
				(SELECT '<GetItems_Grouping />')
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetLegalHoldItemsWithGrouping')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldItemsWithGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldItemsWithGrouping')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldItemsWithGrouping'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetLegalHoldItemsWithGrouping',  '00010006000000000000', 'sp_dm2_GetLegalHoldItemsWithGrouping', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetWithGrouping.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetWithGrouping.sp,v $ $Id: sp_dm2_GetResultSetWithGrouping.sp,v 1.15 2015/04/16 18:52:07 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultSetWithGrouping <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultSetWithGrouping')
	drop procedure sp_dm2_GetResultSetWithGrouping
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultSetWithGrouping')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetWithGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetWithGrouping')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetWithGrouping'
GO
print '... Creating Procedure: sp_dm2_GetResultSetWithGrouping'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultSetWithGrouping
  @i_xml XML ,
  @o_resultItemsCount BIGINT OUTPUT,
  @o_groupingCount BIGINT OUTPUT,
  @o_localGroupingXml NVARCHAR(MAX) OUTPUT,
  @o_groupingXml NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	/*
	This sp would return ResultItems in the container along with grouping info. This can be invoked under below cases
		1. Get ResultItems only
		2. ResultItems + LocalGrouping Only
		3. Grouping Only
		4. ResultItems + LocalGrouping + Grouping Tables.
	Seperate paging config can be provided for both the ResultItems and Grouping table. However the localGrouping table will not honor any paging config
	Input:
	1.@i_XML
		Sample XML --
		<GetItems containerId="08D07D0D-7E9C-4981-892F-FBCC7ACC0D5B" ignoreResultItems="0" ignoreGrouping="0"
				whereCondition=" (  OwnerField  IN (''Kamal Hasan'',''Sruthi Hasan'') ) ">
			<Grouping groupByClause="OwnerField" orderByClause="" pageSize="200" startIndex="0" fetchEmails="1" fetchFiles="1" />
			<ResultItems orderByClause="" pageSize="220" startIndex="0" fetchEmails="1" fetchFiles="1" />
		</GetItems>
	2. @o_resultItemsCount
		Output variable which have total count of ResultItem for that criteria
	3. @o_groupingCount
		Output variable holding total count of Grouping for input criteria
	4. @o_localGroupingXml
		Output variable. This contain the XML blob of the local grouping info
	5. @o_groupingXml
		Output variable. This contain the XML blob of the grouping info
	Output:
	this would return ResultItem table and the XML(formatted table) blob.
	1. ResultItems table
		if (ignoreResultItems=0) then
			Return ResultItems
		else
			Return empty table
	2. localGrouing (Grouping details for the ResultItems table that is returned)   --XML
		if (ignoreResultItems=0 and LEN(groupByClause) > 0) then
			return o_localGroupingXml
		Else
			return empty XML
	3. Grouping table (Groupind details for the entire criteria NOT specific to ResultItem table)  --XML
		if(ignoreGrouping = 0 and LEN(groupByClause) > 0) then
			return o_groupingXml
		Else
			return empty XML
	Sample XML format of output variable:
		<GetItems_Grouping>
			<Items value="Administrator" countVal="5"/>
			<Items value="Arun P. Amarendran" countVal="8"/>
			<Items value="Shivaji Rao" countVal="4"/>
			<Items value="Sruthi Hasan" countVal="4"/>
		  </GetItems_Grouping>
	*
	*
	****/
	--reset Output variables
	SELECT @o_groupingCount = 0, @o_resultItemsCount = 0,
			@o_localGroupingXml = '',@o_groupingXml = ''
	--local variables
	DECLARE @i_ignoreResultItems BIT = 0,
			@i_ignoreGrouping BIT = 0,
			@i_containerId VARCHAR(36),
			@i_whereClause	NVARCHAR(MAX),
			@i_groupByclause VARCHAR(50),
			@i_orderByClause VARCHAR(50),
			@sqlCmd NVARCHAR(MAX) = '',
			@fetchEmail CHAR(1) = '1',
			@fetchFiles	CHAR(1)	= '1',
			@StartRN	INTEGER = 0,
			@pageCount	INTEGER = 0,
			@EndRN	INTEGER = -1,
			@i_debug	BIT = 0,
			@returnEmptyResultItemTable BIT = 1,
			@ParmDefinition		NVARCHAR(MAX),
			@i_ForRestoreFlag	INT = 0,
			@idxSyncInterval int = 1,
			@CaseStmtForGrouping nvarchar(max),
			@UserTagIDs varchar(max) = '',
			@whereClauseTags varchar(max) = '',
			@whereClauseTagsForGrouping varchar(max) = ''
	--parse the input XML to get required field only
	SELECT	@i_containerId = ISNULL(T.col.value('@containerId','VARCHAR(36)'),''),
			@i_ignoreResultItems = ISNULL(T.col.value('@ignoreResultItems','BIT'),0),
			@i_ignoreGrouping = ISNULL(T.col.value('@ignoreGrouping','BIT'),0),
			@i_whereClause = ISNULL(T.col.value('@whereCondition','NVARCHAR(MAX)'),''),
			@i_groupByclause = ISNULL(T.col.value('Grouping[1]/@groupByClause','VARCHAR(50)'),''),
			@i_debug = ISNULL(T.col.value('@debug','BIT'),0),
			@i_ForRestoreFlag = ISNULL(T.col.value('@forRestore', 'INT'), 0),
			@UserTagIDs = ISNULL(T.col.value('@allUserTagIdList', 'varchar(max)'),''),
			@whereClauseTags = ISNULL(T.col.value('@tagIdWhereClause', 'varchar(max)'),''),
			@whereClauseTagsForGrouping = ISNULL(T.col.value('@tagIdWhereClauseForGrouping', 'varchar(max)'),'')
	FROM @i_xml.nodes('/GetItems')  T(col)
	-------++++++++++Case when GResultItems will be returned++++++++-------
	IF(@i_ignoreResultItems = 0)
	BEGIN
		--get the apptype filter and other info
		SELECT	@fetchEmail= ISNULL(T.col.value('@fetchEmails','VARCHAR(1)'),'1'),
				@fetchFiles= ISNULL(T.col.value('@fetchFiles','VARCHAR(1)'),'1'),
				@StartRN = 	ISNULL(T.col.value('@startIndex','INTEGER'),0),
				@pageCount = ISNULL(T.col.value('@pageSize','INTEGER'),0),
				@i_orderByClause = CASE LEN(ISNULL(T.col.value('@orderByClause','VARCHAR(50)'),''))
										WHEN 0 THEN 'DMContainerItem.CreateTime DESC'
										ELSE T.col.value('@orderByClause','VARCHAR(50)')
									END
		FROM @i_xml.nodes('/GetItems/ResultItems[1]')  T(col)
		--Get the total count
		--since the query is common to get the total count and the retrival on pagination.
		-- create string accordingly
		DECLARE @middleWhereClause NVARCHAR(MAX)= '';
		--DECLARE @tempAppTypeTable NVARCHAR(MAX) = '';
		DECLARE @totalCount INT = 0;
		DECLARE @dynamicparamdec AS NVARCHAR(1000);
		IF NOT(@fetchEmail = '1' AND @fetchFiles = '1')
		BEGIN
			CREATE TABLE #tblAppType (AppType INT );
			CREATE UNIQUE CLUSTERED INDEX IDX_tempTblAppType ON #tblAppType (AppType)
			INSERT INTO #tblAppType
			 SELECT distinct AppTypeId
							FROM DMUIAppTypeMap AS AT
				 WHERE AT.IsEmailAppType = @fetchEmail
					OR AT.IsFileAppType = @fetchFiles
		END
		DECLARE @extraJoin nvarchar(max) = ''
		IF (@fetchEmail = '1' AND @fetchFiles = '0')--email view special join for sorting..
		BEGIN
			SET @extraJoin = ' LEFT JOIN DMEmailResult ON DMResultSet.ResultSetID = DMEmailResult.ResultSetID '
		END
		SET @middleWhereClause = 'FROM DMResultSet AS DMResultSet WITH (READUNCOMMITTED)
						INNER JOIN DMContainerItem AS DMContainerItem WITH (READUNCOMMITTED)
						ON	DMResultSet.ResultSetID = DMContainerItem.ResultSetID AND (DMContainerItem.Attribute & 4) = 0 '
		--if both email and files are enabled, AppType check is unnecessary
		--Also this check must be inline with inner join so that left join may not cause issue
		IF NOT(@fetchEmail = '1' AND @fetchFiles = '1')
			SET @middleWhereClause = @middleWhereClause + '  AND DMResultSet.AppType IN (SELECT AT.AppType
													FROM #tblAppType AS AT) '
		--check if the value is empty or has empty space only
		--Filter condition was becoming unuseful because of left join, so filter condition is being made to go inline with inner join
		IF(LEN(LTRIM(ISNULL(@i_whereClause,'')))>0 )
		BEGIN
			SET @middleWhereClause = @middleWhereClause + ' AND ' + @i_whereClause
		END
		IF (LEN(LTRIM(ISNULL(@extraJoin,'')))>0 )
		BEGIN
			SET @middleWhereClause = @middleWhereClause + @extraJoin
		END
		SET @middleWhereClause = @middleWhereClause + ' WHERE (LEN(''' + @i_ContainerID + ''') = 0
									or (DMContainerItem.ContainerID = ''' + @i_ContainerID + '''))'
		IF LTRIM(RTRIM(ISNULL(@whereClauseTags, ''))) <> ''
		BEGIN
			SET @middleWhereClause = @middleWhereClause + ' AND ' + @whereClauseTags
		END
		SET @sqlCmd = ' SELECT  @totalCount = COUNT(DMContainerItem.ResultSetID) ' + @middleWhereClause
		SET @dynamicparamdec = ' @totalCount INT OUTPUT '
		IF(@i_debug = 1)
			SELECT @sqlCmd 'totalCountSQLCMD'
		EXECUTE sp_executesql  @sqlCmd
                               ,@dynamicparamdec
                               ,@totalCount output
		--Now reset the @sqlCmd, so that it can be used for retrieving the resultItems..
		--aling with total count.
		SELECT @sqlCmd = '',@o_resultItemsCount = @totalCount
		IF(@o_resultItemsCount > 0)
		BEGIN
			--Paging config
			SELECT @StartRN = CASE WHEN @StartRN <= 0 THEN 1
									ELSE @StartRN
								END,
					@pageCount = CASE WHEN @pageCount < 0 THEN 0
									ELSE @pageCount
								END,
					@EndRN = CASE WHEN @pageCount <= 0 THEN @o_resultItemsCount
									ELSE (@pageCount+ @StartRN -1)
								END
		IF object_id('tempdb.dbo.#tblGetContainerItem') is not null
			DROP TABLE #tblGetContainerItem
		CREATE TABLE #tblGetContainerItem
		(
			rowId INT,
			ResultSetID VARCHAR(36),
			--UserComments NVARCHAR(MAX),
			Attribute INT,
			CreateTime DATETIME,
			ContainerItemID INT,
		)
		-- Construct the select query.
		SET @sqlCmd = N';WITH AllResults AS
						(	SELECT TOP (@EndRN)
							ROW_NUMBER() OVER (ORDER BY ' + @i_OrderByClause +') AS row ,
								DMContainerItem.ResultSetID,DMContainerItem.Attribute,DMContainerItem.CreateTime, DMContainerItem.ID AS ContainerItemID '
		--Since we have constructed the where clause already we reuse it.
		SET @sqlCmd = @sqlCmd + @middleWhereClause
		-- output from the CTE.
		SET @sqlCmd = @sqlCmd + ')INSERT INTO #tblGetContainerItem
							SELECT  V.row,V.ResultSetID,V.Attribute,V.CreateTime,V.ContainerItemID
								FROM AllResults AS V
								where V.row >= @StartRN '
		SET @ParmDefinition = N'@EndRN INTEGER,@StartRN INTEGER'
		IF(@i_debug = 1)
			SELECT @sqlCmd 'ResultItemSQLCMD'
		EXEC sp_executesql @sqlCmd,@ParmDefinition,@EndRN,@StartRN
		IF(@i_debug = 1)
			SELECT * FROM #tblGetContainerItem
		/*@karthik
		  Usercomments will be returned in the metadata response or in the retrieved via seperate call
		  **/
		--IF len(@i_ContainerID) > 0
--		BEGIN
--			UPDATE #tblGetContainerItem
--			SET UserComments =
--				(SELECT TOP 1 ISNULL(UC.Comment, '')
--				FROM DMUserComment UC
--					 WHERE  UC.ResultSetID = #tblGetContainerItem.ResultSetID
--						AND UC.ContainerID = @i_ContainerID
--				ORDER BY UC.CreateTime desc)
--		END
			SELECT	RS.ResultSetID,RS.CommCellNumber,RS.aFileID,RS.aFileOffset,
					RS.aFileLength,RS.AppType,RS.FileSizeKB,RS.ModifiedTime,
					RS.JobId,RS.OriginalFullPath,RS.DestinationPath,RS.CreateTime,
					RS.RestoreUserGUID,RS.RestoreJobID,RS.RestoreStatus,
					RS.RestoreTime,RS.Attribute,
					RS.documentID,RS.ClientID,
					RSI.ResultSet, '' AS "UserComments",
					T.Attribute AS ItemAttribute, T.CreateTime AS ItemAdded, T.ContainerItemID
			FROM #tblGetContainerItem AS T
					INNER JOIN
				DMResultSet AS RS WITH (NOLOCK)
				ON RS.ResultSetID = T.ResultSetID
					INNER JOIN
				DMResultSetInfo AS RSI  WITH (NOLOCK)
				ON RS.ResultSetID = RSI.ResultSetID
			ORDER BY T.rowId
			DROP TABLE #tblGetContainerItem
			--reset empty table as false
			SET @returnEmptyResultItemTable = 0
			----+++++ localGrouping table WILL NOT BE RETURNED..+++++------
			-- NO PROCESSING IS REQUIRED FOR LOCAL GROUPING --
		END
	END
	---------+++++++++++++If empty table has to be returned for ResultItems+++++++++++++-------------
	IF(@returnEmptyResultItemTable = 1)
	BEGIN
		SELECT RS.*, ''  AS "ResultSet"
		FROM DMResultSet AS RS WITH (READUNCOMMITTED)
		 WHERE 1= 2
	END
	---------++++++++++++Case when GroupingItems to be returned+++++++++++++++------------------
	IF(@i_ignoreGrouping = 0 AND LEN(@i_groupByclause) > 0)
	BEGIN
		--Grouping on aFileID is only done by restore code to determine invalid aFileIDs. No point in returning the ones already existing in DMPrunedArchFile
		IF charindex('aFileID', @i_groupByclause) > 0 AND LEN(ISNULL(@i_whereClause, '')) > 0
		BEGIN
			SET @i_whereClause = @i_whereClause + ' AND aFileID NOT IN (SELECT ArchFileId FROM DMPrunedArchFile) '
		END
		--get the apptype filter and other info
		SELECT	@fetchEmail= ISNULL(T.col.value('Grouping[1]/@fetchEmails','VARCHAR(1)'),'1'),
				@fetchFiles= ISNULL(T.col.value('Grouping[1]/@fetchFiles','VARCHAR(1)'),'1'),
				@StartRN = 	ISNULL(T.col.value('Grouping[1]/@startIndex','INTEGER'),0),
				@pageCount = ISNULL(T.col.value('Grouping[1]/@pageSize','INTEGER'),0),
				@i_orderByClause = CASE LEN(ISNULL(T.col.value('Grouping[1]/@orderByClause','VARCHAR(50)'),''))
										WHEN 0 THEN 'countVal DESC'
										ELSE T.col.value('Grouping[1]/@orderByClause','VARCHAR(50)')
									END
		FROM @i_xml.nodes('/GetItems')  T(col)
		IF object_id('tempdb.dbo.#tblGetGroupingItem') is not null
			DROP TABLE #tblGetGroupingItem
		CREATE TABLE #tblGetGroupingItem (rowId INT IDENTITY(1,1), value NVARCHAR(max), countVal BIGINT )
		IF @i_groupByclause IS NOT NULL AND CHARINDEX('RestoreStatus', @i_groupByclause) > 0
		BEGIN
			SET @CaseStmtForGrouping = '
				 CASE RestoreStatus WHEN 7 THEN 5 ELSE RestoreStatus END '
		END
		ELSE
		BEGIN
			SET @CaseStmtForGrouping = '
				  CASE LEN(ISNULL(' + @i_groupByclause +',''''))
					WHEN 0 THEN ''N/A''
					ELSE '+ @i_groupByclause +'
				END'
		END
		SET @sqlCmd = 'INSERT INTO #tblGetGroupingItem
						SELECT ' + @CaseStmtForGrouping + ' AS "value",
						COUNT_BIG(*) AS "countVal"
					 FROM DMContainerItem AS DMContainerItem WITH (READUNCOMMITTED) INNER JOIN
						DMResultSet AS DMResultSet WITH (READUNCOMMITTED)
					ON	DMResultSet.ResultSetID = DMContainerItem.ResultSetID AND
						DMResultSet.AppType
						IN (SELECT AT.AppTypeId
							FROM DMUIAppTypeMap AS AT
							WHERE AT.IsEmailAppType = '+ @fetchEmail +
							' OR AT.IsFileAppType = '+  @fetchFiles +')'
		IF @i_groupByclause IS NOT NULL AND CHARINDEX('TagID', @i_groupByclause) > 0
		BEGIN
			SET @sqlCmd += '
				JOIN DMContainerItemStates WITH (READUNCOMMITTED) ON DMContainerItem.ContainerID = DMContainerItemStates.ContainerID AND DMContainerItem.ResultSetID = DMContainerItemStates.ResultSetID AND DMContainerItemStates.Attribute & 4 = 0
				JOIN DMContainerItemTags WITH (READUNCOMMITTED) ON DMContainerItemTags.AssignID = DMContainerItemStates.AssignID'
			IF ISNULL(@UserTagIDs, '') <> ''
			BEGIN
				SET @sqlCmd += '
					JOIN dbo.splitStringToTable(''' + @UserTagIDs + ''') TagsTemp ON TagsTemp.ID = DMContainerItemTags.TagID'
			END
		END
		SET @sqlCmd += ' WHERE (LEN(''' + @i_ContainerID + ''') = 0 or (DMContainerItem.ContainerID = ''' + @i_ContainerID + '''))
							AND (DMContainerItem.Attribute & 4) = 0 '
		IF LTRIM(RTRIM(ISNULL(@whereClauseTagsForGrouping, ''))) <> ''
		BEGIN
			SET @sqlCmd = @sqlCmd + ' AND ' + @whereClauseTagsForGrouping
		END
		IF(LEN(ISNULL(@i_whereClause,''))>0)
		BEGIN
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_whereClause
		END
		--	set grouping Clause
			SET @sqlCmd = @sqlCmd + ' GROUP BY ' + @CaseStmtForGrouping + ' ORDER BY '+@i_orderByClause
		IF(@i_debug = 1)
			SELECT @sqlCmd
		EXECUTE (@sqlCmd)
		SELECT @o_groupingCount = MAX(T.rowId)
		FROM #tblGetGroupingItem AS T
		IF(@o_groupingCount > 0)
		BEGIN
			--Paging config
			SELECT @StartRN = CASE WHEN @StartRN <= 0 THEN 1
									ELSE @StartRN
								END,
					@pageCount = CASE WHEN @pageCount < 0 THEN 0
									ELSE @pageCount
								END,
					@EndRN = CASE WHEN @pageCount <= 0 THEN @o_groupingCount
									ELSE (@pageCount+ @StartRN -1)
								END
			SET @o_groupingXml =
					(SELECT T.value,T.countVal
			FROM #tblGetGroupingItem AS T
			WHERE T.rowId BETWEEN @StartRN AND @EndRN
			ORDER BY T.rowId
					For XML RAW('Items'),ROOT('GetItems_Grouping'))
		END
		DROP TABLE #tblGetGroupingItem
	END
	--If empty XML to be returned
	IF(LEN(ISNULL(@o_groupingXml,'')) = 0)
	BEGIN
		SET @o_groupingXml =
				(SELECT '<GetItems_Grouping />')
END
	IF(LEN(ISNULL(@o_localGroupingXml,'')) = 0)
	BEGIN
		SET @o_localGroupingXml =
				(SELECT '<GetItems_Grouping />')
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultSetWithGrouping')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetWithGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetWithGrouping')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetWithGrouping'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultSetWithGrouping',  '00010015000000000000', 'sp_dm2_GetResultSetWithGrouping', '00010015000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneDMLegalHoldItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneDMLegalHoldItems.sp,v $ $Id: sp_dm2_PruneDMLegalHoldItems.sp,v 1.3 2014/06/24 06:26:37 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneDMLegalHoldItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneDMLegalHoldItems')
	drop procedure sp_dm2_PruneDMLegalHoldItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneDMLegalHoldItems')
	delete from GxQscripts where name = 'sp_dm2_PruneDMLegalHoldItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneDMLegalHoldItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneDMLegalHoldItems'
GO
print '... Creating Procedure: sp_dm2_PruneDMLegalHoldItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneDMLegalHoldItems
  @i_CompPolicyId VARCHAR(36) = '',
  @i_JobId INT = 0,
  @i_batchFetchCount INT = 0,
  @i_debug INT = 0  --this should be the last param.
AS
SET NOCOUNT ON
		--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		--			   Stored Procedure For Pruning DMLegalHoldItemsToBackup			--
		--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		/*****************************************************************
		*
		*
		*
			This stored procedure doesnt have any mandatory parameters.
			Below are optional params which can be used to constraint the pruning criteria..
					@i_CompPolicyId - Prune for any specific CompPolicy Id.
					@i_JobId -- Prune for any particular job
					@i_batchFetchCount --By default 1000 items would be processed,
										for powerful machines, it can be increased accordingly
					@i_debug --Enabling would print the details of items deleted .Useful when invoked explicitly
			The criteria for deleting duplicate entries are as follows.
				1.	For a tuple(JobId,CompPolicyId,ResultSetId) only one entry should exists in the table
				2.	If multiple entries are found for a tuple, then
				3.	If any entries exists with BackupStatus = Completed(1)
					a.	Delete remaining entries with other BackupStatus
					b.	If more than one items exists with Same BackupStatus (in this case Completed)
						i.	Retain the first row with latest modified time and delete others
				4.	Else If any entries exists with BackupStatus = Not Submitted
					a.	Perform 3.a and 3.b
				5.	Else
					a.	Duplicate entries are found for Status In Processing.
					b.	Perform 3.b
			*
			*
			*********************************/
	BEGIN TRY
		--Declare variables
		DECLARE @contOuterloop INT,
				@totalCount	BIGINT,
				@errorCode	INTEGER,
				@rowsAffected	INT,
				@incr		INT,
				@tempStr	NVARCHAR(MAX)
		--Set default values
		SET @contOuterloop = 1
		SET @totalCount = 0
		SET	@errorCode	= 0
		SET @incr = 0
		SET @tempStr = ''
		--CHECK Batch COUNT value is <= 1000
		IF(@i_batchFetchCount < 1000)
			SET @i_batchFetchCount = 1000
		IF( @i_debug = 1)
		BEGIN
			SET @tempStr  = 'Total Count : '+ (SELECT CONVERT(NVARCHAR(MAX),COUNT_BIG(CompPolicyId))
											   FROM DMLegalHoldItemsToBackup WITH (READUNCOMMITTED))
			PRINT @tempStr
		END
		--This loop will continue until there is no duplicate entries for the same tuple
		WHILE(@contOuterloop = 1)
		BEGIN
			-- Assign default values before the loop starts
			SET @incr = @incr+1
			IF object_id('tempdb.dbo.#tmpLHTable') IS NOT null
				DROP TABLE #tmpLHTable
			CREATE TABLE #tmpLHTable
			(
				JobId INT,
				CompPolicyId CHAR(36),
				ResultSetID CHAR(36)
			);
			--Create index on the temp tables
			CREATE INDEX idx_tmpLHTable
			ON #tmpLHTable (ResultSetID,JobId, CompPolicyId )
			--Perform operation batch (Retrieve only @i_batchFetchCount items at atime)
			INSERT INTO #tmpLHTable
			SELECT TOP (@i_batchFetchCount) A.JobId, A.CompPolicyId,A.ResultSetID
			FROM DMLegalHoldItemsToBackup A WITH (READUNCOMMITTED)
			WHERE A.JobId>0 AND (@i_JobId= 0 OR (A.JobId = @i_JobId)) AND
				LEN(ISNULL(A.CompPolicyId,''))> 0 AND
				LEN(ISNULL(A.ResultSetID,''))> 0 AND (LEN(ISNULL(@i_CompPolicyId,''))=0 OR A.CompPolicyId = @i_CompPolicyId)
				GROUP BY A.JobId, A.CompPolicyId,A.ResultSetID
				HAVING COUNT(*) > 1
			--Check the temp table has valid number of rows
			IF ((SELECT COUNT(CompPolicyId) FROM #tmpLHTable) = 0)
				BREAK;
			IF(@i_debug = 1)
			BEGIN
				SET @tempStr  = CONVERT(NVARCHAR(MAX),@incr) + '. Cnt [ ' +
					(SELECT CONVERT(NVARCHAR(MAX),COUNT_BIG(*)) FROM #tmpLHTable WITH (READUNCOMMITTED)) + ' ]'
				PRINT  @tempStr
			END
			---drop the temp table if exists
			IF object_id('tempdb.dbo.#tmpLHTable2') IS NOT null
				DROP TABLE #tmpLHTable2
			CREATE TABLE #tmpLHTable2
			(
				JobId INT,
				CompPolicyId CHAR(36),
				ResultSetID CHAR(36),
				BackupStatus INT,
				ModifiedTime DATETIME
			);
			CREATE INDEX idx_tmpLHTable2
			ON #tmpLHTable2 (ResultSetID,JobId, CompPolicyId )
			--#tmpLHTable2 will hold the BackUpstatus,ModifiedTime and the tuple to have quick reference for manipulation
			INSERT INTO #tmpLHTable2 (JobId,CompPolicyId,ResultSetID,BackupStatus,ModifiedTime)
			SELECT A.JobId, A.CompPolicyId,A.ResultSetID,A.BackupStatus,A.ModifiedTime
				FROM DMLegalHoldItemsToBackup A WITH (READUNCOMMITTED)
						INNER JOIN #tmpLHTable B WITH (READUNCOMMITTED)
				ON A.JobId = B.JobId
					AND A.CompPolicyId = B.CompPolicyId
					AND	A.ResultSetID = B.ResultSetID
				ORDER BY A.ResultSetID,A.JobId,A.CompPolicyId
			IF(@i_debug = 1)
			BEGIN
				SET @tempStr  = '	Temp table2 Count : [ ' +
					(SELECT CONVERT(NVARCHAR(MAX),COUNT_BIG(*)) FROM #tmpLHTable2 WITH (READUNCOMMITTED)) + ' ]'
				PRINT  @tempStr
			END
			--local variables
			DECLARE @deletedRows INT = 0,
					@tempRowsCount INT = 0
			--------+++++++++++ Begin Transaction++++++++++-------------
			BEGIN TRAN
			WHILE((SELECT COUNT(JobId) FROM #tmpLHTable2) > 0)
			BEGIN
				DECLARE @cJobId			INT,
						@cCompPolicyId	VARCHAR(36),
						@cResultSetId	VARCHAR(36),
						@Status INT = 2
				SELECT TOP 1 @cJobId = T.JobId,
						@cCompPolicyId = T.CompPolicyId,
						@cResultSetId = T.ResultSetID
				FROM #tmpLHTable2 AS T
				--CREATE A TEMP TAble FRO
				IF object_id('tempdb.dbo.#tmpLHTable3') IS NOT null
					DROP TABLE #tmpLHTable3
				CREATE TABLE #tmpLHTable3
				(
					ResultSetID CHAR(36),
					BackupStatus INT,
					ModifiedTime DATETIME
				);
				INSERT INTO #tmpLHTable3
				SELECT T.ResultSetID,T.BackupStatus,T.ModifiedTime FROM #tmpLHTable2 AS T
				WHERE	T.JobId = @cJobId AND
						T.CompPolicyId = @cCompPolicyId AND
						T.ResultSetID = @cResultSetId
				IF EXISTS (SELECT ResultSetID FROM #tmpLHTable3
							 WHERE BackupStatus = 1)
				BEGIN
					SET @Status = 1
				END
				ELSE IF EXISTS (SELECT ResultSetID FROM #tmpLHTable3
									WHERE BackupStatus = 0)
				BEGIN
					SET @Status = 0
				END
				IF(@status != 2)
				BEGIN
					--delete all other rows
					DELETE DMLegalHoldItemsToBackup
					WHERE	JobId = @cJobId AND
							CompPolicyId = @cCompPolicyId AND
							ResultSetID = @cResultSetId AND
							BackupStatus != @status
					SELECT 	@errorCode	=	@@ERROR, @tempRowsCount = @@ROWCOUNT
					IF	@errorCode != 0
						GOTO CX_EXIT
					SET @deletedRows = @deletedRows + @tempRowsCount
					DELETE  #tmpLHTable3
					WHERE	BackupStatus != @status
				END
				-- duplicate entries exists for same status
				-- delete all retaining one
				IF((SELECT COUNT(ResultSetID) FROM #tmpLHTable3) > 1)
				BEGIN
					DECLARE @maxCount INT = 0
					DECLARE @date DATETIME = NULL
					SELECT TOP 1 @maxCount= COUNT(*),@date = ModifiedTime from #tmpLHTable3
					GROUP BY ModifiedTime ORDER BY ModifiedTime DESC
					--If more than one items exists with MAX(modifiedTime)
					-- delete all retaining only one
					IF(@maxCount > 1)
					BEGIN
						DELETE TOP (@maxCount-1) FROM DMLegalHoldItemsToBackup
						WHERE	JobId = @cJobId AND
								CompPolicyId = @cCompPolicyId AND
								ResultSetID = @cResultSetId AND
								ModifiedTime = @date
						SELECT 	@errorCode	=	@@ERROR, @tempRowsCount = @@ROWCOUNT
						IF	@errorCode != 0
							GOTO CX_EXIT
						SET @deletedRows = @deletedRows + @tempRowsCount
					END
					DELETE FROM DMLegalHoldItemsToBackup
					WHERE	JobId = @cJobId AND
							CompPolicyId = @cCompPolicyId AND
							ResultSetID = @cResultSetId AND
							ModifiedTime != @date
					SELECT 	@errorCode	=	@@ERROR, @tempRowsCount = @@ROWCOUNT
					IF	@errorCode != 0
						GOTO CX_EXIT
					SET @deletedRows = @deletedRows + @tempRowsCount
				END
				--DELETE FROM #tmpLHTable2
				DELETE #tmpLHTable2
				WHERE	ResultSetID = @cResultSetId AND
						CompPolicyId = @cCompPolicyId AND
						JobId = @cJobId
				DROP TABLE #tmpLHTable3
			END
			--------+++++++++++ Commit Transaction++++++++++-------------
			COMMIT TRAN
			IF(@i_debug = 1)
			BEGIN
				SET @tempStr  = '	BatchRows Deleted : [ ' + CONVERT(NVARCHAR(MAX),@deletedRows) + ' ]'
				PRINT @tempStr
			END
			SET @totalCount = @totalCount + @deletedRows
			--- if the count of #tmpLHTable is less than @i_batchFetchCount. No further items exists
			IF( (SELECT COUNT(*) FROM #tmpLHTable) < @i_batchFetchCount)
				SET @contOuterloop = 0
		END
		IF(@i_debug = 1)
		BEGIN
			SET @tempStr  = '	Total Rows Deleted : [ ' + CONVERT(NVARCHAR(MAX),@totalCount) + ' ]'
			PRINT @tempStr
		END
		IF(@@TRANCOUNT > 0 AND XACT_STATE() <> 0)
		BEGIN
			COMMIT TRAN;
		END
		print 'Total items deleted : ' + CONVERT(NVARCHAR(MAX),@totalCount)
		IF object_id('tempdb.dbo.#tmpLHTable') IS NOT null
			DROP TABLE #tmpLHTable
		IF object_id('tempdb.dbo.#tmpLHTable2') IS NOT null
			DROP TABLE #tmpLHTable2
		IF object_id('tempdb.dbo.#tmpLHTable3') IS NOT null
			DROP TABLE #tmpLHTable3
	CX_EXIT:
		IF (@errorCode != 0)
		BEGIN
			PRINT 'Completed With Error [ '+ 	CONVERT(NVARCHAR(MAX),@errorCode) + ' ]';
			IF(XACT_STATE() <> 0)
			BEGIN
				ROLLBACK TRAN;
				PRINT 'Transcation Rollbacked due to Error'
			END
		END
		ELSE
		BEGIN
			PRINT 'Completed Successfully';
		END
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		-- Rollback any active or uncommittable transactions
		PRINT 'Error Code   : '+ CONVERT(NVARCHAR(MAX),ERROR_NUMBER() )
	    PRINT 'Error Message: '+ ERROR_MESSAGE()
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRAN;
			PRINT 'Transcation Rollbacked due to Exception'
		END
	END CATCH;
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneDMLegalHoldItems')
	delete from GxQscripts where name = 'sp_dm2_PruneDMLegalHoldItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneDMLegalHoldItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneDMLegalHoldItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneDMLegalHoldItems',  '00010003000000000000', 'sp_dm2_PruneDMLegalHoldItems', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemsForGroupingInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetResultItemsForGroupingInfo()
--  | Description:
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemsForGroupingInfo.sp,v $ $Id: sp_dm2_GetResultItemsForGroupingInfo.sp,v 1.2 2012/08/06 15:32:09 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultItemsForGroupingInfo <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultItemsForGroupingInfo')
	drop procedure sp_dm2_GetResultItemsForGroupingInfo
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultItemsForGroupingInfo')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemsForGroupingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemsForGroupingInfo')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemsForGroupingInfo'
GO
print '... Creating Procedure: sp_dm2_GetResultItemsForGroupingInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultItemsForGroupingInfo
  @downloadId CHAR(36),
  @groupByValue NVARCHAR(MAX),
  @startIndex BIGINT = 0,
  @pageSize BIGINT = -1
AS
	SET NOCOUNT ON
	/*
		Usage:
			This Sp returns list of resultItem details for the input downloadId and groupByValue.. This SP can also be used to get items based on pagination..
			Attribute field is used to store the grouping field info..
				FolderPath --> POWER(2,14) [15th bit]
				OwnerField --> POWER(2,15) [16th bit]
	**/
	DECLARE @returnEmptyTable BIT = 1
	IF(LEN(ISNULL(@groupByValue,N''))>0  AND  LEN(ISNULL(@downloadId,''))>0 )
	BEGIN
		DECLARE @attribute INT = 0
		DECLARE @groupByClause VARCHAR(50) = ''
		DECLARE @sql NVARCHAR(MAX) = ''
		DECLARE @whereClause	NVARCHAR(MAX) = ''
		DECLARE @isPaginingEnabled BIT = 0
		IF(@startIndex <= 0)
			SET @startIndex = 1
		SELECT @attribute = Attribute
		FROM DMDownload WHERE DownLoadID = @downloadId
		IF(@attribute & POWER(2,14) > 0)
			SET @groupByClause = 'FolderPath'
		ELSE IF(@attribute & POWER(2,15) > 0)
			SET @groupByClause = 'OwnerField'
		IF(LEN(ISNULL(@groupByClause,''))>0)
		BEGIN
			IF(@groupByValue = N'Not-Available')
			BEGIN
				SET @whereClause = '(LEN(ISNULL('+@groupByClause+' ,'''')) = 0 ) '
			END
			ELSE
			BEGIN
				SET @whereClause = '(' + @groupByClause + ' = N''' + @groupByValue + ''' )'
			END
			SET @sql = 'SELECT A.DownloadID,A.ResultSetID,A.AppType,
							A.Status,A.CreateTime,A.FileName,A.DestinationPath
							FROM (
								SELECT D.DownloadID,D.ResultSetID,D.AppType,
										D.Status,D.CreateTime,ISNULL(D.FileName,'''') AS FileName,
										RS.DestinationPath,ROW_NUMBER() OVER (ORDER BY D.CreateTime ASC ) AS "RowNumber"
								FROM	DMDownloadResultSet AS D  WITH (NOLOCK)
											INNER JOIN
										DMResultSet AS RS WITH (NOLOCK)
								ON D.ResultSetID = RS.ResultSetID
								WHERE  D.DownLoadID = '''+@downloadId +''' AND ' +
									@whereClause +
							') AS A WHERE A.RowNumber >= ' + (CONVERT (VARCHAR(8),@startIndex))
			IF(@pageSize > 1)
				SET @sql = @sql +' AND A.RowNumber <'+ (CONVERT (VARCHAR(8),(@startIndex+@pageSize)))
			EXECUTE (@sql)
			SET @returnEmptyTable = 0
		END
	END
	IF(@returnEmptyTable = 1)
		SELECT 	D.*, ''  AS "DestinationPath"
		FROM DMDownloadResultSet AS D  WHERE 1= 2
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultItemsForGroupingInfo')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemsForGroupingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemsForGroupingInfo')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemsForGroupingInfo'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultItemsForGroupingInfo',  '00010002000000000000', 'sp_dm2_GetResultItemsForGroupingInfo', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetGroupingInfoOnDownloaId.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetGroupingInfoOnDownloaId()
--  | Description:  Get groupingInfo for the input downloadId, if any
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetGroupingInfoOnDownloaId.sp,v $ $Id: sp_dm2_GetGroupingInfoOnDownloaId.sp,v 1.2 2012/08/06 15:32:09 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetGroupingInfoOnDownloaId <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetGroupingInfoOnDownloaId')
	drop procedure sp_dm2_GetGroupingInfoOnDownloaId
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetGroupingInfoOnDownloaId')
	delete from GxQscripts where name = 'sp_dm2_GetGroupingInfoOnDownloaId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetGroupingInfoOnDownloaId')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetGroupingInfoOnDownloaId'
GO
print '... Creating Procedure: sp_dm2_GetGroupingInfoOnDownloaId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetGroupingInfoOnDownloaId
  @downloadId CHAR(36)
AS
	SET NOCOUNT ON
	/*
		Usage:
			This Sp takes input as downloadId and returns the Grouping Info(value and its count) associated with it..
			Attribute field is used to store the grouping field info..
				FolderPath --> POWER(2,14) [15th bit]
				OwnerField --> POWER(2,15) [16th bit]
	**/
	DECLARE @attribute INT = 0
	DECLARE @groupByClause VARCHAR(50) = ''
	DECLARE @sql VARCHAR(MAX) = ''
	SELECT @attribute = Attribute
	FROM DMDownload WHERE DownLoadID = @downloadId
	IF(@attribute & POWER(2,14) > 0)
		SET @groupByClause = 'FolderPath'
	ELSE IF(@attribute & POWER(2,15) > 0)
		SET @groupByClause = 'OwnerField'
	IF(LEN(ISNULL(@groupByClause,''))>0)
	BEGIN
		SET @sql= 'SELECT CASE LEN(ISNULL(' + @groupByClause +',''''))
								WHEN 0 THEN ''Not-Available''
								ELSE '+ @groupByClause +'
								END AS "value",
								COUNT_BIG(*) AS "countVal"
					 FROM DMResultSet AS RS WITH (NOLOCK) WHERE
					 RS.ResultSetID IN ( SELECT D.ResultSetID FROM DMDownloadResultSet AS D  WITH (NOLOCK)
											WHERE  D.DownLoadID = '''+@downloadId +''')
					 GROUP BY CASE LEN(ISNULL(' + @groupByClause +',''''))
								WHEN 0 THEN ''Not-Available''
								ELSE '+ @groupByClause +'
								END '
		EXECUTE (@sql)
	END
	ELSE
	BEGIN
		SELECT 	'' AS "value",0 AS "countVal" WHERE 1= 2
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetGroupingInfoOnDownloaId')
	delete from GxQscripts where name = 'sp_dm2_GetGroupingInfoOnDownloaId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetGroupingInfoOnDownloaId')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetGroupingInfoOnDownloaId'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetGroupingInfoOnDownloaId',  '00010002000000000000', 'sp_dm2_GetGroupingInfoOnDownloaId', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AuditOperation.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AuditOperation.sp,v $ $Id: sp_dm2_AuditOperation.sp,v 1.4 2014/06/24 06:26:37 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AuditOperation <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AuditOperation')
	drop procedure sp_dm2_AuditOperation
IF EXISTS (select * from GxQscripts where name='sp_dm2_AuditOperation')
	delete from GxQscripts where name = 'sp_dm2_AuditOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AuditOperation')
	delete from GXDBVersions where aliasname = 'sp_dm2_AuditOperation'
GO
print '... Creating Procedure: sp_dm2_AuditOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AuditOperation
  @inputXML nvarchar(MAX),
  @discardAnyOutput int = 0 --when this value is set as 1, output will not be returned
AS
SET NOCOUNT ON
/*******
			------------------------Sample XML------------------------
		<DM2ContentIndexing_EventOperation containerGuid="fa8b5408-352c-4a51-bb0f-e7599a677c7e" type="1" userGuid="1F1DE630-FD3F-41cc-A0D9-86B0C1E6CF1A" reuseRequestId="">
			<paramList paramValue="Search" paramName="11" />
			<paramList paramValue="b3b49890-1e04-46fc-bcca-05a260eb7d9b" paramName="1" />
			<resultSetIds val="01bfbf46-f887-4a8f-84c8-71bda85563ad" />
			<resultSetIds val="499fe66b-0257-48df-8f07-e74c6041ce2a" />
			<resultSetIds val="19c5b7c9-4d7b-4f67-a318-26007727473d" />
			<resultSetIds val="e55e2ad5-d12d-4336-8beb-d8231ddda098" />
			<resultSetIds val="a82a1540-8249-4f0a-8919-36c5f805d8a2" />
		</DM2ContentIndexing_EventOperation>
			------------------------ Description ------------------------
		1. if valid reuseRequestId is passed as the input then
			a. Check if any row exists with same value, then get its eventId
			b. Do Not create new entry in DMAction table.
			c. Goto 3
		2. else insert new row in DMAction table
			a. Query DMUserSession to get the userName
		3. Since we maintain the unique combination of EventId and ParamId in DMActionParam table.
		   a. So before inserting into DMActionParam table,
		   b. Check, if item exists --> Update with new value
					else --> insert new rows.
		4. Similar case while inserting into DMActionItemMap table.. DoNot insert if item exists.
			------------------------ Output ------------------------
		1. Error Object will be returned.
		2. On Success, ErrorCode - 0 And ErrorMessage - NO ERROR
		3. On failure, can be any of below.
			a. Userguid is empty
			b. EventType is not specified.
			c. Failure in insert/update
			d. Any foreign key violation
			e. Unknown exception
*******/
BEGIN
	-------Return variables-------
	DECLARE @o_errorCode INTEGER = 0,
			@o_errorString NVARCHAR(500) = 'NO ERROR'
	-------input values-------
	DECLARE @i_xml XML = '',
			@i_reuseRequestId VARCHAR(100) = '',
			@i_userGuid VARCHAR(36) = '',
			@i_containerGuid VARCHAR(36) = '',
			@i_eventType INTEGER = 0,
			@i_attribute INTEGER = 0,
			@i_debug INTEGER = 0
	------LocalVariables------
	DECLARE @refEventId BIGINT = 0,
			@userName NVARCHAR(256) = ''
	----------++++++++++Begin Transaction++++++++--------------
	BEGIN TRY
	BEGIN TRAN
		SET @i_xml = @inputXML
		SELECT @i_reuseRequestId = ISNULL(T.col.value('@reuseRequestId','VARCHAR(100)'),''),
				@i_userGuid = ISNULL(T.col.value('@userGuid','VARCHAR(36)'),''),
				@i_containerGuid = ISNULL(T.col.value('@containerGuid','VARCHAR(36)'),''),
				@i_eventType = ISNULL(T.col.value('@type','INTEGER'),0),
				@i_attribute = ISNULL(T.col.value('@attribute','INTEGER'),0),
				@i_debug = ISNULL(T.col.value('@debug','INTEGER'),0)
		FROM @i_xml.nodes('DM2ContentIndexing_EventOperation') as T(col)
		--Null checks
		IF @i_eventType = 0
		BEGIN
			SELECT @o_errorCode = 1, @o_errorString = 'EventType is not specified'
			GOTO EXIT_ERROR
		END
		IF @i_userGuid = ''
		BEGIN
			SELECT @o_errorCode = 2, @o_errorString = 'Invalid UserGuid..'
			GOTO EXIT_ERROR
		END
		----------Check if reuseRequestId exists.----------
		IF (LEN(@i_reuseRequestId) > 0 AND EXISTS (SELECT EventId FROM DMAction WHERE reuseRequestId = @i_reuseRequestId))
		BEGIN
			SELECT @refEventId = EventId FROM DMAction WHERE reuseRequestId = @i_reuseRequestId
			IF(@i_debug = 1)
				SELECT 'Exists',* FROM DMAction WHERE EventId = @refEventId
		END
		---------------------------------------------
			------- Insertion into DMAction ------
		---------------------------------------------
		IF (@refEventId = 0)
		BEGIN
			--Assign userName
			SELECT TOP 1 @userName = UserName FROM DMUserSession WHERE UserGUID = @i_userGuid
			--insert input i_reuseRequestId also, as next time when request comes with same reuseRequestId
			-- previous IF block will be executed and new insertion will not happen
			INSERT INTO DMAction (EventType,UserGuid,UserName,ContainerGuid,CreateTime,Attribute,reuseRequestId)
			VALUES (@i_eventType,@i_userGuid,@userName,@i_containerGuid,GETUTCDATE(),@i_attribute,@i_reuseRequestId)
			SELECT @o_errorCode = @@ERROR, @refEventId = @@IDENTITY
			IF(@o_errorCode != 0)
			BEGIN
				SELECT @o_errorString = 'ERROR While inserting into DMAction table'
				GOTO EXIT_ERROR
			END
			IF(@i_debug = 1)
				SELECT 'New',* FROM DMAction WHERE EventId = @refEventId
		END
		---------------------------------------------
		  ------ Insertion into DMActionParam ------
		---------------------------------------------
		---Now check if paramList exists
		IF ((SELECT T.col.exist('./paramList') FROM @i_xml.nodes('DM2ContentIndexing_EventOperation') AS T(col)) = 1)
		BEGIN
			MERGE DMActionParam  AS A
			USING (  SELECT ISNULL(T.col.value('@paramName','INTEGER'),0) AS "ParamId",
							ISNULL(T.col.value('@paramValue','NVARCHAR(MAX)'),'')  AS "ParamValue"
					FROM @i_xml.nodes('DM2ContentIndexing_EventOperation/paramList') AS T(col)
					WHERE ISNULL(T.col.value('@paramName','INTEGER'),0) > 0) AS B
			ON (A.refEventId = @refEventId AND A.ParamId = B.ParamId )
			WHEN NOT MATCHED THEN
				INSERT (refEventId,ParamId,ParamValue)
				VALUES (@refEventId,B.ParamId,dbo.DecodeInvalidXMLCharsManaged(B.ParamValue))
			WHEN MATCHED AND B.ParamValue <> '' THEN
				UPDATE SET ParamValue = dbo.DecodeInvalidXMLCharsManaged(B.ParamValue)
			;
			SELECT @o_errorCode = @@ERROR
			IF(@o_errorCode != 0)
			BEGIN
				SELECT @o_errorString = 'ERROR While inserting into DMActionParam table'
				GOTO EXIT_ERROR
			END
			IF (@i_debug= 1)
			BEGIN
				SELECT ISNULL(T.col.value('@paramName','INTEGER'),0) AS "ParamId",
							ISNULL(T.col.value('@paramValue','NVARCHAR(MAX)'),'')  AS "ParamValue"
					FROM @i_xml.nodes('DM2ContentIndexing_EventOperation/paramList') AS T(col)
					WHERE ISNULL(T.col.value('@paramName','INTEGER'),0) > 0
			ENd
		END
			---------------------------------------------
			------- Insert into DMActionItemMap ------
			---------------------------------------------
		--Check for existence of ResultSetIds
		IF ((SELECT T.col.exist('./resultSetIds') FROM @i_xml.nodes('DM2ContentIndexing_EventOperation') AS T(col)) = 1)
		BEGIN
			MERGE DMActionItemMap AS A
			USING (SELECT T.col.value('@val','VARCHAR(36)') AS "ResultSetId"
					FROM @i_xml.nodes('DM2ContentIndexing_EventOperation/resultSetIds') AS T(col)) AS B
			ON (A.refEventId = @refEventId AND A.ResultSetId = B.ResultSetId)
			WHEN NOT MATCHED THEN
				INSERT (refEventId,ResultSetId,CreateTime)
				VALUES (@refEVentId,B.ResultSetId,GETUTCDATE())
			;
			SELECT @o_errorCode = @@ERROR
			IF(@o_errorCode != 0)
			BEGIN
				SELECT @o_errorString = 'ERROR While inserting into DMActionItemMap table'
				GOTO EXIT_ERROR
			END
			IF (@i_debug= 1)
			BEGIN
				SELECT T.col.value('@val','VARCHAR(36)') AS "ResultSetId"
					FROM @i_xml.nodes('DM2ContentIndexing_EventOperation/resultSetIds') AS T(col)
			END
		END
	----------++++++++++Commit Transaction++++++++--------------
	COMMIT TRAN
	END TRY
	---------------------------------------------
	-- CHECK FOR ERRORS ----
	---------------------------------------------
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF @@TRANCOUNT > 0 AND XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
		SELECT @o_errorString = ERROR_MESSAGE(), @o_errorCode = ERROR_NUMBER()
	END CATCH
	EXIT_ERROR:
		IF @o_errorCode != 0
		BEGIN
			IF(@@TRANCOUNT > 0)
			BEGIN
				ROLLBACK TRANSACTION;
			END
		END
		IF @o_errorCode = 0
		BEGIN
			SET @o_errorString = 'NO ERROR'
		END
		IF(@discardAnyOutput != 1)
		BEGIN
		     SELECT (SELECT @o_errorCode "errorCode", @o_errorString "errLogMessage"
				FOR XML RAW('DM2ContentIndexing_Error') )
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AuditOperation')
	delete from GxQscripts where name = 'sp_dm2_AuditOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AuditOperation')
	delete from GXDBVersions where aliasname = 'sp_dm2_AuditOperation'
GO

insert into GXDBVersions values(2, 'sp_dm2_AuditOperation',  '00010004000000000000', 'sp_dm2_AuditOperation', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetPruneFileList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneDownload()
--  | Description:  Returns the altered input fileList which doesnt have any reference
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetPruneFileList.sp,v $ $Id: sp_dm2_GetPruneFileList.sp,v 1.3 2013/07/16 12:44:48 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetPruneFileList <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetPruneFileList')
	drop procedure sp_dm2_GetPruneFileList
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetPruneFileList')
	delete from GxQscripts where name = 'sp_dm2_GetPruneFileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetPruneFileList')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetPruneFileList'
GO
print '... Creating Procedure: sp_dm2_GetPruneFileList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetPruneFileList
  @i_filePathList NVARCHAR(MAX) = ''
AS
/***
	---------------------Description---------------------
	For the input filePathList, this stored procedure will try to find any reference exists
	and the return the list which doesnot have any reference, which later can be pruned..
	The table used in reference check.
	1. [DMContainerExport]			-- DestPath
	2. [DMDownload]					-- CabFilePath/DestinationPath
	3. [DMResultSet]				-- DestinationPath
	4. [DMLegalHoldItemsToBackup]	-- OrginalPath (where BackupStatus <> 1 AND ContainerID = '')
***/
BEGIN
	DECLARE @FileList TABLE ( filePath NVARCHAR(MAX)) ;
	DECLARE @i_xml XML =  @i_filePathList
	/*
		format of i_xml
		'<PathList>
			<path val ="c:\test\a;t.t"/>
			<path val ="c:\test1\b.t"/>
			<path val ="c:\test2\c.t"/>
		</PathList>'
	*/
	INSERT INTO @FileList
	SELECT distinct ref.value('@val','nvarchar(MAX)')
	FROM @i_xml.nodes('PathList/path') R(ref)
	DELETE @FileList
	WHERE filePath IN (
		SELECT distinct DestPath FROM [DMContainerExport] WITH (READUNCOMMITTED)
			WHERE DestPath IN (SELECT distinct filePath FROM @FileList ))
	IF EXISTS (SELECT top 1 filePath FROM @FileList )
	BEGIN
		DECLARE @tempTable2 TABLE(filePath NVARCHAR(MAX));
		INSERT INTO @tempTable2
		SELECT distinct filePath
		FROM @FileList AS T
				INNER JOIN
			DMDownload AS D
			ON D.CabFilePath = T.filePath OR D.DestinationPath = T.filePath
		DELETE @FileList
		FROM @tempTable2 as C, @FileList as L
		WHERE L.filePath = C.filePath
	END
	IF EXISTS (SELECT top 1 filePath FROM @FileList )
	BEGIN
		DECLARE @tempTable TABLE(filePath NVARCHAR(MAX));
		INSERT INTO @tempTable
		SELECT distinct filePath
		FROM DMResultSet AS D  WITH (READUNCOMMITTED)
					INNER JOIN
			@FileList AS F
			ON   D.DestinationPath=F.filePath
		DELETE @FileList
		FROM @tempTable as C, @FileList as L
		WHERE L.filePath = C.filePath
	END
	IF EXISTS (SELECT top 1 filePath FROM @FileList )
	BEGIN
		DECLARE @tempTable1 TABLE(filePath NVARCHAR(MAX));
		INSERT INTO @tempTable1
		SELECT distinct filePath
		FROM DMLegalHoldItemsToBackup AS D  WITH (READUNCOMMITTED)
					INNER JOIN
			@FileList AS F
			ON   D.OriginalPath=F.filePath
			WHERE	D.BackupStatus <> 1 AND
					(D.ContainerID = '' OR D.ContainerID IS NULL)
		DELETE @FileList
		FROM @tempTable1 as C, @FileList as L
		WHERE L.filePath = C.filePath
	END
	SELECT  filePath  AS "filePath" FROM @FileList
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetPruneFileList')
	delete from GxQscripts where name = 'sp_dm2_GetPruneFileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetPruneFileList')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetPruneFileList'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetPruneFileList',  '00010003000000000000', 'sp_dm2_GetPruneFileList', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetAuditValue.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetAuditValue.sp,v $ $Id: sp_dm2_GetAuditValue.sp,v 1.1 2011/05/17 11:07:03 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetAuditValue <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetAuditValue')
	drop procedure sp_dm2_GetAuditValue
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetAuditValue')
	delete from GxQscripts where name = 'sp_dm2_GetAuditValue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAuditValue')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAuditValue'
GO
print '... Creating Procedure: sp_dm2_GetAuditValue'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetAuditValue
  @inputXml XML 
AS
BEGIN
	--Local variables.
	DECLARE @userGuid VARCHAR(36)
	DECLARE @containerGuid VARCHAR(36)
	DECLARE @eventType INT
	DECLARE @eventId BIGINT
	DECLARE @resultSetTable TABLE( resultSetId VARCHAR(36));
	DECLARE @paramListTable TABLE( paramValue INT);
	--Assign local Value.
	SELECT @containerGuid = ISNULL(T.col.value('@containerGuid','VARCHAR(36)'),''),
			@userGuid = ISNULL(T.col.value('@userGuid','VARCHAR(36)'),''),
			@eventType = ISNULL(T.col.value('@type','INT'),0),
			@eventId = ISNULL(T.col.value('@eventId','INT'),0)
	FROM @inputXML.nodes('DM2ContentIndexing_AuditQueryRequest') AS T(col)
	--insert input resultSetIds
	INSERT INTO @resultSetTable
	SELECT T.col.value('@val','VARCHAR(36)')
	FROM @inputXML.nodes('DM2ContentIndexing_AuditQueryRequest/resultSetIds') AS T(col)
	--insert input paramList
	INSERT INTO @paramListTable
	SELECT T.col.value('@val','INT')
	FROM @inputXML.nodes('DM2ContentIndexing_AuditQueryRequest/paramList') AS T(col)
	;WITH CTE_EvntId AS
	(
		SELECT refEventId,A.ContainerGuid,A.UserGuid,Map.CreateTime,Map.ResultSetId,A.UserName
		FROM DMActionItemMap AS Map
			INNER JOIN
			DMAction AS A
		ON ( (@eventId > 0 AND A.EventId = @eventId AND  Map.refEventId = @eventId ) OR
			 (@eventId <= 0 AND A.EventId = Map.refEventId ))
		AND ResultSetId IN (SELECT resultSetId FROM @resultSetTable)
		AND ( @eventType = 0 OR A.EventType = @eventType)
			WHERE (LEN(@containerGuid) = 0 OR ContainerGuid = @containerGuid)
	)
	SELECT p.refEventId "eventId",CTE.ContainerGuid,CTE.ResultSetId,
		P.ParamId,P.ParamValue,CTE.UserGuid,CTE.UserName,CTE.CreateTime
	FROM DMActionParam AS P
		INNER JOIN
		CTE_EvntId AS CTE
	ON P.refEventId = CTE.refEventId AND P.ParamId in (SELECT T.paramValue FROM @paramListTable AS T)
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetAuditValue')
	delete from GxQscripts where name = 'sp_dm2_GetAuditValue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAuditValue')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAuditValue'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetAuditValue',  '00010001000000000000', 'sp_dm2_GetAuditValue', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_SyncTurboResultSet.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_SyncTurboResultSet.sp,v $ $Id: sp_dm2_SyncTurboResultSet.sp,v 1.3 2012/05/24 23:42:33 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_SyncTurboResultSet <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_SyncTurboResultSet')
	drop procedure sp_dm2_SyncTurboResultSet
IF EXISTS (select * from GxQscripts where name='sp_dm2_SyncTurboResultSet')
	delete from GxQscripts where name = 'sp_dm2_SyncTurboResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncTurboResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncTurboResultSet'
GO
print '... Creating Procedure: sp_dm2_SyncTurboResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_SyncTurboResultSet
  @i_Items XML
AS
	BEGIN
		-- expects a list like
		-- <DM2ContentIndexing_GResultItems>
		--    <resultItem commcellNo="2" aFileId="2" aFileOffset="27" turboGuid="35097346298432698868347349" ResultItemID="298727549823535823672356" />
		-- </DM2ContentIndexing_GResultItems>
  DECLARE @lt_AFOffsets TABLE (CCId int, AFId bigint, AFOff bigInt, IndexGUID char(36), ResultItemID char(36))
  DECLARE @error int
  DECLARE @errorMessage varchar(max)
  DECLARE @count bigint
  DECLARE @debug bit
		SET NOCOUNT ON
			SET @errorMessage = 'Procedure executed successfully'
			SET @debug = 0
		INSERT INTO @lt_AFOffsets
		SELECT T.c.value('@commcellNo','int'), T.c.value('@aFileId', 'bigint'), T.c.value('@aFileOffset', 'bigint'),
		T.c.value('@turboGuid', 'char(36)'), T.c.value('@ResultItemID', 'char(36)')
		FROM @i_Items.nodes('//resultItem') T(c)
		SET @error = @@ERROR
		IF @error > 0
		BEGIN
			SET @errorMessage = 'Error when capturing XML data sent as input into temporary table.'
			GOTO exitHandler
		END
		BEGIN TRANSACTION
		UPDATE DMResultSet WITH(PAGLOCK)
		SET CommCellNumber = CCID, aFileID = AFId, aFileOffset = AFOff
		FROM @lt_AFOffsets T
		WHERE (ISNULL(T.IndexGUID, '') <> '' AND DMResultSet.IndexGUID = T.IndexGUID)
		OR (ISNULL(T.ResultItemID, '') <> '' AND T.ResultItemID = DMResultSet.ResultSetID)
		SELECT @error = @@ERROR, @count = @@rowcount
	IF @debug = 1
	BEGIN
		SELECT * FROM @lt_AFOffsets
	END
	PRINT 'Rows affected in DMResulset:'+convert(varchar(10), @count)
		IF @error > 0
		BEGIN
			SET @errorMessage = 'Error updating DMResultSet table.'
			GOTO errHandler
		END
	IF @error > 0
	BEGIN
		SET @errorMessage = 'Error updating DMResultSet table.'
		GOTO errHandler
	END
	UPDATE DMResultSetInfo WITH(PAGLOCK)
	SET ResultSet = dbo.fn_dm2_GetTurboResultSet(ResultSet, F.CCId, F.AFId, F.AFOff)
	FROM @lt_AFOffsets F
	JOIN DMResultSet R WITH (READUNCOMMITTED)
	ON (ISNULL(F.IndexGUID, '') <> '' AND F.IndexGUID = R.IndexGUID) OR (ISNULL(F.ResultItemID, '') <> '' AND F.ResultItemID = R.ResultSetID)
	WHERE DMResultSetInfo.ResultSetID = R.ResultSetID
	SELECT @error = @@ERROR, @count = @@rowcount
	PRINT 'Rows affected in DMResulsetInfo:'+convert(varchar(10), @count)
	IF @error > 0
	BEGIN
		SET @errorMessage = 'Error updating DMResultSetInfo table.'
	END
		errHandler:
		IF @error > 0
			ROLLBACK TRANSACTION
		ELSE
			COMMIT TRANSACTION
		exitHandler:
			PRINT @errorMessage
			SELECT @error AS ErrorCode, @errorMessage as ErrorMessage
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_SyncTurboResultSet')
	delete from GxQscripts where name = 'sp_dm2_SyncTurboResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncTurboResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncTurboResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_SyncTurboResultSet',  '00010003000000000000', 'sp_dm2_SyncTurboResultSet', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddItemsToSyncWithIndexing.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_AddItemsToSyncWithIndexing()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddItemsToSyncWithIndexing.sp,v $ $Id: sp_dm2_AddItemsToSyncWithIndexing.sp,v 1.5 2012/10/09 22:22:00 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddItemsToSyncWithIndexing <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddItemsToSyncWithIndexing')
	drop procedure sp_dm2_AddItemsToSyncWithIndexing
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_AddItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddItemsToSyncWithIndexing'
GO
print '... Creating Procedure: sp_dm2_AddItemsToSyncWithIndexing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddItemsToSyncWithIndexing
  @ItemsToSync AS DMItemsToSyncWithIndexingTypeV2 READONLY 
AS
BEGIN
CREATE TABLE #DMItemsToSyncWithIndexingType
(
	ItemID					int identity(1,1),
	aFileID					bigint,
	aFileOffset				bigint,
	CommCellNumber   		int,
	OriginalFullPath 		nvarchar(4000),
	IndexGUID				varchar(128),
	SyncStatus				int,
	idxAFileId				bigint,
	idxAFileOffset			bigint,
	idxCommCellNumber		int null,
	ResultSetID				char(36) null
)
INSERT INTO #DMItemsToSyncWithIndexingType (aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber, ResultSetID)
SELECT aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber, ResultSetID
FROM @ItemsToSync
MERGE DMItemsToSyncWithIndexing AS A
USING (SELECT *, RANK() OVER(PARTITION BY aFileID, aFileOffset, CommCellNumber ORDER BY ItemID) ItemRank FROM #DMItemsToSyncWithIndexingType) AS T
ON (A.aFileID = T.aFileID AND A.aFileOffset = T.aFileOffset AND A.CommCellNumber = T.CommCellNumber AND T.ItemRank = 1)
WHEN NOT MATCHED THEN
	INSERT (aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber, ResultSetID, IndexSyncTime)
	VALUES (T.aFileID, T.aFileOffset, T.CommCellNumber, T.OriginalFullPath, T.IndexGUID, T.SyncStatus, T.idxAFileId, T.idxAFileOffset, T.idxCommCellNumber, T.ResultSetID, GetDate())
WHEN MATCHED THEN
UPDATE SET idxaFileId = T.idxaFileId,
idxaFileOffset = T.idxaFileOffset,
idxCommCellNumber = T.idxCommCellNumber,
IndexSyncTime = GetDate(),
SyncStatus = T.SyncStatus,
OriginalFullPath = T.OriginalFullPath
;
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_AddItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddItemsToSyncWithIndexing'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddItemsToSyncWithIndexing',  '00010005000000000000', 'sp_dm2_AddItemsToSyncWithIndexing', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetItemsToSyncWithIndexing.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetItemsToSyncWithIndexing()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetItemsToSyncWithIndexing.sp,v $ $Id: sp_dm2_GetItemsToSyncWithIndexing.sp,v 1.8 2015/03/11 19:25:38 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetItemsToSyncWithIndexing <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetItemsToSyncWithIndexing')
	drop procedure sp_dm2_GetItemsToSyncWithIndexing
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_GetItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetItemsToSyncWithIndexing'
GO
print '... Creating Procedure: sp_dm2_GetItemsToSyncWithIndexing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetItemsToSyncWithIndexing
  @ItemsToSync AS DMItemsToSyncWithIndexingTypeV2 READONLY,
  @tblInvalidArchFiles ArchFileType READONLY
AS
BEGIN
	DECLARE @idxSyncInterval int = 1
	DECLARE @syncAll bit = 0
	DECLARE @SyncSettingVal varchar(50)
	SELECT @idxSyncInterval = ISNULL(SettingValue, 24) FROM DMSetting
	WHERE SettingName = 'INDEX_SYNC_INTERVAL'
	SELECT @SyncSettingVal = ISNULL(SettingValue, 'SYNC_NEVER')
	FROM DMSetting
	WHERE SettingName = 'RESTORE_OFFSET_SYNC_OPTION'
	IF @SyncSettingVal = 'SYNC_NEVER'
	BEGIN
		SELECT TOP 1 * FROM @ItemsToSync
		WHERE 1 = 2
	END
	ELSE IF @SyncSettingVal = 'SYNC_FORCE_ALL'
	BEGIN
		SELECT A.aFileID, A.aFileOffset, A.CommCellNumber, A.OriginalFullPath, A.IndexGUID,
		2 AS SyncStatus, A.idxAFileId, A.idxAFileOffset, A.idxCommCellNumber, R.ResultSetID  FROM @ItemsToSync A
		LEFT JOIN DMResultSet R WITH (READUNCOMMITTED) ON A.aFileID = R.aFileID AND A.aFileOffset = R.aFileOffset AND A.CommCellNumber = R.CommCellNumber
	END
	ELSE IF @SyncSettingVal = 'SYNC_ALL'
	BEGIN
		SELECT A.aFileID, A.aFileOffset, A.CommCellNumber, ISNULL(S.OriginalFullPath, ISNULL(A.OriginalFullPath, '')) AS OriginalFullPath, A.IndexGUID,
		(CASE WHEN ISNULL(S.SyncStatus, 0) = 1 AND datediff(hour, ISNULL(S.IndexSyncTime,getdate()), getdate()) < @idxSyncInterval THEN 1 ELSE 2 END) AS SyncStatus,
		S.idxAFileId, S.idxAFileOffset, S.idxCommCellNumber, R.ResultSetID  FROM @ItemsToSync A
		LEFT JOIN DMItemsToSyncWithIndexing S WITH (READUNCOMMITTED) ON A.aFileID = S.aFileID AND A.aFileOffset = S.aFileOffset AND A.CommCellNumber = S.CommCellNumber
		LEFT JOIN DMResultSet R WITH (READUNCOMMITTED) ON A.aFileID = R.aFileID AND A.aFileOffset = R.aFileOffset AND A.CommCellNumber = R.CommCellNumber
	END
	ELSE
	BEGIN
		--Sync only if turboguid present in input row for SYNC_ONLY_TURBO option.
		--left join with @tblInvalidArchFiles, because now we want to restore stubs as data, so we return them for lookup even though it is not marked for pruning.
		--we are not using ResultSetID taken from DMResultSet table for any purpose and this join could slow down, so that is being removed
		SELECT A.aFileID, A.aFileOffset, A.CommCellNumber, ISNULL(S.OriginalFullPath, ISNULL(A.OriginalFullPath, '')) AS OriginalFullPath, A.IndexGUID,
		(CASE WHEN ISNULL(S.SyncStatus, 0) = 1 AND datediff(hour, ISNULL(S.IndexSyncTime,getdate()), getdate()) < @idxSyncInterval THEN 1 ELSE 2 END) AS SyncStatus,
		S.idxAFileId, S.idxAFileOffset, S.idxCommCellNumber, NULL AS ResultSetID
		FROM @ItemsToSync A
		LEFT JOIN @tblInvalidArchFiles P ON A.AFileID = P.ArchFileID
		LEFT JOIN DMItemsToSyncWithIndexing S WITH (READUNCOMMITTED) ON A.aFileID = S.aFileID AND A.aFileOffset = S.aFileOffset AND A.CommCellNumber = S.CommCellNumber
		--LEFT JOIN DMResultSet R WITH (READUNCOMMITTED) ON A.aFileID = R.aFileID AND A.aFileOffset = R.aFileOffset AND A.CommCellNumber = R.CommCellNumber
		WHERE ISNULL(A.IndexGUID, '') <> '' AND (ISNULL(A.SyncStatus, 0) = 3 OR P.ArchFileId IS NOT NULL) --either item is marked for pruning or if it is stub, we want to sync using turboguid.
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_GetItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetItemsToSyncWithIndexing'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetItemsToSyncWithIndexing',  '00010008000000000000', 'sp_dm2_GetItemsToSyncWithIndexing', '00010008000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_SyncResultSetOffset.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_SyncResultSetOffset()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_SyncResultSetOffset.sp,v $ $Id: sp_dm2_SyncResultSetOffset.sp,v 1.6 2012/11/15 16:04:32 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_SyncResultSetOffset <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_SyncResultSetOffset')
	drop procedure sp_dm2_SyncResultSetOffset
IF EXISTS (select * from GxQscripts where name='sp_dm2_SyncResultSetOffset')
	delete from GxQscripts where name = 'sp_dm2_SyncResultSetOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncResultSetOffset')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncResultSetOffset'
GO
print '... Creating Procedure: sp_dm2_SyncResultSetOffset'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_SyncResultSetOffset
  @ItemsToSync AS DMItemsToSyncWithIndexingTypeV2 READONLY 
AS
BEGIN
	DECLARE @error int
	DECLARE @errorMessage varchar(max)
	DECLARE @count bigint
	DECLARE @debug bit
	SET NOCOUNT ON
	SELECT @error = 0, @debug = 0, @errorMessage = 'Procedure executed successfully'
	IF NOT EXISTS (SELECT TOP 1 * FROM @ItemsToSync)
	GOTO exitHandler
	DECLARE @ItemsInDB DMItemsToSyncWithIndexingTypeV2
	INSERT INTO @ItemsInDB (ResultSetID, aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber)
	SELECT RI.ResultSetID, I.idxAFileID, I.idxAFileOffset, I.idxCommCellNumber, I.OriginalFullPath, I.IndexGUID, I.SyncStatus, I.idxAFileID, I.idxAFileOffset, I.idxCommCellNumber
	FROM @ItemsToSync I
	JOIN DMResultSet RI with (NOLOCK) ON RI.CommCellNumber = I.idxCommCellNumber AND RI.aFileID = I.idxAFileID AND RI.aFileOffset = I.idxAFileOffset
	INSERT INTO @ItemsInDB (ResultSetID, aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber)
	SELECT R.ResultSetID, I.aFileID, I.aFileOffset, I.CommCellNumber, I.OriginalFullPath, I.IndexGUID, I.SyncStatus, I.idxAFileId, I.idxAFileOffset, I.idxCommCellNumber
	FROM @ItemsToSync I
	JOIN DMResultSet R with (NOLOCK) ON I.aFileID = R.aFileID AND I.aFileOffset = R.aFileOffset AND I.CommCellNumber = R.CommCellNumber
	WHERE NOT EXISTS (SELECT * FROM @ItemsInDB D WHERE D.aFileID = I.idxaFileID AND D.aFileOffset = I.idxaFileOffset AND D.CommCellNumber = I.idxCommCellNumber) -- DO not map already mapped items that matched against indexing lookedup data
	IF EXISTS (SELECT TOP 1 ResultSetID FROM @ItemsInDB)
	BEGIN
	BEGIN TRANSACTION
	UPDATE DMResultSet WITH(PAGLOCK)
	SET CommCellNumber = I.idxCommCellNumber, aFileID = I.idxAFileID, aFileOffset = I.idxAFileOffset,
	OriginalFullPath = (CASE WHEN ISNULL(I.OriginalFullPath, '') = '' THEN DMResultSet.OriginalFullPath ELSE I.OriginalFullPath END) --update OriginalFullPath due to bug in indexing system that prepends backslash in case of synth full turbo.
	FROM @ItemsInDB I
	WHERE I.ResultSetID = DMResultSet.ResultSetID
	SELECT @error = @@ERROR, @count = @@rowcount
	PRINT 'Rows affected in DMResulset:'+convert(varchar(10), @count)
	IF @error > 0
	BEGIN
		SET @errorMessage = 'Error updating DMResultSet table.'
		GOTO errHandler
	END
	UPDATE DMResultSetInfo WITH(PAGLOCK)
	SET ResultSet = dbo.fn_dm2_GetTurboResultSet(ResultSet, I.idxCommCellNumber, I.idxAFileID, I.idxAFileOffset)
	FROM @ItemsInDB I
	WHERE I.ResultSetID = DMResultSetInfo.ResultSetID
	SELECT @error = @@ERROR, @count = @@rowcount
	PRINT 'Rows affected in DMResulsetInfo:'+convert(varchar(10), @count)
	IF @error > 0
	BEGIN
		SET @errorMessage = 'Error updating DMResultSetInfo table.'
	END
errHandler:
	IF @error > 0
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
	END
exitHandler:
		PRINT @errorMessage
		SELECT @error AS ErrorCode, @errorMessage as ErrorMessage
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_SyncResultSetOffset')
	delete from GxQscripts where name = 'sp_dm2_SyncResultSetOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncResultSetOffset')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncResultSetOffset'
GO

insert into GXDBVersions values(2, 'sp_dm2_SyncResultSetOffset',  '00010006000000000000', 'sp_dm2_SyncResultSetOffset', '00010006000000000000')
GO


-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddPunedArchFile.sp,v $ $Id: sp_dm2_AddPunedArchFile.sp,v 1.3 2015/04/21 19:05:08 ksundaram Exp $";

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

print '>>> Drop Stored Procedure: sp_dm2_AddPunedArchFile <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddPunedArchFile')
	drop procedure sp_dm2_AddPunedArchFile
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddPunedArchFile')
	delete from GxQscripts where name = 'sp_dm2_AddPunedArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddPunedArchFile')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddPunedArchFile'
GO


print '... Creating Procedure: sp_dm2_AddPunedArchFile'
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE	sp_dm2_AddPunedArchFile (@tblInvalidArchFiles ArchFileType READONLY)
AS
BEGIN

	INSERT INTO DMPrunedArchFile (ArchFileId)
	SELECT ArchFileId FROM @tblInvalidArchFiles 
	WHERE ArchFileId NOT IN (SELECT ArchFileId FROM DMPrunedArchFile)

END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddPunedArchFile')
	delete from GxQscripts where name = 'sp_dm2_AddPunedArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddPunedArchFile')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddPunedArchFile'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddPunedArchFile',  '00010001000000000000', 'sp_dm2_AddPunedArchFile', '00010001000000000000')
GO




--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneItemsToSyncWithIndexing.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneItemsToSyncWithIndexing.sp,v $ $Id: sp_dm2_PruneItemsToSyncWithIndexing.sp,v 1.2 2012/08/28 04:12:07 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneItemsToSyncWithIndexing <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneItemsToSyncWithIndexing')
	drop procedure sp_dm2_PruneItemsToSyncWithIndexing
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_PruneItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneItemsToSyncWithIndexing'
GO
print '... Creating Procedure: sp_dm2_PruneItemsToSyncWithIndexing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneItemsToSyncWithIndexing
AS
SET NOCOUNT ON
BEGIN
	/*
		This Stored procedure prunes items in DMItemsToSyncWithIndexing table based on below criteria
			1. if success status( =1 ), prune will happen based on setting key [INDEX_SYNC_INTERVAL] [default -24hrs]
			2. if status <>1, prune will be based on key [PRUNE_FAILED_INDEX_INTERVAL_InHrs]		 [default-168hrs]
	*/
	DECLARE @idxSyncInterval int = 24  -- 1day
	DECLARE @idxSyncIntervalFailedItems int = 168 -- 7 days
	SELECT @idxSyncInterval = ISNULL(SettingValue, 24) FROM DMSetting
    WHERE SettingName = 'INDEX_SYNC_INTERVAL'
    SELECT @idxSyncIntervalFailedItems = ISNULL(SettingValue, 168) FROM DMSetting
    WHERE SettingName = 'PRUNE_FAILED_INDEX_INTERVAL_InHrs'
	DELETE FROM DMItemsToSyncWithIndexing
	WHERE DATEDIFF(HOUR, ISNULL(IndexSyncTime,getdate()), getdate()) > @idxSyncInterval AND SyncStatus = 1
	DELETE FROM DMItemsToSyncWithIndexing
	WHERE DATEDIFF(HOUR, ISNULL(IndexSyncTime,getdate()), getdate()) > @idxSyncIntervalFailedItems AND SyncStatus <> 1
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_PruneItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneItemsToSyncWithIndexing'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneItemsToSyncWithIndexing',  '00010002000000000000', 'sp_dm2_PruneItemsToSyncWithIndexing', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneReviewSets.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneReviewSets.sp,v $ $Id: sp_dm2_PruneReviewSets.sp,v 1.4 2014/01/28 02:56:28 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneReviewSets <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneReviewSets')
	drop procedure sp_dm2_PruneReviewSets
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneReviewSets')
	delete from GxQscripts where name = 'sp_dm2_PruneReviewSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneReviewSets')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneReviewSets'
GO
print '... Creating Procedure: sp_dm2_PruneReviewSets'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneReviewSets
  @i_ContainerGuid VARCHAR(MAX)
AS
SET NOCOUNT ON
BEGIN
	/*
		This Stored procedure prunes list of review set that is passed as input.
		Prune Inteval is based on Key setting "PRUNE_REVIEWSET_INTERVAL_InHrs". Default = 720 hrs (30 days)
		For each container,
			Get top 10000 resultSetIds, which matches the prune time criteria in that reviewset
			Pass those list to existing SP [sp_dm2_PruneResultSetItemsBulk] with that contaierGuid
			Continue till we have items to prune
	*/
	DECLARE @i_pruneCriteriaInHrs INT = 720
	SELECT @i_pruneCriteriaInHrs = ISNULL(SettingValue, 720) FROM DMSetting WHERE SettingName = 'PRUNE_REVIEWSET_INTERVAL_InHrs'
	--IF(LEN(LTRIM(RTRIM(ISNULL(@tempSettingVal,'')))) > 0)
	--	SELECT @i_pruneCriteriaInHrs = CONVERT(INT,@tempSettingVal)
	--if less than an hour, fall back to default 7 days
	if( @i_pruneCriteriaInHrs < 1 )
		SET @i_pruneCriteriaInHrs = 720
	DECLARE @containerGuidTbl table(id INT IDENTITY(1,1) , containerGuid varchar(36))
	INSERT INTO @containerGuidTbl
	SELECT  LTRIM(RTRIM(ID))
	FROM dbo.splitStringToTable(@i_ContainerGuid)
	WHERE LEN(ISNULL(ID,'')) > 0
	IF OBJECT_ID('tempdb.dbo.#tmpResultSetId1') IS NOT NULL
		DROP TABLE #tmpResultSetId1
	CREATE TABLE #tmpResultSetId1
	(
		ResultSetId VARCHAR(36)
	) ;
	DECLARE @totalCount INT = 0
	DECLARE @incrVal INT = 0
	DECLARE @localContainerGuid VARCHAR(36) = ''
	DECLARE @resulSetIdList VARCHAR(MAX) = ''
	SELECT @totalCount = MAX(ID) FROM @containerGuidTbl
	WHILE(@incrVal < @totalCount )
	BEGIN
		SET @localContainerGuid = ''
		SELECT @localContainerGuid = containerGuid FROM @containerGuidTbl WHERE id = (@incrVal+1)
		INSERT INTO #tmpResultSetId1
		SELECT TOP 10000 ResultSetID FROM DMContainerItem WITH (NOLOCK)
		WHERE ContainerID = @localContainerGuid AND DATEDIFF(HH,CreateTime,GETDATE()) >= @i_pruneCriteriaInHrs
		WHILE EXISTS ( SELECT TOP 1 * FROM #tmpResultSetId1)
		BEGIN
				SET @resulSetIdList		= ''
				SELECT @resulSetIdList = ISNULL(STUFF(
						(SELECT ';' "text()", tt.ResultSetId "text()" FROM #tmpResultSetId1 tt FOR XML PATH(''))
					,1,1,''),'')
				IF(LEN(ISNULL(@resulSetIdList,'')) > 0)
				BEGIN
					--Execute only if any restultsetIds exists.
					EXEC sp_dm2_PruneResultSetItemsBulk @resulSetIdList, @localContainerGuid
				END
				--clean up before processing
				DELETE #tmpResultSetId1;
				INSERT INTO #tmpResultSetId1
				SELECT TOP 10000 ResultSetID FROM DMContainerItem WITH (NOLOCK)
				WHERE ContainerID = @localContainerGuid AND DATEDIFF(HH,CreateTime,GETDATE()) >= @i_pruneCriteriaInHrs
		END
		DELETE #tmpResultSetId1;
		SET @incrVal = @incrVal + 1
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneReviewSets')
	delete from GxQscripts where name = 'sp_dm2_PruneReviewSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneReviewSets')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneReviewSets'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneReviewSets',  '00010004000000000000', 'sp_dm2_PruneReviewSets', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneOrphanReviewSetsAndResultItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneOrphanReviewSetsAndResultItems.sp,v $ $Id: sp_dm2_PruneOrphanReviewSetsAndResultItems.sp,v 1.5 2015/02/16 18:55:30 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneOrphanReviewSetsAndResultItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneOrphanReviewSetsAndResultItems')
	drop procedure sp_dm2_PruneOrphanReviewSetsAndResultItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneOrphanReviewSetsAndResultItems')
	delete from GxQscripts where name = 'sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneOrphanReviewSetsAndResultItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO
print '... Creating Procedure: sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneOrphanReviewSetsAndResultItems
  @i_ContainerGuids VARCHAR(MAX) = '',
  @o_OutputMessage NVARCHAR(MAX) OUTPUT --this needs to be last param
AS
SET NOCOUNT ON
BEGIN
	/*
		This Stored procedure prunes orphan review sets And orphan entries in DMResultSet table
		Reviewset Pruning
			Input is list of reviewSet available in CommServe (DM2Container table)
			If input containerGuids list is not empy
			{
				containerGuids in DMContainerItem table which doesnt match any of the input containers will be pruned.
			}
		Restored Item Pruning
			For items in DMResultSet whose RestoreTime and CreateTime is older than default 45 days., we will reset restore information
		DMResultSet Pruning
			For any entries in DMResultSet without mapping between DMContainerItem., and
				CreateTime is null Or CreateTime is greater then PRune interval AND
				Restore time is null OR Restoretime is greater then PRune interval
		DMSEtting keys used
			ENABLE_ORPHAN_REVIEWSET_PRUNING			--> To enable orphan review set pruning. [Default true]
			ENABLE_ORPHAN_ITEM_PRUNING				-->	To enable DMResultSet orphan items pruning. (ie., when there is no mapping between DMContainerItem exits). [Default true]
			PRUNE_INTERVAL_FOR_ORPHAN_ITEMS_InHrs	-->	Time interval to compare with RestoreTime and CreateTime while pruning items. [Default- 168 hrs]
			ENABLE_RESTORED_ITEM_PRUNING			-->	To enable restored items pruning. [Default false]
			RESET_INTERVAL_FOR_RESTORED_ITEMS_InHrs	-->	Time interval to compare with RestoreTime and CreateTime for resetting restore status of restored items. [Default- 1 hrs]
	*/
	DECLARE @enableOrphanRSPruning		VARCHAR(10) = 'TRUE'
	DECLARE @enableOrphanItemPruning	VARCHAR(10) = 'TRUE'
	DECLARE @enableRestoredItemPruning	VARCHAR(10) = 'FALSE'
	DECLARE @outputMessage				NVARCHAR(MAX) = ''
	SELECT @enableOrphanRSPruning = ISNULL(SettingValue,'TRUE')
	FROM DMSetting WHERE SettingName = 'ENABLE_ORPHAN_REVIEWSET_PRUNING'
	SELECT @enableOrphanItemPruning = ISNULL(SettingValue,'TRUE')
	FROM DMSetting WHERE SettingName = 'ENABLE_ORPHAN_ITEM_PRUNING'
	SELECT @enableRestoredItemPruning = ISNULL(SettingValue,'FALSE')
	FROM DMSetting 	WHERE SettingName = 'ENABLE_RESTORED_ITEM_PRUNING'
	SET @outputMessage = @outputMessage + ' Flags ENABLE_ORPHAN_REVIEWSET_PRUNING: [ ' + @enableOrphanRSPruning + ' ] '
	SET @outputMessage = @outputMessage + ' , ENABLE_ORPHAN_ITEM_PRUNING : [' + @enableOrphanItemPruning + ' ] '
	SET @outputMessage = @outputMessage + ' , ENABLE_RESTORED_ITEM_PRUNING : [' + @enableRestoredItemPruning + ' ] '
	DECLARE @date DATETIME =  GETDATE();
	--check if enable orphan RS pruning is enabled, and also input containeGuid list is not empty
	--
	IF( @enableOrphanRSPruning = 'TRUE' AND LEN(ISNULL(@i_ContainerGuids,'')) > 0 )
	BEGIN
		DECLARE @containerGuidTbl table( containerGuid varchar(36))
		INSERT INTO @containerGuidTbl
		SELECT  LTRIM(RTRIM(ID))
		FROM dbo.splitStringToTable(@i_ContainerGuids)
		WHERE LEN(ISNULL(ID,'')) > 0
		IF OBJECT_ID('tempdb.dbo.#tmpPruneContainerGuids') IS NOT NULL
			DROP TABLE #tmpPruneContainerGuids
		CREATE TABLE #tmpPruneContainerGuids
		(
			id INT IDENTITY(1,1) ,
			containerGuid VARCHAR(36)
		) ;
		--Insert containerGuid which doesnt match the input list
		--
		INSERT INTO #tmpPruneContainerGuids
		SELECT DISTINCT ContainerID FROM
		DMContainerItem WITH (NOLOCK)
		WHERE ContainerID NOT IN (SELECT distinct containerGuid FROM @containerGuidTbl)
		IF EXISTS (SELECT TOP 1 * FROM #tmpPruneContainerGuids)
		BEGIN
			DECLARE @tempContainerList VARCHAR(MAX)
			SELECT @tempContainerList = ISNULL(STUFF(
							(SELECT  ';' "text()", containerGuid "text()"
								FROM 	#tmpPruneContainerGuids
								FOR XML PATH('')),1,1,''),'')
			SET @outputMessage = @outputMessage + ' \n Container list to be pruned [ '+@tempContainerList +' ]'
			-- Now start pruning for all the input containerGuid
			--
			DECLARE @totalCount INT = 0
			DECLARE @incrVal INT = 0
			DECLARE @localContainerGuid VARCHAR(36) = ''
			SELECT @totalCount = MAX(ID) FROM #tmpPruneContainerGuids
			WHILE(@incrVal < @totalCount )
			BEGIN
				SET @localContainerGuid = ''
				SELECT @localContainerGuid = containerGuid FROM #tmpPruneContainerGuids WHERE id = (@incrVal+1)
				EXEC sp_dm2_PruneResultSetItemsBulk '', @localContainerGuid
				SET @incrVal = @incrVal + 1
			END
		END
		ELSE
		BEGIN
			SET @outputMessage = @outputMessage + ' \n No Containers will be pruned'
		END
		IF OBJECT_ID('tempdb.dbo.#tmpPruneContainerGuids') IS NOT NULL
			DROP TABLE #tmpPruneContainerGuids
	END
	IF @enableRestoredItemPruning = 'TRUE'
	BEGIN
		DECLARE @maxid INT = 0,
				@doContinue BIT = 1,
				@batchCnt INT = 5000,
				@totalUpdated BIGINT = 0
		DECLARE	@IDTable TABLE ( id INT)
		DECLARE @pruneRestoredItemInterval INT = 1080  -- default 45 days
		SELECT @pruneRestoredItemInterval = ISNULL(SettingValue, 1080) FROM DMSetting
		WHERE SettingName = 'RESET_INTERVAL_FOR_RESTORED_ITEMS_InHrs'
		WHILE (@doContinue = 1)
		BEGIN
			INSERT INTO @IDTable
			SELECT TOP (@batchCnt) RS.ID FROM DMResultSet RS WITH (NOLOCK)
			WHERE RS.ID > @maxid AND
				RS.RestoreStatus = 4 AND
				ISNULL(RS.DestinationPath,'') <> '' AND
				(RS.CreateTime IS NULL OR DATEDIFF(HOUR, ISNULL(RS.CreateTime,@date), @date) > @pruneRestoredItemInterval ) AND
				(RS.RestoreTime IS NULL OR DATEDIFF(HOUR, ISNULL(RS.RestoreTime,@date), @date) > @pruneRestoredItemInterval )
			IF EXISTS( SELECT 1 FROM @IDTable)
			BEGIN
				IF (SELECT COUNT(*) FROM @IDTable) < @batchCnt
					SET @doContinue = 0
				SELECT @maxid = MAX(id) FROM @IDTable
				UPDATE RS
				SET RS.RestoreStatus = 0,
					RS.RestoreJobID = 0,
					RS.RestoreTime = NULL,
					RS.DestinationPath = ''
				FROM DMResultSet RS
					INNER JOIN
					@IDTable as T
				ON RS.ID = T.id
				SELECT @totalUpdated = @totalUpdated + @@ROWCOUNT
				DELETE FROM @IDTable
			END
			ELSE
				SET @doContinue = 0
		END
		SET @outputMessage = @outputMessage + '\n Number of restored items updated [' + CONVERT(VARCHAR(100), @totalUpdated) +  ' ] '
	END
	--check if enable orphan DMResultset item pruning is enabled
	--
	IF( @enableOrphanItemPruning = 'TRUE' )
	BEGIN
		--if entry doesnt exists in SyncUploadInfo then reset edge attribute,so that regular pruning prunes that entry
		--
		IF NOT EXISTS (SELECT 1 FROM DMSetting WHERE SettingName = 'DISABLE_RESET_EDGE_ATTRIBUTE' AND SettingName = 'True')
		BEGIN
			UPDATE DMResultSet
			SET Attribute = Attribute & ~128
			WHERE (Attribute & 128) = 128 AND
				NOT EXISTS(SELECT 1 FROM SyncUploadInfo WITH (NOLOCK) WHERE entityType = 111 AND localPath like '%_'+ documentID)
		END
		DECLARE @pruneInterval INT = 168  -- default 7 days
		SELECT @pruneInterval = ISNULL(SettingValue, 168) FROM DMSetting
		WHERE SettingName = 'PRUNE_INTERVAL_FOR_ORPHAN_ITEMS_InHrs'
		IF OBJECT_ID('tempdb.dbo.#tmpResultSetIdsPrune') IS NOT NULL
			DROP TABLE #tmpResultSetIdsPrune
		--Create temp tbl for holding ResultSetId
		CREATE TABLE #tmpResultSetIdsPrune
		(
			ResultSetId VARCHAR(36)
		) ;
		--insert any resultsetId which doesnt have mapping with DMContainerItem and DMDownloadResultSet
		-- And DMResulSet's
		--			CreateTime is null Or CreateTime is greater then PRune interval
		--			AND Restore time is null OR Restoretime is greater then PRune interval
		--
		-- use date Filter at last .
		-- Since resultsetid column have index in all tables
		--	using date in the same query will make dmresultset to go for entire table clustered index	scan.
		--
		;with CTE as(
		SELECT DISTINCT RS.ResultSetID FROM
			DMResultSet RS WITH (READUNCOMMITTED)
				LEFT OUTER JOIN
			DMContainerITem CI WITH (READUNCOMMITTED)
		ON RS.ResultSetId = CI.ResultSetId
				LEFT OUTER JOIN
			DMDownloadResultSet DR WITH (READUNCOMMITTED)
		ON RS.ResultSetID = DR.ResultSetID
		WHERE CI.ResultSetId IS NULL AND DR.ResultSetID IS NULL
		)
		INSERT INTO #tmpResultSetIdsPrune
		SELECT DISTINCT RS.ResultSetID FROM
			DMResultSet AS RS WITH (READUNCOMMITTED)
				INNER JOIN
			CTE
		ON RS.ResultSetID = CTE.ResultSetID
		WHERE  (RS.Attribute & 128) = 0 AND		--skip files for edge
			(RS.CreateTime IS NULL OR DATEDIFF(HOUR, ISNULL(RS.CreateTime,@date), @date) > @pruneInterval ) AND
			(RS.RestoreTime IS NULL OR DATEDIFF(HOUR, ISNULL(RS.RestoreTime,@date), @date) > @pruneInterval )
		IF EXISTS (SELECT Top 1 * FROM #tmpResultSetIdsPrune)
		BEGIN
			SET @outputMessage = @outputMessage + '\n Number of resultSet eligible to prune [' +
				 CONVERT(VARCHAR(100),(SELECT COUNT(*) FROM #tmpResultSetIdsPrune)) +  ' ] '
			DECLARE @numRowsAffected BIGINT = 0
			DECLARE @deleteNumber INT = 1000
			SELECT @deleteNumber = ISNULL(SettingValue, 1000) FROM DMSetting
				WHERE SettingName = 'DELETE_BATCH_COUNT_FOR_RESULTSET'
			WHILE(EXISTS (SELECT Top 1 * FROM #tmpResultSetIdsPrune))
			BEGIN
				--prune DMACtion tables.no
				--
				DECLARE @ResultSetIds VARCHAR(MAX)
				SELECT @ResultSetIds = ISNULL(STUFF(
								(SELECT TOP (@deleteNumber) ';' "text()", ResultSetId "text()"
									FROM 	#tmpResultSetIdsPrune
									FOR XML PATH('')),1,1,''),'')
				EXEC sp_dm2_PruneActionInfo @i_resultSetIds = @ResultSetIds
				--Pruning of other tables may not be requred. since all other have delete cascase option enabled in is foreign key, it will automatically delete those entries
				--Anyway keep look on this statement
				--
				DELETE FROM DMResultSet
				WHERE ResultSetID IN (SELECT TOP (@deleteNumber) ResultSetId FROM #tmpResultSetIdsPrune)
				SET @numRowsAffected += @@ROWCOUNT
				DELETE TOP (@deleteNumber) FROM #tmpResultSetIdsPrune
			END
			SET @outputMessage = @outputMessage + '\n Total number rows affected in DMResultSet [' +
					 CONVERT(NVARCHAR(100),@numRowsAffected) + ' ] '
		END
		ELSE
		BEGIN
			SET @outputMessage = @outputMessage + '\n No ResultSet items are eligible for pruning'
		END
	END
	SET @o_OutputMessage = @outputMessage
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneOrphanReviewSetsAndResultItems')
	delete from GxQscripts where name = 'sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneOrphanReviewSetsAndResultItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneOrphanReviewSetsAndResultItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneOrphanReviewSetsAndResultItems',  '00010005000000000000', 'sp_dm2_PruneOrphanReviewSetsAndResultItems', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/APP_Upload_AddCacheInfo.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/APP_Upload_AddCacheInfo.sp,v $ $Id: APP_Upload_AddCacheInfo.sp,v 1.6 2014/10/22 22:56:11 gpattabiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APP_Upload_AddCacheInfo <<<'

IF EXISTS (select * from sysobjects where name='APP_Upload_AddCacheInfo')
	drop procedure APP_Upload_AddCacheInfo
IF EXISTS (select * from GxQscripts where name='APP_Upload_AddCacheInfo')
	delete from GxQscripts where name = 'APP_Upload_AddCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_Upload_AddCacheInfo')
	delete from GXDBVersions where aliasname = 'APP_Upload_AddCacheInfo'
GO
print '... Creating Procedure: APP_Upload_AddCacheInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APP_Upload_AddCacheInfo
  @i_header int,
  @i_entityId int,
  @i_entityType int,
  @i_userId int,
  @i_requestId nvarchar(1024),
  @i_destPath nvarchar(1024),
  @i_localPath nvarchar(1024),
  @i_fileSize bigint,
  @i_chunkOffset bigint,
  @i_flag int,
  @i_timestamp int
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode integer
SET @errorCode = 0
IF @i_header = 1
BEGIN
	IF NOT EXISTS (SELECT * FROM SyncUploadInfo WHERE requestId = @i_requestId)
		INSERT INTO SyncUploadInfo
		VALUES (@i_entityId, @i_entityType, @i_userId, @i_requestId, @i_destPath, @i_localPath, @i_fileSize, @i_chunkOffset, @i_flag, @i_timestamp, @i_timestamp)
	ELSE
		SET @errorCode = 1
END
ELSE
BEGIN
	IF EXISTS (SELECT * FROM SyncUploadInfo WHERE requestId = @i_requestId)
	BEGIN
		UPDATE SyncUploadInfo
		SET
		--flag = @i_flag,
		flag = (flag & 0xFFFFFFF0) | @i_flag, -- Add the flag without affecting sync flag bits.
		chunkOffset = @i_chunkOffset,
		modified = @i_timestamp
		WHERE requestId = @i_requestId
	END
	ELSE
		SET @errorCode = 1
END
GO

IF EXISTS (select * from GxQscripts where name = 'APP_Upload_AddCacheInfo')
	delete from GxQscripts where name = 'APP_Upload_AddCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_Upload_AddCacheInfo')
	delete from GXDBVersions where aliasname = 'APP_Upload_AddCacheInfo'
GO

insert into GXDBVersions values(2, 'APP_Upload_AddCacheInfo',  '00010006000000000000', 'APP_Upload_AddCacheInfo', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/APP_Upload_GetFileInfoToCopy.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/APP_Upload_GetFileInfoToCopy.sp,v $ $Id: APP_Upload_GetFileInfoToCopy.sp,v 1.5 2014/10/22 22:06:11 gpattabiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APP_Upload_GetFileInfoToCopy <<<'

IF EXISTS (select * from sysobjects where name='APP_Upload_GetFileInfoToCopy')
	drop procedure APP_Upload_GetFileInfoToCopy
IF EXISTS (select * from GxQscripts where name='APP_Upload_GetFileInfoToCopy')
	delete from GxQscripts where name = 'APP_Upload_GetFileInfoToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_Upload_GetFileInfoToCopy')
	delete from GXDBVersions where aliasname = 'APP_Upload_GetFileInfoToCopy'
GO
print '... Creating Procedure: APP_Upload_GetFileInfoToCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APP_Upload_GetFileInfoToCopy
  @i_restartProcessing int,
  @i_destClientId int
AS
SET NOCOUNT ON
-- Flag values: 0: Incomplete File, 1: Ready for Transfer, 2: Under Transfer Process, 3: Waiting for Work-Queue
-- Flag values defined in "AppMgr/AppMgrDefines.h"
-- Reset all Under Process entries, and try to send the files, when cvd restarts
IF @i_restartProcessing = 1
BEGIN
	UPDATE SyncUploadInfo
	SET flag = (flag & 0xFFFFFFF0) | 1 -- Add Ready flag without affecting sync flag bits.
	WHERE flag & 0xF = 2
	AND entityType = 3 --CLIENT_ENTITY
END
DECLARE @outputTbl TABLE
(requestId NVARCHAR(MAX),
 entityType INT,
 entityId INT,
 destPath NVARCHAR(MAX),
 localPath NVARCHAR(MAX)
 )
 DECLARE @blackListRetryInterval INT = 60*60
 DECLARE @nowTime INT
 SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
-- Request from cvd threads: i_destClientId = -1
-- Request from Work-Queue: i_destClientId = <valid destination client-id>
IF @i_destClientId <= 0
BEGIN
	INSERT INTO @outputTbl
	SELECT requestId, entityType, entityId, destPath, localPath FROM SyncUploadInfo
	WHERE ( (flag & 0xF = 1)
										OR
			((flag & 0xF = 5) AND ((modified + @blackListRetryInterval) <= @nowTime) )
			)
	AND entityType = 3 --CLIENT_ENTITY
END
ELSE
BEGIN
	INSERT INTO @outputTbl
	SELECT requestId, entityType, entityId, destPath, localPath FROM SyncUploadInfo
	WHERE entityId = @i_destClientId
	AND entityType = 3
	AND flag & 0xF = 3
	AND entityType = 3 --CLIENT_ENTITY
END
UPDATE SyncUploadInfo
SET flag = (flag & 0xFFFFFFF0) | 2 -- Add Processing Flag without affecting sync flag bits.
FROM SyncUploadInfo S
INNER JOIN @outputTbl O ON S.requestId = O.requestId
SELECT DISTINCT requestId, entityType, entityId, destPath, localPath FROM @outputTbl
GO

IF EXISTS (select * from GxQscripts where name = 'APP_Upload_GetFileInfoToCopy')
	delete from GxQscripts where name = 'APP_Upload_GetFileInfoToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_Upload_GetFileInfoToCopy')
	delete from GXDBVersions where aliasname = 'APP_Upload_GetFileInfoToCopy'
GO

insert into GXDBVersions values(2, 'APP_Upload_GetFileInfoToCopy',  '00010005000000000000', 'APP_Upload_GetFileInfoToCopy', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppSyncGetInfoForEdgeBackup.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/AppSyncGetInfoForEdgeBackup.sp,v $ $Id: AppSyncGetInfoForEdgeBackup.sp,v 1.4 2014/10/06 20:27:06 gpattabiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetInfoForEdgeBackup <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetInfoForEdgeBackup')
	drop procedure AppSyncGetInfoForEdgeBackup
IF EXISTS (select * from GxQscripts where name='AppSyncGetInfoForEdgeBackup')
	delete from GxQscripts where name = 'AppSyncGetInfoForEdgeBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetInfoForEdgeBackup')
	delete from GXDBVersions where aliasname = 'AppSyncGetInfoForEdgeBackup'
GO
print '... Creating Procedure: AppSyncGetInfoForEdgeBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetInfoForEdgeBackup
AS
SET NOCOUNT ON
DECLARE @nowTime INT
SET @nowTime = dbo.GetUnixTime(GETDATE())
DECLARE @syncRetryInterval INT = 60
DECLARE @requestIdTbl TABLE
(requestId NVARCHAR(MAX),
 userId INT)
INSERT INTO @requestIdTbl
SELECT requestId, userId
FROM SyncUploadInfo
WHERE entityType = 111 --SYNC_WEBFOLDER_ENTITY
AND ( (flag & 0xF = 1)  -- Upload Ready
                OR
	  ( (flag & 0xF = 3) AND ((modified + @syncRetryInterval) <= @nowTime) )  -- This  means backup is failed or killed and we have to try after retry interval time.
	)
AND flag &  (0x70) <> 0 --(0x10 | 0x20 | 0x40) Any sync upload for add/delete/rename. Definitions in appMgrDefines.h
UPDATE SyncUploadInfo
SET flag = (flag & 0xFFFFFFF0) | 2 -- Add Processing Flag without affecting sync flag bits.
FROM SyncUploadInfo S
INNER JOIN @requestIdTbl R ON S.requestId = R.requestId
SELECT DISTINCT userId FROM @requestIdTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetInfoForEdgeBackup')
	delete from GxQscripts where name = 'AppSyncGetInfoForEdgeBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetInfoForEdgeBackup')
	delete from GXDBVersions where aliasname = 'AppSyncGetInfoForEdgeBackup'
GO

insert into GXDBVersions values(2, 'AppSyncGetInfoForEdgeBackup',  '00010004000000000000', 'AppSyncGetInfoForEdgeBackup', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppSyncProcessEdgeBkpComplete.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/AppSyncProcessEdgeBkpComplete.sp,v $ $Id: AppSyncProcessEdgeBkpComplete.sp,v 1.3 2014/10/06 20:26:42 gpattabiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncProcessEdgeBkpComplete <<<'

IF EXISTS (select * from sysobjects where name='AppSyncProcessEdgeBkpComplete')
	drop procedure AppSyncProcessEdgeBkpComplete
IF EXISTS (select * from GxQscripts where name='AppSyncProcessEdgeBkpComplete')
	delete from GxQscripts where name = 'AppSyncProcessEdgeBkpComplete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncProcessEdgeBkpComplete')
	delete from GXDBVersions where aliasname = 'AppSyncProcessEdgeBkpComplete'
GO
print '... Creating Procedure: AppSyncProcessEdgeBkpComplete'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppSyncProcessEdgeBkpComplete
  @i_userId int,
  @i_jobStatus int
AS
SET NOCOUNT ON
BEGIN
	DECLARE @nowTime INT
	SET @nowTime = dbo.GetUnixTime(GETDATE())
	IF @i_jobStatus <> 1 --JMSUCCESS
	-- Job did not succeed. So mark all the processing items with workqueue flag.
	BEGIN
		UPDATE SyncUploadInfo
		SET flag = (flag & 0xFFFFFFF0) | 3, -- Add workqueue Flag without affecting sync flag bits.
			modified = @nowtime
		WHERE userId = @i_userId
		AND flag & 2 <> 0
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncProcessEdgeBkpComplete')
	delete from GxQscripts where name = 'AppSyncProcessEdgeBkpComplete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncProcessEdgeBkpComplete')
	delete from GXDBVersions where aliasname = 'AppSyncProcessEdgeBkpComplete'
GO

insert into GXDBVersions values(2, 'AppSyncProcessEdgeBkpComplete',  '00010003000000000000', 'AppSyncProcessEdgeBkpComplete', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppSyncAddUploadFileForDownload.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/AppSyncAddUploadFileForDownload.sp,v $ $Id: AppSyncAddUploadFileForDownload.sp,v 1.4 2015/04/16 18:52:36 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncAddUploadFileForDownload <<<'

IF EXISTS (select * from sysobjects where name='AppSyncAddUploadFileForDownload')
	drop procedure AppSyncAddUploadFileForDownload
IF EXISTS (select * from GxQscripts where name='AppSyncAddUploadFileForDownload')
	delete from GxQscripts where name = 'AppSyncAddUploadFileForDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncAddUploadFileForDownload')
	delete from GXDBVersions where aliasname = 'AppSyncAddUploadFileForDownload'
GO
print '... Creating Procedure: AppSyncAddUploadFileForDownload'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppSyncAddUploadFileForDownload
  @i_uploadReqId NVARCHAR(max),
  @i_documentId NVARCHAR(max),
  @i_CCN int
AS
SET NOCOUNT ON
BEGIN
	IF NOT EXISTS (SELECT * FROM DMResultSet WHERE documentID = @i_documentId)
	BEGIN
		INSERT INTO DMResultSet([ResultSetID]
			   ,[CommCellNumber]
			   ,[aFileID]
			   ,[aFileOffset]
			   ,[aFileLength]
			   ,[AppType]
			   ,[FileSizeKB]
			   ,[ModifiedTime]
			   ,[OriginalFullPath]
			   ,[DestinationPath]
			   ,RestoreStatus
			   ,[CreateTime]
			   ,JobId
			   ,RestoreUserGUID
			   ,RestoreCommCellNumber
			   ,RestoreJobID
			   ,Attribute
			   ,documentID
			   ,ClientID
			   ,ERMStatus
			   ,Title)
		SELECT NEWID(),@i_CCN,0,0,0,33, (fileSize/1024), dbo.getdatetime(modified), @i_documentId, localPath, 4, dbo.getdatetime(created ), 0, userId, 0, 0, 0, @i_documentId, 0, 0, destPath
		FROM SyncUploadInfo
		WHERE requestId = @i_uploadReqId
	END
	ELSE
	BEGIN
		UPDATE DMResultSet
		SET
			[FileSizeKB] = (S.fileSize/1024),
			[ModifiedTime] = dbo.getdatetime(S.modified),
			[DestinationPath] = S.localPath,
			[CreateTime] = dbo.getdatetime(S.created ),
			[Title] = S.destPath,
			Attribute = 0
		FROM SyncUploadInfo S
		WHERE documentID = @i_documentId
		AND S.requestId = @i_uploadReqId
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncAddUploadFileForDownload')
	delete from GxQscripts where name = 'AppSyncAddUploadFileForDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncAddUploadFileForDownload')
	delete from GXDBVersions where aliasname = 'AppSyncAddUploadFileForDownload'
GO

insert into GXDBVersions values(2, 'AppSyncAddUploadFileForDownload',  '00010004000000000000', 'AppSyncAddUploadFileForDownload', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddEmailShare.sp] ---------- 

 SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddEmailShare <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddEmailShare')
	drop procedure sp_dm2_AddEmailShare
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddEmailShare')
	delete from GxQscripts where name = 'sp_dm2_AddEmailShare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddEmailShare')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddEmailShare'
GO
print '... Creating Procedure: sp_dm2_AddEmailShare'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddEmailShare
  @i_DownLoadID varchar(36) = '',
  @i_Token varchar(36)='',
  @i_EmailList nvarchar(max) = '',
  @i_DownloadLink nvarchar(max)='',
  @i_Type int=0,
  @i_Message nvarchar(max)='',
  @i_Flag int=0
AS
SET NOCOUNT ON
insert into DMEmailShare(DownLoadID,EmailList,DownloadLink,Token,Type,Message,Flag,CreateTime) values(@i_DownLoadID,@i_EmailList,@i_DownloadLink,@i_Token,@i_Type,@i_Message,@i_Flag,GETUTCDATE())
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddEmailShare')
	delete from GxQscripts where name = 'sp_dm2_AddEmailShare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddEmailShare')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddEmailShare'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddEmailShare',  '00000000000000000000', 'sp_dm2_AddEmailShare', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetEmailShare.sp] ---------- 

 SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetEmailShare <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetEmailShare')
	drop procedure sp_dm2_GetEmailShare
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetEmailShare')
	delete from GxQscripts where name = 'sp_dm2_GetEmailShare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetEmailShare')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetEmailShare'
GO
print '... Creating Procedure: sp_dm2_GetEmailShare'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetEmailShare
  @i_DownloadId varchar(36) = '',
  @i_Token varchar(36) = '',
  @i_Mode int =0
AS
SET NOCOUNT ON
if @i_Mode=1
select * from DMEmailShare WITH (READUNCOMMITTED) where DownloadId=@i_DownloadId and Token = @i_Token
else
select * from DMEmailShare WITH (READUNCOMMITTED) where  Token = @i_Token
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetEmailShare')
	delete from GxQscripts where name = 'sp_dm2_GetEmailShare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetEmailShare')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetEmailShare'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetEmailShare',  '00000000000000000000', 'sp_dm2_GetEmailShare', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetEmailShareFileName.sp] ---------- 

 SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetEmailShareFileName <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetEmailShareFileName')
	drop procedure sp_dm2_GetEmailShareFileName
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetEmailShareFileName')
	delete from GxQscripts where name = 'sp_dm2_GetEmailShareFileName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetEmailShareFileName')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetEmailShareFileName'
GO
print '... Creating Procedure: sp_dm2_GetEmailShareFileName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetEmailShareFileName
  @i_DownLoadID varchar(36) = ''
AS
SET NOCOUNT ON
DECLARE @type int
DECLARE @sharedFileName nvarchar(100)
select @type=Type from DMEmailShare where DownloadID=@i_DownLoadID
if @type=1
begin
	select d2.OriginalFullPath as SharedFileName from DMDownloadResultSet d1, DMResultSet d2 where d1.DownloadID= @i_DownLoadID and d1.ResultSetID=d2.ResultSetID
end
else
begin
	select 'Download_'+CAST(DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()) as varchar) + '.zip' as SharedFileName from DMDownload where DownLoadID=@i_DownLoadID
end
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetEmailShareFileName')
	delete from GxQscripts where name = 'sp_dm2_GetEmailShareFileName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetEmailShareFileName')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetEmailShareFileName'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetEmailShareFileName',  '00000000000000000000', 'sp_dm2_GetEmailShareFileName', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_InitPruning.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_InitPruning()
--  | Description:  This sp will create new tables for pruning and if suppose table alread exists, then delete it.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_InitPruning.sp,v $ $Id: sp_dm2_InitPruning.sp,v 1.2 2013/12/28 03:35:36 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_InitPruning <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_InitPruning')
	drop procedure sp_dm2_InitPruning
IF EXISTS (select * from GxQscripts where name='sp_dm2_InitPruning')
	delete from GxQscripts where name = 'sp_dm2_InitPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_InitPruning')
	delete from GXDBVersions where aliasname = 'sp_dm2_InitPruning'
GO
print '... Creating Procedure: sp_dm2_InitPruning'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_InitPruning
AS
BEGIN
	DECLARE @o_message NVARCHAR(MAX)
	/*
		This sp will create new tables and if suppose table alread exists, then delete it.
		if DMSetting key [REUSE_EXISTING_PRUNE_TABLE] with value [true] is present, then we will reuse existing atble
	*/
	DECLARE @l_reuse_table BIT = 0
	SET @o_message =  ''
	IF EXISTS ( SELECT * FROM DMSetting WHERE SettingName = 'REUSE_EXISTING_PRUNE_TABLE' AND SettingValue = 'TRUE')
	BEGIN
		SET @o_message =' REUSE_EXISTING_PRUNE_TABLE key is present, will not delete table if already exists.. '
		SET @l_reuse_table = 1;
	END
	--delete if exists
	--
	if object_id('DM2TempReferencePath') is not null AND (@l_reuse_table = 0)
	BEGIN
		DROP TABLE DM2TempReferencePath
		SET @o_message = '\n' + @o_message + ' Deleted DM2TempReferencePath table'
	END
	if object_id('DM2TempCacheFileList') is not null AND (@l_reuse_table = 0)
	BEGIN
		DROP TABLE DM2TempCacheFileList
		SET @o_message = '\n' + @o_message + ' Deleted DM2TempCacheFileList table'
	END
	--CREAT tables
	if object_id('DM2TempReferencePath') is null
	BEGIN
		CREATE TABLE DM2TempReferencePath(
			 id INT IDENTITY(1,1) PRIMARY KEY,
			 destinationPath NVARCHAR(MAX) NOT NULL,
			 chkSum VARCHAR(32) NOT NULL
		);
		CREATE INDEX IDX_DM2TempReferencePath_1 ON DM2TempReferencePath(chkSum);
		SET @o_message = '\n' + @o_message + ' Created DM2TempReferencePath table.. '
	END
	if object_id('DM2TempCacheFileList') is null
	BEGIN
		CREATE TABLE DM2TempCacheFileList(
			id INT IDENTITY(1,1) PRIMARY KEY,
			cachePath NVARCHAR(MAX) NOT NULL,
			chkSum VARCHAR(32) NOT NULL
		);
		CREATE INDEX IDX_DM2TempCacheFileList_1 ON DM2TempCacheFileList(chkSum);
		SET @o_message = '\n' + @o_message + ' Created DM2TempCacheFileList table.. '
	END
	SELECT @o_message 'Message'
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_InitPruning')
	delete from GxQscripts where name = 'sp_dm2_InitPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_InitPruning')
	delete from GXDBVersions where aliasname = 'sp_dm2_InitPruning'
GO

insert into GXDBVersions values(2, 'sp_dm2_InitPruning',  '00010002000000000000', 'sp_dm2_InitPruning', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddCacheFileListBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_AddCacheFileListBulk()
--  | Description:  Add inputfiles to the DM2TempCacheFileList table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddCacheFileListBulk.sp,v $ $Id: sp_dm2_AddCacheFileListBulk.sp,v 1.2 2013/12/28 03:35:36 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddCacheFileListBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddCacheFileListBulk')
	drop procedure sp_dm2_AddCacheFileListBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddCacheFileListBulk')
	delete from GxQscripts where name = 'sp_dm2_AddCacheFileListBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddCacheFileListBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddCacheFileListBulk'
GO
print '... Creating Procedure: sp_dm2_AddCacheFileListBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddCacheFileListBulk
  @i_filePathList NVARCHAR(MAX),
  @o_errrorCode INT OUTPUT,
  @o_errorMessage NVARCHAR(MAX) OUTPUT
AS
BEGIN
	/*
		sp_dm2_InitPruning myst be called before invoking this SP.
	*/
	--DECLARE @o_errrorCode	INT;
	--DECLARE @o_errorMessage	NVARCHAR(MAX);
	--if table is not created, return error.
	if (object_id('DM2TempCacheFileList') is null)
	BEGIN
		SELECT @o_errrorCode = 1, @o_errorMessage = 'Tables DM2TempCacheFileList is not created. '
		GOTO EXIT_;
	END
	DECLARE @FileList TABLE ( filePath NVARCHAR(MAX)) ;
	DECLARE @i_xml XML =  @i_filePathList
	/*
		format of i_xml
		'<PathList>
			<path val ="c:\test\a;t.t"/>
			<path val ="c:\test1\b.t"/>
			<path val ="c:\test2\c.t"/>
		</PathList>'
	*/
	INSERT INTO @FileList
	SELECT distinct ref.value('@val','nvarchar(MAX)')
	FROM @i_xml.nodes('PathList/path') R(ref)
	--Now insert into
	INSERT INTO DM2TempCacheFileList (cachePath, chkSum)
	SELECT F.filePath, dbo.fn_HashData(UPPER(F.filePath)) FROM @FileList as F
	WHERE ISNULL(F.filePath,'') <> ''
	SELECT @o_errrorCode = 0, @o_errorMessage = 'Inserted ' + CONVERT(VARCHAR(10),@@ROWCOUNT) + ' into cache temp table'
	EXIT_:
		RETURN
		--SELECT @o_errrorCode 'ErrorCode', @o_errorMessage 'Message'
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddCacheFileListBulk')
	delete from GxQscripts where name = 'sp_dm2_AddCacheFileListBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddCacheFileListBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddCacheFileListBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddCacheFileListBulk',  '00010002000000000000', 'sp_dm2_AddCacheFileListBulk', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PopulateAndUpdateFilesToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PopulateAndUpdateFilesToPrune()
--  | Description:  Update DM2TempCacheFileList table after finding reference
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PopulateAndUpdateFilesToPrune.sp,v $ $Id: sp_dm2_PopulateAndUpdateFilesToPrune.sp,v 1.2 2013/12/28 03:35:36 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PopulateAndUpdateFilesToPrune <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PopulateAndUpdateFilesToPrune')
	drop procedure sp_dm2_PopulateAndUpdateFilesToPrune
IF EXISTS (select * from GxQscripts where name='sp_dm2_PopulateAndUpdateFilesToPrune')
	delete from GxQscripts where name = 'sp_dm2_PopulateAndUpdateFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PopulateAndUpdateFilesToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_PopulateAndUpdateFilesToPrune'
GO
print '... Creating Procedure: sp_dm2_PopulateAndUpdateFilesToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PopulateAndUpdateFilesToPrune
  @o_errrorCode INT OUTPUT,
  @o_errorMessage NVARCHAR(MAX) OUTPUT
AS
BEGIN
	/*
		Before this SP is called,
			sp_dm2_InitPruning must be called in order to create tables..
			And cachefile list table(DM2TempCacheFileList) must be populated.
		Flow,
			- Entries must exists DM2TempCacheFileList table, else return
			- Populate destinationPath from all reference tables into DM2TempReferencePath table. [Not this can be little time consuming]
			- delete entries from cachefile table which have reference to Reference table.
	*/
	--DECLARE @o_errrorCode	INT;
	--DECLARE @o_errorMessage	NVARCHAR(MAX);
	--if any table is not created, return error.
	if object_id('DM2TempReferencePath') is null OR (object_id('DM2TempCacheFileList') is null)
	BEGIN
		SELECT @o_errrorCode = 1, @o_errorMessage = 'Tables(DM2TempCacheFileList,DM2TempReferencePath) is/are not created. '
		GOTO EXIT_;
	END
	--
	IF NOT EXISTS (SELECT TOP 1 * FROM DM2TempCacheFileList)
	BEGIN
		SELECT @o_errrorCode = 2, @o_errorMessage = 'DM2TempCacheFileList table is empty, pruning not requried..'
		GOTO EXIT_;
	END
	--delete the content from reference table
	DELETE DM2TempReferencePath
	-- now poulate reference table
	/*
		Tables:
			The table used in reference check.
				1. [DMContainerExport]			-- DestPath
				2. [DMDownload]					-- CabFilePath/DestinationPath
				3. [DMResultSet]				-- DestinationPath
				4. [DMLegalHoldItemsToBackup]	-- OrginalPath (where BackupStatus <> 1 AND ContainerID = '')
	 */
	--[DMContainerExport]
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT distinct DestPath, '' FROM [DMContainerExport] WITH (NOLOCK)
	WHERE ISNULL(DestPath,'') <> ''
	--DMDownload (cabfilePath)
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT CabFilePath, '' FROM DMDownload AS D WITH (NOLOCK)
	WHERE ISNULL(CabFilePath,'') <> ''
	--DMDownload (destinationPath)
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT distinct DestinationPath, '' FROM DMDownload AS D WITH (NOLOCK)
	WHERE ISNULL(DestinationPath,'') <> ''
	-- DMResultSet
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT DestinationPath, '' FROM DMResultSet WITH (NOLOCK)
	WHERE LEN(ISNULL(Destinationpath,''))>0
	-- DMLegalHoldItemsToBackup	-- OrginalPath (where BackupStatus <> 1 AND ContainerID = '')
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT D.OriginalPath, '' FROM DMLegalHoldItemsToBackup AS D  WITH (READUNCOMMITTED)
	WHERE	D.BackupStatus <> 1 AND ( ISNULL(D.ContainerID, '') = '' ) AND
			ISNULL(D.OriginalPath,'') <> ''
	--now update hash function
	UPDATE DM2TempReferencePath
	SET chkSum = dbo.fn_HashData(UPPER(destinationPath))
	--delete duplicate entries from reference table
	;WITH cte
		 AS (SELECT ROW_NUMBER() OVER (PARTITION BY chkSum ORDER BY id asc) RN
			 FROM   DM2TempReferencePath)
	DELETE FROM cte
	WHERE  RN > 1
	DECLARE @l_tempCount1 INT,
			@l_tempCount2 INT
	SELECT @l_tempCount1 = COUNT(*) FROM DM2TempCacheFileList
	SELECT @l_tempCount2 = COUNT(*) FROM DM2TempReferencePath
	--updated row count
	SELECT @o_errorMessage = ' Total Count in DM2TempCacheFileList ['+ CONVERT(VARCHAR(10),@l_tempCount1) + '], DM2TempReferencePath ['+ CONVERT(VARCHAR(10),@l_tempCount2) + ']..'
	-- start deleting which ever matches the reference table
	--
	DELETE Cache
	FROM
		DM2TempCacheFileList Cache
			INNER JOIN
		DM2TempReferencePath ref
	ON cache.chkSum = ref.chkSum
	SELECT @o_errrorCode = 0, @o_errorMessage = @o_errorMessage + ' Total rows deleted in after reference table map : ' + CONVERT(VARCHAR(10),@@ROWCOUNT)
EXIT_:
	RETURN
	--SELECT @o_errrorCode 'ErrorCode', @o_errorMessage 'Message'
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PopulateAndUpdateFilesToPrune')
	delete from GxQscripts where name = 'sp_dm2_PopulateAndUpdateFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PopulateAndUpdateFilesToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_PopulateAndUpdateFilesToPrune'
GO

insert into GXDBVersions values(2, 'sp_dm2_PopulateAndUpdateFilesToPrune',  '00010002000000000000', 'sp_dm2_PopulateAndUpdateFilesToPrune', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetCacheFileListToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetCacheFileListToPrune()
--  | Description:  Get top x files from DM2TempCacheFileList table and delete the same from it
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetCacheFileListToPrune.sp,v $ $Id: sp_dm2_GetCacheFileListToPrune.sp,v 1.2 2013/12/28 03:35:36 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetCacheFileListToPrune <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetCacheFileListToPrune')
	drop procedure sp_dm2_GetCacheFileListToPrune
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetCacheFileListToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetCacheFileListToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetCacheFileListToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetCacheFileListToPrune'
GO
print '... Creating Procedure: sp_dm2_GetCacheFileListToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetCacheFileListToPrune
  @i_offset INT,
  @o_totalCount INT OUTPUT,
  @o_outputMessage NVARCHAR(MAX) OUTPUT
AS
BEGIN
	/*
		This SP will fetch top N(@i_offset) from cacheFileList table, and delete the same after retrieving
	*/
	if object_id('tempdb.dbo.#DM2TempCacheFileList') is not null
			DROP TABLE #DM2TempCacheFileList
		create table #DM2TempCacheFileList
		(	id				int ,
			FilePath		NVARCHAR(MAX))
	--if table is not created, return error.
	if (object_id('DM2TempCacheFileList') is null)
	BEGIN
		SELECT @o_totalCount = 0, @o_outputMessage = 'Table DM2TempCacheFileList is not created. '
	END
	ELSE
	BEGIN
		--check @i_offset > 0, else set default 1000
		--
		SELECT @o_totalCount = COUNT(t.id) FROM DM2TempCacheFileList as T
		IF( @o_totalCount > 0)
		BEGIN
			INSERT INTO #DM2TempCacheFileList(id,FilePath)
			SELECT TOP (@i_offset)t.id, t.cachePath 'FilePath' FROM DM2TempCacheFileList as t
			--delete the same
			DELETE FROM DM2TempCacheFileList WHERE id in (SELECT t.id FROM #DM2TempCacheFileList as t)
		END
	END
	SELECT T.FilePath FROM #DM2TempCacheFileList as T
	if object_id('tempdb.dbo.#DM2TempCacheFileList') is not null
			DROP TABLE #DM2TempCacheFileList
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetCacheFileListToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetCacheFileListToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetCacheFileListToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetCacheFileListToPrune'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetCacheFileListToPrune',  '00010002000000000000', 'sp_dm2_GetCacheFileListToPrune', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateUserSessionBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateUserSessionBulk.sp,v $ $Id: sp_dm2_UpdateUserSessionBulk.sp,v 1.3 2014/07/31 03:55:51 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateUserSessionBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateUserSessionBulk')
	drop procedure sp_dm2_UpdateUserSessionBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateUserSessionBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateUserSessionBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateUserSessionBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateUserSessionBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateUserSessionBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateUserSessionBulk
  @i_inputxml VARCHAR(MAX)
AS
	BEGIN
		/**
			Based on input XML we parse and update DMUSerSession with input lastaccesstime.
			If any of the session is not found or exceeding timeoutInMin , then consider that as invalid and return that back
			NOTE: This SP assumes that Session already exists, it wont insert new entry. just update lastAccessTime, if entry is not foud. it will considered as invalid entry
			--sample XML
			<SessionMap>
				  <session id="8F6257B8-EC92-4D47-BB66-14589CA98E41" lastaccesstime="2014-07-08T07:19:52" />
				  <session id="F91273FC-4861-445A-8C8B-52BCB686B3ED" lastaccesstime="2014-07-08T07:16:52" />
				  <session id="UIOP8905-4861-445A-8C8B-52BCB686B3EW" lastaccesstime="2014-07-08T07:14:52" />
			</SessionMap>
		*/
		--constants
		DECLARE @C_TIMEOUT		INT			= 30
		DECLARE @C_CURRENT_TIME DATETIME	= GETUTCDATE()
		SELECT @C_TIMEOUT = ISNULL(SettingValue ,30) FROM DMSetting WHERE SettingName = 'SESSION_TIME_OUT'
		IF object_id('tempdb.dbo.#tmpSessionInfo') IS NOT NULL
			DROP TABLE #tmpSessionInfo
		IF object_id('tempdb.dbo.#tmpInvalidSession') IS NOT NULL
			DROP TABLE #tmpInvalidSession
		CREATE TABLE #tmpSessionInfo(
			SessionId			VARCHAR(36),
			lastAccessTime		DATETIME,
			origIsExists		BIT DEFAULT 0,	--updated to 1, if entry exists in DMUserSession Table
			origLastAccessTime	DATETIME,
			origTimeOut			INT		DEFAULT 30,
			origAttribute		INT
		)
		CREATE TABLE #tmpInvalidSession(
			SessionId VARCHAR(36)
		)
		DECLARE @l_XML XML = @i_inputxml
		--insert into temp table
		INSERT INTO #tmpSessionInfo(SessionId, lastAccessTime)
		SELECT ISNULL(T.col.value('@id','VARCHAR(36)'),0) AS SessionId,
			   T.col.value('@lastaccesstime','DATETIME')  AS lastAccessTime
		FROM @l_XML.nodes('SessionMap/session') AS T(col)
		--update temp table with lastaccesstime of the DMUserSession tab;e
		--
		UPDATE  tSI
		SET tSI.origIsExists		= 1,
			tSI.origLastAccessTime	= ISNULL(dUS.lastAccessTime,dUS.CreateTime),
			tSI.origTimeOut			= ISNULL(dUS.TimeOutInMin,@C_TIMEOUT),
			tSI.origAttribute		= dUS.Attribute
		FROM #tmpSessionInfo tSI
			INNER JOIN
			DMUserSession dUS WITH (NOLOCK)
		ON tSI.SessionId = dUS.SessionID
		/*
			Invalid SessionId Criteria Cases when
				- sessionId doesnt exists in DMUserSession
				- input time is less than table access time
				- logout happened
				- orig table access time is > input last access time
		*/
		INSERT INTO #tmpInvalidSession
		SELECT tSI.SessionId FROM #tmpSessionInfo tSI
		WHERE	tSI.origIsExists <> 1 OR
				tSI.lastAccessTime < tSI.origLastAccessTime OR -- case when input time is less than table access time
				tSI.origAttribute & 4 <> 0 OR -- case when logout happened
				DATEDIFF(minute, tSI.origLastAccessTime, tSI.lastAccessTime) > tSI.origTimeOut  -- orig table access time is > input last access time
		--now delete from temp table
		DELETE #tmpSessionInfo
		WHERE #tmpSessionInfo.SessionId IN
				(SELECT tIS.SessionId FROM #tmpInvalidSession as tIS )
		--update DMUserSession table
		UPDATE US
		SET		LastAccessTime = tSI.lastAccessTime
		FROM	DMUserSession US INNER JOIN #tmpSessionInfo tSI
			ON US.SessionID = tSI.SessionId
		--return back invalid sessionIds
		SELECT * from #tmpInvalidSession
		IF object_id('tempdb.dbo.#tmpSessionInfo') IS NOT NULL
			DROP TABLE #tmpSessionInfo
		IF object_id('tempdb.dbo.#tmpInvalidSession') IS NOT NULL
			DROP TABLE #tmpInvalidSession
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateUserSessionBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateUserSessionBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateUserSessionBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateUserSessionBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateUserSessionBulk',  '00010003000000000000', 'sp_dm2_UpdateUserSessionBulk', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddFavorites.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddFavorites <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddFavorites')
	drop procedure sp_dm2_AddFavorites
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddFavorites')
	delete from GxQscripts where name = 'sp_dm2_AddFavorites'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddFavorites')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddFavorites'
GO
print '... Creating Procedure: sp_dm2_AddFavorites'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddFavorites
  @FavoriteList DMFavoritesType READONLY
AS
SET NOCOUNT ON
MERGE DMFavorites AS t
    USING (SELECT userId, clientId, subclientId, filePath, fileDisplayName, fileModificationTime, isFolder, flag, isLiveBrowse, created, modified from @FavoriteList ) AS s
    ON (t.userId = s.userId and t.clientId=s.clientId and t.subclientId=s.subclientId and t.filePath=s.filePath)
    WHEN MATCHED THEN
        UPDATE SET t.fileDisplayName=s.fileDisplayName, t.isFolder=s.isFolder, t.fileModificationTime=s.fileModificationTime, t.flag=s.flag, t.isLiveBrowse=s.isLiveBrowse, t.modified=s.modified
	WHEN NOT MATCHED THEN
	    INSERT (userId, clientId, subclientId, filePath, fileDisplayName, fileModificationTime, isFolder, isliveBrowse, flag, created, modified)
	    VALUES (s.userId, s.clientId, s.subclientId, s.filePath, s.fileDisplayName, s.fileModificationTime, s.isFolder, s.isLiveBrowse, s.flag, s.created, s.modified) ;
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddFavorites')
	delete from GxQscripts where name = 'sp_dm2_AddFavorites'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddFavorites')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddFavorites'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddFavorites',  '00000000000000000000', 'sp_dm2_AddFavorites', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetFavorites.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetFavorites <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetFavorites')
	drop procedure sp_dm2_GetFavorites
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetFavorites')
	delete from GxQscripts where name = 'sp_dm2_GetFavorites'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetFavorites')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetFavorites'
GO
print '... Creating Procedure: sp_dm2_GetFavorites'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetFavorites
  @userId int = 0,
  @clientId int =0
AS
SET NOCOUNT ON
if @clientId=0
begin
	select clientId, subclientId, filePath, fileDisplayName, fileModificationTime, isFolder, isLiveBrowse from DMFavorites where userId=@userId
end
else
begin
	select clientId, subclientId, filePath, fileDisplayName, fileModificationTime, isFolder, isLiveBrowse from DMFavorites where userId=@userId and clientId=@clientId
end
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetFavorites')
	delete from GxQscripts where name = 'sp_dm2_GetFavorites'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetFavorites')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetFavorites'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetFavorites',  '00000000000000000000', 'sp_dm2_GetFavorites', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_RemoveFavorites.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_RemoveFavorites <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_RemoveFavorites')
	drop procedure sp_dm2_RemoveFavorites
IF EXISTS (select * from GxQscripts where name='sp_dm2_RemoveFavorites')
	delete from GxQscripts where name = 'sp_dm2_RemoveFavorites'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RemoveFavorites')
	delete from GXDBVersions where aliasname = 'sp_dm2_RemoveFavorites'
GO
print '... Creating Procedure: sp_dm2_RemoveFavorites'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_RemoveFavorites
  @FavoriteList DMFavoritesType READONLY
AS
SET NOCOUNT ON
delete from DMFavorites where exists(select * from @FavoriteList t2 where DMFavorites.userId=t2.userId and DMFavorites.clientId=t2.clientId and DMFavorites.subclientId=t2.subclientId and  DMFavorites.filePath=t2.filePath)
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_RemoveFavorites')
	delete from GxQscripts where name = 'sp_dm2_RemoveFavorites'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RemoveFavorites')
	delete from GXDBVersions where aliasname = 'sp_dm2_RemoveFavorites'
GO

insert into GXDBVersions values(2, 'sp_dm2_RemoveFavorites',  '00000000000000000000', 'sp_dm2_RemoveFavorites', '00000000000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppSyncAddMultiFileForDownload.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/AppSyncAddMultiFileForDownload.sp,v $ $Id: AppSyncAddMultiFileForDownload.sp,v 1.3 2014/10/17 19:04:55 gpattabiraman Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncAddMultiFileForDownload <<<'

IF EXISTS (select * from sysobjects where name='AppSyncAddMultiFileForDownload')
	drop procedure AppSyncAddMultiFileForDownload
IF EXISTS (select * from GxQscripts where name='AppSyncAddMultiFileForDownload')
	delete from GxQscripts where name = 'AppSyncAddMultiFileForDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncAddMultiFileForDownload')
	delete from GXDBVersions where aliasname = 'AppSyncAddMultiFileForDownload'
GO
print '... Creating Procedure: AppSyncAddMultiFileForDownload'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppSyncAddMultiFileForDownload
  @i_downloadId NVARCHAR(max),
  @i_documentId NVARCHAR(max),
  @i_containerId NVARCHAR(max),
  @i_downloadSetId NVARCHAR(max),
  @i_userGUID NVARCHAR(max),
  @i_setRestoreDone INT
AS
SET NOCOUNT ON
BEGIN
	IF @i_downloadId IS NULL OR LEN(@i_downloadId) = 0
	BEGIN
		SET @i_downloadId = NEWID()
		INSERT INTO DMDownload(DownLoadID
           ,DestinationPath
           ,Description
           ,FileType
           ,FileSizeKB
           ,UserGUID
           ,ContainerID
           ,Status
           ,Attribute
           ,CreateTime
           ,DownloadTime
           ,RestoreJobID
           ,DownLoadSetID)
        VALUES (@i_downloadId, '', '', 5, 0, @i_userGUID, @i_containerId, 1 /*DOWNLOADSTATUS_PENDING*/, 0, GETDATE(), null, 0, @i_downloadSetId)
	END
	IF EXISTS (SELECT * FROM DMResultSet WHERE documentID = @i_documentId)
	AND NOT EXISTS(SELECT * FROM DMDownloadResultSet WHERE DownloadID = @i_downloadId AND ResultSetID = @i_documentId)
	BEGIN
		INSERT INTO DMDownloadResultSet
           (DownloadID
           ,ResultSetID
           ,AppType
           ,Status
           ,CreateTime
           ,FileName)
		VALUES
           (@i_downloadId
           ,(SELECT ResultSetID FROM DMResultSet WHERE documentID = @i_documentId)
           ,33
           ,100 /*DOWNLOADITEMSTATUS_OK*/
           ,GETDATE()
           ,(SELECT DestinationPath FROM DMResultSet WHERE documentID = @i_documentId))
	END
	SELECT @i_downloadId AS downloadId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncAddMultiFileForDownload')
	delete from GxQscripts where name = 'AppSyncAddMultiFileForDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncAddMultiFileForDownload')
	delete from GXDBVersions where aliasname = 'AppSyncAddMultiFileForDownload'
GO

insert into GXDBVersions values(2, 'AppSyncAddMultiFileForDownload',  '00010003000000000000', 'AppSyncAddMultiFileForDownload', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppUpdateSubclientRecallInfo.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/AppUpdateSubclientRecallInfo.sp,v $ $Id: AppUpdateSubclientRecallInfo.sp,v 1.2 2015/01/28 19:43:12 gpattabiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateSubclientRecallInfo <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateSubclientRecallInfo')
	drop procedure AppUpdateSubclientRecallInfo
IF EXISTS (select * from GxQscripts where name='AppUpdateSubclientRecallInfo')
	delete from GxQscripts where name = 'AppUpdateSubclientRecallInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSubclientRecallInfo')
	delete from GXDBVersions where aliasname = 'AppUpdateSubclientRecallInfo'
GO
print '... Creating Procedure: AppUpdateSubclientRecallInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateSubclientRecallInfo
  @i_xml XML
AS
SET NOCOUNT ON
DECLARE @i_subclientId INT = ISNULL(( SELECT ref.value('@subclientId', 'int')
									FROM   @i_xml . nodes('TMMsg_JMEndJobReq/subclientRecallInfo/subclient') R ( ref )
								), 0)
DECLARE @i_commcellId INT = ISNULL(( SELECT ref.value('@commCellId', 'int')
									FROM   @i_xml . nodes('TMMsg_JMEndJobReq/subclientRecallInfo/subclient') R ( ref )
								), 0)
DECLARE @i_appTypeId INT = ISNULL(( SELECT ref.value('@applicationId', 'int')
									FROM   @i_xml . nodes('TMMsg_JMEndJobReq/subclientRecallInfo/subclient') R ( ref )
								), 0)
DECLARE @i_mediaAgentName NVARCHAR(MAX) = ISNULL(( SELECT ref.value('@mediaAgentName', 'nvarchar(max)')
									FROM   @i_xml . nodes('TMMsg_JMEndJobReq/subclientRecallInfo/mediaAgent') R ( ref )
								), 0)
DECLARE @i_indexAFileTime INT = ISNULL(( SELECT ref.value('@indexingAfileTimeStamp', 'int')
										FROM   @i_xml . nodes('TMMsg_JMEndJobReq/subclientRecallInfo') R ( ref )
								), 0)
DECLARE @i_jobId INT = ISNULL(( SELECT ref.value('@jobID', 'int')
									FROM   @i_xml . nodes('TMMsg_JMEndJobReq') R ( ref )
								), 0)
DECLARE @currentTime INT = dbo.GetUnixTime(GETUTCDATE())
IF NOT EXISTS(SELECT 1 FROM AppSubclientRecallInfo WHERE subclientId = @i_subclientId)
BEGIN
	INSERT INTO AppSubclientRecallInfo(subclientId, commcellId, appTypeId, mediaAgentMangledName, backupJobId, indexAfileTimeStamp, updatedTime)
	VALUES(@i_subclientId, @i_commcellId, @i_appTypeId, @i_mediaAgentName, @i_jobId, @i_indexAFileTime, @currentTime)
END
ELSE
BEGIN
	UPDATE AppSubclientRecallInfo
	SET commcellId = @i_commcellId,
		appTypeId = @i_appTypeId,
		mediaAgentMangledName = @i_mediaAgentName,
		backupJobId = @i_jobId,
		indexAfileTimeStamp = @i_indexAFileTime,
		updatedTime = @currentTime
	WHERE subclientId = @i_subclientId
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateSubclientRecallInfo')
	delete from GxQscripts where name = 'AppUpdateSubclientRecallInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateSubclientRecallInfo')
	delete from GXDBVersions where aliasname = 'AppUpdateSubclientRecallInfo'
GO

insert into GXDBVersions values(2, 'AppUpdateSubclientRecallInfo',  '00010002000000000000', 'AppUpdateSubclientRecallInfo', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppSyncGetUploadCacheFilesToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetSyncUploadCacheFilesToPrune()
--  | Description:  Get the files from SyncUploadCache folder for pruning
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/AppSyncGetUploadCacheFilesToPrune.sp,v $ $Id: AppSyncGetUploadCacheFilesToPrune.sp,v 1.2 2015/02/14 18:16:03 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetUploadCacheFilesToPrune <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetUploadCacheFilesToPrune')
	drop procedure AppSyncGetUploadCacheFilesToPrune
IF EXISTS (select * from GxQscripts where name='AppSyncGetUploadCacheFilesToPrune')
	delete from GxQscripts where name = 'AppSyncGetUploadCacheFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetUploadCacheFilesToPrune')
	delete from GXDBVersions where aliasname = 'AppSyncGetUploadCacheFilesToPrune'
GO
print '... Creating Procedure: AppSyncGetUploadCacheFilesToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetUploadCacheFilesToPrune
  @i_batchCount INT = 0,
  @i_maxId INT = 0
AS
BEGIN
	/*
		Return top N (batchCount) which ever matching below criteria order by id column
		Criteria
			- .lck files ==> EntityType = 3 and DateDiff > 2 days
			- laptop files ==> EntityType= 111 and DateDiff > 21 days
	*/
	--DECLARE @currDate	DATETIME = GETDATE()
	declare @currUnixTime INT = dbo.GetUnixTime(GETDATE())
	DECLARE @lckPruneInterval INT = 48  -- default 2 days
	DECLARE @laptopPruneInterval INT = 504  -- default 21 days
	DECLARE @enableLCKPruning		BIT = 1
	DECLARE @enableLapTopPruning	BIT = 1
	if( @i_batchCount <= 0) SET @i_batchCount = 1000
	IF EXISTS ( SELECT * FROM DMSetting WHERE SettingName = 'EDGE_DISABLE_LCK_PRUNING' AND SettingValue = 'TRUE')
		SET @enableLCKPruning = 0
	IF EXISTS ( SELECT * FROM DMSetting WHERE SettingName = 'EDGE_DISABLE_LAPTOP_PRUNING' AND SettingValue = 'TRUE')
		SET @enableLapTopPruning = 0
	SELECT @lckPruneInterval = ISNULL(SettingValue, 48) FROM DMSetting WHERE SettingName = 'EDGE_PRUNE_INTERVAL_FOR_LCK_ITEMS_InHrs'
	SELECT @laptopPruneInterval = ISNULL(SettingValue, 504) FROM DMSetting WHERE SettingName = 'EDGE_PRUNE_INTERVAL_FOR_LAPTOP_ITEMS_InHrs'
	--convert to seconds
	SELECT @lckPruneInterval = @lckPruneInterval * 3600, @laptopPruneInterval = @laptopPruneInterval * 3600
	SELECT TOP (@i_batchCount) SI.id, SI.localPath
	FROM SyncUploadInfo AS SI WITH (NOLOCK)
	WHERE SI.id > @i_maxId AND
		((@enableLCKPruning = 1 AND entityType = 3 AND (@currUnixTime - SI.modified) > @lckPruneInterval) OR
		 (@enableLapTopPruning  = 1 AND entityType = 111 AND (@currUnixTime - SI.modified) > @laptopPruneInterval))
	ORDER BY SI.id
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetUploadCacheFilesToPrune')
	delete from GxQscripts where name = 'AppSyncGetUploadCacheFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetUploadCacheFilesToPrune')
	delete from GXDBVersions where aliasname = 'AppSyncGetUploadCacheFilesToPrune'
GO

insert into GXDBVersions values(2, 'AppSyncGetUploadCacheFilesToPrune',  '00010002000000000000', 'AppSyncGetUploadCacheFilesToPrune', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_deleteContainerItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_deleteContainerItems.sp,v $ $Id: sp_dm2_deleteContainerItems.sp,v 1.2 2015/03/02 17:16:44 sbarman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_deleteContainerItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_deleteContainerItems')
	drop procedure sp_dm2_deleteContainerItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_deleteContainerItems')
	delete from GxQscripts where name = 'sp_dm2_deleteContainerItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_deleteContainerItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_deleteContainerItems'
GO
print '... Creating Procedure: sp_dm2_deleteContainerItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_deleteContainerItems
  @i_documentIdsXml varchar(max)
AS
SET NOCOUNT ON
declare @idoc int = 0
declare @rows int = -1
exec sp_xml_preparedocument @idoc output, @i_documentIdsXml
if @idoc = 0 select @rows;
declare @DocIdTable table
(
	DocId varchar(256) primary key
)
insert into @DocIdTable
select * from OPENXML(@idoc, '/root/doc', 1) with (id  varchar(256))
if @idoc <> 0 exec sp_xml_removedocument @idoc
delete DMContainerItem from DMContainerItem d
inner join DMResultSet r on r.ResultSetID = d.ResultSetID
inner join @DocIdTable t on t.DocId = r.documentID
select @@rowcount
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_deleteContainerItems')
	delete from GxQscripts where name = 'sp_dm2_deleteContainerItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_deleteContainerItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_deleteContainerItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_deleteContainerItems',  '00010002000000000000', 'sp_dm2_deleteContainerItems', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PickContainerToMigrate.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreFile()
--  | Description:  Update the Restore Files
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PickContainerToMigrate.sp,v $ $Id: sp_dm2_PickContainerToMigrate.sp,v 1.3 2015/05/02 00:56:45 sbarman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PickContainerToMigrate <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PickContainerToMigrate')
	drop procedure sp_dm2_PickContainerToMigrate
IF EXISTS (select * from GxQscripts where name='sp_dm2_PickContainerToMigrate')
	delete from GxQscripts where name = 'sp_dm2_PickContainerToMigrate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PickContainerToMigrate')
	delete from GXDBVersions where aliasname = 'sp_dm2_PickContainerToMigrate'
GO
print '... Creating Procedure: sp_dm2_PickContainerToMigrate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PickContainerToMigrate
  @i_containerGuid char(36),
  @i_processId int
AS
  DECLARE @Picked BIT = 0;
  DECLARE @State SmallInt = 0;
update DMMigrationContainers set State = 1, ProcessId = @i_processId, LastUpdated = GetUTCDate() where ContainerGuid = @i_containerGuid and State = 0
if @@ROWCOUNT > 0
	select @Picked = 1, @State = 1
else
	select @Picked = 0, @State = State from DMMigrationContainers with (NOLOCK) where ContainerGuid = @i_containerGuid
select @Picked as Picked, @State as State
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PickContainerToMigrate')
	delete from GxQscripts where name = 'sp_dm2_PickContainerToMigrate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PickContainerToMigrate')
	delete from GXDBVersions where aliasname = 'sp_dm2_PickContainerToMigrate'
GO

insert into GXDBVersions values(2, 'sp_dm2_PickContainerToMigrate',  '00010003000000000000', 'sp_dm2_PickContainerToMigrate', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_EnableBannerText.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_EnableBannerText.sp,v $ $Id: QS_EnableBannerText.sp,v 1.4 2014/08/27 15:04:44 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EnableBannerText <<<'

IF EXISTS (select * from sysobjects where name='QS_EnableBannerText')
	drop procedure QS_EnableBannerText
IF EXISTS (select * from GxQscripts where name='QS_EnableBannerText')
	delete from GxQscripts where name = 'QS_EnableBannerText'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableBannerText')
	delete from GXDBVersions where aliasname = 'QS_EnableBannerText'
GO
print '... Creating Procedure: QS_EnableBannerText'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_EnableBannerText
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_enableBanner varchar(64)='',
  @i_filePath varchar(1024)=''
AS
Set NOCOUNT ON
/*
 Local Variables
 */
	DECLARE @localErrorMsg	varchar(512)
	DECLARE @localErrorCode INT = 0
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @NoParameter			varchar(10)
	SET     @NoParameter			=''
	DECLARE @param1Invalid INT
	IF @i_enableBanner = @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error:  Insufficient command line parameters'
		SET @localErrorCode = 1
		GOTO CV_EXIT
	END
	SELECT @param1Invalid = CASE WHEN @i_enableBanner not in ('True', 'False', 'EnableSecondBanner', 'DisableSecondBanner') THEN 1 ELSE 0 END
	DECLARE @isRequestForSecondBanner INT
	SELECT @isRequestForSecondBanner = CASE WHEN @i_enableBanner in ('EnableSecondBanner', 'DisableSecondBanner') THEN 1 ELSE 0 END
	DECLARE @ENABLE_BANNER_SETTING VARCHAR(255)
	DECLARE @BANNER_TEXT_SETTING VARCHAR(255)
	IF @isRequestForSecondBanner = 1
	BEGIN
		SET @ENABLE_BANNER_SETTING = 'PRELOGIN_BANNER2_ENABLED'
		SET @BANNER_TEXT_SETTING = 'PRELOGIN_BANNER2_TEXT'
	END
	ELSE
	BEGIN
		SET @ENABLE_BANNER_SETTING = 'PRELOGIN_BANNER_ENABLED'
		SET @BANNER_TEXT_SETTING = 'PRELOGIN_BANNER_TEXT'
	END
	IF @param1Invalid = 1
	BEGIN
		SET @localErrorMsg = 'Error:  Parameter value: [' + @i_enableBanner + '] is invalid'
		SET @localErrorCode = 2
		GOTO CV_EXIT
	END
	IF(@i_enableBanner = 'True' AND @i_filePath = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error: FilePath is not provided to enable banner text'
		SET @localErrorCode = 3
		GOTO CV_EXIT
	END
	IF(@i_enableBanner = 'EnableSecondBanner' AND @i_filePath = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error: FilePath is not provided to enable second banner text'
		SET @localErrorCode = 4
		GOTO CV_EXIT
	END
	--------+++++++Disable the banner test ++++++++------------
	IF(@i_enableBanner = 'False')
	BEGIN
		IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING)
			delete FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING
		IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING)
			delete FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING
		SET @localErrorMsg = 'Prelogin Banner is Disabled'
	END
	ELSE
	BEGIN
	--------+++++++Enable the banner test ++++++++------------
	IF(@i_enableBanner = 'True' OR @i_enableBanner = 'EnableSecondBanner')
	BEGIN
		IF object_id('tempdb.dbo.#temp') IS NOT null
			DROP TABLE #temp
		CREATE TABLE #temp
		(VALUE VARCHAR(MAX));
		SET ANSI_WARNINGS OFF;
		DECLARE @sqlStmt VARCHAR(MAX)
		SET @sqlStmt = 'BULK INSERT #temp FROM '''+ @i_filePath +
						'''WITH (DATAFILETYPE = ''widechar'' ,
								 ROWTERMINATOR  = ''\0'',
								 FIELDTERMINATOR = ''\0'' )'
		---Perform Bulk Insert operation inside TRY/CATCH operation
		BEGIN TRY
			EXECUTE(@sqlStmt)
		END TRY
		BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

			SET @localErrorMsg = 'Error: Cannot load the file : [' + @i_filePath + ']'
			SET @localErrorCode = 5
			GOTO CV_EXIT
		END CATCH
		IF NOT EXISTS (SELECT * FROM #temp T WHERE isnull(T.Value, '') <> '')
		BEGIN
			SET @localErrorMsg = 'Error: Banner text is emtpy in specified file'
			SET @localErrorCode = 6
			GOTO CV_EXIT
		END
	END
		IF(@i_enableBanner = 'False' OR @i_enableBanner = 'DisableSecondBanner')
		BEGIN
			IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING)
				delete FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING
			IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING)
			 delete FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING
			IF @i_enableBanner = 'False'
				SET @localErrorMsg = 'Main PreLogin Banner is Disabled'
			ELSE
				SET @localErrorMsg = 'Second Banner is Disabled'
		END
		ELSE
		BEGIN
			IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING)
			BEGIN
				INSERT INTO DMSetting (SettingName,SettingValue,CreateTime)
				VALUES (@ENABLE_BANNER_SETTING, 'True', getDate())
			END
			ELSE
			BEGIN
				UPDATE DMSetting
				SET SettingValue = 'True'
				WHERE SettingName = @ENABLE_BANNER_SETTING
			END
			IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING)
			BEGIN
				INSERT INTO DMSetting(SettingName,SettingValue,CreateTime)
				SELECT TOP 1 @BANNER_TEXT_SETTING, #temp.VALUE, getUtcDate() FROM #temp
			END
			ELSE
			BEGIN
				UPDATE DMSetting
				SET SettingValue = (SELECT TOP 1 #temp.VALUE FROM #temp)
				WHERE SettingName = @BANNER_TEXT_SETTING
			END
			IF @i_enableBanner = 'True'
				SET @localErrorMsg = 'Main PreLogin banner is successfully enabled'
			ELSE
				SET @localErrorMsg = 'Second banner is successfully enabled'
		END
		--Drop temp table
		IF OBJECT_ID('tempdb.dbo.#temp') IS NOT NULL
			DROP TABLE #temp
	END
CV_EXIT:
	IF @localErrorCode > 0
	BEGIN
		RAISERROR (@localErrorMsg, 15, 1)
	END
	ELSE
	BEGIN
		SELECT @localErrorMsg
	END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableBannerText')
	delete from GxQscripts where name = 'QS_EnableBannerText'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableBannerText')
	delete from GXDBVersions where aliasname = 'QS_EnableBannerText'
GO

insert into GXDBVersions values(2, 'QS_EnableBannerText',  '00010004000000000000', 'QS_EnableBannerText', '00010004000000000000')
GO

insert into GxQscripts values(2,'QS_EnableBannerText',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	To enanble banner text'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn EnableBannerText -si ''True'' -si ''Banner text filePath'' '
 + CHAR(10) + '-- 	To disable banner text'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn EnableBannerText -si ''False'''
 + CHAR(10) + '-- 	--------------------------------'
 + CHAR(10) + '--     To enable second banner text'
 + CHAR(10) + '--     qoperation execscript -dbn DM2 -c ''client Name'' -sn EnableBannerText -si ''EnableSecondBanner'' -si ''Banner text filePath'' '
 + CHAR(10) + '--     To disable second banner text'
 + CHAR(10) + '--     qoperation execscript -dbn DM2 -c ''client Name'' -sn EnableBannerText -si ''DisableSecondBanner'''
 + CHAR(10) + '-- 	-------------- Explanation of arguments ------------------'
 + CHAR(10) + '-- 	''client Name'' -- client name of the Webserver machine (Single quotes not required. Hint: To find this, look at name of web server client in simpana administrative console)'
 + CHAR(10) + '-- 	''Banner text filePath'' -- Path to the file, that contains banner text, located on webserver machine local disk'
)
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_UpdateSettingValue.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_UpdateSettingValue.sp,v $ $Id: QS_UpdateSettingValue.sp,v 1.2 2011/03/14 14:54:43 ksundaram Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_UpdateSettingValue <<<'

IF EXISTS (select * from sysobjects where name='QS_UpdateSettingValue')
	drop procedure QS_UpdateSettingValue
IF EXISTS (select * from GxQscripts where name='QS_UpdateSettingValue')
	delete from GxQscripts where name = 'QS_UpdateSettingValue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateSettingValue')
	delete from GXDBVersions where aliasname = 'QS_UpdateSettingValue'
GO
print '... Creating Procedure: QS_UpdateSettingValue'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateSettingValue
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_settingName varchar(200)='',
  @i_settingValue nvarchar(max)=''
AS
Set NOCOUNT ON
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @NoParameter			varchar(10)
	SET     @NoParameter			=''
	IF(@i_settingName = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error:  Setting Name cannot be empty'
		GOTO CV_EXIT
	END
	--if setting name exists update the value
	--else insert new record
	IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @i_settingName)
	BEGIN
		UPDATE DMSetting
		SET SettingValue = @i_settingValue,
			CreateTime = getDate()
		WHERE SettingName = @i_settingName
		SET @localErrorMsg = 'Updated successfully for the SettingName = ' + @i_settingName + ' with value ' + @i_settingValue
	END
	ELSE
	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime)
		VALUES (@i_settingName, @i_settingValue, getDate())
		SET @localErrorMsg = 'Inserted successfully for the SettingName = ' + @i_settingName + ' with value ' + @i_settingValue
	END
CV_EXIT:
	SELECT @localErrorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateSettingValue')
	delete from GxQscripts where name = 'QS_UpdateSettingValue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateSettingValue')
	delete from GXDBVersions where aliasname = 'QS_UpdateSettingValue'
GO

insert into GXDBVersions values(2, 'QS_UpdateSettingValue',  '00010002000000000000', 'QS_UpdateSettingValue', '00010002000000000000')
GO

insert into GxQscripts values(2,'QS_UpdateSettingValue',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	To update/insert setting value'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn UpdateSettingValue -si ''setting name'' -si ''setting value'''
 + CHAR(10) + '-- 	''client Name'' -- client name of the Webserver machine'
 + CHAR(10) + '-- 	''setting name'' -- Name of setting which needs to be inserted or updated'
 + CHAR(10) + '-- 	''setting value'' -- value which needs to be inserted or updated'
)
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_BccColumnForEmailResults.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_BccColumnForEmailResults.sp,v $ $Id: QS_BccColumnForEmailResults.sp,v 1.1 2011/04/20 06:36:24 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_BccColumnForEmailResults <<<'

IF EXISTS (select * from sysobjects where name='QS_BccColumnForEmailResults')
	drop procedure QS_BccColumnForEmailResults
IF EXISTS (select * from GxQscripts where name='QS_BccColumnForEmailResults')
	delete from GxQscripts where name = 'QS_BccColumnForEmailResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BccColumnForEmailResults')
	delete from GXDBVersions where aliasname = 'QS_BccColumnForEmailResults'
GO
print '... Creating Procedure: QS_BccColumnForEmailResults'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_BccColumnForEmailResults
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_operation nvarchar(100)='add'
AS
Set NOCOUNT ON
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @NoParameter			varchar(10)
	SET     @NoParameter			=''
	DECLARE @AddOperationConst nvarchar(3)
	DECLARE @DropOperationConst nvarchar(6)
	SET @AddOperationConst = 'add'
	SET @DropOperationConst = 'remove'
	IF (@i_operation = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error:  Operation Name cannot be empty'
		GOTO CV_EXIT
	END
	ELSE
	BEGIN
		SET @i_operation = LTRIM(RTRIM(@i_operation))
		IF NOT (@i_operation=@AddOperationConst OR @i_operation=@DropOperationConst)
		BEGIN
			SET @localErrorMsg = 'Error:  Invalid Operation Name. Allowed values: ADD, REMOVE'
			GOTO CV_EXIT
		END
	END
	--if operation type is add, then check if Bcc column exists in email results panel and add it..
	IF(@i_operation = @AddOperationConst)
	BEGIN
		IF NOT EXISTS (SELECT * FROM DMUIColumns WHERE ColumnName = 'Bcc')
		BEGIN
			INSERT INTO DMUIColumns (Id, ColumnName, ResourceKey, PropertyName, Width, Alignment)
			VALUES ('14', 'Bcc', 'AppSpecific_EMail_Bcc_ResourceKey', 'emailBcc', 100, '')
		END
		ELSE
		BEGIN
			--IF it already exists, we want to make make sure it is initially hidden column when grid is loaded.
			IF EXISTS (SELECT * FROM DMUIColumns WHERE Id = 14 AND ResourceKey <> 'AppSpecific_EMail_Bcc_ResourceKey')
			BEGIN
				UPDATE DMUIColumns SET ResourceKey = 'AppSpecific_EMail_Bcc_ResourceKey'
				WHERE Id = 14
			END
		END
		--Bcc for Email Results Grid only for compliance site
		IF NOT EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '14' AND PanelTypeId = 3)
		BEGIN
			INSERT INTO DMUIPanelColumns (Id, ColumnId, PanelTypeId, BitVisibility, DisplayOrder)
			SELECT MAX(ID) + 1 AS ID, '14', '3', '2', 16
			FROM DMUIPanelColumns
		END
		SET @localErrorMsg = 'Successfully added Bcc column for Email Results'
	END
	IF(@i_operation = @DropOperationConst)
	BEGIN
		IF EXISTS (SELECT * FROM DMUIPanelColumns WHERE ColumnId = '14' AND PanelTypeId = 3)
		BEGIN
			EXEC('DELETE FROM DMUIPanelColumns  WHERE ColumnId = 14 AND PanelTypeId = 3')
			IF @@error = 0
				SET @localErrorMsg = 'Successfully removed Bcc column for Email Results'
		END
		ELSE
		BEGIN
			SET @localErrorMsg = 'Successfully removed Bcc column for Email Results'
		END
	END
CV_EXIT:
	SELECT @localErrorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'QS_BccColumnForEmailResults')
	delete from GxQscripts where name = 'QS_BccColumnForEmailResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_BccColumnForEmailResults')
	delete from GXDBVersions where aliasname = 'QS_BccColumnForEmailResults'
GO

insert into GXDBVersions values(2, 'QS_BccColumnForEmailResults',  '00010001000000000000', 'QS_BccColumnForEmailResults', '00010001000000000000')
GO

insert into GxQscripts values(2,'QS_BccColumnForEmailResults',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	To add/remove Bcc column for email search results panel'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn BccColumnForEmailResults -si ''flag'' '
 + CHAR(10) + '-- 	''client Name'' -- client name of the Webserver machine'
 + CHAR(10) + '-- 	''flag'' -- flag can be add or remove and is optional. Default is add.'
)
GO



--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_SetAdvanceSearchTabDisplay.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_SetAdvanceSearchTabDisplay.sp,v $ $Id: QS_SetAdvanceSearchTabDisplay.sp,v 1.3 2015/06/23 22:30:06 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_SetAdvanceSearchTabDisplay <<<'

IF EXISTS (select * from sysobjects where name='QS_SetAdvanceSearchTabDisplay')
	drop procedure QS_SetAdvanceSearchTabDisplay
IF EXISTS (select * from GxQscripts where name='QS_SetAdvanceSearchTabDisplay')
	delete from GxQscripts where name = 'QS_SetAdvanceSearchTabDisplay'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAdvanceSearchTabDisplay')
	delete from GXDBVersions where aliasname = 'QS_SetAdvanceSearchTabDisplay'
GO
print '... Creating Procedure: QS_SetAdvanceSearchTabDisplay'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetAdvanceSearchTabDisplay
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_GroupName nvarchar(200) = '',
  @i_Visiblity varchar(4) = '',
  @i_Site varchar(50) = 'Compliance'
AS
Set NOCOUNT ON
	DECLARE @scriptName  		varchar(32)
	DECLARE @siteWeightage 		INT = 0
	DECLARE @systemError 		INT = 0
	DECLARE @success 			INT = 0
	DECLARE @localErrorMsg		varchar(512)
	DECLARE @NoParameter		varchar(10)
	SELECT @scriptName = 'SetAdvanceSearchTabDisplay', @NoParameter = '', @localErrorMsg = 'Error Encountered when running script.'
	SELECT @i_GroupName = CASE WHEN @i_GroupName IS NOT NULL THEN LTRIM(RTRIM(@i_GroupName)) ELSE @NoParameter END
	SELECT @i_Visiblity = CASE WHEN @i_Visiblity IS NOT NULL THEN LTRIM(RTRIM(@i_Visiblity)) ELSE @NoParameter END
	SELECT @i_Site = CASE WHEN @i_Site IS NOT NULL THEN LTRIM(RTRIM(@i_Site)) ELSE @NoParameter END
	IF(@i_GroupName = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error:  Group Name input is missing'
		GOTO CV_EXIT
	END
	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Name = @i_GroupName)
	BEGIN
		SET @localErrorMsg = 'Error:  Group Name is invalid.'
		GOTO CV_EXIT
	END
	IF(@i_Visiblity = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error:  Visibility input is missing'
		GOTO CV_EXIT
	END
	IF(@i_Visiblity NOT IN ('Show', 'Hide'))
	BEGIN
		SET @localErrorMsg = 'Error:  Visibility input is invalid.'
		GOTO CV_EXIT
	END
	IF(@i_Site = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error: Site name input is missing'
		GOTO CV_EXIT
	END
	IF(@i_Site NOT IN ('Compliance', 'EndUser'))
	BEGIN
		SET @localErrorMsg = 'Error:  Site name input is invalid.'
		GOTO CV_EXIT
	END
	SELECT @siteWeightage = BinaryWeightage FROM DMSearchView WHERE ViewName = @i_Site
	IF @i_Visiblity = 'Hide'
	BEGIN
		IF EXISTS (SELECT TOP 1 * FROM DMSearchCriteriaGroup WHERE Name = @i_GroupName AND (BitVisibility & @siteWeightage) > 0)
		BEGIN
			UPDATE DMSearchCriteriaGroup
			SET BitVisibility = BitVisibility ^ @siteWeightage
			WHERE Name = @i_GroupName
		END
	END
	ELSE IF @i_Visiblity = 'Show'
	BEGIN
		IF EXISTS (SELECT TOP 1 * FROM DMSearchCriteriaGroup WHERE Name = @i_GroupName AND (BitVisibility & @siteWeightage) = 0)
		BEGIN
			UPDATE DMSearchCriteriaGroup
			SET BitVisibility = BitVisibility | @siteWeightage
			WHERE Name = @i_GroupName
		END
	END
	SET @systemError = @@ERROR
	SET @success = CASE WHEN @systemError = 0 THEN 1 ELSE 0 END
CV_EXIT:
	PRINT 'Execution of ' + @scriptName + ' completed at ' + Convert(varchar(60), getdate()) + '. Exit Code: [' +  Convert(varchar(10), @systemError) + '].'
	--If we did not succeed then we may need to raise error
	if @success = 0
	BEGIN
		--Don't raise error if SQL server did that already
		IF @systemError = 0
		BEGIN
			RAISERROR (@localErrorMsg, 16, 1)
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetAdvanceSearchTabDisplay')
	delete from GxQscripts where name = 'QS_SetAdvanceSearchTabDisplay'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAdvanceSearchTabDisplay')
	delete from GXDBVersions where aliasname = 'QS_SetAdvanceSearchTabDisplay'
GO

insert into GXDBVersions values(2, 'QS_SetAdvanceSearchTabDisplay',  '00010003000000000000', 'QS_SetAdvanceSearchTabDisplay', '00010003000000000000')
GO

insert into GxQscripts values(2,'QS_SetAdvanceSearchTabDisplay',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	To hide or show desired advance search tab in compliance or end user search interface'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn SetAdvanceSearchTabDisplay -si ''GroupName'' -si ''Visiblity'' -si ''Site'''
 + CHAR(10) + '-- 	''client Name'' is the client name of web server machine to which compliance search is pointing to.'
 + CHAR(10) + '-- 	''GroupName'' -- Advance search tab name to be visible or hidden. Possible group names are Email, File, Common, Discovery, Client, Search Options, Keyword, Query Builder, Delegates'
 + CHAR(10) + '-- 	''Visiblity'' -- Possible values are Show, Hide'
 + CHAR(10) + '-- 	''Site'' -- Site in which option to be hidden or shown. Possible values are Compliance, EndUser'
)
GO

