

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/cvsp_drop_pk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/cvsp_drop_pk.sp,v $ $Id: cvsp_drop_pk.sp,v 1.1 2008/09/29 17:03:08 hkapadia Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_drop_pk()
--  |
--  | Description:  First drop all foreign keys referenced to the primary key
--  |				of the given table then drop the primary key
--  |
--  |       Input:  tblName
--	|
--  |      Output:  error code
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_drop_pk <<<'

IF EXISTS (select * from sysobjects where name='cvsp_drop_pk')
	drop procedure cvsp_drop_pk
IF EXISTS (select * from GxQscripts where name='cvsp_drop_pk')
	delete from GxQscripts where name = 'cvsp_drop_pk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_pk')
	delete from GXDBVersions where aliasname = 'cvsp_drop_pk'
GO
print '... Creating Procedure: cvsp_drop_pk'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_drop_pk
  @tblName varchar(40)
AS
DECLARE	@fkTable	varchar (40)
DECLARE @keyName	varchar (255)
DECLARE @execString	nvarchar(255)
DECLARE @errCode    int
SET	@errCode = 0
DECLARE fkCursor CURSOR FOR
	SELECT	DISTINCT object_name(constid), object_name(fkeyid)
	FROM	sysforeignkeys
	WHERE	rkeyid = object_id(@tblName)
OPEN	fkCursor
FETCH	NEXT FROM fkCursor INTO @keyName, @fkTable
WHILE	@@FETCH_STATUS = 0
BEGIN
		SET	@execString = 'ALTER TABLE ' + @fkTable +' DROP CONSTRAINT ' + @keyName
		EXEC sp_executesql @execString
		SET	@errCode = @@error
		IF	@errCode <> 0
			BREAK
		FETCH NEXT FROM fkCursor INTO @keyName, @fkTable
END
CLOSE		fkCursor
DEALLOCATE	fkCursor
IF	@errCode <> 0
	return @errCode
SELECT @keyName = name FROM sysobjects WHERE parent_obj = object_id(@tblName) AND xtype = 'PK'
IF (@keyName IS NOT null)
BEGIN
	SET @execString = 'ALTER TABLE ' + @tblName +' DROP CONSTRAINT ' + @keyName
	EXEC sp_executesql @execString
END
RETURN @errCode
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_drop_pk')
	delete from GxQscripts where name = 'cvsp_drop_pk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_pk')
	delete from GXDBVersions where aliasname = 'cvsp_drop_pk'
GO

insert into GXDBVersions values(2, 'cvsp_drop_pk',  '00010001000000000000', 'cvsp_drop_pk', '00010001000000000000')
GO

