

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_UpdateSettingValue.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_UpdateSettingValue.sp,v $ $Id: QS_UpdateSettingValue.sp,v 1.2.210.2 2018/12/27 18:34:22 vikashkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_UpdateSettingValue')
BEGIN
	print '>>> Drop Stored Procedure: QS_UpdateSettingValue <<<'
	drop procedure QS_UpdateSettingValue
END
IF EXISTS (select * from GxQscripts where name='QS_UpdateSettingValue')
	delete from GxQscripts where name = 'QS_UpdateSettingValue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateSettingValue')
	delete from GXDBVersions where aliasname = 'QS_UpdateSettingValue'
GO
print '... Creating Procedure: QS_UpdateSettingValue'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateSettingValue
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_settingName varchar(200)='',
  @i_settingValue nvarchar(max)=''
AS
Set NOCOUNT ON
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @NoParameter			varchar(10)
	SET     @NoParameter			=''
	IF(@i_settingName = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error:  Setting Name cannot be empty'
		GOTO CV_EXIT
	END
	--if setting name exists update the value
	--else insert new record
	IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @i_settingName)
	BEGIN
		UPDATE DMSetting
		SET SettingValue = @i_settingValue,
			CreateTime = getDate()
		WHERE SettingName = @i_settingName
		SET @localErrorMsg = 'Updated successfully for the SettingName = ' + @i_settingName + ' with value ' + @i_settingValue
	END
	ELSE
	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime)
		VALUES (@i_settingName, @i_settingValue, getDate())
		SET @localErrorMsg = 'Inserted successfully for the SettingName = ' + @i_settingName + ' with value ' + @i_settingValue
	END
CV_EXIT:
	SELECT @localErrorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateSettingValue')
	delete from GxQscripts where name = 'QS_UpdateSettingValue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateSettingValue')
	delete from GXDBVersions where aliasname = 'QS_UpdateSettingValue'
GO

insert into GXDBVersions values(2, 'QS_UpdateSettingValue',  '00010002021000020000', 'QS_UpdateSettingValue', '00010002021000020000')
GO

insert into GxQscripts values(2,'QS_UpdateSettingValue',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	To update/insert setting value'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn UpdateSettingValue -si ''setting name'' -si ''setting value'''
 + CHAR(10) + '-- 	''client Name'' -- client name of the Webserver machine'
 + CHAR(10) + '-- 	''setting name'' -- Name of setting which needs to be inserted or updated'
 + CHAR(10) + '-- 	''setting value'' -- value which needs to be inserted or updated'
)
GO

