

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_UpdateCacheDirectoryMove.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_UpdateCacheDirectoryMove.sp,v $ $Id: QS_UpdateCacheDirectoryMove.sp,v 1.1.2.1 2019/05/23 23:17:10 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_UpdateCacheDirectoryMove')
BEGIN
	print '>>> Drop Stored Procedure: QS_UpdateCacheDirectoryMove <<<'
	drop procedure QS_UpdateCacheDirectoryMove
END
IF EXISTS (select * from GxQscripts where name='QS_UpdateCacheDirectoryMove')
	delete from GxQscripts where name = 'QS_UpdateCacheDirectoryMove'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateCacheDirectoryMove')
	delete from GXDBVersions where aliasname = 'QS_UpdateCacheDirectoryMove'
GO
print '... Creating Procedure: QS_UpdateCacheDirectoryMove'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_UpdateCacheDirectoryMove
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_OldPath nvarchar(1024), 
  @i_NewPath nvarchar(1024)
AS
BEGIN
	DECLARE @rows INT = 0
	DECLARE @TotalRows int = 0
	DECLARE @errMsg VARCHAR(MAX) = ''
	DECLARE @debug INT = 0
	IF ISNULL(@i_OldPath, '') = ''
	BEGIN
		SET @errMsg = 'Old cache location input missing.'
		GOTO EXIT_LINE
	END
	IF ISNULL(@i_NewPath, '') = ''
	BEGIN
		SELECT @i_NewPath = SettingValue FROM DMSetting
		WHERE SettingName = 'RestorePath'
	END
	IF @i_NewPath = @i_OldPath
	BEGIN
		SET @errMsg = 'Both old and new location cannot be same!'
		GOTO EXIT_LINE
	END
	--
	-- Remove possible trialing slash in both paths so that after update so we don't have path errors
	--
	IF RIGHT(@i_OldPath, 1) = '\'
	BEGIN
		SET @i_OldPath = SUBSTRING(@i_OldPath, 1, LEN(@i_OldPath) - 1)
	END
	IF RIGHT(@i_NewPath, 1) = '\'
	BEGIN
		SET @i_NewPath = SUBSTRING(@i_NewPath, 1, LEN(@i_NewPath) - 1)
	END
	--
	-- book keeping status value of rows processed for migration of restored items cache location from old to new.
	--
	DECLARE @dmResultSetStatusTrack int = 100 -- DMResultSet
	DECLARE @dmDownloadResultSetStatusTrack int = 1000  -- DMDownloadResultSet
	SET NOCOUNT ON
	IF EXISTS (SELECT TOP 1 1 FROM DMDownload a WHERE CHARINDEX(@i_OldPath, a.CabFilePath) = 1 OR CHARINDEX(@i_OldPath, DestinationPath) = 1)
	BEGIN
		UPDATE DMDownload
		SET DestinationPath = REPLACE(DestinationPath, @i_OldPath, @i_NewPath),
		CabFilePath = REPLACE(CabFilePath, @i_OldPath, @i_NewPath)
		PRINT 'Number of rows updated in DMDownload table = ' + CONVERT(VARCHAR(10), @@ROWCOUNT)
	END
	IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'idx_dmresultset_restorestatus_t')
	BEGIN
		CREATE INDEX idx_dmresultset_restorestatus_t on dmresultset(restorestatus)
	END
	IF object_id('tempdb.dbo.#TmpResult') IS NOT NULL
	DROP TABLE #TmpResult
	CREATE TABLE #TmpResult (id bigint, destpath nvarchar(max), updateit int default 0)
	--
	-- Enter loop at-least once by assuming we have some rows
	--
	SET @rows = 1
	--
	BEGIN TRY
	WHILE(@rows > 0)
	BEGIN
		DELETE FROM #TmpResult
		INSERT INTO #TmpResult(id, destpath)
		SELECT TOP 1000 id, DestinationPath FROM DMResultSet WHERE RestoreStatus in (2, 4)
		SELECT @rows = COUNT(*) FROM #TmpResult
		IF @rows > 0
		BEGIN
			IF @debug = 1
			PRINT 'Start processing batch of #' + convert(varchar(10), @rows) + ' rows in DMResultSet'
			-- replace old path with new one
			-- if there is data that's restored after cache path changed to new, we leave them as is
			--
			UPDATE #TmpResult SET updateit = 1, destpath = REPLACE(destpath, @i_OldPath, @i_NewPath)
			WHERE CHARINDEX(@i_OldPath, destpath) = 1
			IF @debug = 1
			PRINT 'Updating current batch of rows in DMResultSet'
			UPDATE a
			SET
			RestoreStatus = @dmResultSetStatusTrack,
			a.DestinationPath = (case when updateit = 1 then b.destpath else a.DestinationPath end)
			FROM DMResultSet a
			JOIN #TmpResult b on a.ID = b.id
			SELECT @TotalRows = @TotalRows + COUNT(*) FROM #TmpResult WHERE updateit = 1
			IF @debug = 1
			PRINT 'Going to process next batch of # ' + convert(varchar(10), @rows) + ' rows in DMResultSet.'
		END
	END
	END TRY
	BEGIN CATCH
		SET @errMsg = 'Script failed after updating # ' + CONVERT(VARCHAR(10), @TotalRows) + ' rows. Error: ' + ERROR_MESSAGE()
	END CATCH
	IF @TotalRows > 0
	BEGIN
		PRINT 'Number of rows updated in DMResultSet table = [' + CONVERT(VARCHAR(10), @TotalRows) + ']'
	END
	--
	-- We used RestoreStatus = 100 as book-keeping value of rows that's already processed
	-- Now that we are done processing DMResultSet, revert such entries to RestoreStatus = 4 (Completed)
	-- Even if an error occurred in above loop, we have to make sure we do this before exiting..
	SET @rows = 1 -- always start with assumption saying we do have some data to process..
	WHILE(@rows > 0)
	BEGIN
		UPDATE TOP (1000) DMResultSet SET RestoreStatus = 4 WHERE RestoreStatus = @dmResultSetStatusTrack
		SELECT @rows = COUNT(*) from DMResultSet WHERE RestoreStatus = @dmResultSetStatusTrack
	END
	IF EXISTS (SELECT * FROM sysindexes WHERE name = 'idx_dmresultset_restorestatus_t')
	BEGIN
		DROP INDEX DMResultSet.idx_dmresultset_restorestatus_t
	END
	--
	-- if there are failures, let us end the script so that DEV get chance to check and correct failures before doing more updates..
	--
	IF ISNULL(@errMsg, '') <> '' GOTO EXIT_LINE
	--
	-- Create temp index on status column to help tracking records being processed quicker..
	--
	IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'idx_dmdownloadresultset_status_t')
	BEGIN
		CREATE INDEX idx_dmdownloadresultset_status_t on dmdownloadresultset(status)
	END
	--
	-- reset and re-use convenicnce variables
	--
	SELECT @TotalRows = 0, @rows = 1
	BEGIN TRY
	WHILE(@rows > 0)
	BEGIN
		DELETE FROM #TmpResult
		INSERT INTO #TmpResult(id, destpath)
		SELECT TOP 1000 id, FileName FROM DMDownloadResultSet WHERE Status = 100
		SELECT @rows = COUNT(*) FROM #TmpResult
		IF @rows > 0
		BEGIN
			--
			-- replace old path with new one in DMDownloadResultSet table
			-- if there is data that's restored after cache path changed to new, we leave them as is
			--
			UPDATE #TmpResult SET updateit = 1, destpath = REPLACE(destpath, @i_OldPath, @i_NewPath)
			WHERE CHARINDEX(@i_OldPath, destpath) = 1
			IF @debug = 1
			PRINT 'Updating current batch of rows in DMDownloadResultSet'
			UPDATE a
			SET
			Status = @dmDownloadResultSetStatusTrack,
			a.FileName = (CASE WHEN updateit = 1 THEN b.destpath ELSE a.FileName END)
			FROM DMDownloadResultSet a
			JOIN #TmpResult b on a.ID = b.id
			SELECT @TotalRows = @TotalRows + COUNT(*) FROM #TmpResult WHERE updateit = 1
			IF @debug = 1
			PRINT 'Going to process next batch of # ' + CONVERT(VARCHAR(10), @rows) + ' rows in DMDownloadResultSet.'
		END
	END
	END TRY
	BEGIN CATCH
		SET @errMsg = 'Script failed after updating # ' + CONVERT(VARCHAR(10), @TotalRows) + ' rows in DMDownloadResultSet.. Error: ' + ERROR_MESSAGE()
	END CATCH
	IF @TotalRows > 0
	BEGIN
		PRINT 'Number of rows updated in DMDownloadResultSet table = [' + convert(varchar(10), @TotalRows) + ']'
	END
	--
	-- reset and re-use convenicnce variables
	--
	SELECT @TotalRows = 0, @rows = 1
	--
	-- We used Status = 1000 as book-keeping value of rows that's already processed.
	-- Now that we are done processing DMDownloadResultSet, revert such entries back to Status = 100 (Completed)
	--
	WHILE(@rows > 0)
	BEGIN
		UPDATE TOP (1000) DMDownloadResultSet SET Status = 100
		WHERE Status = @dmDownloadResultSetStatusTrack
		SELECT @rows = COUNT(*) FROM DMDownloadResultSet WHERE Status = @dmDownloadResultSetStatusTrack
	END
	IF EXISTS (SELECT * FROM sysindexes WHERE name = 'idx_dmdownloadresultset_status_t')
	BEGIN
		DROP INDEX dmdownloadresultset.idx_dmdownloadresultset_status_t
	END
	EXIT_LINE:
	IF OBJECT_ID('tempdb.dbo.#TmpResult') IS NOT NULL
		DROP TABLE #TmpResult
	if ISNULL(@errMsg, '') <> ''
		RAISERROR(@errMsg, 16, 1)
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_UpdateCacheDirectoryMove')
	delete from GxQscripts where name = 'QS_UpdateCacheDirectoryMove'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_UpdateCacheDirectoryMove')
	delete from GXDBVersions where aliasname = 'QS_UpdateCacheDirectoryMove'
GO

insert into GXDBVersions values(2, 'QS_UpdateCacheDirectoryMove',  '00010001000200010000', 'QS_UpdateCacheDirectoryMove', '00010001000200010000')
GO

insert into GxQscripts values(2,'QS_UpdateCacheDirectoryMove',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	Use this script to update already restored/exported item''s location in cache directory. Typically required when doing hardware refresh or an explicit move of cache directory is done using documented steps.'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn UpdateCacheDirectoryMove -si ''Old Cache Location'' -si ''New Cache Location'''
 + CHAR(10) + '-- 	''client Name'' -- Client name of the web server machine'
 + CHAR(10) + '-- 	''Old Cache Location'' -- Path of previous cache directory. Example: C:\Program Files\Commvault\ContentStore\WebCache '
 + CHAR(10) + '-- 	''New Cache Location'' -- Path of new cache directory. Example: E:\WebCache'
)
GO

