

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/QS_SetKeyMetricsConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/QS_SetKeyMetricsConfig.sp,v $ $Id: QS_SetKeyMetricsConfig.sp,v 1.1.2.2 2018/12/27 18:51:38 vikashkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetKeyMetricsConfig')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetKeyMetricsConfig <<<'
	drop procedure QS_SetKeyMetricsConfig
END
IF EXISTS (select * from GxQscripts where name='QS_SetKeyMetricsConfig')
	delete from GxQscripts where name = 'QS_SetKeyMetricsConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetKeyMetricsConfig')
	delete from GXDBVersions where aliasname = 'QS_SetKeyMetricsConfig'
GO
print '... Creating Procedure: QS_SetKeyMetricsConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetKeyMetricsConfig
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_key nvarchar(64)='',
  @i_enabled nvarchar(64) = '',
  @i_value nvarchar(max) = ''
AS
Set NOCOUNT ON
--------------------------------------------
-- Convenience Definitions --
--------------------------------------------
DECLARE @scriptName         varchar(32)
SET     @scriptName =       'SetKeyMetricsConfig'
DECLARE @transactionName    varchar(32)
SET @transactionName =      'SetKeyMetricsConfigTran'
--------------------------------------------
-- Local Variables --
--------------------------------------------
DECLARE @lastError              integer
DECLARE @response          varchar(512)
SET     @response          ='Error Encountered when running script.'
SET     @lastError  = 0                                 -- Be optimistic
--------------------------------------------
-- Input Validation --
--------------------------------------------
if @i_key = ''
BEGIN
	SET @response = 'Error. No Metrics Configuration Key name is provided.'
	SET @lastError = 1
	GOTO PROC_EXIT
END
-- @i_enabled is compulsory param
if (LOWER(@i_enabled) <> 'y' and LOWER(@i_enabled) <> 'n')
BEGIN
    SET @response = 'Error. Invalid enabled or key paramater value. Enter [y] to enable and [n] to disable.'
    Set @lastError = 1
    GOTO PROC_EXIT
END
-- If @i_enabled is true, Validate @i_value
if (LOWER(@i_enabled) = 'y')
    if @i_value = ''
    BEGIN
        SET @response = 'Error. Invalid value parameter value.'
        Set @lastError = 1
        GOTO PROC_EXIT
    END
BEGIN TRY
BEGIN TRANSACTION @transactionName
    DELETE from cf_surveyconfig where name = @i_key
    if (LOWER(@i_enabled) ='y')
        INSERT INTO cf_surveyconfig(Name, Value) VALUES (@i_key, @i_value)
COMMIT TRANSACTION @transactionName
END TRY
BEGIN CATCH
    ROLLBACK TRANSACTION @transactionName
    SET @response = 'Error.  Database error occured. Please retry'
    Set @lastError = 1
    GOTO PROC_EXIT
END CATCH
PROC_EXIT:
    IF (@lastError <> 0)
	BEGIN
        SELECT @response
		RAISERROR(@response, 16, 1)
	END
	ELSE
	BEGIN
		SET @response = 'The Metrics Configuration Key has been set successfully.'
		SELECT @response
	END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetKeyMetricsConfig')
	delete from GxQscripts where name = 'QS_SetKeyMetricsConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetKeyMetricsConfig')
	delete from GXDBVersions where aliasname = 'QS_SetKeyMetricsConfig'
GO

insert into GXDBVersions values(2, 'QS_SetKeyMetricsConfig',  '00010001000200020000', 'QS_SetKeyMetricsConfig', '00010001000200020000')
GO

insert into GxQscripts values(2,'QS_SetKeyMetricsConfig',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn setKeyMetricsConfig -dbn CVCloud -si @i_key=''key_name'' -si @i_enabled=''enabled'' -si @i_value=''value''
'
 + CHAR(10) + '	qoperation execscript -sn setKeyMetricsConfig -dbn CVCloud -si ''key_name'' -si ''enabled'' -si ''value''
'
 + CHAR(10) + '-- 	key_name: The Metrics Configuration Key name'
 + CHAR(10) + '-- 	enabled: This input should be y or n. Enter y to enable the key. Enter n to disable the key.'
 + CHAR(10) + '-- 	value: Value of Metrics Configuration key. This field is mandatory to enable a key, and is disregarded while disabling a key.'
)
GO

