

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_SetAdvanceSearchTabDisplay.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_SetAdvanceSearchTabDisplay.sp,v $ $Id: QS_SetAdvanceSearchTabDisplay.sp,v 1.3.2.2 2018/12/27 18:30:19 vikashkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_SetAdvanceSearchTabDisplay')
BEGIN
	print '>>> Drop Stored Procedure: QS_SetAdvanceSearchTabDisplay <<<'
	drop procedure QS_SetAdvanceSearchTabDisplay
END
IF EXISTS (select * from GxQscripts where name='QS_SetAdvanceSearchTabDisplay')
	delete from GxQscripts where name = 'QS_SetAdvanceSearchTabDisplay'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAdvanceSearchTabDisplay')
	delete from GXDBVersions where aliasname = 'QS_SetAdvanceSearchTabDisplay'
GO
print '... Creating Procedure: QS_SetAdvanceSearchTabDisplay'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_SetAdvanceSearchTabDisplay
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_GroupName nvarchar(200) = '',
  @i_Visiblity varchar(4) = '',
  @i_Site varchar(50) = 'Compliance'
AS
Set NOCOUNT ON
	DECLARE @scriptName  		varchar(32)
	DECLARE @siteWeightage 		INT = 0
	DECLARE @systemError 		INT = 0
	DECLARE @success 			INT = 0
	DECLARE @localErrorMsg		varchar(512)
	DECLARE @NoParameter		varchar(10)
	SELECT @scriptName = 'SetAdvanceSearchTabDisplay', @NoParameter = '', @localErrorMsg = 'Error Encountered when running script.'
	SELECT @i_GroupName = CASE WHEN @i_GroupName IS NOT NULL THEN LTRIM(RTRIM(@i_GroupName)) ELSE @NoParameter END
	SELECT @i_Visiblity = CASE WHEN @i_Visiblity IS NOT NULL THEN LTRIM(RTRIM(@i_Visiblity)) ELSE @NoParameter END
	SELECT @i_Site = CASE WHEN @i_Site IS NOT NULL THEN LTRIM(RTRIM(@i_Site)) ELSE @NoParameter END
	IF(@i_GroupName = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error:  Group Name input is missing'
		GOTO CV_EXIT
	END
	IF NOT EXISTS (SELECT * FROM DMSearchCriteriaGroup WHERE Name = @i_GroupName)
	BEGIN
		SET @localErrorMsg = 'Error:  Group Name is invalid.'
		GOTO CV_EXIT
	END
	IF(@i_Visiblity = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error:  Visibility input is missing'
		GOTO CV_EXIT
	END
	IF(@i_Visiblity NOT IN ('Show', 'Hide'))
	BEGIN
		SET @localErrorMsg = 'Error:  Visibility input is invalid.'
		GOTO CV_EXIT
	END
	IF(@i_Site = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error: Site name input is missing'
		GOTO CV_EXIT
	END
	IF(@i_Site NOT IN ('Compliance', 'EndUser'))
	BEGIN
		SET @localErrorMsg = 'Error:  Site name input is invalid.'
		GOTO CV_EXIT
	END
	SELECT @siteWeightage = BinaryWeightage FROM DMSearchView WHERE ViewName = @i_Site
	IF @i_Visiblity = 'Hide'
	BEGIN
		IF EXISTS (SELECT TOP 1 * FROM DMSearchCriteriaGroup WHERE Name = @i_GroupName AND (BitVisibility & @siteWeightage) > 0)
		BEGIN
			UPDATE DMSearchCriteriaGroup
			SET BitVisibility = BitVisibility ^ @siteWeightage
			WHERE Name = @i_GroupName
		END
	END
	ELSE IF @i_Visiblity = 'Show'
	BEGIN
		IF EXISTS (SELECT TOP 1 * FROM DMSearchCriteriaGroup WHERE Name = @i_GroupName AND (BitVisibility & @siteWeightage) = 0)
		BEGIN
			UPDATE DMSearchCriteriaGroup
			SET BitVisibility = BitVisibility | @siteWeightage
			WHERE Name = @i_GroupName
		END
	END
	SET @systemError = @@ERROR
	SET @success = CASE WHEN @systemError = 0 THEN 1 ELSE 0 END
CV_EXIT:
	PRINT 'Execution of ' + @scriptName + ' completed at ' + Convert(varchar(60), getdate()) + '. Exit Code: [' +  Convert(varchar(10), @systemError) + '].'
	--If we did not succeed then we may need to raise error
	if @success = 0
	BEGIN
		--Don't raise error if SQL server did that already
		IF @systemError = 0
		BEGIN
			RAISERROR (@localErrorMsg, 16, 1)
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_SetAdvanceSearchTabDisplay')
	delete from GxQscripts where name = 'QS_SetAdvanceSearchTabDisplay'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_SetAdvanceSearchTabDisplay')
	delete from GXDBVersions where aliasname = 'QS_SetAdvanceSearchTabDisplay'
GO

insert into GXDBVersions values(2, 'QS_SetAdvanceSearchTabDisplay',  '00010003000200020000', 'QS_SetAdvanceSearchTabDisplay', '00010003000200020000')
GO

insert into GxQscripts values(2,'QS_SetAdvanceSearchTabDisplay',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	To hide or show desired advance search tab in compliance or end user search interface'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn SetAdvanceSearchTabDisplay -si ''GroupName'' -si ''Visiblity'' -si ''Site'''
 + CHAR(10) + '-- 	''client Name'' is the client name of web server machine to which compliance search is pointing to.'
 + CHAR(10) + '-- 	''GroupName'' -- Advance search tab name to be visible or hidden. Possible group names are Email, File, Common, Discovery, Client, Search Options, Keyword, Query Builder, Delegates'
 + CHAR(10) + '-- 	''Visiblity'' -- Possible values are Show, Hide'
 + CHAR(10) + '-- 	''Site'' -- Site in which option to be hidden or shown. Possible values are Compliance, EndUser'
)
GO

