SET QUOTED_IDENTIFIER OFF
SET NOCOUNT ON
GO

BEGIN
		DECLARE @ProcNameCursorFlag 	INTEGER
		SET 		@ProcNameCursorFlag 	= 0
		
		DECLARE	@errorCode	INTEGER
		SET 		@errorCode	= 0
		
		DECLARE	@ProcName		nvarchar(256)
			
		DECLARE	ProcNameListCursor CURSOR STATIC FOR
		SELECT	distinct name
		FROM		sysobjects
		WHERE     xtype = 'P'
		AND		  OBJECTPROPERTY(id, N'IsProcedure') = 1
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
			
		SET		@ProcNameCursorFlag = 1
		OPEN	ProcNameListCursor
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	
		FETCH	NEXT 
		FROM ProcNameListCursor
		INTO @ProcName
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		
		--Drop all stored procedures
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			PRINT '>>> Drop Stored Procedure: ' + @ProcName + ' <<<'
			
			IF EXISTS (select * from sysobjects where name = @ProcName and OBJECTPROPERTY(id, N'IsProcedure') = 1) 
				EXEC ('DROP PROCEDURE [' + @ProcName + ']')
				
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
						
			FETCH	NEXT 
			FROM ProcNameListCursor
			INTO @ProcName
	
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @ProcNameCursorFlag = 1
	BEGIN
			CLOSE				ProcNameListCursor
			DEALLOCATE	ProcNameListCursor
	END
END	

RETURN
GO
