

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppSyncGetUploadCacheFilesToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetSyncUploadCacheFilesToPrune()
--  | Description:  Get the files from SyncUploadCache folder for pruning
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/AppSyncGetUploadCacheFilesToPrune.sp,v $ $Id: AppSyncGetUploadCacheFilesToPrune.sp,v 1.2.34.5 2017/10/02 02:19:32 njain Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncGetUploadCacheFilesToPrune <<<'

IF EXISTS (select * from sysobjects where name='AppSyncGetUploadCacheFilesToPrune')
	drop procedure AppSyncGetUploadCacheFilesToPrune
IF EXISTS (select * from GxQscripts where name='AppSyncGetUploadCacheFilesToPrune')
	delete from GxQscripts where name = 'AppSyncGetUploadCacheFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetUploadCacheFilesToPrune')
	delete from GXDBVersions where aliasname = 'AppSyncGetUploadCacheFilesToPrune'
GO
print '... Creating Procedure: AppSyncGetUploadCacheFilesToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSyncGetUploadCacheFilesToPrune
  @i_batchCount INT = 0,
  @i_maxId INT = 0
AS
BEGIN
	/*
		Return top N (batchCount) which ever matching below criteria order by id column
		Criteria
			- .lck files ==> EntityType = 3 and DateDiff > 2 days
			- laptop files ==> EntityType= 111 and DateDiff > 21 days
	*/
	--DECLARE @currDate	DATETIME = GETDATE()
	declare @currUnixTime INT = dbo.GetUnixTime(GETUTCDATE()) -- USE UTC DATE AS UTC DATE GETS INSERTED TO SYNCUPLOADINFO TABLE
	DECLARE @lckPruneInterval INT = 48  -- default 2 days
	DECLARE @laptopPruneInterval INT = 504  -- default 21 days
    DECLARE @backedupFilePruneInterval INT = 4  -- default 4 hours
	DECLARE @enableLCKPruning		BIT = 1
	DECLARE @enableLapTopPruning	BIT = 1
    DECLARE @previewExtractionTaskCompleteFlag INT = CAST(0x200 AS INT) -- APP_SYNC_FLAG_PREVIEW_EXTRACTION_TASK_COMPLETE
    DECLARE @backupCompleteFlag INT = CAST(0x400 AS INT) -- APP_SYNC_FLAG_BKUP_COMPLETE
	if( @i_batchCount <= 0) SET @i_batchCount = 1000
	IF EXISTS ( SELECT * FROM DMSetting WHERE SettingName = 'EDGE_DISABLE_LCK_PRUNING' AND SettingValue = 'TRUE')
		SET @enableLCKPruning = 0
	IF EXISTS ( SELECT * FROM DMSetting WHERE SettingName = 'EDGE_DISABLE_LAPTOP_PRUNING' AND SettingValue = 'TRUE')
		SET @enableLapTopPruning = 0
	SELECT @lckPruneInterval = ISNULL(SettingValue, 48) FROM DMSetting WHERE SettingName = 'EDGE_PRUNE_INTERVAL_FOR_LCK_ITEMS_InHrs'
	SELECT @laptopPruneInterval = ISNULL(SettingValue, 504) FROM DMSetting WHERE SettingName = 'EDGE_PRUNE_INTERVAL_FOR_LAPTOP_ITEMS_InHrs'
	--convert to seconds
	SELECT @lckPruneInterval = @lckPruneInterval * 3600, @laptopPruneInterval = @laptopPruneInterval * 3600, @backedupFilePruneInterval = @backedupFilePruneInterval * 3600
	SELECT TOP (@i_batchCount) SI.id, SI.localPath, (CASE WHEN (flag & @backupCompleteFlag = @backupCompleteFlag) THEN 1 ELSE 0 END) as isBackedup
	FROM SyncUploadInfo AS SI WITH (NOLOCK)
	WHERE SI.id > @i_maxId
	AND
	(
		-- FLAG=0 MEANS UPLOAD HAS NOT COMPLETE AND IS STUCK.
(@enableLCKPruning = 1 AND (SI.flag & 0xF = 0) AND (@currUnixTime - SI.modified) > @lckPruneInterval)
		OR
		(@enableLapTopPruning  = 1 AND entityType = 3 AND (@currUnixTime - SI.modified) > @laptopPruneInterval)
        OR
		-- GET BACKED UP AND (PREVIEW COMPLETED OR MODIFIEDTIME GREATER THAN 4 HRS).
		((flag & @backupCompleteFlag = @backupCompleteFlag) AND ((flag & @previewExtractionTaskCompleteFlag = @previewExtractionTaskCompleteFlag) OR ((@currUnixTime - SI.modified) >@backedupFilePruneInterval )))
	)
	ORDER BY SI.id
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncGetUploadCacheFilesToPrune')
	delete from GxQscripts where name = 'AppSyncGetUploadCacheFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncGetUploadCacheFilesToPrune')
	delete from GXDBVersions where aliasname = 'AppSyncGetUploadCacheFilesToPrune'
GO

insert into GXDBVersions values(2, 'AppSyncGetUploadCacheFilesToPrune',  '00010002003400050000', 'AppSyncGetUploadCacheFilesToPrune', '00010002003400050000')
GO

