

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppProcessEdgeBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--  +========================================================================+
--  |      Name	 :  AppProcessEdgeBackup
--  |
--  | Description:  Delete the entries from Syncupload and DMResultSet for files not downloaded before back up complete
--  |               and returns turboguids of files downloaded before back up is complete (attribute=128)
--	|
--  |	   Input :	input XML request
--	|
--  |      Output:  ouput XML response
--	|
--  |   Revisions  Author      Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.0      Niresh Ramalingam  Gets TurboGuiDs for files downloaded before back up is complete
--  |     1.1      Niresh Ramalingam  Also get the list of files that are backed up and previewExtractionTask not enabled to be deleted on webserver upload cache
--  +========================================================================+
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppProcessEdgeBackup <<<'

IF EXISTS (select * from sysobjects where name='AppProcessEdgeBackup')
	drop procedure AppProcessEdgeBackup
IF EXISTS (select * from GxQscripts where name='AppProcessEdgeBackup')
	delete from GxQscripts where name = 'AppProcessEdgeBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessEdgeBackup')
	delete from GXDBVersions where aliasname = 'AppProcessEdgeBackup'
GO
print '... Creating Procedure: AppProcessEdgeBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppProcessEdgeBackup
  @xmlTextInput XML
AS
SET NOCOUNT ON
    DECLARE @localPathList  TABLE(localPath NVARCHAR(MAX))
    DECLARE @turboGuidList  TABLE(turboGuid NVARCHAR(MAX))
    DECLARE @uploadDeleteList  TABLE(localPath NVARCHAR(MAX))
    DECLARE @previewExtractionTaskCompleteFlag INT = CAST(0x200 AS INT) --APP_SYNC_FLAG_PREVIEW_EXTRACTION_TASK_COMPLETE
    DECLARE @backupCompleteFlag INT = CAST(0x400 AS INT) -- APP_SYNC_FLAG_BKUP_COMPLETE
    DECLARE @xmlOutput   XML ='<Api_ProcessEdgeBackupResponse/>'
    -- Get localPathList
    INSERT @localPathList(localPath)
    SELECT DISTINCT ref.value('(.)[1]', 'NVARCHAR(MAX)')FROM  @xmlTextInput.nodes('/Api_ProcessEdgeBackupRequest/localPathList/@val') doc(ref)
   -- Get turboguid of files that are downloaded before backup
	 INSERT @turboGuidList(turboGuid)
		SELECT DISTINCT DR.IndexGuid FROM @localPathList LPL
	 INNER JOIN SyncUploadInfo SU ON SU.localpath = LPL.localPath
	 INNER JOIN DMResultset DR ON DR.OriginalFullPath = SU.RequestId
	 WHERE DR.Attribute=128
     -- setting the bkup complete flag
     UPDATE SU SET FLAG = FLAG | @backupCompleteFlag
     FROM SyncUploadInfo SU
     INNER JOIN @localPathList LPL ON SU.localpath = LPL.localPath
	 --get the list of files that are backed up and previewExtractionTask is complete
     INSERT @uploadDeleteList(localPath)
     SELECT SU.localpath FROM SyncUploadInfo SU WITH (NOLOCK)
     INNER JOIN @localPathList LPL ON SU.localpath = LPL.localPath AND (flag & @backupCompleteFlag = @backupCompleteFlag) AND (flag & @previewExtractionTaskCompleteFlag = @previewExtractionTaskCompleteFlag )
     -- delete entries in DMResultSet with upload path
     DELETE DR FROM DMResultset DR INNER JOIN @localPathList LPL ON DR.DestinationPath = LPL.localPath
	 SET @xmlOutput =(SELECT
                        (SELECT turboGuid as '@val' FROM @turboGuidList FOR XML PATH('turboGuidList'), TYPE),
                        (SELECT localpath as '@val' FROM @uploadDeleteList FOR XML PATH('uploadDeleteList'), TYPE)
                    FOR xml PATH('Api_ProcessEdgeBackupResponse'))
    SELECT @xmlOutput
GO

IF EXISTS (select * from GxQscripts where name = 'AppProcessEdgeBackup')
	delete from GxQscripts where name = 'AppProcessEdgeBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessEdgeBackup')
	delete from GXDBVersions where aliasname = 'AppProcessEdgeBackup'
GO

insert into GXDBVersions values(2, 'AppProcessEdgeBackup',  '00000000000000000000', 'AppProcessEdgeBackup', '00000000000000000000')
GO

