

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/APP_Upload_GetFileInfoToCopy.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/APP_Upload_GetFileInfoToCopy.sp,v $ $Id: APP_Upload_GetFileInfoToCopy.sp,v 1.5.46.10 2020/07/10 18:29:17 logeshg Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APP_Upload_GetFileInfoToCopy')
BEGIN
	print '>>> Drop Stored Procedure: APP_Upload_GetFileInfoToCopy <<<'
	drop procedure APP_Upload_GetFileInfoToCopy
END
IF EXISTS (select * from GxQscripts where name='APP_Upload_GetFileInfoToCopy')
	delete from GxQscripts where name = 'APP_Upload_GetFileInfoToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_Upload_GetFileInfoToCopy')
	delete from GXDBVersions where aliasname = 'APP_Upload_GetFileInfoToCopy'
GO
print '... Creating Procedure: APP_Upload_GetFileInfoToCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APP_Upload_GetFileInfoToCopy
  @i_restartProcessing int,
  @i_destClientId int,
  @i_reqId nvarchar(max)
AS
SET NOCOUNT ON
-- Flag values: 0: Incomplete File, 1: Ready for Transfer, 2: Under Transfer Process, 3: Waiting for Work-Queue
-- Flag values defined in "AppMgr/AppMgrDefines.h"
-- Reset all Under Process entries, and try to send the files, when cvd restarts
IF @i_restartProcessing = 1
BEGIN
	UPDATE SyncUploadInfo
SET flag = (flag & 0xFFFFFFF0) | 1 -- Add Ready flag without affecting sync flag bits.
WHERE flag & 0xF = 2
	AND entityType = 3 --CLIENT_ENTITY
END
DECLARE @outputTbl TABLE
(requestId NVARCHAR(MAX),
 entityType INT,
 entityId INT,
 destPath NVARCHAR(MAX),
 localPath NVARCHAR(MAX),
 userId INT,
 flag INT
 )
 DECLARE @blackListRetryInterval INT = 60*60
 DECLARE @nowTime INT
 SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
-- Request from cvd threads: i_destClientId = -1
-- Request from Work-Queue: i_destClientId = <valid destination client-id>
IF @i_destClientId <= 0
BEGIN
	INSERT INTO @outputTbl
	SELECT requestId, entityType, entityId, destPath, localPath, userId, flag FROM SyncUploadInfo WITH(NOLOCK)
WHERE ( (flag & 0xF = 1)
										OR
((flag & 0xF = 5) AND ((modified + @blackListRetryInterval) <= @nowTime) )
			)
	AND (entityType = 3/*CLIENT_ENTITY*/ OR entityType = 90 /*LM_MONITORING_POLICY_ENTITY*/)
	AND (
( @i_reqId IS NULL OR @i_reqId = '' ) AND ((flag & 0x80 ) <> 0x80  )   --  Synchronous upload will get accesed by providing requestId
		  OR
		  ( @i_reqId =  requestId ) --  If requestId is passed we need to process only that
	    )
END
ELSE
BEGIN
	INSERT INTO @outputTbl
	SELECT requestId, entityType, entityId, destPath, localPath, userId, flag FROM SyncUploadInfo WITH(NOLOCK)
	WHERE entityId = @i_destClientId
	AND entityType = 3
AND flag & 0xF = 3
	AND entityType = 3 --CLIENT_ENTITY
END
UPDATE SyncUploadInfo
SET flag = (S.flag & 0xFFFFFFF0) | 2 -- Add Processing Flag without affecting sync flag bits.
FROM SyncUploadInfo S
INNER JOIN @outputTbl O ON S.requestId = O.requestId
SELECT DISTINCT requestId, entityType, entityId, destPath, localPath, userId, flag FROM @outputTbl
GO

IF EXISTS (select * from GxQscripts where name = 'APP_Upload_GetFileInfoToCopy')
	delete from GxQscripts where name = 'APP_Upload_GetFileInfoToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_Upload_GetFileInfoToCopy')
	delete from GXDBVersions where aliasname = 'APP_Upload_GetFileInfoToCopy'
GO

insert into GXDBVersions values(2, 'APP_Upload_GetFileInfoToCopy',  '00010005004600100000', 'APP_Upload_GetFileInfoToCopy', '00010005004600100000')
GO

