
IF object_id('tempdb.dbo.#tmpResultSetInfo') IS NOT NULL DROP TABLE #tmpResultSetInfo	
		
CREATE TABLE #tmpResultSetInfo (
	ResultSetID		VARCHAR(36),
	ResultSet 		NVARCHAR(MAX)
)

DECLARE @errorCode INTEGER
SET		@errorCode = 0

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

DECLARE @sqlQuery VARCHAR(MAX)
SET @sqlQuery = ''

PRINT @DescTag + ' Check for data consistencies'

--Get all ResultItem XML from DMResultSet / DMResultSetInfo table
IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DMResultSetInfo]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN
	SET @sqlQuery = 'INSERT INTO #tmpResultSetInfo SELECT ResultSetID, ResultSet FROM DMResultSetInfo WITH (NOLOCK)'
END
ELSE
BEGIN
	SET @sqlQuery = 'INSERT INTO #tmpResultSetInfo SELECT ResultSetID, ResultSet FROM DMResultSet WITH (NOLOCK)'
END

EXEC (@sqlQuery)

SET @errorCode = @@ERROR
IF @errorCode <> 0 GOTO CX_EXIT

--Remove the encoding info 
update #tmpResultSetInfo
set ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), ResultSet), 'encoding="utf-8"', '')

SET @errorCode = @@ERROR
IF @errorCode <> 0 GOTO CX_EXIT

update #tmpResultSetInfo
set ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), ResultSet), 'encoding="utf-16"', '')

SET @errorCode = @@ERROR
IF @errorCode <> 0 GOTO CX_EXIT

--Convert to XML type will catch the XMLs that are not well formed XMLs
update #tmpResultSetInfo
set ResultSet = CONVERT(NVARCHAR(MAX), (CONVERT(XML, ResultSet)))

SET @errorCode = @@ERROR
IF @errorCode <> 0 GOTO CX_EXIT

CX_EXIT:
	DROP TABLE #tmpResultSetInfo
	
	IF @errorCode <> 0
	BEGIN
		PRINT @ErrorTag + ' XML validation failed.' 
		PRINT @AdviceTag + ' Please contact software vendor support.'
		SELECT 2
	END
	ELSE
	BEGIN
		PRINT 'XML validation completed successfully.'
		SELECT 0
	END
		