

--  ------------  Generated from [../../../Source/CommServer/DM2Db/TblScript/DMSetting.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/TblScript/DMSetting.script,v $ $Id: DMSetting.script,v 1.36.2.11 2020/06/23 05:15:22 sjanakiraman Exp $";
-- TABLENAME DMSetting

print '... inserting Table: DMSetting'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME DMSetting

SET NOCOUNT ON

DECLARE @IsReleaseUpgrade INT = 0

DECLARE @isUpgradeFromRel9 integer = 0

SELECT @isUpgradeFromRel9  = (CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END) FROM DBUpgradeSteps 

WHERE Step = 'UpgradeFromRelease' AND CAST(Status AS INTEGER) IN (14)

IF EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeType' AND CAST(Status AS INTEGER) = 1)

BEGIN

	SET @IsReleaseUpgrade = 1

END

IF @IsReleaseUpgrade = 1

BEGIN

	IF NOT EXISTS (SELECT TOP 1 * FROM DMSetting WHERE SettingName = (SELECT TOP 1 'IS_UPGRADE_TO_'+release FROM simAllGalaxyRel ORDER BY id desc))

	BEGIN
		INSERT INTO DMSetting 


		SELECT TOP 1 'IS_UPGRADE_TO_'+release as SettingName, 'True', getDate() FROM simAllGalaxyRel

		ORDER BY id desc

	END

END

--With release upgrade from 9.0 then we will have search by tags option assuming that they could have FAST engine where search by tags feature is needed.

--Upgrading from 10.0, if the customer upgraded from 9.0, then anyway they would have that entry already and need not worry.

IF @isUpgradeFromRel9 = 1

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'SEARCH_BY_TAGS')

	BEGIN
		INSERT INTO DMSetting VALUES ('SEARCH_BY_TAGS', 'True', getDate())


	END

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'ALLOW_EXPORT_TO_PST_FOR_ENDUSER')

BEGIN

	DELETE FROM DMSetting WHERE SettingName = 'ALLOW_EXPORT_TO_PST_FOR_ENDUSER'

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Queries_retention_in_days_per_user')

BEGIN

	DELETE DMSetting WHERE SettingName = 'DEFAULT_Queries_retention_in_days_per_user'

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Result_sets_retention_in_days_per_user')

BEGIN

	DELETE DMSetting WHERE SettingName = 'DEFAULT_Result_sets_retention_in_days_per_user'

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disk_space_quota_per_user')

BEGIN

	DELETE DMSetting WHERE SettingName = 'DEFAULT_Disk_space_quota_per_user'	

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Results_retention_in_days_per_user')

BEGIN

	DELETE DMSetting WHERE SettingName ='DEFAULT_Results_retention_in_days_per_user'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'ALLOW_LEGALHOLD_DELETION')

BEGIN
	INSERT INTO DMSetting VALUES ('ALLOW_LEGALHOLD_DELETION', 'TRUE', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'ALLOW_CISERVER_TAGGING')

BEGIN
	INSERT INTO DMSetting VALUES ('ALLOW_CISERVER_TAGGING', 'TRUE', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'excludeWellKnownSids')

BEGIN
	INSERT INTO DMSetting VALUES ('excludeWellKnownSids', '64', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'InstanceName')

BEGIN
	INSERT INTO DMSetting VALUES ('InstanceName', 'Instance001', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'MAX_FILE_SIZE_FOR_DOWNLOAD')

BEGIN
	INSERT INTO DMSetting VALUES ('MAX_FILE_SIZE_FOR_DOWNLOAD', '209715200', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'MaxDynTeaserLength')

BEGIN
	INSERT INTO DMSetting VALUES ('MaxDynTeaserLength', 512, getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'MaxSubjectLineLength')

BEGIN
	INSERT INTO DMSetting VALUES ('MaxSubjectLineLength', 512, getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Max_number_of_queries_per_user')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Max_number_of_queries_per_user', '100', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = '100'

	WHERE SettingName = 'DEFAULT_Max_number_of_queries_per_user'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Max_number_of_result_sets_per_user')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Max_number_of_result_sets_per_user', '500', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = '500'

	WHERE SettingName = 'DEFAULT_Max_number_of_result_sets_per_user'

END

IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Max_number_of_results_per_search')

BEGIN

	DELETE DMSetting WHERE SettingName = 'DEFAULT_Max_number_of_results_per_search'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Number_of_results_per_page_in_result_set')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Number_of_results_per_page_in_result_set', 10, getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 10

	WHERE SettingName = 'DEFAULT_Number_of_results_per_page_in_result_set'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Number_of_results_per_page_in_Search_results')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Number_of_results_per_page_in_Search_results', 10, getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 10

	WHERE SettingName = 'DEFAULT_Number_of_results_per_page_in_Search_results'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Switch_to_Review_set_upon_item_add')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Switch_to_Review_set_upon_item_add', 'On', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'On'

	WHERE SettingName = 'DEFAULT_Switch_to_Review_set_upon_item_add'

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Hide_Visible_File_Advanced_search_tabs')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Show_File_Advanced_search_tabs',

		SettingValue = 'True'

	WHERE SettingName = 'DEFAULT_Hide_Visible_File_Advanced_search_tabs'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Show_File_Advanced_search_tabs')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Show_File_Advanced_search_tabs', 'True', getDate())

	END

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Hide_Visible_Email_Advanced_search_tabs')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Show_Email_Advanced_search_tabs',

		SettingValue = 'True'

	WHERE SettingName = 'DEFAULT_Hide_Visible_Email_Advanced_search_tabs'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Show_Email_Advanced_search_tabs')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Show_Email_Advanced_search_tabs', 'True', getDate())

	END

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_End_user_based_security')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_End_user_based_security', 'Based on recipients', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'Based on recipients'

	WHERE SettingName = 'DEFAULT_End_user_based_security'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Default_search_tab_to_show')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_Default_search_tab_to_show', 'All', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'All'

	WHERE SettingName = 'DEFAULT_Default_search_tab_to_show'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Enable_Document_Highlighting')

BEGIN
	INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) VALUES ('DEFAULT_Enable_Document_Highlighting', 'On', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'On'

	WHERE SettingName = 'DEFAULT_Enable_Document_Highlighting'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Allow_emails_export_to_PST')

BEGIN
	INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) VALUES ('DEFAULT_Allow_emails_export_to_PST', 'Off', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'Off'

	WHERE SettingName = 'DEFAULT_Allow_emails_export_to_PST'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disable_End_User_Setting')

BEGIN
	INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) VALUES ('DEFAULT_Disable_End_User_Setting', 'False', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'False'

	WHERE SettingName = 'DEFAULT_Disable_End_User_Setting'

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disable_Search_Option')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Enable_Search_Option',

		SettingValue = 'True'

	WHERE SettingName = 'DEFAULT_Disable_Search_Option'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Enable_Search_Option')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Enable_Search_Option', 'True', getDate())

	END

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disable_Browse_Option')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Enable_Browse_Option',

		SettingValue = 'True'

	WHERE SettingName = 'DEFAULT_Disable_Browse_Option'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Enable_Browse_Option')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Enable_Browse_Option', 'True', getDate())

	END

END

IF EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Disable_MyContents_Option')

BEGIN

	UPDATE DMSetting

	SET SettingName = 'DEFAULT_Enable_MyContents_Option',

		SettingValue = 'False'

	WHERE SettingName = 'DEFAULT_Disable_MyContents_Option'

END

ELSE

BEGIN

	IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_Enable_MyContents_Option')

	BEGIN
		INSERT INTO DMSetting (SettingName,SettingValue,CreateTime) 


		VALUES ('DEFAULT_Enable_MyContents_Option', 'False', getDate())

	END

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DOC_ONLINE_URL')

BEGIN
	INSERT INTO DMSetting


	SELECT 'DOC_ONLINE_URL' AS SettingName, 'http://documentation.commvault.com/commvault/release_8_0_0//books_online_1/english_us/prod_info/ci_search.htm' AS SettingValue, GetDate()

END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = 'https://search.commvault.com/docsearch/searchHandler?wt=rss&release=v11'

	WHERE SettingName = 'DOC_ONLINE_URL'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'USE_ONLINE_DOC_URL')

BEGIN
	INSERT INTO DMSetting


	SELECT 'USE_ONLINE_DOC_URL' AS SettingName, 'False' AS SettingValue, GetDate()

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CI_STATE_SUCCESS')

BEGIN
	INSERT INTO DMSetting


	SELECT 'CI_STATE_SUCCESS' AS SettingName, '0,1,12,13,14,15,1014' AS SettingValue, GetDate()

END

ELSE

BEGIN

	UPDATE DMSetting

	SET SettingValue = '0,1,12,13,14,15,1014' WHERE SettingName = 'CI_STATE_SUCCESS'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CI_STATE_DELETED')

BEGIN
	INSERT INTO DMSetting


	SELECT 'CI_STATE_DELETED' AS SettingName, '3333,3334,3335' AS SettingValue, GetDate()

END

ELSE

BEGIN

update DMSetting 

	SET SettingValue='3333,3334,3335' where SettingName='CI_STATE_DELETED'

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CI_STATE_FAILED')

BEGIN
	INSERT INTO DMSetting


	SELECT 'CI_STATE_FAILED' AS SettingName, '2,16,1016,2016' AS SettingValue, GetDate()

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DM2_DATABASE_ID')

BEGIN
	INSERT INTO DMSetting VALUES ('DM2_DATABASE_ID', newId(), getDate())


END

ELSE

BEGIN

	IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DM2_DATABASE_ID' AND LEN(SettingValue) <> 36)

	BEGIN

		UPDATE DMSetting SET SettingValue = newId() WHERE SettingName = 'DM2_DATABASE_ID'

	END

END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CHUNK_SIZE')

BEGIN
	INSERT INTO DMSetting VALUES ('CHUNK_SIZE', '3145728', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'JOB_STATUS_PAGE_SIZE')

BEGIN
	INSERT INTO DMSetting VALUES ('JOB_STATUS_PAGE_SIZE', '25', getDate())


END

-- Number of minutes for session time out.

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'SESSION_TIME_OUT')

BEGIN
	INSERT INTO DMSetting VALUES ('SESSION_TIME_OUT', '30', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'PRELOGIN_BANNER_ENABLED')

BEGIN
	INSERT INTO DMSetting VALUES ('PRELOGIN_BANNER_ENABLED', 'False', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'PRELOGIN_BANNER_TEXT')

BEGIN
	INSERT INTO DMSetting VALUES ('PRELOGIN_BANNER_TEXT', '', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DISABLE_EMPTYKEYWORD_SEARCH_ENDUSER')

BEGIN
	INSERT INTO DMSetting VALUES ('DISABLE_EMPTYKEYWORD_SEARCH_ENDUSER', 'True', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DISABLE_EMPTYKEYWORD_SEARCH_COMPUSER')

BEGIN
	INSERT INTO DMSetting VALUES ('DISABLE_EMPTYKEYWORD_SEARCH_COMPUSER', 'True', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'ALLOW_RESULTS_GROUPING')

BEGIN
	INSERT INTO DMSetting VALUES ('ALLOW_RESULTS_GROUPING', 'True', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting SET SettingValue='True' WHERE SettingName = 'ALLOW_RESULTS_GROUPING'

END

-- -- only possible values as of now: modifiedUTCTime, rank.

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'DEFAULT_SEARCH_SORT_ORDER')

BEGIN
	INSERT INTO DMSetting VALUES ('DEFAULT_SEARCH_SORT_ORDER', 'modifiedUTCTime', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'PERFORM_DATETIME_LOCAL_SORT')

BEGIN
	INSERT INTO DMSetting VALUES ('PERFORM_DATETIME_LOCAL_SORT', 'False', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'SIZE_IN_GB')

BEGIN
	INSERT INTO DMSetting VALUES ('SIZE_IN_GB', '4', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'AUTO_EDRM_UPON_DOWNLOAD')

BEGIN
	INSERT INTO DMSetting VALUES ('AUTO_EDRM_UPON_DOWNLOAD', 'False', getDate())


END

-- VALUES CAN BE SYNC_ONLY_TURBO, SYNC_ALL, SYNC_FORCE_ALL or SYNC_NEVER. Default will be SYNC_ONLY_TURBO as the feature is now (Jun18-2012) integrated.

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'RESTORE_OFFSET_SYNC_OPTION')

BEGIN
	INSERT INTO DMSetting VALUES ('RESTORE_OFFSET_SYNC_OPTION', 'SYNC_ONLY_TURBO', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'CI_STATE_SKIPPED')

BEGIN
	INSERT INTO DMSetting VALUES ('CI_STATE_SKIPPED','17', getDate())


END

--Number of hours after which we decide to sync with indexing layer again if needed for turbo.

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'INDEX_SYNC_INTERVAL')

BEGIN
	INSERT INTO DMSetting VALUES ('INDEX_SYNC_INTERVAL','24', getDate())


END

--IF solr is slow on returning aFileId facets, then we can set this True. This way, instead of finding facets on entire search request, we will take distinct aFileId in each page of results and check if it is marked for pruning

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'SKIP_SEARCH_SYNC_PREP_PHASE')

BEGIN
	INSERT INTO DMSetting VALUES ('SKIP_SEARCH_SYNC_PREP_PHASE','False', getDate())


END

IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'EmailQueryWithCopyField')

BEGIN
	INSERT INTO DMSetting VALUES ('EmailQueryWithCopyField','True', getDate())


END

ELSE

BEGIN

	UPDATE DMSetting 

	SET SettingValue = 'True'

	WHERE SettingName = 'EmailQueryWithCopyField'

END

IF NOT EXISTS(SELECT * FROM DMSETTING WHERE settingname = 'ENABLE_TURBO_GUID_CHECK_IN_RESTORE')

BEGIN
    INSERT INTO DMSETTING VALUES ('ENABLE_TURBO_GUID_CHECK_IN_RESTORE', 'True', GETDATE())


END 

IF NOT EXISTS(SELECT * FROM DMSETTING WHERE settingname = 'RecallBasedPreviewAllowed')

BEGIN
    INSERT INTO DMSETTING VALUES ('RecallBasedPreviewAllowed', 'allowed', GETDATE())


END 

IF NOT EXISTS(SELECT * FROM DMSETTING WHERE settingname = 'sEnableTagFiltering')

BEGIN
    INSERT INTO DMSETTING VALUES ('sEnableTagFiltering', 'True', GETDATE())


END 

IF NOT EXISTS(SELECT * FROM DMSETTING WHERE settingname = 'CREATE_DATASOURCE_FOR_REVIEWSET')

BEGIN
    INSERT INTO DMSETTING VALUES ('CREATE_DATASOURCE_FOR_REVIEWSET', 'False', GETDATE())


END

-- add egde role and fs role to be able to search in compliance site

IF NOT EXISTS(SELECT * FROM DMSETTING WHERE settingname = 'ComplianceSearchIndexServerRoles')

BEGIN
    INSERT INTO DMSETTING VALUES ('ComplianceSearchIndexServerRoles', 'FileSystem Index', GETDATE())


END

ELSE

BEGIN

	-- role name was incorrect in sp14.. So correct it here

	update DMSetting 

	SET SettingValue = replace(SettingValue, 'EDGE Index', 'EDGE Drive') 

	where SettingName = 'ComplianceSearchIndexServerRoles'

	--remove edge drive role. No default support

	update DMSetting SET SettingValue=replace(SettingValue, 'EDGE Drive,', '')

	where SettingName='ComplianceSearchIndexServerRoles'

	--if value doesnt contain filesystem index already , add it now

	update DMSetting 

	SET SettingValue = SettingValue + ',FileSystem Index' 

	where SettingName = 'ComplianceSearchIndexServerRoles' and SettingValue NOT LIKE '%FileSystem Index%'

END

IF NOT EXISTS (SELECT 1 FROM DBUpgradeSteps WHERE Step = 'UpgradeInProgress') AND NOT EXISTS (SELECT 1 FROM DMSetting WHERE SettingName = 'ENABLE_BCC_ADMIN_SEARCH')

BEGIN
    INSERT INTO DMSETTING VALUES ('ENABLE_BCC_ADMIN_SEARCH', 'True', GETDATE())


END

DECLARE @SettingVal VARCHAR(MAX)

DECLARE @SP13ReindexTime DATETIME = '2018-09-15'

DECLARE @LastIndexTime DATETIME

SELECT @SettingVal = SettingValue, @LastIndexTime = CREATETIME FROM DMSETTING 

WHERE SettingName = 'DC_FULL_RUN_STATUS'

IF @SettingVal IS NOT NULL AND @SettingVal = 'True' AND @LastIndexTime < @SP13ReindexTime

BEGIN

	UPDATE DMSetting SET SettingValue = 'False', CreateTime = @SP13ReindexTime WHERE SettingName = 'DC_FULL_RUN_STATUS'

END

SET NOCOUNT OFF

GO

