SET QUOTED_IDENTIFIER OFF
SET NOCOUNT ON
GO

BEGIN
	DECLARE @TriggerNameCursorFlag 	INTEGER
	SET 		@TriggerNameCursorFlag 	= 0
	
	DECLARE	@errorCode	INTEGER
	SET 		@errorCode	= 0
	
	DECLARE	@TriggerName		NVARCHAR(256)

	DECLARE @currentRel 		INTEGER
	DECLARE @relStr					NVARCHAR(128)
	DECLARE @SQLString  		NVARCHAR(500)
	DECLARE @ParamDef				NVARCHAR(500)	
	DECLARE @ParamVal				NVARCHAR(500)

	SET @currentRel = (select max(id) from simAllGalaxyrel)
	SET @relStr = (select release from simAllGalaxyrel where id=@currentRel)

	/* Build the SQL string. */
	IF @relStr = '6.1'
	BEGIN
		SET @SQLString = N'DECLARE TriggerNameListCursor CURSOR STATIC FOR SELECT distinct aliasname FROM cvTable WHERE type = 6' -- (For Triggers)
	END
	ELSE
	BEGIN
		SET @SQLString = N'DECLARE TriggerNameListCursor CURSOR STATIC FOR SELECT distinct aliasname FROM GXDBVersions WHERE type = 6' -- (For Triggers)	
	END
			
	EXECUTE sp_executesql @SQLString
		
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		
	SET		@TriggerNameCursorFlag = 1
	OPEN	TriggerNameListCursor

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	FETCH	NEXT 
	FROM TriggerNameListCursor
	INTO @TriggerName

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	
	--Drop all triggers
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		print '>>> Drop Trigger: ' + @TriggerName + ' <<<'
	
		IF EXISTS (select * from sysobjects where name = @TriggerName and OBJECTPROPERTY(id, N'IsTrigger') = 1) 
			EXEC ('DROP TRIGGER [' + @TriggerName + ']')
			
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		/* Build the SQL string. */
		IF @relStr = '6.1'
		BEGIN
			SET @SQLString = N'IF EXISTS (select * from cvTable where aliasname = @TrigName AND type = 6) DELETE FROM cvTable WHERE aliasname = @TrigName AND type = 6'
		END
		ELSE
		BEGIN
			SET @SQLString = N'IF EXISTS (select * from GXDBVersions where aliasname = @TrigName AND type = 6) DELETE FROM GXDBVersions WHERE aliasname = @TrigName AND type = 6'
		END
				
		SET @ParamDef = N'@TrigName NVARCHAR(32)'
		SET @ParamVal = @TriggerName
		EXECUTE sp_executesql @SQLString, @ParamDef, @TrigName = @ParamVal

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		FETCH	NEXT 
		FROM TriggerNameListCursor
		INTO @TriggerName

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @TriggerNameCursorFlag = 1
	BEGIN
			CLOSE				TriggerNameListCursor
			DEALLOCATE	TriggerNameListCursor
	END
END	

RETURN
GO

