

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_ViewCommands.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_ViewCommands.sp,v $ $Id: sp_dm2_ViewCommands.sp,v 1.1.2.7 2020/02/12 15:15:41 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_ViewCommands')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_ViewCommands <<<'
	drop procedure sp_dm2_ViewCommands
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_ViewCommands')
	delete from GxQscripts where name = 'sp_dm2_ViewCommands'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ViewCommands')
	delete from GXDBVersions where aliasname = 'sp_dm2_ViewCommands'
GO
print '... Creating Procedure: sp_dm2_ViewCommands'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_ViewCommands
  @i_StartIndex int = 0,
  @i_ItemsOnPage int = 0,
  @i_OrderByClause nvarchar(max) = 'modifiedTime DESC',
  @i_flatTable INT = 0,
  @o_TotalCount int output,
  @o_errorCode INT OUTPUT,
  @o_errorMessage nvarchar(max) OUTPUT
AS
BEGIN
  DECLARE @StartRN integer
  DECLARE @EndRN integer
  DECLARE @sqlCmd nvarchar(max)
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SELECT @sqlCmd = ''
	BEGIN TRY
		IF @i_StartIndex <= 0 OR @i_ItemsOnPage <= 0
		BEGIN
			SET @StartRN = 1
			SET @i_ItemsOnPage = 15
		END
		ELSE
		BEGIN
			SET @StartRN = @i_StartIndex + 1
		END
		SET @EndRN = @StartRN + @i_ItemsOnPage - 1
		PRINT '@i_ItemsOnPage = ' + CONVERT(VARCHAR,@i_ItemsOnPage) + ' , @StartRN = ' + CONVERT(VARCHAR, @StartRN)
		IF object_id('tempdb.dbo.#tblTempCommand') is not null
			DROP TABLE #tblTempCommand
		create table #tblTempCommand (Id INT IDENTITY(1,1), CommandId INT)
		DECLARE @colOrder TABLE ( Id int identity(1,1), Data nvarchar(max) )
		INSERT INTO @colOrder SELECT TOP 2 Data FROM split(@i_OrderByClause,' ') WHERE Data <>' '
		DECLARE @orderByColName NVARCHAR(MAX)
		DECLARE @orderByColType NVARCHAR(MAX)
		SELECT @orderByColName = Data FROM @colOrder where Id=1
		SELECT @orderByColType = Data FROM @colOrder where Id=2
		IF(ISNULL(@orderByColType,'') <> 'asc'  AND  ISNULL(@orderByColType,'') <> 'desc' )
			SET @orderByColType = 'asc'
		SET @sqlCmd = 'insert into #tblTempCommand select C.CommandId FROM DMCmd C '
		--Earlier there was no check and this can cause error if client program explicitely sends empty order by clause..
		-- Also ensure the column name is valid, else use the default col sort ( ModifiedTime)
		IF ISNULL(@i_OrderByClause, '') <> '' AND EXISTS (SELECT 1 FROM sys.columns WHERE NAME=@orderbyColName AND Object_ID = Object_ID('DMCmd') )
			BEGIN
				IF @i_OrderByClause = 'RunTime' OR @i_OrderByClause = 'RunTime asc'
				BEGIN
					SET @sqlCmd = @sqlCmd + ' LEFT JOIN DMCmdRun CR On CR.CommandId = C.CommandId GROUP BY C.CommandId order by  MAX(CR.RunTime)'
				END
				ELSE IF @i_OrderByClause = 'RunTime Desc'
				BEGIN
					SET @sqlCmd = @sqlCmd + ' LEFT JOIN DMCmdRun CR On CR.CommandId = C.CommandId GROUP BY C.CommandId order by  MAX(CR.RunTime) desc'
				END
				ELSE
				BEGIN
					SET @sqlCmd = @sqlCmd + ' order by ' +  @orderByColName + ' ' + @orderByColType
				END
			END
		ELSE
			BEGIN
				SET @sqlCmd = @sqlCmd + ' order by ModifiedTime DESC '
			END
		PRINT @sqlCmd
		exec sp_executesql @sqlCmd
		-- Total number of commands in DB
		SELECT @o_TotalCount = count(*) from #tblTempCommand
		--
		if @EndRN < 0 	select @EndRN = @o_TotalCount
		--
		IF @i_flatTable = 1
		BEGIN
			SELECT C.CommandId, CT.EntityId, CT.EntityType, CP.ParamGuid, DG.Name as ActionName, DF.FieldLabel as ParamName, CP.ParamValue,
				CR.RunTime, CR.RunID  FROM #tblTempCommand T
				INNER JOIN DMCmdTarget CT ON T.CommandId = CT.CommandId
				INNER JOIN DMCmdRun CR ON T.CommandId = CR.CommandId
				INNER JOIN DMCmdAction CA ON T.CommandId = CA.CommandId
				INNER JOIN DMSearchCriteriaGroup DG ON DG.Id = CA.ActionId
				LEFT JOIN DMCmdParams CP ON CP.CommandActionId = CA.CommandActionId
				LEFT JOIN DMSearchCriteriaField DF ON DF.Id = CP.ParamGuid
				INNER JOIN DMCmd C ON C.CommandId = T.CommandId
				where T.Id between @StartRN and @EndRN
				ORDER BY T.Id, CR.RunTime desc
		END
		ELSE
		BEGIN
			select (select C.CommandId '@cmdid',
				C.Name '@name',
				C.Description '@desc',
				C.ClientType '@clientType',
				C.Attribute '@attribute',
				C.Status '@status',
				C.Retention '@retentionPeriod',
				dbo.GetUnixTime(C.ModifiedTime) '@modifiedTime',
				dbo.GetUnixTime(C.CreateTime) '@createTime',
				C.CreatedBy '@createdByGuid',
				C.ModifiedBy '@modifiedByGuid',
				C.TaskId '@taskId'
			FOR XML PATH('cmdList') , TYPE)
			from #tblTempCommand T
			INNER JOIN DMCmd C ON T.CommandId = C.CommandId
			where T.Id between @StartRN and @EndRN
			ORDER BY T.Id
			FOR XML PATH(''), ROOT('DM2ContentIndexing_DM2CmdViewResponse')
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @o_errorMessage = ERROR_MESSAGE(), @o_errorCode = ERROR_NUMBER()
	END CATCH
_EXIT:
	IF object_id('tempdb.dbo.#tblTempCommand') is not null
	DROP TABLE #tblTempCommand
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_ViewCommands')
	delete from GxQscripts where name = 'sp_dm2_ViewCommands'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_ViewCommands')
	delete from GXDBVersions where aliasname = 'sp_dm2_ViewCommands'
GO

insert into GXDBVersions values(2, 'sp_dm2_ViewCommands',  '00010001000200070000', 'sp_dm2_ViewCommands', '00010001000200070000')
GO

