

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateVSARestoreFilesBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateVSARestoreFilesBulk()
--  | Description:  Update the Restore JobId in bulk for VM restore
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateVSARestoreFilesBulk.sp,v $ $Id: sp_dm2_UpdateVSARestoreFilesBulk.sp,v 1.1.2.3 2017/09/02 18:23:12 sbonilla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateVSARestoreFilesBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateVSARestoreFilesBulk')
	drop procedure sp_dm2_UpdateVSARestoreFilesBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateVSARestoreFilesBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateVSARestoreFilesBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateVSARestoreFilesBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateVSARestoreFilesBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateVSARestoreFilesBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateVSARestoreFilesBulk
  @i_jobId Integer,
  @DMrestoreTbl DM2RestoreFileUpdateV2 READONLY,
  @i_isUnixUpdate INTEGER = 0
AS
		DECLARE @error int
		DECLARE @DownloadID char(36)
		DECLARE @SettingVal VARCHAR(MAX) = ''
		DECLARE @CcnCheckEnabled BIT = 0
		DECLARE @TurboGuicCheckEnabled BIT = 0
		DECLARE @MtimeCheckEnabled BIT = 0
		SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_CCN_CHECK_IN_RESTORE'
		IF ISNULL(@SettingVal, '') = 'True'
			SET @CcnCheckEnabled = 1
		SET @SettingVal = ''
		SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_TURBO_GUID_CHECK_IN_RESTORE'
		IF ISNULL(@SettingVal, '') = 'True'
			SET @TurboGuicCheckEnabled = 1
		SET @SettingVal = ''
		SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_MODIFIED_TIME_CHECK_IN_RESTORE'
		IF ISNULL(@SettingVal, '') = 'True'
			SET @MtimeCheckEnabled = 1
	BEGIN TRANSACTION
		DECLARE @lt_AFFiles TABLE (ID int IDENTITY(1,1) ,CCId int, AFId bigint, OrigPath nvarchar(max), DestPath nvarchar(max), status int, mtime int, turboGUID varchar(128))
		INSERT INTO @lt_AFFiles (CCId,AFId,OrigPath,DestPath,status, mtime, turboGUID)
		SELECT T.CCId,T.AFId,T.OPath,T.DPath,T.status, T.mtime, T.turboGUID FROM @DMrestoreTbl as T
		DECLARE @lt_AFFilesToResultSetId TABLE (t_id int , t_resultSetID char(36))
		INSERT INTO  @lt_AFFilesToResultSetId
		SELECT T.ID,  R.ResultSetID
		FROM @lt_AFFiles T, DMResultSet R WITH (NOLOCK)
		WHERE OriginalFullPath = OrigPath
		AND (@MtimeCheckEnabled = 0 OR (@MtimeCheckEnabled = 1 AND mtime = dbo.GetUnixTime(ModifiedTime)))
				AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
		AND T.ID NOT IN (SELECT DISTINCT t_id FROM @lt_AFFilesToResultSetId )
		AND R.RestoreJobID = @i_jobId
		UPDATE DMResultSet
		SET DestinationPath = tt.DestPath, RestoreStatus = 4
		FROM @lt_AFFiles tt, @lt_AFFilesToResultSetId tr
		WHERE ResultSetID = tr.t_resultSetID AND tt.id = tr.t_id
		AND RestoreJobID = @i_jobId
        AND ModifiedTime = dbo.GetDateTime(tt.mtime)
		SET @error = @@ERROR
		IF @error = 0
		BEGIN
			SELECT TOP 1 @DownloadID = DownloadID FROM DMDownload WITH(NOLOCK) WHERE RestoreJobID = @i_jobId
			IF ISNULL(@DownloadID, '') <> ''
			BEGIN
				UPDATE DMDownloadResultSet
				SET [FileName] = tt.DestPath,
				[Status] = (CASE WHEN tt.Status = 4 AND ISNULL(tt.DestPath, '') <> '' THEN 100 ELSE 500 END)
				FROM @lt_AFFiles tt, @lt_AFFilesToResultSetId tr
				WHERE DownloadID = @DownloadID AND tt.id = tr.t_id AND ResultSetID = tr.t_resultSetID
				SET @error = @@ERROR
			END
		END
		IF @error = 0
			COMMIT TRANSACTION
		ELSE
			ROLLBACK TRANSACTION
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateVSARestoreFilesBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateVSARestoreFilesBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateVSARestoreFilesBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateVSARestoreFilesBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateVSARestoreFilesBulk',  '00010001000200030000', 'sp_dm2_UpdateVSARestoreFilesBulk', '00010001000200030000')
GO

