

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateResultSetToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateResultSetToPrune()
--  | Description:  Update the resultsets to prune
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateResultSetToPrune.sp,v $ $Id: sp_dm2_UpdateResultSetToPrune.sp,v 1.3 2011/06/21 10:01:21 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateResultSetToPrune <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateResultSetToPrune')
	drop procedure sp_dm2_UpdateResultSetToPrune
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateResultSetToPrune')
	delete from GxQscripts where name = 'sp_dm2_UpdateResultSetToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateResultSetToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateResultSetToPrune'
GO
print '... Creating Procedure: sp_dm2_UpdateResultSetToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateResultSetToPrune
  @i_PruneResults XML
AS
	SET NOCOUNT ON
-- expects a list like
-- <PruneResults>
--    <ResultSet ResultSetID="abcd-abcd0a0d-ad-gadg-ag-d" PruneStatus="1"/>
--    <ResultSet ResultSetID="asdfas-abcdasdf0a0d-ad-asd" PruneStatus="2"/>
--    <ResultSet ResultSetID="abasdfasd-adsf-a-dsf-a-dfd" PruneStatus="3"/>
-- </PruneResults>
	DECLARE @tblResultSetPruneResults TABLE (RSID varchar(36), Status int)
	DECLARE @tblResultSetDeleted TABLE (RSID varchar(36))
	INSERT INTO @tblResultSetPruneResults
	SELECT T.c.value('@ResultSetID','varchar(36)'),
		   T.c.value('@PruneStatus', 'int')
	FROM @i_PruneResults.nodes('/PruneResults/ResultSet') T(c)
	INSERT INTO @tblResultSetDeleted
	SELECT DISTINCT RS.ResultSetID
	FROM DMResultSet RS WITH (READUNCOMMITTED) LEFT OUTER JOIN DMDownloadResultSet D WITH (READUNCOMMITTED)
	ON RS.ResultSetId = D.ResultSetId
	WHERE D.ResultSetId IS NULL
	AND RS.ResultSetID IN (SELECT RSID FROM @tblResultSetPruneResults WHERE Status = 0)
	AND	(RS.Attribute & 4) = 4
	-- Update prune status for items that are successfully removed from cache
	UPDATE DMResultSet
	SET PruneStatus = 0,
	PruneUpdateTime = getUTCDate(),
	DestinationPath = '',
	RestoreUserGUID = '',
	RestoreCommCellNumber = 0,
	RestoreJobID = 0,
	RestoreStatus = 0,
	RestoreTime = NULL
	WHERE ResultSetID IN (SELECT RSID FROM @tblResultSetPruneResults WHERE Status = 0)
	-- Update the PruneStatus of all items that failed to remove from cache
	UPDATE DMResultSet
	SET PruneStatus = tt.Status, PruneUpdateTime = getUTCDate()
	FROM @tblResultSetPruneResults tt
  WHERE ResultSetID = tt.RSID
  AND		tt.Status != 0
	AND	(Attribute & 4) = 4
	UPDATE DMResultSet
	SET PruneStatus = 0, PruneUpdateTime = getUTCDate()
	FROM @tblResultSetPruneResults tt
  WHERE ResultSetID = tt.RSID
  AND tt.Status != 0
	AND	(Attribute & 4) = 0
/*
	-- This can be moved to sp_dm2_prunedownload
	delete from DMDownloadResultSet
	where ResultSetID in (select RSID from @tblResultSetDeleted)
	-- This will be moved to new SP which needs to handle physical pruning of zip files and cab files
	-- In response of above SP we will delete entries from DMDownload table
	delete from DMDownload
	where DownloadID not in (select DownloadID from DMDownloadResultSet WITH (READUNCOMMITTED))
*/
/*
	-- No need to keep entries for Legalhold since we are now going to get legalhold page info from LegalHold MetaData XML
	-- Do Not delete the resultset for LegalHold Backups
	DELETE 	@tblResultSetDeleted
	FROM 		@tblResultSetDeleted T, DMLegalHoldItemsToBackup LHI WITH (NOLOCK)
	WHERE 	T.RSID = LHI.ResultSetID
*/
	-- Now we are not going to soft delete items in DMContainerItem table.
	--It will be deleted when delete operation is performed on Reviewsets or items on reviewset
	--However, need this deletion for upgrading customers
	DELETE FROM DMContainerItem
	WHERE ResultSetID IN (SELECT RSID FROM @tblResultSetDeleted)
	DELETE 	DMContainerItemStates
	FROM 		DMContainerItemStates S LEFT OUTER JOIN DMContainerItem CI
	ON 			S.containerID = CI.containerID
	AND			S.resultsetID = CI.resultsetID
	WHERE 	CI.containerID IS NULL
	AND 		CI.resultsetID IS NULL
	--Items that are not restored can be deleted if not referenced in any reviewsets
	INSERT INTO @tblResultSetDeleted
	SELECT RS.ResultSetID
	FROM DMResultSet RS LEFT OUTER JOIN DMDownloadResultSet D
	ON RS.ResultSetId = D.ResultSetId
	WHERE D.ResultSetId IS null
	AND (DestinationPath IS null OR LEN(DestinationPath) = 0)
	AND	(Attribute & 4) = 4
	--prune DMACtion tables.
	DECLARE @ResultSetIds VARCHAR(MAX)
	SELECT @ResultSetIds = ISNULL(STUFF(
					(SELECT  ';' "text()", RSID "text()"
						FROM 	@tblResultSetDeleted
						FOR XML PATH('')),1,1,''),'')
	EXEC sp_dm2_PruneActionInfo @i_resultSetIds = @ResultSetIds
	DELETE FROM DMResultSet
	WHERE ResultSetID IN (SELECT RSID FROM @tblResultSetDeleted)
	--DELETE DMResultSet
	--FROM DMResultSet RS LEFT OUTER JOIN DMDownloadResultSet D
	--ON RS.ResultSetId = D.ResultSetId
	--WHERE D.ResultSetId IS null
	--AND (DestinationPath IS null OR LEN(DestinationPath) = 0)
	--AND	(Attribute & 4) = 4
/*
	-- We don't need to set / unset this flag now
	UPDATE DMContainerItem
	SET Attribute = (Attribute & ~1)
	where ResultSetID in (select RSID from @tblResultSetPruneResults where Status = 0)
	and (Attribute & 1) = 1
	-- DMContainer table is moved to CS now
	-- There is no user preference based pruning
	delete from DMContainer
	where ContainerID not in (select ContainerID from DMContainerItem WITH (READUNCOMMITTED))
	and (Attribute & 1) = 1
*/
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateResultSetToPrune')
	delete from GxQscripts where name = 'sp_dm2_UpdateResultSetToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateResultSetToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateResultSetToPrune'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateResultSetToPrune',  '00010003000000000000', 'sp_dm2_UpdateResultSetToPrune', '00010003000000000000')
GO

