

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreStatusBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreStatusBulk()
--  | Description:  Update the Restore Status in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreStatusBulk.sp,v $ $Id: sp_dm2_UpdateRestoreStatusBulk.sp,v 1.6.12.2 2019/04/16 16:21:13 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreStatusBulk')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreStatusBulk <<<'
	drop procedure sp_dm2_UpdateRestoreStatusBulk
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreStatusBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreStatusBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreStatusBulk
  @i_jobId Integer,
  @DMrestoreTbl DM2RestoreStatusUpdate READONLY
AS
BEGIN
-- expects a list like
-- <restlist>
--    <file CCId="2" AFId="2" AFOffset="27" DPath="/blabla" />
--    <file CCId="2" AFId="4" AFOffset="37" />
--    <file CCId="2" AFId="6" AFOffset="909" />
-- </restlist>
	DECLARE @lt_AFFiles TABLE (CCId int, AFId bigint, AFOffset bigint, OrigPath nvarchar(max), DestPath nvarchar(max), status int, ResultItemID char(36))
	DECLARE @lt_AFFilesToResultSetId TABLE (t_resultSetID char(36), t_ResultID bigint, t_destPath nvarchar(max))
	DECLARE @error int
	DECLARE @DownloadID char(36)
--	INSERT INTO @lt_AFFiles (CCId,AFId,AFOffset,OrigPath,DestPath,status)
--	SELECT T.c.value('@CCId','int'),
--		   T.c.value('@AFId', 'bigint'),
--		   T.c.value('@AFOffset', 'bigint'),
--		   T.c.value('@OPath', 'nvarchar(max)'),
--		   T.c.value('@DPath', 'nvarchar(max)'),
--		   ISNULL(T.c.value('@status', 'int'), 0) -- ERMStatus for success
--	FROM   @i_xml_AFFiles.nodes('/restlist/file') T(c)
	INSERT INTO @lt_AFFiles (CCId,AFId,AFOffset,OrigPath,DestPath,status)
	SELECT T.CCId,T.AFId,T.AFOffset,T.OPath,T.DPath,ISNULL(T.status, 0) FROM @DMrestoreTbl as T
	insert into @lt_AFFilesToResultSetId (t_resultSetID, t_ResultID, t_destPath)
	select r.ResultSetID, r.id, tt.DestPath  FROM @lt_AFFiles tt, DMResultSet R WITH(NOLOCK)
	WHERE
				-- CommcellNumber= tt.CCId AND
			aFileID = tt.AFId
			AND ( aFileOffset = tt.AFOffset OR (ISNULL(tt.OrigPath, '') != '' AND OriginalFullPath = tt.OrigPath))
	BEGIN TRANSACTION
		UPDATE DMResultSet
		SET DestinationPath = tt.t_destPath, RestoreStatus = 4
		FROM @lt_AFFilesToResultSetId tt
		WHERE ID = tt.t_ResultID
		SET @error = @@ERROR
		IF @error = 0
		BEGIN
			SELECT TOP 1 @DownloadID = DownloadID FROM DMDownload WITH(NOLOCK) WHERE RestoreJobID = @i_jobId
			IF ISNULL(@DownloadID, '') <> ''
			BEGIN
				UPDATE DMDownloadResultSet
				SET [FileName] = tt.t_destPath,
				[Status] = (CASE WHEN ISNULL(tt.t_destPath, '') <> '' THEN 100 ELSE 500 END)
				FROM @lt_AFFilesToResultSetId tt
				WHERE DownloadID = @DownloadID AND ResultSetID = tt.t_resultSetID
				SET @error = @@ERROR
			END
		END
	IF @error = 0
		COMMIT TRANSACTION
	ELSE
		ROLLBACK TRANSACTION
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreStatusBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreStatusBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreStatusBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreStatusBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreStatusBulk',  '00010006001200020000', 'sp_dm2_UpdateRestoreStatusBulk', '00010006001200020000')
GO

