

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreStatus.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateRestoreStatus()
--  | Description:  Update the Restore Status
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateRestoreStatus.sp,v $ $Id: sp_dm2_UpdateRestoreStatus.sp,v 1.9.2.1 2017/02/07 23:49:06 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateRestoreStatus <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateRestoreStatus')
	drop procedure sp_dm2_UpdateRestoreStatus
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateRestoreStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreStatus'
GO
print '... Creating Procedure: sp_dm2_UpdateRestoreStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateRestoreStatus
  @i_RestoreJobID int = 0,
  @i_OldRestoreStatus int = -1,
  @i_RestoreStatus int = 0,
  @i_IsJM int = 0,
  @i_ResultSetID varchar(max) = '',
  @i_ID BIGINT = 0
AS
  -- this sp is NOT called by clRestore, only called by GUI
  -- get dm2 restore job status
  declare @dm2RestoreStatus int
  set @dm2RestoreStatus = @i_RestoreStatus
  if @i_IsJM > 0
  begin
	select @dm2RestoreStatus = (	case @i_RestoreStatus -- this is JM status
									when 1 then 1 -- RUNNING
									when 2 then 1 -- PENDING
									when 3 then 1 -- WAITING
									when 4 then 4 -- COMPLETED
									when 5 then 6 -- STOPPED
									when 6 then 7 -- KILLPENDING
									when 7 then 6 -- STOPPENDING
									when 8 then 6 -- INTERRUPTPENDING
									when 9 then 4 -- COMPLETEDSUCCESS
									when 10 then 5 -- COMPLETEDFAIL
									when 11 then 7 -- STATEKILLED
									when 12 then 4 -- COMPLETEDPARTIAL
									when 13 then 7 -- SYSTEMKILLPENDING
									when 14 then 1 -- DORMANT
									when 15 then 1 -- QUEUED
									when 16 then 1 -- DORMANTSCHEDWAIT
									when 17 then 1 -- RUNNING_UNVERIFIABLE
									when 18 then 1 -- DANGLINGJOBCLEANUP
									when 99 then 1 -- jobs unpicked by schedular
									else  0
								end)
-- DM2 RestoreStatus
--ANY = -1,
--Not_submitted = 0,
--Submitted_for_viewing = 1,
--Ready_to_be_viewed = 2,
--Submitted_for_Restore = 3,
--Restore_completed = 4,
--Failed = 5,
--Suspended = 6,
--Killed = 7
-- JM job status:
--	RUNNING = 1,
--	PENDING,
--	WAITING,
--	COMPLETED,
--	STOPPED,
--	KILLPENDING,
--	STOPPENDING,
--	INTERRUPTPENDING,
--	COMPLETEDSUCCESS,
--	COMPLETEDFAIL,
--	STATEKILLED,
--	COMPLETEDPARTIAL,
--	SYSTEMKILLPENDING, -- this is used when the job is to be automatically killed
--	DORMANT,
--	QUEUED,
--	DORMANTSCHEDWAIT,
--	RUNNING_UNVERIFIABLE,
--	DANGLINGJOBCLEANUP -- this is used when the j
  end
  if @i_ID > 0
  begin
	UPDATE DMResultSet
	SET RestoreStatus = 0, DestinationPath = ''
	WHERE ID = @i_ID
  end
  else if len(@i_ResultSetID) <= 0 and @i_RestoreJobID > 0
  begin
	  if @i_IsJM = 0
        BEGIN
                  ;WITH CTE AS
                  (
                        SELECT DISTINCT ResultSetID FROM DMResultSet WITH (NOLOCK)
                        WHERE RestoreJobID = @i_RestoreJobID
                              and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
                  )
			  update DMResultSet
			  set RestoreStatus = @dm2RestoreStatus
                    WHERE ResultSetID IN ( SELECT C.ResultSetID FROM CTE AS C )
                    --update DMResultSet
                    --set RestoreStatus = @dm2RestoreStatus
                    --where RestoreJobID = @i_RestoreJobID
                    --and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
        END
	  else
		  if @dm2RestoreStatus <> 4 and @dm2RestoreStatus >= 0
              BEGIN
                  ;WITH CTE AS
                  (
                        SELECT DISTINCT ResultSetID FROM DMResultSet WITH (NOLOCK)
                        WHERE RestoreJobID = @i_RestoreJobID
                              AND RestoreStatus NOT IN (4, @dm2RestoreStatus)
                              AND (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
                  )
			  update DMResultSet
			  set RestoreStatus = @dm2RestoreStatus
                  WHERE ResultSetID IN ( SELECT C.ResultSetID FROM CTE AS C )
                    --update DMResultSet
                    --set RestoreStatus = @dm2RestoreStatus
                    --where RestoreJobID = @i_RestoreJobID
                    --and RestoreStatus NOT IN (4, @dm2RestoreStatus)
                    --and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
              END
              ELSE
              BEGIN
                        ;WITH CTE AS
                        (
                              SELECT DISTINCT ResultSetID FROM DMResultSet WITH (NOLOCK)
                              WHERE RestoreJobID = @i_RestoreJobID
                                      and RestoreStatus NOT IN (4,5)
			  and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
                        )
			  update DMResultSet
			  set RestoreStatus = 5
                        WHERE ResultSetID IN ( SELECT C.ResultSetID FROM CTE AS C )
                    --update DMResultSet
                    --set RestoreStatus = 5
                    --where RestoreJobID = @i_RestoreJobID
                    --and RestoreStatus NOT IN (4,5)
                    --and (@i_OldRestoreStatus < 0 or RestoreStatus = @i_OldRestoreStatus)
              END
  end
  else
  begin
	IF ISNULL(@i_ResultSetID, '') <> ''
	begin
		--
		-- Earlier input use to come as a single string like this: '5f3db7e7-78de-4715-bd18-cab10adfda25'',''6da7759b-27f8-41a5-bc78-2386fa102cba'
		-- And here instead of split by separator technique, we were using EXEC and this could cause SQL injectoin
		-- Though identified places client code itself has been modified to pass comma separated list with out single quote inside it, to be safe side
		-- in attempt to avoid regression, replace any single quote with emtpy string and then split the values using split function and fetch data
		--
		--
		SET @i_ResultSetID = REPLACE(@i_ResultSetID, '''', '')
		--
		update DMResultSet
		set RestoreStatus = 0, DestinationPath = '', RestoreJobID = 0
		where ResultSetID in (SELECT Data from dbo.split(@i_ResultSetID, ','))
	end
  end
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateRestoreStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateRestoreStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateRestoreStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateRestoreStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateRestoreStatus',  '00010009000200010000', 'sp_dm2_UpdateRestoreStatus', '00010009000200010000')
GO

