

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateManifestPath.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateManifestPath.sp,v $ $Id: sp_dm2_UpdateManifestPath.sp,v 1.1.2.1 2017/12/29 23:50:26 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateManifestPath <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateManifestPath')
	drop procedure sp_dm2_UpdateManifestPath
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateManifestPath')
	delete from GxQscripts where name = 'sp_dm2_UpdateManifestPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateManifestPath')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateManifestPath'
GO
print '... Creating Procedure: sp_dm2_UpdateManifestPath'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateManifestPath
  @ResourceId nvarchar(255), 
  @IDList varchar(max), 
  @ManifestPath nvarchar(1024)
AS
BEGIN
	DECLARE @errMsg 		NVARCHAR(MAX)
	DECLARE @result 		INT
	DECLARE @errorCode		INT
	BEGIN TRY
		BEGIN TRAN
			--
			-- have common resource lock if client program did not supply one
			--
			IF ISNULL(@ResourceId, '') = ''
			BEGIN
				SET @ResourceId = 'sp_dm2_UpdateManifestPath'
			END
			--
			-- Use lock so that no two threads have dead lock (in case parallel execution happens)
			--
			EXEC @result = sp_getapplock @Resource = @ResourceId, @LockMode = 'Exclusive', @LockTimeout = 60000
			IF @result < 0
			BEGIN
                SET @errMsg = CASE @result
										when -1 then 'Explicit Raise Error: Applock request timed out.'
										when -2 then 'Applock request canceled.'
										when -3 then 'Explicit Raise Error: Applock involved in deadlock'
										else 'Parameter validation or other call error.'
									end
                RAISERROR (@errMsg,16,1)
				set @errorCode = 1001 -- validation error
			END
			--
			-- Update the requested records
			--
			UPDATE DR
			SET ManifestPath = @ManifestPath
			FROM DMDownloadResultSet DR
			JOIN dbo.splitIDs(@IDList) I ON DR.ID = I._ID
			--
			-- If we are here, we have updated records with out any problems
			--
			SELECT @errorCode = 0, @errMsg = ''
		--
		-- commit transaction from here
		--
		COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		if @@TRANCOUNT > 0
			ROLLBACK TRANSACTION
        SELECT @errMsg = ERROR_MESSAGE(),@errorCode = ERROR_NUMBER()
        RAISERROR(@errMsg, 15, 50)
	END CATCH
	SELECT @errorCode ErrorCode, @errMsg ErrorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateManifestPath')
	delete from GxQscripts where name = 'sp_dm2_UpdateManifestPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateManifestPath')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateManifestPath'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateManifestPath',  '00010001000200010000', 'sp_dm2_UpdateManifestPath', '00010001000200010000')
GO

