

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateFilesEntryIdBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateFilesEntryIdBulk()
--  | Description:  Update the File Entryid Mails in bulk
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateFilesEntryIdBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateFilesEntryIdBulk')
	drop procedure sp_dm2_UpdateFilesEntryIdBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateFilesEntryIdBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateFilesEntryIdBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateFilesEntryIdBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateFilesEntryIdBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateFilesEntryIdBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateFilesEntryIdBulk
  @restorejobid varchar(36),
  @i_xml_AFOffsets XML,
  @i_isUnixUpdate INTEGER = 0
AS
BEGIN
-- expects a list like
-- <restlist>
--    <file CCId="2" AFId="2" AFOff="27" DPath="/blabla" />
--    <file CCId="2" AFId="4" AFOff="37" />
--    <file CCId="2" AFId="6" AFOff="909" />
-- </restlist>
	declare @s_downLoadid varchar(36)
	DECLARE @lt_AFFiles TABLE (ID int IDENTITY(1,1) ,CCId int, AFId bigint, OrigPath nvarchar(max), DestPath nvarchar(max), status int,ResultItemID char(36))
	DECLARE @SettingVal VARCHAR(MAX) = ''
	DECLARE @CcnCheckEnabled BIT = 0
	select @s_downLoadId = DownLoadID from DMDownload where RestoreJobID = @restorejobid
	SELECT @SettingVal = SettingValue FROM DMSetting WHERE SettingName = 'ENABLE_CCN_CHECK_IN_RESTORE'
	IF ISNULL(@SettingVal, '') = 'True'
		SET @CcnCheckEnabled = 1
	INSERT INTO @lt_AFFiles (CCId,AFId,OrigPath,DestPath,status)
	SELECT T.c.value('@CCId','int'),
		   T.c.value('@AFId', 'bigint'),
		   T.c.value('@OPath', 'nvarchar(max)'),
		   T.c.value('@DPath', 'nvarchar(max)'),
		   ISNULL(T.c.value('@status', 'int'), 0) -- ERMStatus for success
	FROM   @i_xml_AFOffsets.nodes('/restlist/file') T(c)
	--update resultsetid in temptable
	IF( @i_isUnixUpdate = 1)
	BEGIN
		UPDATE @lt_AFFiles
		SET ResultItemID = ResultSetID
		FROM DMResultSet WITH(NOLOCK)
		WHERE aFileID = AFId AND OriginalFullPath COLLATE Latin1_General_CS_AS = OrigPath AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
	END
	ELSE
	BEGIN
		UPDATE @lt_AFFiles
		SET ResultItemID = ResultSetID
		FROM DMResultSet WITH(NOLOCK)
		WHERE aFileID = AFId AND OriginalFullPath = OrigPath AND (@CcnCheckEnabled = 0 OR (@CcnCheckEnabled = 1 AND CommCellNumber = CCId))
	END
	--Case when we couldn find any matching resultSet,  then we check this flag for Lotus nous
	IF EXISTS(SELECT * FROM @lt_AFFiles as tt WHERE LEN(ISNULL(tt.ResultItemID,'')) = 0)
	BEGIN
		/*
			Issue:
					if an email has multiple attachments during backup and few of them are filtered during CI,
				then the attachment number present in the path for each attachment within its documentID, mismatches and does not follow their sequence of number.
			Fix:
					During restore update, we try to convert the db path to match with original email which doesnt have attachment number,
				there by path would match the input index path.
		*/
		DECLARE @enableLNPartialCheck BIT =
				CASE WHEN ISNULL((SELECT SettingValue FROM DMSetting
							WHERE SettingName = 'ENABLE_LN_PATH_PARTIAL_MATCH'),'false') = 'true'	--default disabled
					THEN 1 ELSE 0 END
		IF(@enableLNPartialCheck = 1)
		BEGIN
			UPDATE tt
			SET tt.OrigPath = (CASE WHEN PATINDEX('%S:_:%',tt.OrigPath) = 0  THEN tt.OrigPath
								ELSE SUBSTRING(tt.OrigPath,1,(PATINDEX('%S:_:%',tt.OrigPath)))END)
			FROM @lt_AFFiles as tt
			WHERE LEN(ISNULL(tt.ResultItemID,'')) = 0
			--Since all mails and attachement have same path, delete duplicate
			DELETE FROM @lt_AFFiles
			WHERE ID NOT IN(
				SELECT MAX(ID)
				FROM @lt_AFFiles AS tt
				GROUP BY tt.AFId,tt.OrigPath
			)
			--For LN, compare origPath by stripping attachment.
			UPDATE tt
				SET ResultItemID = RS.ResultSetID
				FROM @lt_AFFiles as tt inner join  DMResultSet AS RS WITH(NOLOCK)
				ON tt.AFId = RS.aFileID  AND
					tt.OrigPath =
					(CASE WHEN PATINDEX('%S:_:%',RS.OriginalFullPath) = 0  THEN RS.OriginalFullPath
						ELSE SUBSTRING(RS.OriginalFullPath,1,(PATINDEX('%S:_:%',RS.OriginalFullPath)))END)
				WHERE LEN(ISNULL(tt.ResultItemID,'')) = 0 AND RS.AppType IN (52, 90)	--only FOR LN
		END
	END
	UPDATE DMDownloadResultSet
	SET FileName = tt.DestPath, Status = (CASE ISNULL(tt.DestPath,'') WHEN '' THEN dr.Status ELSE 100 END)
	FROM @lt_AFFiles tt INNER JOIN DMDownloadResultSet dr WITH (NOLOCK)
	ON	dr.DownloadID = @s_downLoadId and dr.ResultSetID = tt.ResultItemID
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateFilesEntryIdBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateFilesEntryIdBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateFilesEntryIdBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateFilesEntryIdBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateFilesEntryIdBulk',  '00000000000000000000', 'sp_dm2_UpdateFilesEntryIdBulk', '00000000000000000000')
GO

