

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateEntryIdBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_UpdateEntryIdBulk()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateEntryIdBulk.sp,v $ $Id: sp_dm2_UpdateEntryIdBulk.sp,v 1.4.192.1 2016/11/01 21:09:34 rkulkarni Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateEntryIdBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateEntryIdBulk')
	drop procedure sp_dm2_UpdateEntryIdBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateEntryIdBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateEntryIdBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateEntryIdBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateEntryIdBulk'
GO
print '... Creating Procedure: sp_dm2_UpdateEntryIdBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateEntryIdBulk
  @s_downLoadid varchar(36),
  @i_xml_AFOffsets XML
AS
BEGIN
-- expects a list like
-- <restlist>
--    <file CCId="2" AFId="2" AFOff="27" DPath="/blabla" />
--    <file CCId="2" AFId="4" AFOff="37" />
--    <file CCId="2" AFId="6" AFOff="909" />
-- </restlist>
	DECLARE @lt_AFOffsets TABLE (CCId int, AFId bigint, AFOff bigInt, DestPath nvarchar(max), status int, ResultItemID char(36))
	INSERT INTO @lt_AFOffsets (CCId, AFId, AFOff, DestPath, status)
	SELECT T.c.value('@CCId','int'),
		   T.c.value('@AFId', 'bigint'),
		   T.c.value('@AFOff', 'bigint'),
		   T.c.value('@DPath', 'nvarchar(max)'),
		   ISNULL(T.c.value('@status', 'int'), 0) -- ERMStatus for success
	FROM   @i_xml_AFOffsets.nodes('/restlist/file') T(c)
		UPDATE DMDownloadResultSet
		SET FileName = tt.DestPath, Status = (CASE ISNULL(tt.DestPath,'') WHEN '' THEN 500 ELSE 100 END)
	FROM @lt_AFOffsets tt, DMDownloadResultSet dr, DMResultSet rr WITH (NOLOCK)
		WHERE
		dr.DownloadID = @s_downLoadId and dr.ResultSetID = rr.ResultSetID and
		rr.aFileID = tt.AFId  and rr.aFileoffset = tt.AFOff
	--
	-- In case item was duplicate and was dropped as part of insertion to DMResultSet, then such items information
	-- can be found in DMItemsToSyncWithIndexing with SyncStatus = 4. So map the items by virtue of such data to
	-- minimize chances of afileId, afileOffset mismatch due to which status updates may fail.
	--
	UPDATE DR
	SET FileName = tt.DestPath, Status = (CASE ISNULL(tt.DestPath,'') WHEN '' THEN 500 ELSE 100 END)
	FROM @lt_AFOffsets tt
	JOIN DMItemsToSyncWithIndexing S WITH(NOLOCK) on tt.AFId = s.aFileID and tt.AFOff = s.aFileOffset and tt.CCId = s.CommCellNumber and SyncStatus = 4
	JOIN DMDownloadResultSet DR WITH(NOLOCK) ON S.ResultSetID = DR.ResultSetID
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateEntryIdBulk')
	delete from GxQscripts where name = 'sp_dm2_UpdateEntryIdBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateEntryIdBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateEntryIdBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateEntryIdBulk',  '00010004019200010000', 'sp_dm2_UpdateEntryIdBulk', '00010004019200010000')
GO

