

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_UpdateCompliancePolicyItemsStatus.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_UpdateCompliancePolicyItemsStatus.sp,v $ $Id: sp_dm2_UpdateCompliancePolicyItemsStatus.sp,v 1.4 2012/04/02 07:23:36 pbuilder Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_UpdateCompliancePolicyItemsStatus <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_UpdateCompliancePolicyItemsStatus')
	drop procedure sp_dm2_UpdateCompliancePolicyItemsStatus
IF EXISTS (select * from GxQscripts where name='sp_dm2_UpdateCompliancePolicyItemsStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateCompliancePolicyItemsStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateCompliancePolicyItemsStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateCompliancePolicyItemsStatus'
GO
print '... Creating Procedure: sp_dm2_UpdateCompliancePolicyItemsStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_UpdateCompliancePolicyItemsStatus
  @i_RetainOption INT,
  @i_UserGUID CHAR(36),
  @i_ContainerID CHAR(36),
  @i_OperationTypeFlags INT,
  @i_JobID INT
AS
	DECLARE	@ErrorCode				INT,
				@ErrorDesc				VARCHAR(2000),
				@CheckLegalHoldStatus	BIT,
				@CheckERMStatus			BIT,
				@AttributeToOR			INT
	-- Indicator constants for retain option
	DECLARE @RetainFailedItems INT
	SET @RetainFailedItems = 1
	DECLARE @RetainReviewSet INT
	SET @RetainReviewSet = 2
	-- Binary weight constants for operation type
	DECLARE @LHFlagConstant INT
	SET @LHFlagConstant = 2
	DECLARE @ERMFlagConstant INT
	SET @ERMFlagConstant = 4
        DECLARE @PreviousJobId INT
	BEGIN TRANSACTION
	SET NOCOUNT ON
	-- while checking backup status, we are interested only in immediate previous jobid..
	SELECT TOP 1 @PreviousJobId = JobID
	FROM DMLegalHoldItemsToBackup WHERE ContainerId = @i_ContainerID AND JobId < @i_JobID
	ORDER BY JOBID DESC
	-- Init..
	SELECT @ErrorCode = 0, @ErrorDesc = '', @CheckLegalHoldStatus = 0, @CheckERMStatus = 0
	-- Figure out what operation types are passed in..
	IF @i_OperationTypeFlags & @LHFlagConstant = @LHFlagConstant
	BEGIN
		SET @CheckLegalHoldStatus = 1   -- SET LH Flag.
	END
	IF @i_OperationTypeFlags & @ERMFlagConstant = @ERMFlagConstant
	BEGIN
		SET @CheckERMStatus = 1	-- SET ERM Flag.
	END
	IF NOT (@i_RetainOption = 1 OR @i_RetainOption = 2)
	BEGIN
		SELECT @ErrorCode = 1, @ErrorDesc = 'Invalid Option Specified as input.'
		GoTo ExitLine
	END
	SET NOCOUNT OFF
	CREATE TABLE #DMContainerItem ( ContainerID char(36), ResultSetID char(36), QueryID char(36) )
	IF @i_RetainOption = @RetainFailedItems
	BEGIN
		INSERT INTO	#DMContainerItem
		SELECT CI.ContainerID, CI.ResultSetID, CI.QueryID FROM DMContainerItem CI
		INNER JOIN DMResultSet RS ON CI.ResultSetId = RS.ResultSetId
		LEFT JOIN DMLegalHoldItemsToBackup LH ON CI.ResultSetId = LH.ResultSetId AND CI.ContainerId = LH.ContainerId AND LH.JobID = @PreviousJobId
		WHERE CI.ContainerID = @i_ContainerID
		AND (CI.Attribute & 64 = 64 OR CI.Attribute & 32 = 32)
		AND RS.RestoreStatus = 4
		AND ( (@CheckLegalHoldStatus = 1 AND LH.BackupStatus = 1) OR @CheckLegalHoldStatus = 0 )
		AND ( (@CheckERMStatus = 1 AND RS.ERMStatus = 8) OR @CheckERMStatus = 0 )
		UPDATE DMContainerItem
		SET Attribute = (Attribute | 4)
		FROM #DMContainerItem DM
		WHERE DMContainerItem.ContainerID = DM.ContainerID
		AND DMContainerItem.ResultSetID = DM.ResultSetID
		AND DMContainerItem.QueryID = DM.QueryID
	END
	ELSE IF @i_RetainOption = @RetainReviewSet
	BEGIN
		INSERT INTO	#DMContainerItem
		SELECT CI.ContainerID, CI.ResultSetID, CI.QueryID FROM DMContainerItem CI
		INNER JOIN DMResultSet RS ON CI.ResultSetId = RS.ResultSetId
		LEFT JOIN DMLegalHoldItemsToBackup LH ON CI.ResultSetId = LH.ResultSetId AND CI.ContainerId = LH.ContainerId AND LH.JobID = @PreviousJobId
		WHERE CI.ContainerID = @i_ContainerID
		AND CI.Attribute & 32 = 32
		AND RS.RestoreStatus = 4
		AND ( (@CheckLegalHoldStatus = 1 AND LH.BackupStatus = 1) OR @CheckLegalHoldStatus = 0 )
		AND ( (@CheckERMStatus = 1 AND RS.ERMStatus = 8) OR @CheckERMStatus = 0 )
		UPDATE DMContainerItem
		SET Attribute = (((Attribute | 64)) ^ 32)
		FROM #DMContainerItem DM
		WHERE DMContainerItem.ContainerID = DM.ContainerID
		AND DMContainerItem.ResultSetID = DM.ResultSetID
		AND DMContainerItem.QueryID = DM.QueryID
	END
	SET @ErrorCode = @@ERROR
ExitLine:
	IF @ErrorCode > 0 OR @ErrorDesc <> ''
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
	SELECT @ErrorCode AS ErrorCode, @ErrorDesc as ErrorString
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_UpdateCompliancePolicyItemsStatus')
	delete from GxQscripts where name = 'sp_dm2_UpdateCompliancePolicyItemsStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_UpdateCompliancePolicyItemsStatus')
	delete from GXDBVersions where aliasname = 'sp_dm2_UpdateCompliancePolicyItemsStatus'
GO

insert into GXDBVersions values(2, 'sp_dm2_UpdateCompliancePolicyItemsStatus',  '00010004000000000000', 'sp_dm2_UpdateCompliancePolicyItemsStatus', '00010004000000000000')
GO

