

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_SyncTurboResultSet.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_SyncTurboResultSet.sp,v $ $Id: sp_dm2_SyncTurboResultSet.sp,v 1.3 2012/05/24 23:42:33 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_SyncTurboResultSet <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_SyncTurboResultSet')
	drop procedure sp_dm2_SyncTurboResultSet
IF EXISTS (select * from GxQscripts where name='sp_dm2_SyncTurboResultSet')
	delete from GxQscripts where name = 'sp_dm2_SyncTurboResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncTurboResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncTurboResultSet'
GO
print '... Creating Procedure: sp_dm2_SyncTurboResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_SyncTurboResultSet
  @i_Items XML
AS
	BEGIN
		-- expects a list like
		-- <DM2ContentIndexing_GResultItems>
		--    <resultItem commcellNo="2" aFileId="2" aFileOffset="27" turboGuid="35097346298432698868347349" ResultItemID="298727549823535823672356" />
		-- </DM2ContentIndexing_GResultItems>
  DECLARE @lt_AFOffsets TABLE (CCId int, AFId bigint, AFOff bigInt, IndexGUID char(36), ResultItemID char(36))
  DECLARE @error int
  DECLARE @errorMessage varchar(max)
  DECLARE @count bigint
  DECLARE @debug bit
		SET NOCOUNT ON
			SET @errorMessage = 'Procedure executed successfully'
			SET @debug = 0
		INSERT INTO @lt_AFOffsets
		SELECT T.c.value('@commcellNo','int'), T.c.value('@aFileId', 'bigint'), T.c.value('@aFileOffset', 'bigint'),
		T.c.value('@turboGuid', 'char(36)'), T.c.value('@ResultItemID', 'char(36)')
		FROM @i_Items.nodes('//resultItem') T(c)
		SET @error = @@ERROR
		IF @error > 0
		BEGIN
			SET @errorMessage = 'Error when capturing XML data sent as input into temporary table.'
			GOTO exitHandler
		END
		BEGIN TRANSACTION
		UPDATE DMResultSet WITH(PAGLOCK)
		SET CommCellNumber = CCID, aFileID = AFId, aFileOffset = AFOff
		FROM @lt_AFOffsets T
		WHERE (ISNULL(T.IndexGUID, '') <> '' AND DMResultSet.IndexGUID = T.IndexGUID)
		OR (ISNULL(T.ResultItemID, '') <> '' AND T.ResultItemID = DMResultSet.ResultSetID)
		SELECT @error = @@ERROR, @count = @@rowcount
	IF @debug = 1
	BEGIN
		SELECT * FROM @lt_AFOffsets
	END
	PRINT 'Rows affected in DMResulset:'+convert(varchar(10), @count)
		IF @error > 0
		BEGIN
			SET @errorMessage = 'Error updating DMResultSet table.'
			GOTO errHandler
		END
	IF @error > 0
	BEGIN
		SET @errorMessage = 'Error updating DMResultSet table.'
		GOTO errHandler
	END
	UPDATE DMResultSetInfo WITH(PAGLOCK)
	SET ResultSet = dbo.fn_dm2_GetTurboResultSet(ResultSet, F.CCId, F.AFId, F.AFOff)
	FROM @lt_AFOffsets F
	JOIN DMResultSet R WITH (READUNCOMMITTED)
	ON (ISNULL(F.IndexGUID, '') <> '' AND F.IndexGUID = R.IndexGUID) OR (ISNULL(F.ResultItemID, '') <> '' AND F.ResultItemID = R.ResultSetID)
	WHERE DMResultSetInfo.ResultSetID = R.ResultSetID
	SELECT @error = @@ERROR, @count = @@rowcount
	PRINT 'Rows affected in DMResulsetInfo:'+convert(varchar(10), @count)
	IF @error > 0
	BEGIN
		SET @errorMessage = 'Error updating DMResultSetInfo table.'
	END
		errHandler:
		IF @error > 0
			ROLLBACK TRANSACTION
		ELSE
			COMMIT TRANSACTION
		exitHandler:
			PRINT @errorMessage
			SELECT @error AS ErrorCode, @errorMessage as ErrorMessage
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_SyncTurboResultSet')
	delete from GxQscripts where name = 'sp_dm2_SyncTurboResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncTurboResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncTurboResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_SyncTurboResultSet',  '00010003000000000000', 'sp_dm2_SyncTurboResultSet', '00010003000000000000')
GO

