

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_SyncResultSetOffset.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_SyncResultSetOffset()
--  | Description:  Update the Restore Mails in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_SyncResultSetOffset.sp,v $ $Id: sp_dm2_SyncResultSetOffset.sp,v 1.6 2012/11/15 16:04:32 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_SyncResultSetOffset <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_SyncResultSetOffset')
	drop procedure sp_dm2_SyncResultSetOffset
IF EXISTS (select * from GxQscripts where name='sp_dm2_SyncResultSetOffset')
	delete from GxQscripts where name = 'sp_dm2_SyncResultSetOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncResultSetOffset')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncResultSetOffset'
GO
print '... Creating Procedure: sp_dm2_SyncResultSetOffset'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_SyncResultSetOffset
  @ItemsToSync AS DMItemsToSyncWithIndexingTypeV2 READONLY 
AS
BEGIN
	DECLARE @error int
	DECLARE @errorMessage varchar(max)
	DECLARE @count bigint
	DECLARE @debug bit
	SET NOCOUNT ON
	SELECT @error = 0, @debug = 0, @errorMessage = 'Procedure executed successfully'
	IF NOT EXISTS (SELECT TOP 1 * FROM @ItemsToSync)
	GOTO exitHandler
	DECLARE @ItemsInDB DMItemsToSyncWithIndexingTypeV2
	INSERT INTO @ItemsInDB (ResultSetID, aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber)
	SELECT RI.ResultSetID, I.idxAFileID, I.idxAFileOffset, I.idxCommCellNumber, I.OriginalFullPath, I.IndexGUID, I.SyncStatus, I.idxAFileID, I.idxAFileOffset, I.idxCommCellNumber
	FROM @ItemsToSync I
	JOIN DMResultSet RI with (NOLOCK) ON RI.CommCellNumber = I.idxCommCellNumber AND RI.aFileID = I.idxAFileID AND RI.aFileOffset = I.idxAFileOffset
	INSERT INTO @ItemsInDB (ResultSetID, aFileID, aFileOffset, CommCellNumber, OriginalFullPath, IndexGUID, SyncStatus, idxAFileId, idxAFileOffset, idxCommCellNumber)
	SELECT R.ResultSetID, I.aFileID, I.aFileOffset, I.CommCellNumber, I.OriginalFullPath, I.IndexGUID, I.SyncStatus, I.idxAFileId, I.idxAFileOffset, I.idxCommCellNumber
	FROM @ItemsToSync I
	JOIN DMResultSet R with (NOLOCK) ON I.aFileID = R.aFileID AND I.aFileOffset = R.aFileOffset AND I.CommCellNumber = R.CommCellNumber
	WHERE NOT EXISTS (SELECT * FROM @ItemsInDB D WHERE D.aFileID = I.idxaFileID AND D.aFileOffset = I.idxaFileOffset AND D.CommCellNumber = I.idxCommCellNumber) -- DO not map already mapped items that matched against indexing lookedup data
	IF EXISTS (SELECT TOP 1 ResultSetID FROM @ItemsInDB)
	BEGIN
	BEGIN TRANSACTION
	UPDATE DMResultSet WITH(PAGLOCK)
	SET CommCellNumber = I.idxCommCellNumber, aFileID = I.idxAFileID, aFileOffset = I.idxAFileOffset,
	OriginalFullPath = (CASE WHEN ISNULL(I.OriginalFullPath, '') = '' THEN DMResultSet.OriginalFullPath ELSE I.OriginalFullPath END) --update OriginalFullPath due to bug in indexing system that prepends backslash in case of synth full turbo.
	FROM @ItemsInDB I
	WHERE I.ResultSetID = DMResultSet.ResultSetID
	SELECT @error = @@ERROR, @count = @@rowcount
	PRINT 'Rows affected in DMResulset:'+convert(varchar(10), @count)
	IF @error > 0
	BEGIN
		SET @errorMessage = 'Error updating DMResultSet table.'
		GOTO errHandler
	END
	UPDATE DMResultSetInfo WITH(PAGLOCK)
	SET ResultSet = dbo.fn_dm2_GetTurboResultSet(ResultSet, I.idxCommCellNumber, I.idxAFileID, I.idxAFileOffset)
	FROM @ItemsInDB I
	WHERE I.ResultSetID = DMResultSetInfo.ResultSetID
	SELECT @error = @@ERROR, @count = @@rowcount
	PRINT 'Rows affected in DMResulsetInfo:'+convert(varchar(10), @count)
	IF @error > 0
	BEGIN
		SET @errorMessage = 'Error updating DMResultSetInfo table.'
	END
errHandler:
	IF @error > 0
		ROLLBACK TRANSACTION
	ELSE
		COMMIT TRANSACTION
	END
exitHandler:
		PRINT @errorMessage
		SELECT @error AS ErrorCode, @errorMessage as ErrorMessage
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_SyncResultSetOffset')
	delete from GxQscripts where name = 'sp_dm2_SyncResultSetOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncResultSetOffset')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncResultSetOffset'
GO

insert into GXDBVersions values(2, 'sp_dm2_SyncResultSetOffset',  '00010006000000000000', 'sp_dm2_SyncResultSetOffset', '00010006000000000000')
GO

