

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_SyncItemTagsWithCIServerBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_SyncItemTagsWithCIServerBulk.sp,v $ $Id: sp_dm2_SyncItemTagsWithCIServerBulk.sp,v 1.5 2010/05/13 17:21:42 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_SyncItemTagsWithCIServerBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_SyncItemTagsWithCIServerBulk')
	drop procedure sp_dm2_SyncItemTagsWithCIServerBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_SyncItemTagsWithCIServerBulk')
	delete from GxQscripts where name = 'sp_dm2_SyncItemTagsWithCIServerBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncItemTagsWithCIServerBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncItemTagsWithCIServerBulk'
GO
print '... Creating Procedure: sp_dm2_SyncItemTagsWithCIServerBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_SyncItemTagsWithCIServerBulk
  @i_ContainerID varchar(36),
  @i_UserID varchar(36),
  @i_SelALLFlag INTEGER,
  @i_DataFilePath varchar(1024),
  @i_ForceSync INTEGER
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
	DECLARE @errorCode integer
	declare @l_delimiter	varchar(256)
	declare @SQL					varchar(2048)
	declare	@uniqueId 		varchar(36)
	set @l_delimiter = ISNULL((select SettingValue from DMSetting WITH (READUNCOMMITTED) where settingName = 'DMBulkInsert_Delim'), '')
	IF(len(@l_delimiter ) = 0)
		SET @l_delimiter = 'CV0X12'
	IF object_id('tempdb.dbo.#tmpDMResultSet') is not null
	DROP TABLE #tmpDMResultSet
	IF object_id('tempdb.dbo.#tmpDMResultSetTags') is not null
	DROP TABLE #tmpDMResultSetTags
	create table #tmpDMResultSet
	(
		[ResultSetID] [char](36) NOT null
	)
	create table #tmpDMResultSetTags
	(
		[ResultSetID] [char](36) NOT null,
		[UserGUID]		[char](36) NOT null,
		[TagGUID]			[char](36) null,
		[Attribute]		int
	)
	IF (@i_SelALLFlag = 0)
	BEGIN
		SET @SQL = 'BULK INSERT #tmpDMResultSet FROM '''+@i_DataFilePath+''' WITH (FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
		exec (@SQL)
	END
	ELSE
	BEGIN
		INSERT INTO #tmpDMResultSet
		SELECT DISTINCT ResultSetID
		FROM DMContainerItem CI
		WHERE CI.ContainerID = @i_ContainerID
		AND		CI.Attribute & 4 = 0
	END
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tmpDMResultSetTags
	SELECT DISTINCT TT.ResultSetId, @i_UserID, CIT.TagID, CIT.Attribute
	FROM #tmpDMResultSet TT, DMContainerItemStates as CIS WITH (READUNCOMMITTED), DMContainerItemTags CIT WITH (READUNCOMMITTED)
	WHERE CIS.ContainerId = @i_ContainerId
	AND 	CIS.ResultSetId = TT.ResultSetId
	AND		CIS.AssignedUserGUID = @i_UserID
	AND		CIS.AssignID = CIT.AssignID
	AND		((@i_ForceSync = 1) OR (CIT.Attribute & (2 + 8)) = 0)		-- NOT SYNCed, Not Submitted For Sync
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- DO NOT send the items without documentID for Tagging since those items will never get tags in CIServer
	DELETE #tmpDMResultSetTags
	FROM 	#tmpDMResultSetTags AS tt, DMResultSet AS RS WITH (NOLOCK)
	WHERE tt.ResultSetID = RS.ResultSetID
	AND		(RS.documentID IS NULL OR LEN(RS.documentID) = 0)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update the DELETE flag if there is new request to ADD tag again
	UPDATE DMUserItemTags
	SET 	Attribute = tt.Attribute
	FROM 	DMUserItemTags as UIT WITH (READUNCOMMITTED), #tmpDMResultSetTags as tt
	WHERE UIT.ResultSetId = tt.ResultSetId
	AND		UIT.UserGUID = tt.UserGUID
	AND		UIT.TagID = tt.TagGUID
	AND		UIT.Attribute & 4 = 4
	AND		tt.Attribute & 4 = 0
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT INTO #tmpDMResultSetTags
	SELECT DISTINCT UIT.ResultSetId, @i_UserID, UIT.TagID, UIT.Attribute
	FROM #tmpDMResultSet TT, DMUserItemTags UIT
	WHERE UIT.ResultSetId = TT.ResultSetId
	AND		UIT.UserGUID = @i_UserID
	AND		((@i_ForceSync = 1) OR (UIT.Attribute & (2 + 8)) = 0)	-- NOT SYNCed, Not Submitted For Sync
	AND		NOT EXISTS (SELECT TOP 1 * FROM #tmpDMResultSetTags AS TAG
										WHERE UIT.ResultSetId = TAG.ResultSetId
										AND		UIT.UserGUID = TAG.UserGUID
										AND		UIT.TagID = TAG.TagGUID)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- DO NOT send the items without documentID for Tagging since those items will never get tags in CIServer
	DELETE #tmpDMResultSetTags
	FROM 	#tmpDMResultSetTags AS tt, DMResultSet AS RS WITH (NOLOCK)
	WHERE tt.ResultSetID = RS.ResultSetID
	AND		(RS.documentID IS NULL OR LEN(RS.documentID) = 0)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	CREATE INDEX IDX_tmpDMResultSetTags_CIT ON #tmpDMResultSetTags(TagGUID, ResultSetID, UserGUID)
	SELECT @uniqueId = NEWID()
	INSERT INTO DMItemsToSyncWithCIServer
	SELECT DISTINCT @uniqueId, ResultSetID, UserGUID, TagGUID, Attribute, 0, 0
	FROM 	#tmpDMResultSetTags
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	DROP TABLE #tmpDMResultSet
	DROP TABLE #tmpDMResultSetTags
	SELECT	0 AS ErrorCode, @uniqueId AS UniqueID
	RETURN
CX_ERROR_EXIT:
	DROP TABLE #tmpDMResultSet
	DROP TABLE #tmpDMResultSetTags
	SELECT	-1 AS ErrorCode, '' AS UniqueID
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_SyncItemTagsWithCIServerBulk')
	delete from GxQscripts where name = 'sp_dm2_SyncItemTagsWithCIServerBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_SyncItemTagsWithCIServerBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_SyncItemTagsWithCIServerBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_SyncItemTagsWithCIServerBulk',  '00010005000000000000', 'sp_dm2_SyncItemTagsWithCIServerBulk', '00010005000000000000')
GO

