

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_RestoreLHRSItemsWithAFIdAndOffset.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_RestoreLHRSItemsWithAFIdAndOffset()
--  | Description:  Restore LegalHold Items
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_RestoreLHRSItemsWithAFIdAndOffset.sp,v $ $Id: sp_dm2_RestoreLHRSItemsWithAFIdAndOffset.sp,v 1.25.12.5 2019/04/16 16:21:29 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_RestoreLHRSItemsWithAFIdAndOffset <<<'
	drop procedure sp_dm2_RestoreLHRSItemsWithAFIdAndOffset
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
	delete from GxQscripts where name = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
	delete from GXDBVersions where aliasname = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO
print '... Creating Procedure: sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_RestoreLHRSItemsWithAFIdAndOffset
  @i_ContainerID VARCHAR(36),
  @i_restoreJobId INTEGER,
  @i_restoreCCNumber INTEGER,
  @i_backupCCNumber INTEGER,
  @i_archFileId BIGINT,
  @i_archFileOffset BIGINT,
  @i_destPath NVARCHAR(max),
  @i_metaDataXML NVARCHAR(max),
  @i_DownloadID CHAR(36) = '',
  @i_UserGUID VARCHAR(36) = ''
AS
	SET NOCOUNT ON
	BEGIN TRANSACTION LHRESTOREITEM
	DECLARE @Mark_Legal_Restored_Item INT = 16
	DECLARE @inputXML XML
	SET			@inputXML = CONVERT(XML, @i_metaDataXML, 1)
	DECLARE @errorCode	INTEGER
	SET			@errorCode	= 0
	DECLARE @restoreStatus	INTEGER
	SET	  	@restoreStatus	= 0
        DECLARE @auditInputXML NVARCHAR(MAX)
	SET @auditInputXML = ''
	IF @i_ContainerID IS NULL OR LEN(@i_ContainerID) = 0
	BEGIN
		SET	@errorCode	=	-1
		GOTO CX_EXIT
	END
	DECLARE @count INTEGER
	SELECT @count = COUNT(*) FROM @inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
	--Translate old LegalHold MetaDataXML to 9.0 format
	IF @count = 0
	BEGIN
		--SET @inputxml = CAST(dbo.ConvertLegalHoldMetaDataXMLTo900XMLManaged(@i_metaDataXML) AS XML)
		RAISERROR('The format of meta-data in legal hold backup is not supported for restore. Contact your vendor support', 16, 1)
	END
	IF @i_UserGUID IS NULL OR LEN(@i_UserGUID) = 0
	BEGIN
		SET	@errorCode	=	-1
		GOTO CX_EXIT
	END
	IF (@i_destPath IS null)
		SET @i_destPath = ''
	IF (LEN(@i_destPath) = 0)
		SET	  @restoreStatus	= 5 -- Failed
	ELSE
		SET	  @restoreStatus	= 4 -- For Success
	DECLARE @tblResultSet TABLE
	(
		filePath							NVARCHAR(max),
		fileName							NVARCHAR(1024),
		folderPath						NVARCHAR(max),
		appType								INTEGER,
		appId									INTEGER,
		commcellNo						INTEGER,
		clientId							INTEGER,
		pushError							NVARCHAR(max),
		sizeKB								FLOAT,
		MIMEType							NVARCHAR(256),
		modifiedTime					BIGINT,
		jobId									INTEGER,
		contentIndexingJobId	INTEGER,
		backupTime						BIGINT,
		aFileId								INTEGER,
		aFileOffset						BIGINT,
		aFileLength						BIGINT,
		dynTeaser							NVARCHAR(max),
		rank									FLOAT,
		ownerField						NVARCHAR(MAX),
		lnks							NVARCHAR(MAX)
	)
	DECLARE @tblUserComments TABLE
	(
		UserGUID					VARCHAR(36),
		CreationDateTime	VARCHAR(25),
		ModifiedDateTime	VARCHAR(25),
		Comments					NVARCHAR(max)
	)
	DECLARE @tblAssignedUser TABLE
	(
		AssignId					INTEGER,
		StateID						VARCHAR(36),
		UserNotes					NVARCHAR(max),
		UserGUID					VARCHAR(36),
		ReviewSetTags			XML,
		CITags						XML
	)
	DECLARE @tblUserTags TABLE
	(
		AssignId					INTEGER,
		UserGUID					VARCHAR(36),
		TagId							VARCHAR(36)
	)
	DECLARE @ResultSetID VARCHAR(36)
	SET			@ResultSetID = ''
	DECLARE @ResultSetXMLStr NVARCHAR(MAX)
	SET			@ResultSetXMLStr = ''
	DECLARE @ResultSetXML XML
	DECLARE @NewDocumentID 	VARCHAR(256)
	SET 		@NewDocumentID 	= ''
	DECLARE @NewTurboGUID 	VARCHAR(256) = '' -- The day @NewDocumentID and @NewTurboGUID becomes additional inputs, we can update them when updating DMResultSet table
	DECLARE	@OrigResultSetID			NVARCHAR(36)
	DECLARE @ownerField NVARCHAR(MAX) = N''
	INSERT	INTO @tblResultSet
	SELECT	T.item.value('@filePath', 'NVARCHAR(max)'),
			T.item.value('@fileName', 'NVARCHAR(1024)'),
			T.item.value('@folderPath', 'NVARCHAR(max)'),
			T.item.value('@appType', 'INTEGER'),
			T.item.value('@appId', 'INTEGER'),
			T.item.value('@commcellNo', 'INTEGER'),
			T.item.value('@clientId', 'INTEGER'),
			T.item.value('@pushError', 'NVARCHAR(max)'),
			T.item.value('@sizeKB', 'FLOAT'),
			T.item.value('@MIMEType', 'NVARCHAR(256)'),
			T.item.value('@modifiedTime', 'BIGINT'),
			T.item.value('@jobId', 'INTEGER'),
			T.item.value('@contentIndexingJobId', 'INTEGER'),
			T.item.value('@backupTime', 'BIGINT'),
			T.item.value('@aFileId', 'INTEGER'),
			T.item.value('@aFileOffset', 'BIGINT'),
			ISNULL(T.item.value('@aFileLength', 'BIGINT'), 0),
			T.item.value('@dynTeaser', 'NVARCHAR(max)'),
			T.item.value('@rank', 'FLOAT'),
			T.item.value('./appSpecific[1]/eMail[1]/@from','NVARCHAR(max)'),
			T.item.value('./appSpecific[1]/eMail[1]/@links','NVARCHAR(max)')
	FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @tblResultSet
	SET filePath = CASE WHEN filePath IS null THEN
							N''
						ELSE filePath END
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT	@OrigResultSetID = T.item.value('@ResultItemID', 'NVARCHAR(36)')
	FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
  SET @ResultSetID = (	SELECT	TOP 1 ResultSetID
					FROM	DMResultSet	  WITH (READUNCOMMITTED)
					WHERE	CommCellNumber = @i_backupCCNumber
					AND		aFileID = @i_archFileId
					AND		aFileOffset = @i_archFileOffset
					)
	DECLARE @ResultSetInfoId bigint
	DECLARE @IsNewResultSet BIT
	SELECT @IsNewResultSet = CASE WHEN @ResultSetID IS NULL THEN 1 ELSE 0 END
	SELECT @ResultSetInfoId = ID FROM DMResultSetInfo WHERE ResultSetID = @ResultSetID
	IF @IsNewResultSet = 1 OR @ResultSetInfoId IS NULL
	BEGIN
		--PopulateOwnerField only if required
		IF EXISTS (SELECT * FROM DMUIAppTypeMap
					WHERE AppTypeId = (SELECT TOP 1 appType FROM @tblResultSet)
						AND IsEmailAppType = 1)
		BEGIN
			DECLARE @getOwnerAsMailBoxOwner NVARCHAR(10) = 'False',
					@lnks NVARCHAR(MAX) = '',
					@fromField NVARCHAR(MAX) = '',
					@filePath NVARCHAR(MAX) = ''
			SELECT @getOwnerAsMailBoxOwner = SettingValue
			FROM DMSetting WHERE SettingName = 'POPULATE_OWNERFIELD_AS_MAILBOXOWNER'
			SELECT @lnks = T.lnks,@fromField = T.ownerField, @filePath = T.filePath
			FROM @tblResultSet AS T
			--the CLR function depends on XML layer which is expensive and requires additional options to be enabled on SQL Server which is causing concerns
			--from reliability and scalability standpoint.
			--its a minor issue if we cannot populate owner in DB as we use this for display purposes in success/failed items view of export operations alone.
			SELECT @ownerField = '' --dbo.GetOwnerFieldManaged(@fromField,@lnks,@filePath,@getOwnerAsMailBoxOwner)
		END
		--not needed as we are not populating anymore
		--SELECT @ownerField = LOWER(ISNULL(@ownerField,N''))
		IF @IsNewResultSet = 1
		BEGIN
			SET @ResultSetID = NEWID()
			INSERT INTO DMResultSet
				(ResultSetID,CommCellNumber,aFileID,aFileOffset,aFileLength,
				AppType,FileSizeKB,ModifiedTime,JobId,OriginalFullPath,
				DestinationPath,CreateTime,RestoreUserGUID,RestoreCommCellNumber,RestoreJobID,
				RestoreStatus,RestoreTime,Attribute,
				documentID,ClientID,ERMStatus,
				Title,IndexGUID)
			SELECT
				@ResultSetID, @i_backupCCNumber, @i_archFileId, @i_archFileOffset, aFileLength,
				appType, sizeKB, dbo.GetDateTime(modifiedTime), jobId, filePath,
				@i_destPath, getDate(), @i_UserGUID, 0,@i_restoreJobId,
				@restoreStatus, getDate(), @Mark_Legal_Restored_Item,
				@NewDocumentID, clientId,0,
				fileName,@NewTurboGUID
			FROM	@tblResultSet
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
		IF @ResultSetInfoId IS NULL
		BEGIN
			INSERT INTO DMResultSetInfo
			SELECT	@ResultSetID, ''
			FROM	@tblResultSet
			SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		END
		--Translate to DM2ContentIndexing_GResultItem Root tag
		SELECT @ResultSetXML = CAST(dbo.fn_dm2_GetLatestResultSetXML(@ResultSetID, CAST(@inputxml.query('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') AS NVARCHAR(max))) AS XML)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		IF @ResultSetXML.exist('//DM2ContentIndexing_GResultItem[@ResultItemID]') = 0
			SET @ResultSetXML.modify('insert attribute ResultItemID {sql:variable("@ResultSetID")} into (/DM2ContentIndexing_GResultItem)[1]')
		ELSE
			SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@ResultItemID)[1] with sql:variable("@ResultSetID")')
		SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@commcellNo)[1] with sql:variable("@i_backupCCNumber")')
		SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@aFileId)[1] with sql:variable("@i_archFileId")')
		SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@aFileOffset)[1] with sql:variable("@i_archFileOffset")')
		IF @ResultSetXML.exist('//DM2ContentIndexing_GResultItem[@documentId]') = 0
			SET @ResultSetXML.modify('insert attribute documentId {sql:variable("@NewDocumentID")} into (/DM2ContentIndexing_GResultItem)[1]')
		ELSE
			SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@documentId)[1] with sql:variable("@NewDocumentID")')
		-- The meta-data XML is of the source item. So we replace / nullify documentid & turboguid
		IF @ResultSetXML.exist('//DM2ContentIndexing_GResultItem[@turboGuid]') = 0
			SET @ResultSetXML.modify('insert attribute turboGuid {sql:variable("@NewTurboGUID")} into (/DM2ContentIndexing_GResultItem)[1]')
		ELSE
			SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@turboGuid)[1] with sql:variable("@NewTurboGUID")')
		--check whether the ownerField is populated in the GResultItem
		--if not insert new attribute
		IF(@ResultSetXML.exist('//DM2ContentIndexing_GResultItem/appSpecific/eMail/@owner')  = 0)
			SET @ResultSetXML.modify('insert attribute owner {sql:variable("@ownerField")}
			into (/DM2ContentIndexing_GResultItem/appSpecific/eMail)[1]')
		ELSE
			SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/appSpecific/eMail/@owner)[1]
			with sql:variable("@ownerField") ')
		SELECT @ResultSetXMLStr = CAST(@ResultSetXML AS NVARCHAR(MAX))
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE DMResultSetInfo
		SET ResultSet = @ResultSetXMLStr
		WHERE ResultSetID = @ResultSetID
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	IF @IsNewResultSet = 0
	BEGIN
	    --Update the existing row with the new restorePath and restore Status
		UPDATE DMResultSet
		SET DestinationPath = @i_destPath,
			RestoreUserGUID = @i_UserGUID,
			RestoreJobId = @i_restoreJobId,
			RestoreStatus = @restoreStatus,
			RestoreTime = getDate(),
			Attribute = 16
			-- Unset all other attributes as well
		WHERE ResultSetID = @ResultSetID
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	IF EXISTS (SELECT * FROM DMUIAppTypeMap
					WHERE AppTypeId = (SELECT TOP 1 appType FROM @tblResultSet)
						AND IsEmailAppType = 1)
	BEGIN
		DECLARE @ResultSetTable AS ResultSetType
		INSERT INTO @ResultSetTable
		SELECT ResultSetID, CAST(ResultSet AS XML)
		FROM DMResultSetInfo
		WHERE ResultSetID = @ResultSetID
		IF EXISTS (SELECT TOP 1 * FROM @ResultSetTable)
		BEGIN
			CREATE TABLE #tmpDMEmailFields
			(
				resultSetID VARCHAR(36),
				subjectField NVARCHAR(MAX),
				toField NVARCHAR(MAX),
				fromField NVARCHAR(MAX),
				bccField NVARCHAR(MAX),
				ccField NVARCHAR(MAX)
			);
			INSERT INTO #tmpDMEmailFields
			SELECT T.ResultSetId,T.subjectField,T.toField,T.fromField,T.bccField,T.ccField
			FROM dbo.fn_dm2_GetValuesForEmailFields(@ResultSetTable) AS T
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			UPDATE DMEmailResult
			SET EmailSubject = TR.subjectField, EmailFROM = TR.fromField, EmailTO = TR.toField, EmailCC = TR.ccField, EmailBCC = TR.bccField,
			SavedTime = GETUTCDATE()
			FROM #tmpDMEmailFields TR
			WHERE DMEmailResult.ResultSetID = TR.ResultSetID
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			INSERT INTO DMEmailResult (ResultSetID,EmailSubject,EmailFROM,EmailTO,EmailCC,EmailBCC,SavedTime)
			SELECT TR.ResultSetID, TR.subjectField, TR.fromField, TR.toField, TR.ccField, TR.bccField, GETUTCDATE() FROM #tmpDMEmailFields TR
			WHERE NOT EXISTS (SELECT ResultSetID FROM DMEmailResult E WHERE E.ResultSetID = TR.ResultSetID)
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
	END
	IF NOT (@i_DownloadID IS null OR LTRIM(RTRIM(@i_DownloadID)) = '')
	BEGIN
		INSERT INTO DMDownloadResultSet (DownloadID, ResultSetID, AppType, Status, CreateTime,FileName)
		SELECT @i_DownloadID as DownloadID, @ResultSetID as ResultSetID,
		AppType, (CASE WHEN ISNULL(@i_destPath,'') = '' THEN 0 ELSE 100 END) as Status, GetDate() as CreateTime,@i_destPath as FileName
		FROM DMResultSet
		WHERE ResultSetID = @ResultSetID
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	IF NOT EXISTS (	SELECT *
					FROM	DMContainerItem		WITH (READUNCOMMITTED)
					WHERE	ContainerID = @i_ContainerID
					AND		ResultSetID = @ResultSetID)
	BEGIN
		INSERT INTO DMContainerItem
		values(@i_ContainerID, '', @ResultSetID, getUTCDate(), 0, @i_UserGUID)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO @tblUserComments
		SELECT	ISNULL(T.item.value('userInfo[1]/@userGuid', 'VARCHAR(36)'), ''),
						ISNULL(T.item.value('userComment[1]/@creationDateTime', 'VARCHAR(25)'), ''),
						ISNULL(T.item.value('userComment[1]/@modifiedDateTime', 'VARCHAR(25)'), ''),
						ISNULL(T.item.value('userComment[1]/@comments', 'NVARCHAR(MAX)'), '')
		FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/userCommentInformation/userCommentInfo') T(item)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		IF EXISTS (SELECT UserGUID FROM @tblUserComments WHERE Comments IS NOT NULL)
		INSERT	INTO DMUserComment
		SELECT NEWID(), UserGUID, '', @i_ContainerID, @ResultSetID, NULL, Comments, CONVERT(DATETIME, CreationDateTime), 0, CONVERT(DATETIME, ModifiedDateTime)
		FROM @tblUserComments
		WHERE Comments IS NOT NULL
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-------------------Audit add items to reviewSet.-------------------
		--
		--construct the reuseRequestId,So that for a particular job only once the EventId will be created...
		--
		DECLARE  @reuseRequestId VARCHAR(100)
		SELECT @reuseRequestId = 'ReuseId_JobId_'+ CONVERT(VARCHAR(16),@i_restoreJobId) + '_LegalHoldRestore'
		--ParamList can contain only mandatory fields
		--ItemSource and the Destination containerGuid
		SET @auditInputXML =
			(
				SELECT @i_ContainerID '@containerGuid', 1 '@type', @i_UserGUID '@userGuid',@reuseRequestId '@reuseRequestId',
					(SELECT 'LegalHold_Restore' '@paramValue',11 '@paramName' FOR XML PATH('paramList'), TYPE),
					(SELECT @i_ContainerID '@paramValue',3 '@paramName' FOR XML PATH('paramList'), TYPE),
					@ResultSetID 'resultSetIds/@val'
				FOR XML PATH('DM2ContentIndexing_EventOperation')
			)
	END
	ELSE
	BEGIN
		UPDATE DMContainerItem
		SET Attribute = Attribute & ~4
		WHERE ContainerID = @i_ContainerID
		AND ResultSetID = @ResultSetID
		AND	Attribute & 4 = 4
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE DMUserComment
		SET Attribute = Attribute & ~4
		WHERE ContainerID = @i_ContainerID
		AND ResultSetID = @ResultSetID
		AND	Attribute & 4 = 4
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	--Get Assigned User Info
	INSERT INTO @tblAssignedUser
	SELECT	ISNULL(T.item.value('@assignID', 'INTEGER'), ''),
			ISNULL(T.item.value('docState[1]/@stateID', 'VARCHAR(36)'), ''),
			T.item.value('docState[1]/@stateDescription', 'NVARCHAR(max)'),
			ISNULL(T.item.value('userInformation[1]/@userGuid', 'VARCHAR(36)'), ''),
			T.item.query('./ReviewSetTags'),
			T.item.query('./CITags')
	FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/assignedUserInfo/assignedUser') T(item)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO @tblUserTags
	SELECT	0, UserGUID, T.c.value('@id', 'VARCHAR(36)')
	FROM	@tblAssignedUser CROSS APPLY CITags.nodes('/CITags') T(c)
	UNION
	SELECT	0, UserGUID, T.c.value('@id', 'VARCHAR(36)')
	FROM	@tblAssignedUser CROSS APPLY ReviewSetTags.nodes('/ReviewSetTags') T(c)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the deleted flag if the entry already exists
	UPDATE DMContainerItemStates
	SET Attribute = Attribute & ~4
	FROM @tblAssignedUser AS TT, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
	WHERE CIS.ContainerId = @i_ContainerId
	AND 	CIS.ResultSetId = @ResultSetID
	AND		CIS.AssignedUserGUID = TT.UserGUID
	AND		CIS.Attribute & 4 = 4
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Insert entries if not exists
	INSERT INTO DMContainerItemStates
	SELECT @i_ContainerID, @ResultSetID, TT.UserGUID, TT.StateID, getUTCDate(), @i_UserGUID, TT.UserNotes, 0
	FROM @tblAssignedUser AS TT
	WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemStates AS CIS WITH (READUNCOMMITTED)
							WHERE CIS.ContainerId = @i_ContainerId
							AND 	CIS.ResultSetId = @ResultSetID
							AND		CIS.AssignedUserGUID = TT.UserGUID)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE @tblUserTags
	SET assignID = CIS.assignID
	FROM @tblUserTags TT, DMContainerItemStates CIS WITH (NOLOCK)
	WHERE CIS.ContainerId = @i_ContainerId
	AND 	CIS.ResultSetId = @ResultSetID
	AND		CIS.AssignedUserGUID = TT.UserGUID
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the deleted flag if the entry already exists
	UPDATE DMContainerItemTags
	SET 	Attribute = Attribute & ~4
	FROM 	DMContainerItemTags CIT, @tblUserTags AS TT
	WHERE CIT.assignID = TT.assignID
	AND		CIT.TagID = TT.TagID
	AND		CIT.Attribute & 4 = 4
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the deleted flag if the entry already exists
	UPDATE DMUserItemTags
	SET 	Attribute = Attribute & ~4
	FROM 	DMUserItemTags UIT, @tblUserTags AS TT
	WHERE UIT.UserGUID = TT.UserGUID
	AND		UIT.ResultSetID = @ResultSetID
	AND		UIT.TagID = TT.TagID
	AND		UIT.Attribute & 4 = 4
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Create entries if not exists
	INSERT INTO DMContainerItemTags
	SELECT TT.AssignID, TT.TagID, getUTCDate(), @i_UserGUID, '', 0
	FROM	@tblUserTags AS TT
	WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemTags AS CIT WITH (NOLOCK)
							WHERE CIT.AssignID = TT.AssignID
							AND		CIT.TagID = TT.TagID)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Remove all DB Tags if User Tags already exists
	DELETE DMContainerItemTags
	FROM 	DMContainerItemTags AS CIT, DMContainerItemStates AS CIS WITH (NOLOCK), DMUserItemTags UIT WITH (NOLOCK), @tblUserTags AS TT
	WHERE CIS.ResultSetId = UIT.ResultSetId
	AND		CIS.AssignedUserGUID = UIT.UserGUID
	AND		CIS.AssignID = CIT.AssignID
	AND		CIT.TagID = UIT.TagID
	AND		UIT.ResultSetId = @ResultSetID
	AND		UIT.UserGUID = TT.UserGUID
	AND		UIT.TagID = TT.TagID
	AND		UIT.Attribute & 4 = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF @errorCode = 0
		COMMIT TRANSACTION LHRESTOREITEM
	ELSE
		ROLLBACK TRANSACTION LHRESTOREITEM
	--if the errorCode = 0 and @auditInputXML is not empty
	--call audit stored procedure...
	--this is called after the transaction because, Nested transaction was involved.
	--which ended up is Mismatch transaction count
	IF(@errorCode = 0 AND @auditInputXML IS NOT NULL AND LEN(@auditInputXML) > 0)
	BEGIN
		EXECUTE sp_dm2_AuditOperation @auditInputXML,1
	END
	IF OBJECT_ID('#tmpDMEmailFields') IS NOT null
	DROP TABLE #tmpDMEmailFields
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
	delete from GxQscripts where name = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_RestoreLHRSItemsWithAFIdAndOffset')
	delete from GXDBVersions where aliasname = 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset'
GO

insert into GXDBVersions values(2, 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset',  '00010025001200050000', 'sp_dm2_RestoreLHRSItemsWithAFIdAndOffset', '00010025001200050000')
GO

