

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneUserSession.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneUserSession()
--  | Description:  Prune User Session
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneUserSession.sp,v $ $Id: sp_dm2_PruneUserSession.sp,v 1.4.84.2 2018/09/16 03:01:22 rkulkarni Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneUserSession <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneUserSession')
	drop procedure sp_dm2_PruneUserSession
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneUserSession')
	delete from GxQscripts where name = 'sp_dm2_PruneUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneUserSession'
GO
print '... Creating Procedure: sp_dm2_PruneUserSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneUserSession
  @i_UserGUID varchar(36) = '',
  @i_SessionID varchar(36) = ''
AS
  --Pruning Process will not send session Id input. But Logout functionality will.
  --Marking attribute as 4 helps to identify loggout session entries in dmusersession. We don't delete right away unlike QSDK session entries.
  --We let regular pruning that runs to delete entries from dmusersession.
  if ISNULL(@i_SessionID,'') = ''
  begin
	  --Bug Found: No entry point found in code that calls pruning of queries in 10.0. Fixing it by calling it from here.
	  exec sp_dm2_PruneQuery @i_UserGUID, ''
	  if @i_UserGUID != ''
	  begin
		  delete from DMUserSession
		  where UserGUID = @i_UserGUID
	  end
	  else
	  begin
		DECLARE @l_retainEntries INT = 10  -- default 10 entries
		SELECT @l_retainEntries = ISNULL(SettingValue, 10) FROM DMSetting
		WHERE SettingName = 'RETAIN_USERSESSION_ENTRY'
		--Pruning changes (retain last 10(default) entries grouped by userguid)
		;WITH CTE
		AS
		(
			SELECT ROW_NUMBER() OVER ( PARTITION BY userguid, ConsoleType, DeviceID ORDER BY lastAccesstime DESC ) AS 'RowNumber', u.SessionID
			FROM DMUserSession U LEFT JOIN DMUserSessionDetail US ON U.SessionId = US.SessionId
		)
		DELETE T FROM DMUserSession T JOIN CTE A ON T.SessionID = A.SessionID AND A.RowNumber > @l_retainEntries
	end
  end
  else
  begin
	 UPDATE DMUserSession
	 SET Attribute = Attribute | 4
	 WHERE SessionId = @i_SessionID
  end
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneUserSession')
	delete from GxQscripts where name = 'sp_dm2_PruneUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneUserSession')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneUserSession'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneUserSession',  '00010004008400020000', 'sp_dm2_PruneUserSession', '00010004008400020000')
GO

