

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneResultSetItemsBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneResultSetItemsBulk()
--  | Description:  Prune ResultSet in bulk
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneResultSetItemsBulk.sp,v $ $Id: sp_dm2_PruneResultSetItemsBulk.sp,v 1.6 2012/11/15 16:04:32 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneResultSetItemsBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneResultSetItemsBulk')
	drop procedure sp_dm2_PruneResultSetItemsBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneResultSetItemsBulk')
	delete from GxQscripts where name = 'sp_dm2_PruneResultSetItemsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneResultSetItemsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneResultSetItemsBulk'
GO
print '... Creating Procedure: sp_dm2_PruneResultSetItemsBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneResultSetItemsBulk
  @i_ResultSetIds nvarchar(max) = '',
  @i_containerID nvarchar(max) = '',
  @i_Attribute int = 0,
  @i_InputAsItemID BIT = 0
AS
-- i_ResultSetIds --> This can be comma seperated list of ID from DMContainerItem if i_InputAsItemID = 1
-- i_ResultSetIds --> This will be comma seperated list of ResultSetID from DMResultSet if i_InputAsItemID = 0
  --Create temp tbl for holding ResultSetId
	CREATE TABLE #tmpResultSetId
	(
		ResultSetId VARCHAR(36)
	) ;
	--When we delete particular resultSetId list
	IF LEN(@i_ResultSetIds) > 0 AND LEN(@i_containerID) > 0
	BEGIN
		IF @i_InputAsItemID = 0
		BEGIN
			INSERT INTO #tmpResultSetId
			SELECT  LTRIM(RTRIM(ID))
			FROM dbo.splitStringToTable(@i_ResultSetIds)
			WHERE ID IS NOT NULL
			AND LEN(ID) > 0
		END
		ELSE
		BEGIN
			INSERT INTO #tmpResultSetId
			SELECT ResultSetID FROM DMContainerItem C WITH(NOLOCK), dbo.splitStringToTable(@i_ResultSetIds) A
			WHERE C.ID = CONVERT(INT, LTRIM(RTRIM(A.ID)))
		END
		DELETE DMContainerItemTags
		FROM DMContainerItemTags CIT, DMContainerItemStates CIS, #tmpResultSetId T
		WHERE CIS.ContainerID = @i_containerID
		AND 	CIS.ResultSetID = T.ResultSetId
		AND		CIS.AssignID = CIT.AssignID
		DELETE DMContainerItemStateHistory
		FROM DMContainerItemStateHistory CIH, DMContainerItemStates CIS, #tmpResultSetId T
		WHERE CIS.ContainerID = @i_containerID
		AND 	CIS.ResultSetID = T.ResultSetId
		AND		CIS.AssignID = CIH.AssignID
		DELETE DMContainerItemStates
		FROM DMContainerItemStates CIS, #tmpResultSetId T
		WHERE CIS.ContainerID = @i_containerID
		AND 	CIS.ResultSetID = T.ResultSetId
		DELETE DMUserComment
		FROM DMUserComment UC, #tmpResultSetId T
		WHERE UC.ContainerID = @i_containerID
		AND 	UC.ResultSetID = T.ResultSetId
		DELETE DMContainerItem
		FROM DMContainerItem CI, #tmpResultSetId T
		WHERE CI.ContainerID = @i_containerID
		AND 	CI.ResultSetID = T.ResultSetId
	END
  ELSE IF LEN(@i_containerID) > 0 AND LEN(@i_ResultSetIds) = 0
  --when we delete a  particular ReviewSet
	BEGIN
		INSERT INTO #tmpResultSetId
		SELECT ResultSetID
		FROM DMContainerItem
		WHERE ContainerID = @i_containerID
		AND ResultSetID IS NOT NULL
		AND LEN(ResultSetID) > 0
		DELETE DMContainerItemTags
		WHERE AssignID IN (
												SELECT AssignID
												FROM DMContainerItemStates
												WHERE ContainerID = @i_containerID
											)
		DELETE DMContainerItemStateHistory
		WHERE AssignID IN (
												SELECT AssignID
												FROM DMContainerItemStates
												WHERE ContainerID = @i_containerID
											)
		DELETE DMContainerItemStates
		WHERE ContainerID = @i_containerID
		DELETE DMUserComment
		WHERE ContainerID = @i_containerID
		DELETE DMContainerExport
		WHERE ContainerID = @i_containerID
		DELETE DMContainerItem
		WHERE ContainerID = @i_containerID
	END
	IF ( (SELECT COUNT(*) FROM #tmpResultSetId) > 0 )
	BEGIN
		--Find reference count
		DELETE #tmpResultSetId
		FROM #tmpResultSetId T, DMContainerItem CI WITH (NOLOCK)
		WHERE T.ResultSetId = CI.ResultSetId
		--Find reference count in DMDownloadResultSet
		DELETE #tmpResultSetId
		FROM #tmpResultSetId T, DMDownloadResultSet CI WITH (NOLOCK)
		WHERE T.ResultSetId = CI.ResultSetId
		--Mark items deleted and later submit for space cleanup
		UPDATE DMResultSet
		SET Attribute = Attribute | 4, --Mark DELETED
			PruneRequestTime = GETUTCDATE()
		FROM DMResultSet RS, #tmpResultSetId T
		WHERE RS.ResultSetID = T.ResultSetId
	END
	DROP TABLE #tmpResultSetId
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneResultSetItemsBulk')
	delete from GxQscripts where name = 'sp_dm2_PruneResultSetItemsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneResultSetItemsBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneResultSetItemsBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneResultSetItemsBulk',  '00010006000000000000', 'sp_dm2_PruneResultSetItemsBulk', '00010006000000000000')
GO

