

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneItemsToSyncWithIndexing.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneItemsToSyncWithIndexing.sp,v $ $Id: sp_dm2_PruneItemsToSyncWithIndexing.sp,v 1.2 2012/08/28 04:12:07 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneItemsToSyncWithIndexing <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneItemsToSyncWithIndexing')
	drop procedure sp_dm2_PruneItemsToSyncWithIndexing
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_PruneItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneItemsToSyncWithIndexing'
GO
print '... Creating Procedure: sp_dm2_PruneItemsToSyncWithIndexing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneItemsToSyncWithIndexing
AS
SET NOCOUNT ON
BEGIN
	/*
		This Stored procedure prunes items in DMItemsToSyncWithIndexing table based on below criteria
			1. if success status( =1 ), prune will happen based on setting key [INDEX_SYNC_INTERVAL] [default -24hrs]
			2. if status <>1, prune will be based on key [PRUNE_FAILED_INDEX_INTERVAL_InHrs]		 [default-168hrs]
	*/
	DECLARE @idxSyncInterval int = 24  -- 1day
	DECLARE @idxSyncIntervalFailedItems int = 168 -- 7 days
	SELECT @idxSyncInterval = ISNULL(SettingValue, 24) FROM DMSetting
    WHERE SettingName = 'INDEX_SYNC_INTERVAL'
    SELECT @idxSyncIntervalFailedItems = ISNULL(SettingValue, 168) FROM DMSetting
    WHERE SettingName = 'PRUNE_FAILED_INDEX_INTERVAL_InHrs'
	DELETE FROM DMItemsToSyncWithIndexing
	WHERE DATEDIFF(HOUR, ISNULL(IndexSyncTime,getdate()), getdate()) > @idxSyncInterval AND SyncStatus = 1
	DELETE FROM DMItemsToSyncWithIndexing
	WHERE DATEDIFF(HOUR, ISNULL(IndexSyncTime,getdate()), getdate()) > @idxSyncIntervalFailedItems AND SyncStatus <> 1
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneItemsToSyncWithIndexing')
	delete from GxQscripts where name = 'sp_dm2_PruneItemsToSyncWithIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneItemsToSyncWithIndexing')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneItemsToSyncWithIndexing'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneItemsToSyncWithIndexing',  '00010002000000000000', 'sp_dm2_PruneItemsToSyncWithIndexing', '00010002000000000000')
GO

