

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PruneDMLegalHoldItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PruneDMLegalHoldItems.sp,v $ $Id: sp_dm2_PruneDMLegalHoldItems.sp,v 1.3.60.1 2017/02/10 19:18:48 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PruneDMLegalHoldItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PruneDMLegalHoldItems')
	drop procedure sp_dm2_PruneDMLegalHoldItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_PruneDMLegalHoldItems')
	delete from GxQscripts where name = 'sp_dm2_PruneDMLegalHoldItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneDMLegalHoldItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneDMLegalHoldItems'
GO
print '... Creating Procedure: sp_dm2_PruneDMLegalHoldItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PruneDMLegalHoldItems
  @i_CompPolicyId VARCHAR(36) = '',
  @i_JobId INT = 0,
  @i_batchFetchCount INT = 0,
  @i_debug INT = 0  --this should be the last param.
AS
SET NOCOUNT ON
		--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		--			   Stored Procedure For Pruning DMLegalHoldItemsToBackup			--
		--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		/*****************************************************************
		*
		*
		*
			This stored procedure doesnt have any mandatory parameters.
			Below are optional params which can be used to constraint the pruning criteria..
					@i_CompPolicyId - Prune for any specific CompPolicy Id.
					@i_JobId -- Prune for any particular job
					@i_batchFetchCount --By default 1000 items would be processed,
										for powerful machines, it can be increased accordingly
					@i_debug --Enabling would print the details of items deleted .Useful when invoked explicitly
			The criteria for deleting duplicate entries are as follows.
				1.	For a tuple(JobId,CompPolicyId,ResultSetId) only one entry should exists in the table
				2.	If multiple entries are found for a tuple, then
				3.	If any entries exists with BackupStatus = Completed(1)
					a.	Delete remaining entries with other BackupStatus
					b.	If more than one items exists with Same BackupStatus (in this case Completed)
						i.	Retain the first row with latest modified time and delete others
				4.	Else If any entries exists with BackupStatus = Not Submitted
					a.	Perform 3.a and 3.b
				5.	Else
					a.	Duplicate entries are found for Status In Processing.
					b.	Perform 3.b
			*
			*
			*********************************/
	BEGIN TRY
		--Declare variables
		DECLARE @contOuterloop INT,
				@totalCount	BIGINT,
				@errorCode	INTEGER,
				@rowsAffected	INT,
				@incr		INT,
				@tempStr	NVARCHAR(MAX)
		--Set default values
		SET @contOuterloop = 1
		SET @totalCount = 0
		SET	@errorCode	= 0
		SET @incr = 0
		SET @tempStr = ''
		--CHECK Batch COUNT value is <= 1000
		IF(@i_batchFetchCount < 1000)
			SET @i_batchFetchCount = 1000
		IF( @i_debug = 1)
		BEGIN
			SET @tempStr  = 'Total Count : '+ (SELECT CONVERT(NVARCHAR(MAX),COUNT_BIG(CompPolicyId))
											   FROM DMLegalHoldItemsToBackup WITH (READUNCOMMITTED))
			PRINT @tempStr
		END
		--This loop will continue until there is no duplicate entries for the same tuple
		WHILE(@contOuterloop = 1)
		BEGIN
			-- Assign default values before the loop starts
			SET @incr = @incr+1
			IF object_id('tempdb.dbo.#tmpLHTable') IS NOT null
				DROP TABLE #tmpLHTable
			CREATE TABLE #tmpLHTable
			(
				JobId INT,
				CompPolicyId CHAR(36),
				ResultSetID CHAR(36)
			);
			--Create index on the temp tables
			CREATE INDEX idx_tmpLHTable
			ON #tmpLHTable (ResultSetID,JobId, CompPolicyId )
			--Perform operation batch (Retrieve only @i_batchFetchCount items at atime)
			INSERT INTO #tmpLHTable
			SELECT TOP (@i_batchFetchCount) A.JobId, A.CompPolicyId,A.ResultSetID
			FROM DMLegalHoldItemsToBackup A WITH (READUNCOMMITTED)
			WHERE A.JobId>0 AND (@i_JobId= 0 OR (A.JobId = @i_JobId)) AND
				LEN(ISNULL(A.CompPolicyId,''))> 0 AND
				LEN(ISNULL(A.ResultSetID,''))> 0 AND (LEN(ISNULL(@i_CompPolicyId,''))=0 OR A.CompPolicyId = @i_CompPolicyId)
				GROUP BY A.JobId, A.CompPolicyId,A.ResultSetID
				HAVING COUNT(*) > 1
			--Check the temp table has valid number of rows
			IF ((SELECT COUNT(CompPolicyId) FROM #tmpLHTable) = 0)
				BREAK;
			IF(@i_debug = 1)
			BEGIN
				SET @tempStr  = CONVERT(NVARCHAR(MAX),@incr) + '. Cnt [ ' +
					(SELECT CONVERT(NVARCHAR(MAX),COUNT_BIG(*)) FROM #tmpLHTable WITH (READUNCOMMITTED)) + ' ]'
				PRINT  @tempStr
			END
			---drop the temp table if exists
			IF object_id('tempdb.dbo.#tmpLHTable2') IS NOT null
				DROP TABLE #tmpLHTable2
			CREATE TABLE #tmpLHTable2
			(
				JobId INT,
				CompPolicyId CHAR(36),
				ResultSetID CHAR(36),
				BackupStatus INT,
				ModifiedTime DATETIME
			);
			CREATE INDEX idx_tmpLHTable2
			ON #tmpLHTable2 (ResultSetID,JobId, CompPolicyId )
			--#tmpLHTable2 will hold the BackUpstatus,ModifiedTime and the tuple to have quick reference for manipulation
			INSERT INTO #tmpLHTable2 (JobId,CompPolicyId,ResultSetID,BackupStatus,ModifiedTime)
			SELECT A.JobId, A.CompPolicyId,A.ResultSetID,A.BackupStatus,A.ModifiedTime
				FROM DMLegalHoldItemsToBackup A WITH (READUNCOMMITTED)
						INNER JOIN #tmpLHTable B WITH (READUNCOMMITTED)
				ON A.JobId = B.JobId
					AND A.CompPolicyId = B.CompPolicyId
					AND	A.ResultSetID = B.ResultSetID
				ORDER BY A.ResultSetID,A.JobId,A.CompPolicyId
			IF(@i_debug = 1)
			BEGIN
				SET @tempStr  = '	Temp table2 Count : [ ' +
					(SELECT CONVERT(NVARCHAR(MAX),COUNT_BIG(*)) FROM #tmpLHTable2 WITH (READUNCOMMITTED)) + ' ]'
				PRINT  @tempStr
			END
			--local variables
			DECLARE @deletedRows INT = 0,
					@tempRowsCount INT = 0
			--------+++++++++++ Begin Transaction++++++++++-------------
			BEGIN TRAN
			WHILE((SELECT COUNT(JobId) FROM #tmpLHTable2) > 0)
			BEGIN
				DECLARE @cJobId			INT,
						@cCompPolicyId	VARCHAR(36),
						@cResultSetId	VARCHAR(36),
						@Status INT = 2
				SELECT TOP 1 @cJobId = T.JobId,
						@cCompPolicyId = T.CompPolicyId,
						@cResultSetId = T.ResultSetID
				FROM #tmpLHTable2 AS T
				--CREATE A TEMP TAble FRO
				IF object_id('tempdb.dbo.#tmpLHTable3') IS NOT null
					DROP TABLE #tmpLHTable3
				CREATE TABLE #tmpLHTable3
				(
					ResultSetID CHAR(36),
					BackupStatus INT,
					ModifiedTime DATETIME
				);
				INSERT INTO #tmpLHTable3
				SELECT T.ResultSetID,T.BackupStatus,T.ModifiedTime FROM #tmpLHTable2 AS T
				WHERE	T.JobId = @cJobId AND
						T.CompPolicyId = @cCompPolicyId AND
						T.ResultSetID = @cResultSetId
				IF EXISTS (SELECT ResultSetID FROM #tmpLHTable3
							 WHERE BackupStatus = 1)
				BEGIN
					SET @Status = 1
				END
				ELSE IF EXISTS (SELECT ResultSetID FROM #tmpLHTable3
									WHERE BackupStatus = 0)
				BEGIN
					SET @Status = 0
				END
				IF(@status != 2)
				BEGIN
					--delete all other rows
					DELETE DMLegalHoldItemsToBackup
					WHERE	JobId = @cJobId AND
							CompPolicyId = @cCompPolicyId AND
							ResultSetID = @cResultSetId AND
							BackupStatus != @status
					SELECT 	@errorCode	=	@@ERROR, @tempRowsCount = @@ROWCOUNT
					IF	@errorCode != 0
						GOTO CX_EXIT
					SET @deletedRows = @deletedRows + @tempRowsCount
					DELETE  #tmpLHTable3
					WHERE	BackupStatus != @status
				END
				-- duplicate entries exists for same status
				-- delete all retaining one
				IF((SELECT COUNT(ResultSetID) FROM #tmpLHTable3) > 1)
				BEGIN
					DECLARE @maxCount INT = 0
					DECLARE @date DATETIME = NULL
					SELECT TOP 1 @maxCount= COUNT(*),@date = ModifiedTime from #tmpLHTable3
					GROUP BY ModifiedTime ORDER BY ModifiedTime DESC
					--If more than one items exists with MAX(modifiedTime)
					-- delete all retaining only one
					IF(@maxCount > 1)
					BEGIN
						DELETE TOP (@maxCount-1) FROM DMLegalHoldItemsToBackup
						WHERE	JobId = @cJobId AND
								CompPolicyId = @cCompPolicyId AND
								ResultSetID = @cResultSetId AND
								ModifiedTime = @date
						SELECT 	@errorCode	=	@@ERROR, @tempRowsCount = @@ROWCOUNT
						IF	@errorCode != 0
							GOTO CX_EXIT
						SET @deletedRows = @deletedRows + @tempRowsCount
					END
					DELETE FROM DMLegalHoldItemsToBackup
					WHERE	JobId = @cJobId AND
							CompPolicyId = @cCompPolicyId AND
							ResultSetID = @cResultSetId AND
							ModifiedTime != @date
					SELECT 	@errorCode	=	@@ERROR, @tempRowsCount = @@ROWCOUNT
					IF	@errorCode != 0
						GOTO CX_EXIT
					SET @deletedRows = @deletedRows + @tempRowsCount
				END
				--DELETE FROM #tmpLHTable2
				DELETE #tmpLHTable2
				WHERE	ResultSetID = @cResultSetId AND
						CompPolicyId = @cCompPolicyId AND
						JobId = @cJobId
				DROP TABLE #tmpLHTable3
			END
			--------+++++++++++ Commit Transaction++++++++++-------------
			COMMIT TRAN
			IF(@i_debug = 1)
			BEGIN
				SET @tempStr  = '	BatchRows Deleted : [ ' + CONVERT(NVARCHAR(MAX),@deletedRows) + ' ]'
				PRINT @tempStr
			END
			SET @totalCount = @totalCount + @deletedRows
			--- if the count of #tmpLHTable is less than @i_batchFetchCount. No further items exists
			IF( (SELECT COUNT(*) FROM #tmpLHTable) < @i_batchFetchCount)
				SET @contOuterloop = 0
		END
		IF(@i_debug = 1)
		BEGIN
			SET @tempStr  = '	Total Rows Deleted : [ ' + CONVERT(NVARCHAR(MAX),@totalCount) + ' ]'
			PRINT @tempStr
		END
		IF(@@TRANCOUNT > 0 AND XACT_STATE() <> 0)
		BEGIN
			COMMIT TRAN;
		END
		print 'Total items deleted : ' + CONVERT(NVARCHAR(MAX),@totalCount)
		IF object_id('tempdb.dbo.#tmpLHTable') IS NOT null
			DROP TABLE #tmpLHTable
		IF object_id('tempdb.dbo.#tmpLHTable2') IS NOT null
			DROP TABLE #tmpLHTable2
		IF object_id('tempdb.dbo.#tmpLHTable3') IS NOT null
			DROP TABLE #tmpLHTable3
	CX_EXIT:
		IF (@errorCode != 0)
		BEGIN
			PRINT 'Completed With Error [ '+ 	CONVERT(NVARCHAR(MAX),@errorCode) + ' ]';
			IF(XACT_STATE() <> 0)
			BEGIN
				ROLLBACK TRAN;
				PRINT 'Transcation Rollbacked due to Error'
			END
		END
		ELSE
		BEGIN
			PRINT 'Completed Successfully';
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- Rollback any active or uncommittable transactions
		PRINT 'Error Code   : '+ CONVERT(NVARCHAR(MAX),ERROR_NUMBER() )
	    PRINT 'Error Message: '+ ERROR_MESSAGE()
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRAN;
			PRINT 'Transcation Rollbacked due to Exception'
		END
	END CATCH;
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PruneDMLegalHoldItems')
	delete from GxQscripts where name = 'sp_dm2_PruneDMLegalHoldItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PruneDMLegalHoldItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_PruneDMLegalHoldItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_PruneDMLegalHoldItems',  '00010003006000010000', 'sp_dm2_PruneDMLegalHoldItems', '00010003006000010000')
GO

