

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_PopulateAndUpdateFilesToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PopulateAndUpdateFilesToPrune()
--  | Description:  Update DM2TempCacheFileList table after finding reference
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_PopulateAndUpdateFilesToPrune.sp,v $ $Id: sp_dm2_PopulateAndUpdateFilesToPrune.sp,v 1.2 2013/12/28 03:35:36 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_PopulateAndUpdateFilesToPrune <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_PopulateAndUpdateFilesToPrune')
	drop procedure sp_dm2_PopulateAndUpdateFilesToPrune
IF EXISTS (select * from GxQscripts where name='sp_dm2_PopulateAndUpdateFilesToPrune')
	delete from GxQscripts where name = 'sp_dm2_PopulateAndUpdateFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PopulateAndUpdateFilesToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_PopulateAndUpdateFilesToPrune'
GO
print '... Creating Procedure: sp_dm2_PopulateAndUpdateFilesToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_PopulateAndUpdateFilesToPrune
  @o_errrorCode INT OUTPUT,
  @o_errorMessage NVARCHAR(MAX) OUTPUT
AS
BEGIN
	/*
		Before this SP is called,
			sp_dm2_InitPruning must be called in order to create tables..
			And cachefile list table(DM2TempCacheFileList) must be populated.
		Flow,
			- Entries must exists DM2TempCacheFileList table, else return
			- Populate destinationPath from all reference tables into DM2TempReferencePath table. [Not this can be little time consuming]
			- delete entries from cachefile table which have reference to Reference table.
	*/
	--DECLARE @o_errrorCode	INT;
	--DECLARE @o_errorMessage	NVARCHAR(MAX);
	--if any table is not created, return error.
	if object_id('DM2TempReferencePath') is null OR (object_id('DM2TempCacheFileList') is null)
	BEGIN
		SELECT @o_errrorCode = 1, @o_errorMessage = 'Tables(DM2TempCacheFileList,DM2TempReferencePath) is/are not created. '
		GOTO EXIT_;
	END
	--
	IF NOT EXISTS (SELECT TOP 1 * FROM DM2TempCacheFileList)
	BEGIN
		SELECT @o_errrorCode = 2, @o_errorMessage = 'DM2TempCacheFileList table is empty, pruning not requried..'
		GOTO EXIT_;
	END
	--delete the content from reference table
	DELETE DM2TempReferencePath
	-- now poulate reference table
	/*
		Tables:
			The table used in reference check.
				1. [DMContainerExport]			-- DestPath
				2. [DMDownload]					-- CabFilePath/DestinationPath
				3. [DMResultSet]				-- DestinationPath
				4. [DMLegalHoldItemsToBackup]	-- OrginalPath (where BackupStatus <> 1 AND ContainerID = '')
	 */
	--[DMContainerExport]
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT distinct DestPath, '' FROM [DMContainerExport] WITH (NOLOCK)
	WHERE ISNULL(DestPath,'') <> ''
	--DMDownload (cabfilePath)
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT CabFilePath, '' FROM DMDownload AS D WITH (NOLOCK)
	WHERE ISNULL(CabFilePath,'') <> ''
	--DMDownload (destinationPath)
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT distinct DestinationPath, '' FROM DMDownload AS D WITH (NOLOCK)
	WHERE ISNULL(DestinationPath,'') <> ''
	-- DMResultSet
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT DestinationPath, '' FROM DMResultSet WITH (NOLOCK)
	WHERE LEN(ISNULL(Destinationpath,''))>0
	-- DMLegalHoldItemsToBackup	-- OrginalPath (where BackupStatus <> 1 AND ContainerID = '')
	INSERT INTO DM2TempReferencePath(destinationPath,chkSum)
	SELECT D.OriginalPath, '' FROM DMLegalHoldItemsToBackup AS D  WITH (READUNCOMMITTED)
	WHERE	D.BackupStatus <> 1 AND ( ISNULL(D.ContainerID, '') = '' ) AND
			ISNULL(D.OriginalPath,'') <> ''
	--now update hash function
	UPDATE DM2TempReferencePath
	SET chkSum = dbo.fn_HashData(UPPER(destinationPath))
	--delete duplicate entries from reference table
	;WITH cte
		 AS (SELECT ROW_NUMBER() OVER (PARTITION BY chkSum ORDER BY id asc) RN
			 FROM   DM2TempReferencePath)
	DELETE FROM cte
	WHERE  RN > 1
	DECLARE @l_tempCount1 INT,
			@l_tempCount2 INT
	SELECT @l_tempCount1 = COUNT(*) FROM DM2TempCacheFileList
	SELECT @l_tempCount2 = COUNT(*) FROM DM2TempReferencePath
	--updated row count
	SELECT @o_errorMessage = ' Total Count in DM2TempCacheFileList ['+ CONVERT(VARCHAR(10),@l_tempCount1) + '], DM2TempReferencePath ['+ CONVERT(VARCHAR(10),@l_tempCount2) + ']..'
	-- start deleting which ever matches the reference table
	--
	DELETE Cache
	FROM
		DM2TempCacheFileList Cache
			INNER JOIN
		DM2TempReferencePath ref
	ON cache.chkSum = ref.chkSum
	SELECT @o_errrorCode = 0, @o_errorMessage = @o_errorMessage + ' Total rows deleted in after reference table map : ' + CONVERT(VARCHAR(10),@@ROWCOUNT)
EXIT_:
	RETURN
	--SELECT @o_errrorCode 'ErrorCode', @o_errorMessage 'Message'
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_PopulateAndUpdateFilesToPrune')
	delete from GxQscripts where name = 'sp_dm2_PopulateAndUpdateFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_PopulateAndUpdateFilesToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_PopulateAndUpdateFilesToPrune'
GO

insert into GXDBVersions values(2, 'sp_dm2_PopulateAndUpdateFilesToPrune',  '00010002000000000000', 'sp_dm2_PopulateAndUpdateFilesToPrune', '00010002000000000000')
GO

