

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_MoveFailedLegalHoldItems.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_MoveFailedLegalHoldItems()
--  | Description:  Moved failed LegalHold Items
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_MoveFailedLegalHoldItems.sp,v $ $Id: sp_dm2_MoveFailedLegalHoldItems.sp,v 1.4.12.5 2019/11/07 03:46:12 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_MoveFailedLegalHoldItems')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_MoveFailedLegalHoldItems <<<'
	drop procedure sp_dm2_MoveFailedLegalHoldItems
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_MoveFailedLegalHoldItems')
	delete from GxQscripts where name = 'sp_dm2_MoveFailedLegalHoldItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MoveFailedLegalHoldItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_MoveFailedLegalHoldItems'
GO
print '... Creating Procedure: sp_dm2_MoveFailedLegalHoldItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_MoveFailedLegalHoldItems
  @i_CompPolicyId varchar(36),
  @i_ContainerID varchar(36),
  @i_UserGUID varchar(36)
AS
DECLARE @o_alreadyExistsInContainer INT = 0,
				@o_alreadyExistsWithNewId INT = 0,
				@o_duplicateEntries	INT = 0,
				@o_existsInDMresultSet	INT = 0,
				@o_newlyInserted		INT = 0,
				@o_newlyAddedInDMResultSet INT = 0,
				@o_errorCode		INT = 0,
				@o_errorMessage		NVARCHAR(MAX) = ''
	BEGIN TRY
		DECLARE @l_CURRENTDATE DATETIME = GETUTCDATE();
		DECLARE @l_status INT = 0
		-- dmsetting to over ride default faile status
		--  0 or null - fetch failed items
		--  1			- fetch success items
		-- -1			- move all items
		SELECT @l_status = CONVERT(INT,ISNULL(SettingValue,'0')) FROM DMSetting WHERE SettingName = 'MOVE_LEGALHOLD_ITEMS_FETCH_STATUS'
		IF OBJECT_ID('tempdb.dbo.#tblMoveLegalHoldItems') IS NOT NULL
			DROP TABLE #tblMoveLegalHoldItems
		CREATE TABLE #tblMoveLegalHoldItems (
				ID INT IDENTITY(1,1),
				jobId INT,
				ResultSetID VARCHAR(36),
				isDMResultSetExists BIT DEFAULT 0,
				isDMContainerItemExists BIT DEFAULT 0,
				ResultSetInfoID INT
		)
		CREATE INDEX IDX_tblMoveLegalHoldItems_ResultSetId ON #tblMoveLegalHoldItems(ResultSetID)
		CREATE INDEX IDX_tblMoveLegalHoldItems_isDMResultSetExists ON #tblMoveLegalHoldItems(isDMResultSetExists)
	  -- Get all Failed items
		INSERT 	INTO #tblMoveLegalHoldItems (jobId, ResultSetID, ResultSetInfoID)
		SELECT 	LH.JobId, LH.ResultSetID, NULL
		FROM 	dmLegalHoldItemsToBackup LH	  WITH (READUNCOMMITTED)
		WHERE 	LH.CompPolicyId = @i_CompPolicyID
		AND		(@l_status = -1 OR LH.BackupStatus = @l_status)
		AND 	ISNULL(LH.ResultSetID,'') <> ''
		IF  NOT EXISTS(SELECT TOP 1 * FROM #tblMoveLegalHoldItems)
		BEGIN
			SELECT @o_errorCode = 9524,
					@o_errorMessage = 'No items found for copying from legalhold for criteria CompPolicyId :[' + @i_CompPolicyId + '] ,status: [' + CONVERT(VARCHAR(20),@l_status) + ']'
			GOTO CX_EXIT
		END
		--delete duplicates
		DELETE 	FROM #tblMoveLegalHoldItems
		WHERE ID NOT IN
		(
			SELECT MAX(ID)
			FROM #tblMoveLegalHoldItems
			GROUP BY ResultSetID
		)
		SELECT @o_duplicateEntries = @@ROWCOUNT
		-- Get already exists count isDMContainerItemExists
		UPDATE t
		SET t.isDMContainerItemExists = 1
		FROM #tblMoveLegalHoldItems t
				INNER JOIN
			DMContainerItem AS C WITH (NOLOCK)
		ON t.ResultSetID = C.ResultSetID AND C.ContainerID = @i_ContainerID
		SELECT @o_alreadyExistsInContainer = @@ROWCOUNT
		--update flag that exists in DMResultset table
		UPDATE #tblMoveLegalHoldItems
		SET isDMResultSetExists = 1, ResultSetInfoID = RO.ID
		FROM #tblMoveLegalHoldItems as T
				INNER JOIN
			DMResultSet AS R WITH(NOLOCK)
		ON R.ResultSetID = T.ResultSetID
				LEFT JOIN
			DMResultSetInfo AS RO WITH(NOLOCK)
		ON R.ResultSetID = RO.ResultSetID
		--
		INSERT INTO DMContainerItem (ContainerID, ResultSetID, UserGUID,QueryID,Attribute,CreateTime)
		SELECT DISTINCT @i_ContainerID,T.ResultSetID, @i_UserGUID, '',0 , @l_CURRENTDATE --ignore duplicates
		FROM #tblMoveLegalHoldItems AS T WHERE T.isDMResultSetExists = 1 AND t.isDMContainerItemExists = 0
		SELECT @o_newlyInserted = @@ROWCOUNT
		--delete rows that already exist in both DMResultSet and DMResultSetInfo table
		--
		DELETE #tblMoveLegalHoldItems WHERE isDMResultSetExists = 1 AND ResultSetInfoID IS NOT NULL
		--now create ResultSet
		WHILE EXISTS (SELECT TOP 1 1 from #tblMoveLegalHoldItems)
		BEGIN
			--declare all local variable for processing..
			DECLARE @l_lhId INT = 0,
					@l_jobId	INT = 0,
					@l_resultsetId	VARCHAR(36) = '',
					@l_ResultSetInfoID INT,
					@isDMResultSetExists BIT
			SELECT TOP  1 @l_lhId = ID , @l_jobId = T.jobId, @l_resultsetId = T.ResultSetID, @l_ResultSetInfoID = T.ResultSetInfoID, @isDMResultSetExists = isDMResultSetExists	FROM #tblMoveLegalHoldItems as T
			--
			DECLARE @l_metaDataXML NVARCHAR(max) = '',
					@inputXML XML,
					@count INTEGER,
					@ResultSetID VARCHAR(36) = '',
					@ResultSetXMLStr NVARCHAR(MAX) = '',
					@ResultSetXML XML,
					@OrigResultSetID	NVARCHAR(36) = @l_resultsetId,
					@ownerField NVARCHAR(MAX) = N''
			SELECT @l_metaDataXML = L.MetaDataXML  FROM DMLegalHoldItemsToBackup AS L WITH (NOLOCK)
			WHERE L.CompPolicyId = @i_CompPolicyId AND L.JobId = @l_jobId AND L.ResultSetID = @l_resultsetId
			SET	@inputXML = CONVERT(XML, @l_metaDataXML, 1)
			SELECT @count = COUNT(*) FROM @inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
			--Translate old LegalHold MetaDataXML to 9.0 format
			IF @count = 0
			BEGIN
				--SET @inputxml = CAST(dbo.ConvertLegalHoldMetaDataXMLTo900XMLManaged(@l_metaDataXML) AS XML)
				RAISERROR('The format of meta-data in this legal hold backup is not supported for restore. Contact your vendor support', 16, 1)
			END
			-------------------++++++++++++++++ temp tables for storing parsed XML and updating +++++++++++++++++++++++++++++++++---------------------
			DECLARE @tblResultSet TABLE
			(
				filePath				NVARCHAR(max),
				fileName				NVARCHAR(1024),
				folderPath				NVARCHAR(max),
				appType					INTEGER,
				appId					INTEGER,
				commcellNo				INTEGER,
				clientId				INTEGER,
				pushError				NVARCHAR(max),
				sizeKB					FLOAT,
				MIMEType				NVARCHAR(256),
				modifiedTime			BIGINT,
				jobId					INTEGER,
				contentIndexingJobId	INTEGER,
				backupTime				BIGINT,
				aFileId					INTEGER,
				aFileOffset				BIGINT,
				aFileLength				BIGINT,
				dynTeaser				NVARCHAR(max),
				rank					FLOAT,
				documentId				VARCHAR(256),
				ownerField				NVARCHAR(MAX),
				lnks					NVARCHAR(MAX),
				turboguid				varchar(256)
			)
			DECLARE @tblUserComments TABLE
			(
				UserGUID			VARCHAR(36),
				CreationDateTime	VARCHAR(25),
				ModifiedDateTime	VARCHAR(25),
				Comments			NVARCHAR(max)
			)
			DECLARE @tblAssignedUser TABLE
			(
				AssignId		INTEGER,
				StateID			VARCHAR(36),
				UserNotes		NVARCHAR(max),
				UserGUID		VARCHAR(36),
				ReviewSetTags	XML,
				CITags			XML
			)
			DECLARE @tblUserTags TABLE
			(
				AssignId	INTEGER,
				UserGUID	VARCHAR(36),
				TagId		VARCHAR(36)
			)
			--clean table
			delete @tblResultSet
			delete @tblUserComments
			delete @tblUserTags
			delete @tblAssignedUser
			INSERT	INTO @tblResultSet
			SELECT	T.item.value('@filePath', 'NVARCHAR(max)'),
					T.item.value('@fileName', 'NVARCHAR(1024)'),
					T.item.value('@folderPath', 'NVARCHAR(max)'),
					T.item.value('@appType', 'INTEGER'),
					T.item.value('@appId', 'INTEGER'),
					T.item.value('@commcellNo', 'INTEGER'),
					ISNULL(T.item.value('@clientId', 'INTEGER'), 0),
					T.item.value('@pushError', 'NVARCHAR(max)'),
					ISNULL(T.item.value('@sizeKB', 'FLOAT'), 0),
					T.item.value('@MIMEType', 'NVARCHAR(256)'),
					T.item.value('@modifiedTime', 'BIGINT'),
					ISNULL(T.item.value('@jobId', 'INTEGER'), 0),
					T.item.value('@contentIndexingJobId', 'INTEGER'),
					T.item.value('@backupTime', 'BIGINT'),
					T.item.value('@aFileId', 'INTEGER'),
					T.item.value('@aFileOffset', 'BIGINT'),
					ISNULL(T.item.value('@aFileLength', 'BIGINT'), 0),
					T.item.value('@dynTeaser', 'NVARCHAR(max)'),
					T.item.value('@rank', 'FLOAT'),
					T.item.value('@documentId', 'VARCHAR(256)'),
					T.item.value('./appSpecific[1]/eMail[1]/@from','NVARCHAR(max)'),
					T.item.value('./appSpecific[1]/eMail[1]/@links','NVARCHAR(max)'),
					T.item.value('@turboGuid', 'VARCHAR(256)')
			FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') T(item)
			UPDATE @tblResultSet
			SET filePath = CASE WHEN filePath IS null THEN
									N''
								ELSE filePath END
			--------------------+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++-----------------------
			-- if item already there use old ResultSetID itself
			IF @isDMResultSetExists = 1
			BEGIN
				SET @ResultSetID = @l_resultsetId
			END
			ELSE
			BEGIN
				-- if item does not exist meaning it is pruned
				-- check if same item exists with different ResultSetID, this means
				-- original item got pruned from DM2 DB but it got added back by different add to review set operation
				--
				SET @ResultSetID = (SELECT TOP 1 R.ResultSetID FROM DMResultSet AS R WITH (NOLOCK)
									INNER JOIN
									@tblResultSet AS T
									ON ((ISNULL(T.turboGuid, '') <> '' AND T.turboGuid = R.IndexGUID) OR (T.aFileId = R.aFileID AND T.commcellNo = R.CommCellNumber AND T.aFileOffset = R.aFileOffset)))
				IF ISNULL(@ResultSetID, '') <> ''
				BEGIN
					SET @isDMResultSetExists = 1
					SET @o_alreadyExistsWithNewId += 1
					SELECT @l_ResultSetInfoID = ID FROM DMResultSetInfo WITH(NOLOCK) WHERE ResultSetID = @ResultSetID
				END
			END
				--PopulateOwnerField only if required
				--Do this always as we need value for either DMResultSet or DMResultSetInfo table updation.
				IF EXISTS (SELECT * FROM DMUIAppTypeMap
							WHERE AppTypeId = (SELECT TOP 1 appType FROM @tblResultSet)
								AND IsEmailAppType = 1)
				BEGIN
					DECLARE @getOwnerAsMailBoxOwner NVARCHAR(10) = 'False',
							@lnks NVARCHAR(MAX) = '',
							@fromField NVARCHAR(MAX) = '',
							@filePath NVARCHAR(MAX) = ''
					SELECT @getOwnerAsMailBoxOwner = SettingValue
					FROM DMSetting WHERE SettingName = 'POPULATE_OWNERFIELD_AS_MAILBOXOWNER'
					SELECT @lnks = T.lnks,@fromField = T.ownerField, @filePath = T.filePath
					FROM @tblResultSet AS T
					--the CLR function depends on XML layer which is expensive and requires additional options to be enabled on SQL Server which is causing concerns
					--from reliability and scalability standpoint.
					--its a minor issue if we cannot populate owner in DB as we use this for display purposes in success/failed items view of export operations alone.
					SELECT @ownerField = '' -- dbo.GetOwnerFieldManaged(@fromField,@lnks,@filePath,@getOwnerAsMailBoxOwner)
				END
			IF @isDMResultSetExists = 0
			BEGIN
				SET @ResultSetID = NEWID()	-- new ResultSetId
				INSERT INTO DMResultSet
					(ResultSetID,CommCellNumber,aFileID,aFileOffset,aFileLength,
					AppType,FileSizeKB,ModifiedTime,JobId,OriginalFullPath,
					DestinationPath,CreateTime,RestoreUserGUID,RestoreCommCellNumber,RestoreJobID,
					RestoreStatus,RestoreTime,Attribute,
					documentID,ClientID,ERMStatus,
					Title)
				SELECT
					@ResultSetID, T.commcellNo, T.aFileId, T.aFileOffset, T.aFileLength,
					appType, sizeKB, dbo.GetDateTime(modifiedTime), jobId, filePath,
					'', GETDATE(), @i_UserGUID, 0,0,
					0, null, 0,
					T.documentId, clientId,0,
					fileName
				FROM	@tblResultSet as T
				SET @o_newlyAddedInDMResultSet = @o_newlyAddedInDMResultSet + 1
			END
			-------------------------+++++++++++++++++++++++ Populate DMResultSetInfo table+++++++++++++++++++---------------------
				DECLARE @ResultSetInfoID INT = 0
				IF ISNULL(@l_ResultSetInfoID, 0) <> 0
				BEGIN
					SET @ResultSetInfoID = @l_ResultSetInfoID
				END
				BEGIN
				INSERT INTO DMResultSetInfo
				SELECT	@ResultSetID, ''
				FROM	@tblResultSet
					SET @ResultSetInfoID = SCOPE_IDENTITY()
				END
				--Translate to DM2ContentIndexing_GResultItem Root tag
				SELECT @ResultSetXML = CAST(dbo.fn_dm2_GetLatestResultSetXML(@ResultSetID, CAST(@inputxml.query('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') AS NVARCHAR(max))) AS XML)
				IF @ResultSetXML.exist('//DM2ContentIndexing_GResultItem[@ResultItemID]') = 0
					SET @ResultSetXML.modify('insert attribute ResultItemID {sql:variable("@ResultSetID")} into (/DM2ContentIndexing_GResultItem)[1]')
				ELSE
					SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@ResultItemID)[1] with sql:variable("@ResultSetID")')
				--check whether the ownerField is populated in the GResultItem
				--if not insert new attribute
				IF(@ResultSetXML.exist('//DM2ContentIndexing_GResultItem/appSpecific/eMail/@owner')  = 0)
					SET @ResultSetXML.modify('insert attribute owner {sql:variable("@ownerField")}
					into (/DM2ContentIndexing_GResultItem/appSpecific/eMail)[1]')
				ELSE
					SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/appSpecific/eMail/@owner)[1]
					with sql:variable("@ownerField") ')
				SELECT @ResultSetXMLStr = CAST(@ResultSetXML AS NVARCHAR(MAX))
				UPDATE DMResultSetInfo
				SET ResultSet = @ResultSetXMLStr
				WHERE ID = @ResultSetInfoID
			-------------------------+++++++++++++++++++++++ Populate DMEail table+++++++++++++++++++---------------------
			IF EXISTS (SELECT * FROM DMUIAppTypeMap
						WHERE AppTypeId = (SELECT TOP 1 appType FROM @tblResultSet)
							AND IsEmailAppType = 1)
			BEGIN
				DECLARE @ResultSetTable AS ResultSetType
				INSERT INTO @ResultSetTable	-- ONly one item will get inserted.
				SELECT ResultSetID, CAST(ResultSet AS XML) FROM DMResultSetInfo WITH (NOLOCK)
				WHERE ResultSetID = @ResultSetID
				IF EXISTS (SELECT TOP 1 * FROM @ResultSetTable)
				BEGIN
					IF OBJECT_ID('tempdb.dbo.#tmpDMEmailFields') IS NOT NULL
						DROP TABLE #tmpDMEmailFields
					CREATE TABLE #tmpDMEmailFields
					(
						resultSetID VARCHAR(36),
						subjectField NVARCHAR(MAX),
						toField NVARCHAR(MAX),
						fromField NVARCHAR(MAX),
						bccField NVARCHAR(MAX),
						ccField NVARCHAR(MAX)
					);
					INSERT INTO #tmpDMEmailFields
					SELECT T.ResultSetId,T.subjectField,T.toField,T.fromField,T.bccField,T.ccField
					FROM dbo.fn_dm2_GetValuesForEmailFields(@ResultSetTable) AS T
					IF EXISTS (SELECT E.ResultSetID FROM DMEmailResult E WITH(NOLOCK) inner join @ResultSetTable as TR ON E.ResultSetID = TR.ResultSetID)
					BEGIN
						UPDATE DMEmailResult
						SET EmailSubject = TR.subjectField, EmailFROM = TR.fromField, EmailTO = TR.toField, EmailCC = TR.ccField, EmailBCC = TR.bccField,
						SavedTime = GETUTCDATE()
						FROM #tmpDMEmailFields TR
						WHERE DMEmailResult.ResultSetID = TR.ResultSetID
					END
					ELSE
						INSERT INTO DMEmailResult (ResultSetID,EmailSubject,EmailFROM,EmailTO,EmailCC,EmailBCC,SavedTime)
						SELECT TR.ResultSetID, TR.subjectField, TR.fromField, TR.toField, TR.ccField, TR.bccField, GETUTCDATE() FROM #tmpDMEmailFields TR
				END
			END
			--------------------+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++-----------------------
			--------------------++++++++++++++++++++++++++Inserts in all required tables++++++++++++++++++++++++++-----------------------
			IF NOT EXISTS (	SELECT *
						FROM	DMContainerItem		WITH (READUNCOMMITTED)
						WHERE	ContainerID = @i_ContainerID
						AND		ResultSetID = @ResultSetID)
			BEGIN
				INSERT INTO DMContainerItem
				values(@i_ContainerID, '', @ResultSetID, @l_CURRENTDATE, 0, @i_UserGUID)
				INSERT INTO @tblUserComments
				SELECT	ISNULL(T.item.value('userInfo[1]/@userGuid', 'VARCHAR(36)'), ''),
								ISNULL(T.item.value('userComment[1]/@creationDateTime', 'VARCHAR(25)'), ''),
								ISNULL(T.item.value('userComment[1]/@modifiedDateTime', 'VARCHAR(25)'), ''),
								ISNULL(T.item.value('userComment[1]/@comments', 'NVARCHAR(MAX)'), '')
				FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/userCommentInformation/userCommentInfo') T(item)
				SET @o_newlyInserted += 1
				IF EXISTS (SELECT UserGUID FROM @tblUserComments WHERE Comments IS NOT NULL)
					INSERT	INTO DMUserComment
					SELECT NEWID(), UserGUID, '', @i_ContainerID, @ResultSetID, NULL, Comments, CONVERT(DATETIME, CreationDateTime), 0, CONVERT(DATETIME, ModifiedDateTime)
					FROM @tblUserComments
					WHERE Comments IS NOT NULL
			END
			ELSE
			BEGIN
				UPDATE DMContainerItem
				SET Attribute = Attribute & ~4
				WHERE ContainerID = @i_ContainerID
				AND ResultSetID = @ResultSetID
				AND	Attribute & 4 = 4
				UPDATE DMUserComment
				SET Attribute = Attribute & ~4
				WHERE ContainerID = @i_ContainerID
				AND ResultSetID = @ResultSetID
				AND	Attribute & 4 = 4
			END
				--Get Assigned User Info
											INSERT INTO @tblAssignedUser
			SELECT	ISNULL(T.item.value('@assignID', 'INTEGER'), ''),
					ISNULL(T.item.value('docState[1]/@stateID', 'VARCHAR(36)'), ''),
					T.item.value('docState[1]/@stateDescription', 'NVARCHAR(max)'),
					ISNULL(T.item.value('userInformation[1]/@userGuid', 'VARCHAR(36)'), ''),
					T.item.query('./ReviewSetTags'),
					T.item.query('./CITags')
			FROM	@inputxml.nodes('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/assignedUserInfo/assignedUser') T(item)
									INSERT INTO @tblUserTags
			SELECT	0, UserGUID, T.c.value('@id', 'VARCHAR(36)')
			FROM	@tblAssignedUser CROSS APPLY CITags.nodes('/CITags') T(c)
			UNION
			SELECT	0, UserGUID, T.c.value('@id', 'VARCHAR(36)')
			FROM	@tblAssignedUser CROSS APPLY ReviewSetTags.nodes('/ReviewSetTags') T(c)
				-- Update the deleted flag if the entry already exists
										UPDATE DMContainerItemStates
			SET Attribute = Attribute & ~4
			FROM @tblAssignedUser AS TT, DMContainerItemStates as CIS WITH (READUNCOMMITTED)
			WHERE CIS.ContainerId = @i_ContainerId
			AND 	CIS.ResultSetId = @ResultSetID
			AND		CIS.AssignedUserGUID = TT.UserGUID
			AND		CIS.Attribute & 4 = 4
				--Insert entries if not exists
										INSERT INTO DMContainerItemStates
			SELECT @i_ContainerID, @ResultSetID, TT.UserGUID, TT.StateID, getUTCDate(), @i_UserGUID, TT.UserNotes, 0
			FROM @tblAssignedUser AS TT
			WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemStates AS CIS WITH (READUNCOMMITTED)
									WHERE CIS.ContainerId = @i_ContainerId
									AND 	CIS.ResultSetId = @ResultSetID
									AND		CIS.AssignedUserGUID = TT.UserGUID)
				UPDATE @tblUserTags
				SET assignID = CIS.assignID
				FROM @tblUserTags TT, DMContainerItemStates CIS WITH (NOLOCK)
				WHERE CIS.ContainerId = @i_ContainerId
				AND 	CIS.ResultSetId = @ResultSetID
				AND		CIS.AssignedUserGUID = TT.UserGUID
				-- Update the deleted flag if the entry already exists
									UPDATE DMContainerItemTags
			SET 	Attribute = Attribute & ~4
			FROM 	DMContainerItemTags CIT, @tblUserTags AS TT
			WHERE CIT.assignID = TT.assignID
			AND		CIT.TagID = TT.TagID
			AND		CIT.Attribute & 4 = 4
				-- Update the deleted flag if the entry already exists
										UPDATE DMUserItemTags
			SET 	Attribute = Attribute & ~4
			FROM 	DMUserItemTags UIT, @tblUserTags AS TT
			WHERE UIT.UserGUID = TT.UserGUID
			AND		UIT.ResultSetID = @ResultSetID
			AND		UIT.TagID = TT.TagID
			AND		UIT.Attribute & 4 = 4
				--Create entries if not exists
									INSERT INTO DMContainerItemTags
			SELECT TT.AssignID, TT.TagID, getUTCDate(), @i_UserGUID, '', 0
			FROM	@tblUserTags AS TT
			WHERE NOT EXISTS (SELECT TOP 1 * FROM DMContainerItemTags AS CIT WITH (NOLOCK)
									WHERE CIT.AssignID = TT.AssignID
									AND		CIT.TagID = TT.TagID)
				-- Remove all DB Tags if User Tags already exists
													DELETE DMContainerItemTags
			FROM 	DMContainerItemTags AS CIT, DMContainerItemStates AS CIS WITH (NOLOCK), DMUserItemTags UIT WITH (NOLOCK), @tblUserTags AS TT
			WHERE CIS.ResultSetId = UIT.ResultSetId
				AND		CIS.AssignedUserGUID = UIT.UserGUID
				AND		CIS.AssignID = CIT.AssignID
				AND		CIT.TagID = UIT.TagID
				AND		UIT.ResultSetId = @ResultSetID
				AND		UIT.UserGUID = TT.UserGUID
				AND		UIT.TagID = TT.TagID
				AND		UIT.Attribute & 4 = 0
				--------------------+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++-----------------------
				--delete entry from temp table
				DELETE #tblMoveLegalHoldItems WHERE ID = @l_lhId
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @o_errorMessage = ERROR_MESSAGE(), @o_errorCode = ERROR_NUMBER()
	END CATCH
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tblMoveLegalHoldItems') IS NOT NULL
			DROP TABLE #tblMoveLegalHoldItems
	select @o_alreadyExistsInContainer 'AlreadyExistsInContainer',
			@o_newlyInserted 'NewlyInserted',
			@o_duplicateEntries 'DuplicateEntries',
			@o_alreadyExistsWithNewId 'AlreadyExistsWithNewId',
			@o_newlyAddedInDMResultSet 'NewlyAddedInDMResultSet',
			@o_errorCode 'ErrorCode',
			@o_errorMessage 'ErrorMessage'
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_MoveFailedLegalHoldItems')
	delete from GxQscripts where name = 'sp_dm2_MoveFailedLegalHoldItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MoveFailedLegalHoldItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_MoveFailedLegalHoldItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_MoveFailedLegalHoldItems',  '00010004001200050000', 'sp_dm2_MoveFailedLegalHoldItems', '00010004001200050000')
GO

