

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_MigrateResultXmlsTo90.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_MigrateResultXmlsTo90()
--  | Description:  Update the XMLs in DMResultSetInfo table and DMLegalHoldItemsToBackup to 9.0 desired format.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_MigrateResultXmlsTo90.sp,v $ $Id: sp_dm2_MigrateResultXmlsTo90.sp,v 1.7.210.1 2018/08/23 14:28:58 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_MigrateResultXmlsTo90 <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_MigrateResultXmlsTo90')
	drop procedure sp_dm2_MigrateResultXmlsTo90
IF EXISTS (select * from GxQscripts where name='sp_dm2_MigrateResultXmlsTo90')
	delete from GxQscripts where name = 'sp_dm2_MigrateResultXmlsTo90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MigrateResultXmlsTo90')
	delete from GXDBVersions where aliasname = 'sp_dm2_MigrateResultXmlsTo90'
GO
print '... Creating Procedure: sp_dm2_MigrateResultXmlsTo90'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_MigrateResultXmlsTo90
AS
BEGIN
DECLARE @error 			int
DECLARE @startRN 		int
DECLARE @endRN 			int
DECLARE @totalRows	int
SET @error = 0
--BEGIN TRAN
IF OBJECT_ID('tempdb.dbo.#tblGetResultSetID') IS NOT NULL DROP TABLE #tblGetResultSetID
CREATE TABLE #tblGetResultSetID (rowId INT IDENTITY(1,1), ResultSetID VARCHAR(36))
--IF EXISTS(
--	SELECT * FROM DMLegalHoldItemsToBackup
--	WHERE ISNULL(METADATAXML, '') <> '' AND CONVERT(XML, METADATAXML).exist('/DM2ContentIndexing_LegalHoldItemMetaData/containerItems/contItem/resultItem') = 0
--)
--BEGIN
--	UPDATE DMLegalHoldItemsToBackup
--	SET MetaDataXML = dbo.ConvertLegalHoldMetaDataXMLTo900XMLManaged(MetaDataXML)
--	WHERE MetaDataXML IS NOT NULL
--	AND	  LEN(MetaDataXML) > 0
--	SET @error = @@ERROR
--	PRINT 'DMLegalHoldItemsToBackup Updated Successfully'
--END
IF @error > 0
BEGIN
	PRINT 'Error occurred updating DMLegalHoldItemsToBackup'
	GOTO ErrorL
END
INSERT INTO #tblGetResultSetID
SELECT resultSetID
FROM DMResultSetInfo WITH (NOLOCK)
SET @error = @@ERROR
IF @error > 0	GOTO ErrorL
SET @startRN = 1
SET @endRN = 2000
SELECT @totalRows = COUNT(*) FROM #tblGetResultSetID
WHILE (1 = 1)
BEGIN
	UPDATE DMResultSetInfo
	SET ResultSet = dbo.fn_dm2_GetLatestResultSetXML(RSI.ResultSetID, RSI.ResultSet)
	FROM DMResultSetInfo RSI, #tblGetResultSetID TMP
	WHERE RSI.resultSetID = TMP.resultSetID
	AND TMP.rowId >= @startRN
	AND TMP.rowId <= @endRN
	SET @error = @@ERROR
	IF @error > 0
	BEGIN
		PRINT 'Error occurred updating DMResultSetInfo'
		GOTO ErrorL
	END
	IF @endRN >= @totalRows
		BREAK
	SET @startRN = @endRN + 1
	SET @endRN = @endRN + 2000
END
IF @error = 0
BEGIN
	PRINT 'Successfully processed Result XML Blobs'
END
ELSE
BEGIN
	PRINT 'Errors in processing Result XML Blobs'
	GOTO ErrorL
END
ErrorL:
	if @error > 0
	BEGIN
		--ROLLBACK TRAN
		print 'Exited with errors'
	END
	else
	BEGIN
		--COMMIT TRAN
		print 'Exited Successfully'
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_MigrateResultXmlsTo90')
	delete from GxQscripts where name = 'sp_dm2_MigrateResultXmlsTo90'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_MigrateResultXmlsTo90')
	delete from GXDBVersions where aliasname = 'sp_dm2_MigrateResultXmlsTo90'
GO

insert into GXDBVersions values(2, 'sp_dm2_MigrateResultXmlsTo90',  '00010007021000010000', 'sp_dm2_MigrateResultXmlsTo90', '00010007021000010000')
GO

