

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_InitPruning.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_InitPruning()
--  | Description:  This sp will create new tables for pruning and if suppose table alread exists, then delete it.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_InitPruning.sp,v $ $Id: sp_dm2_InitPruning.sp,v 1.2 2013/12/28 03:35:36 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_InitPruning <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_InitPruning')
	drop procedure sp_dm2_InitPruning
IF EXISTS (select * from GxQscripts where name='sp_dm2_InitPruning')
	delete from GxQscripts where name = 'sp_dm2_InitPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_InitPruning')
	delete from GXDBVersions where aliasname = 'sp_dm2_InitPruning'
GO
print '... Creating Procedure: sp_dm2_InitPruning'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_InitPruning
AS
BEGIN
	DECLARE @o_message NVARCHAR(MAX)
	/*
		This sp will create new tables and if suppose table alread exists, then delete it.
		if DMSetting key [REUSE_EXISTING_PRUNE_TABLE] with value [true] is present, then we will reuse existing atble
	*/
	DECLARE @l_reuse_table BIT = 0
	SET @o_message =  ''
	IF EXISTS ( SELECT * FROM DMSetting WHERE SettingName = 'REUSE_EXISTING_PRUNE_TABLE' AND SettingValue = 'TRUE')
	BEGIN
		SET @o_message =' REUSE_EXISTING_PRUNE_TABLE key is present, will not delete table if already exists.. '
		SET @l_reuse_table = 1;
	END
	--delete if exists
	--
	if object_id('DM2TempReferencePath') is not null AND (@l_reuse_table = 0)
	BEGIN
		DROP TABLE DM2TempReferencePath
		SET @o_message = '\n' + @o_message + ' Deleted DM2TempReferencePath table'
	END
	if object_id('DM2TempCacheFileList') is not null AND (@l_reuse_table = 0)
	BEGIN
		DROP TABLE DM2TempCacheFileList
		SET @o_message = '\n' + @o_message + ' Deleted DM2TempCacheFileList table'
	END
	--CREAT tables
	if object_id('DM2TempReferencePath') is null
	BEGIN
		CREATE TABLE DM2TempReferencePath(
			 id INT IDENTITY(1,1) PRIMARY KEY,
			 destinationPath NVARCHAR(MAX) NOT NULL,
			 chkSum VARCHAR(32) NOT NULL
		);
		CREATE INDEX IDX_DM2TempReferencePath_1 ON DM2TempReferencePath(chkSum);
		SET @o_message = '\n' + @o_message + ' Created DM2TempReferencePath table.. '
	END
	if object_id('DM2TempCacheFileList') is null
	BEGIN
		CREATE TABLE DM2TempCacheFileList(
			id INT IDENTITY(1,1) PRIMARY KEY,
			cachePath NVARCHAR(MAX) NOT NULL,
			chkSum VARCHAR(32) NOT NULL
		);
		CREATE INDEX IDX_DM2TempCacheFileList_1 ON DM2TempCacheFileList(chkSum);
		SET @o_message = '\n' + @o_message + ' Created DM2TempCacheFileList table.. '
	END
	SELECT @o_message 'Message'
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_InitPruning')
	delete from GxQscripts where name = 'sp_dm2_InitPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_InitPruning')
	delete from GXDBVersions where aliasname = 'sp_dm2_InitPruning'
GO

insert into GXDBVersions values(2, 'sp_dm2_InitPruning',  '00010002000000000000', 'sp_dm2_InitPruning', '00010002000000000000')
GO

