

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetUserPref.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetUserPref()
--  | Description:  Get User preferences using the pagenation
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetUserPref.sp,v $ $Id: sp_dm2_GetUserPref.sp,v 1.12.210.7 2018/06/08 16:07:54 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetUserPref <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetUserPref')
	drop procedure sp_dm2_GetUserPref
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetUserPref')
	delete from GxQscripts where name = 'sp_dm2_GetUserPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserPref'
GO
print '... Creating Procedure: sp_dm2_GetUserPref'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetUserPref
  @i_UserGUID VARCHAR(MAX) = '',
  @i_ViewNames VARCHAR(MAX) = '',
  @i_PrefNames VARCHAR(MAX) = '',
  @i_SiteMode VARCHAR(50)	= '',
  @i_Offset INTEGER = 0,
  @i_Limit INTEGER = 10,  
  @i_OrderByClause NVARCHAR(MAX) = 'ViewName',
  @i_groupGuids VARCHAR(MAX) = '',
  @i_onlyAdminPref INT = 1,
  @i_showDefault INT = 1,
  @o_Count bigint OUTPUT
AS
DECLARE @SettingVal BIT = 0
	DECLARE @stNo INTEGER = 1
	DECLARE @endNo INTEGER = -1
	DECLARE @sqlStmt NVARCHAR(MAX) = ''
	DECLARE @bitVisibility INTEGER = 4
	--SEt the bit visibility default is 4
	IF ISNULL(@i_SiteMode, '') = ''
	BEGIN
		SET @bitVisibility = 0
	END
	ELSE
	BEGIN
	        SET @bitVisibility = ISNULL((	SELECT BinaryWeightage
									FROM DMSearchView WITH (NOLOCK)
									WHERE ViewName = @i_SiteMode)
									,-1)
	END
	IF(@i_Offset+@i_Limit <= 0)
	BEGIN
		set @stNo = 1
		set @endNo = -1
	END
	ELSE
	BEGIN
		set @stNo = @i_Offset + 1
		set @endNo = (@i_Offset + @i_Limit)
	END
	IF(LEN(ISNULL(@i_OrderByClause,'')) = 0)
		SET @i_OrderByClause = 'ViewName'
	IF object_id('tempdb.dbo.#tblAllResults') is not null
		DROP TABLE #tblAllResults
	CREATE table #tblAllResults (cnt int identity(1,1),UserGUID varchar(MAX),UserName varchar(max),UserType INT, ViewName varchar(max),
		UserPrefName varchar(max),UserPrefValue varchar(max),LastModifiedTime DateTime,Setting varchar(max));
	IF object_id('tempdb.dbo.#tblAllResultsSorted') is not null
		DROP TABLE #tblAllResultsSorted
	CREATE table #tblAllResultsSorted (id int identity(1,1), resultid int);
	IF ISNULL(@i_UserGUID,'') <> ''
	BEGIN
	CREATE TABLE #tblGroup (  UserGUID VARCHAR(MAX), GroupGUIDs VARCHAR(MAX) )
	IF ( LEN(@i_UserGUID) > 0 AND LEN(@i_groupGUIDs)> 0 )
	BEGIN
		INSERT INTO #tblGroup select A.DATA, B.DATA
		FROM
			(Select * from dbo.split(@i_groupGUIDs,'/') ) AS B
			INNER JOIN
			(SELECT * FROM dbo.split(@i_UserGUID,';')) AS A ON A.ID = B.ID
	END
	SELECT @SettingVal = ISNULL(SettingValue, 'False') FROM DMSetting WITH (NOLOCK) WHERE SettingName = 'DEFAULT_Disable_End_User_Setting'
	/*
	*@karthiks: MR: 56792
	*User has not logged into the webUI but perform ACC policy on CS.
	*So DMUserSession will not hold the userGuid. but some valid userGuid is sent.
	*To handle this scenario, if entry doesnt exists in DMUserSession
	*we put the userGuid and userNAme as "Unknown" in #tblUserGuidViews and return default value
	* */
	--Create temp table that will hold the user details and view names
	CREATE TABLE #tblUserGuidViews(UserGUID VARCHAR(MAX),UserName VARCHAR(MAX),ViewId VARCHAR(MAX), ViewName VARCHAR(MAX));
	-- sometimes the DMUserSession table contains more than 1 entry for userGUID with different names
	-- this results in preferences getting displayed twice in search page
	-- so select distinct of userGUID alone
	INSERT INTO #tblUserGuidViews
	SELECT DISTINCT A.UserGUID,NULL, B.Id as ViewId, B.ViewName
	FROM DMUserSession AS A  WITH (NOLOCK),
		 DMSearchView AS B  WITH (NOLOCK)
	WHERE B.BinaryWeightage in ( 1,2)  --only enduser and compliance view
		AND  (LEN(@i_ViewNames) = 0 OR B.Id IN (SELECT ID FROM dbo.splitStringToTable(@i_ViewNames) ))
		AND  (LEN (@i_UserGUID) = 0 or (A.UserGUID IN (SELECT ID FROM dbo.splitStringToTable(@i_UserGUID))))
	--This is in the case if we get userGuid but its entry is not in DMUserSession
	-- For eg: user performing ACC policy without logging into WebUI once too.
	-- dont conside if the #tblUserGuidViews is > 0
	IF(LEN(@i_UserGUID) > 0 AND (SELECT COUNT(*) FROM #tblUserGuidViews) = 0)
	BEGIN
		INSERT INTO #tblUserGuidViews
		SELECT DISTINCT A.UserGUID,NULL,B.Id as ViewId, B.ViewName
		FROM (SELECT ID FROM dbo.splitStringToTable(@i_UserGUID)) AS A (UserGUID),
			DMSearchView AS B
		WHERE B.BinaryWeightage in ( 1,2) --only enduser and compliance view
			AND  (LEN(@i_ViewNames) = 0 OR B.Id IN (SELECT ID FROM dbo.splitStringToTable(@i_ViewNames) ))
	END
	--Declare variables for the cursor
	DECLARE @cUserGuid			VARCHAR(MAX),
			@cUserName			VARCHAR(MAX),
			@cViewId			VARCHAR(36),
			@cViewName			VARCHAR(MAX),
			@cPrefName			VARCHAR(MAX),
			@cDefaultValue		VARCHAR(MAX)
	-- Declare cursor for Preferences
	DECLARE preferenceCursor CURSOR FAST_FORWARD FOR
	SELECT	 U.UserGUID AS UserGUID,U.UserName AS UserName,U.ViewId AS ViewId,
			 U.ViewName AS ViewName,S.FieldLabel AS FieldLabel,S.InitialDefaultValue AS DefaultValue
	FROM
	(
		(
			SELECT * FROM #tblUserGuidViews
		) AS U
		CROSS APPLY
		(
			-- if @bitVisibility = -1 means invalid site mode, so we won't return any list
		    -- if @bitVisibility = 0 means client program not interested in site mode filtering, so we return all preferences and its values
			SELECT FieldLabel,InitialDefaultValue
			FROM DMSearchCriteriaField WITH (NOLOCK)
			WHERE GroupId = 9 AND @bitVisibility <> -1
				AND (LEN(ISNULL(@i_PrefNames,'')) = 0 OR (FieldLabel IN (SELECT ID FROM dbo.splitStringToTable(@i_PrefNames))))
			AND ( (@bitVisibility = 0) OR (@bitVisibility > 0 AND (BitVisibility & @bitVisibility)>0) )
		) AS S
	)
	OPEN preferenceCursor
	FETCH NEXT FROM preferenceCursor INTO	@cUserGuid,@cUserName,@cViewId,
											@cViewName,@cPrefName,@cDefaultValue
		-----------------------Begin Cursor -----------------------
	WHILE @@FETCH_STATUS = 0
	BEGIN
		/*
		*	The hierarchy is as follows
			1. DMUserPref table where AdminFlag = 0 AND !Disable enduser setting
			2. DMUserPref table where AdminFlag = 1
			3. DMAdminPref table
			4. Default value
		*/
		------Variables to be inserted into the temp table
		DECLARE @tUserPrefValue		VARCHAR(MAX) = '',
				@tUserGUID			VARCHAR(36) = @cUserGuid,
				@tUserName			VARCHAR(MAX) =@cUserName,
				@tModifiedTime		DATETIME,
				@tModifiedUserGuid	VARCHAR(MAX) = ''
	DECLARE @ID INT = 0
		-----+++++++++++++++++++++ DMUserPref Table where AdminFlag = 0 AND !Disable enduser setting+++++++++++++++++++--------------
		SET @ID =  (SELECT TOP 1 P_Id FROM DMUserPref WITH (NOLOCK)
								WHERE( UserGUID		= @cUserGuid
										AND UserPrefName	= @cPrefName
										AND ViewId			= @cViewId
										AND	( (AdminFlag		= 0 AND @SettingVal = 0) )
									)
					)
		-----+++++++++++++++++++++ DMUserPref Table where AdminFlag = 1 AND pref set explicitly by admin for the given user +++++++++++++++++++--------------
		IF @ID IS NULL OR @ID = 0
		BEGIN
			SET @ID = 	(SELECT TOP 1 P_Id FROM DMUserPref WITH (NOLOCK)
							WHERE UserGUID		= @cUserGuid
							AND UserPrefName	= @cPrefName
							AND ViewId			= @cViewId
							AND	AdminFlag = 1
						)
		END
		-----+++++++++++++++++++++ DMUserPref Table where AdminFlag = 1 AND pref set explicitly by admin for the user's groups +++++++++++++++++++--------------
		IF @ID IS NULL OR @ID = 0
		BEGIN
			SET @ID = 	(SELECT TOP 1 P_Id FROM DMUserPref WITH (NOLOCK)
							WHERE(
									UserGUID in ( SELECT ID from dbo.splitStringToTable((Select GroupGUIDs from #tblGroup where UserGUID=@cUserGuid)) )
									AND UserPrefName	= @cPrefName
									AND ViewId			= @cViewId
									AND	AdminFlag = 1
								) ORDER BY CreateTime desc
						)
		END
		IF ( @ID <> 0)
		BEGIN
			SELECT	@tUserPrefValue		= UserPrefValue,
					@tUserGuid			= CASE @i_showDefault WHEN  0 THEN UserGuid ELSE @cUserGuid END,
					@tUserName			= CASE @i_showDefault WHEN 0 THEN ISNULL((SELECT TOP 1 UserName
															FROM DMUserSession  WITH (NOLOCK)
															WHERE UserGUID= U.UserGUID),'')
															ELSE @cUserName END,
					@tModifiedTime		= CreateTime,
					@tModifiedUserGuid	= ModifiedBy
			FROM DMUserPref U WITH (NOLOCK)
			WHERE   P_Id = @ID
		END
		-----+++++++++++++++++++++ DMAdminPref Table	+++++++++++++++++++--------------
		ELSE IF( EXISTS(SELECT TOP 1 Id FROM DMAdminPref WITH (NOLOCK)
						WHERE   PrefName	= @cPrefName
							AND ViewName	= @cViewId))
		BEGIN
			SELECT	@tUserPrefValue		= PrefValue,
					@tUserGUID			= CASE @i_showDefault WHEN 0 THEN (select cast(cast(0 as binary) as uniqueidentifier)) ELSE @cUserGuid END,
					@tUserName			= CASE @i_showDefault WHEN 0 THEN 'All' ELSE @cUserName END,
					@tModifiedTime		= ModifiedTime,
					@tModifiedUserGuid	= ModifiedBy
			FROM DMAdminPref WITH (NOLOCK)
			WHERE   PrefName	= @cPrefName
				AND ViewName	= @cViewId
		END
		-----+++++++++++++++++++++ DEFAULT VALUE	+++++++++++++++++++--------------
		ELSE IF ( @i_showDefault =1 )
		BEGIN
			SELECT	@tUserPrefValue		= @cDefaultValue,
					@tModifiedUserGuid	= 'N/A',
			--GET DATE FROM DMSetting TABLE. IF NOT EXISTS ASSIGN TODAY'S DATE
					@tModifiedTime = ISNULL((SELECT TOP 1 CreateTime
										 FROM DMSetting WITH (NOLOCK)
										 WHERE SettingName = 'DEFAULT_'+@cPrefName),
										 GETUTCDATE());
		END
		-----+++++++++++++++++++++ INSERT INTO TEMP TABLE +++++++++++++++++++--------------
		IF ( LEN(@tUserPrefValue) <> 0)
		BEGIN
			INSERT #tblAllResults
				(UserGUID,UserName,ViewName,
				UserPrefName,UserPrefValue,LastModifiedTime,
				Setting)
			VALUES
				(@tUserGuid,
				ISNULL(@tUserName,
						ISNULL((SELECT TOP 1 UserName FROM DMUserSession  WITH (NOLOCK) WHERE UserGUID= @tUserGuid),'')),
				@cViewName,
				@cPrefName,@tUserPrefValue,@tModifiedTime,
				ISNULL((SELECT TOP 1 UserName
						FROM DMUserSession  WITH (NOLOCK)
						WHERE UserGUID= @tModifiedUserGuid),
						'System'))
		END
	 FETCH NEXT FROM preferenceCursor INTO	@cUserGuid,@cUserName,@cViewId,
											@cViewName,@cPrefName,@cDefaultValue
	END
		----------------------- END	Cursor -----------------------
	CLOSE preferenceCursor
	DEALLOCATE preferenceCursor
	END
	ELSE --user guid null so view mode
	BEGIN
	INSERT #tblAllResults (UserGUID,UserName,UserType,ViewName,
			UserPrefName,UserPrefValue,LastModifiedTime,
			Setting)
		SELECT U.UserGUID
			,ISNULL((SELECT TOP 1 UserName FROM DMUserSession  WITH (NOLOCK) WHERE UserGUID= U.UserGUID),	'')
			, U.UserType
			,(SELECT TOP 1 V.ViewName from DMSearchView V where V.Id=U.ViewId)
			,U.UserPrefName
			,U.UserPrefValue
			,U.CreateTime
			,ISNULL((SELECT TOP 1 UserName FROM DMUserSession  WITH (NOLOCK) WHERE UserGUID= U.ModifiedBy),	'')
	from  DMUserPref U
	INNER JOIN DMSearchCriteriaField DF on U.UserPrefName = DF.FieldLabel AND  DF.BitVisibility&@bitVisibility > 0
	where @i_onlyAdminPref=0 OR (U.AdminFlag = @i_onlyAdminPref)
	END
	SET @sqlStmt = 'INSERT #tblAllResultsSorted SELECT cnt from #tblAllResults '
	SET @sqlStmt = @sqlStmt + ' order by ' + @i_OrderByClause
	EXEC sp_executesql @sqlStmt
	select @o_Count = COUNT(*) from #tblAllResultsSorted
	IF @endNo <=0
		SELECT @endNo = @o_Count
	SELECT A.UserGUID,A.UserName,A.UserType,A.ViewName,A.UserPrefName,A.UserPrefValue,A.LastModifiedTime,A.Setting
	FROM #tblAllResultsSorted S
	INNER JOIN #tblAllResults A ON A.cnt = S.resultid
	LEFT JOIN DMSearchCriteriaField B ON A.UserPrefName = B.FieldLabel
	WHERE s.id BETWEEN @stNo AND @endNo
	ORDER BY  s.id
	IF object_id('tempdb.dbo.#tblAllResults') is not null
	DROP TABLE #tblAllResults
	IF object_id('tempdb.dbo.#tblAllResultsSorted') is not null
	DROP TABLE #tblAllResultsSorted
	IF object_id('tempdb.dbo.#tblGroup') is not null
		DROP TABLE #tblGroup
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetUserPref')
	delete from GxQscripts where name = 'sp_dm2_GetUserPref'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetUserPref')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetUserPref'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetUserPref',  '00010012021000070000', 'sp_dm2_GetUserPref', '00010012021000070000')
GO

