

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetToPrune.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetResultSetToPrune()
--  | Description:  Get the ResultSet To Prune
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultSetToPrune.sp,v $ $Id: sp_dm2_GetResultSetToPrune.sp,v 1.7 2014/03/19 16:46:49 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultSetToPrune <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultSetToPrune')
	drop procedure sp_dm2_GetResultSetToPrune
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultSetToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetToPrune'
GO
print '... Creating Procedure: sp_dm2_GetResultSetToPrune'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultSetToPrune
  @i_StartIndex int = 0,
  @i_Count int = 100
AS
	-- NO PROCESSING SHOULD BE DONE VIA CVD CONTEXT
	--exec sp_dm2_PruneUserSession
	--by default, we dont want to run this pruning operation  from CVD context.
	-- so just return empty value and the other code will not get executed
	IF NOT EXISTS(SELECT * FROM DMSetting WHERE SettingName = 'RETURN_PRUNE_LIST_CVD' AND SettingValue = 'true')
	BEGIN
		SELECT DestinationPath, ResultSetID from DMResultSet where 1=2
	END
	ELSE
	BEGIN
		--download pruning will be done on deletion of downloadSet
		--exec sp_dm2_PruneDownload
		--
		-- Get all the result items that are marked deleted
		DECLARE @EndRN INT
		SET @EndRN = @i_Count + @i_StartIndex - 1
		EXEC ('WITH [dm2_GetResultSet] AS
		(SELECT DestinationPath, ResultSetID, ROW_NUMBER() OVER (order by PruneRequestTime asc) AS RowNumber
		FROM [DMResultSet] WITH (READUNCOMMITTED)
		WHERE (Attribute & 4) = 4
		AND (DestinationPath IS NOT NULL AND LEN(DestinationPath) > 0))
		SELECT DISTINCT DestinationPath, ResultSetID
		FROM [dm2_GetResultSet]
		WHERE RowNumber between ' + @i_StartIndex + ' AND ' + @EndRN)
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultSetToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetResultSetToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultSetToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultSetToPrune'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultSetToPrune',  '00010007000000000000', 'sp_dm2_GetResultSetToPrune', '00010007000000000000')
GO

