

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemsForGroupingInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetResultItemsForGroupingInfo()
--  | Description:
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetResultItemsForGroupingInfo.sp,v $ $Id: sp_dm2_GetResultItemsForGroupingInfo.sp,v 1.2 2012/08/06 15:32:09 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetResultItemsForGroupingInfo <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetResultItemsForGroupingInfo')
	drop procedure sp_dm2_GetResultItemsForGroupingInfo
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetResultItemsForGroupingInfo')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemsForGroupingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemsForGroupingInfo')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemsForGroupingInfo'
GO
print '... Creating Procedure: sp_dm2_GetResultItemsForGroupingInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetResultItemsForGroupingInfo
  @downloadId CHAR(36),
  @groupByValue NVARCHAR(MAX),
  @startIndex BIGINT = 0,
  @pageSize BIGINT = -1
AS
	SET NOCOUNT ON
	/*
		Usage:
			This Sp returns list of resultItem details for the input downloadId and groupByValue.. This SP can also be used to get items based on pagination..
			Attribute field is used to store the grouping field info..
				FolderPath --> POWER(2,14) [15th bit]
				OwnerField --> POWER(2,15) [16th bit]
	**/
	DECLARE @returnEmptyTable BIT = 1
	IF(LEN(ISNULL(@groupByValue,N''))>0  AND  LEN(ISNULL(@downloadId,''))>0 )
	BEGIN
		DECLARE @attribute INT = 0
		DECLARE @groupByClause VARCHAR(50) = ''
		DECLARE @sql NVARCHAR(MAX) = ''
		DECLARE @whereClause	NVARCHAR(MAX) = ''
		DECLARE @isPaginingEnabled BIT = 0
		IF(@startIndex <= 0)
			SET @startIndex = 1
		SELECT @attribute = Attribute
		FROM DMDownload WHERE DownLoadID = @downloadId
		IF(@attribute & POWER(2,14) > 0)
			SET @groupByClause = 'FolderPath'
		ELSE IF(@attribute & POWER(2,15) > 0)
			SET @groupByClause = 'OwnerField'
		IF(LEN(ISNULL(@groupByClause,''))>0)
		BEGIN
			IF(@groupByValue = N'Not-Available')
			BEGIN
				SET @whereClause = '(LEN(ISNULL('+@groupByClause+' ,'''')) = 0 ) '
			END
			ELSE
			BEGIN
				SET @whereClause = '(' + @groupByClause + ' = N''' + @groupByValue + ''' )'
			END
			SET @sql = 'SELECT A.DownloadID,A.ResultSetID,A.AppType,
							A.Status,A.CreateTime,A.FileName,A.DestinationPath
							FROM (
								SELECT D.DownloadID,D.ResultSetID,D.AppType,
										D.Status,D.CreateTime,ISNULL(D.FileName,'''') AS FileName,
										RS.DestinationPath,ROW_NUMBER() OVER (ORDER BY D.CreateTime ASC ) AS "RowNumber"
								FROM	DMDownloadResultSet AS D  WITH (NOLOCK)
											INNER JOIN
										DMResultSet AS RS WITH (NOLOCK)
								ON D.ResultSetID = RS.ResultSetID
								WHERE  D.DownLoadID = '''+@downloadId +''' AND ' +
									@whereClause +
							') AS A WHERE A.RowNumber >= ' + (CONVERT (VARCHAR(8),@startIndex))
			IF(@pageSize > 1)
				SET @sql = @sql +' AND A.RowNumber <'+ (CONVERT (VARCHAR(8),(@startIndex+@pageSize)))
			EXECUTE (@sql)
			SET @returnEmptyTable = 0
		END
	END
	IF(@returnEmptyTable = 1)
		SELECT 	D.*, ''  AS "DestinationPath"
		FROM DMDownloadResultSet AS D  WHERE 1= 2
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetResultItemsForGroupingInfo')
	delete from GxQscripts where name = 'sp_dm2_GetResultItemsForGroupingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetResultItemsForGroupingInfo')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetResultItemsForGroupingInfo'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetResultItemsForGroupingInfo',  '00010002000000000000', 'sp_dm2_GetResultItemsForGroupingInfo', '00010002000000000000')
GO

