

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetPruneFileList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_PruneDownload()
--  | Description:  Returns the altered input fileList which doesnt have any reference
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetPruneFileList.sp,v $ $Id: sp_dm2_GetPruneFileList.sp,v 1.3 2013/07/16 12:44:48 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetPruneFileList <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetPruneFileList')
	drop procedure sp_dm2_GetPruneFileList
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetPruneFileList')
	delete from GxQscripts where name = 'sp_dm2_GetPruneFileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetPruneFileList')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetPruneFileList'
GO
print '... Creating Procedure: sp_dm2_GetPruneFileList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetPruneFileList
  @i_filePathList NVARCHAR(MAX) = ''
AS
/***
	---------------------Description---------------------
	For the input filePathList, this stored procedure will try to find any reference exists
	and the return the list which doesnot have any reference, which later can be pruned..
	The table used in reference check.
	1. [DMContainerExport]			-- DestPath
	2. [DMDownload]					-- CabFilePath/DestinationPath
	3. [DMResultSet]				-- DestinationPath
	4. [DMLegalHoldItemsToBackup]	-- OrginalPath (where BackupStatus <> 1 AND ContainerID = '')
***/
BEGIN
	DECLARE @FileList TABLE ( filePath NVARCHAR(MAX)) ;
	DECLARE @i_xml XML =  @i_filePathList
	/*
		format of i_xml
		'<PathList>
			<path val ="c:\test\a;t.t"/>
			<path val ="c:\test1\b.t"/>
			<path val ="c:\test2\c.t"/>
		</PathList>'
	*/
	INSERT INTO @FileList
	SELECT distinct ref.value('@val','nvarchar(MAX)')
	FROM @i_xml.nodes('PathList/path') R(ref)
	DELETE @FileList
	WHERE filePath IN (
		SELECT distinct DestPath FROM [DMContainerExport] WITH (READUNCOMMITTED)
			WHERE DestPath IN (SELECT distinct filePath FROM @FileList ))
	IF EXISTS (SELECT top 1 filePath FROM @FileList )
	BEGIN
		DECLARE @tempTable2 TABLE(filePath NVARCHAR(MAX));
		INSERT INTO @tempTable2
		SELECT distinct filePath
		FROM @FileList AS T
				INNER JOIN
			DMDownload AS D
			ON D.CabFilePath = T.filePath OR D.DestinationPath = T.filePath
		DELETE @FileList
		FROM @tempTable2 as C, @FileList as L
		WHERE L.filePath = C.filePath
	END
	IF EXISTS (SELECT top 1 filePath FROM @FileList )
	BEGIN
		DECLARE @tempTable TABLE(filePath NVARCHAR(MAX));
		INSERT INTO @tempTable
		SELECT distinct filePath
		FROM DMResultSet AS D  WITH (READUNCOMMITTED)
					INNER JOIN
			@FileList AS F
			ON   D.DestinationPath=F.filePath
		DELETE @FileList
		FROM @tempTable as C, @FileList as L
		WHERE L.filePath = C.filePath
	END
	IF EXISTS (SELECT top 1 filePath FROM @FileList )
	BEGIN
		DECLARE @tempTable1 TABLE(filePath NVARCHAR(MAX));
		INSERT INTO @tempTable1
		SELECT distinct filePath
		FROM DMLegalHoldItemsToBackup AS D  WITH (READUNCOMMITTED)
					INNER JOIN
			@FileList AS F
			ON   D.OriginalPath=F.filePath
			WHERE	D.BackupStatus <> 1 AND
					(D.ContainerID = '' OR D.ContainerID IS NULL)
		DELETE @FileList
		FROM @tempTable1 as C, @FileList as L
		WHERE L.filePath = C.filePath
	END
	SELECT  filePath  AS "filePath" FROM @FileList
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetPruneFileList')
	delete from GxQscripts where name = 'sp_dm2_GetPruneFileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetPruneFileList')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetPruneFileList'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetPruneFileList',  '00010003000000000000', 'sp_dm2_GetPruneFileList', '00010003000000000000')
GO

