

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetPaneltoColumnConfig.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetPaneltoColumnConfig.sp,v $ $Id: sp_dm2_GetPaneltoColumnConfig.sp,v 1.5.210.3 2018/02/13 08:53:07 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetPaneltoColumnConfig <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetPaneltoColumnConfig')
	drop procedure sp_dm2_GetPaneltoColumnConfig
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetPaneltoColumnConfig')
	delete from GxQscripts where name = 'sp_dm2_GetPaneltoColumnConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetPaneltoColumnConfig')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetPaneltoColumnConfig'
GO
print '... Creating Procedure: sp_dm2_GetPaneltoColumnConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetPaneltoColumnConfig
  @i_SiteMode varchar(50) = '',
  @i_Name varchar(50) = ''
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	BEGIN
		DECLARE @TblCustomRuleColumns TABLE (ColumnId INT, PanelTypeId INT)
		DECLARE @enableTagging INT = 0
		DECLARE @showSmtpValuesInEmailPreview int = 0
		IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'ShowSmtpValuesForEmailPreview' AND SettingValue = 'true')
		BEGIN
			SET @showSmtpValuesInEmailPreview = 1
		END
		IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = 'sEnableTagFiltering' AND SettingValue = 'true') AND
			(@i_SiteMode = 'Compliance' OR (@i_SiteMode = 'EndUser' AND EXISTS (SELECT SettingValue FROM DMSetting WHERE SettingName = 'EnableEndUserTagging' AND SettingValue = 'true')))
		BEGIN
			SET @enableTagging = 1
		END
		--
		--With new SolrTagging, feature is enabled using DMSetting sEnableTagFiltering
		--and when it is enabled, we want show tags column that will show applied tags by fetching it from review set core
		--
		INSERT INTO @TblCustomRuleColumns (ColumnId, PanelTypeId)
		SELECT a.ColumnId, c.Id as PanelTypeId FROM DMUIPanelColumns A
		JOIN DMUIColumns B ON A.ColumnId = B.Id  AND B.PropertyName = 'tagNames'
		JOIN DMUIPanelType C ON A.PanelTypeId = C.Id AND C.Name IN ('AllSearchResultsGrid','FileSearchResultsGrid','EmailSearchResultsGrid')
		WHERE ((LEN(ISNULL(@i_Name,'')) = 0) OR C.Name = @i_Name) AND @enableTagging = 1
		UNION
		SELECT T.ColumnId, TP.Id as PanelTypeId FROM DMUIPanelColumns T
		JOIN DMUIPanelType TP ON T.PanelTypeId = TP.Id
		WHERE TP.Name = 'TagsGrid' and @enableTagging = 1
		--
		SELECT ISNULL(C.ColumnName, '') AS ColumnName ,
		ISNULL(C.ResourceKey, '') AS ResourceKey,
		CASE WHEN b.Name = 'EmailResultItemPreviewHeader' AND @showSmtpValuesInEmailPreview = 1 AND C.PropertyName IN ('emailFrom', 'emailTo', 'emailCc', 'emailBcc')
			THEN ISNULL(C.PropertyName, '') + 'Preview'
			ELSE ISNULL(C.PropertyName, '') END AS PropertyName,
		Width, Alignment, ISNULL(A.DisplayOrder, -1) AS DisplayOrder,
		(A.PanelTypeId) AS PanelTypeId	-- Both ENUMS and DB PanelTypeId starts from 1
		FROM [DMUIPanelColumns] AS A
		INNER JOIN [DMUIPanelType] AS B ON B.Id = A.PanelTypeId
		INNER JOIN [DMUIColumns] AS C ON C.Id = A.ColumnId
		WHERE (((LEN(ISNULL(@i_Name,'')) = 0) OR B.Name = @i_Name) AND ((SELECT BinaryWeightage FROM [DMSearchView] WHERE ViewName = @i_SiteMode) & A.BitVisibility > 0))
		OR EXISTS (SELECT * FROM @TblCustomRuleColumns T WHERE A.ColumnId = T.ColumnId AND A.PanelTypeId = T.PanelTypeId)
		ORDER BY B.id,A.DisplayOrder
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetPaneltoColumnConfig')
	delete from GxQscripts where name = 'sp_dm2_GetPaneltoColumnConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetPaneltoColumnConfig')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetPaneltoColumnConfig'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetPaneltoColumnConfig',  '00010005021000030000', 'sp_dm2_GetPaneltoColumnConfig', '00010005021000030000')
GO

