

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldResultSet.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldResultSet.sp,v $ $Id: sp_dm2_GetLegalHoldResultSet.sp,v 1.8 2010/11/18 14:45:03 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetLegalHoldResultSet <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetLegalHoldResultSet')
	drop procedure sp_dm2_GetLegalHoldResultSet
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetLegalHoldResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldResultSet'
GO
print '... Creating Procedure: sp_dm2_GetLegalHoldResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetLegalHoldResultSet
  @i_CompPolicyID varchar(36),
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_OrderByClause nvarchar(max) = 'modifiedTime',
  @i_BackupStatus varchar(30) = 'SUCCESS',
  @i_GetEmailsFlag bit = 1,
  @i_GetFilesFlag bit = 1,
  @i_offset int = 0
AS
SET NOCOUNT ON
DECLARE @StartRN INT
DECLARE @EndRN INT
--Changes to support both the pagination retrieval
-- through the pagenumber and offset
IF(@i_offset <= 0)
BEGIN
	IF (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
	BEGIN
		SET @StartRN = 1
		SET @EndRN = -1
	END
	ELSE
	BEGIN
		SET @StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
		SET @EndRN = @i_NumPages * @i_ItemsOnPage + @StartRN - 1
	END
END
ELSE
BEGIN
	IF(@i_ItemsOnPage) <= 0
	BEGIN
		SET @StartRN = @i_offset
		SET @EndRN = -1
	END
	ELSE
	BEGIN
		SET @StartRN = @i_Offset
		SET @EndRN = @i_offset + @i_ItemsOnPage - 1
	END
END
IF EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = '#tblGetLegalHoldItems')
	DROP TABLE #tblGetLegalHoldItems
CREATE TABLE #tblGetLegalHoldItems
(
	ContainerID 	VARCHAR(36),
	ResultSetID 	VARCHAR(36),
	LHJobID 			INT,
	LHCommCellID 	INT,
	BackupStatus 	INT
)
IF (@i_BackupStatus = 'FAILED')
BEGIN
	INSERT INTO #tblGetLegalHoldItems
	SELECT DISTINCT LH.ContainerID, LH.ResultSetID, LH.JobId, LH.CommCellId, LH.BackupStatus
	FROM dmLegalHoldItemsToBackup LH WITH (NOLOCK), DMUIAppTypeMap AT WITH (NOLOCK)
	WHERE LH.CompPolicyId = @i_CompPolicyID
	AND		LH.BackupStatus <> 1
	AND		LH.AppType = AT.AppTypeId
	AND		(AT.IsEmailAppType = CONVERT(VARCHAR, @i_GetEmailsFlag) OR
			 AT.IsFileAppType = CONVERT(VARCHAR, @i_GetFilesFlag))
END
ELSE IF (@i_BackupStatus = 'SUCCESS')
BEGIN
	INSERT INTO #tblGetLegalHoldItems
	SELECT DISTINCT LH.ContainerID, LH.ResultSetID, LH.JobId, LH.CommCellId, LH.BackupStatus
	FROM dmLegalHoldItemsToBackup LH WITH (NOLOCK), DMUIAppTypeMap AT WITH (NOLOCK)
	WHERE LH.CompPolicyId = @i_CompPolicyID
	AND		LH.BackupStatus = 1
	AND		LH.AppType = AT.AppTypeId
	AND		(AT.IsEmailAppType = CONVERT(VARCHAR, @i_GetEmailsFlag) OR
			 AT.IsFileAppType = CONVERT(VARCHAR, @i_GetFilesFlag))
END
ELSE
BEGIN
	INSERT INTO #tblGetLegalHoldItems
	SELECT DISTINCT LH.ContainerID, LH.ResultSetID, LH.JobId, LH.CommCellId, LH.BackupStatus
	FROM dmLegalHoldItemsToBackup LH WITH (NOLOCK), DMUIAppTypeMap AT WITH (NOLOCK)
	WHERE LH.CompPolicyId = @i_CompPolicyID
	AND		LH.AppType = AT.AppTypeId
	AND		(AT.IsEmailAppType = CONVERT(VARCHAR, @i_GetEmailsFlag) OR
			 AT.IsFileAppType = CONVERT(VARCHAR, @i_GetFilesFlag))
END
if @EndRN < 0 	select @EndRN = count(*) from #tblGetLegalHoldItems
EXEC ('WITH [dm2_GetLegalHoldItems] AS
(SELECT DISTINCT LH.*, ROW_NUMBER() OVER (order by LH.' + @i_OrderByClause + ') as RowNumber
FROM #tblGetLegalHoldItems AS T, dmLegalHoldItemsToBackup LH WITH (NOLOCK)
WHERE T.ContainerID = LH.ContainerID
AND		T.ResultSetID = LH.ResultSetID
AND		T.LHJobID = LH.JobId
AND		T.LHCommCellID = CommCellId
)
SELECT *
FROM [dm2_GetLegalHoldItems]
WHERE RowNumber between ' + @StartRN + ' and ' + @EndRN + ' ORDER BY RowNumber ')
drop table #tblGetLegalHoldItems
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetLegalHoldResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetLegalHoldResultSet',  '00010008000000000000', 'sp_dm2_GetLegalHoldResultSet', '00010008000000000000')
GO

