

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldItemsWithGrouping.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetLegalHoldItemsWithGrouping.sp,v $ $Id: sp_dm2_GetLegalHoldItemsWithGrouping.sp,v 1.6 2012/10/11 17:50:16 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetLegalHoldItemsWithGrouping <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetLegalHoldItemsWithGrouping')
	drop procedure sp_dm2_GetLegalHoldItemsWithGrouping
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetLegalHoldItemsWithGrouping')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldItemsWithGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldItemsWithGrouping')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldItemsWithGrouping'
GO
print '... Creating Procedure: sp_dm2_GetLegalHoldItemsWithGrouping'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetLegalHoldItemsWithGrouping
  @i_xml XML ,
  @o_resultItemsCount BIGINT OUTPUT,
  @o_groupingCount BIGINT OUTPUT,
  @o_localGroupingXml NVARCHAR(MAX) OUTPUT,
  @o_groupingXml NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
BEGIN
	--reset Output variables
	SELECT @o_groupingCount = 0, @o_resultItemsCount = 0,
			@o_localGroupingXml = '',@o_groupingXml = ''
	--local variables
	DECLARE @i_backupStatus VARCHAR(30),
			@i_ignoreResultItems BIT = 0,
			@i_ignoreGrouping BIT = 0,
			@i_containerId VARCHAR(36),
			@i_whereClause	NVARCHAR(MAX),
			@i_groupByclause VARCHAR(50),
			@i_orderByClause VARCHAR(50),
			@sqlCmd NVARCHAR(MAX) = '',
			@fetchEmail CHAR(1) = '1',
			@fetchFiles	CHAR(1)	= '1',
			@StartRN	INTEGER = 0,
			@pageCount	INTEGER = 0,
			@EndRN	INTEGER = -1,
			@i_debug	BIT = 0,
			@returnEmptyResultItemTable BIT = 1
	--parse the input XML to get required field only
	SELECT	@i_containerId = ISNULL(T.col.value('@containerId','VARCHAR(36)'),''),
			@i_ignoreResultItems = ISNULL(T.col.value('@ignoreResultItems','BIT'),0),
			@i_ignoreGrouping = ISNULL(T.col.value('@ignoreGrouping','BIT'),0),
			@i_whereClause = ISNULL(T.col.value('@whereCondition','NVARCHAR(MAX)'),''),
			@i_backupStatus = ISNULL(T.col.value('@backupStatus','VARCHAR(30)'),''),
			@i_groupByclause = ISNULL(T.col.value('Grouping[1]/@groupByClause','VARCHAR(50)'),''),
			@i_debug = ISNULL(T.col.value('@debug','BIT'),0)
	FROM @i_xml.nodes('/GetItems')  T(col)
	--SET the backupstatus accordingly
                                                        SELECT @i_backupStatus = CASE WHEN @i_backupStatus = 'SUCCESS' THEN
									' LH.BackupStatus = 1 '
								WHEN @i_backupStatus in( 'FAILURE','FAILED') THEN
									' LH.BackupStatus <> 1 '
								ELSE
									''
							END
	-------++++++++++Case when GResultItems will be returned++++++++-------
	IF(@i_ignoreResultItems = 0)
	BEGIN
		--get the apptype filter and other info
		SELECT	@fetchEmail= ISNULL(T.col.value('ResultItems[1]/@fetchEmails','VARCHAR(1)'),'1'),
				@fetchFiles= ISNULL(T.col.value('ResultItems[1]/@fetchFiles','VARCHAR(1)'),'1'),
				@StartRN = 	ISNULL(T.col.value('ResultItems[1]/@startIndex','INTEGER'),0),
				@pageCount = ISNULL(T.col.value('ResultItems[1]/@pageSize','INTEGER'),0),
				@i_orderByClause = CASE LEN(ISNULL(T.col.value('ResultItems[1]/@orderByClause','VARCHAR(50)'),''))
										WHEN 0 THEN 'ModifiedTime DESC'
										ELSE T.col.value('ResultItems[1]/@orderByClause','VARCHAR(50)')
									END
		FROM @i_xml.nodes('/GetItems')  T(col)
		IF object_id('tempdb.dbo.#tblGetAllContainerItem') is not null
			DROP TABLE #tblGetAllContainerItem
		CREATE TABLE #tblGetAllContainerItem
		(
			[JobID] 		[int],
			[CompPolicyID] 	[char](36) 	,
			[ContainerID] 	[char](36) 	,
			[ResultSetID] 	[char](36) 	,
			[CommCellID] 	[int] 	,
			[BackupStatus]	[int],
			[AppType] 		[int] 		,
			[OwnerField]	[nvarchar](max) ,
			[FromField]		[nvarchar](max) ,
			[FolderPath]	[nvarchar](max) ,
			[RowNumber]		[BIGINT]
		)
		SET @sqlCmd = '	INSERT INTO #tblGetAllContainerItem
						SELECT DISTINCT LH.JobId,LH.CompPolicyId,
									LH.ContainerID,LH.ResultSetID,LH.CommCellId,LH.BackupStatus,LH.AppType,
									ISNULL(LH.OwnerField,'''') AS "OwnerField",
									ISNULL(LH.FromField,'''') AS "FromField",ISNULL(LH.FolderPath,'''')AS "FolderPath",
									ROW_NUMBER() OVER (order by LH.' + @i_OrderByClause + ') as RowNumber
						FROM DMLegalHoldItemsToBackup AS LH
						WHERE ISNULL(LH.ResultSetID, '''') <> '''' AND LH.CompPolicyId = '''+@i_containerId +''''
		IF @fetchEmail = 0 OR @fetchFiles = 0
			SET @sqlCmd = @sqlCmd + ' AND LH.AppType IN (SELECT AT.AppTypeId
							FROM DMUIAppTypeMap AS AT
							WHERE AT.IsEmailAppType = '+ @fetchEmail +
							' OR AT.IsFileAppType = '+  @fetchFiles +')'
		IF(LEN(ISNULL(@i_backupStatus,''))>0)
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_backupStatus
		IF(LEN(ISNULL(@i_whereClause,''))>0)
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_whereClause
		--SET @sqlCmd = @sqlCmd + ' ORDER BY ' + @i_orderByClause
		IF(@i_debug = 1)
			SELECT @sqlCmd 'ResultItemSQLCMD'
		EXECUTE(@sqlCmd);
		SELECT @o_resultItemsCount = COUNT(CompPolicyId) FROM #tblGetAllContainerItem
		IF(@o_resultItemsCount > 0)
		BEGIN
			--Paging config
			SELECT @StartRN = CASE WHEN @StartRN <= 0 THEN 1
									ELSE @StartRN
								END,
					@pageCount = CASE WHEN @pageCount < 0 THEN 0
									ELSE @pageCount
								END,
					@EndRN = CASE WHEN @pageCount <= 0 THEN @o_resultItemsCount
									ELSE (@pageCount+ @StartRN -1)
								END
			IF object_id('tempdb.dbo.#tempGetPageItems') is not null
				DROP TABLE #tempGetPageItems
		CREATE TABLE #tempGetPageItems
		(
			[JobID] 		[int],
			[CompPolicyID] 	[char](36) 	,
			[ContainerID] 	[char](36) 	,
			[ResultSetID] 	[char](36) 	,
			[CommCellID] 	[int] 	,
			[BackupStatus]	[int],
			[AppType] 		[int],
			[OwnerField]	[nvarchar](max) ,
			[FromField]		[nvarchar](max) ,
			[FolderPath]	[nvarchar](max) ,
			[RowNumber]		[BIGINT]
		)
			--Insert into temp table so that grouping can  be done
			insert INTO #tempGetPageItems
			select * FROM #tblGetAllContainerItem AS T
			WHERE T.RowNumber  BETWEEN @StartRN AND @EndRN
			ORDER BY T.RowNumber
			SELECT R.JobID, R.CommCellID, R.CompPolicyID, R.ContainerID, R.ResultSetID,
			L.OriginalPath, L.BackupPath, L.MetaDataXML, L.BackupStatus, L.Attribute, L.AppType,
			L.FileSizeKB,  L.ModifiedTime, L.OriginalFullPath, L.ClientID, R.OwnerField,
			L.FromField, R.FolderPath, R.RowNumber
			FROM #tempGetPageItems R
			JOIN DMLegalHoldItemsToBackup L ON R.JobID = L.JobId AND
			R.CommCellID = L.CommCellId AND R.CompPolicyID = L.CompPolicyId AND R.ContainerID = L.ContainerID AND R.ResultSetID = L.ResultSetID
			AND R.BackupStatus = L.BackupStatus AND R.AppType = L.AppType
			ORDER BY R.RowNumber
			--reset empty table as false
			SET @returnEmptyResultItemTable = 0
			IF(LEN(@i_groupByclause) > 0)
			BEGIN
				IF object_id('tempdb.dbo.#localTmpTbl') is not null
					DROP TABLE #localTmpTbl
				CREATE TABLE #localTmpTbl
					( value NVARCHAR(MAX),
						 countVal BIGINT )
				SET @sqlCmd = 'INSERT INTO #localTmpTbl
					SELECT  CASE LEN(ISNULL(' + @i_groupByclause +',''''))
							WHEN 0 THEN ''N/A''
							ELSE '+ @i_groupByclause +'
							END AS "value",
							COUNT_BIG(*) AS "countVal"
						 FROM #tblGetAllContainerItem AS T'
				SET @sqlCmd  = @sqlCmd + ' WHERE ISNULL(' + @i_groupByclause +','''')
						  IN
					(SELECT DISTINCT ISNULL(' + @i_groupByclause +','''')
						 FROM #tempGetPageItems )'
				SET @sqlCmd = @sqlCmd + ' GROUP BY CASE LEN(ISNULL(' + @i_groupByclause +',''''))
						WHEN 0 THEN ''N/A''
						ELSE '+ @i_groupByclause +'
						END '
				IF(@i_debug = 1)
					SELECT @sqlCmd "LocalGroupingSQLCMD"
				EXECUTE(@sqlCmd)
				SET @o_localGroupingXml =
						(SELECT *
							FROM #localTmpTbl
							For XML RAW('Items'),ROOT('GetItems_Grouping'))
				DROP TABLE #localTmpTbl
			END
			DROP TABLE #tempGetPageItems
		END
		DROP TABLE #tblGetAllContainerItem
	END
	---------+++++++++++++If empty table has to be returned for ResultItems+++++++++++++-------------
	IF(@returnEmptyResultItemTable = 1)
	BEGIN
		SELECT LH.*
		FROM DMLegalHoldItemsToBackup AS LH WITH (READUNCOMMITTED)
		 WHERE 1= 2
	END
	---------++++++++++++Case when GroupingItems to be returned+++++++++++++++------------------
	IF(@i_ignoreGrouping = 0 AND LEN(@i_groupByclause) > 0)
	BEGIN
		--get the apptype filter and other info
		SELECT	@fetchEmail= ISNULL(T.col.value('Grouping[1]/@fetchEmails','VARCHAR(1)'),'1'),
				@fetchFiles= ISNULL(T.col.value('Grouping[1]/@fetchFiles','VARCHAR(1)'),'1'),
				@StartRN = 	ISNULL(T.col.value('Grouping[1]/@startIndex','INTEGER'),0),
				@pageCount = ISNULL(T.col.value('Grouping[1]/@pageSize','INTEGER'),0),
				@i_orderByClause = CASE LEN(ISNULL(T.col.value('Grouping[1]/@orderByClause','VARCHAR(50)'),''))
										WHEN 0 THEN 'countVal DESC'
										ELSE T.col.value('Grouping[1]/@orderByClause','VARCHAR(50)')
									END
		FROM @i_xml.nodes('/GetItems')  T(col)
		IF object_id('tempdb.dbo.#tblGetGroupingItem') is not null
			DROP TABLE #tblGetGroupingItem
		CREATE TABLE #tblGetGroupingItem (rowId INT IDENTITY(1,1), value NVARCHAR(MAX), countVal BIGINT)
		SET @sqlCmd = 'INSERT INTO #tblGetGroupingItem
					SELECT  CASE LEN(ISNULL(' + @i_groupByclause +',''''))
						WHEN 0 THEN ''N/A''
						ELSE '+ @i_groupByclause +'
						END AS "value",
						COUNT_BIG(*) AS "countVal"
					 FROM  DMLegalHoldItemsToBackup AS LH
						WHERE ISNULL(LH.ResultSetID, '''') <> '''' AND LH.CompPolicyId = '''+@i_containerId +''''
	IF @fetchEmail = 0 OR @fetchFiles = 0
			SET @sqlCmd = @sqlCmd + ' AND LH.AppType IN (SELECT AT.AppTypeId
							FROM DMUIAppTypeMap AS AT
							WHERE AT.IsEmailAppType = '+ @fetchEmail +
							' OR AT.IsFileAppType = '+  @fetchFiles +') '
		IF(LEN(ISNULL(@i_backupStatus,''))>0)
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_backupStatus
		IF(LEN(ISNULL(@i_whereClause,''))>0)
			SET @sqlCmd = @sqlCmd + ' AND ' + @i_whereClause
		--	set grouping Clause
		SET @sqlCmd = @sqlCmd + ' GROUP BY CASE LEN(ISNULL(' + @i_groupByclause +',''''))
						WHEN 0 THEN ''N/A''
						ELSE '+ @i_groupByclause +'
						END
						ORDER BY '+@i_orderByClause
		IF(@i_debug = 1)
			SELECT @sqlCmd
		EXECUTE (@sqlCmd)
		SELECT @o_groupingCount = MAX(T.rowId)
		FROM #tblGetGroupingItem AS T
		IF(@o_groupingCount > 0)
		BEGIN
			--Paging config
			SELECT @StartRN = CASE WHEN @StartRN <= 0 THEN 1
									ELSE @StartRN
								END,
					@pageCount = CASE WHEN @pageCount < 0 THEN 0
									ELSE @pageCount
								END,
					@EndRN = CASE WHEN @pageCount <= 0 THEN @o_groupingCount
									ELSE (@pageCount+ @StartRN -1)
								END
			SET @o_groupingXml =
					(SELECT T.value,T.countVal
			FROM #tblGetGroupingItem AS T
			WHERE T.rowId BETWEEN @StartRN AND @EndRN
			ORDER BY T.rowId
					FOR XML RAW('Items'),ROOT('GetItems_Grouping'))
		END
		DROP TABLE #tblGetGroupingItem
	END
	--If empty XML to be returned
	IF(LEN(ISNULL(@o_groupingXml,'')) = 0)
	BEGIN
		SET @o_groupingXml =
				(SELECT '<GetItems_Grouping />')
	END
	IF(LEN(ISNULL(@o_localGroupingXml,'')) = 0)
	BEGIN
		SET @o_localGroupingXml =
				(SELECT '<GetItems_Grouping />')
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetLegalHoldItemsWithGrouping')
	delete from GxQscripts where name = 'sp_dm2_GetLegalHoldItemsWithGrouping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetLegalHoldItemsWithGrouping')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetLegalHoldItemsWithGrouping'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetLegalHoldItemsWithGrouping',  '00010006000000000000', 'sp_dm2_GetLegalHoldItemsWithGrouping', '00010006000000000000')
GO

