

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetGroupingInfoOnDownloaId.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_GetGroupingInfoOnDownloaId()
--  | Description:  Get groupingInfo for the input downloadId, if any
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetGroupingInfoOnDownloaId.sp,v $ $Id: sp_dm2_GetGroupingInfoOnDownloaId.sp,v 1.2 2012/08/06 15:32:09 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetGroupingInfoOnDownloaId <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetGroupingInfoOnDownloaId')
	drop procedure sp_dm2_GetGroupingInfoOnDownloaId
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetGroupingInfoOnDownloaId')
	delete from GxQscripts where name = 'sp_dm2_GetGroupingInfoOnDownloaId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetGroupingInfoOnDownloaId')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetGroupingInfoOnDownloaId'
GO
print '... Creating Procedure: sp_dm2_GetGroupingInfoOnDownloaId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetGroupingInfoOnDownloaId
  @downloadId CHAR(36)
AS
	SET NOCOUNT ON
	/*
		Usage:
			This Sp takes input as downloadId and returns the Grouping Info(value and its count) associated with it..
			Attribute field is used to store the grouping field info..
				FolderPath --> POWER(2,14) [15th bit]
				OwnerField --> POWER(2,15) [16th bit]
	**/
	DECLARE @attribute INT = 0
	DECLARE @groupByClause VARCHAR(50) = ''
	DECLARE @sql VARCHAR(MAX) = ''
	SELECT @attribute = Attribute
	FROM DMDownload WHERE DownLoadID = @downloadId
	IF(@attribute & POWER(2,14) > 0)
		SET @groupByClause = 'FolderPath'
	ELSE IF(@attribute & POWER(2,15) > 0)
		SET @groupByClause = 'OwnerField'
	IF(LEN(ISNULL(@groupByClause,''))>0)
	BEGIN
		SET @sql= 'SELECT CASE LEN(ISNULL(' + @groupByClause +',''''))
								WHEN 0 THEN ''Not-Available''
								ELSE '+ @groupByClause +'
								END AS "value",
								COUNT_BIG(*) AS "countVal"
					 FROM DMResultSet AS RS WITH (NOLOCK) WHERE
					 RS.ResultSetID IN ( SELECT D.ResultSetID FROM DMDownloadResultSet AS D  WITH (NOLOCK)
											WHERE  D.DownLoadID = '''+@downloadId +''')
					 GROUP BY CASE LEN(ISNULL(' + @groupByClause +',''''))
								WHEN 0 THEN ''Not-Available''
								ELSE '+ @groupByClause +'
								END '
		EXECUTE (@sql)
	END
	ELSE
	BEGIN
		SELECT 	'' AS "value",0 AS "countVal" WHERE 1= 2
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetGroupingInfoOnDownloaId')
	delete from GxQscripts where name = 'sp_dm2_GetGroupingInfoOnDownloaId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetGroupingInfoOnDownloaId')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetGroupingInfoOnDownloaId'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetGroupingInfoOnDownloaId',  '00010002000000000000', 'sp_dm2_GetGroupingInfoOnDownloaId', '00010002000000000000')
GO

