

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadSetItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadSetItems.sp,v $ $Id: sp_dm2_GetDownloadSetItems.sp,v 1.4.12.2 2018/03/29 22:01:52 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDownloadSetItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadSetItems')
	drop procedure sp_dm2_GetDownloadSetItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadSetItems')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadSetItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadSetItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadSetItems'
GO
print '... Creating Procedure: sp_dm2_GetDownloadSetItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownloadSetItems
  @i_DownLoadID varchar(36) = '',
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_RestoreStatus int = -1,
  @i_OrderByClause nvarchar(max) = 'modifiedTime'
AS
  DECLARE @StartRN integer
  DECLARE @EndRN integer
  DECLARE @sqlCmd nvarchar(max)
SET NOCOUNT ON
  IF (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
  BEGIN
		SET @StartRN = 1
		SET @EndRN = -1
  END
  ELSE
  BEGIN
		SET @StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
		SET @EndRN = @i_NumPages * @i_ItemsOnPage + @StartRN - 1
  END
	IF object_id('tempdb.dbo.#tblGetAllDownLoadItem') is not null
	DROP TABLE #tblGetAllDownLoadItem
	IF object_id('tempdb.dbo.#tblGetDownLoadItem') is not null
	DROP TABLE #tblGetDownLoadItem
  create table #tblGetAllDownLoadItem (rowId INT IDENTITY(1,1), ResultSetID VARCHAR(36))
  create table #tblGetDownLoadItem (rowId INT, ResultSetID VARCHAR(36))
	IF(@i_RestoreStatus <> -1)
	BEGIN
		SET @sqlCmd = 'insert into #tblGetAllDownLoadItem '
		SET @sqlCmd = @sqlCmd + 'select a.ResultSetID '
		SET @sqlCmd = @sqlCmd + 'FROM DMDownloadResultSet a WITH (READUNCOMMITTED), '
		SET @sqlCmd = @sqlCmd + 'DMResultSet c WITH (READUNCOMMITTED) '
		SET @sqlCmd = @sqlCmd + 'where a.DownloadID = ''' + @i_DownLoadID + ''' '
		SET @sqlCmd = @sqlCmd + 'and a.ResultSetID = c.ResultSetID '
		SET @sqlCmd = @sqlCmd + 'and c.RestoreStatus = ' + @i_RestoreStatus
		SET @sqlCmd = @sqlCmd + 'order by c.' + @i_OrderByClause
	END
	ELSE
	BEGIN
		SET @sqlCmd = 'insert into #tblGetAllDownLoadItem '
		SET @sqlCmd = @sqlCmd + 'select a.ResultSetID '
		SET @sqlCmd = @sqlCmd + 'FROM DMDownloadResultSet a WITH (READUNCOMMITTED), '
		SET @sqlCmd = @sqlCmd + 'DMResultSet c WITH (READUNCOMMITTED) '
		SET @sqlCmd = @sqlCmd + 'where a.DownloadID = ''' + @i_DownLoadID + ''' '
		SET @sqlCmd = @sqlCmd + 'and a.ResultSetID = c.ResultSetID '
		SET @sqlCmd = @sqlCmd + 'order by c.' + @i_OrderByClause
	END
	--
	exec sp_executesql @sqlCmd
	--
	if @EndRN < 0 	select @EndRN = count(*) from #tblGetAllDownLoadItem
	--
	INSERT INTO #tblGetDownLoadItem
	SELECT rowId, ResultSetID
	FROM #tblGetAllDownLoadItem
	WHERE rowId BETWEEN @StartRN AND @EndRN
	--
	SELECT RS.documentID as documentID, RS.aFileID, RS.AppType, RS.aFileOffset, RS.CommCellNumber, RS.IndexGUID, DRS.FileName,
	DRS.ContentHash, DRS.ID, DRS.ManifestPath, RS.OriginalFullPath, RS.FolderPath, RS.OwnerField, RS.ResultSetID, RS.Title,
	RS.FileSizeKB, dbo.GetUnixTime(RS.ModifiedTime) ModifiedTime,
	E.EmailFROM, E.EmailTO, E.EmailCC, E.EmailBCC
	FROM #tblGetDownLoadItem as t
	INNER JOIN DMResultSet AS RS WITH (READUNCOMMITTED) ON t.ResultSetID = RS.ResultSetID
	INNER JOIN DMDownloadResultSet AS DRS WITH (READUNCOMMITTED) ON t.ResultSetID = DRS.ResultSetID
	LEFT JOIN DMEmailResult AS E WITH(READUNCOMMITTED) ON t.ResultSetID = E.ResultSetID
	WHERE DRS.DownloadID = @i_DownLoadID
	ORDER BY t.rowId
	--
	DROP TABLE #tblGetAllDownLoadItem
    DROP TABLE #tblGetDownLoadItem
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadSetItems')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadSetItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadSetItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadSetItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadSetItems',  '00010004001200020000', 'sp_dm2_GetDownloadSetItems', '00010004001200020000')
GO

