

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadResultSet.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadResultSet.sp,v $ $Id: sp_dm2_GetDownloadResultSet.sp,v 1.6.66.4 2019/11/29 00:51:23 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadResultSet')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_GetDownloadResultSet <<<'
	drop procedure sp_dm2_GetDownloadResultSet
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadResultSet'
GO
print '... Creating Procedure: sp_dm2_GetDownloadResultSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownloadResultSet
  @i_UserGUID varchar(36) = '',
  @i_DownLoadID varchar(36) = '',
  @i_ContainerID varchar(36) = '',
  @i_RestoreJobID int = 0,
  @i_Attribute int = -1,
  @i_offset int = 0,
  @i_limit int = 10000,
  @i_IgnoreStatus bit = 0,
  @i_returnHierarchyInfo int = 0
AS
  DECLARE @o_DownLoadID char(36);
  DECLARE @o_ResultSetID char(36);
  DECLARE @o_AppType integer;
  DECLARE @o_Status integer;
  DECLARE @o_CreateTime datetime;
  DECLARE @o_DestinationPath nvarchar(max);
SET NOCOUNT ON
if len(@i_DownLoadID) = 0
begin
	select a.DownloadID,a.ResultSetID,a.AppType,a.Status,a.CreateTime,a.FileName, a.[FileName] as DestinationPath
	from DMDownloadResultSet a WITH (READUNCOMMITTED), DMResultSet b WITH (READUNCOMMITTED)
	where a.DownloadID in (
		select DownloadID from DMDownload WITH (READUNCOMMITTED)
		where (len(@i_UserGUID) = 0 or UserGUID = @i_UserGUID)
		and (len(@i_ContainerID) = 0 or ContainerID = @i_ContainerID)
		and (len(@i_Attribute) < 0 or (Attribute & @i_Attribute) = @i_Attribute)
		and (@i_RestoreJobID = 0 or RestoreJobID = @i_RestoreJobID)
	)
end
else
begin
	--TODO:we need to impelment paging here
	IF @i_limit <= 0
    BEGIN
        SET @i_limit = 10000
    END
    if ( @i_returnHierarchyInfo = 0 )
    BEGIN
	select DownloadID,ResultSetID,AppType,Status,CreateTime,FileName, DestinationPath,'' as OwnerField, '' as FolderPath  FROM
	(
		select a.DownloadID,a.ResultSetID,a.AppType,a.Status,a.CreateTime,a.FileName, a.[FileName] as DestinationPath, ROW_NUMBER() OVER (ORDER BY CreateTime, a.ID) AS ROWNUM
		from DMDownloadResultSet a WITH (READUNCOMMITTED)
		where a.DownloadID = @i_DownloadID AND (@i_IgnoreStatus=1 OR a.Status = 100)
	)TEMP
    WHERE TEMP.ROWNUM > @i_offset AND TEMP.ROWNUM <= @i_offset + @i_limit
    ORDER BY ROWNUM
    END
    ELSE
    BEGIN
	select DownloadID,ResultSetID,AppType,Status,CreateTime,FileName, DestinationPath, OwnerField, FolderPath FROM
	(
		select a.DownloadID,a.ResultSetID,a.AppType,a.Status,a.CreateTime,a.FileName,
		a.[FileName] as DestinationPath, R.OwnerField, R.FolderPath, ROW_NUMBER()
		OVER (ORDER BY a.CreateTime, a.ID) AS ROWNUM
		from DMDownloadResultSet a WITH (READUNCOMMITTED)
		INNER JOIN DMResultSet R WITH (READUNCOMMITTED)
 ON R.ResultSetID = a.ResultSetID
					where a.DownloadID = @i_DownloadID AND (@i_IgnoreStatus=1 OR a.Status = 100)
			)TEMP
	WHERE TEMP.ROWNUM > @i_offset AND TEMP.ROWNUM <= @i_offset + @i_limit
	ORDER BY ROWNUM
    END
end
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadResultSet')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadResultSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadResultSet')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadResultSet'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadResultSet',  '00010006006600040000', 'sp_dm2_GetDownloadResultSet', '00010006006600040000')
GO

