

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadItems.sp,v $ $Id: sp_dm2_GetDownloadItems.sp,v 1.4.198.8 2020/06/26 03:42:12 sjanakiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadItems')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_GetDownloadItems <<<'
	drop procedure sp_dm2_GetDownloadItems
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadItems')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadItems'
GO
print '... Creating Procedure: sp_dm2_GetDownloadItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDownloadItems
  @i_DownLoadSetID varchar(36) = '',
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_RestoreStatus int = -1,
  @i_OrderByClause nvarchar(max) = 'Description',
  @i_downloadNamesFilter nvarchar(max)= '',
  @i_exactMatch int = 0
AS
  DECLARE @StartRN integer
  DECLARE @EndRN integer
  DECLARE @sqlCmd nvarchar(max)
SET NOCOUNT ON
  IF (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
  BEGIN
		SET @StartRN = 1
		SET @EndRN = -1
  END
  ELSE
  BEGIN
		SET @StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
		SET @EndRN = @i_NumPages * @i_ItemsOnPage + @StartRN - 1
  END
	IF object_id('tempdb.dbo.#tblGetDownLoadsItem') is not null
	DROP TABLE #tblGetDownLoadsItem
  create table #tblGetDownLoadsItem (rowId INT, DownLoadID VARCHAR(36), TotalItemCount int, RestoredItemCount int, retentionDays int)
	IF object_id('tempdb.dbo.#tblGetAllDownLoadsItem') is not null
	DROP TABLE #tblGetAllDownLoadsItem
	create table #tblGetAllDownLoadsItem (rowId INT IDENTITY(1,1), DownLoadID VARCHAR(36))
	declare @SQLParamDef nvarchar(2000) = '@downLoadSetID nvarchar(36)'
	SET @sqlCmd = 'insert into #tblGetAllDownLoadsItem '
	SET @sqlCmd = @sqlCmd + 'select DownLoadID from DMDownload WITH (READUNCOMMITTED) '
	if ( ISNULL(@i_downloadNamesFilter,'') <> '')
	BEGIN
	IF object_id('tempdb.dbo.#tblFilterDownload') is not null
		DROP TABLE #tblFilterDownload
	 create table #tblFilterDownload (Id INT IDENTITY(1,1), Data nvarchar(max))
		INSERT INTO #tblFilterDownload SELECT Data FROM dbo.split(@i_downloadNamesFilter,'|')
		IF ( @i_exactMatch = 0 )
			update #tblFilterDownload set  Data='%'+Data+'%'
		SET @sqlCmd = @sqlCmd + 'INNER JOIN #tblFilterDownload ON Description like Data '
	END
	SET @sqlCmd = @sqlCmd + 'where (LEN(@downLoadSetID) = 0 or DownLoadSetID = @downLoadSetID)'
	SET @sqlCmd = @sqlCmd + ' AND FileType IN (1,2,6,13,14,15,16,18) ' -- HTMLPreview = 6, CVReviewSetExport = 13, RestoreToWebServer = 14, CustomLocationPST = 15, SharepointToCustomLocation = 16, PDF=18
	SET @sqlCmd = @sqlCmd + 'order by ' + @i_OrderByClause
	exec sp_executesql @sqlCmd, @SQLParamDef, @i_DownLoadSetID
	if @EndRN < 0 	select @EndRN = count(*) from #tblGetAllDownLoadsItem
	--select * from #tblGetAllDownLoadsItem
	INSERT INTO #tblGetDownLoadsItem(rowId, DownLoadID)
	SELECT rowId, DownLoadID
	FROM #tblGetAllDownLoadsItem
	WHERE rowId BETWEEN @StartRN AND @EndRN
	--select * from #tblGetDownLoadsItem
	UPDATE #tblGetDownLoadsItem
	SET TotalItemCount = ISNULL((SELECT COUNT(ResultSetId) FROM DMDownloadResultSet RS WITH (READUNCOMMITTED) WHERE RS.DownloadId = #tblGetDownLoadsItem.DownloadID), 0),
	RestoredItemCount = ISNULL((SELECT COUNT(ResultSetId) FROM DMDownloadResultSet RS WITH (READUNCOMMITTED) WHERE RS.DownloadId = #tblGetDownLoadsItem.DownloadID AND RS.Status = 100), 0),
	retentionDays = ISNULL((SELECT OptionValue FROM DMDownloadOption DO WITH (READUNCOMMITTED) WHERE DO.DownloadId = #tblGetDownLoadsItem.DownloadID AND DO.OptionId=2), -1)
	SELECT DL.*, t.TotalItemCount, t.RestoredItemCount, ISNULL(DJ.Results, '') Results,t.retentionDays
	FROM #tblGetDownLoadsItem as t
	JOIN DMDownload AS DL WITH (READUNCOMMITTED) on t.DownLoadID = DL.DownLoadID
	LEFT JOIN DMJOB AS DJ WITH (READUNCOMMITTED) on dl.DownLoadID = dj.JobID
	ORDER BY t.rowId
	IF object_id('tempdb.dbo.#tblGetAllDownLoadsItem') is not null
		DROP TABLE #tblGetAllDownLoadsItem
	IF object_id('tempdb.dbo.#tblGetDownLoadsItem') is not null
		DROP TABLE #tblGetDownLoadsItem
	IF object_id('tempdb.dbo.#tblFilterDownload') is not null
		DROP TABLE #tblFilterDownload
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadItems')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadItems',  '00010004019800080000', 'sp_dm2_GetDownloadItems', '00010004019800080000')
GO

