

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadIdsToPrune.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDownloadIdsToPrune.sp,v $ $Id: sp_dm2_GetDownloadIdsToPrune.sp,v 1.1.2.1 2020/06/26 03:41:45 sjanakiraman Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDownloadIdsToPrune')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_GetDownloadIdsToPrune <<<'
	drop procedure sp_dm2_GetDownloadIdsToPrune
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDownloadIdsToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadIdsToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadIdsToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadIdsToPrune'
GO
print '... Creating Procedure: sp_dm2_GetDownloadIdsToPrune'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sp_dm2_GetDownloadIdsToPrune
AS
SET NOCOUNT ON
BEGIN
	IF OBJECT_ID('tempdb.dbo.#tblDownloadsToPrune') IS NOT NULL
		DROP TABLE #tblDownloadsToPrune
	CREATE TABLE #tblDownloadsToPrune
	(
  		downloadId 			CHAR(36),
	)
	CREATE INDEX Idx_tblDownloadIsToPrune_downloadId on #tblDownloadsToPrune(downloadId)
	--insert all download ids where retention is set explicitly during creation
	INSERT INTO #tblDownloadsToPrune
	SELECT D.DownloadID from DMDownload D
	INNER JOIN DMDownloadOption DO ON D.DownLoadID = DO.DownloadId AND DO.OptionId = 2 --DM2ContentIndexingMsg_DownloadOptionId.DOWNLOAD_RETENTION_IN_DAYS
	WHERE DO.OptionValue > 0 AND DATEDIFF(DD,D.CreateTime,GETUTCDATE()) > CONVERT(INT,DO.OptionValue)
	--If retention option is not set explicitly, insert downloadIds other than PST, CAB, PDF based on DMSetting( default value: 7)
	INSERT INTO #tblDownloadsToPrune
	SELECT DownloadID FROM DMDownload
	WHERE  FileType NOT IN (1,2,18) --these types will have infinite retention if explicit option not set during download creation
	AND DATEDIFF(DD,CreateTime,GETUTCDATE()) > ISNULL((SELECT CONVERT(INT,S.SettingValue) FROM DMSetting AS S WHERE S.SettingName = 'PRUNE_TIME_IN_DMDOWNLOAD_IN_DAYS'),7)
	AND	DownLoadID NOT in ( select downloadId from #tblDownloadsToPrune)
	SELECT downloadId from #tblDownloadsToPrune
	IF OBJECT_ID('tempdb.dbo.#tblDownloadsToPrune') IS NOT NULL
		DROP TABLE #tblDownloadsToPrune
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDownloadIdsToPrune')
	delete from GxQscripts where name = 'sp_dm2_GetDownloadIdsToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDownloadIdsToPrune')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDownloadIdsToPrune'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDownloadIdsToPrune',  '00010001000200010000', 'sp_dm2_GetDownloadIdsToPrune', '00010001000200010000')
GO

