

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetDMJob.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetDMJob.sp,v $ $Id: sp_dm2_GetDMJob.sp,v 1.3 2008/04/08 05:52:25 hkapadia Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetDMJob <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetDMJob')
	drop procedure sp_dm2_GetDMJob
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetDMJob')
	delete from GxQscripts where name = 'sp_dm2_GetDMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMJob'
GO
print '... Creating Procedure: sp_dm2_GetDMJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetDMJob
  @i_StartPageNumber int = 0,
  @i_ItemsOnPage int = 0,
  @i_NumPages int = 0,
  @i_JobID varchar(36) = '',
  @i_SessionID varchar(24) = '',
  @i_UserGUID varchar(36) = '',
  @i_ContainerID varchar(36) = '',
  @i_ResultSetID varchar(36) = '',
  @i_Progress int = 0,
  @i_StartTime varchar(50) = '',
  @i_EndTime varchar(50) = '',
  @i_Attribute int = 0
AS
  DECLARE @o_JobID char(36);
  DECLARE @o_JobType int;
  DECLARE @o_JobState int;
  DECLARE @o_SessionID varchar(50);
  DECLARE @o_UserGUID varchar(36);
  DECLARE @o_ContainerID varchar(36);
  DECLARE @o_ResultSetID varchar(36);
  DECLARE @o_Arguments nvarchar(max);
  DECLARE @o_Progress int;
  DECLARE @o_PendingReason nvarchar(max);
  DECLARE @o_Results nvarchar(max);
  DECLARE @o_StartTime datetime;
  DECLARE @o_EndTime datetime;
  DECLARE @o_Attribute int;
SET NOCOUNT ON
  if len(@i_ResultSetID) > 0
  begin
    select top 1 * from DMJob WITH (READUNCOMMITTED)
	where ResultSetID = @i_ResultSetID
	and JobState in (2, 3)
	order by JobState, StartTime desc
	goto done
  end
  if len(@i_ContainerID) > 0
  begin
    select top 1 * from DMJob WITH (READUNCOMMITTED)
	where ContainerID = @i_ContainerID
	and JobState in (2, 3)
	order by JobState, StartTime desc
	goto done
  end
  if len(@i_JobID) > 0
  begin
    select top 1 * from DMJob WITH (READUNCOMMITTED)
	where JobID = @i_JobID
	and JobState in (2, 3)
	order by JobState, StartTime desc
	goto done
  end
  declare @i_StartRN int
  declare @i_EndRN int
  if (@i_StartPageNumber + @i_ItemsOnPage + @i_NumPages) <= 0
  begin
	set @i_StartRN = 1
	set @i_EndRN = (select count(JobID)
				  from DMJob WITH (READUNCOMMITTED)
				  where (len(@i_SessionID) = 0 or SessionID = @i_SessionID)
				  and (len(@i_UserGUID) = 0 or UserGUID = @i_UserGUID)
				  and (@i_Progress = 0 or Progress = @i_Progress)
				  and (@i_Attribute = 0 or (Attribute & @i_Attribute) = @i_Attribute)
				  and (@i_StartTime = null or StartTime >= @i_StartTime)
				  and (@i_EndTime = null or EndTime <= @i_EndTime))
  end
  else
  begin
	set @i_StartRN = (@i_StartPageNumber - 1) * @i_ItemsOnPage + 1
	set @i_EndRN = @i_NumPages * @i_ItemsOnPage + @i_StartRN - 1
  end
	exec ('WITH [dm2_GetDMJob] AS
	(SELECT J.*, ROW_NUMBER() OVER (order by StartTime) as RowNumber
	FROM DMJob AS J WITH (READUNCOMMITTED)
	  where (len(''' + @i_SessionID + ''') = 0 or SessionID = ''' + @i_SessionID + ''')
	  and (len(''' + @i_UserGUID + ''') = 0 or UserGUID = ''' + @i_UserGUID + ''')
	  and (len(''' + @i_StartTime + ''') = 0 or datediff(d, StartTime, cast(''' + @i_StartTime + ''' as datetime)) >= 0)
	  and (len(''' + @i_EndTime + ''') = 0 or datediff(d, cast(''' + @i_EndTime + ''' as datetime), EndTime) >= 0)
	  and (' + @i_Progress + ' = 0 or Progress = ' + @i_Progress + ')
	  and (' + @i_Attribute + ' = 0 or (Attribute & ' + @i_Attribute + ') = ' + @i_Attribute + '))
	SELECT *
	FROM [dm2_GetDMJob]
	WHERE RowNumber between ' + @i_StartRN + ' and ' + @i_EndRN)
done:
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetDMJob')
	delete from GxQscripts where name = 'sp_dm2_GetDMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetDMJob')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetDMJob'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetDMJob',  '00010003000000000000', 'sp_dm2_GetDMJob', '00010003000000000000')
GO

